CREATE TABLE `hoao_exam` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `level` text NOT NULL,
  `quest` text NOT NULL,
  `op1` text NOT NULL,
  `op2` text NOT NULL,
  `op3` text NOT NULL,
  `op4` text NOT NULL,
  `answer` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;

CREATE TABLE `hoao_exam_select` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level1` int(11) NOT NULL,
  `level2` int(11) NOT NULL,
  `level3` int(11) NOT NULL,
  `level4` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;

CREATE TABLE `hoao_exam_score_board` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_name` text NOT NULL,
  `correct` int(10) unsigned NOT NULL,
  `incorrect` int(10) unsigned NOT NULL,
  `serial_num` int(10) unsigned NOT NULL,
  `wrong_quest` text NOT NULL,
  `test_date` datetime NOT NULL COMMENT '發布時間',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM;


INSERT INTO `hoao_exam` (`id`, `level`, `quest`, `op1`, `op2`, `op3`, `op4`, `answer`) VALUES
(1, '高級', '下列哪一物種為臺灣海洋魚類的外來入侵種？', '臺灣櫻花鉤吻鮭',  '紅鼓魚',  '高身?魚', '石斑魚',  2),
(2, '高級', '下列何者「不是」環境標誌的用途？', '促使區域環境品質標準提升', '喚醒民眾對環境議題的覺知', '幫助消費者確認產品退換通路',  '可塑造企業關心環境及消費者的形象', 3),
(3, '初級', '若發現有人任意傾倒廢棄物或廢液污染河川情事，該如何處理？', '當作沒看見並儘速離開現場', '把自家廢棄物一起倒入河川', '向當地環保單位檢舉',  '打110報警', 3),
(4, '中級', '以下有關電磁波敘述何者正確?', '手機本身會發射電磁波。',  '手機只接收基地臺的訊號，所以不會發射電磁波。', '家中的無線電話不會發射電磁波', '紅外線不是電磁波', 1),
(5, '高級', '下列何者「不是」綠色消費的效益？', '增加自然資源的無限開採與使用', '提升資源的永續利用',  '減少有害物質的使用',  '減少污染物的產生與排放',  1),
(6, '初級', '以下何者是避免過度砍伐樹木的方法？',  '大量使用免洗筷',  '回收有毒廢棄物',  '提升砍伐技術', '有規劃地分區砍伐', 4),
(7, '中高級',  '近年來，臺灣的土石流災害日益頻繁，下列哪個人類活動最可能加劇土石流的災害？',  '山地開發農場', '河谷興建防砂壩',  '山區廣植植被', '平原農田轉種檳榔', 1),
(8, '中高級',  '企業若參加自願性減碳市場有什麼好處？', '自願減碳額度，其額度可作為碳抵換', '販售給有需求的組織',  '提升企業形象', '以上皆是', 4),
(9, '高級', '臺灣永續發展中所遵循的重點項目「善盡國際社會一份子，參與國際環保策略」為下列何種原則？',  '國際人道救援原則', '國際參與與公眾參與原則',  '國際公平交易原則', '國際安全衛生原則', 2),
(10,  '高級', '下列哪一位人士致力於研究並記錄瀕臨絕種的黑猩猩，使他成為倍受推崇的保育人士？', '印地安酋長西雅圖', '珍古德',  '瑞秋卡森', '約克米勒', 2),
(11,  '高級', '為有效提升河川水質，削減排入河川的污染量，可行的改善技術為下列何者？(A)建置人工溼地(B)提升畜牧業生產量(C)建置礫間接觸系統(D)增設曝氣設施', 'ABC',  'BCD',  'ABCD', 'ACD',  4),
(12,  '初級', '以下哪一項是有效提升家裡用電效率的作法？', '吹冷氣時，打開部分窗戶通風',  '將電流與電壓間偏離的相角調回零',  '把客廳的燈全部開光來閱讀', '將剛洗好的衣服，趕快直接進行烘衣程序', 2),
(13,  '高級', '檢測環境中物質時，常需要使用到很多儀器，下列何者是?測儀器主要要求的特性？',  '靈活度',  '廣泛度',  '精密度',  '耐久度',  3),
(14,  '中高級',  '市區環境中以種植植物綠化為主，藉以達到改善空氣品質，提升生活環境品質等目的區域常稱之為什麼？', '空氣污染緩衝區',  '空氣品質淨化區',  '空氣污染防制區',  '空氣品質管制區',  2),
(15,  '高級', '污染物濃度在人體代謝仍未受影響情況下之最高值，則此值稱為恕限值，下?有關恕限值之敘述，何者正確？', '可適用於加班的?況',  '工作???低於恕限值，並?能完全排除職業病發生之可能性',  '可用於作為一般生活環境之標準', '可作為毒性與危害性\n之相對指標\n', 2),
(16,  '中高級',  '基地臺電磁波常用的單位為何？', '毫高斯(mG)',  '微特士拉(μT)', '微米(μm)', '毫瓦特/平方公分(mw/cm2)', 4),
(17,  '高級', '為提升空氣品質，目前車用柴油的硫含量標準為何？',  '10ppmw', '20pppmw',  '30pppmw',  '40pppmw',  1),
(18,  '中級', '由於臭豆腐太臭，而遭到民眾檢舉，此類型環境問題屬於下列哪一種公害？',  '空氣污染', '水質污染', '土壤污染', '噪音污染', 1),
(19,  '高級', '2010年上海世博會，30萬名志工身穿採用綠能纖維的制服，試問此布料具有什麼特性，下列何者「錯誤」？', '具涼感可節省電費、減少排碳量', '綠色纖維產品可以不需作回收',  '纖維原料不需依賴傳統石化原料', '能產生澱粉的作物可做為纖維',  2),
(20,  '初級', '河川裡面的養分忽然變多，對原來生活在河裡的水生植物可能出現什麼衝擊？', '養分越多越好，植物能長得更快', '其他水生動物會跑來搶食物', '影響水生植物正常成長', '增加水生植物的種類',  3),
(21,  '初級', '下列何者會使地下水受到污染？', '車子排放廢氣', '水中的動植物數量太多', '冷氣機滴水',  '過度使用農藥', 4),
(22,  '初級', '若有毒物質進入地下水，對生物有什麼影響？', '因為是地下水，所以不會影響到地面上的生物', '水中動植物可能會生病', '增加生物的免疫力', '可以提高作物品質', 2),
(23,  '初級', '下列何種行為會使土壤受到污染？',  '不當使用農藥及殺蟲劑', '小孩子到海邊堆沙堡',  '倒洗菜的水到土裡', '在土裡養蚯蚓', 1),
(24,  '初級', '下列何者是土壤受到污染時會直接產生的問題？',  '影響食物的安全',  '影響房屋的穩固性', '影響開車的安全',  '影響古跡的保存',  1),
(25,  '初級', '土壤受到嚴重污染對生物會產生什麼影響？',  '生物種類增加', '增加生物的活動能力',  '會使植物生病或死亡',  '只會使生存在土壤的生物死亡',  3),
(26,  '初級', '寢室音量最好在多少分貝以下，睡眠品質比較好？', '40分貝', '70分貝', '80分貝', '90分貝', 1),
(27,  '初級', '下列何者是全球溫度上升對環境所造成的影響？',  '陸地面積增加', '降低國民的購買能力',  '海平面上升',  '颱風變少', 3),
(28,  '初級', '森林大火會造成什麼影響？', '造成空氣污染', '只會對動物有影響', '只會對植物有影響', '造成輻射污染', 1),
(29,  '初級', '下列何者是環境自燃造成森林大火的原因？',  '高溫及太乾燥所產生的大火', '為了土地開發所產生的大火', '因為人類在森林留下火種導致大火',  '飛機墜落引發火災', 1),
(30,  '初級', '導致森林發生火災的人為因素為何？', '火山爆發', '天氣乾燥，加上長時間沒下雨',  '雷電打到森林', '未滅的灰燼造成火燒森林',  4),
(31,  '初級', '建造水庫會對河川生態環境產生什麼影響？',  '棲息於河川的生物，生活空間變大',  '生物棲息地改變，不利原來生物生存', '食物會變得比較多', '生物的種類會增加', 2),
(32,  '初級', '下列何種人類行為導致臺灣許多動、植物的死亡？', '設立禁獵區',  '種植樹木', '任意引進外來物種', '設立國家公園', 3),
(33,  '初級', '下列何者是開採砂石時沒做好水土保持所造成的影響？', '土石流',  '熱島效應', '空氣污染', '全球暖化', 1),
(34,  '初級', '水土保持沒有做好，會發生下列何種事情？',  '', '', '保水力增加',  '土石流',  0),
(35,  '初級', '下列哪一種行為容易造成山坡地水土流失？',  '多種樹木', '成立森林保護區',  '在山坡地興建遊樂園',  '以符合生態的施工方法復育山坡地',  3),
(36,  '初級', '現在海洋環境跟以前的海洋環境有什麼「不一樣」？',  '魚的種類變少', '海平面下降',  '魚類數量越來越多', '魚的種類變多', 1),
(37,  '初級', '海洋受到污染對於以海為家的動物造成什麼影響？', '獲取更多的食物',  '減少生病的頻率',  '棲息地受破壞', '增加繁殖能力', 3),
(38,  '初級', '下列何者是較不會破壞生態平衡的捕魚方法？', '用有刺的網子', '用只能捕捉成熟大魚的網子', '用電電魚', '用毒藥',  2),
(39,  '初級', '下列哪一個是地下水對臺灣民眾的貢獻？', '提供能源', '增加土壤肥沃度',  '減少污染', '提供農業灌溉用水', 4),
(40,  '初級', '下列哪一種交通工具產生的空氣污染物最多？', '新的小車子',  '電動車',  '舊的大車子',  '腳踏車',  3),
(41,  '初級', '下列哪一種車輛產生的空氣污染比較多？', '滑板車',  '汽車', '腳踏車',  '電動機車', 2),
(42,  '中級', '下列何者是酸雨帶來的危害？',  '全球暖化', '輻射污染', '礦產消失', '土壤酸化', 4),
(43,  '中級', '臭氧層稀薄對人類有什麼影響？', '農產品產量增加',  '下雨日子增加', '免疫系統降低', '湖泊優養化',  3),
(44,  '初級', '熱島效應對我們會產生什麼影響？',  '造成溫度變低', '容易下雨', '會產生很大的風',  '空氣中的污染物不容易散掉', 4),
(45,  '中級', '臺灣持續的氣候改變對我們飲食方面有什麼影響？', '水資源變多',  '糧食增加', '水果生長季節改變', '沒有產生什麼改變', 3),
(46,  '中級', '臺灣氣候持續改變對我們生活有什麼影響？',  '降雨日大增',  '因為雨勢遽增，造成淹水',  '夏天夜晚非常涼爽', '颱風強度較弱', 2),
(47,  '初級', '在學校中具有環保生活習慣的是下列哪一項？', '在超商買礦泉水',  '外面商店買奶茶',  '買合作社的飲料',  '自備環保杯',  4),
(48,  '初級', '減緩全球暖化由個人做起，請問以下何者較符合低碳生活之做法？',  '多吃蔬菜少吃肉',  '多洗手',  '多開車',  '多掃地',  1),
(49,  '中級', '下列何者是世界各國國際間的合作，來防止全球溫度繼續上升的方法之一?',  '簽署國際環保公約', '利用人為的力量使天空降雨', '一起發展太空科技', '一起簽署經濟貿易協定', 1),
(50,  '中級', '下列何者是減少全球溫度繼續升高的方法之一？',  '推廣無車日',  '鼓勵民眾多在家中吹冷氣',  '使用人工造雨', '多吃肉少吃蔬菜',  1),
(51,  '初級', '下列何者是因為人類行為而造成大量森林消失的主因？', '森林過度開發成農田',  '遊客到森林觀光',  '閃電產生的森林大火',  '植物被病菌感染',  1),
(52,  '初級', '下列何者的蒸發作用是形成雨水最主要的來源？',  '海洋', '河川', '湖泊', '冰山', 1),
(53,  '初級', '臺灣飲用水的水源主要是從哪裡來的？',  '一直使用回收水',  '直接取用海水', '來自河川', '向鄰近國家購買',  3),
(54,  '初級', '下列何者是減少水受到污染的作法？', '在水源區採砂石',  '農田增加農藥量',  '減少農田不當的施肥',  '在水中加入大量營養物', 3),
(55,  '初級', '臺灣四面環海，東部的海洋名稱為以下何者？', '大西洋',  '印度洋',  '太平洋',  '地中海',  3),
(56,  '初級', '我們所吃的鹽巴大多從下列何者而來的？', '從河裡面來',  '從雨水裡面來', '從海洋裡面來', '從植物提煉來', 3),
(57,  '初級', '下列何者是臺灣周圍海域的季節性洄游魚類？', '黑鮪魚',  '吳郭魚',  '香魚', '鯰魚', 1),
(58,  '初級', '地下水如果消失或變少，會產生下列何種問題？',  '地層下陷', '海嘯', '土石流',  '地震', 1),
(59,  '初級', '下列何者是超抽地下水所產生的狀況？',  '河川枯竭', '近海土地鹽化', '珊瑚死亡', '土地生產力提高',  2),
(60,  '初級', '下列何者是使土壤自然形成不同顏色的原因？', '因為受到的污染物不同', '因為它自己的成份不同', '因為被潑到不同顏色的顏料', '因為陽光照射的問題',  2),
(61,  '中級', '土壤的顏色不同，肥沃度會相同嗎？', '肥沃度與顏色有關', '肥沃度與顏色無關', '顏色越深越貧瘠',  '顏色越淺越肥沃',  1),
(62,  '初級', '下列何者是自然界產生的振動？', '地震', '音樂播放聲音很大的時候',  '有大車子經過時',  '使用炸藥', 1),
(63,  '初級', '下列何者會使地面產生強烈振動？',  '唱歌', '騎腳踏車', '卡車經過', '走路', 3),
(64,  '初級', '「讓人感覺不舒服的聲音」稱做什麼？',  '垃圾', '噪音', '悅音', '酸雨', 2),
(65,  '初級', '空氣組成的成分中，最多的是下列何者？', '氧氣', '氮氣', '水蒸氣',  '二氧化碳', 2),
(66,  '初級', '大氣層中哪一層含有豐富的水蒸氣？', '平流層',  '對流層',  '增溫層',  '中氣層',  2),
(67,  '中級', '造成酸雨的主要來源為何？(A)動、植物分解所產生的有機酸', '(B)汽機車排放的廢氣(C)排泄物分解所產生的甲烷(D)使用非環保冷媒(E)火山的噴發物', '', '', 'ABC',  0),
(68,  '中高級',  '下列何者是常見的游離輻射？',  'Ｘ射線',  '行動電波', '可見光',  '行動電話的電磁波', 1),
(69,  '中級', '下列何種行為會使平流層的臭氧層變稀薄？',  '種植樹木', '使用海龍滅火器',  '走路去上課',  '使用含有環境荷爾蒙的清潔劑',  2),
(70,  '初級', '使平流層臭氧量減少的主要物質為何？',  '', '石油碳氫化合物',  '重金屬',  '戴奧辛',  0),
(71,  '中高級',  '下列何者對於紫外線指數的描述是正確的？',  '3~5級曝曬級數是過量級', '6～7級曝曬級數是過量級', '當曝曬級數越高對人體傷害就越大',  '當曝曬級數越低對人體傷害就越大',  3),
(72,  '初級', '下列哪一個對於熱島效應的描述是正確的？',  '發生在小島上', '使一個地方的溫度特別的高', '多發生在植物很多的地方',  '多發生在海邊', 2),
(73,  '初級', '下列何者對溫室效應的描述是正確的？',  '地球臭氧層破洞',  '如果沒有溫室效應，地球會冷的人類無法居住', '空氣中產生很多顆粒',  '雨水變酸了',  2),
(74,  '初級', '臺灣天氣變化越來越劇烈是下列何種因素造成？',  '地球破洞', '下酸雨',  '溫室效應', '沒下雨',  3),
(75,  '初級', '以下何者是人為造成溫室效應變得更嚴重的主因？', '亂丟垃圾', '工廠和汽機車排放廢氣', '科技進步', '電腦使用過多', 2),
(76,  '中級', '以下何種能量會被地球吸收而產生暖化的現象？',  '紅外線',  'X光', '雷射', 'α射線',  1),
(77,  '初級', '以下何種氣體主要造成溫室效應？',  '二氧化碳', '一氧化碳', '氧氣', '氮氣', 1),
(78,  '初級', '下列何種物質燃燒導致溫室效應氣體的產生？', '陶瓷', '玻璃', '石油', '岩石', 3),
(79,  '初級', '下列何者對全球溫度上升的影響較大？',  '汽車與機車排放廢氣',  '人類放屁', '種植蔬菜', '捕撈魚類', 1),
(80,  '初級', '人類進入到下列哪一個時代，溫室效應才開始越來越嚴重？', '石器時代', '漁業時代', '工業時代', '農業時代', 3),
(81,  '初級', '下列何者是全球溫度上升對我們人類的影響？', '我們可以住的地方越來越多', '農田的生產量增加', '提高大規模傳染病的發生率', '我們可以使用的動植物量增加',  3),
(82,  '初級', '下列何者是全球溫度上升對野生動植物的影響？',  '提高生產能力', '造成幼小動物生存率下降',  '造成動物大量繁殖', '增加動物種類', 2),
(83,  '初級', '大自然有自行恢復的能力，以下哪一個觀念是對的？',  '大自然有自行恢復能力，所以可以任意排放污染物', '大自然恢復能力有限，所以我們不能排放太多的污染物', '我們住在城市，所以跟我們沒有關係', '那是環保人員的事，我們幫不上忙',  2),
(84,  '高級', '下列何者是屬於天然災害敏感地的正確描述？', '容易造成土石崩塌', '不具有生態保育價值的地方', '地質穩定的區域',  '生物多樣性少的地區',  1),
(85,  '初級', '下列何者是生態敏感地區的重要性？', '可以種植農作物',  '可以建造房屋', '提供野生動物棲息地',  '可以提供大量能源', 3),
(86,  '初級', '下列何者生態系的生物多樣性種類最多?', '雨林', '河川', '湖泊', '水庫', 1),
(87,  '初級', '下列哪一個環境，其生態系統中的生物種類較少?', '海洋', '雪地', '河川', '溼地', 2),
(88,  '初級', '外來物種入侵時，會對臺灣原有的生物造成哪一種衝擊？',  '會與原有的生物搶食食物',  '會增加原有生物的糧食來源', '會讓生態更加穩定平衡', '必然會讓區域性物種變得更豐富', 1),
(89,  '初級', '下列何者是臺灣保護野生動植物的方法？', '把牠們做成標本',  '把牠們養在家裡',  '規劃設立國家公園', '大量野放動物', 3),
(90,  '初級', '臺灣夏季炎熱，大家開冷氣造成用電量大增，下列哪一個是政府提出讓民眾減少用電的方法？',  '減少每一度的電費', '每個人限制用電量', '在家吹冷氣取代到外面吹冷氣',  '冷氣溫度設定在攝氏26至28度之間',  4),
(91,  '初級', '我們在日常生活中，落實下列哪一種行為可以降低對環境的破壞？',  '購買過度包裝的商品',  '使用商店提供的免洗碗筷',  '常把冷氣溫度開到最低', '自備環保餐具', 4),
(92,  '初級', '下列何者是我們在日常生活中應該做到的好習慣？', '用大量洗手乳洗手', '大量購買自己不需要的東西', '購物時自備購物袋', '垃圾不分類，都收在一起',  3),
(93,  '初級', '下列哪一種交通工具可以減少因廢氣造成全球溫度上升的現象？', '轎車', '計程車',  '摩托車',  '單車', 4),
(94,  '初級', '政府所宣導的節能「減碳」，指的是減少下列哪一種物質？', '一氧化碳', '二氧化碳', '一氧化二碳',  '二氧化三碳',  2),
(95,  '初級', '下列何者是減碳的真正目的？',  '為了提高我們生活水準', '為了減緩全球暖化', '為了增加氧氣', '為了減少電費', 2),
(96,  '初級', '節能減碳救地球是誰的責任？',  '只是政府的工作',  '只是司機的責任',  '每一個人的責任',  '只是工廠老闆的責任',  3),
(97,  '初級', '下列哪一種飲食習慣能減碳抗暖化？', '多吃速食', '多吃疏菜', '多吃牛肉', '多吃吃到飽',  2),
(98,  '初級', '小冰冰長大了，太小的衣服應該要如何處理才符合環保？',  '直接丟掉', '送給隔壁的小妹妹', '把衣服燒掉',  '放在家裏被蟲咬破再丟掉',  2),
(99,  '初級', '下列何種行為有做到節能減碳？', '使用環保餐具', '使用一次就丟的文具用品',  '使用乾淨的原生紙', '購買多重且精緻的包裝商品', 1),
(100, '初級', '下列何者是減碳帶給我們的好處？',  '降低生物生存空間', '減少全球暖化', '增加消費能力', '造成生活的不便',  2),
(101, '初級', '下列何者是可以落實低碳旅遊的方式？',  '用旅館的免洗牙刷用具', '請爸媽自己開車去旅遊', '搭大眾運輸工具旅遊',  '舉辦營火晚會', 3),
(102, '初級', '低碳旅遊是指在旅遊過程中減少排放溫室氣體，對環境帶來什麼影響？',  '更多污染', '減少污染', '減少食物', '更多破壞', 2),
(103, '初級', '下列何者是正確的資源回收行為？',  '將報紙丟入垃圾桶', '只要東西壞了就丟掉',  '將可以再利用的物品進行回收',  '不論可否回收，所有垃圾都投入回收桶',  3),
(104, '初級', '下列哪一種物品可以進行資源回收？', '複寫紙',  '舊衣服',  '用過的紙尿片', '用過的衛生紙', 2),
(105, '初級', '下列哪一種消費行為可以減少垃圾量？',  '購買很多食物', '準備很多零錢', '準備紙本商品目錄', '準備購物袋',  4),
(106, '初級', '下列何者為政府推動購買商品時建議使用環保購物袋的原因？',  '比較便宜', '減少垃圾量',  '趕上潮流', '增加開銷', 2),
(107, '初級', '下列何者是可以降低對環境所造成的污染？',  '', '', '生產可多次重複使用的商品', '生產高利潤商品',  0),
(108, '初級', '購買下列何種商品對環境比較友善？', '買過度包裝的商品', '買用過即丟的商品', '買不耐用的商品',  '買材質可以回收的商品', 4),
(109, '初級', '環保標章裡的綠色消費，下列何者是正確的觀念？', '多買綠顏色包裝的產品', '多到青山綠水的風景區旅遊', '多購買多層包裝的商品', '購買可回收的環保商品', 4),
(110, '初級', '下列何者是綠色消費對環境的影響？', '可以增加全球溫度', '可以減少空氣中的氧氣', '會增加颱風的產生', '減少資源浪費', 4),
(111, '初級', '下列何者是紙類回收時應該做的事？', '打包好即可隨地擺放',  '將紙類丟進垃圾桶', '用碎紙機剪碎', '放入紙類資源回收桶',  4),
(112, '初級', '玻璃瓶回收時，應怎麼處理才會有利於回收人員作業？', '估價', '壓碎', '裝飾', '清洗', 4),
(113, '初級', '下列何種方式可以減少汽機車排放出污染空氣的氣體？', '定期檢查汽機車',  '自行改裝的車子',  '增加開車頻率', '壞了才做檢查', 1),
(114, '初級', '下列何者關於資源使用的想法是對的？',  '我們比較富有，所以可以有較多資源', '窮困的國家，其資源本來就比較少',  '資源是屬於全球人類的，應該節約使用',  '資源應該是屬於少數有錢的人',  3),
(115, '初級', '下列哪一種行為對生態敏感地區會帶來破壞？', '減少土地開發', '進行生態旅遊', '部分地區禁止進入', '大量捕捉野生生物', 4),
(116, '初級', '下列何種行為會對生態系帶來正面影響？', '採用生態旅遊', '開闢公路', '大量蓋房子',  '野放外來種生物',  1),
(117, '初級', '我們看到公害可以打電話給下列哪一個單位？', '環保署',  '國防部',  '外交部',  '文化部',  1),
(118, '初級', '下列何種場所可能買得到修補過的環保家具？', '清潔隊',  '服裝店',  '百貨公司', '加油店',  1),
(119, '初級', '確保飲用水水質安全與衛生是誰的責任？', '政府', '自來水公司',  '學校', '全民', 4),
(120, '初級', '下列何者是珍惜水資源的生活方式？', '洗澡用浴缸泡澡',  '洗車時，直接用水管的水沖洗',  '用洗米水來澆花',  '刷牙時水龍頭一直開著', 3),
(121, '初級', '山區部落發生土石滑動會產生下列哪一種影響？',  '增加水資源',  '增加土壤肥沃度',  '減少土壤污染', '可能破壞房舍', 4),
(122, '初級', '下列何者是造成水受到污染的主要原因？', '自來水公司加氯在水中', '家中使用不含磷的洗潔劑',  '建立下水道系統',  '家庭污水', 4),
(123, '初級', '除了家庭污水及工廠廢水外，下列何者亦為臺灣水污染的主要來源之一？', '畜牧業',  '植木造林', '沙塵暴',  '航空業',  1),
(124, '初級', '下列何者是水資源受到污染後會對人類產生的影響？',  '可以用的水資源變多了', '增加水上遊樂設施', '食用水中生物會引起身體不適',  '造成熱島效應', 3),
(125, '中級', '下列哪一個是水資源受到污染時對環境產生的影響？',  '增加水生動植物',  '減少水中重金屬',  '增加所有魚類的繁殖',  '部分生物會大量繁殖，影響環境平衡', 4),
(126, '初級', '下列哪一種方式可以減少廢熱水流到河川裡？', '管制工廠將廢熱水排到河川', '禁止使用環境衛生用藥', '檢舉烏賊車',  '減少動物在河川排泄',  1),
(127, '初級', '下列何者是目前臺灣常見的海洋受到污染情況？',  '臭氧層稀薄',  '熱島效應的增加',  '在沙灘玩堆沙雕城堡遊戲',  '船隻漏油', 4),
(128, '初級', '下列何者是造成臺灣地下水大量減少的主要原因？', '被動物喝掉了', '自己流失了',  '被人類過度抽取',  '蒸發掉了', 3),
(129, '初級', '噪音最容易給人以下哪一種感覺？',  '煩躁不安', '破壞免疫系統', '危害心跳', '影響視力', 1),
(130, '初級', '下列何者行為會讓室內空氣受到污染？',  '抽菸', '慢跑', '騎腳踏車', '走路', 1),
(131, '初級', '下列何者是我們生活中主要的空氣污染源之一？',  '動植物排放的二氧化碳', '海水受熱形成的水氣',  '吹氣在玻璃上', '汽機車排放廢氣',  4),
(132, '初級', '下列何者是造成臺灣空氣品質變得更糟的主要來源？',  '露營野餐', '農家產生的炊煙',  '工廠及汽機車的廢氣',  '學校實驗室',  3),
(133, '初級', '下列何者是產生沙塵暴的主要原因？', '種植樹木', '沙漠化',  '颱風', '空氣污染', 2),
(134, '初級', '下列何者與酸雨的形成無直接關聯？', '汽機車、工廠排放的廢氣',  '火山的噴發物', '動植物分解所產生的有機酸', '多種植樹木',  4),
(135, '初級', '臭氧層稀薄化對環境有什麼影響？',  '植物能吸收更多的陽光', '對植物影響較大，動物則不具影響',  '加速植物進行光合作用，產生更多的氧氣', '提高生物得癌症的機率', 4),
(136, '初級', '下列何者是人為因素造成臺灣酸雨的原因之一？',  '火山噴發', '工廠排放空氣污染物',  '下雨日變多',  '聖嬰現象', 2),
(137, '初級', '下列何者是大規模砍伐森林後對環境帶來的影響？', '土壤變肥沃',  '減少二氧化碳的排放',  '減少土壤流失', '氣候改變', 4),
(138, '初級', '我們引進臺灣原本沒有的動物以增加生物的種類，會帶來下列何種影響？', '增加生物的多樣性', '促進生態平衡', '提高生物繁殖能力', '會使當地原來生物受到攻擊', 4),
(139, '初級', '你知道植物多樣性會對環境帶來以下哪一種好處？', '增加生物間的競爭力',  '具水土保持作用',  '減少棲息面積', '減少其他生物的生存空間',  2),
(140, '初級', '下列何者是不好的環保觀念？',  '自己帶環保購物袋子',  '使用生物可分解材質的產品', '使用用完即丟的一次性餐具', '購買貼有環保標章的商品',  3),
(141, '初級', '臺灣的自來水便宜，所以我們應如何使用才是正確的？', '因為便宜，就大量使用', '雖然便宜，但仍要節約使用', '可以一直使用也不用擔心會用完', '毫無限制地用水洗車子', 2),
(142, '初級', '臺灣四面環海，對於取用海洋資源應該懷著怎樣的態度？',  '海洋資源會自己再生，所以可以無限制的使用', '海洋資源有限，所以我們應該珍惜使用',  '海洋資源是免費的東西，不用白不用', '海洋資源這麼好用，趕快霸佔它', 2),
(143, '初級', '海洋資源很豐富，所以我們在捕魚時應採取下列何種態度？', '魚類會自己繁殖，可以大量捕撈', '魚類繁殖速度有限，不能過度捕撈',  '魚類種類很多，全部捕回來做標本',  '魚類會自己繁殖，不會有捕完的一天', 2),
(144, '初級', '因為黑鮪魚很好吃，所以我們可以大量捕撈。這句話為什麼不對？',  '因為黑鮪魚有毒',  '因為過度捕撈會導致黑鮪魚消失', '因為捕撈很辛苦',  '因為捕撈很危險',  2),
(145, '初級', '為避免土壤受到污染，我們該如何正確保護它？',  '土壤污染與我無關', '我住在城市，不會受到土壤污染的影響',  '不能任意傾倒垃圾於空地上', '土壤有自我恢復的能力，所以不用管它',  3),
(146, '初級', '減少臭氧層持續稀薄化是誰的責任？', '只是政府的責任',  '只是企業的責任',  '只是環保團體的責任',  '每一個人的責任',  4),
(147, '初級', '下列哪一種行為是對環境保護最有利的？', '在外面吃飯自己帶環保餐具', '吃麵食使用免洗碗', '出門時讓電腦繼續運轉', '晚上睡覺時，客廳大燈開著', 1),
(148, '初級', '防止全球溫度持續上升應該是誰的責任？', '環保人士', '政府官員', '工廠管理者',  '全地球的人類', 4),
(149, '初級', '我們的地球很大，空間和資源很多，對待資源應採取下列何種態度?', '資源很多，取之不盡',  '空間很大，可放置很多垃圾', '地球很大，受到污染不明顯', '地球雖大，但資源有限，要節省使用', 4),
(150, '初級', '國家公園的設置對於野生動植物帶來下列哪一種影響？', '限制植物生長的空間',  '減少動物的棲息空間',  '提供人類食物的來源',  '提供動植物的生長空間', 4),
(151, '初級', '我們應該要用下列何種態度來面對環境？', '環境是大家的，我不保護別人會保護', '我又沒用到環境的資源，不需要保護', '是政府應該做的事，我們沒有能力去做',  '保護環境大家都有責任', 4),
(152, '初級', '下列何者是保護環境我們所應該學習的事情？', '學習伐樹的技能',  '學習烹飪的能力',  '了解衛生教育法',  '了解環境變化的原因',  4),
(153, '初級', '京都議定書主要是減少下列哪一種氣體的排放？',  '二氧化碳', '水蒸氣',  '一氧化碳', '氫氣', 1),
(154, '初級', '京都議定書主要是減少下列哪一種環境效應？', '溫室效應', '酸雨', '火山爆發', '生物多樣性',  1),
(155, '初級', '下列何者是我們政府對於京都議定書的要求所提出的解決方式？', '鼓勵民眾多吃肉',  '鼓勵民眾多開車',  '鼓勵研發低污染的替代能源', '鼓勵土地多開發',  3),
(156, '初級', '京都議定書對我國帶來什麼影響？',  '促使我國對節能減碳的重視', '促使我國對海洋污染的重視', '促使我國對輻射污染的重視', '促使我國對垃圾分類的重視', 1),
(157, '中級', '下列何者是國際間一起合作保護環境的行為？', '訂定具有強制力的國際公約', '簽訂國際經濟貿易約定', '一起建造海底隧道', '建立跨國鐵路', 1),
(158, '初級', '維護生態敏感地區對於生物有什麼幫助？', '增加生存難度', '增加觀光旅遊景點', '增加舉辦活動的地區',  '提供生物的食物來源',  4),
(159, '初級', '下列何者「不是」為了保護臺灣動、植物所設立的區域？',  '野生動物保護區',  '美術館',  '自然保護區',  '國家公園', 2),
(160, '初級', '何者是我們國家關於環境保護的法律？',  '勞工安全衛生法',  '空氣污染防制法',  '食品衛生管理法',  '傳染病防治法', 2),
(161, '初級', '違反國家環保法規，下列何種態度是正確的？', '只要罰錢就好', '又不是只有我違法，大家都這樣', '我違法應該受到處罰',  '違法不一定會被抓到，小心點就好了', 3),
(162, '初級', '下列何者對以後的子孫在環境資源上的使用比較公平？', '資源應該全在有錢人手上',  '增加貧富差距', '資源不應任意浪費', '資源永遠用不完可以任意浪費',  3),
(163, '初級', '下列何者是考慮到現在的人類及未來子孫的行為？', '增加貧富差距', '強調性別歧視', '資源分配男女各半', '植木造林，森林復育',  4),
(164, '初級', '何種行為是環境保護中的預防勝於治療的行為？',  '洗澡用泡澡',  '冷氣溫度調很低',  '使用再生產品', '用水管直接洗車',  3),
(165, '初級', '為什麼我們要參與國際的環保行動？', '因為其他國家逼我們去做',  '因為政府要我們去做',  '因為我們是地球村的一份子', '因為老師說要做',  3),
(166, '初級', '下列何者是保護水資源的方法？', '設立水源保護區',  '在水源區畜養家畜', '在水源區種植淺根植物', '抽取地下水做灌溉', 1),
(167, '初級', '下列何者是減少海洋污染的方式？',  '噴灑大量的化學清潔劑', '大量砍伐樹木', '減少使用冷氣以減緩溫室效應',  '要將污水處理後才能排入大海',  4),
(168, '初級', '下列何者行為可以預防土壤受到污染？',  '不中斷地開發使用土壤', '讓動物在上面直接排泄，增加養分',  '不讓人把工業廢水在未達排放標準時倒入土裡', '大量使用環境衛生用藥', 3),
(169, '初級', '為了減少土壤受污染，我們能做什麼？',  '看到有人在偷偷倒廢水，要通知環保人員', '把廚餘直接倒入土壤，增加土壤肥力', '長期使用環境衛生用藥，殺死害蟲',  '看到有烏賊車，通知環保署人員', 1),
(170, '初級', '下列何者是我們常在家中使用的環境衛生用藥？',  '空氣清新劑',  '香精油',  '洗碗精',  '殺蟲劑',  4),
(171, '初級', '下列何者是使用環境衛生用藥時應該注意的事項？', '按照標示說明書指示',  '大量噴灑，這樣效果比較好', '使用劑量越濃越好', '晚上噴，白天不要噴',  1),
(172, '初級', '下列何者情形需要使用環境衛生用藥？',  '', '', '房間整齊', '家中有許多蟑螂',  0),
(173, '初級', '下列何者不是目前政府對沙塵暴的影響而提出保護人民的措施？', '建立沙塵網站', '提供沙塵信息簡訊服務', '看病不用錢',  '發布於新聞報導',  3),
(174, '初級', '以下何者是控制登革熱病媒蚊孳生的根本方法？',  '買電蚊拍', '買電蚊香', '裝紗窗',  '清除家中不需要的積水器具', 4),
(175, '初級', '我們在屋內使用殺蟲劑後，應採取何種行動？', '留在室內觀察害蟲情形', '暫時離開房間到戶外休息',  '繼續使用殺蟲劑以利殺死害蟲',  '留在室內繼續工作', 2),
(176, '初級', '會讓人注意力集中、心情愉快的環境是下列哪一項？',  '工地施工的聲音',  '飛機起飛的聲音',  '冷氣水塔的聲音',  '微風吹過樹梢的聲音',  4),
(177, '初級', '對於別人長時期產生的噪音，我們應如何處理？',  '他們吵，我們也吵', '打電話給環保專員來處理',  '多一事不如少一事，不要管他',  '拿耳塞塞住自己的耳朵', 2),
(178, '初級', '我們國家有規定噪音的限制標準，下列何者敘述是正確的？', '噪音時段分為白天和晚上兩段',  '噪音時段分為日間、晚上和夜間三段', '噪音限制只針對工廠',  '噪音限制只針對娛樂場所',  2),
(179, '初級', '下列何者會增加最多空氣污染？', '走路上學', '騎腳踏車', '種植植物', '焚燒塑膠垃圾', 4),
(180, '初級', '當紫外線指數達到過量級時，我們應該要怎麼保護自己？',  '不喝水',  '戴隱形眼鏡',  '穿短袖衣褲',  '塗防曬油', 4),
(181, '初級', '下列何種行為會減少熱島效應的程度？',  '多開車',  '興建綠建築',  '多使用冷氣',  '多舖設柏油路', 2),
(182, '初級', '下列何者是我們自己能做到減少溫室效應的方法？', '少走路多開車', '少開窗戶多吹冷氣', '多運動少吃東西',  '多吃蔬菜少吃肉',  4),
(183, '初級', '下列何者是保護環境最好的方法？',  '自己做自己的', '大家團結合作一起努力', '有一些人做就可以了',  '大家都不做',  2),
(184, '初級', '將未經處理的垃圾直接埋在土壤，對環境會產生下列哪一種問題？',  '會造成空氣污染',  '會造成土壤污染',  '不會造成污染', '會造成噪音污染',  2),
(185, '中高級',  '下列何者是日常生活中常見的非游離輻射(比較不會傷害身體的光)？',  'X射線',  'α射線',  '紅外線',  '伽傌射線', 3),
(186, '初級', '下列何種行為可以減少電磁波對我們的影響？', '把手機放在身上',  '看電視坐很近', '微波食物時站在旁邊',  '不要長時間接近高壓變電站', 4),
(187, '初級', '中國大陸所產生的沙塵暴對我們造成下列哪一種影響？', '農作物生長得更好', '只會對我國造成水污染', '對我國造成空氣污染',  '改善人文景觀', 3),
(188, '中高級',  '除了臺灣、南韓以外，還有哪一個國家受到中國大陸沙塵暴的影響？', '日本', '美國', '澳洲', '印度', 1),
(189, '初級', '下列何者是沙塵暴對環境的影響？',  '空氣變得不好', '天氣變得更熱', '樹木長得更好', '直接形成土石流',  1),
(190, '初級', '酸雨對我們會造成下列哪一種危害？', '增加熱島效應', '影響洋流的流動',  '產生光害', '傷害人體的皮膚及眼睛', 4),
(191, '初級', '下列何者是酸雨對環境的影響？', '湖泊變酸', '土地變肥沃',  '森林生長速度增加', '水生動物種類會增加',  1),
(192, '初級', '下列何者是目前臺灣面臨最主要的環境問題？', '空氣污染', '垃圾未分類',  '輻射污染', '暴風雪侵襲',  1),
(193, '初級', '下列何者對保護野生動、植物會帶來正面影響？',  '簽署經濟貿易協定', '把他們棄養在戶外', '成立國家公園', '把他們養在家裡',  3),
(194, '高級', '建商在開發土地前應對環境做出下列何種評估？',  '了解開發對個人的效益', '了解開發的成本',  '開發對環境帶來的影響', '開發對公司的影響', 3),
(195, '中級', '氣象預報常出現「紫外線指數」，其英文縮寫是什麼？', 'PSI',  'UVI',  'EuP',  'ISO',  2),
(196, '初級', '下列何者是臺灣目前處理垃圾的主要方式？',  '拿到垃圾場埋起來', '送到焚化廠燒掉',  '倒到海裡', '花錢讓其他國家處理',  2),
(197, '初級', '進行垃圾強制分類，對環境主要的幫助是什麼？',  '會減少可回收的量', '會減少垃圾量', '會減少空氣污染',  '會減少噪音污染',  2),
(198, '初級', '下列何者是正確處理垃圾的態度？',  '把垃圾丟到其他國家',  '付錢給其他國家，再把垃圾運過去',  '隨地亂丟垃圾', '儘量減少垃圾的產生',  4),
(199, '初級', '下列何者是造成水庫有太多養分的主因？', '排泄物流入水庫',  '石油流入水庫', '重金屬流入水庫',  '酸水進到水庫', 1),
(200, '初級', '當湖泊有太多養分時，對河中生物棲息環境會有何種影響？', '增加魚類的活動空間',  '魚類會大量繁殖',  '增加水中氧氣', '藻類會大量繁殖',  4),
(201, '初級', '水中的懸浮粒子大量增加對魚類會造成下列哪一種影響？',  '只對水生植物有影響',  '阻礙魚類生長與繁殖',  '有效躲避其他生物的攻擊',  '增加魚群的食物量', 2),
(202, '初級', '我們將熱廢水排入河川中，下列何者是首當其衝受到沖擊？', '空中的飛鳥',  '陸地的走獸',  '水裡的魚', '森林中的植物', 3),
(203, '初級', '下列何者是造成河川水溫上升的原因？',  '酸雨', '傾倒廢棄物',  '熱廢水的排放', '熱島效應', 3),
(204, '初級', '下列何者是造成海洋污染的主要來源？',  '船隻漏油', '加油站漏油',  '汽機車廢油亂倒',  '使用免洗餐具', 1),
(205, '初級', '下列何者是海洋受到嚴重污染所帶來的影響？', '增加熱島效應', '引起海嘯', '降低海中礦物質',  '海中動物生病', 4),
(206, '初級', '下列哪一種方式可以使受到重金屬污染的土壤恢復健康？',  '在土地上養很多牛', '在土裡養很多蚯蚓', '用家裡的清潔劑清洗',  '種植可吸收重金屬的植物',  4),
(207, '初級', '下列何者是政府推動清淨家園的方法？',  '鼓勵企業認養照顧家園', '強迫大家要打掃',  '請清潔公司幫忙維護整潔',  '我們的市長、縣長不用參加', 1),
(208, '初級', '在我們住屋的室外或庭園使用大量殺蟲劑，可能造成下列哪一種後果？',  '植物長得更茂盛',  '動物生長得更快',  '部分好的生物也會死掉', '害蟲永遠不會再來', 3),
(209, '初級', '毒性化學物質可能對我們身體產生下列何種影響？', '使我們更健康', '有害健康', '促進食慾', '降低膽固醇',  2),
(210, '初級', '在洗碗時沒有將洗碗精徹底沖洗乾淨，會造成下列何種影響？',  '不會造成影響，因為洗碗精都沒有毒性',  '殘留的洗碗精可能會危害健康',  '可以避免蟑螂靠近碗盤確保我們的健康',  '殘留的洗碗精會自動消失，所以不會有影響',  2),
(211, '初級', '不當使用環境衛生用藥，對環境會產生什麼影響？', '害蟲會產生抗藥性，不利於環境生態', '不會影響到人類的健康', '可以殺死更多的害蟲',  '只會對害蟲有影響', 1),
(212, '初級', '我們在放置老鼠藥後，應採取下列何種動作？', '立即吃飯', '立即洗手', '立即睡覺', '立即上網', 2),
(213, '初級', '下列何者是在臺灣常常聽到的噪音類型？', '飛機引擎聲',  '工程爆破聲',  '炸彈爆炸聲',  '道路交通車輛的聲音',  4),
(214, '初級', '下列哪一種對噪音的說明是正確的？', '我們的政府仍沒有規定噪音的限制',  '不同時段會有不同的噪音管制標準',  '噪音的標準不一致，所以不應該檢舉', '有忍耐美德的人不應該檢舉別人製造的噪音',  2),
(215, '初級', '若在室內使用油漆粉刷牆壁，對身體會產生下列哪一種影響？',  '不影響呼吸',  '具有放鬆心情的作用',  '只會對皮膚造成影響',  '頭暈', 4),
(216, '初級', '空氣中的微小粒子，可能對身體會產生下列哪一種影響？',  '肚子痛',  '胃痛', '氣喘', '手痛', 3),
(217, '初級', '空氣被污染對於生物有什麼影響？',  '破壞生物的生存環境',  '提高生物繁殖力',  '增加生物多樣性',  '降低對生物生存的威脅', 1),
(218, '初級', '下列哪一個是臺灣空氣品質要檢測的氣體成份？',  '氮氣', '一氧化碳', '二氧化碳', '水蒸氣',  2),
(219, '初級', '下列何者是沙塵暴對身體產生的影響？',  '腸胃不適', '眼睛容易受刺激不舒服', '引發小兒麻痺', '聽力會降低',  2),
(220, '初級', '下列何者方法可以減少沙塵暴的發生？',  '簽署巴塞爾公約',  '多開車，少坐捷運', '選購不能回收的商品',  '增加植被', 4),
(221, '初級', '下列哪一種原因使高空的臭氧層變薄？',  '因為人類使用破壞它的物質', '臭氧層自己破掉的', '臭氧層被外太空的石頭打破', '受颱風影響',  1),
(222, '初級', '我們所產生的污染物質會對其他國家帶來影響嗎？', '臺灣沒有跟其他國家相連，所以不會有影響',  '海水、氣流會將污染物帶到其他國家', '只會造成空氣污染', '只會造成噪音污染', 2),
(223, '初級', '臺灣氣候持續改變對於這塊土地上的生物有什麼影響？', '增加垃圾量',  '增加光害的影響',  '提高土石流發生率，造成動植物死亡', '增加游離輻射的危險性', 3),
(224, '初級', '政府為配合京都議定書的政策，做了哪些努力？',  '因為沒有簽署所以沒有政策', '實施噪音管制時段', '落實垃圾不落地政策',  '制定再生能源發展條例', 4),
(225, '初級', '下列何者會增加水資源的浪費？', '使用兩段式沖水馬桶',  '隨手關緊水龍頭',  '換裝節水水龍頭',  '洗澡用盆浴方式',  4),
(226, '初級', '我們要如何避免使水裡面出現太多的營養物？', '多種高山蔬果，吸收養分',  '多種淺根植物', '農田多使用肥料',  '禁止將動物的排泄物排入水中',  4),
(227, '初級', '打掃社區環境，我們應採取下列何者行動？',  '自己不打掃，請別人來打掃', '自己不打掃，也不要別人來打掃', '社區通知，被動打掃',  '自己主動打掃', 4),
(228, '初級', '白天外出活動時，為避免被登革熱病媒蚊叮咬，可採取下列何者方法？',  '塗防蚊液', '塗防曬油', '穿短袖衣褲',  '戴帽子',  1),
(229, '初級', '下列何者是減少登革熱產生的方法？', '勤掃地',  '儘量多去公共場所', '清除居家內外的積水容器或輪胎', '多擦玻璃', 3),
(230, '初級', '下列何者是可以減少蟑螂的方法？',  '把垃圾堆在家門口', '廚餘放在袋口打開的袋子裡', '保持居家環境清潔', '常開燈，居家環境不要保持陰暗', 3),
(231, '初級', '下列何者是有毒的東西？',  '農夫用的農藥', '吃起來苦苦的苦瓜', '看起來紫紫的茄子', '乾淨的襪子',  1),
(232, '初級', '下列何者是有毒物質？', '綠豆粉',  '殺蟲劑',  '洗米水',  '乳液', 2),
(233, '初級', '在戶外或庭園使用殺蟲劑時，應選擇下列哪一種殺蟲劑較佳？',  '有效且毒性較強的', '有效且低毒性的',  '自行混合使用', '有效且長效型的',  2),
(234, '初級', '在室內使用噴霧殺蟲劑時應注意下列哪些事項？',  '按照標示說明書指示噴灑',  '廣泛且大量噴灑害蟲出沒處的地方',  '大量噴灑時要關緊門窗', '為增加效果，自行混合兩種以上的殺蟲劑使用', 1),
(235, '初級', '購買或使用洗碗精時應該要注意下列哪一個事項？', '洗碗時沖一次水就可以了',  '購買時要選容易被環境分解的',  '用洗碗精洗過碗的水可以澆花',  '多用一點洗碗精，碗筷才會乾淨', 2),
(236, '初級', '發現有人焚燒塑膠或稻草時，應該打電話給誰？',  '朋友', '警察', '環保局',  '家人', 3),
(237, '中高級',  '政府在何時頒布禁止在公共場所抽菸的法令？', '民國96年',  '民國97年',  '民國98年',  '民國99年',  3),
(238, '初級', '下列哪一個法規是針對空氣品質設立的法規？', '水污染防治法', '空氣污染防制法',  '土壤及地下水防制法',  '廢棄物清理法', 2),
(239, '初級', '下列何者是發生沙塵暴時保護自己的方法？',  '外出戴口罩',  '小孩子比較不受沙塵暴影響', '儘量待在室外', '去海邊玩', 1),
(240, '初級', '下列患有何種疾病的人在發生沙塵暴時特別要減少外出？',  '呼吸道疾病的人',  '需要洗腎的人', '胃病的人', '癌症的人', 1),
(241, '中級', '下列何者是我們國家為了減少臭氧層稀薄所做的努力？', '禁用海龍滅火器',  '推動省水', '推動旅遊', '推動地方觀光', 1),
(242, '初級', '由於全球工業一直在發展，它們所排出的二氧化碳會產生下列哪一種環境災害？',  '臭氧層破洞',  '沙塵暴',  '地球暖化', '森林火災', 3),
(243, '中級', '土石流會對當地居民產生什麼影響？', '居住地受到威脅',  '增加土壤肥沃度',  '減緩地層下陷', '地層持續上升，相抵之後沒有影響',  1),
(244, '中級', '大部分的水污染對環境產生什麼影響？',  '水溫降低，導致生物無法存活',  '水中溶氧量增加，降低藻類繁殖', '對於水中生物的繁殖產生影響',  '使水中的動物因為食物增加，族群量提高', 3),
(245, '中級', '下列何者是造成臺灣西部地區「地下水位下降」的主要原因？',  '居民飲用', '自我流失', '養殖漁業', '蒸發作用', 3),
(246, '中級', '下列何者是超抽地下水可能造成的問題？', '土壤軟化', '地層下陷', '地層抬升', '土地生產力提高',  2),
(247, '中級', '下列何者是臺灣主要常見污染土壤的來源？',  '焚化廠排放廢氣',  '工業污染', '沙塵暴',  '廢熱污染', 2),
(248, '中級', '過量使用環境用藥對生物會產生什麼影響？',  '有利生物增加抗體並健康生存',  '造成目標生物族群滅絕', '增加生物多樣性',  '防治對象會產生抗藥性', 4),
(249, '中級', '汽車會排放出什麼氣體造成空氣污染？',  '水',  '氮氧化合物',  '氧氣', '氮氣', 2),
(250, '中級', '下列何者是酸雨對土壤所造成的影響？',  '土壤重金屬的釋出', '土壤液化', '土壤漬化', '土壤礦化', 1),
(251, '初級', '造成臺灣氣候溫度升高的主要原因為何？', '臭氧層薄化造成',  '下酸雨',  '溫室效應', '沒下雨',  3),
(252, '中級', '下列何者是全球溫度上升對環境造成的影響？', '冰層增厚', '海平面下降',  '植物生長空間改變', '地層下陷', 3),
(253, '中級', '下列何者是政府針對企業應負起的環保責任所採用的措施？(A)對於盡到責任之企業給予補助(B)使用環保法令(C)利用環保標章制度', 'AB', 'AD', 'BC', 'ABC',  4),
(254, '中級', '下列何者可以使企業在生產過程中減少對環境污染？',  '改變製程', '改變銷售方式', '改變產品價格', '增加曝光度',  1),
(255, '中級', '臺灣哪一條河川曾是污染嚴重，後來經過整治變成觀光聖地？',  '二仁溪',  '濁水溪',  '愛河', '大漢溪',  3),
(256, '中級', '海洋環境的變化導致下列哪一種情形？',  '漁獲量減少',  '鹽產量減少',  '礦產量變少',  '海水量減少',  1),
(257, '中級', '對於海洋受到有毒物質污染所帶來的影響，下列何者「不正確」？',  '魚群發生死亡', '危脅棲息於海邊生物的生命', '人類透過飲食易累積毒物',  '使海水溫度上升的主因', 4),
(258, '中級', '我國於何時立法規定，三人以上共用之室內場所全面禁止吸菸？', '民國90年',  '民國95年',  '民國98年',  '民國100年', 3),
(259, '初級', '政府對於手機或基地臺產生電磁波建議哪些防護措施？', '增加通話時間', '使用免持聽筒套件', '安置基地臺在屋頂', '電量剩一格時還是可以使用', 2),
(260, '中級', '下列哪一個國際約定是針對臭氧層破壞而簽訂的？', '《蒙特婁議定書》', '《鹿特丹公約》',  '《斯德哥爾摩公約》',  '《氣候變化綱要公約》', 1),
(261, '中級', '蒙特婁議定書是針對下列哪一類的化學物質進行管制？', '氟氯碳化物',  '甲基氯仿', '溴甲烷',  '氯化亞鈷', 1),
(262, '中級', '臺灣夏季炎熱，大家開冷氣造成用電量大增，下列哪一個是政府提出讓民眾減少用電的方法？',  '戶外太熱，多待至家裡', '減少用電量政府會給予獎勵', '', '', 0),
(263, '中級', '下列哪一個國際公約是為了減緩全球暖化而制訂的條約？',  '《生物安全議定書》',  '《巴塞爾公約》',  '《京都議定書》',  '《斯德哥爾摩公約》',  3),
(264, '中級', '京都議定書是在下列哪一個國家開會通過?',  '美國', '日本', '中國大陸', '臺灣', 2),
(265, '中級', '京都議定書於下列哪一年簽署的？',  '民國66年',  '民國76年',  '民國86年',  '民國96年',  3),
(266, '中級', '京都議定書主要是針對下列哪一種問題？', '全球暖化', '酸雨', '熱島效應', '生物多樣性保存',  1),
(267, '中高級',  '京都議定書的簽署對我國有何影響？', '我國未簽署，因此不受約束', '我國未簽署，但因各國重視，我國也自動遵行', '我國已簽署，因此受到議定書約束',  '我國從未生產或使用議定書所規範的物質', 2),
(268, '中高級',  '對環境有影響疑慮之開發案，第一階段環境影響評估審查時，須提出哪種報告？',  '環境影響說明書',  '生物影響評估書',  '污染影響評估書',  '噪音影響評估書',  1),
(269, '中級', '地球上超過70％的面積被水覆蓋，但能有效利用的地表水淡水資源不超過多少比例？', '0.1',  '1%', '0.1%', '0.01%',  3),
(270, '中級', '地球上最大的水量主要儲存在哪裡？', '湖泊', '空氣', '河川', '海洋', 4),
(271, '中級', '下列何者是臺灣最容易取得的淡水資源？', '南極的冰', '海洋的水', '河川的水', '綠洲的水', 3),
(272, '初級', '下列何者是造成湖泊優養化的主要營養鹽？',  '磷',  '鎂',  '鈣',  '鈉',  1),
(273, '中高級',  '下列何者對於一般地下水水質特性之說明是正確的？',  '地下水含鹽量較低', '地下水是地下飽和層的水',  '地下水的水質最混濁',  '地下水流動的速度較快', 2),
(274, '中高級',  '下列何者是組成土壤的液相成份？',  '微生物',  '腐植質',  '水分溶液', '氧化物',  3),
(275, '中高級',  '下列哪一個對於土壤肥沃的描述是正確的？',  '滿足動物生存需求', '滿足作物生產需求', '鹼性為肥沃指標',  '酸性為肥沃指標',  2),
(276, '中級', '下列哪一種類型的土壤最為貧瘠？',  '紅土', '黑土', '黃土', '綠土', 1),
(277, '中級', '下列哪一種元素會使土壤產生紅色的現象？',  '鉻(ㄍㄜˋ)', '鐵',  '銅',  '硫',  2),
(278, '中級', '下列何者是目前我們常見的土壤污染型態？',  '硬化', '礦化', '熱水污染', '重金屬污染',  4),
(279, '中級', '下列何者是土石流的特徵？', '表面流速慢，下面流速快',  '表面流速快，下面流速慢',  '泥沙濃度低',  '衝擊力不大',  2),
(280, '中級', '臺灣腸病毒好發的季節是哪一季？',  '1~3月', '4~6月', '7~9月', '10~12月', 2),
(281, '中級', '大氣層一共有五層，最外層的是？',  '對流層',  '外逸層',  '熱成層',  '平流層',  2),
(282, '高級', '大氣層中哪一層含有最高比例的臭氧？',  '', '對流層',  '中氣層',  '增溫層',  0),
(283, '中級', '下列何種物質屬於空氣中的「懸浮微粒」？',  '花粉', '水氣', '氧氣', '氟氯碳化物',  1),
(284, '中級', '氣象報告中所使用的英文代號PSI(Pollutant', 'Standards',  'Index)代表的意義為何？', '颱風強度', '海浪強度', 0),
(285, '初級', '下列何者是產生沙塵暴的條件之一？', '地表土質鬆軟、乾燥',  '地表有茂盛草木生長',  '無地面風', '經常降雨及降雪天氣現象',  1),
(286, '中級', '下列哪一項對於熱島效應的描述是正確的？',  '多好發在島國地形上',  '多好發在都市地區', '多好發在沙漠地區', '多好發在海邊', 2),
(287, '中級', '下列何者是溫室效應的正確描述？',  '因火山甦醒噴發所造成', '臭氧層薄化造成',  '空氣中懸浮物造成保溫效應', '部分熱量被留在地球表面',  4),
(288, '中級', '下列何者是溫室效應二氧化碳主要的來源？',  '化石燃料的燃燒',  '家畜腸胃發酵', '化肥', '森林', 1),
(289, '中級', '造成全球暖化的氣體中，最主要的是哪一種氣體？', '二氧化碳', '一氧化氮', '二氧化硫', '乙烷', 1),
(290, '中級', '下列何者是屬於環境敏感地的正確描述？', '容易受到人為開發影響的地方',  '不具有生態保育價值的地方', '地質穩定的區域',  '生物多樣性少的地區',  1),
(291, '中級', '臺灣的環境敏感地是政府的哪一個機關負責管理的？',  '環保局',  '農委會',  '衛生局',  '依類型不同有不同管理機關', 4),
(292, '中級', '生態敏感地區為什麼很重要？',  '具有豐富的物種及資源', '增加氣候變化', '減少糧食作物', '保護文化產業', 1),
(293, '初級', '下列何者是劃設環境敏感地的功用之一？', '做為良好的開發用地',  '提供人類開墾', '提供人類捕獵', '保留生態棲息環境', 4),
(294, '初級', '下列何種現象是造成森林自燃的主要原因？',  '因為颳風下雨，使樹木不斷摩擦產生', '因季節性氣候乾燥，容易產生高溫環境',  '因土石崩落，造成火災', '因人為疏忽造成火災',  2),
(295, '中級', '下列何者是增加生物多樣性合適的方法？', '減少棲地的破壞',  '引進外來生物以增加當地的生物種類', '全部畜養於動物園', '每個家庭都養動物，增加數量及種類', 1),
(296, '中級', '下列何者為植物多樣性增加對生物的影響？',  '穩固生物繁衍的橋樑',  '減少抓土力',  '減少棲息地',  '當環境變動，整個生態系易導致崩解', 1),
(297, '中級', '下列何者為植物多樣性增加對人類主要的影響？',  '調節氣候，提供舒適的生存環境', '提供我們打獵', '減少食物量',  '提供人類觀賞', 1),
(298, '中級', '若增加一地區的植物種類，可對該地區的氣候帶來何種影響？',  '可以調節空氣中的濕度', '使溫度增加',  '會減少空氣中的水分',  '會使空氣中的二氧化碳增加', 1),
(299, '中級', '一般會讓人注意力集中、心情愉快的環境是下列何者？', '工地施工的聲音',  '飛機起飛的聲音',  '音量小於50分貝的聲音',  '大聲播放音樂的環境',  3),
(300, '中級', '下列何種機車比較環保？',  '新的四行程機車',  '舊的二行程機車',  '舊的四行程機車',  '新的二行程機車',  1),
(301, '中級', '日常生活中，你可以採取下列哪種行動減緩全球暖化？', '選擇環保標章商品', '電腦不關機',  '多吃肉少吃蔬菜',  '多搭乘電梯，少走樓梯', 1),
(302, '中級', '下列何種行為可以稱為低碳生活？',  '外食使用免洗筷',  '自備購物袋',  '衣服舊了就買新的', '在家多吹冷氣', 2),
(303, '中級', '我們在日常生活中可以做什麼來減少環境敏感地被破壞？',  '購買綠色色彩的產品',  '減少出入環境敏感地區', '少吃蔬菜多吃肉',  '進住敏感地區', 2),
(304, '中級', '低碳旅遊主要是為了減緩下列哪一種環境問題？',  '減少排放造成臭氧層薄化的氣體', '減少排放造成溫室效應的氣體',  '減少排放造成酸雨的氣體',  '減少海嘯發生', 2),
(305, '高級', '下列何者對於低碳旅遊的描述是正確的？', '利用最省錢方式旅遊',  '利用最舒適的方式旅遊', '利用最少能源的方式旅遊',  '到落後的地方去旅遊',  3),
(306, '高級', '下列何者是交通省油好方法？',  '降低胎壓', '行車維持安全距離，避免緊急煞車',  '停紅燈時，持續催油門', '購買馬力大的汽車', 2),
(307, '中級', '下列何者對於目前資源回收方法的描述是正確的？', '將全新的物品回收後再利用', '沒貼上回收標誌的物品不能回收再利用',  '將不能使用且可進行再利用的物品回收',  '所有廢棄物都回收後再利用', 3),
(308, '初級', '下列何者是容器類回收三部曲的其中一項？',  '焚燒', '販賣', '分解', '沖洗', 4),
(309, '中級', '為了保護環境，政府提出了4個R的口號，下列何者是4R中的其中一項？',  '再創新',  '再利用',  '再分解',  '再研究',  2),
(310, '初級', '請問下列哪些東西可以進行資源回收？',  '輻射廢料', '寶特瓶、玻璃瓶等', '實驗室化學藥品',  '有毒廢棄藥物', 2),
(311, '中高級',  '學校實驗室之廢棄物依法屬於下列何種廢棄物類型？',  '一般廢棄物',  '團體型廢棄物', '事業廢棄物',  '大型廢棄物',  3),
(312, '中級', '你認為下列何者是工廠將應負的成本責任轉嫁給社會大眾？', '工廠生產可回收產品',  '工廠將處理好的廢氣排出',  '工廠將廢棄物運往焚化廠處理',  '排出未處理的廢水', 0),
(313, '中級', '下列哪一項是PSI(Pollutant',  'Standards',  'Index)所代表的意思？',  '水污染指標',  '空氣污染指標', 0),
(314, '中級', '下列何者是空氣污染指標所需測定的物質？',  '一氧化硫', '二氧化碳', '臭氧', '氟氯碳化物',  3),
(315, '中級', '政府向民眾收取污染環境應該要付出的費用後，將這些錢用在哪裡？', '用在建立圖書館',  '用在建立高速公路', '用在學校的營養午餐',  '用在整治與恢復被污染的環境',  4),
(316, '中級', '下列何者「不是」目前國際間環保的重點話題？',  '廢棄物跨國輸送',  '氣候暖化問題', '輻射外洩', '垃圾清理費用隨袋徵收', 4),
(317, '中級', '下列何項行為對環境保護是正面的？', '購買免洗餐具', '買過度包裝的商品', '買有環保標章商品', '買不可回收的商品', 3),
(318, '中級', '能代表綠色消費、低污染與省資源等意涵的標誌是什麼？　', '優良食品工廠標誌', '健康食品標誌', '有機標誌', '環保標章', 4),
(319, '高級', '下列哪個機構是目前優先被規定需要進行綠色採購的單位？', '電子業',  '公營事業', '鋼鐵業',  '造紙業',  2),
(320, '中級', '我們要怎麼才能讓廢熱水不流到河川裡？', '工廠不排放熱水至河川', '減少溫室效應的氣體',  '減少酸雨的產生',  '減少地層下陷', 1),
(321, '中級', '下列何者對於綠建築的說明是正確的？',  '主要使用綠色做為粉刷的顏色',  '增加水霧設施', '增加房屋周圍的植物種類',  '增加照明亮度', 3),
(322, '中級', '我們政府為配合京都議定書的政策，做了下列哪些努力？',  '提倡節能減碳', '禁用四行程之車輛', '倡導文化保存', '提倡清淨家園', 1),
(323, '初級', '你知道世界地球日是何時嗎？',  '6月8日', '3月21日',  '4月22日',  '5月21日',  3),
(324, '初級', '下列何者是保護生態敏感地區的方法？',  '完全開放開發', '禁止不當的開發行為',  '同意設立飯店', '野放外來種，增加生物種類', 2),
(325, '中級', '我們在國家公園從事什麼行為會增加對環境敏感地的破壞？', '不攀折樹木',  '不帶走任何生物',  '留下垃圾', '不從事捕獵',  3),
(326, '中級', '下列何者「不是」保護生物多樣性的方式？',  '國際間簽定保護生物多樣性的條約',  '針對污染進行管制與監控',  '引進其他國家物種，在國家內進行繁殖',  '建立保護或保存區', 3),
(327, '中高級',  '我國移動污染源空氣污染防制費的徵收機制為何？', '依車輛里程數計費', '隨油品銷售徵收',  '依牌照徵收',  '從菸品售價中徵收', 2),
(328, '中級', '下列哪一類公民素養對保護環境最為重要？',  '公德', '自私', '計較', '易怒', 1),
(329, '中高級',  '下列何者「不是」造成臺灣水資源減少的主要因素？',  '超抽地下水',  '雨水酸化', '水庫淤積', '濫用水資源',  2),
(330, '中級', '如果水土保持沒有做好，會發生下列哪一件事情？', '土壤滑動的作用力小於阻力', '土石凝聚力增加',  '土石滑動造成落石', '地面抬升以免海水侵入', 3),
(331, '中級', '下列哪一個是造成河川有太多養分的原因？',  '排泄物流入河川',  '石油流入河川', '重金屬流入河川',  '廢熱流入河川', 1),
(332, '中級', '海洋溫度上升對於海洋生物有什麼「不良」影響？', '提高生物的免疫能力',  '生物繁殖量減少',  '生物壽命延長', '生物的種類變多，但數量變少',  2),
(333, '中級', '下列何者是造成大量珊瑚死亡的原因之一？',  '海水溶氧增加', '水中生物大量食用珊瑚', '海水溫度提高', '海水養分提高', 3),
(334, '中級', '下列何者是在靠近海邊超抽地下水所產生的問題？', '土壤鹽化', '土壤軟化', '土壤液化', '地層抬升', 1),
(335, '中級', '下列何者是「不正確」使用環境用藥觀念？',  '只針對害蟲有影響', '對人體可能產生某些影響',  '影響環境生態', '影響水質', 1),
(336, '中級', '下列哪一個國家是受中國大陸沙塵暴影響最大的國家之一？', '美國東岸', '立陶宛',  '臺灣', '西班牙',  3),
(337, '中級', '除了中國大陸以外，下列哪一個區域也是主要產生沙塵暴的區域？',  '南亞地區', '東太平洋地區', '地中海地區',  '中亞地區', 4),
(338, '中級', '下列何者是沙塵暴對於人類生活所產生的影響？',  '能見度下降',  '增加海洋鹽份', '造成腸胃不適', '建築物受腐蝕', 1),
(339, '中高級',  '科學家首先發現臭氧層稀薄化是在下列何處？', '北極上空', '臺灣上空', '南極上空', '赤道上空', 3),
(340, '中級', '下列何者是氣候變遷對珊瑚礁生物的影響？',  '疾病蔓延', '增加生物物種', '降低生物活動量',  '維持原狀', 1),
(341, '中級', '下列何者是造成臺灣單次累積降雨量遽增的原因？', '溫室效應', '臭氧層薄化',  '酸沉降',  '沙塵暴',  1),
(342, '中級', '下列何者「不是」森林死亡對環境產生的影響？',  '土壤變肥沃',  '地下水變少',  '土壤流失', '氣候改變', 1),
(343, '中級', '下列哪一個國家是目前主要生產熱帶雨林木材與紙漿的國家？',  '冰島', '加拿大',  '印尼', '瑞士', 3),
(344, '初級', '我們到海邊，下列哪一種行為不能做？',  '玩沙子',  '泡泡腳',  '用海水洗手',  '用沙子把垃圾埋起來',  4),
(345, '中級', '打掃家園是誰的責任？', '工友', '學校', '清潔隊',  '每一個人', 4),
(346, '中級', '下列何者是環境衛生用藥製劑研發的主要考量原則？',  '長效型',  '大範圍',  '安全性',  '高劑量',  3),
(347, '中高級',  '下列何者對暖化觀念的描述是正確？', '', '', '臭氧層破洞造成暖化',  '人類應該為暖化負責任', 0),
(348, '中級', '目前臺灣用水量比重佔最多的是下列哪一個？', '工業用水', '農業用水', '民生用水', '電廠用水', 2),
(349, '中級', '沿海地區地層持續塌陷的主要原因為何？', '過度取用地下水',  '土石流',  '地震', '海嘯', 1),
(350, '初級', '下列何者是土壤污染對人類產生的影響？', '氣候變遷', '土地使用受限', '漁業損失', '導致地殼崩裂', 2),
(351, '中級', '臺灣的污染物質對於其他國家是否會產生影響？',  '不會產生影響，因為與其他國家沒有連結', '不會產生影響，因為有海洋調節', '會產生影響，因為污染會藉由海洋或大氣移動', '會產生影響，因為可以將污染物隨意運至他國', 3),
(352, '中級', '下列何者是全球暖化帶來的影響？',  '白日增長', '夜晚增長', '夏季增長', '冬季增長', 3),
(353, '初級', '下列何者對於土壤自淨作用的描述是正確的？', '由人類添加化學物分解', '由動物分解',  '由微生物分解', '藉由種植植物析出', 3),
(354, '中級', '使用仍有殘留含磷洗碗精的器具，對我們會產生什麼影響？', '毒性很強，立即死亡',  '危害健康，影響腎臟運作',  '皮膚潰爛', '賀爾蒙系統運作正常',  2),
(355, '中級', '下列何者是在選購或使用油漆時應注意的事項？',  '多使用噴霧式噴漆', '於密閉空間使用',  '標明「有機」即代表無毒性', '仔細閱讀說明書',  4),
(356, '初級', '下列何者是噪音對人體生理的主要影響？', '聽力受損', '血小板分散',  '白血球增加',  '心跳降低', 1),
(357, '初級', '下列何者是我們國家努力減少全球溫度繼續升高的方法？',  '鼓勵節能減碳做環保',  '鼓勵民眾多在家中吹冷氣',  '使用人工造雨', '不需做好垃圾分類', 1),
(358, '中級', '下列何者是考慮到環境保護中的世代公平原則的行為？', '資源適度使用並思考留給下一代使用', '過度的開發行為',  '捐款給環境難民',  '幫助中低收入戶',  1),
(359, '中級', '下列何者是制定環境保護相關法規的用意？',  '想展現我國有國際水準', '因為被其他國家逼迫而制定', '改善生活環境，增進國民健康',  '故意要懲罰壞人',  3),
(360, '中級', '下列何者是環保署對於保護環境而設立的法律？',  '多樣性培育法', '動物保護法',  '空氣污染防制法',  '農業發展條例', 3),
(361, '中級', '下列何者是?用垃圾焚化廠處?垃圾的最主要優點？',  '減少處理後的垃圾體積', '消除所有毒性', '減少空氣污染', '減少處理垃圾的程序',  1),
(362, '初級', '下列何者是增加水土保持的方法？',  '多種深根樹木', '多種蔬果', '多種檳榔樹',  '多種花卉', 1),
(363, '中級', '我們要如何減少河川水質優養化？',  '多種高山蔬果，吸收養分',  '多種檳榔樹',  '農田多使用肥料',  '增加污水下水道的接管率',  4),
(364, '中級', '下列何者是工業廢水中重金屬對土壤帶來主要的影響？', '為土壤中的動物補充必要養分',  '增加土壤肥沃度',  '降低土壤自淨能力', '加速農作物生長',  3),
(365, '中級', '若欲檢舉噪音公害時可撥打下列哪一個電話號碼？', '0800-055119',  '0800-085717',  '0800-066666',  '0800-222911',  3),
(366, '中級', '下列何者方式可以減少汽機車排放出污染空氣物？', '定期檢查機車', '使用馬力較大的車輛',  '使用二行程車子',  '使用自行改裝車子', 1),
(367, '中級', '下列何者是減少沙塵暴的發生方法？', '多吃肉類', '增加植被', '增加蓄養牲畜量',  '多清潔家園',  2),
(368, '中級', '下列哪一種方法是減少河川污染的方法？', '提供河川氮與磷',  '增加家庭污水接管率',  '降低水中溶氧率',  '提高水溫', 2),
(369, '初級', '土壤受到污染我們能做什麼？',  '看到污染立即通報', '不是我的土地，所以沒關係', '購買該土地之產品', '自動購買藥劑清洗', 1),
(370, '初級', '下列何者是登革熱好發的季節？', '春冬', '春夏', '夏秋', '秋冬', 3),
(371, '中級', '下列何者是可以藉由人為方式來減少噪音所引起的振動？',  '播放聲音與噪音源互相干擾', '跟著振動跳動', '', '降低播放低頻率音樂的音量', 0),
(372, '中級', '下列何者是工廠減少振動產生的方式？',  '發耳塞給作業員',  '與住戶良性溝通協調',  '改善機械平衡或加裝隔振材料',  '補貼職災金額', 3),
(373, '中級', '當電視氣象報告宣布：明日空氣污染程度將達到對人體健康有「不良」影響時，從事下列哪種舉動是比較不合適的？',  '出門到戶外跑步',  '避免外出', '隨時瞭解相關消息', '出門戴口罩',  1),
(374, '中級', '下列哪一個行為會造成臭氧層稀薄化？',  '種植樹木', '使用氟氯碳化物的冷媒', '走路', '動物排氣', 2),
(375, '中級', '下列何者是家庭污水造成河川污染的原因之一？',  '大家偷排放污水',  '污水下水道不普及', '家庭污水毒性強，處理廠不易處理',  '家庭污水未經處理廠處理',  2),
(376, '中級', '下列何者是造成河川溫度上升的原因？',  '酸雨', '生物族群增加，影響水溫',  '工廠溫水排入', '生物分解能量造成水溫升高', 3),
(377, '中級', '溫室效應造成現在海洋環境的變化為何？', '生物種類增加', '海水溫度提高', '生物數量增加', '水中溶氧增加', 2),
(378, '中級', '下列何者是造成海洋環境產生變化的原因？',  '海水為動態平衡，所以是自身產生變化',  '全球溫度升高，海水溫度也提高', '因為下雨量減少，海水變少', '因季風不斷的吹送，導致海水不斷移動',  2),
(379, '初級', '下列何者是造成海洋主要污染的來源？',  '石油外洩', '自來水管老舊', '農作廢棄物',  '酸雨的下降',  1),
(380, '初級', '下列何者是目前臺灣常常看得到海洋受到污染的情況？', '工廠排放廢熱水',  '船隻漏油', '以海洋拋棄處理國家垃圾',  '鑽油平臺漏油', 2),
(381, '中級', '下列何者「不是」目前在臺灣日常生活中的有毒物質？', '戴奧辛',  '農藥', 'DDT',  '甲苯', 3),
(382, '中級', '下列何者是目前常見的基因改良食品？',  '燕麥', '黃豆', '紅豆', '綠豆', 2),
(383, '中級', '冬季是一氧化碳中毒的高峰期，下列何者是家中熱水器應裝設位置？', '裝設於陽臺，但未通風', '裝設於陽臺，但瓦斯桶放至於室內',  '裝設於室內',  '裝設於室外，且通風良好',  4),
(384, '初級', '下列何種行為會產生噪音？', '亂按喇叭', '用耳機聽音樂', '說話音量適中', '兩人並肩小聲的聊天',  1),
(385, '初級', '尖銳的聲音是屬於下列哪一種頻率？', '低頻率',  '中低頻率', '中頻率',  '高頻率',  4),
(386, '中級', '在日常生活中，空氣污染中的人為污染源為下列哪一種？',  '養殖污染源',  '火山污染源',  '海拋污染源',  '交通污染源',  4),
(387, '中級', '計程車司機可以在沒載乘客之車內抽菸嗎？',  '可以，因為沒有客人',  '可以，因為司機為車輛擁有者',  '不可以，這樣會有礙觀瞻',  '不可以，因為計程車是法規規範交通工具', 4),
(388, '中級', '工廠排放二氧化碳會產生下列哪一種環境災害？',  '臭氧層薄化',  '外來種入侵',  '地球暖化', '地震', 3),
(389, '初級', '下列何者是臺灣主要面臨的環境問題之一？',  '垃圾量逐年減少',  '輻射外洩', '空氣污染嚴重', '降雨日增加',  3),
(390, '中級', '下列何者是造成氣候變化加劇的原因？',  '臭氧層破洞',  '沙塵暴',  '酸雨', '地球暖化', 4),
(391, '初級', '下列何者氣體對於溫室效應影響最大？',  '氟硼酸',  '二氧化碳', '氟化氫',  '一氧化氮', 2),
(392, '中級', '全球溫度上升會使下列何種現象變得更加嚴重？',  '酸雨現象', '聖嬰現象', '日蝕現象', '', 0),
(393, '中級', '下列何者是目前臺灣生物資源遭受威脅的主因？',  '土地過度利用', '因生物彼此競爭大，導致物種減少',  '生物因天擇被淘汰', '遭到人類大量圈養', 1),
(394, '中級', '下列哪一種廢棄物適合在焚化廠中進行焚化處?？', '塑膠類',  '無法再使用之廢棄家具類',  '無法回收再利用的家庭垃圾', '紙類', 3),
(395, '中級', '目前全球淡水資源供給情況如何？',  '很足夠的，因為雨量分布均勻',  '很足夠，因為各國均有大量的水庫',  '很足夠，因為各國均節約使用水資源', '不足夠，因為氣候變遷導致降雨異常', 4),
(396, '中級', '臺灣下雨就容易產生土石流，下列何者「不是?直接原因？', '降雨強度增加', '大型地震造成土石鬆軟', '隨意開發山坡地',  '造林', 4),
(397, '中級', '下列何者是可以在海洋中捕抓的魚類？',  '吳郭魚',  '馬口魚',  '高身鏟頜魚',  '白帶魚',  4),
(398, '中級', '下列哪一項是我們在家中常見的環境衛生用藥？',  '除草劑',  '殺蟲劑',  '洗滌劑',  '洗碗精',  2),
(399, '中級', '臺灣的噪音管制標準是否各地區、各時段皆一致？', '是一樣的，不會受限於地區不同', '是一樣的，不會受限於時間的不同',  '是不一樣的，受限於地區的不同', '是不一樣的，受限時間與地區的不同', 4),
(400, '中級', '下列何者是造成臺灣雨水酸鹼(pH)值下降的原因？', '國外火山噴發', '工業排放廢氣', '森林減少', '降雨量減少',  2),
(401, '初級', '下列何項作法能降低溫室氣體的排放？',  '多蓄養食草動物',  '增加森林面積', '使用大自然產生的化石燃料', '增加該區人口數',  2),
(402, '中級', '全球暖化主要因下列哪種人類行為而產生的？', '燃燒化石燃料', '種植深根植物', '排放含硫化合物',  '使用核能發電', 1),
(403, '中級', '車輛若選擇使用無鉛汽油，將可減少下列哪一種污染的程度？',  '噪音污染', '垃圾污染', '水污染',  '空氣污染', 4),
(404, '中級', '下列何者是避免浪費家中水資源的正確行為？', '使用兩段式沖水馬桶',  '在外面洗完澡再回家',  '洗車用強力水柱清洗',  '衣服拿到自助洗衣店洗', 1),
(405, '中級', '下列何者是清淨家園推動的主要策略？',  '增加清潔隊員', '推廣5S方法的精神與文化', '強迫上網登錄比較成績', '強制企業清潔自己的環境',  2),
(406, '初級', '下列何者是我們到戶外避免蚊蟲叮咬的自我保護方式？', '穿長袖衣褲',  '帶雨傘',  '穿短袖',  '噴香水',  1),
(407, '初級', '下列何者是最好的噪音防治策略？',  '摀住耳朵', '景觀植栽', '改善噪音源',  '離開噪音區',  3),
(408, '初級', '當發生地震時我們要如何自保？', '往房子裡面跑', '跑到海邊去',  '靠近狹窄的馬路',  '躲到堅固的牆角或桌邊', 4),
(409, '中級', '減少空氣污染的做法，下列何者較正確？', '定期保養汽機車',  '在家門口吸菸', '在窗口打板擦', '露天燃燒廢輪胎',  1),
(410, '中級', '發現有人焚燒塑膠或稻草造成嚴重的空氣污染，可以向誰報案？', '記者', '朋友', '環保人員', '家人', 3),
(411, '初級', '下列何者是紫外線過量時，所採取的措施？',  '', '', '多外出運動',  '戴太陽眼鏡，多做防曬', 0),
(412, '中高級',  '減少下列哪一類氣體，最能有效防治酸雨的產生？', '二氧化碳', '硫氧化物', '氟氯碳化物',  '一氧化碳', 2),
(413, '中高級',  '墾丁的珊瑚在下列哪一個季節較容易白化？',  '春季', '夏季', '秋季', '冬季', 2),
(414, '中高級',  '下列何者是海水中含量最多的離子？', '氯',  '鈉',  '鎂',  '溴',  1),
(415, '中高級',  '下列哪一個是海水中主要的化學物質？',  '氯化鈉',  '碳酸鈣',  '磷酸鹽',  '氫氧化鈉', 1),
(416, '中高級',  '下列何者是土石流發生前的徵兆？',  '溪水異常清澈', '山區寧靜', '有異常的山鳴', '動物行為正常', 3),
(417, '中級', '下列何者是過度漁撈後造成的不良後果？', '食物鏈受破壞', '生物生長快速', '資源增加', '經濟快速成長', 1),
(418, '中級', '下列何者是引起過度漁撈現象的原因？',  '從事漁夫人口增加', '撈捕技術進步且消費人口增加',  '政府鼓勵捕撈', '海洋資源取之不盡', 2),
(419, '中高級',  '下列何者是臺灣每年捕獲黑鮪魚數量逐漸減少的原因？', '外來物種入侵', '捕獲技術變差', '過度捕撈', '地下水受污染', 3),
(420, '中高級',  '臺灣西部沿海地層嚴重下陷。下列何者是造成該地區地層下陷的主要原因？',  '超抽地下水',  '位處地震區',  '海平面上漲',  '海邊地質較鬆軟',  1),
(421, '中高級',  '下列何者能解決水污染的問題？', '倒入大量化學物品清淨污水', '大自然有淨化水質的能力，不需要特別去整治', '建立完善的污水下水道系統', '禁止家庭排放廢水', 3),
(422, '高級', '下列何者是地下水污染事件？',  '倫敦煙霧事件', '中國大陸三聚氰胺事件', '美國愛渠事件', '日本七腳川事件',  3),
(423, '中高級',  '下列何者是清淨家園5S中「整頓」的效益？(A)降低作業成本',  '(B)提高工作效率',  '(C)提升工作環境品質(D)激勵工作士氣', '', '', 0),
(424, '中高級',  '下列哪一項因素會降低「清淨家園5S」運動的成效？', '必須全員參與', '貫徹宗旨，實施到底',  '僅有部分人員認同5S宗旨', '最高負責人要親巡活動', 3),
(425, '中高級',  '清淨家園5S改善活動源自於下列哪一個國家？',  '日本', '美國', '加拿大',  '澳洲', 1),
(426, '中高級',  '清淨家園5S所指的區域是下列哪一個場所？', '家',  '學校', '辦公室',  '日常生活中的所有環境', 4),
(427, '中高級',  '下列何者是推動5S的最終目的？',  '學會分類物品', '養成遵守規定，自動自發的習慣', '學會物品歸位', '知道有這個活動',  2),
(428, '中高級',  '下列何者是對於吸入性中毒者施救時該注意的事項？',  '讓患者保留在原地', '口對口人工呼吸',  '打開所有門窗', '給患者飲用牛奶，中和胃部酸性液體', 3),
(429, '中高級',  '下列何者是經常出現在生活中的環境衛生用藥？',  '痛風藥膏', '殺蟲劑',  '香水', '液態瓦斯', 2),
(430, '中高級',  '如果家中發現病媒蟲鼠嚴重肆虐，下列解決方法的選擇何者正確？',  '選擇領有合格病媒防治業許可執照之業者進行驅蟲', '驅蟲後才審視業者所提之計劃書', '驅蟲時不需要有病媒防治業專業技術人在場',  '選擇和自己相熟且價格低廉的業者',  1),
(431, '中高級',  '下列何者是環境衛生用藥進入人體並影響健康的途徑之一？', '飛沫傳染', '病媒傳染', '眼睛黏膜接觸', '血液感染', 3),
(432, '中高級',  '下列何者是殺蟲劑中侵入昆蟲體內並達到殺蟲作用的主要機制？', '麻痹', '觸毒', '暈眩', '興奮', 2),
(433, '中高級',  '下列何者是選擇環境用藥之大原則？', '便宜', '外國進口', '安全', '有名', 3),
(434, '中高級',  '下列何者是自然空氣污染的歷史事件？',  '英國倫敦「黃色濃霧」', '美國洛杉機「光化煙霧」',  '義大利的維蘇威火山暴發',  '世紀之毒戴奧辛',  3),
(435, '中高級',  '我國中央氣象局哪一年開始增加紫外線指數的預報？',  '民國67年',  '民國77年',  '民國87年',  '民國97年',  3),
(436, '初級', '下列何者的環境音量最小？', '狗的叫聲', '正常交談聲',  '飛機引擎聲',  '磨擦樹葉聲',  4),
(437, '中級', '下列何者可以減輕溫室效應？',  '控制溫室氣體排出', '舖設柏油路',  '生產氟氯碳化物產品',  '多吹冷氣降溫', 1),
(438, '初級', '下列哪一個選項能有效減少溫室效應的產生？', '興建綠建築',  '用不含磷的洗潔劑', '開車上下學',  '不抽菸',  1),
(439, '中高級',  '下列何者分布在熱帶的淺海，且有海洋中的熱帶雨林之稱？', '珊瑚礁',  '海灘', '海溝', '海底火山', 1),
(440, '中高級',  '下列哪一個是保存生物多樣性的方式？',  '設立動植物園', '製作標本', '製作生物圖鑑', '製作生物錄影帶',  1),
(441, '中高級',  '如果在集水區需進行開發行為時，以下哪個作為對環境是友善的？',  '水土保持', '整地', '找尋水源', '找尋電源', 1),
(442, '中級', '下列何者是種樹能減少山崩的理由？', '', '', '增加綠美化',  '增加氧氣產生量',  0),
(443, '中級', '下列何者能有效減少或降低家庭污水污染程度？',  '殘油之鍋盤直接清洗',  '使用過量洗衣粉',  '適量使用清潔用品', '使用大量洗碗精去污',  3),
(444, '中高級',  '下列哪一項行為可以避免海洋受到污染？', '建立工廠', '燒烤活動', '建立污水下水道系統',  '興建高速公路', 3),
(445, '中級', '下列何種方式是解決土壤污染最根本的方法？', '用化學藥劑處理',  '使用植物吸附污染物',  '嚴格管制工業廢水的排放',  '把污染的土壤移除', 3),
(446, '初級', '下列哪一種行為在日常生活中可以防止土壤污染？', '不隨便傾倒垃圾',  '有規劃性地進行森林復育',  '使用含磷的清潔劑', '購買具有省水標章的產品',  1),
(447, '中高級',  '關於地震的敘述，下列何者是正確的?',  '距震央愈遠，規模愈大', '臺灣地震是由菲律賓海板塊與印度洋板塊推擠而成', '地層擠壓是發生地震的原因之一', '臺灣超抽地下水，因此地震頻繁', 3),
(448, '中級', '下列何種舉動能有效減少沙塵暴？',  '減少使用冷氣的時間',  '營造防護林措施',  '多興建水庫',  '多看天氣預報', 2),
(449, '中高級',  '水污染是指水因下列何者之介入，而變更品質，影響其正常用途或危害國民健康及生活環境？',  '空氣', '物質', '壓力', '氣候', 2),
(450, '中高級',  '下列何種方法可以減少汽機車所排放的廢氣污染？', '使用國外進口車輛', '改善油品品質', '使用二行程機車代替四行程機車', '打開車內空調', 2),
(451, '中高級',  '下列何者是沙漠化防治的重點？', '種植固沙植物', '加強開墾山林', '種植果樹', '多蓋高樓大廈', 1),
(452, '中高級',  '下列哪一項是大氣層中可提供紫外線有效防護的氣體？', '對流層的二氧化碳', '對流層的水氣', '平流層的臭氧', '對流層的臭氧', 3),
(453, '中高級',  '應降低下列何者的使用率或直接禁用，較有效減緩臭氧層破壞現象？', '含CFCs噴霧劑', '環保冷媒', '洗衣精',  '汽機車',  1),
(454, '中高級',  '下列何者是地球溫度上升帶來的現象？',  '減緩海平面下降的速度', '形成更強烈颶風、颱風及熱帶旋風',  '加速地下水受污染的範圍',  '加速動植物種類繁衍速度',  2),
(455, '中級', '部分太陽輻射穿透大氣層，且能量不斷的在大氣層與地面之間被地表吸收與溢出至外太空，此現象稱為什麼？', '熱島效應', '蝴蝶效應', '溫室效應', '儲熱效應', 3),
(456, '中級', '溫室效應原為一種自然現象，但現在由於下列何種行為使其作用加劇？',  '化石燃料的燃燒',  '增加綠地覆蓋面積', '建立污水處理廠',  '購買環保標章商品', 1),
(457, '中高級',  '控制下列哪一組氣體可降低全球暖化的速度？', '二氧化碳(CO2)、甲烷(CH4)',  '二氧化碳(CO2)、一氧化碳(CO)', '氧氣(O2)、氫氟碳化物(HFCs)', '甲烷(CH4)、一氧化碳(CO)', 1),
(458, '中級', '下列哪一種氣體排放量的增加會使得地球表面溫度上升？',  '一氧化碳(CO)', '氧氣(O2)', '臭氧(O3)', '二氧化碳(CO2)',  4),
(459, '中高級',  '下列何者會加快全球暖化的速度？',  '工業和汽機車排放的廢氣量', '使用不當的捕撈方式',  '大規模種植森林',  '有毒廢棄物傾入土壤',  1),
(460, '中高級',  '下列何者是因為全球暖化使得海水溫度上升所帶來的影響？', '珊瑚白化', '產生酸雨', '產生煙霧', '臭氧層稀薄',  1),
(461, '中高級',  '森林除了供應木材，同時具有水土保持的功能，下列有關森林的敘述，哪一項是正確？', '森林可以吸收二氧化碳', '熱帶雨林生長快速，可以任意砍伐',  '針葉林的生物種類繁多，常有新物種發現', '可以作為生產糧食的地方',  1),
(462, '中高級',  '下列何種森林的降雨量最多，是植物生長最茂密的地區？',  '寒帶針葉林',  '常綠闊葉林',  '熱帶雨林', '溫帶闊葉林',  3),
(463, '中高級',  '生物學家將生物分為五界，下列哪一項不是在五界之內？',  '原核生物界',  '原生生物界',  '真菌界',  '食物界',  4),
(464, '中高級',  '生物學家將生物分為五界，病毒是屬於下列哪一界？',  '不屬於任何一界',  '原生生物界',  '原核生物界',  '動物界',  1),
(465, '中高級',  '下列哪種動物屬於食物鏈中第一級消費者？',  '老虎', '馬',  '狐狸', '老鷹', 2),
(466, '中高級',  '下列何者是目前臺灣中南部養殖業最常用的水資源？',  '地下水',  '湖泊', '海洋', '水庫', 1),
(467, '中高級',  '下列哪一個是大自然中水所提供的功能？', '組織細胞核的主要物質', '讓植物的根立足',  '調節氣候', '提供陸地生物氮氣', 3),
(468, '中高級',  '下列何者是造成臺灣水資源減少的主要因素？', '垃圾不落地',  '土壤沙漠化',  '污水下水道不完善', '臭氧層破洞',  3),
(469, '中高級',  '下列哪一項物質含量過低會造成河川中魚類死亡？', '含鐵量',  '含磷量',  '含氧量',  '含氮量',  3),
(470, '中高級',  '下列何者是造成湖泊優養化的主要化學物質？', '磷酸鹽',  '鐵鹽類',  '碳酸鈣鹽', '鈉鹽', 1),
(471, '中高級',  '下列何者不是水中污染物影響生物生存的原因？',  '降低透光度',  '產生毒性', '降低溶氧', '產生臭氧', 4),
(472, '中級', '請問臺灣最長的河川是哪一條？', '大甲溪',  '', '濁水溪',  '', 0),
(473, '中高級',  '提供臺灣豐富漁業資源的黑潮，是屬於下列哪一類的潮流？', '冷流', '沉降流',  '湧升流',  '暖流', 4),
(474, '中高級',  '下列何者對於「聖嬰現象」描述正確？',  '東太平洋海水溫度降低', '南亞夏季季風雨量增加', '東太平洋熱帶氣旋數增加',  '每年都會發生', 3),
(475, '中高級',  '下列何者是目前造成全球海洋環境產生變化的主因？',  '全球溫度下降', '魚貝種類增加', '陽光強度劇烈變化', '人類的活動影響',  4),
(476, '中高級',  '下列何者是海洋受污染的現象？', '形成紅潮', '臭氧層稀薄化', '溫室效應', '形成黑潮', 1),
(477, '中高級',  '下列何者是受壓地下水層所在的位置？',  '位於兩透水層間之含水層',  '位於兩不透水層間之含水層', '位在兩透水層之上', '位在兩非透水層之下',  2),
(478, '初級', '下列何者是登革熱的傳播媒介？', '水蠆(ㄔㄞˋ)和豆娘', '蟑螂與老鼠',  '埃及斑蚊和白線斑蚊',  '跳蚤與蒼蠅',  3),
(479, '初級', '下列何者是噪音音量的單位？',  '微米(μm)', '加侖(gal)',  '帕(Pa)',  '分貝「dB(A)」',  4),
(480, '中級', '民眾一般說話的音量是下列哪一個分貝數？',  '20分貝', '30分貝', '60分貝', '80分貝', 3),
(481, '初級', '下列何者是噪音對人體健康帶來的影響？', '臂力受損', '心情煩躁', '視力衰退', '骨質疏鬆', 2),
(482, '中高級',  '下列何者是營建工地正常施工作業時的平均音量分貝值？',  '60~80分貝',  '80~110分貝', '110~130分貝',  '超過130分貝',  2),
(483, '中級', '下列何者是大氣臭氧層主要的功用？', '阻擋太空異物入侵', '阻隔紫外線照射',  '維持地球溫度', '提供氧氣呼吸', 2),
(484, '中高級',  '下列何者關於大氣層的說明是正確的？',  '對流層是唯一有氣象變化',  '平流層臭氧量最少', '中氣層隨高度增加溫度增加', '一般可分三層', 1),
(485, '中高級',  '下列何者是環保署評估空氣品質之空氣污染指標？', 'PSI',  '(Pollutant', 'Standards',  'Index)', 0),
(486, '中高級',  '無論從早上到日落以後，城市部分的氣溫都比周邊地區異常的高。下列哪一個是符合此種現象的描述？',  '熱平行',  '熱昇華',  '熱島效應', '溫室效應', 3),
(487, '中高級',  '下列何種職業會長期暴露在極低頻電磁場(主要為電力系統環境)？', '變電所工作者', '清潔人員', '醫師', '警察', 1),
(488, '中高級',  '土壤的顏色主要是受到下列哪一項因素影響？', '地形', '礦物質',  '人類活動', '氣溫', 2),
(489, '中高級',  '如何判別土壤的肥力？', '聞味道來判定', '從內含的營養份來看',  '從土壤結塊的形狀判定', '從土壤密度來判定', 2),
(490, '中高級',  '1950年日本富山縣當地居民罹患「痛痛病」，是下列何種金屬所導致？',  '鎘',  '鎳',  '砷',  '汞',  1),
(491, '中高級',  '下列何者是造成土壤污染的主要污染行為之一？',  '發電廠冷卻的水',  '海水倒灌', '廢水不當排放', '外來種入侵',  3),
(492, '中高級',  '臺灣毒鴨蛋事件是由於鴨群吃下何種污染物質所致？',  '戴奧辛',  '鎘',  '砷',  '汞(ㄍㄨㄥˇ)',  1),
(493, '中高級',  '酸雨較其他空氣污染更難以防治，是由於其具有下列哪一個特性？',  '跨區域性、跨國際性',  '生物累積性',  '系統毒性', '生物多樣性',  1),
(494, '中級', '臺北、高雄是臺灣發生酸雨頻率較高的地方，下列哪一個原因為兩座城市共通點？', '商業繁榮', '交通運輸發達', '歷史文化背景', '綠地多',  2),
(495, '中高級',  '越戰期間，美國大量使用之落葉劑含有下列哪一種物質？',  'TCDD', '重金屬',  '二氧化硫', '三聚氰胺', 1),
(496, '中級', '不生產含有氟氯碳化物之產品是為了減輕下列何種環境問題？',  '臭氧層稀薄化', '砷污染',  '鎘污染',  '汞污染',  1),
(497, '中高級',  '下列何者是全球暖化所導致的現象？', '沿海低窪地區被淹沒',  '地震頻繁', '板塊運動', '海平面下降',  1),
(498, '中高級',  '溫室效應除了二氧化碳之外，也發現下列何種氣體亦可加速全球暖化？',  '氧氣(O2)', '一氧化碳(CO)', '甲烷(CH4)',  '氫氣(H)',  3),
(499, '中高級',  '下列何者對於聖嬰現象的描述有誤?', '沙漠地區雨量暴增', '秘魯境內出現湖泊', '東太平洋魚群死亡', '東太平洋水溫降低', 4),
(500, '中高級',  '下列何者對於全球氣候未來趨勢描述是正確的？',  '赤道地區氣溫增加最多', '南半球地區氣溫增加最多',  '冰雪覆蓋區縮小',  '熱浪發生率下降',  3),
(501, '中高級',  '下列何者是由於海平面上升產生的影響？', '海岸被沖蝕',  '石油危機', '造山運動', '地震頻繁', 1),
(502, '中高級',  '臺灣的地理環境豐富，下列何者「不是」環境敏感地區？',  '自然保護區',  '濕地', '國家公園', '都市', 4),
(503, '中高級',  '極端氣候導致物種消失可能造成下列什麼影響？',  '食物鏈失衡',  '出現紅潮', '海平面上升',  '溫室效應', 1),
(504, '中高級',  '蜜蜂消失後將會造成何種影響？', '農業生態功能崩盤', '人類生存空間減少', '海平面上升',  '溫室效應', 1),
(505, '中高級',  '生物多樣性的減少經常被視為何種現象？', '環境受污染或破壞', '環境改善', '工業發展', '經濟成長', 1),
(506, '中高級',  '下列何者會導致珊瑚礁白化？',  '高溫廢水', '臭氧層破裂',  '噪音污染', '黑潮經過', 1),
(507, '中高級',  '下列何者是導致物種消失的主因之一？',  '噪音污染', '雨林衰減', '設立動植物保護區', '科技進步', 2),
(508, '中高級',  '下列哪一個地區發生土石流的機率最高？', '臺北市中山區', '新竹市北區',  '高雄市六龜鄉', '臺中市西屯區', 3),
(509, '中級', '中亞的鹹海原為世界大湖，但其面積日漸縮小，主要的原因為何？',  '居民過度使用', '臭氧稀薄化',  '滲透進地下水速度過快', '酸雨化造成的自然現象', 1),
(510, '高級', '下列何者是順向坡容易發生山崩的主要原因？', '岩石的下滑力大於摩擦力',  '此類岩層比較鬆散', '此類地質不易種植樹木', '此類地質孔隙大易滲水', 1),
(511, '中高級',  '土石崩落現象多發生在連續大雨後，下列何者是最主要的原因？', '被酸雨侵蝕岩石',  '雨水入滲使岩層間的下滑力增加', '因為有很多樹木枯萎',  '野生動物棲息在內', 2),
(512, '高級', '下列何者是土石流發生的條件之一？', '降雨強度增加', '地下水受到污染',  '種植人工林',  '土壤酸化', 1),
(513, '中高級',  '下列何者是產生熱污染的主要原因？', '用於冷卻過熱機器的水', '家庭污水', '含有排泄物之廢水', '陽光照射', 1),
(514, '中高級',  '「泥、砂石及巨石等和水混合後，受到重力的影響沿著斜坡或河道等路徑，由高處流到低處的現象。」是屬於下列何者的描述？', '火山爆發', '土石流',  '暴風雨',  '龍捲風',  2),
(515, '中高級',  '下列何者是造成珊瑚大量死亡的原因？',  '地震', '外來生物的侵入',  '廢熱水的排放', '海運交通發達', 3),
(516, '中高級',  '下列何者是土石流的特徵？', '大小石頭平均分布', '後端隆起，流量小', '流動速度慢，泥砂濃度低',  '前端隆起，流量大', 4),
(517, '高級', '下列何者是超抽取地下水所造成的問題？', '海平面下降',  '產生優養化',  '出現紅潮', '地層下陷', 4),
(518, '中高級',  '下列何者是土壤中常出現的污染源？', '重金屬',  '氯化鈉',  '碳酸氫鈉', '醋酸', 1),
(519, '中高級',  '下列何者是臺灣土壤污染的主要來源？',  '黑潮', '廢污水',  '輻射外洩', '植樹造林', 2),
(520, '中高級',  '下列何者不是屬於土石流的防災方法？',  '種植大量淺根植物', '疏通排水系統', '阻擋肇災土石', '避開災害敏感區',  1),
(521, '初級', '下列何種方式能有效杜絕蚊子孳生？', '多使用防蚊液', '裝設紗窗、紗門',  '儲水容器要加蓋子', '不使用的衣物要晾乾',  3),
(522, '中高級',  '下列何者是日常生活常見的環境衛生用藥？',  '', '', '戴奧辛',  '殺蟲劑',  0),
(523, '中高級',  '下列何者是依現行「環境用藥管理法」，規範其管理範圍之環境用藥的分類？', '環境衛生預防用藥', '污染防治用藥', '環境用藥血清製劑', '維他命及抗生素',  2),
(524, '中高級',  '下列何者是用於評估地震規模的單位？',  '莫氏規模', '芮氏規模', '凱氏規模', '麥氏規模', 2),
(525, '中高級',  '以下何者為空氣污染中的自然污染源？',  '油漆或揮發性溶劑', '火山爆發', '汽機車排煙',  '石油燃燒', 2),
(526, '中高級',  '下面哪一項是機車排放氣體主要的化學物質？', '氫氧化鈉', '汞',  '一氧化碳', '多氯聯苯', 3),
(527, '中級', '下列何者是因為空氣污染而產生的現象？', '土石流',  '海嘯', '酸雨', '森林大火', 3),
(528, '中高級',  '下列何者是非游離輻射？',  '紫外線',  '粉塵', 'β射線',  '空氣', 1),
(529, '中高級',  '下列何者是沙塵暴發生的原因？', '大片水泥地',  '溫暖潮濕氣候', '無植被或草木生長', '砂石隨意傾倒', 3),
(530, '中高級',  '下列何者是環保署對沙塵暴的監測？', '空氣品質監測', '定時氣溫報告', '天文觀測器',  '網路上的新聞', 1),
(531, '中高級',  '下列何者是沿海養殖漁業過度抽取地下水會引發的現象？',  '颱風數量增加', '地下水鹽化',  '房屋腐蝕', '傳染疾病', 2),
(532, '中高級',  '下列那一種職業會長期暴露在振動環境中而影響身體的健康？',  '警察', '醫生', '礦工', '律師', 3),
(533, '高級', '下列何者是長期暴露於振動使全身容易造成哪些方面的影響？(A)坐骨神經痛(B)腕道症候群(C)白指病(D)間歇性麻痛感', 'ABCD', 'ABD',  'AB', 'ABC',  1),
(534, '中高級',  '下列哪一項「無法」減少汽機車廢氣的排放？', '清潔或更換空氣濾清器', '安裝觸媒轉化器',  '自行改裝排氣管',  '定期做排氣檢查',  3),
(535, '高級', '為何政府要建設污水下水道？',  '可大量提高化糞池的效率',  '讓污水直接排入河川',  '防治河川污染', '', 0),
(536, '中高級',  '在酸雨相當嚴重的城市蓋房子，下列何者是較適合的建材？', '石灰岩',  '石版', '大理石',  '瓷磚', 4),
(537, '中高級',  '氟氯碳化物為《蒙特婁公約》規範管制的化學物質，下列何種產品含有此種物質？', '洗髮精',  '輪胎', '冷媒', '水泥', 3),
(538, '中高級',  '下列何種方式可避免熱島效應的產生？',  '選用可回收產品',  '增加綠樹及綠地面積',  '多塗防曬油',  '長時間使用冷氣機', 2),
(539, '中高級',  '下列哪一個說明人類生活環境受氣候變遷影響？',  '旱澇等極端氣候',  '地震頻繁', '交通阻塞', '能源浩劫', 1),
(540, '中高級',  '二氧化碳為溫室氣體排放最大宗，以臺灣為例，採用下列何種交通方式排放量較低？',  '騎摩托車', '騎腳踏車', '自己開車', '搭乘計程車',  2),
(541, '中級', '下列何者為雨林減少的主要原因？',  '人為砍伐', '溫室效應', '聖嬰現象', '臭氧層破裂',  1),
(542, '中高級',  '如何減少全球漁業資源逐年下降的現象？', '不在本地而到國外去捕魚',  '把漁網的網目變小', '採用流刺網捕魚',  '實施階段性的休漁', 4),
(543, '中高級',  '土壤被污染會導致下列何種結果？',  '傳染疾病和熱污染', '可能會影響飲用水安全', '溫室效應和熱島效應',  '聖嬰和反聖嬰現象', 2),
(544, '中高級',  '下列何者是土壤污染主要的來源之一？',  '生活污水排入污水下水道系統',  '過度使用農藥、肥料',  '冷氣排放水',  '工廠排放廢氣', 2),
(545, '中高級',  '在五金行買來的強力膠中主要有下列哪一種會對人體產生危害的化學物質？',  '甲苯', '乙苯', '甲醛', '乙醛', 1),
(546, '中高級',  '家中擺放的殺蟲劑所具有的潛在危害，下列何者說明為是？', '因為殺蟲劑會自己擴散到外面',  '孩童不慎誤食', '藉由傳媒(蚊蠅)引起食物中毒', '引發精神疾病', 2),
(547, '高級', '民國97年中國大陸發生的毒奶粉事件，不法商人加入的是下列哪一種化學物質？', '多氯聯苯', 'DDT',  '三聚氰(ㄑㄧㄥ)胺',  '甲醛(ㄑㄩㄢˊ)', 3),
(548, '中高級',  '下列何者是沙塵暴產生的影響？', '減少空氣中的懸浮物質', '破壞植物生長', '造成溫室效應', '腐蝕房屋', 2),
(549, '初級', '臺灣降雨量豐富，為何仍有缺水的現象，下列何者是正確的？',  '地形陡峭，大部分的雨水都迅速地流入海洋',  '降雨時空分布平均', '大部分雨水直接流入下水道', '人口不足', 1),
(550, '初級', '落實資源回收對環境帶來什麼好處？', '提高資源消耗量',  '減少垃圾量並減少污染', '加速暖化效應', '增加酸雨發生機率', 2),
(551, '中級', '下列何者是屬於可以回收的「塑膠容器」？',  '玻璃瓶',  '寶特瓶',  '鐵罐', '鋁罐', 2),
(552, '中高級',  '下列何者是屬於廢棄物清理法所規定的廢資訊物品？',  '廢電視機', '廢印表機', '廢照明光源',  '廢乾電池', 2),
(553, '中高級',  '下列哪一種廢棄物「不屬於」可回收項目？',  '廢輪胎',  '廢資訊物品',  '廢玻璃容器',  '陶瓷花瓶', 4),
(554, '中高級',  '天然災害發生後所?棄的廢棄物，應如何處理？',  '家戶部分可隨意丟棄，等待政府處理', '家戶部分由當地環保局或清潔隊處理', '事業部分由環保清潔隊處理', '事業部分由里長處理',  2),
(555, '高級', '您知道學校飲水機在正常使用的情況下應多久清洗維護一次？',  '一個月',  '三個月',  '六個月',  '一年', 1),
(556, '高級', '您知道家中水塔、水池在正常使用的情況下應多久清洗維護一次？',  '半年', '一年', '二年', '三年', 1),
(557, '高級', '下列哪一種方法可以防止土壤污染？', '對於有污染之虞的加油站專案列管',  '用海水冷卻機器',  '生活用水減量', '隨手關燈', 1),
(558, '中高級',  '民眾何時會使用到環境衛生用藥？',  '家中出現蚊子', '舒緩疲勞的芳香精油',  '生病去看醫生', '身上噴的香水', 1),
(559, '中高級',  '空氣污染對植物帶來下列哪一種影響？',  '降低光合作用', '細胞生長速率提高', '缺少水分', '葉綠素量增加', 1),
(560, '中級', '下列哪一個可以有效改善室內的空氣污染？',  '購買紗窗、蚊帳',  '常開冷氣', '噴灑空氣清香劑',  '增加良好的通風設施',  4),
(561, '中高級',  '下列何者屬於人為紫外線？', '無線電',  '殺菌燈',  '微波爐',  '電腦顯示器',  2),
(562, '中高級',  '游離輻射對人體可能帶來什麼傷害？', '糖尿病',  '癌症', '登革熱',  '腸胃炎',  2),
(563, '中級', '在市區中看見快速道路兩旁建有兩排阻隔牆，其主要作用為何？', '降低對附近居民所造成的噪音',  '阻隔動物闖進馬路', '減少民眾家中的灰塵',  '阻隔民眾亂丟垃圾', 1),
(564, '中高級',  '下列哪一項是《蒙特婁公約》中規範的化學物質？', '二氧化碳', '多氯聯苯', 'DDT',  '氫氯氟碳化物', 4),
(565, '中級', '《京都議定書》中規範下列何種溫室氣體？',  '二氧化碳(CO2)',  '氧氣(O2)', '一氧化碳(CO)', '臭氧(O3)', 1),
(566, '高級', '《京都議定書》規範各個國家可以透過購買下列哪一項權益，而達到全球暖化減輕目標？',  '二氧化碳排放權',  '一氧化碳排放權',  '最佳可行技術', '空氣污染防治設備', 1),
(567, '高級', '《京都議定書》規定開發國家到哪一年平均二氧化碳排放量需比1990年減少5.2%？', '1995年',  '2010年',  '2012年',  '2030年',  3),
(568, '高級', '下列何者是聯合國為了防止海洋生物受到人為活動威脅，而設立的國際公約？', '《聯合國海洋法公約》', '《維也納公約》',  '《巴塞爾公約》',  '《保護世界遺產公約》', 1),
(569, '中高級',  '遊客進入玉山國家公園生態保護區需要申請，這是依據下列何種法規條例？',  '生態保育法',  '國家公園法',  '野生動物保育法',  '生物多樣性法', 2),
(570, '中高級',  '遊客進入水庫區，若未經申請許可就捕捉保育類野生動物，將觸犯下列何種法規？', '國家公園法',  '生態保育法',  '野生動物保育法',  '生物多樣性法', 3),
(571, '中級', '汽機車排放黑煙或白煙，若經勸導仍未改善，會依據下列何種法規處以罰鍰？', '水污染防治法', '廢棄物清理法', '空氣污染防制法',  '環境教育法',  3),
(572, '中高級',  '訂定環保法規是基於下列哪一個原因？',  '環境是大家共有的', '環境是屬於政府單位的', '環境是屬於民眾的', '環境是屬於野生動物的', 1),
(573, '高級', '家庭污水經污水下水道至污水處理場進行處理後，需符合下列何種法規訂定的標準才能排放至河川？', '《廢棄物清理法》', '《空氣污染防制法》',  '《水污染防治法》', '《環境教育法》',  3),
(574, '中級', '為了解決環境髒亂的問題，縣市政府紛紛推行「垃圾不落地」，此政策依據下列何種法規實施？', '空氣污染防制法',  '水污染防治法', '廢棄物清理法', '環境教育法',  3),
(575, '中高級',  '若要進行環境影響評估的開發行為，下列哪一項是重點評估項目？',  '對生態環境的衝擊', '增加營利', '增加知名度',  '促進鄉村都市化',  1),
(576, '中高級',  '下列何者需進行環境影響評估？', '建築高速鐵路', '在室內舉辦演唱會', '舉辦單車日',  '在社區公園舉辦舞會',  1),
(577, '中高級',  '開發行為是依據下列何者理由需要進行環境影響評估？', '對環境有不良影響', '位於人口密集處',  '可以幫助保護動植物',  '以上皆是', 1),
(578, '高級', '下列何種指標系統參數可監測PM10、NO2、SO2以提供民眾或單位機構做參考？',  'CSI',  '(Certified', 'Standard', 'Index)', 0),
(579, '高級', '下列何種指標系統主要監測BOD5、DO、SS、NH3-N以提供民眾或單位機構做參考？', 'WQI',  'PSI',  'RPI',  'CSI',  3),
(580, '中高級',  '臺中市清水鄉高美溼地在99年因下列何種公害而重度影響當地生態環境？',  '油污污染', '空氣污染', '噪音污染', '飲水污染', 1),
(581, '中高級',  '汽機車所使用的油品，於銷售時同時徵收的是下列何種費用？',  '水污費',  '土污費',  '空污費',  '噪音費',  3),
(582, '中高級',  '1998年臺塑公司將一批汞污泥送往柬埔寨，並棄置在海邊，造成當地民眾多人不適，引起國際喧然大波，這種行為違反下列哪一項國際公約？', '凡爾賽條約',  '蒙特婁公約',  '氣候變化綱要公約', '巴塞爾公約',  4),
(583, '中高級',  '下列何者是申請有害廢棄物輸出的正確方法？', '有害廢棄物輸出前，輸出國不需通知接受國',  '申請者須出具接受國主管機關同意該有害廢棄物輸入之文件', '輸出國不用確認接受國有處理該有害廢棄物的能力及設施',  '有害廢棄物輸出前，只需接受國之企業同意即可',  2),
(584, '初級', '下列哪一天是世界水質監測日活動？', '3月18日',  '6月18日',  '10月18日', '12月18日', 3),
(585, '高級', '放流水標準規定每年的5月~9月期間，排放水的水溫最高溫度不得高過攝氏幾度？',  '36℃',  '37℃',  '38℃',  '39℃',  3),
(586, '高級', '當外國船隻至本國海域產生污染時，其未完成賠償義務時，得限制其離境，是根據下列哪一條法律？', '《土壤及地下水污染整治法》',  '《水污染防治法》', '《環境影響評估法》',  '《海洋污染防治法》',  4),
(587, '中高級',  '一般環境衛生用藥如殺蟲劑，需要經過政府哪個單位核准，才能製造', '、加工、輸入？',  '', '', '衛生署',  0),
(588, '中高級',  '下列哪一個國際環境保護公約，是針對有害廢棄物越境轉移進行規範？',  '倫敦公約', '京都議定書',  '巴塞爾公約',  '華盛頓公約',  3),
(589, '中高級',  '下列何者是環保署用以評估臺灣河川水質的指標？', 'PM10', 'RPI',  'PSI',  'O3', 2),
(590, '中級', '臺灣法律對於下列何種噪音會採取處罰？', '在捷運上講手機',  '戴耳機聽音樂', '汽機車消音器拆除', '在KTV唱歌唱很大聲', 3),
(591, '高級', '下列何種法規是目前臺灣沒有特別公告的？',  '噪音管制法',  '水污染防治法', '振動管制法',  '環境影響評估法',  3),
(592, '中高級',  '下列何者是華盛頓公約的內容？', '管制破壞臭氧層物質',  '抑制氮氧化物排放', '管制因船舶、海洋設施等所造成的海洋污染',  '管制國際間野生動植物貿易手段', 4),
(593, '中高級',  '下列何種是環境衛生用藥會使用的成分？', '有機汞',  '有機鉛',  '除蟲菊精', '戴奧辛',  3),
(594, '中高級',  '避免熱島效應的產生，民眾消費方式可以做什麼改變？', '購買具有節能標章的冷氣',  '購買二手電器用品', '購買二手車',  '購買回收紙產品',  1),
(595, '中高級',  '人類面臨全球暖化的危機，下列何者是民眾可以從生活中降低二氧化碳的排放量？', '多乘大眾運輸工具', '多開小汽車',  '多使用冷氣',  '多買包裝華麗的東西',  1),
(596, '中高級',  '民眾在日常生活中需要做下列何者以減緩氣候變遷？',  '推動計程車共乘',  '增加購買新衣物頻率',  '增加自行開車次數', '減少選擇直航班機', 1),
(597, '中級', '下列何種發電方式主要增加二氧化碳的產生量？',  '風力發電', '太陽能發電',  '火力發電', '水力發電', 3),
(598, '中高級',  '下列何種方式可改善交通運輸工具所產生的二氧化碳排放量？',  '減少自行開車的頻率',  '改裝汽機車，增加效能', '買外國進口的汽車', '用含鉛汽油',  1),
(599, '中級', '政府若要改變能源結構，可以投資哪些能源產業以降低二氧化碳的排放量？',  '石油', '風力、水力',  '天然氣',  '煤碳', 2),
(600, '中高級',  '炎炎夏日該如何使用冷氣較為恰當？', '打開冷氣，使室內溫度維持在22.', '8度C',  '打開冷氣，使室內溫度維持在16度C',  '打開冷氣，使室內溫度維持在30度C',  0),
(601, '中高級',  '以下何者是政府與企業間為了有效減少二氧化碳而彼此合作？',  '多蓋火力發電廠',  '輔導訂定二氧化碳排放減量', '建立新焚化爐', '增設石化產業', 2),
(602, '中高級',  '節能減碳風行，許多觀光地區提供下列何種交通工具響應此綠色活動？',  '腳踏車',  '遊覽車',  '機車', '汽車', 1),
(603, '中高級',  '下列何種行為稱得上是節能減碳？',  '腳踏車作為代步工具',  '購買更換率高的產品',  '多搭乘電梯',  '室外溫度達到25度就開冷氣',  1),
(604, '中高級',  '家中電扇需進行更換，你可以選擇下列哪一種類型的電扇較為環保？', '最便宜',  '轉速最快', '有節能標章產品',  '電扇體積大',  3),
(605, '中級', '臺灣餐飲業若要落實節能減碳，下列何項作法正確？',  '餐廳提供環保餐具', '推出促銷商品', '使用免洗湯匙', '多使用塑膠袋包裝食物', 1),
(606, '中高級',  '下列何者為山坡地開發所帶來的影響？',  '引進外來生物', '氣溫變高', '破壞水土保持', '產生傳染病',  3),
(607, '中高級',  '土地過度開發時，原地區的野生動植物會受到下列哪方面的影響？',  '破壞棲息環境', '增加繁殖數目', '生存空間變大', '食物來源增加', 1),
(608, '初級', '民眾可以透過下列何種方式達到減少資源浪費？',  '自備購物袋',  '向店家要塑膠袋',  '使用免洗餐具', '購買用完丟棄商品', 1),
(609, '中高級',  '下列何者被規列為應優先採購環保標章產品？', '家庭', '公立學校', '寺廟', '工廠', 2),
(610, '中高級',  '下列何者對綠色採購的敘述是正確的？',  '目的是保護野生動物',  '正式立法並對全民強制推動', '公營單位、政府機關優先採購',  '為買到便宜產品而訂定', 3),
(611, '中高級',  '以下何者是綠色採購的原則？',  '考慮該產品是否有前膽性',  '考慮產品生命週期對環境的各種衝擊', '選擇用心照顧成本的供應商', '收集產品及供應商的資金資訊',  2),
(612, '中高級',  '關於再循環與再生之間的差異，下列何者說明正確？',  '兩者都是環保4R，沒有差異',  '前者是改變其形態的再利用', '後者是不改變其形態的再利用',  '後者是改變其形態的再利用', 4),
(613, '初級', '我們在購買商品時，下列何者是我們應該有的行為？',  '購買拋棄式餐具',  '購買含聚丙烯(常見的塑膠容器材質)的產品', '購買有環保標章的產品', '購買過度包裝的產品',  3),
(614, '中高級',  '下列何者屬於企業環保責任的範圍？', '增加生產步驟', '增加生產原料', '增加商品的利潤',  '環保化設計',  4),
(615, '中高級',  '下列何者是工廠在製造商品時，應該要負起對環境保護的責任？', '', '', '產品使用方便', '產品便宜', 0),
(616, '初級', '下列何者能減少水資源的浪費？', '用淋浴代替盆浴',  '洗車用水管沖洗',  '洗碗時水龍頭水閥開到最大', '使用地下水代替自來水', 1),
(617, '中高級',  '下列何者是海洋污染對臺灣國民帶來的影響？', '魚獲量增加',  '水產受污染',  '海洋面積減少', '產生海水倒灌與海嘯',  2),
(618, '初級', '我們到海邊做出下列何者行為會破壞海洋生態？',  '不隨處丟棄垃圾',  '成為保護海洋志工', '過量撈獲海洋生物', '進行生態旅遊', 3),
(619, '中高級',  '下列何者是我們在購買環境用藥時需要注意的事項？',  '注意商品是否為進口貨', '注意應有環保署核發許可之字號', '注意包裝的精美度', '以上皆非', 2),
(620, '中高級',  '下列何者行為是使用環境用藥時該注意的事項？',  '可自行調配多種混用以加強效果', '大量且廣泛噴灑',  '儲存於冰箱中', '仔細閱讀使用說明', 4),
(621, '中高級',  '下列何者是形成沙塵暴的原因？', '過度耕作', '建造道路', '建造水庫', '種植森林', 1),
(622, '中高級',  '下列何者是地層下陷產生的影響？',  '農地不易耕種', '增加土壤肥沃度',  '增加外來生物', '增加地下水含量',  1),
(623, '中高級',  '下列何種途徑可以讓民眾知道沙塵暴的消息？', '教育部的公布欄',  '環保署的空氣監測網站', '內政部的諮詢信箱', '警察局的網站', 2),
(624, '中高級',  '在全球暖化的危機中，臺灣民眾可以採取下列哪些正面的行動？', '響應節能減碳', '多消費拼經濟', '到國外避難',  '多打掃房屋',  1),
(625, '中級', '下列何種環保措施不是屬於政府可以做的？',  '調整產業結構', '調整交通運輸系統', '調整能源結構', '調整天災頻率', 4),
(626, '中高級',  '下列何種方式在校園內可以節省能源？',  '多乘電梯，少走樓梯',  '裝設自動感應照明', '空調設定於20~23度',  '共乘計程車',  2),
(627, '初級', '環境保護是下列何者的責任？',  '只有政府單位', '只有民眾', '野生動植物',  '所有環境資源的使用者', 4),
(628, '中高級',  '下列何者是永續發展的理念？',  '產品無法回收', '資源有限度的利用', '資源浪費', '能源過度使用', 2),
(629, '中高級',  '綠色產品的指標是下列哪三項？', '低污染、可回收、省資源',  '省錢、省資源、省時間', '可再生、可回收、可利用',  '低污染、省資源、省時間',  1),
(630, '中高級',  '消費者可以透過哪一項管道得到相關環保產品的資訊？', '環保署綠色生活資訊網', '經濟部能源局', '財政部稅捐處', '戶政事務所',  1),
(631, '中高級',  'GreenPeace組織的中文名稱是什麼？',  '綠色和平組織', '環境保護組織', '反溫室效應組織',  '環境保育組織', 1),
(632, '中高級',  '下列何者是清淨家園5S所推廣的？', '努力', '用功', '勤勞', '整頓', 4),
(633, '中高級',  '下列何者是可以直接預防振動對身體產生傷害的方法？', '定期做柔軟體操',  '常常到郊外踏青',  '減少處於振動的時間',  '多補充水份',  3),
(634, '中高級',  '若要提高全民的生態保護意識，可增強下列哪些環境意識？', '生產成本和經濟獲利的觀念', '樹立可持續發展的觀念', '個人利益至上的觀念',  '自掃門前雪的觀念', 2),
(635, '高級', '下列何者是目前臺灣最主要的淡水資源？', '地下水',  '湖泊', '海洋', '河川', 4),
(636, '高級', '下列何者是河川污染指標的英文縮寫？',  'PSI',  'RPI',  'UVI',  'DO', 2),
(637, '高級', '在臺灣河川中找到下列哪一種魚代表其河川水質良好？', '?(ㄍㄨˋ)魚',  '虱目魚',  '吳郭魚',  '金錢魚',  1),
(638, '高級', '依據河川污染指標(RPI)將污染程度劃分為幾大類別？', '3個類別', '4個類別', '5個類別', '6個類別', 2),
(639, '高級', '下列何者為水利法所規定擁有最先使用水權者？',  '水運用水', '農業用水', '民生用水', '一般工業用水', 3),
(640, '高級', '在河川中找到下列哪一種魚代表其河川水質受到嚴重污染？', '鱒魚', '吳郭魚',  '?魚', '香魚', 2),
(641, '高級', '行政院組織再造完成前，水土保持的業務是歸哪一個政府部門？', '林務局',  '環保署',  '農委會',  '中央氣象局',  3),
(642, '高級', '臺灣處理家庭污水之污水處理廠，依處理總水量而言，主要以幾級處理為主？', '一級處理', '二級處理', '三級處理', '四級處理', 1),
(643, '高級', '下列何者是我們常見的海洋污染？',  '焚化廠的灰飛直接傾倒入海洋',  '船隻因意外而漏油', '汽機車漏油',  '夾帶大量泥沙的河川流入海洋',  2),
(644, '高級', '下列何者是倫敦廢棄物投棄公約訂定禁止海洋投棄之物質？', '', '氫化物',  '有機氯化物',  '明礬', 0),
(645, '高級', '當外國船至本國海域產生污染時，其未完成賠償義務時，是否可以限制其離境？',  '可以', '不可以',  '需視與該國有無邦交',  '視該國有無簽署倫敦公約',  1),
(646, '高級', '下列何者是目前海洋最主要面臨的污染來源？', '土石流',  '地面水體夾帶污染物流入海洋',  '酸雨污染', '過多廢熱進入海水，使整體海水溫度增加', 2),
(647, '高級', '下列何者是河川三大機能中的治水機能？', '水利發電能源', '供應民生用水', '宣洩洪水', '供應農業用水', 3),
(648, '高級', '下列何者是卡爾森優養化指標(CTSI)所需測定項目？', '濁度', '水中葉綠素a', '水溫', 'pH值',  2),
(649, '高級', '下面哪一個是解決造成優養化重要元素氮的方法？', '加入石灰', '加入酸',  '加入硝化菌與脫硝菌',  '加入硫化鋁',  3),
(650, '高級', '下列何者是水庫優養化的化學防制措施？', '曝氣循還法',  '前壩法',  '混凝沉降法',  '生物性吸收法', 3),
(651, '高級', '海洋之外，地球上各儲水層之含水量的比例，由大至小的排列是？',  '地下水>冰層>土壤>大氣', '土壤>地下水>大氣>冰層', '大氣>土壤>地下水>冰層', '冰層>地下水>土壤>大氣', 4),
(652, '高級', '下列何者為卡爾森優養化指標(CTSI)正確的分級標準？',  '30~50為貧養', '50~60為優養', '目前沒有普養標準', '60以上為超優養', 2),
(653, '高級', '海洋環境的變遷對環境會造成什麼影響？', '全球溫度略降', '魚貝種類增加', '氣候劇烈變化', '空氣中二氧化碳量降低', 3),
(654, '高級', '土壤污染物可概分為有機污染物與無機污染物兩大類，下列哪一項是兩者的差異？', '有機污染物可被生物分解',  '有機污染物不易被生物分解', '無機污染物易被生物分解',  '無機污染物與有機污染物特性相同',  1),
(655, '高級', '下列何者是日常生活常見的環境用藥？',  '全氟碳化物',  '海龍滅火器',  '除蟲菊精', '多氯聯苯', 3),
(656, '高級', '下列哪一種毒性化學物質需取得許可、登記備查、核可等證照才能逕行使用？', '乙苯', '甲醛', '醋酸乙烯酯',  '甲基第三丁基醚',  2),
(657, '高級', '毒性化學物質的劑量超過標準便會對人體產生危害，下列何者的劑量算法是對的？', '其濃度超過一定標準對人將產生危害', '每公斤人體重(kg)攝取多少毫克(mg)會產生危害',  '每公升的液體含有多少毫克(mg)會產生危害',  '每公升的氣體含有多少毫克(mg)會產生危害',  2),
(658, '高級', '下列何者是使用電動車帶來的直接正面影響？', '大眾運輸蓬勃發展', '增加汽油銷售', '電動機車使用無鉛汽油，可減少污染', '減少空氣污染', 4),
(659, '中高級',  '下列何者是酸雨對於人類的危害？',  '土壤礦化', '有毒重金屬釋出',  '土石崩解', '地層下陷', 2),
(660, '高級', '關於溫室效應的描述，何者為正確？', '溫室效應是人為所造成的',  '溫室效應是大氣層產生的',  '是人為和自然共同產生的',  '溫室效應是太陽一直放出過多的熱所造成的',  3),
(661, '高級', '下面哪一個縣市目前已有環保科技園區？', '臺中市',  '屏東縣',  '高雄市',  '新竹縣',  3),
(662, '高級', '下列何者為優先預防而非避免污染物產生之法規？', '放流水標準',  '環境影響評估法',  '空氣污染防制法',  '廢棄物清理法', 2),
(663, '高級', '根據統計，全球資源目前大都被哪類型國家消耗？', '已開發',  '發展中',  '未開發',  '低度開發', 1),
(664, '高級', '下列何者是臺灣匯集各方意見制定永續發展原則的政府單位？',  '行政院環保署', '行政院教育部', '行政院國家永續發展委員會', '行政院經濟部', 3),
(665, '高級', '許多公約我國並未簽署，但我們為配合國際環保趨勢做了哪些努力？', '生產氟氯碳化物產品',  '鼓勵購買貼有環保標章的商品',  '工廠遷廠', '禁止生產竹筷', 2),
(666, '高級', '下列何者「不是」目前外來種入侵的主要方式？',  '被人類刻意引進',  '生物進入交通工具進行移動', '人類沾黏花或植物的種子',  '藉由大自然的力量進行遷移', 4),
(667, '高級', '下列何者對生物濃縮作用的描述是正確？', '毒性物質存留於生物組織內累積', '毒性物質藉由食物鏈累積濃度',  '毒性物質藉由食物鏈降低毒物量', '毒性物質藉由生物體分解消失',  2),
(668, '高級', '有關生物累積作用(Bioaccumulation)的描述，下列何者正確？', '毒性物質存留於空氣中而累積濃度',  '毒性物質藉由食物鏈累積濃度',  '毒性物質藉由食物鏈，毒物量減少',  '毒性物質不會藉由食物鏈，毒物量增加',  2),
(669, '高級', '在環境影響評估委員會中專家學者不得少於委員會總人數之多少？',  '五分之二', '四分之一', '三分之二', '二分之一', 3),
(670, '高級', '開發案通過環境影響評估審查後，涉及環保事項之變更，無需重新進行環境影響評估者，應該提出什麼資料送審？', '環境地質變更報告', '環境生態調查書',  '環境影響差異分析報告', '環境設施變更報告', 3),
(671, '高級', '在申請案件內，下列何者是屬於環保陳情案件？',  '工廠偷排廢水', '滋生有害昆蟲', '動物吠叫', '濫砍森林', 1),
(672, '高級', '2009年法國大導演盧貝松為了環保製做了一部影片，下列何者是該影片的名稱？',  '不願意面對的真相', '2012', '拯救地球', '明天過後', 3),
(673, '高級', '下列哪一個是環保宣導片「不願面對的真相」主要探討的議題？', '雨水酸化', '嚴重沙漠化',  '臭氧層逐漸消失',  '全球暖化', 4),
(674, '高級', '下列何者對BOO（Build-Operate-Own, 建設-營運-擁有）的描述是正確的？',  '政府提供設施土地，民間出資興建',  '民間提供設施土地，政府出資興建',  '由民間出資興建並擁有設施之財產權', '政府出資興建，民間管理',  3),
(675, '高級', '下列何者對BOT（Build-Operate-Transfer, 建設-營運-轉讓）的描述是正確的？', '政府提供設施土地，民間出資興建',  '民間提供設施土地，政府出資興建',  '由民間出資興建並擁有設施之財產權', '政府出資興建，民間管理',  1),
(676, '高級', '下列何者是歐盟訂定之「有害物質禁用指令」(RoHS)所禁用之物質？',  '禁用鉛',  '禁用銀',  '禁用銅',  '禁用錫',  1),
(677, '中高級',  '下列何者是土壤及地下水污染整治基金的經費來源？',  '土壤及地下水污染整治費收入',  '營業稅收入',  '全民健保費收入',  '向中央銀行借貸',  1),
(678, '高級', '下列何者是颱風豪雨期間發布的土石流黃色警戒？', '某地區的預測雨量大於當地的土石流警戒基準值',  '某地區的預測雨量小於當地的土石流警戒基準值',  '某地區的實際降雨小於當地的土石流警戒基準值',  '某地區的實際降雨大於當地的土石流警戒基準值',  1),
(679, '高級', '下列何者是世界企業永續發展委員會所認定的「生態效益」之要素？', '增加商品和能源使用的密集度',  '減少原料的可塑性', '減少有毒物的擴散', '減少服務的耐久性', 3),
(680, '中高級',  '請問臺灣蓄水量最大的水庫是哪一座？',  '曾文水庫', '', '石門水庫', '翡翠水庫', 0),
(681, '高級', '水中懸浮固體物濃度過高對水域之生態有何影響？', '有助於溶氧提升',  '有利水生植物進行光合作用', '大部分魚類不易生存',  '提高水生植物固碳作用', 3),
(682, '高級', '了解水域環境除了使用河川污染指標(RPI)之外，還可配合下列哪一個做為指標？', 'WQI',  'PSI',  'ERI',  'CSI',  1),
(683, '高級', '根據海洋放流水標準中溫度規範，排放於海洋者溫度應低於攝氏幾度以下？',  '38度',  '40度',  '42度',  '44度',  3),
(684, '高級', '根據放流水標準中放流水排放到河川時，其溫度在冬季時要在攝氏幾度以下？', '32度',  '34度',  '35度',  '36度',  3),
(685, '高級', '下列何者是因為溫排水排放所造成的影響？',  '', '', '易產生黑潮',  '生物種類增加', 0),
(686, '高級', '下列何者場域所排的水，其平均溫度較其他場域排放水來的高？', '家庭污水', '核電廠之冷卻水',  '醫院廢水', '水力發電廠之發電用水', 2),
(687, '高級', '下列那一種的海水變化，會造成珊瑚大量死亡？',  '海水溫度提高', '海水鹽度提高', '海水溶氧提高', '海水電解度降低',  1),
(688, '高級', '下列何者是一般用來判斷海水入侵地下水的依據？', '鎂離子濃度',  '鈣離子濃度',  '氯離子濃度',  '氫離子濃度',  3),
(689, '高級', '下列何者是目前我們常見的土壤污染？',  '土壤軟化', '土壤酸化', '熱廢水污染',  '土壤礦化', 2),
(690, '高級', '下列何者是岩石風化的物理作用？',  '水合作用', '溶解作用', '還原作用', '溫度變化', 4),
(691, '高級', '下列何者對於土壤受到污染的描述是正確的？', '土壤受污染會降低其催化化學毒素能力，但不影響涵養水分', '土壤受污染會降低其催化化學毒素的能力，同時影響涵養水分',  '土壤受污染不會降低其催化化學毒素能力，也不會影響水分的涵養',  '土壤受污染不會降低其催化化學毒素的能力，但會影響涵養水分', 2),
(692, '高級', '如果廢水排放要以直接排入土壤的方式，需符合以下何者標準？', '排放標準', '土壤處理標準', '總量管制標準', '土壤排放標準', 2),
(693, '高級', '新買的衣櫃或家具中可能含有何種化學物質而對人體產生危害？', '甲醛', '甲酮', '甲醇', '甲酸', 1),
(694, '高級', '下列何項國際環保公約主要提倡世代公平的原則？', '赫爾辛基宣言', '里約宣言', '那德威克宣言', '索非亞協定',  2),
(695, '高級', '下列何者是「二十一世紀議程」內容所涵括的四大項中的一項？', '六星計畫', '加強文化保存', '各族群作用與參與', '維護鄉土特色', 3),
(696, '高級', '聯合國所發表的「二十一世紀議程」(Agenda',  '21)的意義為何？',  '發展宇航技術', '推動永續發展', '解決全球金融危機', 0),
(697, '高級', '1992', '年聯合國在巴西里約的地球高峰會中宣佈森林原則(forest',  'principle)，其中特別強調項目為下列何者？',  '企業評估原則', '地方影響原則', 0),
(698, '高級', '下列何項國際條約是為了維護森林環境？', '巴塞爾公約',  '赫爾辛基宣言', '森林原則', '海牙宣言', 3),
(699, '高級', '《拉姆薩爾公約》中特別強調要保護下列何種動物的棲息地？',  '雲豹', '水鳥', '北極熊',  '大象', 2),
(700, '高級', '下列何項國際條約是維護溼地環境？', '華盛頓公約',  '拉姆薩爾公約', '那德威克宣言', '世界文化及自然資產保護公約',  2),
(701, '高級', '下列哪一項人為因素可能導致森林衰退？', '', '', '火山噴發', '林地大量變成農耕地',  0),
(702, '高級', '下列何者是被世界自然保護聯盟，列入全球100種最具危害之外來入侵物種?',  '小花蔓澤蘭',  '五葉松',  '檜木', '木賊', 1),
(703, '高級', '下列何項國際約定是針對現今生物技術及基因改造對生物多樣性的衝擊加以維護？', '生物安全議定書',  '鹿特丹公約',  '華盛頓公約',  '維也納公約',  1),
(704, '高級', '《華盛頓公約》以下列何種方式保護稀有或瀕臨絕種動植物？',  '管理野生動植物之捕殺', '管理野生動植物之貿易', '管理野生動植物之擁有權',  '僅開放部分時間提供捕獵',  2),
(705, '高級', '下列何者是國際對野生動植物保護的條約？',  '鹿特丹公約',  '華盛頓公約',  '赫爾辛基協定', '斯德哥爾摩公約',  2),
(706, '高級', '下面何項國際條約是以維護動植物多樣性為主要目的？', '赫爾辛基宣言', '巴塞爾公約',  '生物多樣性公約',  '氣候變化綱要公約', 3),
(707, '高級', '環保署設置空氣品質監測除了針對空氣污染指標的項目外，還包含下列哪一類污染項目？',  '光化學污染物', '甲烷污染物',  '含氟氯碳化物污染物',  '含汞污染物',  1),
(708, '高級', '下列何者是跟環保有關的國際公約？', '華盛頓公約',  '羅馬公約', '伯恩公約', '巴黎公約', 1),
(709, '中級', '下列何者是目前因全球暖化而產生的國際環保的趨勢？', '廢棄物可以隨意跨國輸送',  '土壤鹽化問題', '重視氣候變遷減緩與調適',  '垃圾費隨袋徵收',  0),
(710, '高級', '一氧化碳之所以對人體有害，主要原因為何？', '破壞血小板功能',  '降低血紅素帶氧能力',  '產生嚴重過敏', '造成身體痙攣', 2),
(711, '中高級',  '下列哪一個國家在《京都議定書》中被視為開發中國家？',  '中國大陸', '臺灣', '法國', '美國', 1),
(712, '高級', '下列哪一種氣體為光化學作用後產生的光化學性高氧化物？', '臭氧', '二氧化碳', '二氧化硫', '氯乙烯單體',  1),
(713, '高級', '下列哪一種物質是引起光化學霧的前驅物質？', '二氧化碳', '氮氧化物', '甲烷', '三氧化硫', 2),
(714, '高級', '下列何者是《蒙特婁議定書》(Montreal', 'Protocol)要求限用的氣體？',  '二氧化氮', '氟氯碳化物',  '甲烷', 0),
(715, '中級', '下列何者是臺北市空氣污染的主要來源？', '', '', '汽機車排放廢氣',  '工廠排放廢氣', 0),
(716, '高級', '下列何者是針對機車定期檢驗的正確描述？',  '兩年以上的機車要定期檢驗', '定期檢驗需付100元', '需定期檢驗之車輛，檢驗時間為行車執照原發照月份之前後1個月',  '一定要到監理所做排氣檢驗', 3),
(717, '高級', '環保署規範空氣污染指標(PSI)所需要測定的項目共有幾種？',  '4種', '5種', '6種', '7種', 2),
(718, '高級', '空氣污染指標(PSI)依其對人體健康的影響程度，分為幾個等級？',  '3個等級', '4個等級', '5個等級', '6個等級', 3),
(719, '高級', '一般空氣污染物指標PM10所量測的懸浮微粒其粒徑在多少以下？', '10毫米', '10', '微米', '1毫米',  1),
(720, '高級', '環保署依地區性質對於空氣品質之需求，劃設空氣污染防制區，下列何者屬於一級空氣污染防制區？', '運動公園', '國家公園', '未符合空氣品質標準區域',  '城市地區', 2),
(721, '高級', '下列何者為長距離越境大氣污染公約所管制的對象？',  '二氧化硫', '碳氫化物', '全氟碳化物',  '環狀烴',  1),
(722, '高級', '下列何者是沙塵暴對環境的影響？',  '提高空氣溫度', '阻絕部分陽光，降低光合作用',  '土壤肥力減少', '減少海洋營養鹽',  2),
(723, '中高級',  '造成酸雨的主要化合物為何？',  '硫氧化物', '丙醇類',  '甲酸類',  '乙醚類',  1),
(724, '高級', '下列哪一種國際條約是針對硫氧化物的排放及越境移動的管制問題而制定？',  '倫敦廢棄物投棄公約',  '華盛頓公約',  '聯合國海洋法公約', '赫爾辛基協定', 4),
(725, '中級', '哪一種氣體造成臭氧層被嚴重的破壞？',  '氟氯碳化物',  '二氧化硫', '硫化氫',  '氮氧化合物',  1),
(726, '高級', '下列何者是造成臭氧層稀薄化的污染源？', '汽機車排放之二氧化硫', '海龍滅火器',  '使用環保冷媒', '燃燒電線產生的戴奧辛', 2),
(727, '中高級',  '下列何者是臭氧層稀薄化持續發生對人類帶來的影響？', '白天時間變長', '夜晚溫度偏低', '酸雨的嚴重度更劇烈',  '進入地球的紫外線增加', 4),
(728, '高級', '下列哪一個是「氣候變化綱要公約」所管制的氣體？',  '一氧化氮', '二氧化碳', '溴化銀',  '乙烷', 2),
(729, '高級', '下列哪一個國際公約是管制溫室效應氣體的排放？', '氣候變化綱要公約', '巴塞爾公約',  '鹿特丹公約',  '赫爾辛基協定', 1),
(730, '高級', '下列何者是移動污染源空氣污染防制費的徵收對象？',  '營建業主', '污染源之處理者',  '管理人',  '隨油品銷售時徵收', 4),
(731, '高級', '《蒙特婁議定書》是針對下列哪一類化學物質進行管制？',  '四氯化碳', '甲基氯仿', '溴甲烷',  '氯化銀',  1),
(732, '高級', '下列哪一個國際條約禁用氟氯碳化物？',  '《鹿特丹公約》',  '《里約宣言》', '《蒙特婁議定書》', '《那德威克宣言》', 3),
(733, '高級', '下列哪一個國際公約是針對減緩溫室效應的條約？', '《巴塞爾公約》',  '《斯德哥爾摩公約》',  '《生物安全議定書》',  '《聯合國氣候變化綱要公約》',  4),
(734, '高級', '《京都議定書》所管制的溫室氣體為下列何種？',  '二氧化硫', '氟硼酸',  '甲烷', '一氧化氮', 3),
(735, '高級', '溫室效應不是因下列哪一種人類行為而產生的？',  '', '燃燒石化燃料', '蓄養大量牲畜', '排放含硫化合物',  0),
(736, '高級', '下列何者與溫室效應有最密切的關係？',  '增加輻射外洩機率', '產生沙塵暴',  '戴奧辛的排放', '全球氣候變遷', 4),
(737, '中高級',  '《京都議定書》是因為下列何者之締約大會下所制訂定的？', '華盛頓公約',  '?合國氣候變化綱要公約',  '拉姆薩爾公約', '斯德哥爾摩公約',  2),
(738, '中高級',  '下列何者是《京都議定書》主要的訴求？', '減少產生酸雨的氣體',  '減少溫室氣體的排放',  '減少產生臭氧層薄化氣體',  '減少戴奧辛的產生', 2),
(739, '高級', '下列何者是環保署因應全球暖化所作的努力之一？', '擬訂溫室氣體減量法(草案)',  '制定國際公約', '簽訂京都議定書',  '鼓勵企業遷廠', 1),
(740, '高級', '下列何者是光化學煙霧事件發生的條件之一？', '發生於平原',  '日照充足', '發生於春季',  '發生於雨天',  2),
(741, '高級', '1952年發生於倫敦的「煙霧事件」其主要是因為燃煤產生什麼物質？', '二氧化氮', '二氧化硫和粉塵',  '氟氯碳化物',  '全鹵化物', 2),
(742, '高級', '《寂靜的春天》一書主要反映哪一?化學物質的?用會對生態平衡造成威脅？', '百滅寧',  'DDT',  '芬普寧',  '脫克松',  2),
(743, '高級', '苯之曝?對人體健康可能產生之影響為何？',  '白血球上升',  '血小板數量增加',  '骨頭疼痛', '紅血球下降',  4),
(744, '高級', '當氣象報導提醒民眾，紫外線指數達過量級，下列哪一個時段最好不要出門？', '早上6點~8點',  '早上8點~10點', '下午1點~2點',  '下午5點~6點',  3),
(745, '高級', '下列何者不是空氣污染指標(PSI)所需測定的物質？',  '二氧化氮', '二氧化硫', '氟氯碳化物',  '臭氧', 3),
(746, '高級', '下列何者為環保4R的目的？',  '增加商品的販售量', '提高產品賣價', '減少資源的消耗量', '改變產品的功能',  3),
(747, '高級', '下列哪一個國際會議同時簽定最多國際環保條約？', '蒙特婁會議',  '斯德哥爾摩會議',  '哥本哈根環境會議', '地球高峰會議', 4),
(748, '高級', '下列何者是清潔生產的要素？',  '增加回收量',  '減少排放毒物', '增加原料多樣性',  '壓低生產成本', 2),
(749, '高級', '下列何者是因為濫墾而產生的自然災害？', '土壤鈣化', '土壤礦化', '土壤酸化', '土石流',  4),
(750, '高級', '清淨家園顧厝邊綠色生活網中「去污保育」主要的概念為何？',  '建立低碳社會', '降低污染保護生態', '去污保育護生態',  '即時通報與清理',  3),
(751, '高級', '清淨家園顧厝邊綠色生活網中「整潔美化」主要的工作為何？',  '建立低碳社會', '推動綠色設計', '去污保育護生態',  '即時通報與清理髒亂的環境', 4),
(752, '高級', '清淨家園顧厝邊綠色生活網中「資源循環」主要的工作為何？',  '建立低碳社會', '推動資源再利用',  '去污保育護生態',  '即時通報與清理',  2),
(753, '高級', '清淨家園顧厝邊綠色生活網中「節能減碳」主要的工作為何？',  '建立低碳社會', '推動綠色設計', '去污保育護生態',  '即時通報與清理',  1),
(754, '高級', '下列何者是清淨家園顧厝邊綠色生活網的簡稱？',  'E-School', 'EcoLife',  'ERI',  'EGL',  2),
(755, '高級', '下列何者是生命行星指數(Living', 'Planet', 'Index，LPI)的正確描述？', '主要是描述地球爆炸的剩餘時間', '主要是監測地球下一階段冰河期時間', 0),
(756, '高級', '電磁波對於下列何種東西相較之下不易產生干擾？', '心律調節器',  '助聽器',  '高速鐵路的供電設備',  '飛機導航系統', 3),
(757, '高級', '下列何者對產業環境會計的描述是正確的？',  '主要提供給專家學者使用',  '透過衡量、記錄、分析與解釋的程序', '分析公司對環境所造成的破壞',  '幫助企業營業額',  3),
(758, '高級', '下列何者是為計算綠色國民所得帳所製作的整合系統？', '環境經濟綜合帳整合系統(SEEA)',  '環境品質管理系統(EMS)',  '國民生產總值(GNP)',  '綠色學校(GS)', 1),
(759, '高級', '下列何者是非游離輻射正確的描述？', '可破壞生物組織細胞',  '頻率大於3*1015Hz', '', '波長大於100',  0),
(760, '高級', '熱島效應多發生在下列哪一個地區？', '鄉村地區', '海邊', '都會區',  '高山部落', 3),
(761, '高級', '下列何者是針對熱島效應正確的描述？',  '郊區溫度上升', '能見度提升',  '降雨量增加',  '空氣污染物不易擴散',  4),
(762, '高級', '溫室效應是溫室氣體攔截地球表面反射哪一個波段的射線？', '紫外線',  '紅外線',  'X射線',  '?射線',  2),
(763, '高級', '下列何者是生態效益目的？', '生產過程減少能源和原料的使用量',  '生產過程降低生產成本', '生產以採綠色系產品為主',  '生產以減少生產所需時間為主',  1),
(764, '高級', '下列何者是生態效益需達到的目標？', '延長產品的耐久性', '減少商品和服務',  '加強產品的適用性', '增強客製化的服務', 1),
(765, '高級', '下列何者是鉻中毒產生的疾病症狀？', '心律不整', '少尿症',  '骨骼脆化', '腦性麻痺', 2),
(766, '中級', '水俁(ㄩˇ)病是因為患者誤食下列哪一種元素濃度過高或累積總量過多而導致中毒？', '砷',  '鉻',  '鉛',  '汞',  4),
(767, '高級', '著名的烏腳病，是因為食用含有下列哪一個元素濃度過高或累積總量過多，所導致中毒？',  '鉛',  '鎘',  '砷',  '汞',  3),
(768, '高級', '下列何者是鉛中毒產生的疾病症狀？', '心律不整', '癲癇', '痛痛病',  '胃穿孔',  2),
(769, '高級', '下列何者「不是」目前臺灣生物資源遭受威脅的主因？', '土地利用的改變',  '過度的捕獵',  '生物因天擇被淘汰', '引進外來種',  3),
(770, '高級', '下列何者「不是」環保4R中的意思？',  '減量', '再使用',  '再循環',  '再研究',  4),
(771, '高級', '因環境問題而首次在下列何地召開「聯合國人類環境會議」？',  '英國', '瑞典', '美國', '日本', 2),
(772, '高級', '下列何者最適合當養豬用的廚餘回收？',  '落葉', '豬骨', '飯菜', '蛋殼', 3),
(773, '高級', '下列何者「不是」事業廢棄物？', '農業廢棄物',  '醫療廢棄物',  '學校實驗室廢棄物', '家戶廢棄物',  4),
(774, '高級', '管制有害廢棄物之越境轉移及最終處置的《巴塞爾公約》於下列哪一年簽署的？',  '1979年',  '1989年',  '1999年',  '2009年',  2),
(775, '中級', '民眾在丟垃圾時，', '應依政府規定將垃圾分為幾類？', '五大類',  '四大類',  '三大類',  0),
(776, '高級', '環保署於民國86年推動「全民參與回饋式資源回收四合一計畫」，主要是透過下列何者先進行垃圾分類，再結合其他單位共同進行回收再利用？', '地方政府清潔隊',  '回收商',  '社區民眾', '基管會',  3),
(777, '高級', '下列何者與巴塞爾公約條文內容有關？',  '管制溫室氣體的排放',  '管制有害廢棄物之越境轉移', '管制破壞臭氧層氣體的排放', '管制保育類動物的輸出', 2),
(778, '高級', '下列何者是斯德哥爾摩公約主要管制的化學物質類別？', '持久性有機污染物', '無機污染物',  '重金屬',  '含放射性污染物',  1),
(779, '高級', '下列何者是斯德哥爾摩公約主要管制的化學物質？', '丙烯醯胺', '福爾培',  '安特靈',  '蓋普丹',  3),
(780, '高級', '下列哪一個公約主要管制持久性有機污染物(POPs)？', '斯德哥爾摩公約',  '里約宣言', '海牙宣言', '京都議定書',  1),
(781, '高級', '下列何者是我國目前最主要的廢棄物處理的方式？', '掩埋法',  '焚化法',  '海拋法',  '堆肥法',  2),
(782, '高級', '下列何者不是廢棄物、剩餘土石方清除機具所需要具備的文件或設備？',  '車上附有清運廢棄物之文件', '載運土石方產生源文件', '清運車輛車主文件', 'GPS',  0),
(783, '高級', '根據環保署公告，具有下列何者特性之廢棄物應列為毒性有害物質？', '不具生物累積性',  '非立即性對人體產生危害',  '不具腐蝕性',  '致畸胎、腫瘤', 4),
(784, '高級', '下列何者屬於環境用藥中的有機磷殺蟲劑？',  '毒殺芬',  '亞列寧',  '百滅寧',  '亞培松',  4),
(785, '高級', '兩輛各別產生80分貝的機車同時出現時，合成的噪音值為多少？',  '80分貝', '', '', '83分貝', 0),
(786, '中高級',  '下列何者是一般人的聽力可以聽到音量值的範圍？', '1~90分貝', '50~150分貝', '1~140分貝',  '40~160分貝', 3),
(787, '高級', '我國針對航空噪音有設置防制區，第一級航空噪音防制區之日間不得超過幾分貝？', '50~55分貝',  '55~60分貝',  '60~65分貝',  '65~70分貝',  3),
(788, '高級', '下列何者是噪音對人體的影響？', '耗氧量減少',  '注意力集中',  '血壓驟降', '精神緊張', 4),
(789, '高級', '下列哪一個時段是噪音管制區標準所稱的「日間」？',  '上午五時至晚上六時',  '上午六時至晚上八時',  '上午七時至晚上七時',  '上午八時至晚上六時',  3),
(790, '高級', '下列哪一個時段是第一、二、三類管制區規定最嚴格的噪音值？', '日間', '中午', '晚間', '夜間', 4),
(791, '高級', '兩輛各別產生70分貝和80分貝的機車同時出現時，合成的噪音值為多少？', '70分貝', '', '', '80分貝', 0),
(792, '高級', '在政府的管制項目中，下列何者尚未立法通過？',  '水污染防治',  '溫室氣體減量', '噪音管制', '廢棄物清理',  2),
(793, '高級', '在水循環中，下列哪一個環節其整體水流動的速度最為緩慢？',  '海洋', '水蒸發',  '地下水',  '河川', 3),
(794, '高級', '在水循環系統中，下列何者自淨能力最好？',  '海洋', '河川', '湖泊', '地下水',  1),
(795, '高級', '地下水自淨能力較差，其原因為下列何者？',  '水流速快', '溶氧量高', '生物數量多',  '溫度較低', 4),
(796, '高級', '一般來說，將土壤分成三層：O層是枯枝落葉層，A層是腐植層，E層是淋溶層，以上三層稱為什麼層？', '最下層',  '心土層',  '洗入層',  '表土層',  4),
(797, '高級', '下列何者元素因較不易受淋溶作用而聚集，使土壤產生紅色的現象？', '鉻、矽',  '鐵、鋁',  '銅、氮',  '硫、鎂',  2),
(798, '高級', '下列何者對土壤酸化的描述是正確的？',  '土壤pH值偏高',  '一般土壤多缺乏鈣、磷、鉀', '適合多種菌類生長', '多適合植物生長',  2),
(799, '高級', '目前我們對基因改造食品對人體可能產生的影響所知有限，因此其原料須於上市前通過審核，目前衛生署選定下列何者原料作為優先管制？',  '燕麥', '玉米', '大豆', '馬鈴薯',  2),
(800, '高級', '我們生活的空間屬於大氣層的哪一層次？', '對流層',  '中氣層',  '增溫層',  '平流層',  1),
(801, '高級', '臺灣的特有物種，對外來種的侵入很敏感與脆弱的。下列哪一種是臺灣常見的外來物種？',  '銀膠菊',  '臺灣欒樹', '欖仁樹',  '香杉', 1),
(802, '中高級',  '下列哪一種是臺灣常見的外來物種？', '臺灣欒樹', '銀合歡',  '水茄苳',  '臺灣杉',  2),
(803, '高級', '下列何者是臺灣常見的本土物種？',  '馬纓丹',  '水茄苳',  '銀合歡',  '小花蔓澤蘭',  2),
(804, '高級', 'ISO',  '14000，是國際標準組織為針對下列何種項目制定？',  '企業環境管理', '地方環境管理', '處所環境管理', 0),
(805, '中高級',  '持續的溫室效應對環境不會產生下列何種現象？',  '熱帶地區的傳染病往兩極移動',  '海平面上升',  '地殼崩解', '糧食產量銳減', 3),
(806, '高級', '在生態系統中食腐質動物可以分為分解者與食腐者，下列何者描述是正確的？', '分解者主要都是微生物', '分解者以食用排泄物為主',  '食腐者會食用排泄物',  '食腐者以分解生物屍體為主', 1),
(807, '高級', '下列何種生態系其每單位面積平均生物種類最多？', '河川', '深海', '熱帶森林', '草原', 3),
(808, '高級', '生態系統內物種在整體生態系統之重要性有多種假說，下列哪一個是屬於鉚(ㄇㄠˇ)釘假說？', '每一物種在生態系中正常發揮有其貢獻，且不能相互取代',  '在系統內有分重要物種與冗餘物種',  '生態系裡每個物種沒有一定存在的重要性', '鉚釘假說與關鍵假說是相同的',  1),
(809, '高級', '生物多樣性從微觀到巨觀，可分成三個層面來思考，下列何者正確？', '物種多樣性',  '系統多樣性',  '數量多樣性',  '來源多樣性',  1),
(810, '高級', '下列何者是外?種生物會對本地環境產生的影響？', '外來種易受天敵的抑制，所以影響不大',  '與本地物種競爭且具優勢',  '外來種較本地物種相較弱勢', '外來種的入侵對人類不會有影響', 2),
(811, '高級', '下列何者是清淨家園5S運動中所推廣的內容？',  '整齊', '教養', '清除', '簡潔', 2),
(812, '高級', '下列何者是清淨家園推動的策略？',  '', '深入鄰里建置志工、義工',  '強迫上網登錄比較成績', '主要對象為都市的人',  0),
(813, '中高級',  '下列哪一個區域是登革熱主要發生的地方？',  '熱帶及寒帶',  '熱帶及亞熱帶', '溫帶及寒帶',  '溫帶及熱帶',  2),
(814, '高級', '下列有關殺鼠劑的描述何者正確？',  '解毒劑為維他命Ｃ', '屬抗凝血劑',  '屬空間噴灑法', '屬燻蒸法', 2),
(815, '高級', '下列何者是被公告禁用之住家環境衛生用藥殺蟲劑？',  '天然殺蟲劑',  '有機氯殺蟲劑', '有機磷殺蟲劑', '人工合成除蟲菊殺蟲劑', 2),
(816, '高級', '下列哪一種環境衛生用藥對人體的慢性危害最為嚴重？', '生理性殺蟲劑', '有機氯殺蟲劑', '工合成除蟲菊殺蟲劑',  '有機磷系殺蟲劑',  2),
(817, '高級', '下列何者是環境用藥製劑之大原則？', '高濃度',  '衛生', '持續殘留作用', '安全性',  4),
(818, '中級', '下列何者是二氧化碳所衍生的環境變遷問題？', '土壤污染', '水庫優養化',  '全球暖化', '季風方向改變', 3),
(819, '中級', '臺灣每年沙塵暴主要發生在以下哪一個時期？', '冬末及春季',  '春末及夏季',  '夏末及秋季',  '秋末及初冬',  1),
(820, '高級', '臺灣沙塵暴主要來源是中國大陸，下列哪一個省份是沙塵暴的主要發源地？',  '青島', '四川', '河南', '甘肅', 4),
(821, '高級', '下列哪一個地區是受中國大陸沙塵暴東移所影響的地區？',  '馬爾地夫', '哈薩克',  '夏威夷',  '印度', 3),
(822, '高級', '下列何者是臺灣目前所面臨的氣候危機？', '季風風向改變', '梅雨季提前',  '極端降雨，強度增加',  '颱風減弱', 3),
(823, '中高級',  '下列何者是造成臺灣雨量異常的原因？',  '全球暖化', '臭氧層薄化',  '酸沉降',  '因太少下雨，導致水氣持續累積在大氣層', 1),
(824, '高級', '下列何者「不是」全球暖化所帶來的影響？',  '夏季溫度上升', '降雨量減少',  '日照量增加',  '氣候穩定度低', 3),
(825, '中高級',  '2009年的哥本哈根會議中提出控制全球暖化的關鍵溫度是下列何者？', '1℃', '2℃', '3℃', '4℃', 2),
(826, '高級', '下列何者「不是」全球暖化對臺灣民眾的影響？',  '暴雨強度增加', '下雨天數增加', '農作物產量可有效提升', '颱風強度減少', 3),
(827, '高級', '下列哪一種溫室氣體吸收大氣熱能的能力最強？',  '二氧化碳', '甲烷', '六氟化硫', '氧氣', 3),
(828, '高級', '對於聖嬰現象的描述，下列何者是正確的？',  '海水總量增加', '東太平洋湧升流增強',  '颶風量增加',  '全球冬季溫度更低', 3),
(829, '高級', '我們在挑選冷氣時應該重視下列何種指標對環境才是友善的？',  'HP值',  'EER值', 'A值', 'COD值', 2),
(830, '高級', '下列何者是目前世界環保商品的趨勢？',  '', '強化精緻度',  '降低成本', '強調客製化',  0),
(831, '高級', '有關第二類環保產品的描述，下列何者正確？', '屬於環保署公告之環保標章產品', '原料符合再生材質', '符合增加社會利益之產品即可',  '產品通過IS19000認證即可',  2),
(832, '高級', '符合「可拆解之設計」的綠色商品，具有甚麼特色？',  '產品在壽命結束後被拆解而使組件及零件易於再利用或回收', '產品與其他產品組合，方便使用', '產品具有設計感，可在產品壽命前由專人修復並再利用', '產品設計以可分解材料為主，並可在產品壽命結束直接丟棄，在環境中自然分解',  1),
(833, '高級', '「ISO14020環境標誌與宣告」系列標準，所提到的「回收比率」為何？',  '在產品或包裝中，所使用的回收料',  '在產品或包裝中，回收過程的程序',  '在產品或包裝中，回收料的重量比',  '在產品設計過程中，所回收的材料',  3),
(834, '高級', '下列何者「不是」綠色採購的原則？', '收集產品及供應商的環境資訊',  '採購時應考產品生命週期對環境的衝擊',  '選擇照顧環境的供應商', '採購前應考慮該產品價格',  4),
(835, '高級', '下列哪項行為是執行低碳旅遊的作法之一？',  '搭乘大眾運輸工具旅遊', '使用旅館提供相關免洗用具', '到戶外舉辦賽車活動',  '到商店大量購買新衣物', 1),
(836, '高級', '下列何種行為可以稱為減碳生活？',  '推動舊衣回收機制', '以泡澡代替淋浴',  '騎乘二行程機車',  '加購塑膠袋',  1),
(837, '高級', '下列何者是減碳行為？', '選用進口昂貴商品', '選用含磷洗衣精',  '推動共乘', '電燈開開關關最省電',  3),
(838, '高級', '下列何者是家中減碳的好方法？', '電冰箱要塞滿食物，避免浪費空間',  '冷氣維持23℃',  '米飯烹煮時可先浸泡30分鐘',  '使用白熾燈',  3),
(839, '高級', '低碳旅遊主要是為了減少下列哪一種氣體的排放？', '減少造成臭氧層薄化的氣體', '減少排放溫室氣體', '減少排放含戴奧辛的氣體',  '減少造成光化學煙霧的氣體', 2),
(840, '高級', '臺灣永續發展原則與方向中有關「社會公平與世代正義原則」，下列描述何者正確？',  '資源應交易買賣',  '增加貧富差距，符合市場需求',  '資源應妥善利用',  '資源應該被保存，任何人都不能使用', 3),
(841, '高級', '下列何種行為考慮到世代公平的原則？',  '企業遷廠', '增加遊樂設施', '增加非再生資源開採',  '減少污染行為', 4),
(842, '高級', '關於社會公義之原則，下列何者正確？',  '資源不用留給後代子孫', '污水排放至河川',  '開發過程不需評估對環境衝擊',  '資源及經濟分配應符合公平原則', 4),
(843, '高級', '臺灣永續發展原則與方向中有關「國際參與與公眾參與原則」下列描述何者正確？', '資源要留給後代子孫',  '集合各方期望和智慧共同制定永續發展原則',  '資源應最大化開採，竭盡其用',  '資源及經濟分配應符合公平', 2),
(844, '高級', '對於永續發展方案的系統整合原則，下列描述何者正確？',  '污染者及受益者付費為基礎', '資源要留給後代子孫',  '制定永續發展方案需整合政府及民間力量', '資源及經濟分配應符合公平', 3),
(845, '高級', '下列何者是積極保護水資源的方式？', '提高家庭污水下水道接管率', '偷排廢水', '超抽地下水',  '繼續興建水庫', 1),
(846, '高級', '針對產品生產過程排放出的廢水，以預防的角度而言，下列何種做法較為消極？',  '設置污水處理廠',  '工廠使用環保原料', '產品綠色設計', '修改生產製程以減少污染排放',  1),
(847, '高級', '下列何者是從源頭減少土壤污染的方法？', '改善工業製程，降低製程污染排放',  '把污染的土壤移到別的地方', '針對可能污染的土壤進行土壤檢測',  '把有污染的區域劃定為污染管制區',  1),
(848, '高級', '下列何者對於土石流特徵的描述是正確的？',  '前端多為巨大石礫', '後端多為巨大石礫', '泥砂濃度低',  '礦物含量高',  1),
(849, '高級', '下列何者是土石流災害的型態？', '雪崩', '溪流改道', '湖底噴發', '伽瑪射線暴',  2),
(850, '中級', '下列何者動作可以減少沙塵暴對人體的影響？', '呼吸道疾病患者出門多活動', '出門時戴口罩', '出門時戴手電筒',  '老人出門運動', 2),
(851, '中高級',  '下列何者是目前減少臭氧層持續稀薄化的方式？',  '購買環保冷媒', '購買含氟氯碳化物的產品',  '購買海龍滅火器',  '多種植經濟作物',  1),
(852, '高級', '下列何種方法能減少熱島效應的影響力？', '減少排放戴奧辛',  '多採用水泥大樓，可有效吸熱',  '鋪設柏油路增加反射光能力', '使用綠建築取代原有建築型態',  4),
(853, '高級', '下列哪一種方法能有效降低溫室效應？',  '家中使用白熾燈泡', '公共場所使用燈光感應設施', '室溫維持在23度', '水槽中加濾網', 2),
(854, '高級', '如何使用冷氣才能節省能源？',  '打開冷氣，讓室溫維持在23~24℃',  '打開冷氣，讓室溫維持在24~25℃',  '打開冷氣，讓室溫維持在25~26℃',  '', 0),
(855, '高級', '下列何者是文化景觀敏感地的重要性？',  '保護歷史與生態的延續', '減少氣候變化', '具有人類賴以維生之資源',  '鞏固地形較為敏感地帶', 1),
(856, '高級', '下列何者是維護天然災害敏感地的做法？', '保護人類賴以維生之資源',  '保護該地，避免人為開發造成該地發生天然災害',  '保護當地經濟作物', '保護風俗民情', 2),
(857, '高級', '以下何者是文化景觀敏感地？',  '水雉生態地',  '地下水資源區', '古蹟保存區',  '地質災害地區', 3),
(858, '高級', '下列何者是企業對環境應盡的責任？', '降低生產成本', '提高能源使用量',  '外部成本內部化',  '提供較便宜的商品', 3),
(859, '高級', '我們應抱持何種對環境友善的觀念？', '保護環境是政府的責任', '將正確的環境知識往下扎根', '具有愛護環境的想法，但可以僅限於想法', '鼓吹他人從事環保，自己可以不用',  2),
(860, '高級', '在晚上聽到隔壁鄰居吵架而影響到他人的生活可向下列哪一個單位求助？', '警察機關', '里長辦公室',  '教育部',  '環保署',  1),
(861, '高級', '下列哪一個是臺灣「公害陳情免付費的專線電話號碼」？',  '0800-066666',  '0800-085717',  '0800-055119',  '0800-057119',  1),
(862, '高級', '下列哪一個是有效減少臭氧層稀薄化的方式？', '禁止生產含氟氯碳化物產品', '大量生產氟氯烴產品',  '不研發替代產品',  '種植綠樹，增加氧氣',  1),
(863, '高級', '下列何種收費方式是以外部污染成本內化原則為主？',  '空氣污染防制費',  '所得稅',  '健保費',  '房屋稅',  1),
(864, '高級', '下列何者是工廠從源頭減少振動產生的方式？', '設置隔音設備', '與住戶良性溝通協調',  '改善工業製程', '廠房搬遷', 3),
(865, '初級', '在四公尺以內之公共巷弄應該由誰清掃？', '各縣市清潔隊', '社區志工', '巷道兩旁住戶', '建築物營建者', 3),
(866, '中級', '下列哪個選項「不是」臺灣現行的環保法規？', '野生動物保護法',  '水污染防治法', '噪音管制法',  '京都議定書',  4),
(867, '初級', '面對全球環境的問題，我們如何修正自己的行為，以減少環境的破壞？',  '減少山坡地濫墾、濫伐', '增加物質的慾望',  '過著奢華的生活',  '增加能源的消耗',  1),
(868, '初級', '6月5日為世界環境日，其推動的主要目的為何？', '推廣戒菸', '保護地球', '防制毒品', '預防家暴', 2),
(869, '初級', '下列哪個選項「不是」政府為保護環境所做的努力？',  '研擬環保法規', '設環保專責機構負責環保事務',  '制定環保政策', '在山地設工業區',  4),
(870, '初級', '下列哪個選項「不是」推動環保政策而推行的措施？',  '延攬環保人才規劃政策', '設環保專責機構負責環保事務',  '成立中華民國消費者文教基金會', '設保護區保育生物', 3),
(871, '初級', '下列哪種做法「不會」使地球環境變得更好？', '垃圾分類', '自備購物袋',  '使用耗電量大的電器',  '關懷瀕臨絕種的生物',  3),
(872, '初級', '下列哪種做法「不是」愛護地球所應該做的行為？', '響應資源回收', '節約用電、用水',  '使用免洗筷',  '選用有環保標章的產品', 3),
(873, '初級', '下列哪一種行為是愛護地球環境的表現？', '在水源區倒垃圾',  '垃圾不分類，交給焚化爐燒毀',  '多植栽喬木及灌木', '水龍頭使用開到最大',  3),
(874, '初級', '下列哪個選項是企業或工廠應有的做法？', '直接排放廢水', '研發具環保概念的產品', '直接排放廢氣', '直接排放廢棄物',  2),
(875, '初級', '下列哪種觀念「不是」環境保護應該有的觀念？',  '資源取之不盡', '資源分類', '商品不過度包裝',  '垃圾減量', 1),
(876, '初級', '下列哪種觀念是「錯誤」的？',  '維護地球環境人人有責', '做好垃圾減量工作', '環境有自淨能力，再多污染沒煩惱',  '隨手做環保，環境自然好',  3),
(877, '初級', '面對工業科技所造成的環境破壞危機，要如何因應？',  '逐步將工業轉型為農業', '將工業區設在人口稀少的地方',  '制定良善的環保法令',  '修改憲法禁止工業發展', 3),
(878, '初級', '下列何者「不是」我們的家園目前所面臨的問題？', '發生嚴重土石流',  '森林面積縮小', '山坡地濫墾濫建',  '自然資源蘊藏豐富', 4),
(879, '初級', '下列哪個選項是經濟快速發展可能帶來的「壞處」？',  '物質生活改善', '資源耗竭', '國民所得提高', '競爭力增強',  2),
(880, '初級', '下列哪個選項是政府制定環保法規的目的？',  '降低生活品質', '保護自然環境', '合法濫用資源', '增加罰款收入', 2),
(881, '初級', '下列何者「無法」達到節能減碳的目的？', '隨手關燈', '用大量的水洗澡',  '出門走路、騎踏車', '多吃蔬食少吃肉',  2),
(882, '初級', '下列哪個選項「不會」造成環境污染？',  '工廠直接排放黑煙', '污水直接排放到河川',  '汽機車排放廢氣',  '多種行道樹',  4),
(883, '初級', '春節期間要注意什麼情形，才能過個好年，下列何者正確？', '燒金紙時小心火苗，將灰燼清理乾淨', '不暴飲暴食，注意飲食健康衛生', '放鞭炮時要留意周遭安全',  '以上皆是', 4),
(884, '初級', '當我們發現工廠排放廢氣或污水時，可以向下列哪個單位告發？', '建設局',  '衛生局',  '環保局',  '交通局',  3),
(885, '初級', '為解決全世界的環境污染問題，臺灣有許多民間組織為環保而努力，下列哪個選項是臺灣的環保團體？',  '柯內爾共享自然基金會', '國際公平貿易標籤組織', '臺灣國際合作發展基金會',  '荒野保護協會', 4),
(886, '中高級',  '「世界清潔日」的活動是由下列哪個組織之下的機構協助籌畫的？',  '世界貿易組織', '臺灣荒野保護協會', '行政院環境保護署', '聯合國',  4),
(887, '中高級',  '「綠帶運動」是萬加瑞‧瑪塔伊女士在下列哪個地區開始發起的活動？',  '奈及利亞', '肯亞', '南非', '利比亞',  2),
(888, '初級', '下列哪個選項「不是」環保團體該做的事？',  '宣導環保觀念', '舉辦淨山、境灘活動',  '假借環保名義牟利', '監督政府的環保政策',  3),
(889, '初級', '關於生態保育的作者與其書籍，下列哪個選項是正確的？',  '珍古德-寂靜的春天',  '瑞秋卡森-西雅圖酋長的天空',  '印地安酋長西雅圖-與牠為伴',  '李奧波-砂地郡曆誌(沙郡年紀)',  4),
(890, '初級', '下列哪個選項「不是」宜蘭厝的設計原則？',  '半戶外空間',  '斜屋頂',  '高樓層',  '自然樸素的建材',  3),
(891, '初級', '萬加瑞‧瑪塔伊女士鼓勵農村婦女加入植樹的行列，引起廣大迴響，形成「綠帶運動」，帶來下列哪種影響？', '具經濟價值的棕櫚樹栽種面積擴大',  '增加地熱資源', '擴大鹹海面積', '有助水土保持', 4),
(892, '初級', '人類過度開發對環境會造成什麼影響？',  '生物多樣性增加',  '水土保持良好', '嚴重空氣污染', '森林變多，排擠人類生存空間',  3),
(893, '初級', '下列哪個選項「不屬於」人為造成的環境問題？',  '核能發電廠附近水溫升高，造成珊瑚白化', '工廠燃燒油品、排放污水，造成環境污染', '油輪漏油，污染海洋',  '低溫造成魚蝦暴斃', 4),
(894, '初級', '有關環境被破壞的情形，下列哪個選項是正確的？', '土石流造成冰山融化，海平面上升',  '土地沙漠化造成沙塵暴', '地表溫度升高造成紫外線過量',  '紅外線過量導致生物免疫系統被破壞', 2),
(895, '初級', '臺灣十分之九的人口居住在哪種地形，也是土地資源被開發最多的區域？', '海洋和沙灘',  '平原和盆地',  '山地和峽谷',  '丘陵和崖洞',  2),
(896, '初級', '臺灣目前有許多人主張「非核家園」，他們的理由「不包括」下列哪個選項？', '核廢料如果處理不當，會嚴重威脅人體健康',  '臺灣應該開發其他更環保的能源', '核能發電不會產生任何環境問題', '核電廠若發生意外，後果相當嚴重',  3),
(897, '初級', '任何重大的工程都會對自然環境造成衝擊，下列何者是「錯誤」的做法？', '與當地居民進行協商',  '實施環境影響評估', '徵收土地強制當地居民遷移', '遵守環保法規', 3),
(898, '初級', '為提高糧食生產與供應，以因應不斷增加的世界人口，人們不斷引水灌溉，對環境造成許多破壞，下列哪個選項「不是」過度使用水造成的結果？', '地層下陷', '水源地枯竭',  '河流流失', '石油枯竭', 4),
(899, '初級', '下列哪個選項「不是」影響臺灣氣候的因素？', '人口', '季風', '緯度', '地形', 1),
(900, '初級', '世界產生資源不足及飢餓問題，下列何者是主要原因之一？', '發生自然災害', '世界人口減少', '宣導節能減碳', '世界各國礦產分配平均', 1),
(901, '初級', '地球上每一個人都是平等的，都應該享有相同的基本人權，這個基本人權「不包括」下列何者？', '成為有錢人',  '溫飽的生活',  '衛生的環境',  '安樂的生活',  1),
(902, '初級', '人口分布過度集中的環境會產生許多社會問題，下列何者正確？', '男女比例差亦變大', '休閒玩樂費用變貴', '城鄉差距變大', '流浪貓狗便多', 3),
(903, '初級', '隨著世界人口爆增，全球糧食不足，下列哪一洲飢餓人口的比例高於40%？', '歐洲', '亞洲', '非洲', '美洲', 3),
(904, '初級', '下列哪個問題與一個國家的出生率遞減「無關」？', '未來人力資源不足', '少子化',  '平均壽命縮短', '人口老化', 3),
(905, '初級', '下列哪個選項「不是」造成臺灣離島地區人口數量少的原因？',  '受到海洋阻隔', '對外交通不方便',  '土壤資源不充足',  '地勢過於高聳', 4),
(906, '初級', '下列何者是吸引人們遷居都市地區的原因？',  '工作機會少',  '交通與生活不便',  '物價水準較高', '醫療資源豐富', 4),
(907, '初級', '下列何者是造成富有國家人民生育率「較低」的原因？', '醫療資源較缺乏',  '傳染病控制較差',  '優生保健的觀念盛行',  '衛生條件較差', 3),
(908, '初級', '目前移居臺灣的新移民人口中，來自哪個地區的人數占最多？',  '奈及利亞', '中國大陸', '墨爾本',  '緬甸', 2),
(909, '初級', '有關臺閩地區人口分布情形，下列何者是「錯誤」的敘述？', '各地人口分布不平均',  '臺灣西部的平原和盆地是人口最密集的地區',  '離島地區風景優美人口眾多', '臺灣東部人口較西部少', 3),
(910, '初級', '良好的養育條件，能確保下列哪種資源的品質？',  '森林', '海洋', '土地', '人力', 4),
(911, '初級', '某國家具有下列哪種特點，比較有可能面臨人口老化的社會問題？',  '教育水準低',  '死亡率高', '出生率低', '國民所得低',  3),
(912, '中級', '為什麼當前臺灣的出生人口數不斷「降低」？', '養兒育女的花費升高',  '環境品質很好', '配合政府政策', '醫療技術不佳，生產風險高', 1),
(913, '初級', '下列何者是世界衛生組織期望在2015年「環境」公共衛生領域所要達成的目標？',  '增加提供開發中國家的食物量',  '使酸雨濃度減半',  '使二氧化碳濃度減半',  '將無法持續獲得安全飲用水的人口比例減半',  4),
(914, '初級', '近年來臺灣人口成長緩慢的原因，「不包括」下列何者？',  '人口分布在鄉村',  '男女晚婚', '夫婦均工作，無暇照顧子女', '養兒育女花費提高', 1),
(915, '初級', '近幾十年來，全球人口成長快速會產生什麼影響？', '生活品質大大提升', '生活空間變大', '每人分得的資源變多',  '全球糧食生產負擔日益沉重', 4),
(916, '初級', '下列哪個選項是可再生的資源？', '核能資源', '礦產資源', '漁業資源', '石油', 3),
(917, '初級', '下列何種觀念的提出，是為達到和子孫共享自然資源的理想？',  '都市計畫', '禁用石油', '永續發展', '節育計畫', 3),
(918, '初級', '下列哪一種作法最符合自然資源永續發展？',  '鼓勵每個人都開車上班', '洗青菜時讓水龍頭的水一直流',  '將家庭污水直接排放到溪流中',  '選購具有節能標章的家電產品',  4),
(919, '初級', '維護生態環境和善用自然資源，是世界各國共同關注的課題，身為地球的一分子，需為地球盡一份心力。這個觀念屬於哪種理念，下列哪個選項正確？', '綠色生活，環保選購',  '保護自然，萬物共存',  '分類回收，循環再生',  '以上皆是', 4),
(920, '初級', '巴西的庫里奇巴城曾經因為人口增加而導致環境嚴重污染，如今已成為擁有良好生態環境的經濟大城，其成功的原因是下列哪個選項？',  '將過多的人口遷往他處', '禁止使用化石燃料', '制定嚴峻的法律來對抗污染', '以環保、節儉和創意來重新規劃城市', 4),
(921, '初級', '政府應該以下列哪一種做法因應全球性的環保問題？',  '致力發展重工業',  '推廣核能發電', '以永續發展為概念', '停止進口原油', 3),
(922, '初級', '推動「我愛綠建築」與下列哪個議題相關？',  '交通', '環保', '經濟', '政治', 2),
(923, '初級', '貼有下列哪種標章的電器產品，表示比一般電器省電？', '省水標章', '節能標章', 'CAS標章',  '回收標章', 2),
(924, '初級', '下面何者「不是」綠建築的概念？',  '親近大自然',  '讓房子裡外都變成綠色', '降低對周遭環境的衝擊', '讓人住得更健康舒適',  2),
(925, '初級', '生態池裡充滿魚類、蛙類和水生植物，這是配合「綠建築」的哪一項主張？',  '親近自然環境', '減少能源消耗', '減少廢棄物',  '讓人住得更舒適',  1),
(926, '初級', '如果要蓋一座符合環保概念的園區，下列哪個選項的作為「不適合」出現？',  '利用風力發電', '採用太陽能發電系統',  '選購節能標章的設施',  '建材儘量從國外買進來', 4),
(927, '初級', '陸上交通工具的發展，使人類生活更加便利。下列哪個選項是正確的描述？',  '大眾運輸工具工具已經全面使用電力做為動力', '早期的交通工具得依靠人力拖拉', '工業科技提升了交通工具的速度，縮短人與人之間的距離',  '遊覽車屬於大眾運輸工具',  3),
(928, '初級', '使用太陽能燈和太陽能熱水器是配合綠建築的哪一項主張？', '讓人住得更舒適',  '涵養水源', '節能減碳', '親近自然環境', 3),
(929, '初級', '在以環境為優先的考量下，選購家電產品應最先考慮什麼？', '價格是否昂貴', '外觀是否美觀', '包裝是否精美', '是否有節能標章',  4),
(930, '初級', '下列哪個選項「不是」綠建築的主要設計原則？',  '防震建材', '通風設計', '節能節水', '頂樓防漏與隔熱',  1),
(931, '初級', '下列哪個選項「無法」讓屋子變得更涼快？',  '外牆使用多孔牆',  '全玻璃外牆',  '屋頂加蓋遮陽架，減少陽光直射', '窗戶外加裝百葉窗', 2),
(932, '初級', '下列哪一種房屋的設計是比較適合於寒冷地區的建築物？',  '具有斜面遮陽板的走廊', '屋頂設置遮陽架',  '多孔隙外牆',  '使用深色的外牆',  4),
(933, '初級', '下列哪個選項「不是」節能減碳的正確作法？', '隨手關燈', '使用節能標章的電器產品',  '做好資源回收', '節省時間，多乘電梯',  4),
(934, '初級', '下列哪種房屋的設計「不會」影響室內溫度的變化？',  '建築外牆的顏色',  '建材的熱傳導性',  '信箱擺放的位置',  '室內採光的多寡',  3),
(935, '初級', '下列哪種設施和綠建築「沒有」關係？',  '採光通風良好', '使用可回收的建材', '房屋四周種植喬木及灌木',  '使用進口花崗岩',  4),
(936, '初級', '使用環保標章清潔劑符合綠色消費的哪一項原則？', '重複使用', '低污染',  '回收再生', '減量', 2),
(937, '初級', '「可回收、低污染、省資源」的產品符合下列哪項標章概念？',  '節能標章', '回收標章', '環保標章', '以上皆是', 3),
(938, '初級', '一名綠色消費者在購買商品時，下列哪個選項最正確？', '優先選購包裝精美的商品',  '優先選購對環境傷害較少的產品', '接受店員提供的免費塑膠袋', '單次使用、用過即丟的商品較衛生',  2),
(939, '初級', '下列何者「不符合」綠色消費原則?', '使用可分解的環保塑膠袋',  '自備餐具、環保杯、環保袋', '做好資源回收，讓資源再利用',  '注意生態保護，不要污染環境造成公害',  1),
(940, '初級', '下列何者最符合綠色消費的環保行為？',  '選購新型電器就不需要考慮節能效力', '減少不必要的消費', '免費的塑膠袋，不需要重複使用', '買咖啡不需要自備環保杯',  2),
(941, '初級', '下列何種購物行為「沒有」綠色消費觀念？',  '單次使用、用過即丟的商品較衛生',  '購買天然殺蟲劑，減少環境污染', '不接受店家提供的免費塑膠袋',  '買咖啡自備環保杯', 1),
(942, '初級', '下列哪種設計更容易使炎熱的臺灣地區溫度升高？', '加裝遮陽板',  '在屋頂加裝通風塔', '室外有走廊設計',  '加裝玻璃帷幕', 4),
(943, '初級', '以下消費行為，何者對地球環境較友善？', '多吃異國料理有助環保', '吃在地的食物最環保',  '國外進口水果又大又漂亮，一定比較環保', '名牌比較有保障，越貴越環保',  2),
(944, '初級', '在學校用餐自備餐具，是落實綠色消費中的哪一項表現？',  '重複使用', '環保選購', '回收再生', '隨用即丟', 1),
(945, '初級', '拒絕購買用過即丟及過度包裝的產品，或選購具有環保標章的產品，屬於下列哪一項？', '可重複使用',  '可回收再生',  '環保選購', '以上皆是', 4),
(946, '初級', '夏天居住在室內會覺得特別熱，是利用下列哪種建材所建築的房子？', '水泥屋',  '紅磚屋',  '鐵皮屋',  '木屋', 3),
(947, '初級', '強調「低污染、可回收、省資源」的商品消費，又稱為何？', '需求層次理論', '群體消費', '綠色消費', '健康消費', 3),
(948, '初級', '綠色消費的五個原則除減量、環保選購、回收再生、保護萬物自然共生外，還有下列哪個原則？', '隨手關燈', '重複使用', '節約用水', '無毒消費', 2),
(949, '初級', '下列何者符合綠建築概念的設計？',  '在建築物周圍栽種植物', '門窗加裝鐵欄杆',  '庭院鋪水泥地面',  '儘量使用進口的建材',  1),
(950, '初級', '有關於綠建築的敘述，下列哪個選項是「錯誤」的？',  '盡可能親近大自然', '自然且節能',  '建築物以綠色為主', '有助於緩和環境與生態的危機',  3),
(951, '初級', '有關綠建築的敘述，下列何者是「錯誤」的？', '具環保概念的建築', '建築物設計儘量親近大自然', '使用最多能量、製造最少廢棄物的新建築', '有助於緩和環境與生態危機的建築新概念', 3),
(952, '初級', '有關綠建築的觀念，下列何者是正確的？', '是一種符合環保的建築新概念',  '是一種完全以綠色素材建構成的建築', '是建築在森林中的建築物',  '是有庭院的建築',  1),
(953, '初級', '為使地球能夠生生不息，許多個人和團體紛紛投入環保運動，我們小學生能夠做到的是下列何者？',  '買下濕地作為野生動物保護區',  '開發新的環保能源', '簽署有強制力的環保條約',  '每週一天蔬食', 4),
(954, '初級', '下列哪種房子的設計「沒有」隔熱與通風的效果？', '建築物四周都有迴廊設計',  '建築物有多孔牆',  '頂樓加蓋鐵皮屋',  '樓房屋頂有通風塔', 3),
(955, '初級', '下列哪種建材當作房屋外牆時，在夏天所測出的室內溫度最高？', '木材', '磁磚', '鐵皮', '紅磚', 3),
(956, '初級', '因應宜蘭多雨的氣候，下列何者是「宜蘭厝」的建築特色？', '平臺式屋頂',  '拱形屋頂', '斜屋頂',  '圓形屋頂', 3),
(957, '初級', '下列何者符合通風和散熱的設計？',  '建築物有走廊', '屋頂上的遮陽架',  '多孔性的外牆建築', '以上皆是', 4),
(958, '初級', '我們常看到的白色百葉窗是因為下列何種原因？',  '白色比較容易清洗', '白色的材料比較便宜',  '白色吸收太陽輻射熱較多',  '白色吸收太陽輻射熱較少',  4),
(959, '初級', '屋子走廊的外牆會採用多孔牆，其主要目的是下列哪個選項？',  '節省材料', '比較美觀', '讓室內的人看到外面的風景', '可以有通風、散熱的效果',  4),
(960, '初級', '怎樣的住宅設計可以「減少」能源的消耗，下列哪個選項最正確？',  '設置電梯', '讓室內空氣對流',  '使用白熾燈泡', '採用玻璃帷幕牆',  2),
(961, '初級', '有關環保選購的準則，下列何者正確？',  '不使用過度包裝的產品', '使用環保標章的產品',  '不使用用過即丟的產品', '以上皆是', 4),
(962, '初級', '下列哪個選項「不是」推動綠建築的目標？',  '減少消耗地球資源', '製造最少的廢棄物', '使用較多的能源',  '建築物與地球環境共生共榮', 3),
(963, '初級', '「宜蘭厝」可以成為有特色的地區建築是因為下列哪個選項？',  '閩南式屋頂',  '周圍種滿三星蔥',  '引進宜蘭礁溪的溫泉',  '使用卵石和宜蘭石', 4),
(964, '初級', '下列哪種建築設計可以讓人有生活在大自然的感覺？',  '雨撲滿',  '牆壁種植攀爬植物', '透水步道', '風力發電', 2),
(965, '中高級',  '下列哪一種方式「不是」荷蘭現在用來防洪的方式？',  '設計漂浮屋',  '遷移聚落', '遷移農地', '增設河堤', 4),
(966, '高級', '2010年在墨西哥坎昆舉行的國際會議COP',  '16，主要是在討論下列哪個問題？', '傳染病控制',  '經濟改革', '氣候變遷', 0),
(967, '中級', '因應臺灣氣候而發展出不同的地方特色，下列哪個選項是「錯誤」的？',  '九份地區多雨-用油毛氈蓋屋頂', '蘭嶼高溫強風-達悟族的傳統住屋',  '澎湖的東北季風強勁-風鈴季',  '新竹湖口多雨氣候-騎樓',  3),
(968, '初級', '因應臺灣氣候所發展的地方特色，下列哪個選項是正確的？', '澎湖東北季風強勁-發展風鈴季', '臺灣東北地區多雨-使用油毛氈蓋屋頂',  '蘭嶼高溫強風-利用咾咕石為植物擋風',  '恆春半島落山風-騎樓', 2),
(969, '初級', '有關全球暖化的敘述，下列哪個選項是「錯誤」的？',  '溫室氣體的大量排放是造成全球暖化的主因',  '全球持續暖化將會造成海平面上升、全球氣候異常等現象',  '追求經濟成長，可以犧牲環境',  '避免地球持續暖化的工作，人人都可以做得到', 3),
(970, '初級', '各種交通工具和電器設備所排放的哪種氣體，容易造成地球暖化？',  '二氧化硫', '二氧化碳', '一氧化碳', '一氧化硫', 2),
(971, '初級', '大氣中二氧化碳濃度過高可能造成什麼環境問題？', '噪音污染', '全球暖化', '河川污染', '酸雨', 2),
(972, '初級', '下列哪個選項「不是」加速地球暖化的原因？', '工廠大量排放廢氣', '任意使用冷暖氣',  '車輛眾多', '種植樹木', 4),
(973, '初級', '全球暖化使得馬爾地夫等海島國家面臨到被淹沒的危機，我們應該採取什麼行動？', '反校園霸凌',  '響應節能減碳', '多吃肉、少吃菜',  '多使用非再生能源', 2),
(974, '初級', '日常生活中，我們應該如何珍惜自然資源？',  '多騎乘汽機車', '多使用化學肥料',  '垃圾不分類',  '多搭乘大眾運輸工具',  4),
(975, '初級', '有些學校每周一有「蔬食日」活動，這個活動主要在宣導下列哪個選項？', '維護生態', '健康管理', '節能減碳', '消除飢餓', 3),
(976, '初級', '要過健康的綠生活，我們可以怎麼做，下列何者正確？', '多爬樓梯、少搭電梯',  '自備環保餐具、環保袋', '搭乘大眾交通工具', '以上皆是', 4),
(977, '初級', '要過環保節能減碳的生活，應該如何選擇食材，下列何者正確？', '吃清淡的食物', '吃當季的蔬果', '吃在地生產的食材', '以上皆是', 4),
(978, '初級', '有關美化環境的敘述，下列哪個選項是「錯誤」的？',  '自然通風的房舍，住起來更舒適', '透水步道可以涵養水資源',  '自然採光的住屋可以減少能源消耗',  '在住家栽種植物只是為了美化環境，對環保沒有幫助',  4),
(979, '初級', '我們應該如何節約能源，下列何者是正確的？', '電視機可以打開一整晚', '中午午休時，隨手關燈', '距離目的地不到3分鐘，還是開車比較方便',  '夏天時，冷氣可以開到20度以下',  2),
(980, '初級', '荒野保護協會推動「夏至關燈一小時」的活動，是提醒民眾重視下列哪個議題？',  '維護人權', '防治傳染病',  '關懷弱勢', '全球暖化', 4),
(981, '初級', '森林和熱帶雨林被砍伐後會造成天氣變熱、降雨減少，這是因為森林的哪一項功能消失？',  '造氧功能', '維護生物多樣性',  '保護土壤', '調節氣候', 4),
(982, '初級', '酸雨的形成與燃燒下列哪種物質關係較大？',  '木材', '石油', '氧氣', '廚餘', 2),
(983, '初級', '鹹海面積縮小後，對當地的影響，下列哪個選項是「錯誤」的敘述？', '湖中魚類減少', '水源氾濫', '含鹽塵土被吹至各地',  '乾涸的部分會變成沙漠', 2),
(984, '初級', '當臭氧層愈來愈稀薄時，會對地球環境造成下列哪一種影響？',  '海平面上升',  '破壞本土動植物生存環境',  '增加罹患皮膚癌的機會', '增加河水的酸度',  3),
(985, '初級', '下列哪個選項「不是」減少酸雨的做法？', '汽機車定期排氣檢查',  '多搭乘大眾運輸工具',  '工廠加裝污染防制設備', '節約用水', 4),
(986, '初級', '下列哪個現象「不是」全球暖化所帶來的影響？',  '水資源短缺',  '海平面下降',  '傳染病流行',  '陸生物種滅絕', 2),
(987, '初級', '下列哪個選項「不是」全球性的環境問題？',  '海洋污染', '全球暖化', '酸雨', '噪音', 4),
(988, '初級', '下列哪個選項「不是」全球暖化後將會帶來的災難？',  '傳染病流行、經濟衰退', '水旱災頻率增加',  '氣候溫暖造成物種繁殖過剩', '兩極的冰層融化，海水量增加造成海平面上升', 3),
(989, '初級', '下列哪個選項「不是」全球暖化現象對臺灣所造成的影響？', '海平面上升',  '人口快速成長', '年平均溫度上升',  '冬天更長且嚴寒',  2),
(990, '初級', '下列哪種污染物會形成酸雨？',  '汽機車排放的廢氣', '焚化廠排放的廢氣', '燃燒煤炭所排出的污染物',  '以上都是', 4),
(991, '初級', '北極熊遠離原本的居住地，南移到人類居住的城鎮，其原因是因為下列哪個選項？', '氣候異常，風雪交加，北極熊找不到家',  '人間美味，吸引北極熊', '氣候異常，北極愈來愈冷',  '氣候暖化，北極融冰，北極熊棲息地迅速減少', 4),
(992, '初級', '全球暖化會對臺灣造成什麼影響？',  '陸地增加', '冰山遍布', '沿海土地面積縮減', '颱風減少', 3),
(993, '初級', '酸雨會造成什麼影響？', '造成建築物受損',  '使農作物長得更好', '使森林生機盎然',  '降低河水酸度', 1),
(994, '初級', '人類對於核能的應用，應該要有什麼樣的態度？',  '不斷興建核能發電廠',  '致力研發核子武器', '適度地使用核能，注意核能可能帶來災害', '在深海處大量試爆核子武器', 3),
(995, '中高級',  '下列哪一種發電方法是利用核分裂產生巨大的能量？',  '風力發電', '火力發電', '核能發電', '太陽能發電',  3),
(996, '初級', '下列哪個選項是應用太陽能的「缺點」？', '不會產生空氣污染', '取之不盡用之不竭', '長期沒有日照就無法發電',  '沒有任何缺點', 3),
(997, '初級', '下列哪種能源「不是」潔淨且污染小的發電方式？', '水力', '太陽能',  '風力', '核能', 4),
(998, '初級', '下列哪種發電方式「不屬於」再生能源？', '水力', '風力', '太陽能',  '核能', 4),
(999, '初級', '相對而言，下列哪種發電方式對環境所造成的影響最大？',  '風力、地熱發電',  '核能、火力發電',  '水力、太陽能', '風力、水力發電',  2),
(1000,  '初級', '燃燒後所產生的蒸汽來推動發電機發電，是利用下列哪種方式？', '水力發電', '核能發電', '火力發電', '風力發電', 3),
(1001,  '初級', '下列哪個選項「不是」資訊科技發達對人類生活產生的影響？',  '騎鐵馬環保旅遊',  '利用視訊設備做遠距開會',  '利用網路購物', '即時與國外親友聯絡',  1),
(1002,  '初級', '下列哪個選項的產品最具環保的概念？',  '二行程摩托車', '塑膠玩具', '柴油汽車', '太陽能路燈',  4),
(1003,  '初級', '世界能源分布非常不均，而各國能源使用量的差距也很大，下列哪種國家的能源使用量最大？',  '工業化國家',  '人口多的國家', '產石油國家',  '領土大的國家', 1),
(1004,  '初級', '世界能源的分配和使用量非常不平均，就平均值而來說，下列哪個國家的人均耗能最高？',  '埃及人',  '印度人',  '日本人',  '美國人',  4),
(1005,  '初級', '以下何者常以太陽能來使用？',  '熱水器',  '路燈', '計算機',  '以上皆是', 4),
(1006,  '中級', '為因應溫室效應的惡化和石油耗竭，阿拉伯聯合大公國嘗試打造完全使用太陽能的環保城市。這樣的城市「不包含」下列哪個選項？', '零輻射',  '零污染',  '零碳排',  '零廢棄',  2),
(1007,  '初級', '各國為解決能源耗竭問題而研發替代能源，下列何者「不是」可再生能源？',  '風力', '地熱', '石油', '太陽能',  3),
(1008,  '初級', '臺灣連同興建中的核能電廠，目前共有4座。唯一「不在」新北市境內的是哪一座核能電廠？',  '核一廠',  '核二廠',  '核三廠',  '核四廠',  3),
(1009,  '初級', '下列哪個選項「不是」自然資源？',  '陽光、空氣',  '水、空氣', '礦產', '汽車、飛機',  4),
(1010,  '初級', '下列哪個選項的發電能源屬於「不可」再生的能源？',  '地熱', '太陽能',  '核能', '生質能',  3),
(1011,  '初級', '下列哪種能源的使用對環境破壞的程度最高？', '太陽能',  '石油', '風力', '以上皆是', 2),
(1012,  '初級', '有關能源問題的敘述，下列哪個選項是正確的？',  '石油取之不盡，用之不竭',  '工業化國家消耗較少的能源', '地球亟須尋找新的能源', '目前各國都能平均使用共有的能源',  3),
(1013,  '初級', '臺灣目前發電方式所占比例最高的是下列哪個選項？',  '火力發電', '風力發電', '太陽能發電',  '核能發電', 1),
(1014,  '初級', '下列哪個選項「不屬於」永續利用的天然資源？',  '太陽能',  '水力', '石油', '風力', 3),
(1015,  '初級', '為控制污染問題，各國紛紛投入研發乾淨的替代能源，目前哪一種能源逐漸被國人居家使用？',  '太陽能',  '水力', '生質燃料', '地熱', 1),
(1016,  '初級', '臺灣哪個地區的住家最適合裝太陽能熱水器？', '宜蘭', '高雄', '臺北', '基隆', 2),
(1017,  '初級', '關於太陽能的敘述，下列哪個選項是正確的？', '太陽能是地球主要電力來源', '太陽能目前被廣泛的使用於家電用品上',  '太陽能會污染環境', '太陽能路燈是將太陽的熱儲存起來，再轉換成電能', 4),
(1018,  '初級', '下列哪種發電方式是利用水位的高度差產生的能量發電？',  '火力發電', '水力發電', '核能發電', '風力發電', 2),
(1019,  '初級', '有關既潔淨又可以永續利用的發電方式，下列哪個選項正確？',  '核能發電', '風力發電', '燃煤發電', '燃氣發電', 2),
(1020,  '初級', '關於天然氣的描述，下列哪個選項是「錯誤」的？', '燃點很低', '氣體很活潑',  '可以回收再利用',  '容易散失', 3),
(1021,  '初級', '下列哪個選項「不是」造成空氣污染的原因？', '太陽能發電',  '汽機車排放廢氣',  '火災時的濃煙', '工廠排放廢氣', 1),
(1022,  '初級', '冰島擁有下列哪一種豐富資源，並且藉此提供首都所需的能源？', '太陽能',  '風力', '地熱', '潮汐能',  3),
(1023,  '初級', '在西濱公路可以看到許多大風車，風車具有下列哪項功能？', '調節氣溫', '氣象預測', '發電', '吸收光能', 3),
(1024,  '初級', '風力發電適合選擇在下列哪種地方運作？', '多風空曠', '海邊多浪', '高溫多陽光',  '水位落差大',  1),
(1025,  '初級', '下列哪個選項是使用石油能源所造成的主要影響？', '全球暖化', '土地沙漠化',  '河川消失', '海洋生物減少', 1),
(1026,  '初級', '關於核能發電，下列哪個選項是「錯誤」的敘述？', '以石油當燃料', '排出溫水', '減少二氧化碳的排放',  '發電的成本最低',  1),
(1027,  '初級', '有關核能的敘述，下列哪個選項是正確的？',  '民眾要常常上街抗議核能的使用', '政府應定期做核安演習', '核廢料的最好處理方式是運到國外掩埋',  '應廢除核能技術的研究', 2),
(1028,  '中級', '為了解決臭氧層日漸稀薄的問題，許多國家共同簽訂哪個國際協定？', '《華盛頓公約》',  '《京都議定書》',  '《蒙特婁議定書》', '《拉姆薩公約》',  3),
(1029,  '初級', '我國政府禁止狂牛疫區的肉類進口，主要因素為何？',  '將疫區肉類銷往其他國家',  '各國施壓的結果',  '維護民眾健康', '避免影響本地肉商商機', 3),
(1030,  '初級', '下列哪個選項「不是」臺灣加入世界貿易組織後所採取的因應措施？', '降低成本', '改良生產技術', '拒買外國貨',  '研發具特色的產品', 3),
(1031,  '初級', '在人口高度成長和資源分配不均的狀況下，會造成下列哪種現象？',  '全人類都能夠生活得更富裕', '全人類都有高度的環保意識和實踐低碳生活',  '世界上的糧食能夠均勻地分配，人人都能有足夠的糧食', '世界上少數國家占用了多數的資源',  4),
(1032,  '初級', '我們應該如何善盡世界公民的責任？', '獨善其身，不參與國際活動', '勇於突破困境，擴展視野',  '只管好國內的事務即可', '自掃門前雪，不管有關全球議題的事物',  2),
(1033,  '中級', '「氣候變化綱要公約」規定簽約國限制下列哪種氣體的排放？',  '一氧化碳', '二氧化碳', '氫氣', '氧氣', 2),
(1034,  '初級', '下列哪種參與國際環保組織的心態較「不適當」？', '為提升國際形象',  '為了解全球環境政策走向',  '為保護環境盡心力', '為獲取他國資源',  4),
(1035,  '初級', '有關國際組織與其成立宗旨的敘述，下列哪個選項是「錯誤」的？',  '國際綠色和平組織-保護地球生態環境',  '世界展望會-救助無數飢餓、疾病的人們', '聯合國難民署-互通犯罪情報，阻止跨國性犯罪',  '國際公平貿易標籤組織-讓農人免除中盤商的剝削', 3),
(1036,  '初級', '世界貿易組織的簡稱為何？', 'WTO',  'WHO',  'WOT',  'WHA',  1),
(1037,  '初級', '大氣中的水，是以何種狀態呈現，下列哪個選項正確？', '固體', '氣體', '液體', '以上皆是', 4),
(1038,  '初級', '下雪、結霜、下雨等天氣的變化主要和下列哪個選項的關係最為密切？',  '空氣中的氧氣與二氧化碳',  '月亮的盈缺變化與太陽', '大氣中的水',  '地表的岩石與土壤', 3),
(1039,  '初級', '我們可以利用下列哪個選項來測量天氣的溫度？',  '體重計',  '氣壓計',  '計算機',  '氣溫計',  4),
(1040,  '初級', '我們所觀測的天氣現象和下列哪個選項的關係最為密切？',  '氮氣', '氧氣', '二氧化碳', '大氣中的水',  4),
(1041,  '初級', '我們要怎樣才能預先知道今天或明天的天氣，下列哪個選項是「錯誤」的？',  '收看電視或收聽廣播',  '上網查詢', '撥打117的氣象預報專線', '看報紙',  3),
(1042,  '初級', '星星在天空中的位置，會隨著時間、季節改變，只有下列哪一個星星幾乎固定不動，可以幫助人們在黑夜中辨認方向？', '北極星',  '夏季大三角',  '天狼星',  '北斗七星', 1),
(1043,  '初級', '氣象站的雨量儀是採用平底直筒容器，在一定時間內累積雨水的高度。1小時的累積降雨稱為下列哪個選項？', '時雨量',  '日雨量',  '季雨量',  '年雨量',  1),
(1044,  '初級', '雨量的單位，通常是用下列哪個選項來表示的？',  '毫升', '坪',  '公斤', '毫米', 4),
(1045,  '初級', '測量天氣的溫度時，要在陰涼通風處，下列哪個選項是正確的測量場所？', '操場上',  '冷氣房內', '樹蔭底下', '教室內',  3),
(1046,  '初級', '登山時，如果在晚上迷失方向，可以透過各種方式找尋正確的方位，下列哪個選項較「不適當」？',  '北極星',  '手電筒',  '觀星盤',  '指北針',  2),
(1047,  '初級', '雲中的冰晶直接以固態的方式掉落地面，會形成下列哪個選項？', '雨',  '露',  '霧',  '雪',  4),
(1048,  '初級', '下列何者為臺灣氣象預報專線的電話號碼？',  '165',  '117',  '119',  '166或167',  4),
(1049,  '初級', '下列哪個選項中的敘述是屬於長期觀察後，所得到天氣變化的結果？', '受到寒流影響，今天早上在淡水地區出現最低溫10℃', '今天下午二點在屏東地區出現最高溫38℃',  '去年8月的月平均氣溫最高，1月的月平均氣溫最低',  '昨天的降雨量為40毫米',  3),
(1050,  '初級', '下列哪種現象是通過臺灣時會造成連續幾天的低溫？',  '滯留鋒',  '颱風', '寒流', '梅雨', 3),
(1051,  '初級', '大氣中的水有各種不同的形態及變化，下列哪個選項的天氣現象「不是」水所轉變的？', '雨',  '露',  '霧',  '雷',  4),
(1052,  '初級', '由高空降落到地面而形成的水形態，是下列哪個選項？', '露和雨',  '雲和雨',  '雪和霜',  '雨和雪',  4),
(1053,  '初級', '水蒸氣遇冷會產生霜或露，下列哪個選項是正確的敘述？',  '霜是透明的液態',  '露是白色的固體',  '霜常見於寒冬的地面上', '露常見於秋天清晨的地面',  4),
(1054,  '初級', '在3000公尺的高山上「不可能」觀察到下列哪種現象？', '出現聖嬰現象', '天上飄下白色的雪花',  '夜晚氣溫降低，葉片邊緣結霜',  '日出可以看到雲海', 1),
(1055,  '初級', '有關霧的敘述，下列哪個選項是正確的？', '霧是白色固體，摸起來硬硬的',  '霧常見於清晨或午後山區',  '清晨草木上的小水滴是霧',  '水蒸氣遇冷結成細小的水滴，飄浮在高空中是霧',  2),
(1056,  '初級', '依臺灣的地理與氣候條件，在下列哪種情況中才有機會看到銀白色的雪？', '春天的小溪邊', '夏天的海邊',  '秋天的溪谷中', '冬天的高山上', 4),
(1057,  '初級', '空氣中的水會以不同形態出現的主要原因為何？',  '位置高低', '時間不同', '地形差異', '溫度不同', 4),
(1058,  '初級', '空氣中的水蒸氣遇冷變成液態水的現象稱為什麼？', '結晶', '凝固', '蒸發', '凝結', 4),
(1059,  '初級', '空氣中的水蒸氣凝結成水的過程主要是受到下列哪種因素的影響？',  '溫度上升', '溫度下降', '溼度上升', '溼度下降', 2),
(1060,  '初級', '雨水和露水最主要的不同是下列哪種因素的關係？', '組成成分', '顏色外觀', '出現時的形態', '形成時的高度', 4),
(1061,  '初級', '氣溫降低到攝氏0℃以下時，地面附近的水蒸氣會變成下列哪種形態附著在物體的表面？',  '雨',  '霜',  '霧',  '雪',  2),
(1062,  '初級', '清晨時常可發現下列哪種形態的水附著在花草的表面？', '雨',  '露',  '霜',  '雪',  2),
(1063,  '初級', '雲中的冰晶以液態的方式掉落地面，是下列哪個選項？', '雨',  '露',  '霧',  '雪',  1),
(1064,  '初級', '臺灣年平均雨量約為2,500毫米，如此豐沛的雨量是受到什麼因素影響，下列哪個選項正確？',  '西南季風(6月中至9月中)',  '東北季風(10月初至隔年4月底)', '颱風(夏、秋兩季)',  '以上皆是', 4),
(1065,  '初級', '臺灣梅雨季節總是連續降雨不停，這是因為下列哪個選項所造成的？', '冷氣團推向暖氣團所形成的冷鋒', '暖氣團取代原本冷氣團的區域，所形成的暖鋒', '冷氣團與暖氣團勢力相當所形成的滯留鋒', '冷鋒停滯變成寒流', 3),
(1066,  '初級', '燒杯中倒入碎冰、水和鹽之後，用筷子攪拌，這時杯壁外側會出現一些固態的結成物，這種情形類似大自然中的哪種現象？', '起霧', '結霜', '下雨', '降雪', 2),
(1067,  '初級', '關於大氣中水的敘述，下列哪個選項是正確的？',  '霜常見於清晨或午後山區',  '霧通常出現於寒冷的清晨',  '地面溫度很低，降下的白色小水滴是雪',  '飄浮在高空中的小水滴聚集落下是雨', 4),
(1068,  '初級', '關於颱風眼的敘述，下列哪個選項是正確的？', '位於颱風內部的雲柱中心部分',  '颱風眼區域屬於無雲或雲層很薄的狀態',  '從颱風眼的結構?實與否來判斷颱風的結構是否完整',  '以上皆是', 4),
(1069,  '初級', '在太平洋地區形成的氣團具有什麼特性？', '寒冷且乾燥',  '寒冷且潮溼',  '溫暖且乾燥',  '溫暖且潮溼',  4),
(1070,  '初級', '氣象預報「隨著鋒面持續南下，中南部地區開始下雨，北部地區從明天開始雨勢趨緩。」這是什麼鋒面造成的？',  '冷鋒', '暖鋒', '滯留鋒',  '囚錮鋒',  3),
(1071,  '初級', '從中央氣象局網站上連結衛星雲圖，從幾張連續的衛星雲圖上，可以看出天氣的狀況有什麼不同？',  '雲層分布不同', '雨量不同', '氣溫不同', '氣壓不同', 1),
(1072,  '初級', '從衛星雲圖中，我們可以獲得許多氣象的資料，但是「不包括」下列哪個選項？',  '不同的雲層',  '地面的高度',  '日期與時間',  '區域的範圍',  2),
(1073,  '初級', '當冷氣團的勢力減弱後退，使得原本的空氣區域被暖空氣取代，此時的鋒面稱為什麼？', '冷鋒', '暖鋒', '滯留鋒',  '囚錮鋒',  2),
(1074,  '初級', '當冷氣團勢力較強推向暖氣團時，所形成的鋒面稱為什麼？', '冷鋒', '暖鋒', '滯留鋒',  '囚錮鋒',  1),
(1075,  '中級', '當冷暖氣團勢均力敵時，鋒面會呈現停留、徘徊的狀態，此時的鋒面稱為什麼？',  '冷鋒', '暖鋒', '滯留鋒',  '囚錮鋒',  3),
(1076,  '中級', '颱風的強度，可分為幾種等級？', '2種', '3種', '4種', '5種', 2),
(1077,  '初級', '關於氣象衛星的敘述，下列哪個選項是正確的？',  '每次的觀測資料都會有變化', '不是人造衛星', '每天只能傳回一次氣象資訊', '可以從地球中觀測天氣的情況',  1),
(1078,  '初級', '地面天氣圖上，一條條彎曲且封閉的「黑線」是指下列哪個選項？',  '相等高度', '相等溫度', '相等水平面',  '相等氣壓', 4),
(1079,  '初級', '地面天氣圖上，圓圈中心的「H」是指下列哪個選項？', '低氣壓中心',  '高氣壓中心',  '暖鋒', '冷鋒', 2),
(1080,  '初級', '地面天氣圖上，圓圈中心的「L」是指下列哪個選項？', '低氣壓中心',  '高氣壓中心',  '暖鋒', '冷鋒', 1),
(1081,  '初級', '在地面天氣圖上可以找到下列哪個選項中的符號或資料？',  '地震強度', '等壓線',  '＠',  '％',  2),
(1082,  '初級', '在衛星雲圖上，臺灣南部被一大片白色的東西所遮住，試問臺灣南部的天氣狀況如何？', '陰天或下雨',  '晴朗炎熱', '強風', '濃霧', 1),
(1083,  '初級', '空氣中的水蒸氣凝結成細小的水滴，飄浮在地面附近，是下列哪個選項？', '雨',  '霜',  '霧',  '雪',  3),
(1084,  '初級', '若對大氣中雲層分布的變化情形有興趣，應該觀察下列哪個選項中的氣象圖表？',  '衛星雲圖', '衛星地圖', '地面天氣圖',  '降雨機率表',  1),
(1085,  '初級', '等壓線在同一線上的氣壓數值都相同，且會連成一條封閉的曲線，其氣壓數值的單位是下列哪個選項？',  '分貝', '百帕', '毫米', '瓦特', 2),
(1086,  '初級', '下列哪種措施「無法」減輕都會區的空氣污染？',  '避免焚燒垃圾', '多搭乘大眾運輸系統',  '出門時帶口罩', '車輛定期做排氣檢驗',  3),
(1087,  '初級', '有關空氣污染的敘述，下列哪個選項是「錯誤」的？',  '酸雨是空氣污染造成的', '地球上的二氧化碳濃度越來越高', '純住宅區就不會有空氣污染的問題',  '加強汽、機車廢氣排放管制可減輕空氣污染',  3),
(1088,  '初級', '露天燃燒稻草是「違反」下列哪種環保法規？', '水污染防治法', '空氣污染防制法',  '噪音管制法',  '野生動物保護法',  2),
(1089,  '初級', '有關二氧化碳和氧氣的敘述，下列哪個選項是正確的？', '汽水的主要成分是溶入氧氣的碳酸水', '氧氣不助燃的特性，可作為滅火器使用',  '酵母菌的發酵作用會產生氧氣，使麵包膨鬆',  '動物呼出的氣體含有二氧化碳',  4),
(1090,  '初級', '下列哪種行為「無法」降低空氣污染？',  '儘量搭乘大眾運輸工具上下班',  '多走路少開車', '儘量採取共乘的方式',  '多開車少走路', 4),
(1091,  '初級', '政府可以經由下列哪種措施來降低空氣污染？', '興建垃圾掩埋場',  '強制購買購物袋',  '汽機車定期排氣檢測',  '騎機車強制戴安全帽',  3),
(1092,  '初級', '在生活中氧氣還有哪些用途，下列哪個選項正確？', '生物呼吸不需要氧氣',  '攪動水面，減低水中溶氧量', '氧氣可以用來滅火', '打氣幫浦將空氣打成氣泡，增加加水中溶氧量', 4),
(1093,  '初級', '工廠排放未經處理的廢氣是違反了下列哪一種環保法規？',  '野生動物保育法',  '水污染管制法', '空氣污染防制法',  '噪音管制法',  3),
(1094,  '初級', '下列哪個選項的觀察結果，可以作為空氣污染程度的指標？', '生物數量的多少',  '分貝數的大小', '落塵量的多少', '垃圾量的多少', 3),
(1095,  '高級', '下列哪個選項是「空氣污染指標」的英文簡稱？',  'SPI',  'PSI',  'PIS',  'SIP',  2),
(1096,  '初級', '我們可以藉由下列哪種方式來判斷空氣品質的好壞？',  '太陽的仰角高度',  '衛星雲圖', '空氣污染指標', '海嘯發生的地點',  3),
(1097,  '初級', '環保署推動空氣品質監測獲得空氣污染指標數值愈小時，表示下列哪個選項？', '正在下大雨',  '空氣裡的污染物愈多',  '空氣品質愈差', '空氣裡的污染物愈少',  4),
(1098,  '初級', '將冷氣機裝設在牆上方較容易使屋內達到冷卻效果，這是何種熱傳播方式的應用？', '傳導', '輻射', '對流', '對傳', 3),
(1099,  '中級', '測量聲音大小的儀器是下列何者？',  '氣溫計',  '氣壓計',  '計算機',  '分貝計',  4),
(1100,  '初級', '噪音對我們的影響「不包括」下列何者？', '心情放鬆', '心情煩躁', '容易緊張', '可能會震破耳膜',  1),
(1101,  '初級', '有關減少噪音污染的方法，下列何者是「錯誤」的敘述？',  '在公共場所降低說話的音量', '在機場或高速公路旁架設隔音牆', '在汽車的引擎加裝消音器',  '晚上在住宅區進行道路施工', 4),
(1102,  '初級', '有關噪音的敘述，下列何者是正確的？',  '車輛經過學校旁，可以猛按喇叭', '聲音的計量單位是分貝', '在公共場所講話要愈大聲愈好',  '噪音對我們的聽力不會有任何影響',  2),
(1103,  '初級', '維護生活環境安寧是誰的責任？', '警察', '爸爸、媽媽',  '消防隊員', '每一個人', 4),
(1104,  '初級', '有關減少或降低噪音的做法，下列哪個選項是正確的？', '半夜大聲的唱歌',  '在圖書館的閱覽室裡，與同學大聲嬉鬧',  '開車行經學校附近，車輛不亂鳴喇叭', '半夜進行路面施工', 3),
(1105,  '初級', '生活中常見的聲音，下列何者的音源音量最高？',  '時鐘滴答聲',  '洗衣機',  '防盜器',  '飛機起飛聲',  4),
(1106,  '初級', '減少噪音、維護生活環境的安寧是大家的責任，下列何者的做法是「錯誤」的？',  '在高速公路或機場附近的建築旁架設隔音牆',  '車輛駕駛不隨意亂按喇叭',  '在公共場合與朋友大聲說話，免得對方聽不清楚',  '正在施工中的工地外圍，應架設隔音板',  3),
(1107,  '中高級',  '下列哪個選項「不是」政府針對水污染所進行的防治措施？', '加強廢水排放的查核和取締', '設置污水處理廠，處理家庭和工業廢水',  '加強清洗街道，減少揚塵',  '設置地下水質監測站，管制地下水質', 3),
(1108,  '初級', '關於水污染敘述，下列哪個選項是「錯誤」的？',  '減少清潔劑使用，可以降低水污染',  '水庫的水可以直接飲用', '家庭用水也會造成水污染',  '污水會沿著地下擴散開來，造成土壤污染', 2),
(1109,  '初級', '工廠產生的廢水都直接排入河川，可能會造成下列哪個選項的情況發生？', '河川生態更豐富',  '人類可以直接利用的淡水減少',  '河川五顏六色更美麗',  '沒有任何影響', 2),
(1110,  '初級', '日常生活中要做到減少水污染，下列哪個選項是「不好」的？',  '設置污水處理廠',  '家庭污水排入污水下水道',  '規劃水源保護區',  '工廠直接排放廢水至河川',  4),
(1111,  '中級', '處理家庭污水比較正確的做法是下列哪個選項？',  '增設排水系統，將污水排放至外海',  '興建污水下水道，把污水集中到污水處理廠',  '把家庭污水倒至住家附近的空地', '興建下水道，把廢水排放到地底深處', 2),
(1112,  '初級', '關於水污染的敘述，下列哪個選項「錯誤」？', '減少清潔劑的使用，能夠降低水污染', '污水會沿著地下水擴散開來', '污水可以直接飲用', '家庭用水也可能會造成水污染',  3),
(1113,  '初級', '下列哪個選項「不是」水污染的來源？',  '養殖廢水', '雨水', '家庭污水', '工廠排放廢水', 2),
(1114,  '初級', '下列哪個選項「不屬於」水污染？',  '在河邊飼養家畜',  '工廠排放廢水', '工廠排放濃煙', '垃圾棄置於河川中', 3),
(1115,  '初級', '下列哪個選項是水污染所造成的影響？',  '土石流',  '地層下陷', '魚群暴斃', '呼吸道疾病',  3),
(1116,  '初級', '下列哪項建設可以解決水污染的問題？',  '興建垃圾焚化爐',  '興建高速公路', '興建大眾捷運系統', '興建污水處理廠',  4),
(1117,  '初級', '下列哪個選項「不是」海洋污染造成的災害？', '破壞海洋生態環境', '海鳥誤食垃圾死亡', '冰川融化而淹沒沿海地區',  '海中生物死亡', 3),
(1118,  '初級', '下列哪個選項是造成海洋污染擴及全球的原因？',  '海水蒸發形成酸雨落下', '海水流動', '海洋所占的地表面積小於陸地',  '海洋是封閉系統',  2),
(1119,  '初級', '下列哪個選項對臺灣周圍海域的描述「錯誤」？',  '東臨太平洋',  '西有福建海峽', '南有巴士海峽', '北濱東海', 2),
(1120,  '初級', '下列哪個選項「不是」海洋污染造成的影響？', '污染物擴散至全球', '破壞沿海生態', '引發土石流',  '海洋生物死亡', 3),
(1121,  '初級', '下列哪個選項「不是」臺灣河流特徵？',  '坡度大、流速急',  '源於高山、長度短', '降雨量多集中於冬季，常導致河水暴漲',  '河川集水區大小不一',  3),
(1122,  '初級', '關於河流的作用，下列哪個敘述比較正確？',  '河道最寬的地方是河流下游', '河流中游的河床通常會堆滿細沙', '河流從上游到下游，河道通常寬窄不一',  '河流下游會布滿從中游沖刷下來的巨大石頭',  1),
(1123,  '初級', '造成臺灣西部平原愈來愈寬的原因是下列哪個選項？',  '泥沙堆積', '侵蝕作用', '板塊的推擠',  '造山運動', 1),
(1124,  '初級', '臺灣中南部河川在哪一個季節進入豐水期？',  '春季', '夏季', '秋季', '冬季', 2),
(1125,  '初級', '臺灣的河川大多起源於哪一座山脈？', '阿里山山脈',  '玉山山脈', '雪山山脈', '中央山脈', 4),
(1126,  '初級', '下列哪個選項「不是」水庫的功能？', '防洪', '儲存水量', '孕育生態池',  '發電', 3),
(1127,  '初級', '下列何者是節省水資源的好方法？',  '大量使用清潔劑',  '洗衣機的水量設至最高', '天天洗車', '裝置二段式馬桶沖水器', 4),
(1128,  '初級', '什麼樣的洗澡習慣較「無法」省水？', '盆浴後的水排放掉', '將等待熱水前的冷水儲起來', '站在浴缸裡淋浴後將水再利用',  '在蓮蓬頭裝設節水器',  1),
(1129,  '初級', '節省、愛惜水資源的方法有很多，下列哪個選項正確？', '利用洗米水澆花',  '利用洗米水拖地',  '利用洗臉水沖馬桶', '以上皆是', 4),
(1130,  '中高級',  '河流是供應人類生活用水的最重要來源，隨著人口增加，水資源也變得愈來愈珍貴，下列哪個單位正積極提高人們的用水效率？', '農糧署',  '水利署',  '衛生署',  '營建署',  2),
(1131,  '初級', '雨撲滿具有下列哪一種作用？',  '淨化空氣', '可以發電', '驅逐蚊蟲', '可將雨水回收利用', 4),
(1132,  '初級', '下列哪種情形可能會使水庫淤積情況更加嚴重？',  '山坡地做好水土保持',  '年雨量太少',  '上游帶來大量泥沙', '落山風',  3),
(1133,  '初級', '赤崁水庫是臺灣唯一的地下水庫，位於下列哪一個縣市？',  '桃園縣',  '臺中市',  '臺南市',  '澎湖縣',  4),
(1134,  '初級', '臺灣降雨量豐沛，但每人可分配到的水資源卻不多。下列哪一個選項「不是」其主要原因？', '豐水期和枯水期流量差異大', '自來水管道不普遍', '受到地形影響', '受到人口密度影響', 2),
(1135,  '初級', '下列哪個水庫主要供應屏東地區的用水？', '曾文水庫', '牡丹水庫', '赤崁水庫', '石門水庫', 2),
(1136,  '初級', '目前臺灣地區的各項用水總量以何者為最多？', '生活用水', '冷卻用水', '農業灌溉', '工業用水', 3),
(1137,  '初級', '關於「雨撲滿」的敘述，下列哪個選項是「錯誤」的？', '可以用來發電', '可有效利用水資源', '可將雨水回收再利用',  '是環保設施之一',  1),
(1138,  '初級', '有關臺灣水資源的敘述，下列哪個選項是正確的？', '降雨量受地形和氣候的影響，時間和空間分配平均', '澎湖縣的赤崁水庫是我國唯一的地下水庫', '臺灣下水道普及，河川得以免於污染之虞', '臺灣降雨量多，所以水資源豐富', 2),
(1139,  '初級', '有關臺灣的地形景觀，下列哪個選項「不是」受到海水侵蝕的結果？', '野柳的海蝕洞', '東北角的海蝕平臺', '和平溪出海口的三角洲', '花蓮的海蝕崖', 3),
(1140,  '初級', '臺灣海岸線東西南北有不同的地形和風貌，下列哪個選項是正確的？', '南部海岸多珊瑚礁，有些位在水面下', '西部海岸曲折，有許多奇形怪狀的岩石',  '東部海岸大多平直，海底也較為平淺', '北部海岸斷崖連綿，船隻停靠困難',  1),
(1141,  '初級', '雨水、河水、地下水、波浪、冰河等對地表的破壞作用稱作什麼？',  '堆積作用', '侵蝕作用', '板塊作用', '沙漠化作用',  2),
(1142,  '中高級',  '下列哪個地形景觀「不是」受到海水侵蝕作用所形成的？',  '海蝕洞',  '海蝕崖',  '出海口的三角洲',  '海蝕平臺', 3),
(1143,  '初級', '怎麼樣的開發行為，會導致地層下陷？',  '濫砍樹木', '山坡地過度開發',  '超抽地下水',  '闢建水庫', 3),
(1144,  '初級', '養殖業大量抽取地下水，可能造成哪一種環境問題？',  '水土流失', '地層下陷', '土石流',  '地震', 2),
(1145,  '初級', '下列哪個選項「不是」校園常見的垃圾分類？', '一般垃圾類',  '大型廢棄傢俱類',  '廚餘類',  '資源回收類',  2),
(1146,  '初級', '下列哪個選項是「不易分解」的物質？',  '廚餘', '果皮', '輪胎', '木桌', 3),
(1147,  '初級', '下列哪一種行為「無法」減少垃圾量？',  '外食自備餐具', '買包裝複雜的商品', '自備購物袋',  '不使用塑膠袋', 2),
(1148,  '初級', '下列哪種行為「無法」達到垃圾減量的目的？', '做好垃圾分類的工作',  '將廚餘製成有機肥料',  '落實資源回收再利用',  '大量消費', 4),
(1149,  '初級', '下列哪個選項「不是」利用廚餘製作有機肥的好處？',  '資源再利用',  '使土地得到滋養',  '垃圾量減少',  '酸雨減少', 4),
(1150,  '初級', '生活中的瓶瓶罐罐可以做何利用？',  '垃圾桶或收集盒',  '花瓶', '筆筒', '以上皆是', 4),
(1151,  '初級', '家裡要淘汰的衣服，怎樣處理「最不」符合環保觀念？', '用垃圾袋打包丟掉', '投入舊衣回收箱',  '捐給慈善團體', '送給需要的人穿',  1),
(1152,  '中級', '生活中產生的剩菜、剩飯等是何種廢棄物？',  '資源垃圾', '廚餘', '有害垃圾', '有害事業廢棄物',  2),
(1153,  '初級', '下列哪個選項「不是」環保標章的概念？', '低污染',  '可回收',  '省資源',  '低單價',  4),
(1154,  '初級', '冬天時要把溫暖傳送給需要幫助的人，下列哪個方法正確？', '發送捐助熱食', '發送捐助厚棉被',  '發送捐助保暖衣物', '以上皆是', 4),
(1155,  '初級', '以下哪些是幫助別人的行為？',  '捐過期發票',  '捐不堪使用的舊衣服',  '捐贈已過使用期限很久的食物',  '捐贈二手書',  4),
(1156,  '初級', '利用排泄物與農作物廢棄物當燃料發電，指的是下列哪種能源？', '地熱', '核能', '生質能',  '太陽能',  3),
(1157,  '初級', '製造生質能的燃料有許多種，下列哪個選項中的物品「不能」當作燃料？', '稻草', '食物腐敗後產生的沼氣', '豬糞', '核廢料',  4),
(1158,  '初級', '關於珍惜資源，下列哪個選項是「錯誤」的？', '玩具壞掉了，我會嘗試修理看看', '不能修理的玩具，我會動動腦改造它', '已經不玩的玩具，我會送給需要的人', '我的玩具很多，不想玩的就丟掉', 4),
(1159,  '初級', '鋪設柏油路面時，加入下列哪種材質可以提高反光度並增加夜間行車的安全？', '廢電池',  '廢玻璃',  '黃金', '塑膠袋',  2),
(1160,  '初級', '在河流通過的地方設置垃圾掩埋場，會造成下列哪種影響？', '減少垃圾所造成的土壤污染', '加速垃圾的腐爛程度',  '垃圾先造成土壤污染，再造成水污染', '會造成熱能，使河川水溫增高',  3),
(1161,  '初級', '愛護環境的具體行動，「不包括」下列哪個選項？', '不放生或棄養動物', '響應淨山、淨灘等活動', '有毒的廢水直接排入水溝或河川', '保護各種生物的棲息地', 3),
(1162,  '初級', '在生活經常使用的物品中，下列何者會產生破壞臭氧層的化學物質？', '塑膠碗',  '免洗筷',  '冷媒、噴霧劑', '立可白',  3),
(1163,  '初級', '下列哪個選項「不是」實施有機栽培的益處？', '提高化學肥料產量', '減少農藥的使用',  '保護環境', '提升產品競爭力',  1),
(1164,  '初級', '有機農業的培育過程不使用農藥與化學肥料，符合下列哪種觀念？',  '便利生活', '資源回收', '永續發展', '使用再生能源', 3),
(1165,  '初級', '下列哪種物質在農田裡會對土地造成污染？',  '死掉的昆蟲',  '腐爛的農作物', '農藥', '雜草', 3),
(1166,  '初級', '社區裡發生一些狀況時，下列哪個選項的做法是「錯誤」的行為？',  '機車亂排，請警察拖吊開罰', '發現廣告隨意張貼，向環保局反應',  '樓梯間堆放垃圾，不曉得是誰家的，所以不要管它', '晚上睡覺時間鄰居唱卡拉OK聲音太大，請警察協助勸說',  3),
(1167,  '初級', '下列何種方式能於第一時間有效避免傳染病由國外傳入國內？',  '金屬探測器',  'Ｘ光機掃描器', '護照檢驗', '機場檢疫措施', 4),
(1168,  '初級', '下列哪個選項「不是」任意堆放垃圾所造成的影響？',  '污染水和土壤', '影響市容', '使土地肥沃，適合種植', '病媒蚊孳生，引發傳染疾病', 3),
(1169,  '初級', '社區環境需要大家一起共同維護，下列哪個選項是「錯誤」的行為？', '在牆壁或地面上塗鴉',  '愛護公共設施', '參與社區整潔活動', '清理狗大便',  1),
(1170,  '初級', '寒暑假結束後，在校園裡可以先做什麼環境整理的工作？',  '拔除花圃的雜草',  '清掃落葉', '清潔廁所', '以上皆是', 4),
(1171,  '初級', '想要避免室外蚊蟲孳生，擁有乾淨整潔的環境，下列何者正確？', '清理水溝', '清除廢輪胎',  '清理積水容器', '以上皆是', 4),
(1172,  '初級', '想要避免屋內蚊蟲孳生，擁有乾淨整潔的環境，下列何者正確？', '安裝紗窗', '垃圾桶加蓋',  '使用捕蚊燈',  '以上皆是', 4),
(1173,  '初級', '為什麼核廢料放置場必須加強安全維護？', '減少消耗地球資源', '避免輻射外洩污染', '具有高經濟價值',  '可以再利用',  2),
(1174,  '初級', '發電廠、原子能、輻射外洩，以上關鍵字與下列哪個選項中的危機有關聯？',  '傳染病危機',  '核能危機', '生態危機', '倫理危機', 2),
(1175,  '初級', '下列哪個選項「不是」造成環境污染的行為？', '工廠排放黑煙', '家庭污水排放至河川',  '種植樹木', '汽機車排放廢氣',  3),
(1176,  '初級', '下列哪個選項「不是」酸雨帶來的影響？', '土壤變成酸性土質', '增加農作物產量',  '汽車烤漆剝落部位容易生鏽', '毀損建築物',  2),
(1177,  '初級', '下列哪個選項是空氣污染的來源？',  '將廢土傾倒在河裡', '將廚餘等垃圾丟進海裡', '燃燒電纜線所產生的廢氣',  '垃圾掩埋場滲出的污水', 3),
(1178,  '初級', '下列哪個選項是造成臭氧層破洞的原因？', '人類不斷砍伐森林', '人類大量使用氟氯碳化物',  '汽機車燃石油排放廢氣', '過度使用農藥及化學肥料',  2),
(1179,  '初級', '下列哪個選項是酸雨會造成的危害？', '發生土石流',  '產生溫室效應', '產生聽力障礙', '侵蝕大理石建築物', 4),
(1180,  '初級', '工廠露天燃燒廢五金違反下列哪一種環保法規？',  '水污染防制法', '野生動物保護法',  '噪音管制法',  '空氣污染防制法',  4),
(1181,  '高級', '空氣污染指標大於等於300，表示空氣品質如何？',  '有害', '不良', '普通', '良好', 1),
(1182,  '高級', '空氣污染指標介於0至50，表示空氣品質如何？', '有害', '不良', '普通', '良好', 4),
(1183,  '初級', '空氣污染會產生下列哪種現象？', '酸雨', '乾旱', '農作物產量增加',  '電器耗電量增加',  1),
(1184,  '初級', '當空氣污染嚴重時，會對人體產生下列哪種影響？', '呼吸道不舒服', '牙齒痛',  '昏睡', '體重減輕', 1),
(1185,  '中高級',  '工廠發生PVC粉塵外洩污染，是屬於下列哪種污染？', '空氣污染', '垃圾污染', '水污染',  '土壤污染', 1),
(1186,  '初級', '下列哪種物質溶入雨水後會形成酸雨？',  '牛羊豬的排泄物',  '蒸發的檸檬汁', '火力發電廠排放的廢氣', '沙塵', 3),
(1187,  '初級', '下列哪種發電方式需要大量的冷卻水？',  '風力發電', '水力發電', '核能發電', '以上皆是', 3),
(1188,  '初級', '火力發電對環境造成的主要影響為何？',  '增加放射性物質',  '改變水庫生態', '排放溫水造成魚蝦死亡', '增加空氣污染', 4),
(1189,  '初級', '有關酸雨的敘述，下列哪個選項是「錯誤」的？',  '不會對建築物產生影響', '會危害人體健康',  '汽機車排放的廢氣是酸雨的成因之一', '限制煤的燃燒可以控制酸雨量',  1),
(1190,  '初級', '下列哪一種發電方式「最不」環保？', '火力發電', '風力發電', '太陽能發電',  '水力發電', 1),
(1191,  '初級', '關於污染的敘述，下列哪個選項是正確的？',  '被污染的土壤仍然可以耕種稻米', '用受污染的水灌溉土壤，土壤也會被污染', '垃圾處理不當只會造成空氣污染問題', '抽菸不會造成空氣污染', 2),
(1192,  '初級', '下列哪個選項的行為是正確的？', '將廢棄物倒在海裡', '大量噴灑農藥', '工廠廢水不經處理，直接排放到河川', '利用自然濕地淨化污水', 4),
(1193,  '初級', '把落塵檢測器放在校園的不同地點，下列哪個選項所檢測的落塵量會最多？',  '老師辦公室',  '圖書館閱覽室', '校園戶外停車場',  '教室抽屜裡',  3),
(1194,  '初級', '綠色植物除了能供應人們和動物所需的食物外，最重要的是還有什麼功用？',  '減少空氣濕度', '分解動物屍體', '淨化空氣', '過濾污染物',  3),
(1195,  '中級', '收集酸雨，用石蕊試紙檢驗會有下列哪種變化？',  '藍色石蕊試紙變紅色',  '紅、藍石蕊試紙都不變色',  '紅色石蕊試紙變藍色',  '都變成黑色',  1),
(1196,  '初級', '下列哪個選項中的植物種子是經由動物傳播？', '番茄', '椰子', '鳳仙花',  '蒲公英',  1),
(1197,  '初級', '下列哪個選項「不是」世界地圖中的五大洲？', '亞洲', '美洲', '大洋洲',  '澳洲', 4),
(1198,  '初級', '下列哪個選項是愛護自然生態的正確行為？',  '在山坡地大量種植檳榔樹',  '不破壞環境，不傷害各種生物',  '把國外帶回來的植物栽種在野外', '把牛蛙放生在池塘裡',  2),
(1199,  '初級', '下列哪個選項中的植物果實和種子是經由自身力量傳播？',  '鳳仙花',  '番茄', '木瓜', '葡萄', 1),
(1200,  '中高級',  '非生長在水中的植物可分成「葉背有孢子囊群」和「葉背沒有孢子囊群」二類，下列哪一項植物是屬於「葉背有孢子囊群」的植物？', '木瓜', '腎蕨', '黃鵪菜',  '大花咸豐草',  2),
(1201,  '初級', '地球整體的自然環境息息相關，形成一個緊密的生態圈，生態圈裡的森林和熱帶雨林的功能「不包含」下列哪個選項？', '保護土壤', '調節氣候', '提供生物棲息地',  '生成煤炭與石油',  4),
(1202,  '初級', '有些國家為種植具經濟價值的棕櫚樹，不斷開墾土地，使哪一項自然環境資源逐漸減少？',  '油田', '熱帶雨林', '海洋資源', '非再生能源',  2),
(1203,  '初級', '有些植物的果實能鉤附在動物身上以利繁殖後代，這類果實的特徵是什麼？',  '有勾刺',  '鮮甜多汁', '有細毛',  '可浮在水面上', 1),
(1204,  '初級', '依據二分法將植物生長環境分成「長在水中」和「不是長在水中」二類，下列哪一項植物是屬於「長在水中」的植物？', '布袋蓮',  '大花咸豐草',  '筆筒樹',  '木瓜', 1),
(1205,  '初級', '絲瓜所開的花全凋謝後，接下來可以觀察到什麼現象？', '絲瓜也會接著枯萎', '絲瓜藤長出很多新花',  '雌花凋謝後，會長出果實',  '雄花凋謝後，會長出果實',  3),
(1206,  '初級', '對於大甲溪上游的描述，下列哪個選項是「錯誤」的？', '有櫻花鉤吻鮭', '有德基水庫',  '有峽谷和瀑布', '有高美溼地紅樹林', 4),
(1207,  '初級', '臺灣四周散布著許多具有特色的離島，下列哪個選項是「錯誤」的描述？', '由於魚類資源豐富，居民多以漁業及觀光業維生',  '金門島位於馬祖列島北方，屬於大陸島',  '琉球嶼、東沙島、太平島屬於珊瑚礁島',  '澎湖群島、綠島、蘭嶼、釣魚臺列嶼、龜山島屬於火山島',  2),
(1208,  '初級', '臺灣島島形狹長，雖然面積不大，但各地氣候與動植物分布都有明顯差異，最主要的原因是下列哪個選項？',  '緯度高低差異', '地形高低起伏顯著', '降雨量分布不均',  '土壤肥沃的差異程度',  2),
(1209,  '初級', '關於臺灣地形樣貌的描述，下列哪個選項是「錯誤」的？',  '位於歐亞板塊與菲律賓板塊交界處',  '分為山地、丘陵、臺地、盆地、平原，五大地形',  '中央山脈因位於臺灣島中央而得名',  '山地主要分布於島的中央及東部沿海地區', 3),
(1210,  '初級', '下列哪一座山是臺灣的第一高峰？',  '阿里山',  '玉山', '陽明山',  '合歡山',  2),
(1211,  '初級', '下列哪個平原是臺灣最大的平原？',  '宜蘭平原', '花東縱谷平原', '屏東平原', '嘉南平原', 4),
(1212,  '初級', '有關臺灣的敘述，下列哪個選項是「錯誤」的？',  '臺灣擁有豐富的海洋和森林資源', '臺灣地區地勢平坦，平原與盆地較多', '臺灣山地多平原少', '臺灣是一個四面環海的海島', 2),
(1213,  '初級', '對於臺灣島的敘述，下列哪個選項正確？', '位於太平洋與歐亞大陸的交界處', '各地的氣候都有不同的變化', '位在季風盛行的區域裡', '以上皆是', 4),
(1214,  '初級', '下列對於臺灣珍貴資源的敘述，哪個選項是「錯誤」？', '水筆仔是淡水紅樹林常見的植物', '太魯閣的峽谷是大理石構成的',  '臺灣獼猴是臺灣特有種動物', '女王頭是野柳著名的風積現象',  4),
(1215,  '初級', '關於臺灣的自然環境，下列哪個選項是「錯誤」的？',  '位處板塊交界處',  '礦物與能源資源有限',  '受季風吹拂，雨量豐沛', '平原多於高山', 4),
(1216,  '初級', '下列哪個選項「不是」臺灣的自然生態環境？', '山地', '極地', '濕地', '森林', 2),
(1217,  '初級', '下列哪個選項「無法」減輕環境污染？',  '工廠廢水排放管制', '制定農藥使用標準', '汽、機車排氣定期檢驗', '開放森林保育區興建工廠',  4),
(1218,  '初級', '下列哪個選項是植物產生種子的主要用途？',  '用來繁殖下一代',  '做為儲存水分之用', '提供給其他生物當做糧食',  '當作防禦及攻擊的武器', 1),
(1219,  '初級', '下列哪種環境中可以看到巨大的樹木和爬藤植物？', '非洲大草原',  '沙漠環境', '熱帶雨林', '濱海沼澤地區', 3),
(1220,  '初級', '戶外教學一路上看到冷杉、檜木、招潮蟹、彈塗魚、珊瑚礁等不同生物，應該「沒有」經過哪一種地形？', '河口濕地', '沙漠', '海邊', '高山', 2),
(1221,  '初級', '在地球生物圈裡，能夠調節氣候、吸收水氣、增加空氣濕度等功能是下列哪一種環境？', '河川', '沙漠', '森林', '冰山', 3),
(1222,  '初級', '有關臺灣氣候的特徵，下列哪個選項是正確的？',  '受地形影響，同一緯度可能出現熱帶、溫帶和寒帶', '夏季東北季風盛行，氣候濕冷；冬季吹西南季風，北部天氣濕熱', '臺灣雨量豐沛，降雨多集中在冬季',  '臺灣以北回歸線為界，以北為熱帶氣候；以南為副熱帶氣候', 1),
(1223,  '初級', '我們可以在澎湖看到下列哪種壯觀的景象？',  '珊瑚礁',  '峽谷', '泥火山',  '柱狀玄武岩',  4),
(1224,  '初級', '臺灣東部地區受到下列哪一座山脈的阻隔，使得交通較為不便？', '雪山山脈', '阿里山山脈',  '中央山脈', '海岸山脈', 3),
(1225,  '初級', '臺灣哪個地區可以看到柱狀玄武岩？', '金門', '澎湖', '馬祖', '綠島', 2),
(1226,  '初級', '下列哪個選項中的植物果實和種子是經由水力傳播？',  '橘子', '葡萄', '椰子', '辣椒', 3),
(1227,  '初級', '植物繁殖除了用種子之外，還可以用什麼方式繁殖下一代？', '種植花瓣', '種植樹皮', '種植花萼', '種植根、莖、葉',  4),
(1228,  '初級', '馬鈴薯肥大的莖主要功能在儲存養分，下列哪個選項中的植物莖具有相同功能？',  '薑',  '苦瓜', '長春藤',  '番薯', 1),
(1229,  '初級', '牽牛花的莖具有攀爬功能，可以將植物體延伸到適合生長的地方，下列哪個選項中的植物莖具有相同功能？',  '鬱金香',  '蓮藕', '荸薺', '絲瓜', 4),
(1230,  '初級', '臺灣黑熊是保育類動物，我們應該如何保護牠們？', '開發、砍伐森林',  '告訴大家不要買也不要吃熊膽和熊掌', '獵熊是很英勇的事', '熊膽和熊掌是很好的中藥材', 2),
(1231,  '初級', '櫻花鉤吻鮭是臺灣的國寶魚，是屬於哪個級別的保育類動物？',  '一級', '二級', '三級', '沒有區分級別', 1),
(1232,  '初級', '屏東縣墾丁地區有些人利用「鳥仔踏」，違法捕捉下列哪種動物？',  '紅尾伯勞鳥',  '灰面鵟鷹', '黑面琵鷺', '黃裳鳳蝶', 1),
(1233,  '初級', '小動物真可愛，下列哪個選項「不是」愛護牠們的行為？',  '靜靜觀賞，不去打擾牠們',  '不去捕捉牠們', '把牠們抓起來玩耍', '不踢打貓狗等動物', 3),
(1234,  '中高級',  '下列哪一位人士致力於黑猩猩的保育而備受尊崇？', '瑞秋卡森', '西雅圖',  '李奧波',  '珍古德',  4),
(1235,  '初級', '民眾任意獵捕伯勞鳥會觸犯下列哪項法律？',  '空氣污染防制法',  '野生動物保育法',  '水污染防治法', '噪音管制法',  2),
(1236,  '初級', '關於黑面琵鷺的敘述，下列哪個選項是「錯誤」的？',  '成群到臺灣過冬',  '有黑黑扁扁的長嘴巴',  '牠們在臺灣繁殖下一代', '又稱飯匙鳥、琵琶嘴鷺', 3),
(1237,  '初級', '板塊持續推擠除了造成頻繁的地震外，還導致下列哪個現象的產生？', '海岸山脈向中央山脈逐漸靠攏',  '導致地層下陷日益嚴重', '多數山脈由南北走向變成東西走向',  '多數河川的走向改變',  1),
(1238,  '初級', '颱風侵襲時會帶來很多災害，但「不包括」下列哪個選項？', '水庫蓄水量增加',  '山坡地發生土石流', '路樹、招牌倒塌',  '低窪地區淹水', 1),
(1239,  '初級', '下列何者「不是」颱風帶來的災害？', '豪雨引發土石流',  '帶來豐沛雨量，造成低漥地區淹水',  '地面隆起，壩堤變形',  '狂風暴雨，招牌、花盆掉落', 3),
(1240,  '初級', '撒哈拉沙漠不斷進行公路維護工程，其原因是下列哪個選項？',  '陽光和酷熱，使公路損壞',  '防制土地沙漠化現象擴大',  '當地游擊隊橫行，常破壞公路',  '施工時偷工減料，導致事後要做補強與修護',  2),
(1241,  '初級', '對於臺灣氣候的描述，下列哪個選項是正確的？',  '冬季少有寒流來襲', '澎湖群島多強風烈日少降雨', '南部四季有雨', '平地雨量多於山地', 2),
(1242,  '中高級',  '下列哪個國家較「不會」受到春季中國北方沙塵暴的影響？', '澳大利亞', '臺灣', '日本', '韓國', 1),
(1243,  '初級', '大陸華北地區因工業發達燃燒煤炭，產生二氧化硫，常隨著哪種季風飄來臺灣北部，產生酸雨的問題？',  '東北季風', '東南季風', '西北季風', '西南季風', 1),
(1244,  '初級', '地區與其土地開發利用的關聯性，下列哪個選項是「錯誤」的？', '高雄的平原-農地', '通霄鎮山坡地-牧場',  '海埔新生地-魚塭', '阿里山林場-果園', 4),
(1245,  '初級', '臺灣山脈「沒有」明顯升高，是受到下列哪個因素的影響？', '地層下陷', '山坡地開發',  '侵蝕作用', '地震頻繁', 3),
(1246,  '初級', '地區與其主要物產的關聯性，下列哪個選項是「錯誤」的？', '嘉南平原-水稻',  '屏東大鵬灣-漁業', '坪林-葡萄',  '臺東初鹿-乳牛',  3),
(1247,  '初級', '新竹的米粉好吃又有彈性，主要應歸功於下列哪個季風的吹拂？', '東北季風', '東南季風', '西北季風', '西南季風', 1),
(1248,  '初級', '下列哪一種人類行為對環境有正面的影響？',  '闢建高爾夫球場',  '劃定自然保護區',  '開發森林遊樂區',  '興建水庫', 2),
(1249,  '中級', '校園中較潮濕陰暗的地方，容易觀察到哪種植物？', '蒲公英',  '咸豐草',  '蕨類', '向日葵',  3),
(1250,  '初級', '臺灣大部分的蘇鐵凋萎，主要的原因是下列哪個選項？', '有計畫的讓蘇鐵凋萎',  '天災', '缺水枯死', '被白輪盾介殼蟲寄生繁殖',  4),
(1251,  '初級', '校園中較潮濕陰暗的地方，容易觀察到哪種生物？', '蝸牛', '蚯蚓', '蛞蝓', '以上皆是', 4),
(1252,  '初級', '導致臺灣河流沖刷力道十分強勁的原因是下列哪個選項？',  '平原廣大', '面積狹小', '高山陡峭', '氣候溫暖', 3),
(1253,  '中級', '哪種地貌是由大自然的力量造成的，下列何者正確？',  '南投的九九峰', '太魯閣的V型峽谷', '高雄的月世界', '以上皆是', 4),
(1254,  '初級', '下列何者「不屬於」人為的環境問題？',  '工廠燃燒油品、排放污水',  '油輪漏油污染海洋', '921大地震', '濫用農藥', 3),
(1255,  '初級', '下列何者屬於自然的災害？', '核能發電廠附近海域珊瑚白化',  '濫用農藥', '油輪漏油污染海洋', '921大地震', 4),
(1256,  '初級', '發生森林大火時，消防單位最常採取下列哪種方式來滅火？', '利用雲梯車從高處灑水滅火', '覆蓋大量的沙土滅火',  '等火熄滅再來搶救', '將周圍林木移除，開闢防火巷',  4),
(1257,  '初級', '下列何者「不是」臺灣常見的自然災害？', '颱風', '寒流', '海嘯', '地震', 3),
(1258,  '初級', '大家一起動手種樹來綠化環境。下列哪個選項「不是」種樹的好處？', '吸收空氣中的二氧化碳', '產生落葉，造成髒亂',  '增加土壤的吸水力', '調節氣溫', 2),
(1259,  '初級', '人類過度用水，加上砍伐熱帶雨林，會造成下列哪種影響？', '石油枯竭', '土壤保水性變差',  '河川暴漲', '增加空氣濕度', 2),
(1260,  '初級', '濫伐森林會造成下列哪種結果？', '土石流肆虐',  '全球暖化加劇', '生物滅種', '以上皆是', 4),
(1261,  '初級', '下列哪個選項被稱為「地球之肺」，具有淨化空氣的功能？', '海洋', '水庫', '森林', '草原', 3),
(1262,  '初級', '砍伐森林會造成什麼影響？', '增加森林大火的機會',  '減少土石流發生的機會', '森林裡動物的棲息地消失',  '淨水功能提升', 3),
(1263,  '初級', '我們應該如何愛護植物？',  '在樹幹上刻字', '攀折樹枝', '為植物澆水',  '在樹上裝飾霓虹燈', 3),
(1264,  '中級', '臺灣保育人士致力於棲蘭山的保育工作，主要是因為棲蘭山擁有下列哪種珍貴物種？',  '原生檜木', '臺灣水韭', '烏來杜鵑', '臺灣黑熊', 1),
(1265,  '初級', '下列哪個地區可以發現具有肥厚的脂肪層、能生存在低溫環境中的動物？', '草原', '熱帶雨林', '濱海沼澤', '極地', 4),
(1266,  '初級', '下列哪個選項可以看出臺灣在生態保育方面的成果？',  '設網捕捉來臺過冬的候鳥',  '走私犀牛角',  '進行標放紫斑蝶活動',  '私自飼養保育類動物',  3),
(1267,  '初級', '下列哪種動物可以適應沙漠的環境？', '企鵝', '孟加拉虎', '駱駝', '亞洲象',  3),
(1268,  '初級', '下列哪種動物可以適應極地的環境？', '企鵝', '孟加拉虎', '駱駝', '亞洲象',  1),
(1269,  '初級', '下列哪個選項屬於臺灣原生種？', '紅火蟻',  '櫻花鉤吻鮭',  '琵琶鼠魚', '牛蛙', 2),
(1270,  '初級', '八色鳥被列為稀有瀕危的動物。有關八色鳥的描述，下列哪個選項正確？', '在臺灣是屬於夏候鳥',  '羽毛具有八種顏色', '在臺灣低海拔丘陵山區活動', '以上皆是', 4),
(1271,  '初級', '下列哪一種植物屬於臺灣原生種？',  '銀合歡',  '小花蔓澤蘭',  '大花咸豐草',  '玉山杜鵑', 4),
(1272,  '初級', '下列哪個選項「不是」臺灣特有的生物？', '臺灣水韭', '黑面琵鷺', '蘭嶼角鴞', '烏來杜鵑', 2),
(1273,  '初級', '下列哪個選項是臺灣的原生物種？',  '吳郭魚',  '福壽螺',  '烏來杜鵑', '琵琶鼠魚', 3),
(1274,  '初級', '下列哪種魚是臺灣的一級國寶魚？',  '黑鮪魚',  '石斑魚',  '琵琶鼠魚', '櫻花鉤吻鮭',  4),
(1275,  '初級', '下列哪種鳥類經常於每年10月自北方經過臺灣到南方過冬，所以又稱「國慶鳥」？',  '黑面琵鷺', '灰面鷲',  '白頭翁',  '蘭嶼角鴞', 2),
(1276,  '初級', '臺灣水韭為臺灣的特有植物，主要生育地在夢幻湖，其位於下列哪個區域？',  '臺江國家公園', '太魯閣國家公園',  '玉山國家公園', '陽明山國家公園',  4),
(1277,  '初級', '櫻花鉤吻鮭的生長環境有何特色？',  '水流速度較出海口緩慢', '溪流邊都是圓滑的鵝卵石',  '河道較窄', '河道坡度非常平緩', 3),
(1278,  '初級', '為了保護生態環境，下列哪個選項的作為是正面積極的？',  '大量抽取地下水',  '設立自然保育區',  '在濕地闢建魚塭、養殖貝類', '在河邊養魚',  2),
(1279,  '初級', '下列哪一種「不是」臺灣特有種生物？',  '長鬃山羊', '玉山杜鵑', '櫻花鉤吻鮭',  '紅毛猩猩', 4),
(1280,  '初級', '下列哪個選項的敘述「不是」保護櫻花鉤吻鮭的正確方法？', '在棲息地建造水壩', '禁止在櫻花鉤吻鮭棲息地打獵',  '禁止在水源保護區舉辦活動', '設置野生動物保護區',  1),
(1281,  '初級', '臺東縣鹿野鄉的龍田村，對下列哪種生物的復育工作貢獻良多？', '臺灣獼猴', '莫氏樹蛙', '長鬃山羊', '蝴蝶', 4),
(1282,  '初級', '人們引進國外動、植物會帶來下列哪種影響？', '增加臺灣生物的多樣性', '增加臺灣經濟繁榮', '促進臺灣的生物競爭能力',  '破壞臺灣的生態平衡',  4),
(1283,  '初級', '下列哪一種生物「不是」臺灣的外來種？', '蘭嶼角鴞', '小花蔓澤蘭',  '福壽螺',  '琵琶鼠魚', 1),
(1284,  '初級', '為了使自然界的生物生生不息，下列哪一種行為是「錯誤」的？', '不隨意引進國外生物',  '不隨意破壞或帶走屬於大自然的一草一木', '野生動物不易吃到，偶爾吃吃沒關係', '不任意放生或飼養外來種',  3),
(1285,  '初級', '生長速度非常快，有纏勒覆蓋的本事，能使植物窒息而死，入侵臺灣後大量蔓延生長，有植物殺手之稱的外來種是下列哪個選項？',  '大花咸豐草',  '馬纓丹',  '小花蔓澤蘭',  '銀合歡',  3),
(1286,  '初級', '有關生態保育的觀念，下列哪個選項是「錯誤」的？',  '不過度開發山林',  '不鼓勵民眾大量飼養珍禽異獸',  '不捕殺、食用野生動物', '隨意引進外來的動物、植物', 4),
(1287,  '初級', '下列哪個物種是臺灣淡水水域的外來種？', '櫻花鉤吻鮭',  '美洲螯蝦', '高身鏟頜魚',  '埔里中華爬岩鰍',  2),
(1288,  '初級', '下列哪種兩棲爬蟲類是臺灣的外來種？',  '莫氏樹蛙', '菊池氏龜殼花', '楚南氏山椒魚', '', 0),
(1289,  '高級', '下列哪種昆蟲是臺灣的外來種？', '紅火蟻',  '渡邊氏長吻白蠟蟬', '短腹幽蟌(ㄘㄨㄥ)',  '曙(ㄕㄨˋ)鳳蝶', 1),
(1290,  '初級', '下列哪種植物是臺灣的外來種？', '玉山一葉蘭',  '牛樟', '小花蔓澤蘭',  '烏來杜鵑', 3),
(1291,  '初級', '下列哪個選項「不是」野生動、植物瀕臨絕種的原因？', '人們不當引進外來種',  '人們缺乏環境保育觀念', '人們拒食保育類動、植物',  '野生動、植物的棲息地被人類破壞',  3),
(1292,  '初級', '關於臺南市七股的「潟湖」，下列哪個選項是「錯誤」的描述？', '介於沙洲和海岸之間',  '海水完全被攔阻而圍成', '內有陸地河流沉積物',  '受洋流潮汐影響，形成天然的養殖場', 2),
(1293,  '初級', '關於雲林、嘉義兩縣交界外海的「沙洲」，下列哪個選項是「錯誤」的描述？', '為河流和洋流帶來的泥沙沉積所形成', '屬於離岸沙洲', '為西北-東南走向的狹長沙洲',  '又稱為外傘頂洲',  3),
(1294,  '初級', '下列哪一個國家公園裡面可以見到珊瑚礁美景？',  '墾丁國家公園', '太魯閣國家公園',  '玉山國家公園', '陽明山國家公園',  1),
(1295,  '初級', '在太魯閣國家公園可以看見下面哪一種地形？', '珊瑚礁',  '峽谷', '泥火山',  '柱狀玄武岩',  2),
(1296,  '中級', '請問臺灣哪一座國家公園可以看到一線天的峽谷地形？', '金門國家公園', '太魯閣國家公園',  '墾丁國家公園', '陽明山國家公園',  2),
(1297,  '初級', '下列哪一個國家公園位於臺灣本島的最北端？', '雪霸國家公園', '太魯閣國家公', '陽明山國家公園',  '墾丁國家公園', 3),
(1298,  '初級', '下列哪個地方可以見到地熱、噴氣孔和硫磺結晶等地形？',  '墾丁國家公園', '臺江國家公園', '太魯閣國家公園',  '陽明山國家公園',  4),
(1299,  '初級', '下列哪個選項「不是」臺灣設立國家公園的目的？', '保護自然風景', '讓高山繼續上升',  '提供國民育樂及研究',  '保護野生動、植物', 2),
(1300,  '初級', '對於珍惜資源，下列哪一種行為是「錯誤」的？',  '選購有節能標章的電器產品', '隨手關水、電源的開關', '儘量搭乘大眾交通工具上下班',  '多開發山林資源作為遊樂區', 4),
(1301,  '初級', '下列哪個生態環境具有豐富的生物多樣性？',  '熱帶雨林', '冰山', '沙漠', '河川', 1),
(1302,  '初級', '在住家周圍設置下列哪個選項可以讓人們親近自然環境？',  '太陽能燈', '生態池',  '遊樂場',  '雨撲滿',  2),
(1303,  '初級', '有關生態池的敘述，下列哪個選項是「錯誤」的？', '池裡常種植許多水生植物',  '不符合「綠建築」的主張',  '是魚類和蛙類的成長樂園',  '是一種讓人親近自然環境的設計', 2),
(1304,  '初級', '下列哪一種生物「不會」出現在紅樹林？', '招潮蟹',  '黑面琵鷺', '彈塗魚',  '莫氏樹蛙', 4),
(1305,  '初級', '下列哪個選項「不是」河口濕地的生物？', '彈塗魚',  '高翹?',  '鸚鵡螺',  '招潮蟹',  3),
(1306,  '初級', '有關河口濕地生態環境的說明，下列哪個選項是正確的？',  '屬於淡水的水域環境',  '常見的植物是筆筒樹和水筆仔',  '聚集大量的鷹鷲等鳥類', '棲息大量的魚、蝦、貝類',  4),
(1307,  '中級', '下列哪個選項「不是」紅樹林的功能？',  '可以過濾水中化學有機廢物、懸浮物', '可以防止沿海地區的地層下陷',  '可以提供許多生物繁衍和棲息的環境', '其根部有固土護岸的功能',  2),
(1308,  '初級', '下列哪種方法可以保護土壤？',  '減少肥料的使用量', '使用農藥消滅害蟲', '栽種果樹和檳榔樹', '興建蓄水池',  1),
(1309,  '初級', '為了土地的永續發展，下列何者是「錯誤」的作法？',  '重視生物棲息地的保育', '各種地形都應該做好水土保持',  '在不破壞生態的前提下，可以適度地開發土地', '為促進生物多樣性，應引進外來種',  4),
(1310,  '初級', '沒有經過開發的山坡和種滿樹木的山坡地，比較不容易發生土石流，這和植物的哪個構造最有關係？', '根',  '莖',  '葉',  '花',  1),
(1311,  '初級', '下列何者「不能」防止土壤流失？',  '減少山坡地的開發', '不亂砍樹木',  '山坡地大範圍種植檳榔樹',  '保持山林原貌', 3),
(1312,  '初級', '關於透水步道的敘述，下列哪個選項是「錯誤」的？',  '它的透水性佳', '可以涵養自然界的水資源',  '柏油為常見用材',  '使雨水容易滲入地底下', 3),
(1313,  '初級', '下列哪個選項「不是」板塊運動對臺灣的影響？',  '臺灣地震多',  '臺灣島西部平原愈來愈寬',  '臺灣島的形成', '臺灣山脈的形成',  2),
(1314,  '初級', '山坡上的森林被大量砍伐做為耕地或牧場後，會造成下列什麼影響？', '野生動物變多', '可以淨化更多空氣', '雨後容易造成土壤流失', '減少噪音污染', 3),
(1315,  '初級', '菲律賓板塊和歐亞板塊相互擠壓的結果，除了使臺灣島浮出水面外，還讓臺灣島出現了下列哪個現象？',  '海岸線變長',  '海邊砂石變多', '形成好幾條河川',  '形成好幾座山脈',  4),
(1316,  '初級', '菲律賓板塊屬於下列哪一板塊的一部分？', '歐亞板塊', '北美洲板塊',  '印澳板塊', '太平洋板塊',  4),
(1317,  '初級', '臺灣島位在哪兩個板塊的交界處？',  '歐亞板塊和北美板塊',  '菲律賓板塊和澳洲板塊', '菲律賓板塊和歐亞板塊', '印度洋板塊和太平洋板塊',  3),
(1318,  '初級', '下列何者是造成臺灣多地震的主要原因？', '侵蝕作用', '板塊運動', '地層滑動', '堆積作用', 2),
(1319,  '初級', '有關土石流的敘述，下列何者是「錯誤」的？', '由於地勢山高水急，土石流是臺灣的大自然現象',  '不當開墾山坡地，容易造成土石流',  '高山果園種在山頂，就不怕土石流的侵襲', '落實水土保持工作，才能減少土石流的災害',  3),
(1320,  '初級', '臺灣位於下列哪一個地震帶中，所以每年大、小地震不斷？', '大西洋地震帶', '海岸山脈地震帶',  '環太平洋地震帶',  '中央山脈地震帶',  3),
(1321,  '初級', '「臺中光復國中操場因岩層斷裂而抬升約2.5公尺。」試問上述情形是由於下列哪個選項所造成的？',  '火山爆發', '超抽地下水',  '地震', '土石流',  3),
(1322,  '初級', '下列哪種做法可以防止土石流發生？', '在山坡地上蓋民宿', '做好水土保持', '將山坡地闢建成果園',  '大量砍伐森林', 2),
(1323,  '初級', '南投縣九九峰山頭光禿禿的景象是由於下列何者所造成的？', '火山爆發', '土石流',  '超抽地下水',  '地震', 4),
(1324,  '初級', '政府在颱風來臨時常提醒大家要做好防颱準備，下列何者是颱風造成的損害？', '土石流',  '地層下陷', '龍捲風',  '斷層', 1),
(1325,  '初級', '臺灣地震頻繁的主因是什麼？',  '南亞海嘯作用', '板塊持續推擠', '山脈土質流失', '多雨的氣候',  2),
(1326,  '初級', '臺灣在冰河時期曾經與下列何處相連？',  '印尼', '日本', '中國', '南韓', 3),
(1327,  '初級', '造成土石流的原因是下列何者？', '傾倒垃圾', '森林大火', '抽取地下水',  '山坡地濫墾、濫建', 4),
(1328,  '初級', '下列哪個選項是古代生物遺骸埋藏在地底下，經過長時間而形成的液態資源？', '煤炭', '地熱', '石油', '瓦斯', 3),
(1329,  '初級', '下列哪個聚落的發展與採金事業的消長有關？', '花蓮縣富里鄉', '新北市土城區', '新北市瑞芳九份',  '高雄市旗津區', 3),
(1330,  '初級', '下列哪個選項是必須經過千萬年後才有再生機會的自然資源？',  '石油、天然氣', '風、樹木', '水、陽光', '植物、陽光',  1),
(1331,  '初級', '下列哪種能源是動、植物的遺骸分解時，所產生的揮發性物質？', '地熱', '煤礦', '天然氣',  '石油', 3),
(1332,  '中級', '環保工作可從哪些方面著手，下列哪個選項正確？', '物品重複使用及節約能約',  '使用綠色環保產品及垃圾減量',  '垃圾分類與資源回收、垃圾再生', '以上皆是', 4),
(1333,  '中級', '造成臭氧濃度日益降低的主要原因為何？', '地球溫度較高，兩極冰冠縮小，大量海水吸收氧氣', '溫室氣體增加，地表反射的紅外線被大量吸收', '人類大量使用氟氯碳化物',  '極端天氣現象增加，使得臭氧隨大氣對流流動', 3),
(1334,  '中級', '下列哪個選項「不是」政府決定興建核四廠之前，所需要用來判斷是否適宜設廠的考慮要項？',  '地區經濟效益評估', '地主和廠方的遊說', '專家學者的評估',  '生態環境的影響',  2),
(1335,  '中級', '生物多樣性所面臨的主要威脅為何？', '棲息地減少與受到破壞', '過度獵捕、採集及引進外來種',  '環境污染', '以上皆是', 4),
(1336,  '中級', '下列哪一種污染屬於生物圈之污染範疇？', '水污染',  '大氣污染', '垃圾污染', '以上皆是', 4),
(1337,  '中級', '下列何者是現今生物圈所面臨的污染問題？',  '空氣污染', '水污染',  '固體廢棄物污染',  '以上皆是', 4),
(1338,  '中級', '下列哪種因素造成南極洲地區人口分布稀少的現象？',  '地勢高峻', '水源稀少', '氣候嚴寒', '面積廣大', 3),
(1339,  '中級', '臺灣人口分布的特色之一是「西部人口數量多於東部，且較密集」，下列何者是正確的？',  '緯度較低', '盛行季風', '平原較廣', '北回歸線通過', 3),
(1340,  '中級', '中國自1980年進行經濟改革政策，沿海地區經濟快速發展，臺商移民潮也因而一波波湧向該地區，造成臺灣人口變化重大的影響為何？',  '自然增加率提高',  '社會增加率提高',  '自然增加率減少',  '社會增加率減少',  4),
(1341,  '中級', '世界人口不斷地增加，其最主要的原因為何？', '危害人類的病毒種類大幅度減少', '醫藥科技發達，人類死亡率降低', '環境污染問題大幅度改善',  '人類互助，戰爭減少',  2),
(1342,  '中級', '下列何者為政府強化社會福利的作法？',  '減少基本薪資', '減少建設國民住宅', '強化社會福利政策', '減少外籍勞工人數', 3),
(1343,  '中級', '有關臺灣人口分布的特色之一是「東西部分布不均，人口過度集中大都市」，因此容易造成下列哪種問題？',  '人力資源不足', '自然增加率提高',  '進入高齡化社會',  '資源分配不均', 4),
(1344,  '中級', '我國由於經濟因素或觀念的改變，有些夫婦只生育一個子女，或未育有子女，會造成什麼影響？', '人類絕種', '臺灣滅亡', '污染減少', '人口老化的問題日趨嚴重',  4),
(1345,  '中級', '近年來由於人口結構改變，臺灣產生了許多人口議題，需要政府與全民一起解決，但下列何者「不是」臺灣即將面臨的人口問題？',  '少子化趨勢',  '出生率過高',  '新住民移入',  '勞動力不足',  2),
(1346,  '中級', '第二次世界大戰後，臺灣人口結構與日治時期愈來愈不同，有關臺灣近幾年來的人口結構，下列何者是正確的敘述？',  '外籍配偶逐年減少', '銀髮族愈來愈多',  '平均壽命縮短', '出生率逐年增加',  2),
(1347,  '中級', '臺灣老年人口比例逐年攀升，政府在面對這種人口趨勢下，必須採取適當的措施以照顧老年人，下列哪種措施「不是」長久之計？',  '發放老人年金', '宣傳家有一老如有一寶的觀念',  '建立終生學習大學', '設置完善的安養中心',  1),
(1348,  '中級', '臺灣東部地區的人口明顯少於西部地區，造成此現象的因素「不包含」下列哪個選項？', '東部工作機會較少', '東部聯外交通便利', '西部地勢較平坦',  '西部開發歷史較早', 2),
(1349,  '中級', '臺灣在民國99年被列為生育率偏低的國家，此現象最可能是受到下列何種因素影響？', '醫療技術落後', '養育成本過大', '都市發展落後', '傳統觀念影響', 2),
(1350,  '中級', '近幾年來，臺灣少子化現象愈來愈明顯，全臺婦女總生育率屬全球最低，有關臺灣婦女生育率的敘述，下列何者是「錯誤」的？', '醫療設備日新月異', '經濟不景氣',  '年輕男女享樂主義盛行', '受到西方不婚主義的影響',  1),
(1351,  '中級', '地球上大部分生物所需要的能量，都是由下列何者所供應？', '煤炭', '石油', '太陽', '綠色植物', 3),
(1352,  '中級', '秦朝的「田律」規定，每年的一段期間內，不准進山砍伐森林，不准誘捕幼獸；清朝頒布禁令，嚴禁於虎丘周圍設染坊，以保護水質。綜合上述二例內容判斷，其中隱含的觀念與下列哪種做法的目的最類似？',  '運用觀光資源，促進經濟發展',  '採用嚴刑峻罰，遏止犯罪問題',  '限制開發範圍，避免破壞環境',  '立法保護古蹟，維護文化資產',  3),
(1353,  '中級', '永續發展應該建構在哪些基礎之上，下列哪個選項正確？',  '環境保護', '經濟發展', '社會公義', '以上皆是', 4),
(1354,  '中級', '氣候變遷對環境生態造成的影響，「不包括」下列哪個選項？',  '海水面上升',  '造成環境災害', '生物棲息地改變',  '生物多樣性增加',  4),
(1355,  '中高級',  '有關黑潮的敘述，下列哪個選項是正確的？',  '流速快',  '屬於寒流', '含大量有機物，故呈黑色',  '主流流經臺灣西部外海', 1),
(1356,  '中級', '臺灣地區的氣候深受季風的影響，使得冬、夏季各有不同的天氣特徵，試問下列相關敘述哪個選項是正確的？', '夏季盛行西南季風及東南風', '太平洋暖氣團強盛時，盛行東北季風', '臺灣北部地區受東北季風的影響較南部弱', '臺灣東北部地區的冬季較南部寒冷乾燥',  1),
(1357,  '中級', '臺灣南端的恆春半島因受到下列哪一個洋流的影響，終年氣候宜人？', '北太平洋高壓環流', '北太平洋洋流', '黑潮支流', '黑潮(主洋流)',  3),
(1358,  '初級', '因紫外線過量而造成的生物傷害，「不包括」下列何者？',  '眼疾', '皮膚癌',  '免疫系統減弱', '腸胃炎',  4),
(1359,  '中級', '如果全球平均氣溫持續上升，下列哪一現象最能夠造成全球海平面的明顯上升？',  '北極海的浮冰融化', '南極大陸的冰層融化',  '太平洋周圍火山活動增加',  '地球表面的海水潮汐變化增大',  2),
(1360,  '中級', '每日太陽輻射的紫外線指數是由下列哪個單位進行估計並發報？', '環保署',  '中央氣象局',  '天文館',  '中央研究院',  2),
(1361,  '中級', '近年來北極地區冰層面逐漸縮小，其原因為何？',  '全球暖化', '地震', '臭氧層破洞',  '土地荒漠化',  1),
(1362,  '中級', '根據報導指出：「赤道東太平洋海域在2009年1月到4月的最高溫，已創下歷年來的新高。」由本段報導內容，你認為此現象可能為下列哪個選項的徵兆？', '聖嬰年',  '臭氧層破洞增大',  '洋流停止', '火山爆發', 1),
(1363,  '中級', '氣後異常造成的環境災害，「不包括」下列哪個選項？', '乾旱', '豪雨', '暴風雪',  '工業污染', 4),
(1364,  '中級', '由於溫室效應增強，某座山脈的冰河正迅速融化，以每年約10公尺的速度消退，短期內將引起中國、印度等的河川氾濫，造成水災。指下列哪座山脈？',  '天山', '崑崙山',  '大興安嶺', '喜馬拉雅山',  4),
(1365,  '中級', '近年來地球資源逐漸枯竭，環保意識備受重視。在建築方面，為了適應大自然，熱帶濕潤氣候區可採用下列哪種具備綠建築概念的建築物？',  '獸皮帷幕', '傾斜屋頂', '干欄式建築',  '窯洞', 3),
(1366,  '中級', '下列哪種氣體會造成溫室效應，導致海冰融化，使海平面上升？', '一氧化碳', '二氧化碳', '氮氣', '氟氯碳化合物', 2),
(1367,  '中級', '下列哪個選項最有可能是近年來全球暖化日益嚴重的主要原因？', '被大氣吸收的太陽輻射增加，地表大氣中溫室氣體過低', '被大氣反射到太空的太陽輻射增加',  '被地表反射到太空的太陽輻射增加',  '被大氣吸收的地表輻射增加', 4),
(1368,  '中級', '有關臭氧層的敘述，下列哪個選項是「錯誤」的？', '又稱為平流層', '距離地表約20至30公里高',  '可以吸收太陽輻射中的紫外線',  '人類所使用的氟氯碳化物會破壞臭氧層',  1),
(1369,  '中級', '常常聽人家說：「我們的臭氧層破了一個洞」。有關「臭氧洞」的敘述，下列哪個選項是正確的？',  '是指這裏的大氣沒有臭氧了', '是指這裏的大氣臭氧太多了', '是指這裏的大氣臭氧稀薄',  '是指這裏的大氣臭氧正在增加中', 3),
(1370,  '中級', '下列哪個行動「不能」減緩大氣溫室氣體含量增加？',  '搭乘大眾運輸工具', '採用太陽能發電技能',  '於野地大量堆肥以節約資源', '節約用紙以保護森林',  3),
(1371,  '中級', '下列哪個選項是北極永久冰層融化而產生的環境衝擊？', '地球表面吸收太陽輻射量提高',  '海豹與北極熊等極地生物因海洋擴張而更適合生存', '人類可經由東南通道減少航運路程',  '海水密度提高造成洋流加劇', 1),
(1372,  '中級', '東北季風通常盛行在臺灣的哪一個季節？', '春季', '夏季', '秋季', '冬季', 4),
(1373,  '中高級',  '有關氟氯碳化物的敘述，下列哪個選項是正確的？', '氟氯碳化物受到紅外線照射而分解',  '可用來製造冷媒',  '不具溫室氣體的特性',  '因京都議定書規範而減量使用',  2),
(1374,  '中級', '受到全球氣溫逐漸上升，地球的環境也有相當大的變化。試問下列哪個選項「不是」全球暖化所造成的現象？', '水分蒸發速率加快', '兩極的冰層加速融化',  '平均海平面上升',  '溫、寒帶生物棲息地必須往更低緯度處遷移',  4),
(1375,  '中級', '近半世紀以來，大氣中的溫室氣體含量顯著增加，此現象對地球環境有何影響？',  '使世界各地的海水面下降',  '地表接收到的紫外線大量增加',  '隕石直接撞擊地表的機率增加',  '大氣會吸收更多的地表輻射', 4),
(1376,  '中級', '氟氯碳化物分解出氯離子，主要發生在大氣的哪一個分層中？',  '對流層',  '平流層',  '中氣層',  '增流層',  2),
(1377,  '中級', '下列哪個政策的制定與溫室效應有關？',  '《蒙特婁議定書》', '《東京高峰會協議》',  '《生物安全議定書》',  '以上皆非', 4),
(1378,  '中級', '造成北極海永久冰層融化的原因「不包括」下列哪個選項？', '人類大量砍伐森林', '大量興建核能發電廠供電',  '出門均以車代步',  '大量使用化石燃料', 2),
(1379,  '中級', '最近科學家研究發現，南極冰原面積正加速縮減，此一現象的主要原因是下列哪個選項？',  '臭氧層破洞',  '全球暖化', '大氣污染', '太陽輻射增強', 2),
(1380,  '中級', '當平流層中的臭氧含量逐漸減少時，對地球環境造成最直接的危機是下列何者？',  '地表冰川因太陽輻射量增加而融化',  '太陽輻射增加造成地表海水大量蒸發', '地表溫室效應增加，全球氣溫上升',  '地表紫外線入射量增加，生物健康受到影響',  4),
(1381,  '中級', '工業革命之後，地球大氣中的二氧化碳濃度有逐漸增加的趨勢，下列哪個選項「不是」造成此現象的主要原因之一？',  '以石油、天然氣為燃料之工業大幅成長',  '為人類需求而大量砍伐森林', '氟氯碳化物的大量使用', '人口的增加及汽機車的大量使用', 3),
(1382,  '中級', '下列哪個選項「不是」解決溫室效應惡化的有效方法？', '搭乘大眾運輸工具', '減少甲烷排放量',  '使用再生能源', '開發熱帶雨林', 4),
(1383,  '中級', '面對全球暖化危機，下列哪項防治工作「不能」改善或減緩暖化的現象？', '多植樹木', '開發再生能源', '外出多搭乘公共交通工具',  '出門攜帶防晒工具', 4),
(1384,  '中級', '有關酸雨的敘述，下列敘述哪個選項是正確的？',  '大氣中的二氧化碳溶解於雨水中所致', '酸雨對動物危害比較大，對植物沒有影響', '大氣中硫氧化物溶解於雨水中會造成酸雨', '主要為工廠排放的廢氣與汽車廢氣無關',  3),
(1385,  '中級', '當平流層的臭氧含量逐漸減少時，對地球環境造成最直接的危機為何？',  '太陽輻射增加造成地表海水大量蒸發，海平面下降', '地表冰川因太陽輻射量增加而融化，海平面上升',  '地表紫外線入射量增加，生物健康受到影響',  '地表溫室效應增加，全球氣溫上升',  3),
(1386,  '中級', '臺灣的雨水若酸鹼值偏低則稱為酸雨，下列哪個選項是正確的敘述？', '酸雨主要是大氣中的硫化物溶解於雨水中所致', '酸雨主要是大氣中的鹽酸溶解於雨水中所致',  '酸雨主要是和工廠排放廢氣有關，與汽機車排放廢氣無關',  '酸雨對植物危害比較大，對人類則沒有幫助',  1),
(1387,  '中級', '下列哪個選項「不是」臭氧層被破壞所導致的結果？',  '皮膚癌患者增加',  '農作物減產',  '免疫系統受抑制',  '氣候更加穩定', 4),
(1388,  '中級', '「竹風蘭雨」這句諺語的意思是下列哪個選項？',  '颱風侵襲時，新竹與宜蘭風雨都很大', '新竹容易刮颱風、宜蘭容易飄綿綿細雨',  '新竹先刮風再下雨，宜蘭是先下雨再刮風', '新竹風大與宜蘭多雨的氣候特徵', 4),
(1389,  '中級', '一般來說，侵襲臺灣的颱風路徑主要受何者影響？', '北太平洋洋流', '黑潮', '北太平洋高壓環流', '蒙古高壓環流', 3),
(1390,  '中級', '下列哪個選項對於全球大氣中的二氧化碳濃度與地表平均溫度變化關係推論最為合理？', '二氧化碳濃度已逐漸趨於一個穩定數值',  '二氧化碳增加時，地表平均溫度就增加',  '長期來看，地表平均溫度與二氧化碳濃度皆呈現增加的趨勢', '人類大量燃燒化石燃料，大氣中才出現二氧化碳',  3),
(1391,  '中級', '中南部地區為何在颱風過境後，還會持續降下大雨？',  '此時東北季風增強', '颱風中心氣壓升高', '颱風在原地打轉',  '颱風過後引進西南氣流', 4),
(1392,  '中級', '午後雷陣雨常來得急、去得快，往往讓人措手不及。有關午後雷陣雨的敘述，下列哪個選項是正確的？',  '午後雷陣雨僅出現於臺灣西南部', '夏天臺灣盛行的東北風來自於海洋氣團的影響', '氣團性質視其起源地而定',  '源自蒙古大陸的冷氣團為低氣壓', 3),
(1393,  '中級', '冬季時，臺灣南部降雨量比北部少的原因為下列哪個選項？', '中央山脈阻擋東北季風帶來的水氣',  '大陸高氣壓靠近北部',  '太平洋熱帶高壓靠近南部',  '南部氣溫較高不易降雨', 1),
(1394,  '中級', '全球可劃分為熱帶、溫帶、寒帶三個氣候帶。劃分此三個氣候帶的指標為哪兩條緯線？', '本初經線、赤道',  '赤道、回歸線', '回歸線、極圈', '國際換日線、赤道', 3),
(1395,  '中級', '有關臺灣冬季附近洋流對海水溫度影響的敘述，下列哪個選項是「錯誤」的？', '東部有黑潮主流經過',  '臺灣海峽西側有冷海水向南流入', '南部因受到西南季風吹拂，因此海水向北流入臺灣海峽', '西北部的海水溫度較東部或南部低',  3),
(1396,  '中級', '有關臺灣地區的環境特色說明，下列哪個選項是正確的？',  '冬季出現鮪魚群與臺灣海峽洋流的流向有關',  '西南部水產養殖區發生海水倒灌，主要是全球暖化所致', '都市化程度越高，大氣中的氧氣含量將隨之升高',  '終年流經臺灣東部外海的黑潮是由赤道流轉向而來', 4),
(1397,  '中級', '氣象報導常會提及季風與氣團的影響，當氣象局提及下列哪一段報導時，代表臺灣的氣溫下降幅度為「最大」？',  '東北季風', '強烈太平洋暖氣團', '強烈蒙古高壓', '大陸冷氣團',  3),
(1398,  '中級', '梅雨是臺灣農業不可或缺的灌溉資源，但在下列哪一種情況下，將可能導致梅雨期的降雨「減少」？', '當大陸冷氣團逐漸減弱時',  '當雲層通過中央山脈之後',  '當滯留鋒停留的時間過長時', '當下雨過程中，未伴隨打雷時',  1),
(1399,  '中級', '陽明山曾在2005年下雪，下雪屬於水循環中的哪一部分？',  '蒸發', '凝結', '凝固', '降水', 4),
(1400,  '中級', '當發生聖嬰現象時，可以觀察到較溫暖的海水會滯留在東太平洋，下列哪個選項是「錯誤」的敘述？', '祕魯沿海漁獲減少', '亞洲東南部降雨變多',  '南美沙漠地區降下豪大雨',  '世界各地氣候異常，時有豪雨或乾旱發生', 2),
(1401,  '中級', '當颱風入侵臺灣本島時，下列哪個選項是正確的敘述？', '颱風從臺灣東部海面接近時，東部、北部因處於中央山脈的背風面，因此和西南部比較起來，風勢雖大但雨勢較小', '颱風一旦登陸後，經中央山脈的阻隔，威力會相對增強', '登陸臺灣的颱風一般以冬颱居多', '颱風帶來的豪雨，常引發山洪暴發，河水暴漲，甚至導致山崩或土石流',  4),
(1402,  '中級', '聖嬰現象原始定義是因為下列哪個區域的溫度異常升高？',  '南美祕魯一帶陸地', '東大西洋表層海水', '東太平洋表層海水', '歐亞大陸沿海地區', 3),
(1403,  '中級', '聖嬰現象發生時，熱帶太平洋東西兩側的氣候現象會有下列哪種情況發生？',  '東側雨量偏多，甚至有洪水，西側雨量偏少，甚至出現乾旱', '東側雨量偏少，甚至出現乾旱，西側雨量偏多，甚至有洪水', '東西兩側雨量均多，甚至有洪水', '東西兩側雨量均少，甚至出現乾旱',  1),
(1404,  '中級', '臺灣各地的冬季雨量，會受到季風及地型的影響，因此各地的降雨量有所差異。下列哪個選項最有可能是宜蘭的蘭陽平原與嘉義一帶的嘉南平原之冬季平均降雨量？', '蘭陽平原：520毫米；嘉南平原：70毫米', '蘭陽平原：520毫米；嘉南平原：510毫米',  '蘭陽平原：70毫米；嘉南平原：520毫米', '蘭陽平原：70毫米；嘉南平原：80毫米',  1),
(1405,  '中級', '颱風、梅雨及寒潮都是臺灣常見的氣象災害，下列哪個選項是正確的敘述？',  '梅雨是因海洋暖氣團北上，形成暖鋒所造成的降雨現象', '如果同年梅雨和颱風帶來的雨量稀少，則容易發生缺水的現象',  '颱風由熱帶海洋上的高氣壓發展而來', '冬季寒潮來襲時臺灣籠罩在太平洋冷氣團之下', 2),
(1406,  '中級', '颱風常形成於溫暖的海洋地區，其主要原因是下列哪個選項？',  '蒸發旺盛，蒸發所釋放的熱提供颱風能量', '水氣充足，蒸發旺盛，水氣凝結所釋放的熱提供颱風能量',  '溫暖的海洋地區風比較高，可增強颱風的風速', '溫暖的海洋地區氣壓較高，有利於颱風形成',  2),
(1407,  '中級', '關於大氣變化的四則報導中，下列哪個選項屬於「氣候」的範疇？',  '今日臺北紫外線指數達危險級',  '明日臺南的降雨機率為60%',  '貝琪颱風為花蓮山區帶來單日1,100毫米的降水，創觀測紀錄的歷史新高', '臺中明天最高溫28℃、最低溫23℃',  3),
(1408,  '中級', '關於氣團與鋒面的敘述，下列哪個選項是「錯誤」的？', '冷氣團切入將暖氣團向上抬升，會在交界處形成冷鋒',  '鋒面的形成位置，即為冷、暖氣團相遇的交界處',  '當影響臺灣的氣團勢力為暖氣團等於冷氣團時，臺灣地區常有冷鋒過境',  '臺灣夏季大都壟罩在熱帶海洋暖氣團之下', 3),
(1409,  '中級', '關於臺灣天氣的敘述，下列哪個選項是正確的？',  '春末夏初，因為冷暖氣團勢力相當而形成滯留鋒',  '夏季會由於暖鋒通過而形成暖濕的天氣型態',  '秋季由於大陸冷氣團增強，所以不會有颱風',  '冬季的天氣型態，主要受到太平洋冷氣團的影響',  1),
(1410,  '中級', '關於臺灣地區降雨情形的敘述，下列哪個選項是正確的？',  '東北季風盛行時，南部發生豪大雨的機率較北部高', '梅雨季節常是風大雨小的情形',  '颱風來襲時由於風雨強大，中央氣象局會特地另行發布特報', '臺灣地區的水資源主要來自春雨', 3),
(1411,  '中級', '關於臺灣氣象的敘述，下列哪個選項是正確的？',  '夏季侵臺的颱風屬於熱帶性高氣壓',  '梅雨季節是因為在梅花盛開時經常出現連續降雨，故以此命名',  '冬末春初的旱災主要是因為降水不足所引起',  '臺灣近年來多為暖冬，是因為暖鋒經過所影響', 3),
(1412,  '中級', '「聖嬰現象」通常指的是赤道附近的太平洋海水異常升溫持續一段時間的現象，試問每隔幾年發生一次？', '2至3年', '2至5年', '2至7年', '2至10年',  3),
(1413,  '中級', '下列哪一種天氣狀況出現時，臺灣地區在未來幾天內的降雨機率「最低」？',  '強烈冷氣團南下，冷鋒前緣將會在明天通過臺灣',  '衛星雲圖中，大陸地區的華南雲雨帶朝臺灣移動',  '位在花蓮東南方100公里處的颱風直撲臺灣而來', '太平洋高壓系統增強，影響範圍延伸至臺灣全島',  4),
(1414,  '中級', '下列哪個選項「不是」全球暖化所造成的影響？',  '北半球冬季縮短',  '島嶼國家陸地面積增加', '特有種因棲息地消失而絕滅', '海水溫度上升', 2),
(1415,  '中級', '下列哪項「不是」全球暖化造成的現象？', '紫外線增強',  '極端天氣現象的發生次數及嚴重程度提高', '海平面上升，沿岸沼澤地消失',  '生物面臨生態浩劫', 1),
(1416,  '中級', '中國大陸北方燃燒煤炭所產生的二氧化硫和雨水結合，會變成硫酸或亞硫酸，隨著東北季風飄到臺灣，形成「酸雨」。上述現象，主要發生在臺灣的哪一個季節？',  '春季', '夏季', '秋季', '冬季', 4),
(1417,  '中級', '敏督利颱風於2004年侵襲臺灣時，各地風雨交加，而西部地區卻晴朗炎熱且出現焚風的現象。為何天氣狀況會有如此大的差異？', '西部地區為背風面，空氣經過中央山脈因沉降而增溫',  '東部地區本來就比西部地區潮濕', '西部地區有中央山脈阻擋不受颱風影響',  '西部地區受西南季風影響，較溫暖乾燥',  1),
(1418,  '中級', '莫拉克颱風於2009年8月7日侵襲臺灣，造成臺灣中南部沿海地區多處嚴重淹水，淹水的原因除了颱風帶來豐沛的雨量外，下列哪個選項也是可能的因素？', '臺灣西部沿岸有強烈的湧升流',  '黑潮向北流的流量在此季節最大', '颱風使海水增溫，造成海水面上升，導致海水倒灌', '適逢大潮，造成海水倒灌',  4),
(1419,  '中級', '颱風往往會造成嚴重的災害，但也會為我們帶來好處，下列哪個選項是颱風為臺灣所帶來最大的好處？',  '豪雨增加水庫蓄水量',  '大量的土石可以種植作物',  '強勁的風可以發電', '上游沖刷下來的樹木可以作為建材',  1),
(1420,  '中級', '澎湖在冬天常常發生「寒害」，不僅造成養殖漁業損失慘重，野生魚類死亡情形也很嚴重，衝擊澎湖漁業產量及周遭生態。有關「寒害」的相關敘述，下列何者正確？',  '因為大陸冷氣團快速北上所造成', '寒害發生期間，氣壓較低',  '對農作物並無影響', '魚類大量死亡', 4),
(1421,  '中級', '關於天氣預報中常見名詞的敘述，下列哪個選項是正確的？', '由等壓線圖可推測大概的天氣狀況',  '若某地降雨機率為50%，表示該地有一半的時間會下雨',  '紫外線指數達過量級時，表示臭氧濃度在此刻最高', '某地在衛星雲圖上被雲遮住，表示該地當時被高壓壟罩', 1),
(1422,  '中級', '全世界關注臭氧層被破壞的問題，主要是擔心下列哪個影響？',  '各國溫差變大', '陸地的面積迅速變少',  '生物細胞易產生病變',  '南北極極光增強',  3),
(1423,  '中級', '有關氣候與人類生活的敘述，下列哪個選項是「錯誤」的？', '中國人建屋習慣座南朝北，以收冬暖夏涼之效', '冬季寒潮來襲，可能造成農民損失慘重',  '新竹風勢強勁，所以以風乾法製造米粉',  '蘭嶼居民將房子建在低於海平面處是為了阻擋強勁的海風',  1),
(1424,  '中級', '近年來生態研究，發現許多生物分布的區域有逐年往更高緯度或更高海拔處移動的趨勢，下列何者是最主要的原因？',  '臭氧洞面積增加',  '聖嬰現象', '全球暖化', '酸雨越趨嚴重', 3),
(1425,  '中級', '天氣現象千變萬化，天氣預報更是一件勞心勞力的工作。有關天氣預報的敘述，下列何者是正確的？', '天氣預報僅需參考地面、高空和衛星等觀測資料',  '紫外線強度並不包含在預報項目內',  '將觀測資料輸入電腦，即可得到準確的預報資料',  '影響天氣變化的因素很複雜增加預報工作的困難度', 4),
(1426,  '中級', '部分生物因外在環境改變而調整行為模式與生活習性。下列哪個選項和上述外在環境改變的形成最有關係？',  '沙塵暴頻率增加',  '工業化程度提高',  '漁業資源的減少',  '聖嬰現象發生', 2),
(1427,  '中級', '聖嬰現象的發生並不會只有影響單一個地區，而是廣泛影響到全世界各地。這種異常的現象是下列哪兩個層圈互相影響、交互作用所產生的結果？', '岩石圈和水圈', '大氣圈和水圈', '大氣圈和岩石圈',  '水圈和軟流圈', 2),
(1428,  '中級', '聖嬰現象發生時，位於太平洋東岸的國家較可能發生下列哪種現象？', '漁獲豐富', '適合栽種耐旱作物', '大量且密集的降雨', '天氣乾冷', 3),
(1429,  '中級', '酸雨對環境影響甚大，下列哪個選項「不是」酸雨所造成的影響？',  '土壤變質', '鐵軌的腐蝕',  '造成水域優養化',  '樹木生長緩慢', 3),
(1430,  '中級', '南美洲祕魯附近海域是一個大漁場，這是由於有一股海流帶來豐富的營養物質，這股海流的性質為何？',  '上升海流，溫度較低',  '上升海流，溫度較高',  '下沉海流，溫度較高',  '下沉海流，溫度較低',  1),
(1431,  '中級', '烏魚是臺灣漁民重要的漁獲，下列何者是烏魚在冬季聚集於西南海域一帶的原因？', '上升海流，溫度較低',  '中國沿岸流南下至澎湖群島一帶', '黑潮支流帶來溫暖海水', '有湧升流帶來大量營養鹽',  2),
(1432,  '中級', '下列哪一種發電方式最容易造成酸雨的產生？', '火力', '核能', '太陽能',  '水力', 1),
(1433,  '中級', '下列哪個物質是「不是再生」能源？', '天然氣',  '風力', '地熱', '太陽能',  1),
(1434,  '中級', '下列哪個選項「不屬於」石化工業的產品？',  '塑膠', '人造纖維', '玻璃', '黏著劑',  3),
(1435,  '中級', '石化、鋼鐵、造紙等產業的生產過程中，常須耗費大量的能源，為了節約成本，廠商大多會建造下列哪種設備？',  '小型核電廠',  '汽電共生設備', '風力發電設備', '太陽能發電設備',  2),
(1436,  '中級', '煤、石油、天然氣是由古代的動植物死亡後經岩層的壓力與溫度作用而形成，統稱為什麼燃料？', '生質燃料', '基本燃料', '化學燃料', '化石燃料', 4),
(1437,  '中級', '摻了酒精的代用汽油沒有被廣泛使用，主要原因是下列哪個選項？',  '產生大量空氣污染物',  '汽車引擎須改裝才能使用',  '生產成本超過開採石油的成本',  '爆震程度大於一般無鉛汽油', 3),
(1438,  '中級', '行政院為落實節能減碳政策，自2009年起提高太陽能熱水器設置的補助費，以鼓勵民眾安裝，下列哪一個地居的居民，受限於雨天過多、日照不足，安裝意願「最低」？', '臺北', '基隆', '彰化', '高雄', 2),
(1439,  '中級', '下列哪個物質是再生能源？', '太陽光',  '煤',  '石油', '天然氣',  1),
(1440,  '中級', '水力發電的基本原理為何？', '熱能與動能的變換', '位能與動能的變化', '位能與熱能的變化', '質量與能量的變換', 2),
(1441,  '中級', '家中使用的液態瓦斯都有一股難聞的臭味，這個味道是？',  '丙烷的氣味',  '丁烷的氣味',  '為了易於辨別是否漏氣而添加的氣味', '瓦斯不完全燃燒所產生的臭味',  3),
(1442,  '中級', '下列哪種措施能「降低」人類對於自然環境的破壞？',  '使用化石燃料', '多使用塑膠袋', '研發水力、太陽能等再生資源',  '耕作時，多施肥及噴灑農藥', 3),
(1443,  '中級', '人造衛星需靠電力的供給才能運行於太空中，而其電力主要來源為何？',  '核能', '太陽能',  '燃燒燃料', '繞行行星的動能',  2),
(1444,  '中級', '下列哪個物質是現代火力發電廠所使用的燃料之一？',  '煤',  '鈾-235',  '鈷-60', '木材', 1),
(1445,  '中高級',  '火力發電的基本原理是什麼？',  '熱能與動能的變換', '位能與動能的變化', '位能與熱能的變化', '質量與能量的變換', 1),
(1446,  '中級', '有關臺灣各種發電方式的敘述，下列哪個選項是正確的？',  '風力發電是臺灣的主要電力來源', '水力發電是極為乾淨的發電方式', '火力發電受地形及天候的限制',  '核能發電的主要燃料是煤和石油', 2),
(1447,  '中級', '關於利用潮汐發電的敘述，下列哪個選項是「錯誤」的？',  '是利用潮水流動的動能直接發電', '利用漲潮時將海水儲存，等退潮有水位差時發電',  '是由水的位能轉換成電能',  '容易受到海水的侵蝕或暴風雨的破壞', 1),
(1448,  '中級', '「潮汐發電」的發電原理是什麼？',  '利用海水的溫差',  '利用海水的波動',  '利用海流的流動',  '利用海水的水位差', 4),
(1449,  '中級', '「締約國應確保其溫室氣體的人為二氧化碳排放總量不超過分配數量，以使其在2008年至2012年承諾期內這些氣體的全部排放量從1990年水平至少減少5%」上列敘述應是哪一個文件的規範內容？', '《蒙特婁議定書》', '《京都議定書》',  '《地球高峰會協議》',  '《世界氣象組織規範書》',  2),
(1450,  '中級', '《京都議定書》內容主要是限制下列何種氣體的排放，避免溫室效應惡化？',  '二氧化碳', '臭氧', '水',  '一氧化碳', 1),
(1451,  '中級', '臺灣自加入世界貿易組織之後，對臺灣的經濟發展產生重大影響，下列哪個選項是正確的敘述？', '稻米進口量激增，導致價格上揚，帶動農業發展',  '對休閒農業的衝擊最大', '傳統農業所面臨的風險不大', '消費者對於商品的選擇性更為多元',  4),
(1452,  '中級', '大甲溪口是許多重要候鳥的棲息地，因此政府在此處成立高美濕地保護區，此作法合乎下列哪種公約的精神？', '拉姆薩公約',  '蒙特婁公約',  '華盛頓公約',  '京都議定書',  1),
(1453,  '中級', '民國91年臺灣加入WTO後，上萬農民走向街頭大遊行，希望政府可以提供資源並重視農民權利。臺灣在經濟發展的過程中，反映出下列何種問題？', '天災造成農產品歉收',  '農業的就業人口不足',  '年久失修的水利設施',  '農業應尋求轉型',  4),
(1454,  '中高級',  '旨在減少溫室氣體排放量的《京都議定書》已於2005年2月16日生效，根據議定書內容，各國應該如何應變？',  '減少冷煤使用', '減少二氧化碳排放量',  '減少臭氧排放', '減少核能發電，改以火力發電',  2),
(1455,  '中級', '拉姆薩公約主要是保護下列哪種環境？',  '濕地', '熱帶雨林', '冰山', '沙漠', 1),
(1456,  '中級', '許多國家簽訂了《蒙特婁議定書》，經數次協議後，達到自1996年起全面禁用氟氯碳化物的決議。此舉是為了挽救地球免於下列哪種危機？',  '溫室效應日益增強', '紫外線入射量日益增加', '聖嬰現象的發生日益頻繁',  '酸雨問題影響生態', 2),
(1457,  '中級', '《蒙特婁議定書》與京都議定書都是為了全球人民的生活品質所簽訂的，試問兩者的訂定宗旨分別為何？', '禁用氟氯碳化物、減少溫室氣體排放', '增加溫室氣體排放、禁用氟氯碳化物', '使用氟氯碳化物、增加溫室氣體排放', '減少溫室氣體排放、禁用氟氯碳化物', 1),
(1458,  '中級', '下列哪個國際公約是為了減緩全球暖化速度而訂定？',  '《南極公約》', '《京都議定書》',  '《蒙特婁議定書》', '《生物多樣性條約》',  2),
(1459,  '中級', '下列哪個選項「不是」華盛頓公約的內容？',  '限制國際間野生動植物的不當交易',  '希望達成野生動植物的永續利用', '避免野生動、植物因人類的濫捕及販賣而瀕臨絕種', '使各國在政治、經濟與保育工作上可以互相支援、交流學術研究成果', 4),
(1460,  '中級', '中元節是中國人重要節令之一，當晚月相為何？',  '朔月', '望月', '上弦月',  '下弦月',  2),
(1461,  '中級', '有關空氣中水氣的敘述，下列哪個選項是正確的？', '水氣在空氣中的含量很固定', '在所有變動氣體中，水氣含量的變化最小', '水氣於大氣中的分布在對流層中最豐富',  '空氣中的水氣增加，其他氣體的含量也相對跟著增加',  3),
(1462,  '中級', '天氣預報中的「人體舒適度」意指為何？', '不同溫度、濕度條件下，人體感覺舒適的程度', '不同氣壓條件下，人體感覺舒適的程度',  '不同太陽光強度，人體感覺舒適的程度',  '天空雲量多寡，人體感覺舒適的程度', 1),
(1463,  '高級', '有關天然氣水合物(甲烷水合物)的說明，下列敘述何者正確？', '燃燒甲烷水合物不會產生二氧化碳',  '由冰晶封存甲烷氣所構成',  '開採使用不會造成溫室效應加劇', '是可再生的能源',  2),
(1464,  '中級', '有一種颱風俗稱為「西北颱」，其俗稱得名之由為何？', '颱風從臺灣東方海面向西北方進行',  '生成於臺灣西北方溫暖的海洋上', '颱風眼停留在臺灣西北方的海面上',  '南部地區之雨勢特別大', 1),
(1465,  '中級', '(A)氧氣；(B)氮氣；(C)氨氣；(D)水氣；(E)臭氧，以上五種氣體，何者是組成大氣的固定成分氣體？', 'AB', 'AC', 'BD', 'DE', 1),
(1466,  '中級', '「氣團」指的是一團物理性質相近的空氣，這些物理性質「不包括」下列哪個選項？',  '溫度', '密度', '濕度', '溶解度',  4),
(1467,  '中級', '氣團依其溫度高低可分為冷氣團和暖氣團，其中冷氣團的定義是什麼？',  '溫度一路下降的氣團',  '相較於周圍空氣溫度較低的氣團', '溫度一路上升的氣團',  '相較於周圍空氣溫度較高的氣團', 2),
(1468,  '中級', '臺灣地區在春末夏初，常為陰雨綿綿的天氣，這是何種鋒面所造成的？',  '滯留鋒',  '暖鋒', '冷鋒', '囚錮鋒',  1),
(1469,  '中級', '影響臺灣氣候的氣團主要有太平洋海洋氣團和西伯利亞(蒙古)大陸氣團，關於這兩個氣團的敘述，下列哪個選項是「錯誤」的？',  '夏季主要受到太平洋海洋氣團的影響', '太平洋海洋氣團為溫暖潮濕的氣團',  '冬季主要受到西伯利亞(蒙古)大陸氣團的影響',  '西伯利亞(蒙古)大陸氣團自源地形成後，其性質不隨地點而改變',  4),
(1470,  '中級', '中央氣象局對颱風強弱的分類標準，其依據為何？', '颱風中心附近平均的最大風速',  '颱風所含的水氣多寡',  '颱風中心颱風眼的大小', '颱風在垂直剖面的高度', 1),
(1471,  '中級', '有關颱風的敘述，下列哪個選項是「錯誤」的？',  '颱風為夏季形成於太平洋上的高壓系統',  '颱風可為臺灣帶來豐沛降水，為主要的水資源', '若水土保持不良，颱風帶來的暴雨將造成土石流災害',  '颱風眼區氣壓最低，無風無雨',  1),
(1472,  '中級', '太陽發出的輻射中，有許多無法穿過地球大氣層，其中波長較短的紫外線主要是集中在大氣層中的哪一層被臭氧吸收？', '對流層',  '平流層',  '增溫層',  '中氣層',  2),
(1473,  '初級', '地球紫外線指數越來越高與下列哪種因素有關？',  '全球暖化', '冰層融化', '臭氧層破洞',  '生物多樣性降低',  3),
(1474,  '中級', '下列哪個選項是目前大氣的組成成份？',  '氮氣', '氧氣', '水氣、二氧化碳和臭氧', '以上皆是', 4),
(1475,  '中級', '地球大氣層的氧氣是從哪一事件之後逐漸累積產生？',  '天空大量出現閃電後',  '太空中許多小岩塊撞擊地球後',  '行光合作用的生物出現後',  '地球地表逐漸冷卻後',  3),
(1476,  '中高級',  '有關氮循環的敘述，下列哪個選項是「錯誤」的？', '利用根瘤菌固氮',  '雷電作用將氮分子固定成為硝酸態',  '大氣中含有90%的氮氣',  '氮是許多生物生命組成的基本元素',  3),
(1477,  '中級', '有關大氣中臭氧分布的敘述，下列哪個選項是正確的？', '臭氧大部分存在離地面10至50公里的範圍內',  '大氣中90%的臭氧分布在由地面起至25公里高空的範圍內',  '離地面25至50公里的高空，臭氧的分布隨高度的增加而增加', '離地面10至50公里的範圍內，臭氧的分布隨高度的增加而降低',  1),
(1478,  '中級', '下列何種特性說明氫氣是乾淨能源？', '氫是最輕的元素',  '氫為易燃性氣體',  '氫燃燒後產物為水', '氫會被碳棒吸附',  3),
(1479,  '中級', '有關大氣，下列哪項敘述是「錯誤」的？', '水氣能調節地球表面的溫度', '二氧化碳所佔比例比氧氣少', '臭氧層能吸收紫外線以保護地球上的生物', '溫室氣體會吸收紫外線使地球產生溫室效應',  4),
(1480,  '中高級',  '下列哪種資源回收的處理方式與戴奧辛的產生有關？',  '將殘餘的果皮菜屑剪碎形成堆肥', '將廢棄的建築土塊加以堆積掩埋', '將電線外皮燒盡，回收其內的金屬',  '將廢輪胎加上水泥形成海底魚礁', 3),
(1481,  '中級', '「每到冬春之際，伴隨火苗的擴大，蔗葉灰塵漫天飛揚，收割的農民則在一旁，準備採收成熟的甘蔗…。」昔日這樣的景觀最立即的環境影響為下列哪個選項？', '天氣冷順便生火取暖',  '造成空氣污染', '被警察抓走',  '污染地下水',  2),
(1482,  '中級', '下列哪個選項是酸雨對環境或生物造成的影響？',  '減緩植物生長', '造成水體優養化',  '使南極上空臭氧洞擴大', '造成溫、寒帶的生物棲息地往更高緯度處遷移', 1),
(1483,  '中級', '近年來，越來越常見有關酸雨的警示與危害，試問關於酸雨的敘述，下列哪個選項是正確的？',  '汽車廢氣與酸雨的形成無關', '雨水通常呈鹼性，只有酸雨才呈酸性', '通常依據酸鹼值判斷是否為酸雨', '酸雨只出現在都市', 3),
(1484,  '中級', '下列哪一種作用或現象發生時，會增加大氣中的溫室氣體？', '燃燒化石燃料所產生之氣體', '海洋中碳酸鹽類的沉積作用', '植物行光合作用產生之氣體', '水蒸氣凝結為雨滴降落地面', 1),
(1485,  '初級', '氣象預報中的紫外線指數是因下列哪個因素造成紫外線入射地球的量增加？',  '溫室效應', '氣溫異常上升', '森林消失', '臭氧層破洞',  4),
(1486,  '中級', '關於環境污染的敘述，下列何者正確？',  '酸雨的形成主要是臭氧溶解於水中',  '氟氯碳化合物會破壞地球上空的臭氧層',  '空氣污染指標(PSI)愈大代表空氣品質愈好',  '一氧化碳是主要的溫室氣體，造成全球溫度上升',  2),
(1487,  '中級', '人類活動大量排放二氧化碳「不會」導致下列哪個後果？',  '全球氣溫上升', '熱帶淺海珊瑚殼體溶解', '火山活動趨於旺盛', '地表吸收輻射量增加',  3),
(1488,  '中級', '下列哪個選項「不是」空氣污染物？', '二氧化硫', '懸浮微粒', '氮氧化物', '氮氣', 4),
(1489,  '中級', '主要吸收太陽輻射中的紫外線是哪種氣體？',  '水蒸氣',  '氮氣', '二氧化碳', '臭氧', 4),
(1490,  '初級', '大氣層是保護地球的一大功臣，有關大氣層的重要性，下列何者是「錯誤」的？',  '可阻擋所有宇宙射線和紫外線的入侵', '可幫助地表維持適當的溫度', '大氣環流具有調節氣候的功能',  '可阻擋隕石直接撞地球', 1),
(1491,  '中級', '造成太陽紫外線直射地面，是因臭氧層破洞引起，而破壞臭氧層最主要的空氣污染物是下列哪種物質？',  '二氧化碳', '二氧化硫', '一氧化碳', '氟氯碳化物',  4),
(1492,  '中級', '使臭氧被分解，導致臭氧層被破壞，主要是下列哪種物質所造成的？', '硫酸', '二氧化碳', '戴奧辛',  '氟氯碳化物',  4),
(1493,  '中級', '若大量使用氟氯碳化物，最可能造成的環境問題為下列哪個選項？',  '使地面的紫外線指數增加',  '照光分解產生有毒的氟化物', '使人呼吸的氧濃度增加而造成身體不適',  '產生大量氯氧造成居家環境的空氣污染',  1),
(1494,  '中級', '古代志留紀開始有陸生動植物出現，恐龍出現於侏羅紀，哺乳類則出現於第三紀，據此推論，地球大氣中的臭氧含量已足夠保護陸地上的生物免於紫外線的威脅是開始於個時期？', '寒武紀',  '第三紀',  '侏羅紀',  '志留紀',  4),
(1495,  '中級', '河水常因有機污染導致水中「缺乏」下列哪種物質，而不利於水生生物的生存？',  '鈉',  '磷',  '氮',  '氧',  4),
(1496,  '中級', '關於自流井的敘述，下列哪個選項正確？', '所取用的水為受壓地下水時，必為自流井', '自流井井口高度低於地下受壓水水面', '井在雨季時就變成自流井',  '臺灣沒有自流井',  2),
(1497,  '中級', '優養化的水域與下列哪個生物的大量繁殖有關？',  '蘚苔', '藻類', '浮游動物', '水生昆蟲', 2),
(1498,  '中級', '臺灣許多水庫因為集水區不當開發，而產生「優養化」的問題。試問關於優養化的敘述，下列哪個選項是正確的？', '水中營養鹽過量，藻類繁殖過盛，最終使水質惡化', '水中養分含量高，各類生物大量繁殖', '水中的重金屬含量過高，累積於生物體造成毒害',  '經常發生酸雨，造成水中生物生存環境改變',  1),
(1499,  '中級', '下列何者為河川污染指數(RPI)的水質檢測參數？', '細菌', '原生動物', '藻類', '懸浮固體', 4),
(1500,  '中級', '有關地下水的描述，下列哪個選項是「錯誤」的？', '地層岩石的縫隙具有過濾水中雜質的功能，因此地下水可安全飲用',  '地下水有可能是來自數百年前的雨水', '地下水在旱季時，可以補充河水的不足',  '抽取地下水若無限度，將造成地層下陷',  1),
(1501,  '中級', '海水中的主要化學成分為何？',  '氯化鈉',  '碳酸鈉',  '碳酸氫鈉', '碳酸鈣',  1),
(1502,  '中級', '下列哪一事件最容易造成跨河大橋發生橋墩裸露的現象？',  '靠近橋的下游河段遭濫採沙石',  '在橋的下游河流出海處築防波堤', '河流上游山坡地遭濫墾濫伐', '河流上游爆發土石流災變',  1),
(1503,  '中級', '梅雨是臺灣最重要的水資源之一，有關梅雨的敘述，下列哪個選項是「錯誤」的？', '發生在每年的五、六月期間', '每年梅雨季的降水皆很豐沛', '造成梅雨現象的鋒面主要為滯留鋒',  '梅雨期間，降雨主要為綿綿細雨，也可能豪雨成災', 2),
(1504,  '中級', '關於水循環之敘述，下列哪個選項是正確的？', '不會產生天氣現象', '水循環可分為蒸發、凝結、降水三步驟',  '水循環的終點是大海',  '降水時會放熱，可調節氣候', 2),
(1505,  '中級', '新聞報導：「高鐵興建之初，為避免地層下陷影響軌道平整度危及行車安全，行政院下令在雲林路段執行兩側各五百公尺的封井令。」行政院之所以下達封井令，是由於井水大多源自於下列哪一項水資源的使用過度而造成地層下陷？', '河水', '冰川', '湖水', '地下水',  4),
(1506,  '中級', '對於冰川的敘述，下列哪個選項是「錯誤」的？',  '冰川也是水循環的一部分',  '除了南北兩極外，高山地區也可能有冰川', '陸地上的冰川大量溶化，將導致海水面上升',  '冰川在地球上的含水量比河水少，故冰川的多寡並不會對水資源產生影響', 4),
(1507,  '初級', '臺灣降雨量高出世界平均值，但仍名列世界缺水國家，下列哪個選項是主要的原因之一？',  '降雨分配不均', '山多平原少，河水流速緩慢', '四面環海，無淡水可用', '雨水均滲入岩層形成地下水', 1),
(1508,  '中級', '約旦、以色列和敘利亞等國，為了爭奪哪條河的水源而發生衝突？',  '尼羅河',  '印度河',  '約旦河',  '幼發拉底河',  3),
(1509,  '中級', '造成全球水資源不足的問題「不包括」下列哪個選項？', '氣候異常', '興建水庫', '水資源污染',  '用水需求大',  2),
(1510,  '高級', '關於水資源的保護，下列哪種措施最適當？',  '在集水區造林並增加施肥',  '地下水會受到降雨持續補充，還是應該限量使用',  '於水庫內廣設水上休閒設施', '利用放流管將工廠污水直接排入海中', 2),
(1511,  '中級', '南部地區有許多早期埤塘、水圳建設所留存下來的景觀，主要與當地的哪種條件最有關連？', '經濟發展朝向工業化',  '人口密度較高', '降雨和溪流水量豐沛',  '乾濕季節分明', 4),
(1512,  '中級', '臺灣水力資源開發的困難，最主要是受到下列哪項因素的限制？', '河幅寬窄不一', '河水含沙量太多',  '河川流量洪枯懸殊', '河川流量短急', 3),
(1513,  '中級', '太魯閣國家公園以陡峭的峽谷聞名，此峽谷形成的主要原因是什麼？', '河流向下侵蝕岩層', '地震引起岩層崩塌', '冰川移動使得岩層被切割',  '岩層被海流侵蝕與波浪沖刷', 1),
(1514,  '中級', '莫拉克颱風帶來驚人豪雨，引發土石流。多處河川上游土石崩落，堵塞水道形成大小不一的堰塞湖，關於堰塞湖的敘述，下列哪個選項是正確的？', '山崩也可能形成堰塞湖', '湖面可稱作最終侵蝕基準面', '提高河水侵蝕與搬運能力',  '將加速河口淤積程度',  1),
(1515,  '初級', '下列哪種「不是」海浪侵蝕形成的地形？', '海蝕平臺', '海灘', '海蝕洞',  '海拱', 2),
(1516,  '中級', '河流中上游地區若興建了水庫或攔沙壩，河流攜帶入海的泥沙將大量減少，則原本呈平衡狀態的海岸線可能產生下列哪種結果？', '海岸線向海的方向擴散', '海岸線向內陸退縮', '形成海埔新生地',  '海岸線完全消失',  2),
(1517,  '中級', '下列哪個選項是地表最主要的地質作用力？',  '冰川', '太陽', '流水', '風',  3),
(1518,  '中級', '有些漁民會利用沿海潟湖及潮間帶，從事水產養殖漁業，請問分布最密集為下列哪個地區？', '東部斷層海岸', '西部沙質海岸', '南部珊瑚礁海岸',  '北部峽灣海岸', 2),
(1519,  '中級', '以環境保育的角度來看，是什麼原因造成臺灣養殖漁業無法永續？',  '漁業產量減少', '加入世界貿易組織造成惡性削價競爭', '舉辦過多的吃魚活動',  '超抽地下水',  4),
(1520,  '中級', '養殖漁業是臺灣沿海地區重要的產業之一，除了提供國內漁市需求之外，也賺取了許多外匯收入，但此產業也有許多發展危機，下列何者「不是」養殖漁業面臨的危機？', '土石流',  '水質污染', '冬季寒害', '地層下陷', 1),
(1521,  '中級', '莫拉克颱風所造成的水患嚴重區，不少是養殖漁業較密集、且超量使用地下水的鄉鎮，根據此情況的推論，下列何者是正確的？', '養殖業超抽地下水，使地層下陷，增加水患嚴重性', '水患時，地表水可補充地下水，故地下水不虞匱乏', '土石流可以填平下沉土地，故可以無限使用地下水', '本次風災降雨實在太大，淹水與地下水使用完全無關',  1),
(1522,  '中級', '臺灣西南沿海地區，在產業發展的過程中大量抽取地下水，導致地層下陷與海水倒灌等環境問題。上述的環境問題，可能是由哪一個產業發展造成的？', '養殖漁業', '觀光產業', '石化工業', '遠洋漁業', 1),
(1523,  '中高級',  '下列哪個選項為「洋流」的定義?',  '於大洋中的水流，有一定的方向和流速',  '海水受日月引力產生潮波，沿岸一帶，產生伴隨漲落潮現象之水流',  '沿岸陸棚海域，受季風影響，形成流向與流速不定之水流',  '因流體之連續性，某處海水向他處移動，別處的海水補其缺，而發生之海流',  1),
(1524,  '中級', '下列何者的配對最容易引發雲嘉南地區海水倒灌，造成重大農漁業的損失？',  '梅雨，朔月',  '颱風，上弦月', '梅雨，下弦月', '颱風，望月',  4),
(1525,  '中級', '有關海風與陸風的現象，下列哪個選項是正確的？', '白天吹海風，因為白天洋流較強', '白天吹海風，因為白天陸地溫度上升較快，空氣受熱而上升，海上的風過來補充',  '白天吹陸風，因為白天洋流較弱', '白天吹陸風，因為白天海洋溫度上升較快，空氣受熱而上升，陸地的風過來補充',  2),
(1526,  '中級', '形成表面洋流的主要原因為何？', '密度不均', '日月的引力',  '鋒面來襲', '風吹海面', 4),
(1527,  '中級', '每年4~6月，是臺灣東岸太平洋海域的黑鮪魚豐收季，其主要原因為何？',  '隨黑潮帶來魚群',  '臺灣的河川排放營養鹽吸引魚群', '斷層海岸線曲折',  '鯊魚追趕黑鮪魚群', 1),
(1528,  '中級', '秘魯及其鄰近國家漁業發達，是因為海水有湧升流的關係，而湧升流與魚群聚集的關係為何？',  '湧升流含豐富養分引來魚群', '海流引來魚群', '海流並不一定引起湧升流',  '湧升流並不一定引來魚群',  1),
(1529,  '中級', '大自然形成海風與陸風的主要原因為何？', '海洋與陸地的分布面積不同', '海水的流動造成海風',  '海洋與陸地早晚溫度不同',  '板塊運動造成陸風', 3),
(1530,  '中級', '關於潮汐的敘述，下列哪個選項是「錯誤」的？',  '每個月大約有兩次大潮、兩次小潮',  '大潮的滿潮水位較平常高',  '大潮當天潮差較小', '大潮的乾潮水位較平常低',  3),
(1531,  '中級', '每年春季，飛魚群會隨著暖流來到臺灣附近海域，此時居住在該海域島嶼上的達悟族人會舉行招魚祭，之後才開始捕捉飛魚，剛開始僅限於在夜間以燈光誘捕，至夏季時才可在白天捕捉飛魚。上文中的海域是指下列哪個選項？',  '東海', '南海', '太平洋',  '臺灣海峽', 3),
(1532,  '中級', '若赤道附近海域的鹽度偏低，其蒸發量與降水量的關係為何？',  '蒸發量小於降水量', '蒸發量等於降水量', '蒸發量大於降水量', '沒影響',  1),
(1533,  '中級', '下列哪個選項與潮汐現象「無關」？', '海水的浮力',  '到海邊看招潮蟹',  '潮汐能是一種可再生能源',  '漁船進出港口', 1),
(1534,  '中級', '固定方向的風長時間吹拂海水，可以產生大規模的海水流動，此流動稱為什麼？',  '對流', '平流', '洋流', '潮汐', 3),
(1535,  '中級', '恆春一帶四季如春，即使冬季也不很冷，此為下列哪種因素的影響？', '黑潮', '親潮', '中國沿岸流',  '南海海流', 1),
(1536,  '中級', '當颱風侵襲臺灣時若適逢大潮，常常由於潮水高漲而無法迅速將大量雨水排除，造成水患。由下列颱風侵襲臺灣的日期判斷，哪個颱風最可能曾遇上大潮？', '賀伯颱風，民國85年7月31日(農曆6月16日)', '象神颱風，民國89年10月30日(農曆10月4日)',  '桃芝颱風，民國90年7月30日(農曆6月10日)', '康森颱風，民國93年6月9日(農曆4月22日)',  1),
(1537,  '中級', '政府致力推廣資源回收，可直接「減少」下列哪種污染？',  '空氣污染', '水污染',  '噪音污染', '固體廢棄物污染',  4),
(1538,  '中級', '下列各種家庭廢棄的物質中，何者可用來作為製造肥皂的主要原料？', '食醋', '廢紙', '回鍋油',  '吃剩的米飯',  3),
(1539,  '中級', '下列何種做法對於垃圾源頭減量最有幫助？',  '做好垃圾分類，資源回收',  '以紙類製品代替塑膠製品',  '建造焚化爐，減少垃圾體積', '惜物惜福，減少垃圾的產生', 4),
(1540,  '中級', '有關生質能源與化石能源的比較敘述，下列哪個選項是正確的？', '生質能源形成的速率較化石能源慢',  '生質能源是儲存太陽光能而來，化石能源則是儲存地底熱能而得', '生質能源不須加工就可使用，化石能源則須加工才能使用',  '化石能源的形成要經過複雜的地質作用；生質能源則將生物廢料轉化為能源',  4),
(1541,  '中級', '關於地下水的敘述，下列哪個選項正確？', '超抽地下水導致地層下陷，只要再等地下水滲入岩層即可恢復',  '淡水中占最大比例的是地下水',  '地下水存於地底，完全不受污染', '地下水的補注主要依賴雨水', 4),
(1542,  '中級', '近年來，臺灣地區大量使用地下水的結果，部分地區開始出現下列哪些現象？(A)優養化；(B)地層下陷；(C)土壤鹽化；(D)湖泊污染；(E)地下水鹹化。', 'ABC',  'BCE',  'BCD',  'CDE',  2),
(1543,  '中級', '有關各種發電方式與其特點的敘述，下列哪個選項是「錯誤」的？',  '風力發電-僅有部分地區有足夠風力，且有不穩定現象', '火力發電-以燃燒化石燃料發電', '核能發電-利用核分裂產生的能量發電',  '水力發電-利用流速較大的海流發電，會影響海洋生態', 4),
(1544,  '中級', '臺灣使用多種發電方式，以確保供電的穩定性，其中哪些發電方式主要仰賴進口的能源來運作？', '水力發電和火力發電',  '水力發電和核能發電',  '火力發電和核能發電',  '火力發電和風力發電',  3),
(1545,  '中級', '下列何者是綠建築的特色？', '與地球環境共生共存',  '綠色外觀以凸顯特色',  '會浪費資源',  '跳脫地方特色', 1),
(1546,  '中級', '有關露天燃燒廢電纜會產生戴奧辛並影響環境的敘述，下列何者正確？',  '戴奧辛的污染只存於乳製品中',  '戴奧辛只會累積在草食性動物體內',  '戴奧辛會隨食物鏈的轉移，累積至高層的消費者體內',  '戴奧辛只會對當地造成傷害', 3),
(1547,  '中級', '下列哪個選項是一個氟氯碳化合物CFC分子甚至可使十萬個臭氧分子反應成氧分子之主要原因？',  '一個CFC分子分解一次可產生許多氯原子',  '一個CFC分子可與許多個臭氧分子產生反應', '一個CFC分子與一個臭氧分子反應產生許多活性大的氧原子',  '一個CFC分子分解產生的氯原子可重複與許多臭氧分子反應',  4),
(1548,  '中級', '民國75年高雄縣二仁溪口發生養殖牡蠣因受到水污染而變綠死亡，試問導致綠牡蠣事件的原因是下列哪個選項？', '水中藻類大量繁殖', '水中有機物質濃度過高', '水中含有毒的重金屬',  '水中溶氧量過高',  3),
(1549,  '中級', '有關生物累積作用的敘述，下列哪個選項是正確的？',  '生態系中某些無法被生物分解的毒物，在食物鏈中層層累積的過程',  '生態系中若無分解者，將造成生物遺體的累積', '大氣中累積了許多的二氧化碳，造成溫室效應', '生物累積了許多變異後，促成新物種的形成',  1),
(1550,  '中級', '在汽油加入下列哪一種鉛化合物添加劑，隨著汽車排汽管的廢氣噴散在空氣中，人類吸入了重金屬鉛會造成智能減退而被禁用？', '碳酸鉛',  '硫酸鉛',  '氫氧化鉛', '四乙基鉛', 4),
(1551,  '中級', '大量使用氟氯碳化合物最可能造成的環境問題是下列何者？', '使氧濃度增加而造成身體不適',  '光分解產生有毒的氟化物',  '使地面的紫外線指數增加',  '產生大量氯氣造成居家環境的空氣污染',  3),
(1552,  '中級', '在受三丁基錫(TBT)污染的水域中，下列哪個選項所含的TBT濃度最高？',  '水',  '水藻', '浮游生物', '蚵螺', 4),
(1553,  '中級', '有關鉛污染對人體影響的敘述，下列哪個選項是正確的？',  '鉛只傷害人體之中樞神經系統',  '鉛可經臍帶由母體進入胎兒體內', '鉛只能由消化系統進入成人體內', '鉛在人體內會促進紅血球的合成', 2),
(1554,  '中級', '有關環境荷爾蒙的敘述，下列哪個選項是正確的？', '皆由生物體內的細胞分泌',  '不會影響到生物激素的作用', '會干擾生殖器官的發育，並會干擾生物正常的生理機能', '在水域環境中才能夠發現',  3),
(1555,  '中級', '下列何者與氟氯碳化合物(CFCs)的性質「無關」？',  '無毒無臭', '常溫常壓下易揮發', '安定不易燃燒', '遇高能輻射線不容易分解',  4),
(1556,  '中級', '下列何項措施，對於消除船舶塗料三丁基錫(TBT)對環境的污染最為有效？',  '公告TBT為毒性物質，要申報才能製造', '禁止使用TBT，並研發無毒性的代用品', '研究TBT對生物及人體的危害程度', '對輸入及販賣TBT者加徵課稅', 2),
(1557,  '中級', '焚化爐排放戴奧辛的污染問題，主要與下列哪個選項的污染有關？',  '水污染',  '噪音污染', '空氣污染', '輻射污染', 3),
(1558,  '中級', '下列各項物品中，何者使用鉛或加入鉛來製造最「不適當」？',  '加入鉛來製造保護電器的保險絲', '加入鉛來製造焊接金屬的焊接劑', '汽車用的鉛蓄電池其外殼以鉛來製造', '可以用鉛作為製造低濃度硫酸的容器', 3),
(1559,  '中級', '以大量農藥來消滅農作物的害蟲，所造成的結果可能為何？', '農藥僅殺死昆蟲，對人類及其他生物無害', '可增加農作物生產量，有益無害', '農藥進入人體後，可經代謝作用排出，對人類健康影響不大', '殘留農藥可經許多途徑進入人體，對健康造成相當程度的危害',  4),
(1560,  '中級', '赤蛙科中體型最小的臺北赤蛙，近年來瀕臨絕種的主要原因為何？',  '因為肉質鮮美，被人類大量捕捉', '農藥及水域的污染', '不敵外來種的生物', '氣候變遷', 2),
(1561,  '中級', '在受污染海域中，下列生物：(A)浮游生物；(B)蝦；(C)魚；(D)藻類；體內重金屬含量的多寡，哪個選項是正確的？',  'A=B=C=D',  'A>B>C>D',  'C>B>A>D',  'D>A=B=C',  3),
(1562,  '初級', '臺灣山區較可能種植的農作物為下列哪個選項？',  '蔬菜', '稻米', '甘蔗', '熱帶水果', 1),
(1563,  '中級', '臺灣地區許多都市焚化爐的興建，是要解決什麼問題？', '水質污染', '空氣污染', '垃圾污染', '噪音污染', 3),
(1564,  '中級', '家庭主婦常用鹽酸溶液來消毒洗刷廁所，因此廁所的建材「不會」取用下列哪種岩石？', '大理石',  '長石', '角閃石',  '金剛石',  1),
(1565,  '中級', '下列針對「酸雨」的描述，哪個選項「有誤」？',  '雨水酸鹼值低於7.0即稱作酸雨',  '植物生長減緩甚至死亡', '腐蝕雕像和建築物', '土讓、湖泊酸化',  1),
(1566,  '中級', '下列哪種氣體是造成酸雨的主要原因？',  '二氧化碳', '二氧化硫', '一氧化碳', '甲烷', 2),
(1567,  '中級', '日本福島由於地震與海嘯造成核電廠冷卻系統損壞，造成多次爆炸，使大量輻射塵外洩。試問此時核電廠爆炸會因為風力的影響，會先形成下列何種污染？', '土壤污染', '垃圾污染', '水污染',  '空氣污染', 4),
(1568,  '中級', '有關臭氧和環境的敘述，下列哪個選項是正確的？', '大氣層中的增溫層，又稱臭氧層', '南極上空觀測到臭氧量有增加的現象', '氟氯碳化物會增加臭氧量',  '臭氧層能夠吸收　紫外線',  4),
(1569,  '中級', '臺灣很多的河川溪流與水庫都面臨到優養化的問題，這是哪種污染所造成的？', '土壤污染', '空氣污染', '水污染',  '噪音污染', 3),
(1570,  '中級', '下列哪一種行為「不是」安全的行為？',  '藥品應存放在安全的位置',  '化學藥品應存放在兒童不易拿取到之陰涼處',  '瓦斯、熱水器應安裝在室內', '插座上不可同時插滿插頭，以免影響用電安全', 3),
(1571,  '中級', '天然因素及人類活動均會使大氣組成發生變化，試問此一人類活動主要指下列哪個選項？',  '車輛與工廠排放廢氣',  '在集水區開闢菜園、果園',  '進行填海造陸工程', '過量抽取地下水',  1),
(1572,  '中級', '下列哪個選項「不是」光合作用的主要產物？', '氧氣', '二氧化碳', '葡萄糖',  '水',  2),
(1573,  '中級', '下列哪個選項「不是」陸域生態系？', '草原', '森林', '河口', '沙漠', 3),
(1574,  '中級', '下列哪個選項「不屬於」淡水生態系？',  '池塘生態系',  '河口生態系',  '溪流生態系',  '湖泊生態系',  2),
(1575,  '中級', '下列哪個選項是臺灣島曾位於海平面之下的證據？', '恆春半島露出水面的珊瑚礁', '墾丁國家公園的玄武岩地形', '臺東八仙洞內有恐龍化石',  '中橫山區常發生土石流', 1),
(1576,  '中級', '大部分的生物需要以下哪項物質來維持生存？', '空氣', '養分', '水',  '以上皆是', 4),
(1577,  '中級', '比較臺灣東部與西部的海灘，可以發現西部多沙灘，東部則多礫石，下列哪個選項是造成此種差異的主要原因？',  '東西岸發生地震的頻率不同', '東西岸的河流長度及山脈離岸遠近不同',  '東岸有板塊活動，而西岸的板塊運動已經停止', '東岸火山活動較多，而西岸幾乎沒有火山運動', 2),
(1578,  '中級', '由草、蟋蟀、蚱蜢、麻雀組成之食物網，下列哪個選項是最為合理的敘述？',  '若蚱蜢的族群消失，則無法構成食物網',  '若蟋蟀數目增加時，則蚱蜢的數目亦會增加',  '草可吸收太陽能進行光合作用',  '若有毒物質污染環境時，則草的累積濃度最高', 3),
(1579,  '中級', '立霧溪以切割出險峻的太魯閣峽谷而聞名，有關立霧溪的敘述，下列哪個選項是「錯誤」的？',  '立霧溪的向下侵蝕作用強烈，造就了太魯閣峽谷地形',  '立霧溪下游僅有沉積作用，並無侵蝕及搬運作用',  '立霧溪沿岸可發現許多陡直聳立的大理石岩壁', '雨季時，立霧溪會將顆粒較大的石頭搬運至下游',  2),
(1580,  '中級', '地球約在幾億年前形成？',  '45億',  '46億',  '47億',  '48億',  2),
(1581,  '中級', '有關生態系中生物的組成敘述，下列哪個選項是「錯誤」的？',  '生態系各種生物區分為生產者、消費者二大類', '生產者能自行製造養分', '消費者必須攝食其它生物並加以消化、吸收才能獲取養分',  '清除者也是消費者的一種',  1),
(1582,  '中級', '有關臺灣島的敘述，下列哪個選項是「錯誤」的？', '臺灣處於錯動性板塊交界',  '臺灣東部海岸山脈屬於菲律賓海板塊的範圍',  '受板塊運動的影響，臺灣島有逐漸上升的趨勢', '臺灣島上的沉積地層多呈傾斜或彎曲，此為地殼變動的證據', 1),
(1583,  '中級', '何者是花朵授粉的協助傳播者，下列哪個選項正確？',  '風力', '水力', '人工', '以上皆是', 4),
(1584,  '中級', '我們可以藉由哪些特性來區別生物與無生物，下列哪個選項是「錯誤」的？',  '代謝', '生長', '繁殖', '體積增大', 4),
(1585,  '中級', '我國東沙島由珊瑚碎屑及貝殼風化形成獨特白沙地質景觀，其形成原因與哪座離島相同？',  '綠島', '馬祖列嶼', '龜山島',  '琉球嶼',  4),
(1586,  '中級', '科學家將生物在地表生存與活動的範圍稱為什麼？', '大氣圈',  '水圈', '岩石圈',  '生物圈',  4),
(1587,  '中級', '下列何者為「族群」的意義？',  '生長於同一時期、同一棲地的同種生物集合',  '生長於同一時期、同一棲地的所有生物集合',  '生長於同一時期、不同棲地的同種生物集合',  '生長於不同時期、同一棲地的所有生物集合',  1),
(1588,  '中級', '現今生物生存的環境空間是下列哪一個選項？', '大氣圈',  '水圈', '岩石圈',  '以上皆是', 4),
(1589,  '中級', '最初的生命可能是從哪裡誕生的？',  '海洋', '陸地', '空氣', '以上皆是', 1),
(1590,  '中級', '植物的葉子中，主要行光合作用的部位是哪一個選項？', '粒線體',  '葉綠體',  '液泡', '細胞壁',  2),
(1591,  '中級', '對於蕨類植物的描述，下列哪個選項是正確的？',  '煤炭由蘚苔植物形成',  '臺灣水韭為蕨類植物',  '不屬於維管束植物', '產生孢子與種子隨風繁殖',  2),
(1592,  '中級', '臺灣島大約於數百萬年前開始形成，下列哪個選項是臺灣島形成的主要原因？', '火山不斷噴發，冷卻凝固後形成', '海流帶來大量的沉積物，慢慢累積形成',  '菲律賓海板塊不斷向歐亞板塊推擠，造成岩層隆起', '中國大陸沿海受海流侵蝕形成臺灣海峽，使得部分陸地被分隔',  3),
(1593,  '初級', '關於植物的分類，下列哪個選項正確？',  '蘚苔植物', '被子植物', '蕨類植物', '以上皆是', 4),
(1594,  '中級', '「綠島的朝日溫泉泉水自海岸邊的礁石湧出，形成位於海裡的露天溫泉浴場。」由上文判斷，綠島屬於哪一類型的島嶼？',  '大陸島',  '火山島',  '沙洲島',  '珊瑚礁島', 2),
(1595,  '中級', '北海岸野柳擁有豐富的海蝕地形，其中「女王頭」更是大自然鬼斧神工的傑作。關於「女王頭」的敘述，下列哪個選項是正確的？',  '女王頭是風化侵蝕後的結果', '女王頭是一種差異侵蝕，頭部抗侵蝕能力較弱', '作用力只有海水',  '女王頭僅需數十年即可形成', 1),
(1596,  '中級', '地球上所有的生物賴以生存的環境，合稱「生物圈」；其範圍約是海平面垂直上下各多少公尺？', '1萬', '2萬', '3萬', '4萬', 1),
(1597,  '中級', '研究指出高雄市楠梓仙溪保育類的高身?魚棲息地逐漸往高海拔遷移，造成此一生物行為的可能原因是下列哪個選項？', '高海拔地區溪水有較多食物', '海水面逐漸升高以致水壓改變',  '全球暖化造成生態分布改變', '原棲息地受鳥類侵擾，高身?魚被大量捕食',  3),
(1598,  '中級', '下列哪個選項是臺南「臺江國家公園」的地形特色？',  '海埔地',  '珊瑚礁',  '海蝕平臺', '谷灣', 1),
(1599,  '中級', '有關自然資源的保育，下列哪種行為是「錯誤」的？',  '保育工作為專家學者的工作，與一般民眾無關', '發現他人有隨意撲殺野生動物的行為，應予以規勸及制止',  '將所有萬物視為與人類一樣，同樣享有生存的權利，並予以尊重', '對於生物的棲息地，不予以破壞', 1),
(1600,  '中級', '下列哪個選項是進行自然保育工作最根本的作法？', '當經濟利益與生態保育發生衝突時，絕對不開發',  '設立國家公園', '教育民眾瞭解眾生平等且互相依賴的關係', '多設立動物園並以人工繁殖野生動物', 3),
(1601,  '中級', '下列何種生物「不是」哺乳類動物？', '蝙蝠', '袋鼠', '鴨嘴獸',  '貓頭鷹',  4),
(1602,  '中級', '下列哪個選項「不屬於」細菌外型的分類之一？',  '球狀', '桿狀', '螺旋狀',  '橄欖球狀', 4),
(1603,  '中級', '下列哪個選項是「不會」飛行的鳥類？',  '鴕鳥', '蒼鷹', '麻雀', '白頭翁',  1),
(1604,  '中級', '下列哪個選項為爬蟲類之一？',  '麻雀', '彈塗魚',  '蜘蛛', '蛇類', 4),
(1605,  '中級', '水中生物多為體外受精，但下列哪個選項的動物是屬於體內授精的？', '蛙類', '吳郭魚',  '鯊魚', '鯨魚', 4),
(1606,  '中級', '水裡的魚可以呼吸溶解在水中的什麼物質？',  '空氣', '鹽',  '養分', '礦物質',  1),
(1607,  '中級', '有關卵生、胎生、卵胎生的敘述，下列哪個選項最正確？',  '胎生與卵胎生都是體內受精', '卵生與卵胎生都是體外發育', '卵胎生體內養分由母體供應', '卵生的卵黃較少',  1),
(1608,  '中級', '有關動物界分類之描述，下列哪個選項是「錯誤」的？', '棘皮動物門為動物', '節肢動物門為動物', '沙蠶與蚯蚓不同，不是環節動物', '昆蟲屬於節肢動物', 3),
(1609,  '中級', '有關棘皮動物門的描述，下列哪個選項是正確的？', '有海膽、海星等',  '無獨特管狀構造',  '表面有棘，但不是生活在海中',  '不靠管足移動、呼吸、攝食', 1),
(1610,  '中級', '某一山區的山羌在1998年至1999年間的族群個體變化如下：出生15隻，死亡7隻，同時期又有2對山羌遷入，沒有遷出。下列有關此山羌族群的推論，何者最適當？',  '此山區的山羌正在滅少', '此山區的山羌族群達到平衡', '此山區的山羌有增加的趨勢', '此山區的環境惡化不適合山羌生存',  3),
(1611,  '中級', '原生動物界的分類有三種，下列哪個選項「不是」原生動物界的分類？',  '藻類', '原生動物', '原生菌類', '真菌', 4),
(1612,  '中級', '針對節肢動物的描述，下列哪個選項是「錯誤」的？',  '昆蟲為最普遍節肢動物', '附有分節附肢', '附有外骨骼',  '昆蟲不是唯一可以飛翔的無脊椎動物', 4),
(1613,  '中級', '動物依維持體溫的方式，可分為內溫動物(恆溫動物)和外溫動物(變溫動物)，下列哪個選項為內溫動物？', '哺乳類',  '兩生類',  '爬蟲類',  '魚類', 1),
(1614,  '中級', '對於兩棲類之描述，下列哪個選項「錯誤」？', '成體用肺呼吸、幼體用腮呼吸',  '蛙與蟾蜍屬此分類', '皮膚可防止水分散失',  '蟾蜍有毒腺可以分泌毒素',  3),
(1615,  '中級', '犀牛瀕臨絕種的原因為何？', '生殖力高', '人類的濫捕',  '自然環境改變', '犀牛生殖力差', 2),
(1616,  '中級', '有關黑面琵鷺的敘述，下列哪個選項是「錯誤」的？',  '黑面琵鷺瀕臨絕種，屬於世界級保育類動物',  '黑面琵鷺是候鳥，他們每年會跨越許多國家到臺灣過冬', '目前為了黑面琵鷺，我們必須保護臺南七股濕地，不宜開發為工業用地',  '為保育黑面琵鷺，我們應將他們關在動物園，方便加以照顧使其數量增加', 4),
(1617,  '中高級',  '新聞報導：「九二一集集大地震，地震規模是7.3」。下列何者是地震規模所代表的意義？',  '地表震動的程度',  '地震釋放的能量',  '地震發生的深度',  '地震持續的時間',  2),
(1618,  '中級', '當「西北颱」來襲時，中央氣象局會提醒民眾特別注意，下列哪個選項是西北颱可怕的原因？',  '過境後可能替臺灣東部引入西南氣流', '在花東一帶因地形阻擋而降下豪大雨', '臺灣西南地區因處於背風處而引發高熱焚風',  '導致臺灣北部、西北部主要河川積水不易宣洩，並引起海水倒灌', 4),
(1619,  '中級', '當臺灣地區有地震發生時，中央氣象局會很快的發布地震規模與各地地震震度。有關地震規模與地震震度的敘述，下列何者是正確的？',  '規模用來表示地震破壞的程度，震度用來表示地震釋放能量的多寡',  '規模用來表示地震釋放能量的多寡，震度用來表示地震破壞的程度',  '規模用來表示地震釋放能量的多寡，震度用來表示地震影響的範圍',  '規模用來表示地震影響的範圍，震度用來表示地震釋放能量的多寡',  2),
(1620,  '中級', '臺灣冬季經常受到來自蒙古及西伯利亞的氣團影響，下列哪個選項是正確的敘述？', '東部的花蓮、臺東地區因受此氣團影響，常有溫暖季風出現而顯得異常乾燥',  '北部的基隆、宜蘭地區因與氣團前緣接觸，受地形影響容易降雨', '中部的臺中、彰化地區因為位處迎風面，所以極易降雨', '南部的嘉義、臺南地區因受此氣團影響，變得寒冷而潮濕',  2),
(1621,  '中級', '臺灣常因颱風來襲而造成嚴重災情，颱風的威力主要來自下列何者所供應的能量？', '在赤道陸地上吸收來自太陽的熱量',  '受中央山脈的抬升而產生位能',  '低氣壓中心的氣壓差異造成', '颱風雲層吸收水氣凝結所釋放出大量的熱量',  4),
(1622,  '中級', '「中央山脈縱貫臺灣島，早期雖然阻隔東西部的聯繫，但也阻擋不少天然災害的侵襲。」文中所指的「天然災害」主要指的是下列何者？', '寒害', '沙塵暴',  '旱災', '颱風', 4),
(1623,  '中級', '下列何者最有可能是颱風侵襲臺灣所造成的影響？', '由於颱風帶來強風豪雨，經常促成鋒面過境',  '由於颱風帶來大量降雨，使得山區有土石崩落危機', '由於颱風帶來的雨水不易儲存，對水資源的增加沒有幫助',  '由於颱風會帶來溫暖潮濕的空氣，導致全球暖化效應增強',  2),
(1624,  '中級', '當氣象局發布颱風警報，並預測將下三天的豪大雨，則農曆的哪一天，沿海地區最要嚴防海水倒灌？', '初五', '初十', '十五', '二十', 3),
(1625,  '中級', '臺灣哪一個最大的平原，幾乎位在熱帶季風氣候區內，但冬季時強烈大陸冷氣團南下，還是造成大批農作物受到寒害。上述的平原是下列哪個平原？',  '蘭陽平原', '嘉南平原', '屏東平原', '花東縱谷平原', 2),
(1626,  '中級', '臺灣地區每年都會因為洪水而造成許多地區淹水，甚至爆發土石流傷害，試問下列哪一種天氣型態比較”不容易”使南部地區發生洪水災害？', '颱風', '梅雨', '東北季風增強', '西南氣流增強', 3),
(1627,  '中級', '當臺灣地區有地震發生時，常可聽到新聞有相關報導，下列所報導的內容何者是「錯誤」的？',  '本次地震發生的震央位置在花蓮，震源深度為200公里',  '震度為花蓮4.2、臺東3.6、宜蘭3.4', '地震的大小為芮氏地震規模5.3',  '發生原因是菲律賓海板塊擠壓歐亞板塊所致',  2),
(1628,  '中級', '臺灣縣誌中載有「風過後，木葉焦萎」的現象發生，此種乾熱的焚風，最可能發生在下列哪個縣市？', '臺東縣',  '彰化縣',  '宜蘭縣',  '澎湖縣',  1),
(1629,  '中級', '土石流是山崩的一種形式，常常造成臺灣山區嚴重災害。若要設計土石流預警系統，則下列哪項因素可為預警的主要根據？', '氣壓', '風速', '雨量', '溫度', 3),
(1630,  '中級', '交通部已研擬「高速公路疏運計畫」，以利紫斑蝶遷徙時安全穿越國道三號林內段，主要的考量原因是下列哪個選項？', '疏解交通壅塞', '保護自然生態', '促進觀光發展', '顧及行車安全', 2),
(1631,  '中級', '(A)砂灘；(B)V型谷；(C)鵝卵石；(D)三角洲；(E)冰磧石；(F)海拱。以上為沉積作用所形成的有幾種？',  '1種', '3種', '2種', '4種', 2),
(1632,  '中級', '日本於2011年3月11日發生大規模地震，並引發巨大海嘯，造成重大人員和財產損失。試問地震發生處的太平洋板塊和北美板塊交界類型為何？', '為張裂性交界', '為錯動性交界', '為聚合性交界', '資料不足，無法判斷',  3),
(1633,  '中級', '生物複製技術之發展不可輕易為之，其考量因素為何？', '倫理與道德問題',  '會發生基因改變與畸形問題', '生物複製仍未完美仍有缺陷', '以上皆是', 4),
(1634,  '中級', '在食物鏈中若無初級消費者，則下列哪個選項是正確的敘述？',  '生產者可以無限制地繁殖',  '生產者將因過度繁殖，致使資源不足而減少',  '二級消費者大量繁殖',  '二級消費者將因過度繁殖而導致食物分配不足', 2),
(1635,  '中級', '有關風化作用的敘述，下列哪個選項是「錯誤」的？',  '海蝕平臺是風化作用所形成', '風化作用是大岩石逐漸崩解成小碎塊的過程',  '在氣候溫暖潮濕的環境當中，岩石容易與水產生化學反應而逐漸鬆軟', '風化作用的最終產物為土壤', 1),
(1636,  '中級', '有關突變之說明，下列哪個選項正確？',  '突變若發生在生殖細胞則會影響下一代',  '人為誘變分為物理與化學因素',  '突變分為人為誘變與自然突變',  '以上皆是', 4),
(1637,  '中級', '東方果實蠅是臺灣果樹的主要害蟲之一，目前果農常利用寄生蜂進行生物防治的工作，下列哪個選項是正確的敘述？',  '寄生蜂和東方果實蠅存在著競爭關係', '此方法可減少農藥的使用量', '寄生蜂的幼蟲以東方果實蠅的成蟲為食',  '寄生蜂產卵於東方果實蠅體內，兩者間有互利共生關係', 2),
(1638,  '中級', '南美洲有一種植物，只能依賴一種攝取花蜜的蝙蝠為媒介傳送花粉，然而此種蝙蝠因人類大量的捕捉而滅絕。下列何者是此植物族群的個體數量產生的變化？',  '逐漸增加', '不受影響', '逐漸減少', '先增加後減少', 3),
(1639,  '中級', '流水為侵蝕作用的主要營力，試判斷下列哪個選項「無法」加強河流侵蝕與搬運的能力？',  '因板塊擠壓造成地殼隆起',  '因全球暖化影響，海平面高度上升',  '因強烈颱風來襲，河流集水區降下驚人雨量',  '上游山坡地經不肖業者濫墾濫伐', 2),
(1640,  '中級', '美國於1991年創造的「生物圈二號」模擬地球生態封閉系統的實驗，其模擬的生態系統「不包含」下列哪個選項？', '海洋', '雨林', '極地', '沼澤', 3),
(1641,  '中級', '森林裡的松鼠數量激增，危害樹木甚鉅，以下何種做法「不符合」生態保育的原則？',  '森林裡松鼠繁殖的數量再多都要加以保護', '選擇適當的地點設置陷阱，減少松鼠的數量',  '適度開放狩獵活動，適量捕捉森林中的松鼠',  '適量的增加原棲息地松鼠的天敵，如貓頭鷹等', 1),
(1642,  '中級', '湍急的河水當中有粒徑大小不同的沉積物如下：(A)巨礫；(B)泥；(C)沙粒；(D)鵝卵石，若河川流量或流速降低，則上述沉積物之沉積順序下列何者是正確的？', 'CBDA', 'DABC', 'ADCB', 'BCAD', 3),
(1643,  '中級', '形成翡翠樹蛙保護色的演化機制為何？',  '性狀有差異，經天擇的結果', '性狀有差異，經人擇的結果', '天擇後，經性狀改變的結果', '人擇後，經性狀改變的結果', 1),
(1644,  '中級', '臺灣雨量充足，年平均雨量高出世界平均值，但為何臺灣仍然缺乏水資源？',  '工業用水過量', '民生用水過量', '農業用水過量', '降雨集中在雨季，河川短急', 4),
(1645,  '中級', '颱風登陸後，風力減弱的原因是什麼？',  '颱風接近陸地時，壽命本來就即將結束',  '颱風登陸後，人類活動使其風力減弱', '颱風登陸後，缺乏水氣且陸地磨擦力破壞其結構',  '颱風登陸後，受到火山影響而減弱',  3),
(1646,  '中級', '關於風化作用與侵蝕作用的敘述，下列哪個選項是正確的？', '太魯閣的峽谷是冰川侵蝕的結果', '河流、冰川、風與海水隨時都對地表進行侵蝕', '野柳海邊的燭臺石是海浪的沉積作用', '侵蝕地表最主要的力量是風化作用',  2),
(1647,  '中級', '(A)尼羅河三角洲；(B)野柳女王頭；(C)黃土高原；(D)太魯閣峽谷；(E)挪威峽灣。上述著名的地質景觀中，何者屬於旺盛的搬運與堆積作用下所形成的地形？',  'ABC',  'BCE',  'AC', 'CDE',  3),
(1648,  '中級', '日月潭是臺灣著名的景點之一，遊客如織。關於「日月潭」的敘述，下列哪個選項正確？',  '日月潭是淡水湖，所以完全沒有鹽類', '日月潭中的沉積速率大於侵蝕速率',  '日月潭為永久侵蝕基準面',  '以上皆是', 2),
(1649,  '中級', '花蓮太魯閣峽谷高聳入雲，谷底的立霧溪將兩側的大理岩雕塑成各種形貌。關於此一地質景觀，下列哪個選項是「錯誤」的？',  '峽谷主要是立霧溪向下侵蝕而成', '峽谷如此高聳是因為其還在抬升當中', '大理岩是由河水侵蝕而成',  '大理岩是由石灰岩變質而成', 3),
(1650,  '中級', '莫拉克颱風水患造成臺東知本溪旁的金瓜飯店倒塌，造成此一災害的主因為何？',  '大量的土石流衝擊建築', '河流側向侵蝕掏空地基', '土壤泡水液化', '洪水直接沖毀', 2),
(1651,  '初級', '臺灣有「水果王國」的美名，主要受到下列哪兩大因素的影響？', '緯度、地形',  '風向、雨量',  '雨量、土壤',  '季風、土壤',  1),
(1652,  '中級', '昔日臺灣的農業有「農無閒年，地無閒田」之說，主要反映何種農業經營特色？',  '農村勞力老化', '休閒農業興起', '農業經營高度集約', '農業技術先進', 3),
(1653,  '中級', '業者將經營的休閒農場，從大都市的郊區搬到鄉間的農村。選擇此種經營方式的主要原因是什麼？',  '鄰近消費市場', '降低土地成本', '增加勞力供應', '減少遊客污染', 2),
(1654,  '中級', '臺灣從事哪一種產業活動的經營者，因其產品新鮮而在市場因素的刺激下蓬勃發展？',  '精緻農業', '休閒農業', '酪農業',  '養豬業',  3),
(1655,  '中級', '農人為了提高水稻產量而大量撲殺麻雀，反而使得蝗蟲大量繁殖，吃光水稻。這種情況發生的主要原因為何？', '蝗蟲的天敵減少',  '蝗蟲少了麻雀競爭食物來源', '環境中出現外來種的競爭',  '麻雀死了可供蝗蟲做為食物', 1),
(1656,  '中級', '所謂水質優養化是指水質太營養，水中藻類生長快速，當藻類死亡分解時，會使水中所融解的哪種氣體顯著減少？', '二氧化碳', '氧氣', '氮氣', '臭氧', 2),
(1657,  '中級', '預防洪水災害的觀念，下列哪個描述是正確的？',  '洪水是一種自然現象',  '洪水的發生是長時間不下雨所造成的災害', '將河道縮減增加建地，開發成社區居住',  '開發山坡地成果園、農地，農作物的根系又多又深，能牢牢的抓住土壤',  1),
(1658,  '中級', '下列哪種行為較合乎生態平衡的原則？',  '臺灣山區雖然常有毒蛇出沒，為求生態平衡不可濫殺',  '儘量購買國外的鳥類，當不飼養時，為求生態平衡，可放生至野外',  '在水源保護區開發觀光森林公園，是充分利用土地的做法',  '為了沿海養殖漁業的發展，可以遷移黑面琵鷺的棲息地', 1),
(1659,  '中級', '地震快報：「今日清晨發生有感地震，震央位於蘇澳東方外海，深度約40公里，地震規模5.8。」關於上述報導，下列何者正確？',  '為深源地震',  '屬於中規模地震',  '最大震度為0級',  '以上皆是', 2),
(1660,  '中級', '平時做好防震工作，可降低地震發生時的災害，試問此防震工作”不包括”下列哪個選項？', '不任意更改建築物結構', '多栽植花草以美化居家環境', '將房屋中的書架，櫥櫃加以固定', '易碎或易傾倒的物品不置於高處', 2),
(1661,  '中級', '某日，宜蘭發生地震，當時小敏正在家中看電視。當他感覺到地震的搖晃時，做了幾項處理方式，試問下列何者是”不恰當”的？',  '搭乘電梯，逃離四樓的住家', '關閉電源、瓦斯',  '拿枕頭保護頭部',  '將門打開', 1),
(1662,  '中級', '有關環境的問題，下列哪個選項是正確的敘述？',  '汽車排放過多二氧化碳，造成大氣平均溫度降低',  '過度墾荒伐林，加速風化侵蝕作用',  '湖中營養鹽過多，使水中氧氣增加',  '超抽地下水不會造成地層下陷',  2),
(1663,  '中級', '臺灣林業在民國60年代為砍伐高峰期，但從民國80年代開始，所需木材多仰賴進口。導致此種轉變的主要因素為下列哪個選項？', '森林砍伐殆盡', '木材需求量大', '全球氣候暖化', '森林保育是重要的', 4),
(1664,  '中級', '目前的林業政策為何？', '砍伐規模擴大', '提升林業產值', '大量外銷木材', '強調森林保育', 4),
(1665,  '中級', '成立東沙環礁國家公園的主要原因是下列哪個選項？',  '發展海洋觀光事業', '保育島上植被', '宣示東沙群島主權', '珊瑚等海洋生物資源復育',  4),
(1666,  '中級', '下列何種措施最適宜自然資源保育？', '保留野生動、植物的品種和棲地', '大量飼養櫻花鉤吻鮭做為寵物',  '填平溼地、沼澤以利植物生長',  '在所有河口廣植紅樹林', 1),
(1667,  '中級', '造成臺灣本土特有之動、植物瀕臨絕種的主要原因為何？',  '溫室效應', '水資源分配不均',  '森林濫墾、動物濫捕',  '空氣中二氧化碳增加',  3),
(1668,  '中級', '政府制定哪種法令以落實保育工作？', '《文化資產保存法》',  '《國家公園法》',  '《野生動物保育法》',  '以上皆是', 4),
(1669,  '中級', '造成許多臺灣原生動植物，如：臺灣鮭魚、寬尾鳳蝶、鐘萼木等逐漸滅絕的主要原因為何？', '土石流破壞環境',  '外來物種大量繁殖造成威脅', '溫室效應引起的結果',  '人類不當破壞環境及濫加採獵',  4),
(1670,  '中級', '淡水水域常見的福壽螺不是臺灣原生種的淡水螺類，而福壽螺的引進，會造成下列哪種影響？',  '食物來源增加', '增加臺灣地區的生物多樣性', '對淡水生態造成負面衝擊',  '因數量少，因此影響很小',  3),
(1671,  '中級', '臺灣在民國六十幾年時，由於不當引進福壽螺，而大量危害農作物與水生生物，使生態系經歷了一次大浩劫，福壽螺為何可以大量繁殖？', '體型壯碩', '性情凶猛', '在本地沒有天敵',  '食量大',  3),
(1672,  '中級', '二十年前曾有人引進小花蔓澤蘭來綠化環境，今日這種植物已經在臺灣中南部地區造成許多原生植物死亡，甚至危害農作物，因此有綠色癌症之稱，關於此現象，下列哪個選項是正確的敘述？', '這是天擇的結果，應讓其自然演化',  '不當引入外來生物，可能破壞原本的生態平衡', '應多引入外來種昆蟲，以控制此植物的繁衍',  '外來種植物可增加本地的生物多樣性', 2),
(1673,  '中級', '人厭槐葉蘋對許多生態系而言屬於外來種生物，下列哪個選項是此外來種成為生態殺手的主要原因？', '人類的傳播',  '當地有天敵存在',  '無法適應當地環境', '繁殖速度比原生種慢',  1),
(1674,  '中級', '有關外來生物引入的敘述，下列哪個選項是「錯誤」的？',  '為了防止外來生物引入國內，各國海關都有檢疫制度，禁止攜帶活的動植物及種子入關', '進行生物防治時也有可能造成外來生物的引入', '引入外來生物並不會影響生態系中生物的交互作用', '外來生物有可能使當地生物多樣性降低',  3),
(1675,  '中級', '有關外來種生物會造成危害的理由，下列哪個選項是正確的論述？',  '不會帶來當地原本沒有的疫病',  '可能成為當地生物新的掠食者',  '不會與本地種產生雜交，影響族群基因',  '在野外自行大量繁殖，但不會排擠當地原有生物的生存', 2),
(1676,  '中級', '為何福壽螺在臺灣的池塘和稻田中可以大量繁殖？', '性情兇猛', '題型壯碩', '食量大',  '在本地沒有天敵',  4),
(1677,  '中級', '下列何者係經由各種途徑入侵臺灣的外來種生物？', '小花蔓澤蘭',  '馬纓丹',  '紅火蟻',  '以上皆是', 4),
(1678,  '中級', '對外來種實施生物防治，應注意下列何種狀況？',  '入侵物種的適應性', '避免入侵物種滅絕', '天敵在新棲息地的存活率',  '控制非靶標物種的繁殖', 4),
(1679,  '中級', '以下何者為嚴重影響臺灣生態的外來生物？',  '福壽螺',  '美國螯蝦', '布袋蓮',  '以上都是', 4),
(1680,  '中級', '從國外引進福壽螺和螯蝦後，對臺灣的生態環境所造成的長期影響，下列哪個選項是「錯誤」的？',  '原生態系發生改變', '成為優勢的水生動物',  '增加生物多樣性',  '對生活在水田、池塘的其他生物造成嚴重威脅', 3),
(1681,  '中級', '人厭槐葉蘋主要以營養器官繁殖，繁殖速度快，鋪滿整個水面後仍可不斷增生，且越長越厚，使水面下的生物無法行光合作用，也阻絕空氣的交換，使水生動物因缺氧而大量死亡，引發食物鏈崩潰的連鎖效應，造成水生生態系的毀滅。下列哪個選項「不是」此外來種成為生態殺手的主要原因？',  '人類的傳播',  '當地沒有天敵', '可適應當地環境',  '繁殖速度比原生種慢',  4),
(1682,  '中級', '鰲蝦是一種外來生物，它對臺灣生態造成的影響為何？', '增加生物多樣性',  '增加物種複雜度，以穩定食物網', '和原生種生物競爭生存空間', '螯蝦體積小，對環境不會產生影響',  3),
(1683,  '中級', '下列哪種作法「不符合」保育的原則？',  '引入外來物種增加生物種類', '回收與再利用可用物資', '採用輪耕與有機栽培',  '在特定季節開放垂釣非保育類的魚類', 1),
(1684,  '中級', '若我們從平地爬上高山，應可看到不同的植物類型，請依地勢低到高將(A)針葉植物；(B)闊葉植物；(C)高山草原的順序排出。', 'ABC',  'ACB',  'BAC',  'BCA',  3),
(1685,  '中級', '自民國80年起，臺灣政府為了維護生態與水土保持，採取下列哪項林業經營政策？',  '適度開發砍伐天然林',  '全面開發利用山坡地',  '大量開採外銷，以賺取外匯', '保育重於砍伐，全面禁伐天然林', 4),
(1686,  '中級', '最應該優先考量的林業資源相關政策為何？',  '森林生態保育', '觀光資源發展', '林材外銷收益', '提供學術研究', 1),
(1687,  '中級', '目前臺灣對於林業經營的政策為何？', '砍伐重於種植', '伐植平衡', '大量砍伐以賺去外快',  '禁止砍伐，積極造林',  4),
(1688,  '中級', '下列哪項行為「不受」保育法令的禁止？', '在電宰場宰殺土雞', '在玉山國家公園採集稀有植物',  '在雪霸國家公園獵捕雲豹',  '獵捕飛來臺灣過冬的伯勞鳥', 1),
(1689,  '中級', '由北至南依序排列臺灣本島的國家公園，下列哪個選項完全正確？',  '太魯閣、雪霸、墾丁',  '雪霸、太魯閣、玉山',  '臺江、玉山、墾丁', '雪霸、臺江、玉山', 2),
(1690,  '中級', '請問下列哪個國家公園位於離島？',  '太魯閣國家公園',  '雪霸國家公園', '東沙環礁國家公園', '臺江國家公園', 3),
(1691,  '中級', '下列哪個國家公園設立之前，曾因戰地政務的考量，在沿海樹林中埋設大量的地雷，阻隔人們進入濱海的沙灘地，使該地意外成為活化石「鱟」理想的產卵地點？',  '金門國家公園', '東沙環礁國家公園', '墾丁國家公園', '臺江國家公園', 1),
(1692,  '中級', '下列哪個選項「不屬於」食物中所能提供能量的養分之一？', '維生素',  '蛋白質',  '脂類', '醣類', 1),
(1693,  '中級', '下列哪種生物對於氮的循環最為重要？',  '蚯蚓', '禿鷹', '馬陸', '細菌', 4),
(1694,  '中級', '下列哪種生態系中的生物種類「最少」？', '森林生態系',  '草原生態系',  '沙漠生態系',  '海洋生態系',  3),
(1695,  '中級', '已知食物網越複雜，則生態系就越穩定。如果一種生物消失，最容易在下列哪一地區造成生態嚴重失調？', '熱帶雨林', '沙漠', '珊瑚礁',  '濕地', 2),
(1696,  '中級', '下列哪個選項可能是生物之所以會產生多樣性的原因？', '有性生殖造成生物個體特徵的多樣性', '基因突變', '生活棲息地的不同', '以上皆是', 4),
(1697,  '中級', '有關生物分類系統描述，下列哪個選項是「錯誤」的？', '以7個階層分類',  '分類階層越高種類越多', '越低階的種類越少，但越相近',  '外表相似即代表物種相近',  4),
(1698,  '中級', '生物多樣性高的地區「沒有」下列哪種特性？', '通常是開發中國家或未開發的國家',  '生物種類多，較容易保持生態平衡',  '可提供豐富的物種資源解決相關問題', '生物數量多，較不能適應環境的改變', 4),
(1699,  '中高級',  '生物與生物之間相互作用的組合，下列哪個選項是正確的？', '老鷹和魚的關係是競爭', '植物與光線的關係是互利共生',  '小丑魚和海葵的關係是捕食', '樹上的蘭花與樹木是片利共生',  4),
(1700,  '中級', '毒性物質透過食物鏈，從初級消費者逐漸累積到高級消費者的過程稱為什麼？', '食物鏈累積',  '生態累積', '毒性累積', '生物累積', 4),
(1701,  '中級', '白匏子樹的葉柄基部可以分泌甜液吸引螞蟻，螞蟻為了吸食甜液會努力守護白匏子樹，不讓其他昆蟲傷害它。下列哪種模式是此二種生物的交互作用關係？', '共生', '寄生', '捕食', '競爭', 1),
(1702,  '中級', '同種生物的不同個體，具有不同的遺傳因子組合，稱為什麼？',  '物種多樣性',  '遺傳多樣性',  '生態系多樣性', '族群多樣性',  2),
(1703,  '中級', '同種生物個體間表現出不同性狀的差異，稱為遺傳多樣性，下列哪個選項是正確的敘述？',  '應減少遺傳多樣性，否則會使不良品種數量增加',  '無性生殖能使子代間有變異，造成遺傳多樣性', '遺傳多樣性越高，個體越能適應變動的環境',  '遺傳多樣性越高，代表生態系中的物種數量越多',  3),
(1704,  '中級', '有一個食物網包含草、蟋蟀、老鼠、蛇、老鷹；比較上述不同生物的特性及所含總能量的多寡，下列哪個選項是正確的敘述？',  '老鼠為蛇和鷹的食物來源，在此食物網中所含的總能量最多', '蟋蟀個體最小，在此食物網中所含的總能量最少',  '鷹是最高階的消費者，在此食物網中所含的總能量最多', '草是生產者，在此食物網中所含的總能量最多', 4),
(1705,  '中高級',  '有關生物多樣性的組成，下列哪個論述是「錯誤」的？', '遺傳多樣性',  '棲息地多樣性', '生態系多樣性', '物種多樣性',  2),
(1706,  '中級', '有關生物多樣性的描述，下列哪個選項是「錯誤」的？', '分為2種層次', '生物種類多就是生物多樣性', '提供生物棲息環境種類分為生態系多樣性', '同一物種遺傳性狀差異則為遺傳多樣性',  1),
(1707,  '中級', '有關生物多樣性的觀念，下列哪個選項是「錯誤」的？', '引進世界各地區之不同種生物，以增加臺灣地區的生物多樣性',  '生物多樣性有利於維持生態系的平衡', '生物多樣性有助於自然界物質及能量的流動',  '與人類較無直接相關的生物種類，也應該加以保留', 1),
(1708,  '中級', '有關生物的多樣性的敘述，下列哪個選項是正確的？',  '地球上不同的環境中存在著各式各樣、形形色色的生物，稱為生物多樣性', '生態系中所存在的生物種類是永遠固定不變動的',  '生態系中，單一種的生物數量越多，代表生物多樣性越高',  '生態系中，生物多樣性越高就越不穩定',  1),
(1709,  '中級', '有關生物的命名法，下列哪個選項是正確的？', '以俗名分類',  '俗名加上種名', '學名', '種名', 3),
(1710,  '中級', '有關生物的演化描述，下列哪個選項是正確的？',  '最古老化石為藍綠藻',  '距今54億年前之後的地質年代劃分為古生代、中生代與新生代', '中生代的代表生物為三葉蟲', '恐龍的滅絕為距今6億5千萬年前發生',  1),
(1711,  '中級', '有關生物間互相競爭的敘述，下列哪個選項是「錯誤」的？', '環境中資源不足是造成生物間互相競爭的重要原因之一', '榕樹下樹幹周邊區域植物生長稀少，是競爭所產生的結果',  '麻雀與白頭翁的食物來源種類很相近，彼此間便產生了競爭關係', '植物間不會為了爭取生存空間而競爭', 4),
(1712,  '中級', '有關生產者的敘述，下列哪個選項是「錯誤」的？', '為生態系中能量的主要供應者',  '大多分布於陽光可及之處',  '與生態系的組成無關',  '能補充空氣中氧氣的量', 3),
(1713,  '中級', '有關自然界中物質循環的觀念，下列敘述何者「錯誤」？',  '物質可在生物與非生物間循環',  '細菌在物質循環上可扮演分解者的角色',  '以生物屍體為食的物種，有助於物質循環', '進入生物體的物質均可被生物所利用、分解及排除', 4),
(1714,  '中級', '有關孟德爾的遺傳法則，下列哪個選項是正確的描述？', '生物性狀無法由遺傳因子控制',  '遺傳因子只有隱性形式', '隱性與顯性因子同時出現時，只會出現顯性因子症狀',  '遺傳因子在傳給子代時不會各自分離', 3),
(1715,  '中級', '有關河川生態系的敘述，下列哪個選項是正確的？', '由於水流較急，所以含氧量較低', '食物主要來自河岸兩旁的落葉和斷枝', '主要生產者為浮游藻類', '常自成一個獨立的生態系，不與其他水體相連', 2),
(1716,  '中級', '有關食物鏈與食物網的描述，下列哪個選項正確？', '食物網屬於生產者與消費者單向的鏈狀關係',  '生態系物種越多，皆可作為食物鏈而非構成食物網', '食物網可以分類初級消費者與次級消費者', '以上皆非', 4),
(1717,  '中級', '有關被子植物的描述，下列哪個選項是正確的？',  '又稱為開花植物',  '僅可分為雙子葉單一物種',  '雙子葉植物花瓣為3的倍數', '單子葉植物花瓣為4、5的倍數', 1),
(1718,  '中級', '有關演化學說的演進，下列哪個選項是正確的描述？',  '拉馬克用進廢退說為後天基因也會獲得改變',  '達爾文天擇說為物種不會受到自然環境篩選',  '達爾文天擇說說明長頸鹿脖子短無法吃到樹葉者會遭受淘汰', '用進廢退說證明長頸鹿會自己伸長脖子吃到樹葉是正確的',  3),
(1719,  '中級', '有關維護生物多樣性，下列哪個選項是「錯誤」的作法？',  '許多國家共同制定公約，例如生物多樣性公約', '為維護生物多樣性，各國攜手合作',  '結合政治、經濟、法律等各方面的專家與社會大眾的力量，共同參與', '幫助南美洲等具有熱帶雨林的開發中國家開墾森林、築橋鋪路',  4),
(1720,  '中級', '兩物種間的生態關係，其中一種生物會因這個關係而獲得生存上的利益；但是，另一方的生物在這個關係中，並沒有獲得任何益處，屬於競爭中的何種狀態？',  '寄生', '互利共生', '片利共生', '以上皆非', 3),
(1721,  '中級', '果農在培育優良蓮霧物種時，所運用之未透過精卵結合的生殖方式稱為什麼？', '細胞分裂', '減數分裂', '無性生殖', '有性生殖', 3),
(1722,  '中級', '某淡水生態系中生物的食性關係為：水蚤→小蝦→大肚魚→白鷺，在此食物鏈中，哪種生物數量應最多，才能維持平衡狀態？',  '水蚤', '蝦',  '大肚魚',  '白鷺', 1),
(1723,  '中級', '前寒武紀、古生代、中生代和新生代等歷史分期合稱為什麼時代？',  '地球時代', '地質時代', '地理時代', '地科時代', 2),
(1724,  '中級', '下列何者是海葵常附著在寄居蟹上較為合理的解釋？',  '海葵是植物，須靠寄居蟹助其運動',  '海葵能行光合作用，替寄居蟹製造養分',  '海葵能保護寄居蟹，寄居蟹能幫助海葵移動',  '海葵可增加美觀，寄居蟹能使海葵便於浮起',  3),
(1725,  '中級', '能量在生物與環境及生物與生物之間流轉，關於能量流轉的順序排列，下列哪個選項是正確的？', '日光能→生產者→消費者→分解者→大自然',  '日光能→大自然→消費者→分解者→生產者',  '日光能→分解者→生產者→消費者→大自然',  '大自然→生產者→消費者→分解者→日光能',  1),
(1726,  '中級', '解釋同種生物個體間的差異是演化進行的原動力，個體的性狀能否被保留下來，則視當時的環境而定；經過長時間的多代遺傳後，適應環境的性狀在群體中所占的比例會越來越多，所以是「大自然」來決定何種性狀可被保留下來。下列哪一個選項是此理論？',  '用進廢退說',  '天擇說',  '物種原始', '人擇', 2),
(1727,  '中級', '對於生物多樣性的敘述，下列哪個選項正確？', '生態系中，生物多樣性愈高就愈不穩定',  '生態系中，單一種的生物數量愈多，代表生物多樣性愈高',  '生態系中所存在的生物種類是永遠固定不變的', '同一環境中，有各種不同的生物生存', 4),
(1728,  '中級', '對於生物界的描述，下列哪個選項正確？', '病毒可歸類為完整生物體',  '除了原核生物外其餘為非真核生物',  '真核生物沒有細胞核',  '三界分類法分為動物、原生生物與植物',  4),
(1729,  '中級', '演化中的「天擇說」理論是解釋同種生物個體間的差異是演化進行的原動力，是由誰所提出的？', '拉馬克',  '達爾文',  '法拉第',  '以上皆非', 2),
(1730,  '中級', '演化中的「用進廢退」理論解釋生物個體會隨著生存環境的變化而改變的道理。這個理論是由誰所提出的？',  '拉馬克',  '達爾文',  '法拉第',  '以上皆非', 1),
(1731,  '中級', '豬籠草和毛氈苔等捕蟲植物常生長於土壤貧瘠的環境中，主要是藉由捕食昆蟲以獲得該地區「缺乏」的哪種營養素？',  '碳',  '氮',  '鐵',  '鉀',  2),
(1732,  '中級', '「螳螂捕蟬，黃雀在後」這句話表示生物間的哪種關係？',  '寄生', '食物鏈',  '合作', '共生', 2),
(1733,  '中級', '目前發現最古老的化石藍綠菌是距今大約幾億年前的產物？', '30億',  '35億',  '40億',  '45億',  2),
(1734,  '中級', '關於生物多樣性的敘述，下列何者正確？', '引入外來物種的結果',  '生態系失去平衡的結果', '各式各樣的生命逐漸滅絕的結果', '萬物生生不息在地球的生物圈共榮共存的結果', 4),
(1735,  '中級', '關於物種多樣性的敘述，下列哪個選項「錯誤」？', '個體數相近的地區，物種越多的區域，生態系越穩定',  '熱帶雨林比草原生態系的多樣性高',  '物種多樣性越高的地區，食物網越複雜，生態系就越穩定',  '開發沼澤地為良田，增加了物種多樣性',  4),
(1736,  '中級', '生態學家們努力保護現存的樹種，主要目的為何？', '成立國家公園或自然保留區', '維護生物多樣性',  '以利將來的開發',  '供人類觀賞與食用', 2),
(1737,  '中級', '下列何種措施有助於維護臺灣生物的多樣性？', '擴大農業耕地面積', '由國外引進外來種生物', '設立國家公園與生態保護區', '捕捉溪流中的魚飼養在水族箱裡', 3),
(1738,  '中級', '地球上的生物多樣性所遭遇的危機為何？', '棲息地的減少與破壞',  '過度採獵野生動植物做交易', '不當引入外來物種', '以上皆是', 4),
(1739,  '中級', '如果生態系是一個拼圖，每種生物代表一塊小拼圖，你認為下列哪個選項最正確？', '生態系中的拼圖數量越少越好，如此每種生物的重要性便提升',  '生態系中的某一塊小拼圖可被他種生物的拼圖任意取代', '拼圖越多越小越好，如此即使不小心遺失了一塊拼圖，整體的完整性也較不易被破壞',  '以上皆是', 3),
(1740,  '中級', '在漁業資源的影響考量下，為何農業會漁業署規定每年約5至9月為?仔魚的禁捕期？', '避免過度捕撈', '讓漁民放假休息',  '用以調節市場價格', '國際保育團體抨擊', 1),
(1741,  '中級', '下列何種做法有助於維護臺灣生物多樣性？',  '引進外來種',  '設立保護區',  '擴大農業耕作面積', '大量捕捉各種物種進行人工飼養', 2),
(1742,  '中級', '自然界中充滿著形形色色的生物，但生態學家們仍努力保護現存的物種。主要目的為何？',  '成立自然保留區或國家公園', '維持生物多樣性，達到生態平衡', '創造新的物種，提高國際知名度', '提供國人更多休閒旅遊和教育的環境', 2),
(1743,  '中級', '下列棲息地中，哪個區域的生物種類可能最多？',  '大安森林公園', '青青草原', '碧湖山茶園',  '鳥松溼地公園', 4),
(1744,  '中級', '五梨跤與水筆仔同為紅樹科植物，以胎生苗繁衍，下列哪個選項是正確的敘述？',  '種子先在母樹上發芽，然後落在泥土中生長',  '果實隨海水漂流，被沖到岸上才能發芽生長',  '種子要落在鹽分高的海水中，才能發芽生長',  '不會開花結果，需要靠人類為他們插枝繁衍',  1),
(1745,  '中級', '有關潮間帶的敘述，下列哪個選項是「錯誤」的？', '位於滿乾潮之間的地帶', '提供人們養殖、遊憩與觀光的主要場所',  '生物能適應短暫缺水及陽光曝晒', '此地生態系的生產力，與其它生態系相較，生產力偏低', 4),
(1746,  '中級', '砍伐淡水河口沼澤區的水筆仔，將對該區造成下列哪種影響？',  '水鳥會有較大的棲息空間',  '可使淺海逐漸成為沼澤，沼澤再變為陸地', '可防止海水倒灌，有利於海岸的水土保持', '沒有了水筆仔的枯枝落葉，將使魚蝦貝類減少', 4),
(1747,  '中級', '草、水筆仔、蝦、寄居蟹、彈塗魚與水鳥的生物組合，最可能出現在臺灣哪個生態區域？',  '淡水河口', '石門水庫', '墾丁海邊', '澄清湖',  1),
(1748,  '中級', '關於紅樹林生態系的敘述，下列何者「錯誤」？',  '紅樹林中的食物豐富，可供養眾多的生物', '增加紅樹林的種植面積，會增強地球的溫室效應',  '紅樹林中招潮蟹、水筆仔等各種生物族群的集合，稱為群集', '紅樹林中的生物群集和其生存環境共同組成了紅樹林生態系', 2),
(1749,  '中級', '關於臺灣各河口地區生物的特色，下列何者正確？', '臺南四草的五梨跤', '臺北竹圍的海茄苳', '嘉義好美寮的黑面琵鷺', '曾文溪口的水筆仔', 1),
(1750,  '中級', '關於砍伐山坡林木對生態環境所造成的影響，下列哪個選項是「錯誤」的敘述？',  '生物多樣性上升，生物種類增加', '固著土壤的功能變差',  '涵養水源的能力減弱',  '淨化空氣的功能降低',  1),
(1751,  '中級', '下列有關水土保持的敘述，何者「不正確」？', '在低窪地區大量抽取地下水，容易造成地層下陷',  '在河邊養殖家禽家畜，可能使下游藻類過量孳生',  '在水庫上游砍伐樹木，會減少水庫的泥沙淤積量',  '在坡度陡峭的高山上種植蔬果，會造成土壤流失',  3),
(1752,  '中級', '高山地區砍伐森林改種茶樹果園，對生態造成的影響，下列哪個選項是正確的？',  '水土保持會遭受破壞，造成土石流',  '可增加高山動物的棲息場所', '可加速碳元素的循環',  '可促進植物生態的更新演進', 1),
(1753,  '中級', '造成臺灣地區近年來常發生土石流災害的因素中，下列何者屬於人為的因素？', '地震造成的山崩',  '連續不斷的大雨',  '土地不當開發及利用',  '地形陡峻且多順向坡',  3),
(1754,  '中級', '關於砍伐山坡林木對生態環境所造成的影響，下列敘述何者「錯誤」？',  '生物多樣性增加',  '固著土壤的功能變差',  '涵養水源的能力減弱',  '淨化空氣的功能降低',  1),
(1755,  '中級', '下列關於土石流的敘述，哪一個「錯誤」？',  '人類不當開發山坡地，會加劇土石流的發生',  '開發山坡地時，應選擇陡坡，因為其排水系統良好，能夠避免土石流發生', '開發山坡地時，應做好排水系統，才能減緩土石流發生', '應在山坡地上多種植根較深的植物，以穩固疏鬆的土石', 2),
(1756,  '中級', '下列哪種順向坡容易發生山崩？', '珊瑚礁石灰岩區',  '深成岩區', '大理岩區', '砂頁岩互層區', 4),
(1757,  '中級', '引起山崩的主要作用力是下列何者？', '重力', '風力', '離心力',  '磁力', 1),
(1758,  '中級', '有關臺灣發生山崩原因，下列何者是「錯誤」的敘述？', '伐林及濫墾會增加山崩發生機率', '雨水滲入地下會增加土體重量，並減少土體與基盤間的摩擦力',  '建築時之廢物堆積會使坡頂負載增加', '山坡傾斜方向與岩層傾斜方向相反時，岩層易滑落', 4),
(1759,  '中級', '形成土石流的條件「不包括」下列何者？', '岩石鬆散', '強風', '暴雨', '山區有坡度大的窄溝谷', 2),
(1760,  '中級', '豪雨過後，常有山崩的現象，原因是雨水滲入地層後，會造成下列哪種現象？', '雨水滲透使土體的重量減輕', '雨水減少岩層的下滑力', '雨水增加岩層間的摩擦力',  '雨水發揮了潤滑作用',  4),
(1761,  '中級', '下列何者「不是」對於洪水、山崩的根本解決之道？',  '設置大量擋土牆',  '在地質調查結果適合的地區進行開發', '興建排水系統', '重視森林保育', 1),
(1762,  '中級', '山崩發生後若再遇上豪大雨，往往形成土石流。依此判斷，下列哪個因素「不是」土石流形成的主要條件？',  '大量的土石',  '大量的降雨',  '陡峭的坡度',  '地震', 4),
(1763,  '中級', '近年來臺灣颱風季節一到，山區就容易發生土石流災害，下列何者是主要的原因？', '以前颱風的雨量較小',  '現在交通便利，容易到山上觀察土石流現象',  '發生土石流的地區都有種植檳榔樹',  '九二一集集地震後，山坡岩體受到震裂，易引發塊體運動',  4),
(1764,  '中級', '太魯閣國家公園有世界級的峽谷景觀，對此一壯觀景色的敘述，下列哪個選項是「錯誤」的？',  '因大理岩質地柔軟，容易崩落',  '地殼抬升作用與河流侵蝕作用共同造成',  '大理岩由石灰岩變質而來',  '此區可見岩石呈波浪狀彎曲，稱為褶皺',  1),
(1765,  '中級', '以下哪些項目可使地表高低起伏落差「變小」？(A)造山運動；(B)岩石風化；(C)火山運動；(D)地層出現正斷層；(E)地表摺皺；(F)水的侵蝕作用。', 'AD', 'BF', 'BC', 'EF', 2),
(1766,  '中級', '由板塊擠壓而成的臺灣，地?活動仍持續進行。下列有關敘述何者是「錯誤」的？', '嘉南平原的沉積物有部分來自中央山脈',  '陸地上升會加速侵蝕作用的進行', '數百萬年後，臺灣可能被侵蝕成平坦的地形，高山將消失',  '板塊擠壓使斷層活動頻繁',  3),
(1767,  '中級', '有關地震的敘述，下列何者是「錯誤」的？',  '臺灣通用的是芮氏地震規模', '震源深度越淺者，地震規模越大', '離震央越近的地方，地震震度通常越大',  '臺灣地區的地震消息由中央氣象局發布',  2),
(1768,  '中級', '有關臺灣的地質敘述，下列哪個選項是「錯誤」的？',  '臺灣位於歐亞板塊與菲律賓海板塊張裂處', '因板塊活動劇烈使臺灣地震頻繁', '因板塊活動讓臺灣島持續上升',  '臺灣的山脈多呈同一走向與板塊運動有關', 1),
(1769,  '中級', '受到板塊擠壓作用的影響，使臺灣得以形成，但下列哪個現象與板塊擠壓「無關」？',  '颱風侵襲臺灣', '臺灣地震頻繁', '中央山脈持續長高', '東部地區出產許多變質岩',  1),
(1770,  '中級', '某次地震的震央位於宜蘭外海的龜山島，若不考慮地形效應，則下列何處的震度最大？', '臺東', '臺中', '基隆', '高雄', 3),
(1771,  '中級', '臺灣位於聚合性板塊邊界上，玉山也在逐年上升，玉山是否也會面臨被冰河侵蝕的情形？',  '會，因為玉山上會下雪', '不會，玉山並無萬年雪線',  '會，因為玉山是臺灣最高峰', '不會，玉山會永無止境的長高',  2),
(1772,  '中級', '花東縱谷是臺灣一個主要的地質邊界，在花東縱谷上往北目視可看到下列哪種地勢？',  '後方是大屯火山群，前方是墾丁珊瑚礁',  '右邊是中央山脈，左邊是海岸山脈',  '前方是大屯火山群，後方是墾丁珊瑚礁',  '左邊是中央山脈，右邊是海岸山脈',  4),
(1773,  '中級', '臺灣的地理位置正好處於海陸板塊的交接地帶，這種地質現象會產生下列哪種情形的發生？', '火山分布', '山勢高峻', '氣候炎熱', '地震頻繁', 4),
(1774,  '中級', '縱貫臺灣島，有「臺灣屋脊」之稱的中央山脈，其形成原因與下列哪個選項「無關」？', '造山運動', '火山運動', '板塊作用', '侵蝕作用', 2),
(1775,  '中級', '下列四地區，哪一個地區最容易發生土石流災害？', '鬆散土石碎屑表層、坡度30°、日累積降雨量155毫米', '裸露堅硬岩石表層、坡度30°、日累積降雨量120毫米', '裸露堅硬岩石表層、坡度20°、日累積降雨量10毫米',  '鬆散土石碎屑表層、坡度20°、日累積降雨量85毫米',  1),
(1776,  '中級', '下列哪個選項「不是」使地球表面漸漸趨於平坦的作用力？', '火山爆發', '風化作用', '侵蝕作用', '沉積作用', 1),
(1777,  '中級', '有關臺灣地區地貌變化的敘述，下列哪個選項是「錯誤」的？',  '岩層呈水平狀態分布',  '岩石變質作用明顯', '中央山脈與海岸山脈都在持續增高',  '地層抬升，連帶加速了河流的侵蝕速率',  1),
(1778,  '中級', '若在海岸山脈山頂的岩層中，找到500萬年前的珊瑚化石，則下列推論何者最合理？', '500萬年前的珊瑚被岩漿掩埋變成化石', '500萬年前的珊瑚可生存在高山上', '地殼變動將500萬年前的珊瑚化石抬升到高山',  '海岸山脈形成於500萬年前',  3),
(1779,  '中級', '臺灣位於板塊聚合帶，下列哪種地形「不會」出現在臺灣本島？', '摺皺', '斷層', '裂谷', '變質岩',  3),
(1780,  '中級', '世界各地發生地震時，通常以地震規模描述地震的大小，地震規模是依據哪種資料來估算？', '地震所造成的傷亡人數', '地震造成各地搖晃的程度',  '地震釋放出的能量大小', '地震波傳遞的距離', 3),
(1781,  '中級', '臺灣西部河流的跨河大橋，常發現橋墩裸露的現象。下列哪一項最有可能是造成此現象的原因？', '河流上游山坡地被濫墾', '曾爆發土石流災變', '下游河流出海處築防波堤',  '下游河段遭濫採砂石',  4),
(1782,  '中高級',  '在綠色植物中，將空氣中的二氧化碳固定於醣分子的過程稱為？', '碳循環',  'CAM循環',  '克雷柏循環(Krebs',  'cycle)', 0),
(1783,  '中高級',  '有關生物學研究方法的敘述，下列哪個選項「錯誤」？', '提出問題是科學方法的第一步',  '觀察有時須利用適當的儀器', '提出假設後設計實驗需有實驗組與對照組', '學說與定律均必須適時修改', 1),
(1784,  '中高級',  '下列何項是政府環保單位呼籲「減少」使用塑膠製品的重點原因？',  '製造成本偏高', '佔空間不易掩埋',  '掩埋會造成土地污染',  '燃燒易產生有毒氣體',  4),
(1785,  '中高級',  '人口年齡結構呈下降型(或稱之為衰退型、負成長型)的社會，其4歲以下幼兒的個體數和40-44歲中年人的個體數相比較結果為何？',  '幼兒的個體數比中年人的個體數少',  '幼兒的個體數不受中年人個體數的影響',  '幼兒的個體數和中年人的個體數一樣', '幼兒的個體數比中年人的個體數多兩倍',  1),
(1786,  '中高級',  '下列幾項保存農作物野生種的理由，何者較為妥適？',  '可減少地球的溫室效應', '減少當地生態系的穩定性',  '增加澱粉生成量，供人類使用',  '提供有用基因，做農作物的育種', 4),
(1787,  '中高級',  '關於生物防治法的敘述，下列哪個選項是「錯誤」的？', '對環境的影響比化學防治法小',  '防治的有效時間比化學防治法久', '效果比化學防治法快',  '降低對飛行目標物種的影響', 3),
(1788,  '中高級',  '下列何者是作為生物能源材料所應具備的條件？',  '能源零消耗',  '能永續經營',  '零污染',  '利用基因改造生物', 2),
(1789,  '中高級',  '垃圾分類(資源回收)是最能實踐下列何種永續發展的力量？',  '社會大眾環保的力量',  '知識經濟的力量',  '科技興國的力量',  '政策與制度的力量', 1),
(1790,  '中級', '下列何者對於溫室效應的敘述是正確的？', '溫室效應是工業革命以後才有的產物', '地球以外的其它行星都沒有溫室效應', '大氣圈的溫度會持續下降',  '溫室效應會牽動地球不正常之氣候變遷',  4),
(1791,  '中高級',  '造成空氣組成成分改變，並造成地球溫度升高的原因為何？', '火山爆發能量的釋出',  '綠色革命以後，生物、人口大量增加', '工業革命以後，大量燃燒化石燃料',  '工業工廠造成的塵埃使空氣混濁', 3),
(1792,  '中高級',  '溫室效應是因空氣中哪一個污染物過多所造成？',  '二氧化硫', '二氧化氮', '二氧化碳', '一氧化碳', 3),
(1793,  '中高級',  '請選出造成溫室效應的主要原因？',  '大氣中二氧化碳增加，吸收太陽輻射熱',  '大氣中二氧化碳增加，地表輻射熱不易散去',  '臭氧增加，吸收太陽輻射熱', '臭氧增加，吸收地球輻射熱', 2),
(1794,  '中級', '下列哪個選項是導致溫室效應惡化的主因？',  '工廠及汽、機車排放的廢氣', '核能發電的副作用', '冰箱等的冷媒或噴霧劑釋出的氣體',  '過度使用清潔劑',  1),
(1795,  '中級', '使用「生質能源」，將有可能「減緩」下列哪個環境問題？', '水質優養化',  '土石流',  '全球暖化', '地層下陷', 3),
(1796,  '中高級',  '下列何項因素是造成近十年來地球地表氣溫增加的主要原因？',  '臭氧層破洞加大',  '工業大量排放二氧化碳', '地球核心溫度逐年升高', '南北極的冰融化使海平面上升',  2),
(1797,  '中高級',  '下列哪個選項是造成近十年來地球地表氣溫增加的原因？',  '工業大量排放二氧化碳', '臭氧層破洞加大',  '南北極的冰融化使海平面上升',  '地球核心溫度逐年升高', 1),
(1798,  '中高級',  '下列哪個選項最有可能是燃燒煤、石油導致全球溫度改變的原因？',  '臭氧增加，大量吸收地球輻射',  '臭氧增加，大量吸收太陽輻射',  '二氧化碳增加，阻擋地球熱輻射', '二氧化碳增加，大量吸收太陽輻射',  3),
(1799,  '中高級',  '在夏威夷上空觀測大氣中二氧化碳的濃度變化，從1960年以來二氧化碳的濃度快速攀升最主要的原因是下列哪個選項？', '砍伐森林', '火山噴發', '人類活動增加', '植物行光合作用',  3),
(1800,  '中高級',  '下列哪些現象或人類的活動可能會造成全球溫度增加？', '沙塵暴造成大氣中的懸浮微粒增加',  '人類大量使用煤、石油等化石燃料',  '火山噴發，大量火山灰進入大氣', '養殖業超抽地下水', 2),
(1801,  '中高級',  '下列何者為「無碳」能源？', '僅產生少量二氧化碳的能源', '即是化石燃料', '利用二氧化碳產生能源', '沒有碳原子參與的能源', 4),
(1802,  '中高級',  '許多國家紛紛致力於減低暖化現象的相關科技，例如由生質柴油取代柴油燃料、發展低碳社會，這樣的做法主要是為了達到什麼目標？',  '保護自然環境', '展現國家科技研發的進步',  '受限於法律的規範', '降低生產成本的壓力',  1),
(1803,  '中級', '造成地球平均氣溫愈來愈高的主要原因是下列何者？',  '太陽輻射從臭氧層的破洞照到地表',  '人為二氧化碳的排放量增加及綠色植物減少',  '因空氣中帶有硫酸及硝酸成分的煙塵顆粒太多所引起',  '火山活動增加，加上聖嬰現象造成氣溫異常',  2),
(1804,  '中高級',  '大氣中哪一種氣體是天氣變化不可或缺的要素？',  '甲烷', '二氧化碳', '水氣', '臭氧', 3),
(1805,  '中高級',  '有關全球暖化的敘述，下列何者正確？',  '地表溫度升高對空氣中水氣含量沒有影響', '二氧化碳(CO2)、甲烷(CH4)、氧化亞氮(N2O)、全氟碳化物(PFCs)、氫氟碳化物(HFCs)，以及六氟化硫(SF6)等是溫室氣體',  '全球暖化是防災不須重視的課題之一', '全球暖化只造成地球平均氣溫的增加，不會引起其它效應',  2),
(1806,  '中高級',  '有關臺灣海岸線變遷的各項因素中，下列哪個選項屬於全球性因素？', '工業區的開發', '養殖業超抽地下水', '興建攔河堰、水庫', '全球暖化引起海平面上升',  4),
(1807,  '中高級',  '下列有關「酸雨」的敘述，何者正確？',  '酸雨會造成水質優養化', '酸雨中帶有硫酸及硝酸成分', '雨水的酸鹼值低於7即為酸雨',  '', 0),
(1808,  '中級', '地球平均氣溫愈來愈高，一般認為的主因為下列何者？', '火山活動增加', '人為二氧化碳的排放量增加', '太陽輻射', '空氣中帶有硫酸及硝酸成分', 2),
(1809,  '中高級',  '對臺灣地區全球暖化現象持續發生造成生物影響的推測，下列哪個選項較合理？',  '「五月雪」的油桐樹延後開花',  '對高溫敏感的鹿角珊瑚益發繁盛', '喜好冷水域之櫻花鉤吻鮭的數量增加', '紫斑蝶由北往南越冬遷徙的時間延後', 4),
(1810,  '中高級',  '下列哪個選項「不是」大氣中二氧化碳逐年增加之原因？',  '海域的污染導致珊瑚大量死亡',  '森林遭大量砍伐',  '化石燃料的大量燃燒',  '臭氧層的破壞', 4),
(1811,  '中高級',  '2010年某報紙刊登北極熊捕食小北極熊的畫面，此現象與下列何種情形「無關」？', '人類大量砍伐熱帶雨林', '汽、機車數量快速增加，使用燃料增多',  '空氣中硫化物和氮化物增多', '火力發電廠排放的廢氣', 3),
(1812,  '中高級',  '有關酸雨形成的原因及嚴重時可能造成的影響，下列哪個選項是正確的？', '汽車排放的氣體或工廠排放的廢氣增加；湖中魚類增加', '汽車排放的氣體或工廠排放的廢氣增加；湖中魚類死亡', '因氟氯碳化物增加；湖中魚類增加',  '因氟氯碳化物增加；湖中魚類死亡',  2),
(1813,  '中高級',  '酸雨的污染源（二氧化硫和氮氧化物）排放最多的地方在英格蘭、阿帕拉契山西麓和華北地區，但酸雨最嚴重的地方卻在北歐地區、美國東北部和四川盆地、雲貴高原。造成此種差異最主要原因為何？', '盛行風向', '地勢高低', '日照時數', '晝夜溫差', 1),
(1814,  '中高級',  '用能源作物的糖質、澱粉或纖維素轉製成生質酒精時，必須要用到以下哪一種物質？',  '大腸桿菌', '藍綠藻',  '酵母菌',  '病毒', 3),
(1815,  '中高級',  '下列哪個選項「不屬於」再生能源？', '太陽能',  '石油', '風力', '生質能源', 2),
(1816,  '中高級',  '下列哪個選項屬於可再生的資源？',  '太陽能',  '煤',  '天然氣',  '礦物', 1),
(1817,  '中高級',  '有關生質能源和化石燃料的敘述，下列哪個選項正確？', '生質能源較化石燃料易被分解，污染較少', '全面使用生質能源的好處多於壞處',  '生質能源和化石燃料皆屬於可再生資源',  '燃燒生質能源仍會產生二氧化碳，無助於二氧化碳所造成的溫室效應', 1),
(1818,  '中高級',  '「可再生能」是指由各種可持續補充的自然資源(包括日光、風、雨、潮汐、地熱等)中取得的能量，它大約佔了全球總耗用能量的五分之一。下列與可再生能源有關的敘述，何者錯誤？', '太陽輻射的能量是由其內部的核能轉換而來',  '可再生能源如：日光，具有不會提高', '排放量的優點', '太陽能電池是一種直流電源，可將太陽光能直接轉換為電能', 0),
(1819,  '中高級',  '有關能源的敘述，下列哪個選項「錯誤」？',  '煤、石油和天然氣都屬於化石燃料',  '太陽能電池是利用光能產生電流，理論上不消耗物質',  '核能是指核分裂或核融合時所產生的能量，並遵守質量不滅定律', '潮汐發電、波浪發電、洋流發電、海洋溫差發電等均屬於海洋能源',  3),
(1820,  '中高級',  '抽蓄水力發電，其能量轉換主要的過程為下列何者？',  '電能→水的位能→水的動能→電能',  '電能→水的動能→水的位能→電能',  '水的動能→化學能→水的位能→電能', '電能→化學能→水的動能→電能', 1),
(1821,  '中高級',  '下列何者是在臺灣已達商業規模之再生能源？', '核能發電', '潮汐發電', '風力發電', '海流發電', 3),
(1822,  '中高級',  '臺灣已經作為商業使用的再生能源有哪些？(A)核能發電；(B)風力發電；(C)潮汐發電；(D)海流發電；(E)水力發電。',  'AB', 'BC', 'BE', 'DE', 3),
(1823,  '中高級',  '有關1992年各國簽訂生物多樣性公約的目標，以下何者「錯誤」？',  '禁止利用生物資源', '保育生物多樣性',  '永續使用多樣性物種',  '公平合理分享遺傳多樣性所產生的利益',  1),
(1824,  '高級', '有關臺灣四個節氣，春分、夏至、秋分、冬至的敘述，下列哪個選項正確？',  '春分、秋分當天正午時，陽光直射赤道',  '夏至當天正午時，陽光直射南回歸線', '冬至當天正午時，陽光直射北回歸線', '此四個節氣當天，其晝夜皆等長', 1),
(1825,  '中高級',  '下列哪一種現象是同時與太陽、月亮和地球的相對位置有關？',  '一年四季的變遷',  '晝夜的交替情形',  '潮汐的變化',  '中午時刻的太陽仰角變化',  3),
(1826,  '中高級',  '歐洲酸雨的污染源排放最多的地方在英格蘭，但酸雨最嚴重的地方卻在北歐地區。造成此種現象最重要的因素是下列哪個選項？', '晝夜溫差過大', '風向轉變', '地勢起伏', '日照時間', 2),
(1827,  '中高級',  '下列有關『臭氧』的敘述，何者正確？',  '臭氧濃度在地面最高',  '臭氧可以吸收紫外線',  '臭氧屬於大氣中的固定成分', '近年來，臭氧層的臭氧濃度因人類的活動而日漸增大',  2),
(1828,  '中高級',  '工廠的煙囪上加裝吸除二氧化硫的裝置，可防治下列何種環境問題？', '酸雨', '溫室效應', '臭氧層稀薄化', '熱島效應', 1),
(1829,  '中高級',  '生物可藉光合作用將太陽能轉變為化學能，供細胞利用。有關光合作用，下列哪個敘述是正確的？',  '植物細胞進行光合作用時，固定二氧化碳生成醣分子的反應是在葉綠囊上進行', '能行光合作用的植物細胞都含有葉綠體',  '植物細胞主要利用綠光來進行光合作用',  '植物細胞進行光合作用時，將水分解產生氧分子的反應是在葉綠體的基質中進行',  2),
(1830,  '中高級',  '光合作用的反應步驟雖然繁雜，但其反應可歸納為下列哪個選項？',  '化學能轉為化學能的過程',  '光能轉為熱能的反應',  '熱能轉為化學能的反應', '光能轉為化學能的反應', 4),
(1831,  '中高級',  '大量含氮、磷化合物的廢水，會造成河流湖泊的水質優養化，進而引起水域中魚、蝦、貝類的大量死亡。優養化是指何種生物的營養過多？',  '水中魚類', '浮游動物', '水中細菌', '藻類', 4),
(1832,  '中高級',  '有關水質優養化的說明，下列哪個選項是「錯誤」的？', '可能為畜養家畜的排泄物，排放到河流所造成', '水質中含大量的含氮化合物，會促使藻類大量繁殖', '水中細菌、微生物的食物充足，可增加生物多樣性', '會使得水中溶氧含量減少，影響生物生態', 3),
(1833,  '中高級',  '「藻華」是藻類過度繁殖所致，藻類可以行光合作用產生氧，為何「藻華」卻經常造成水域中魚類的大量死亡？',  '藻華本身就是有毒的藻類',  '藻華覆蓋水面，造成空氣中的氧無法進入水中', '藻華的大量殘骸被微生物分解，消耗大量水中溶解的氧', '藻華中含大量的藍綠菌，藍綠菌是原核生物，沒有葉綠體可以進行光合作用',  3),
(1834,  '中高級',  '大量豬隻排泄物排入湖水中很容易引起「藻華」，原因為何？',  '豬隻排泄物經細菌分解後產生甲烷',  '豬隻排泄物經細菌分解後產生硝酸鹽', '豬隻排泄物中含有重金屬',  '豬隻排泄物經細菌分解後產生丙酮',  2),
(1835,  '中高級',  '優養化現象常會造成水中魚類和其它動物的大量死亡，臺灣水質優養化的主要原因為何？',  '工業排放含硫廢水', '家庭排放含磷和含氮污水',  '核電廠排放冷卻水造成水溫升高', '中油公司長期漏油滲入水中', 2),
(1836,  '中高級',  '有關水庫優養化的敘述，下列哪個選項是正確的？', '由於溪流攜帶大量泥砂進入水庫，使得水中的沉積物和營養不斷增加的過程',  '水庫可能因迅速的天然優養化過程，造成水體的溶氧量下降而使水中生物無法存活', '人類活動影響下，氮、磷大量進入水體，導致浮游藻類大量繁殖', '水體富含有機養分、水質優養化，有些藻類大量繁殖，增加生物質量', 3),
(1837,  '中高級',  '近年來高雄二仁溪發現的「綠牡蠣」，污染的來源為何？',  '化學工廠排出含鎘重金屬的廢水', '處理電纜電線後含銅重金屬的廢水流向溪中',  '工業污染含汞的重金屬廢水', '焚燒電纜後含戴奧辛的廢水流向溪水中',  2),
(1838,  '中高級',  '臺灣沿海常發生「綠牡蠣」事件，牡蠣體內累積有高量的重金屬，推測造成其水質污染的來源為何？', '家庭廢水', '養殖廢水', '農田廢水', '工業廢水', 4),
(1839,  '中高級',  '家禽、家畜的排泄物，排入水中經微生物作用而形成硝酸鹽，此一現象會讓何種生物大量繁殖而造成水中缺氧？',  '藻類', '魚類', '蝦類', '浮游生物', 1),
(1840,  '中高級',  '水庫中發生水質優養化現象是下列哪種含量太多所引起？',  '鉀和二氧化碳', '氮和磷',  '鈉和鈣',  '氧與硫酸鹽',  2),
(1841,  '中高級',  '在淡水河、大甲溪和濁水溪等大河流源頭的水域，其共同具有的生態特色為何？',  '溶氧高',  '水質偏酸', '生產者多', '光合作用旺盛', 1),
(1842,  '中高級',  '有關湖泊優養化的敘述，下列哪個選項是「錯誤」的？', '氮的含量增加', '磷的含量增加', '藍綠菌的含量增加', '矽藻的含量增加',  4),
(1843,  '中高級',  '有關人造雨的敘述，下列哪個選項「錯誤」？', '發生在高空中有過飽和水蒸氣存在時', '在高空中散布乾冰的目的是在降低溫度',  '以碘化銀作為晶種，使過飽和水蒸氣凝結成水', '人造雨是利用再結晶的方法，將高空中的水和冰分離出來',  4),
(1844,  '中高級',  '下列何項生態浩劫，「不會」因為水壩或攔砂壩的完工啟用而產生？', '下游土地的無機鹽及有機養分減少，影響植物生長', '流速減少，造成泥沙淤積及污染物聚積',  '下游水量減少，嚴重影響灌溉用水',  '魚種及漁產減少',  3),
(1845,  '高級', '淡水湖的湖水面為何亦可稱為「暫時侵蝕基準面」？',  '河流高於湖水面的部分侵蝕作用強烈', '河流低於湖水面的部分搬運作用強烈', '河流高於湖水面的部分成岩作用強烈', '河流高於湖水面的部分沉積作用強烈', 1),
(1846,  '中高級',  '下列哪一區域的海洋生物種類最多？', '近海岩岸區',  '近海沙岸區',  '遠洋透光區',  '遠洋無光區',  1),
(1847,  '中高級',  '臺灣東部地區山高坡陡且河流短促，下列何種景觀與此地形特色較「無關」？', '出海口多泥灘沙洲', '河水流速快',  '河上的岩屑尖銳多稜角', '河口佈滿大小不一的礫石',  1),
(1848,  '中高級',  '臺灣的沙丘景觀通常於何處形成？',  '高山地區', '海岸地區', '湖泊沿岸', '內陸地區', 2),
(1849,  '中高級',  '新聞報導：「高雄西子灣原本是美麗的海灘，但由於人工築堤以及大量使用消波塊，影響了原本的海流，而使得海灘逐漸縮小。」由這一段報導，可推知下列哪個選項是「錯誤」的敘述？', '該處海岸線的侵蝕現象大於沉積現象', '海流原本會帶來泥沙，沉積在西子灣', '西子灣的海岸線正向內陸退縮',  '西子灣海岸線平衡被改變了，將再也無法達到平衡', 4),
(1850,  '中高級',  '臺灣年雨量超過2,500mm，卻常有缺水、限水的問題，主要原因是下列何者？',  '民生用水量過多',  '河短湍急，保水力差，雨水迅速入海', '雨量平均分布各個月份而變得不足',  '雨水流入地下，形成地下水無法使用', 2),
(1851,  '中高級',  '在污水處理系統完成後，嚴格執行污水排放制度，並向河水輸送某種氣體，使水質得到顯著的改善，試問輸入河川的是何種氣體？',  '二氧化碳', '一氧化碳', '氧氣', '氯氣', 3),
(1852,  '中高級',  '某城市位在河流的下游，長久以來居民都須忍受惡劣的水質。但在將家庭廚廁產生的污水由原先直接排放到河川，改為經由下水道，先通往污水處理場，處理後再排放，結果河川逐漸不再散發惡臭，河水中水生生物的種類也增加了。下列哪一選項是此河流環境改善的主要原因？', '注入河流的家庭清潔劑大量增加', '注入河流的營養鹽的含量減少',  '家庭污水的排放量減少', '注入河流中的水量減少', 2),
(1853,  '中高級',  '臺灣雖然每年的降雨量豐沛，但是因為乾、枯水期非常明顯，所以有缺水之慮。臺灣居民能直接使用的淡水資源，主要是來自下列何者？(A)冰山；(B)海水；(C)地下水；(D)河水；(E)大氣中的水氣', 'AB', 'BC', 'BE', 'CD', 4),
(1854,  '中高級',  '到墾丁礁岸潮間帶觀察海濱生物時，「不易」見到下列哪些生物？',  '珊瑚藻、石蓴', '海蟑螂、海參', '石鱉、藤壺',  '沙蠶、西施舌', 4),
(1855,  '中高級',  '臺灣4種潮間帶，哪種海岸的生物量「最低」？',  '泥岸', '沙岸', '岩岸', '礁岸', 2),
(1856,  '中高級',  '下列哪個選項「不是」聖嬰現象發生時所造成的影響？', '南美洲西側沿海的漁獲量銳減',  '中美洲經常豪雨成災',  '南極上空臭氧洞擴大',  '西太平洋的雨量東移',  3),
(1857,  '中高級',  '以下何者「最不適宜」以焚化方式處理？', '樹枝、樹葉',  '生活垃圾', '電路板、廢輪胎',  '木材、稻草',  3),
(1858,  '中高級',  '下列哪一個選項的廢棄物，較適宜以焚化爐焚燒處理？', '鐵鋁罐、玻璃', '', '蔬果殘渣、廚餘',  '', 0),
(1859,  '中高級',  '下列何種成分屬於生質能源？',  '沼氣', '氫氣', '氨氣', '石油氣',  1),
(1860,  '中高級',  '下列哪種物質「不能」產製生質能源？',  '有機污泥', '林業廢棄木屑', '廢五金',  '農業廢棄物',  3),
(1861,  '中高級',  '下列哪個選項「不是」生質能源的來源？', '黃豆莢',  '下水道污泥',  '埋藏於地底的動、植物屍體', '造紙黑液', 3),
(1862,  '中高級',  '下列哪個選項為生質能源的原料？',  '液化瓦斯', '甘蔗', '煤',  '石油', 2),
(1863,  '中高級',  '生質柴油主要是由哪種化合物轉變而成的？',  '蛋白質',  '澱粉', '礦物質',  '三酸甘油酯',  4),
(1864,  '中高級',  '生質能源近來被視為綠色能源，主要原因應該是下列哪個選項？', '燃燒的過程沒有碳原子的參與',  '用來製造生質酒精的原料都是綠色的', '用來製造生質酒精的植物皆能行光合作用', '生質酒精從製造到燃燒，不影響碳循環平衡',  4),
(1865,  '中高級',  '為充分利用生質能源，巴西以其大量生產的甘蔗為原料，生產下列何種物質作為汽車的燃料？',  '乙醇', '丙烷', '丁烷', '乙烯', 1),
(1866,  '中高級',  '將葵花油製成生質柴油，屬於下列何種能源類型？', '非再生能源',  '回收能源', '生質能源', '太陽能',  3),
(1867,  '中高級',  '關於生質能源的敘述，下列哪個選項是「錯誤」的？',  '屬於無碳能源', '生質能源材料取得容易', '生質酒精即為其中之一', '蘊藏在植物或其它生物體內的能源',  1),
(1868,  '中高級',  '下列哪個選項與再生能源相關性「較低」？',  '廢紙渣產製合成燃氣，進行燃氣發電', '垃圾掩埋場與下水道污泥處理廠所產生的沼氣', '火力發電廠利用煤燃燒產生電能', '利用細菌分解有機垃圾產生的甲烷',  3),
(1869,  '中高級',  '下列哪個選項「不是」可作燃料的生質能源？', '酒精', '煤',  '木材', '牛隻排泄物',  2),
(1870,  '中高級',  '有關生質能源的敘述，下列哪個選項「錯誤」？',  '已應用於垃圾焚化發電', '已應用於沼氣發電', '生質能不包含牲畜糞便、農作物殘渣等使用',  '非再生能源',  4),
(1871,  '中高級',  '有關生質能源的敘述，下列哪個選項正確？',  '生質能源泛指由生物產生的有機物質，包括化石燃料',  '生質作物能轉換成可利用的能源，如生質柴油', '垃圾掩埋場的沼氣不屬於這種能源',  '工業有機廢棄物無法當作生質能源',  2),
(1872,  '中高級',  '使用「生質能源」將有可「減緩」下列哪些環境問題？(A)水質優養化；(B)土石流；(C)溫室效應；(D)地層下陷；(E)酸雨。', 'AC', 'BC', 'CD', 'CE', 4),
(1873,  '中高級',  '由廢食用油、大豆、向日葵及油菜等能源作物提煉的生質柴油屬於生質能源的一種，下列哪個選項為其優點？', '不會排放二氧化碳', '生物可分解',  '低毒性',  '提高油耗', 2),
(1874,  '中高級',  '有關人類發展生質能源的原因，下列哪個敘述「錯誤」？',  '化石燃料即將用盡', '避免地球暖化加劇', '玉米產能過剩', '減少二氧化碳排放', 3),
(1875,  '中高級',  '有關利用植物做為原料製成生質酒精的敘述，下列哪個選項「錯誤」？',  '目前人類已可從甘蔗、玉米中的蔗糖和澱粉，成功提煉酒精', '利用玉米稈、稻稈等農業廢棄物中的半纖維素、纖維素均可製成酒精', '甘蔗、玉米的蔗糖和澱粉與水稻莖稈中的纖維素均存在於細胞壁中',  '蔗糖、木糖、葡萄糖的分子量均較纖維素的分子量為小', 3),
(1876,  '中高級',  '使用生質能源可以降低二氧化碳的排放量，其主要原因為何？',  '使用生質能源不會排放二氧化碳', '使用生質能源所排放的二氧化碳遠少於一般的化石燃料', '使用生質能源排放的二氧化碳是現代植物光合作用所固定的二氧化碳', '生質能源的熱效應高於一般的化石燃料，因此使用量少，進而達到節能減碳的目標', 3),
(1877,  '中高級',  '若未來生質能源取代化石燃料，可能產生的問題中，下列哪個選項「錯誤」？', '溫室效應現象消失', '森林面積減少', '生態失衡', '糧食作物價格上漲', 1),
(1878,  '中高級',  '高雄都會公園原為垃圾掩埋場，經過改建後設置沼氣發電。是屬於下列哪一種能源之應用？', '太陽能',  '化石能源', '生質能源', '核能', 3),
(1879,  '中高級',  '臺灣農民在冬季農田休耕期間常種植油菜，並在其結果前，將之剷入土壤中；此作法主要用意為何？', '充分利用土地，作為蔬菜食用',  '固定氮肥，增進土壤肥力',  '增加生物種類，以維持生態平衡', '固定太陽能，以促進能量流動',  2),
(1880,  '中高級',  '一般農民「不使用」海水灌溉作物，其主要原因為何？', '海水中不含植物生長所需的元素', '海水滲透壓太高，植物不能從中吸取水分', '海水所含的重金屬濃度過高，對植物有毒害作用',  '海水的含氧量太低，植物根部不能進行呼吸作用',  2),
(1881,  '中高級',  '水俁病、痛痛病、綠牡蠣、分別為何種重金屬所引起？', '鉻、銅、汞',  '汞、鎘、鉛',  '汞、鎘、銅',  '鎘、鉛、銅',  3),
(1882,  '中高級',  '從「螳螂捕蟬，黃雀在後」的食物鏈觀點來看，下列哪一種生物體內DDT含量最多？', '螳螂', '蟬',  '黃雀', '一樣多',  3),
(1883,  '高級', '針對使用殺蟲劑所造成的影響，下列哪項描述是正確的？',  '殺蟲劑有選擇性，只殺害蟲，不殺益蟲',  '使用殺蟲劑不會誘使昆蟲產生抗藥性', '使用殺蟲劑會使具抗藥性的昆蟲通過天擇的考驗生存下來',  '生態系自有調節能力，所以使用殺蟲劑並不會影響生態系',  3),
(1884,  '中高級',  '「環境荷爾蒙」是指哪類的環境污染物？', '環境中的動物荷爾蒙',  '環境中的人工合成荷爾蒙',  '植物分泌出會傷害動物的荷爾蒙', '進入生物體內會干擾其內分泌功能的環境污染物',  4),
(1885,  '中高級',  '生物可以去除重金屬污染，下列有關其原理的敘述何者「錯誤」？',  '微生物可將重金屬分解成無害的物質', '利用特定植物可將土壤中的重金屬吸收至植物體內', '細菌可將重金屬變成不可利用的形式累積在細胞中', '可利用細菌吸附重金屬', 1),
(1886,  '中高級',  '在一個被DDT污染的沼澤生態系中，哪種生物體內的DDT濃度最高？', '浮游生物', '河豚', '海鷗', '蚌',  3),
(1887,  '中高級',  '有關DDT的敘述，下列哪個選項是正確的？', 'DDT為水溶性物質',  'DDT在生物體內可溶入蛋白質而累積在體內', 'DDT在生物體內不易被酵素分解',  '次級消費者體內DDT含量通常低於初級消費者',  3),
(1888,  '高級', '號稱「世紀之毒」的空氣污染物為何？',  '氟氯碳化物',  '二氧化碳', '戴奧辛',  '一氧化氮', 3),
(1889,  '中高級',  '下列數種害蟲防治法中，哪個選項對環境影響最大？',  '化學殺蟲劑',  '乾燥法',  '生物防治法',  '利用性費洛蒙吸引害蟲', 1),
(1890,  '中高級',  '長期使用同一種化學農藥，會造成下列何種現象？', '化學農藥被農作物所分解',  '具有抗藥性的害蟲大量繁殖', '農藥使用量會越來越少', '害蟲不會產生抗藥性',  2),
(1891,  '中高級',  '若池水受殺蟲劑污染，則哪一個階層的生物體內所累積的殺蟲劑濃度最高？',  '浮游生物', '草食性小動物', '食小魚的魚類', '細菌和黴菌',  3),
(1892,  '中高級',  '埃及斑蚊是傳染登革熱病毒的媒介之一。有一地區在密集噴灑殺蟲劑後，此蚊族群量減少了99%，但是一年後，該族群又恢復到原來的數量，此時再度噴灑相同量的殺蟲劑後，僅殺死了40%的斑蚊。下列敘述何者正確？', '殺蟲劑造成斑蚊基因突變，產生抗藥性基因',  '斑蚊身體累積的殺蟲劑增加了自身的抗藥性',  '原來的斑蚊族群中，少數個體有抗藥的基因',  '第一年的斑蚊族群沒有基因的變異',  3),
(1893,  '中高級',  '許多國家已禁用DDT作為殺蟲劑，其原因為何？', '蚊蟲均已發展出抗藥基因',  '無法被生物分解',  '成本過於昂貴', '毒性太強，易使人類中毒',  2),
(1894,  '高級', '為解決「作物病蟲害」，下列哪個防治法的效果最快，但也可能產生副作用？', '捕殺法',  '性費洛蒙', '誘殺法',  '農藥', 4),
(1895,  '中高級',  '有關農藥安全使用應注意事項的說明，下列何者「錯誤」？', '稀釋農藥時，避免接觸眼睛、皮膚和衣服', '噴藥時要注意風向，必須逆風倒退',  '噴藥時可以吸菸，但不能吃東西', '不可隨意丟棄農藥廢棄物，要妥善處理',  3),
(1896,  '中高級',  '下列有關抗生素以及抗藥性之敘述，何者是「錯誤」的？',  '有些種類的黴菌可以產生抗生素', '繁殖速率高之微生物較易產生抗藥性', '抗藥性之生成與致病微生物之基因突變有關',  '抗藥性之生成與使用抗生素之病患基因突變有關',  4),
(1897,  '高級', '農人連續幾年在田裡施灑固定量的殺蟲劑，但後來卻失效了，造成失效的原因為何？',  '農藥公司的品質管制不良，使生產的殺蟲劑品質不穩定', '害蟲衍生出抗藥性，使得稻田中具抗藥性的害蟲比例逐年增高',  '灑下殺蟲劑後，如經雨水稀釋，以致藥效降低', '種植的水稻發生突變，吸引大量其它不同種類的害蟲',  2),
(1898,  '中高級',  '對於DDT等殺蟲劑的敘述，下列哪個選項是「錯誤」的？', '各級生物依營養階層，DDT含量會逐漸增加', 'DDT會導致動物生殖能力及生物多樣性降低', 'DDT經由食物性關係，在各級消費者體中逐漸稀釋',  'DDT會干擾鳥類蛋殼的形成，進而降低孵化率',  3),
(1899,  '中高級',  '如果要輔導農友延長農藥的殺蟲年期，對於「猛克」的使用建議，下列何者最為有效？', '逐年降低「猛克」的使用劑量',  '逐年倍增「猛克」的使用劑量',  '以「一年高、一年低」的輪替模式變動每年使用劑量',  '另外挑選他種殺蟲劑與「猛克」輪換使用', 4),
(1900,  '中高級',  '颱風來襲造成水患後，待清除的垃圾，往往堆積如山，衛生單位因此呼籲民眾注意身體及飲食衛生，以防皮膚及腸胃道感染，也應該儘快恢復環境清潔，以防病媒蚊引起登革熱等傳染病。下列敘述何者正確？',  '皮膚或腸胃道感染後，最佳的治療方法是立刻服用抗生素',  '水患使下水道的污水溢出地面，這些污水中的微生物都是致病菌', '引起腸胃道感染與引起登革熱的微生物皆可行分裂生殖', '有些細菌以煮沸方式處理仍然無法去除，主要由於這些細菌會產生內孢子', 4),
(1901,  '中高級',  '核能發電廠附近海域的珊瑚曾經因為海水污染而呈現白化現象，其主要的污染源為何？', '重金屬',  '輻射線',  '熱',  '環境荷爾蒙',  3),
(1902,  '中高級',  '有關污染物的敘述，下列哪個選項是正確的？', '雞鴨的排泄物含有硝酸鹽，可提供水中藻類使用，不能算是污染物',  '地球的溫室效應是由空氣中的硫化物吸收太陽熱能所造成',  '環境荷爾蒙包含DDT、多氯聯苯、多環類的芳香化合物',  'DDT有世紀之毒的稱呼',  3),
(1903,  '中高級',  '關於人類對生態影響的敘述，下列哪個選項是「錯誤」的？', '都市的溫度高於外圍郊區的現象稱為「熱島效應」', '溫室氣體之一的二氧化碳只會吸收地面輻射的紫外線',  '氟氯碳化物是導致臭氧變薄的主要因素',  '氮鹽與磷鹽是造成優養化的主要因素', 2),
(1904,  '中高級',  '下列哪個選項是由重金屬污染所引起的？', '比利時的奶製品受到多氯聯苯污染',  '長期吸入含鉛廢棄的學童，智力發育明顯受影響',  '德國酸雨嚴重，森林受到嚴重傷害',  '臺灣平均年均溫上升攝氏0.17度', 2),
(1905,  '中高級',  '下列哪個選項是重金屬污染所造成的？',  '溫室效應', '臭氧層破壞',  '優養化',  '綠牡蠣',  4),
(1906,  '中高級',  '對於人類歷史上幾次污染事件的敘述，哪個選項是「錯誤」的？', '日本水俁病是由於汞污染，造成受害者腦部受損',  '牡蠣為容易累積重金屬的生物，而綠牡蠣正是銅的累積造成的',  '桃園縣觀音鄉曾發生的痛痛病與砷污染有關',  '臺南市中石化安順廠附近居民多人罹癌，懷疑是戴奧辛污染當地水源所致', 3),
(1907,  '中高級',  '下列何種現象和生長發育「無關」？', '蝌蚪變成蛙',  '紅檜樹苗成為神木', '鹽巴形成結晶析出', '國中男孩聲音漸低沉',  3),
(1908,  '中高級',  '植物的散佈與其種子的主動或被動遷移能力有關。下列何種植物最有機會從大陸傳播到遠離陸地的海島？', '蘇鐵', '胡桃', '蒲公英',  '酢漿草',  3),
(1909,  '中高級',  '下列的生物組合中，哪個選項最可能是一個「族群」？', '一個蜂窩內的蜜蜂', '一個水庫中的小魚', '一個山坡上的蕨類', '一個山谷內的竹子', 1),
(1910,  '中高級',  '由根部吸收的水分，最主要是受到下列哪種作用的影響而能送達至葉部？', '代謝作用', '光合作用', '呼吸作用', '蒸散作用', 4),
(1911,  '中高級',  '有關我國草原的描述，下列哪個選項正確？',  '因分布於高山地區，又稱為岩原', '以高山芒草為代表性植物',  '群集組成屬於初級消長的早期群集',  '高爾夫球場為此生態系的代表',  2),
(1912,  '中高級',  '若某生態系長時間維持在草原的型態，則下列敘述何者「錯誤」？',  '草原為此生態系之顛峰群落型態', '強勁的風可能是此生態系長時間維持在草原型態的主因', '豐富的雨水可能是此生態系長時間維持在草原型態的主因',  '週期性的野火可能是此生態系長時間維持在草原型態的主因', 3),
(1913,  '中高級',  '菟絲子是一種缺乏葉綠素的開花植物，但可藉由吸附於其他綠色植物以取得養分，故菟絲子在生態系中的角色是下列何者？', '生產者',  '分解者',  '消費者',  '清除者',  3),
(1914,  '中高級',  '臺灣水韭是稀有水生蕨類植物。下列有關臺灣水韭的敘述，何者正確？',  '會開韭菜花',  '不具輸送水分及養分的維管束',  '具有根、莖和葉等器官', '主要以種子來繁衍子代', 3),
(1915,  '中高級',  '撕下新鮮青江菜葉下表皮，在顯微鏡下觀察時，如何區分表皮細胞與保衛細胞？',  '有無細胞核',  '有無葉綠體',  '有無細胞壁',  '有無細胞膜',  2),
(1916,  '中高級',  '「根壓」的形成原因為下列哪個選項？',  '根部在土壤中因泥土的擠壓所造成的壓力', '根部接受由葉部運輸來的蔗糖，使根部細胞壓力變大',  '根部細胞的細胞質濃度比土壤高，導致水的滲透壓差而產生根壓', '根部在土壤中與其他植物的根競爭養分所造成的壓力',  3),
(1917,  '中高級',  '關於生命現象的敘述，下列哪個選項是「錯誤」的？',  '植物不具神經系統，故無法對環境刺激發生反應',  '細菌能感應養分或有毒物質的存在，而產生適當的反應', '單細胞生物和多細胞生物皆有新陳代謝與生長的現象',  '生殖是生命現象中最重要的要素之一', 1),
(1918,  '中高級',  '關於生命現象的敘述，下列哪個選項是正確的？',  '植物的運動現象明顯',  '動物遇緊急危難時分泌腎上腺素是一種感應現象',  '同化代謝及異化代謝不可能相伴發生', '異化代謝是一種需能反應',  2),
(1919,  '中高級',  '關於生長的敘述，下列哪個選項完全正確？',  '', '只是細胞體積的增大才稱為「生長」', '只是細胞數目的增加才稱為「生長」', '在細胞內同化代謝產生的新物質，少於異化代謝中消耗的物質，則稱為此細胞正在「生長」', 0),
(1920,  '中高級',  '關於根部構造的描述，下列哪個選項是正確的？',  '肉眼可觀察到的根毛是多細胞的構造', '內皮細胞，為一層排列緊密的死細胞', '周鞘具細胞分裂能力，由此長出支根', '根的表皮具有角質化可防止水分流失', 3),
(1921,  '中高級',  '關於種子植物根部的敘述，下列哪個選項是正確的？',  '內皮屬於中柱的一部分', '根壓與根部細胞的主動運輸有關', '內皮具分生能力可以產生支根',  '周鞘可控制水分進入中柱',  2),
(1922,  '中高級',  '黴菌、菇類等生物在氮循環中扮演什麼角色？', '將含氮化合物中的氮以氨的形式釋出', '將氮氣固定為氨',  '將氨轉變成植物可吸收的銨鹽',  '進行硝化作用將氨轉變為硝酸鹽', 1),
(1923,  '中高級',  '有關臺灣地景與地質作用的敘述，下列哪個選項是正確的？', '恆春風吹沙-風的搬運與沉積作用',  '嘉南平原-埤塘的蓄水作用', '綠島海蝕洞-海風風化作用', '雪山U型谷-雨水的沖刷作用',  1),
(1924,  '中高級',  '新生代早期才從北美洲演化出來的生物類群，最「不可能」出現在下列哪一個地區？',  '德國', '祕魯', '澳大利亞', '西伯利亞', 3),
(1925,  '中高級',  '下列哪一項是善加利用自然資源最可行的做法？',  '將垃圾分類回收利用',  '廣闢山坡地為茶園，以增加農產收成', '於河川中，普設攔砂壩，以避免砂土流失', '進行漁塭養殖時，應儘量使用地下水', 1),
(1926,  '中高級',  '捕蟲植物既然可行光合作用，為何還需要捕蟲以維持生命？', '生長環境缺乏氮元素',  '加速生長', '因為昆蟲會傷害植物體', '捕蟲只是偶然動作，無其它意義', 1),
(1927,  '中高級',  '下列哪個選項「不屬於」生物防治法？',  '以人工合成的性費洛蒙誘引雄蟲', '利用草蛉(ㄌㄧㄥˊ)捕食蚜蟲', '利用蘇力菌防治紋白蝶', '利用木黴菌產生抗生素與細胞分解酵素防治作物的萎凋病',  1),
(1928,  '中高級',  '有關作物病蟲害的防治法，下列哪個選項「不屬於」捕殺法？',  '捕蟲網',  '捕蟲燈',  '捕蠅紙',  '彩色黏板', 2),
(1929,  '中高級',  '報載七星山夢幻湖因為水文狀況改變，導致陸生植被侵入，使原生活在湖中的臺灣水韭數量越來越少。下列哪一種現象與前述現象最相近？',  '溪頭森林遊樂區中，松材線蟲對柳杉林的危害', '演化的過程中，魚類先演化出兩生類再演化出爬蟲類',  '某地先有地衣，一段時間後長出地錢，最後形成草原',  '在同一生態系中，DDT的濃度在較高級的消費者身上較高', 3),
(1930,  '中高級',  '臺灣地區常見的魚類中，下列何者對環境鹽度變化的忍受程度最高？', '河口的彈塗魚', '海中洄游的烏魚',  '礁岩中的石斑魚',  '溪流中的高身?魚', 1),
(1931,  '中高級',  '臺灣在面臨全球氣候暖化時，下列何種生物所受的負面影響最大？',  '水筆仔',  '文殊蘭',  '櫻花鉤吻鮭',  '錦鯉', 3),
(1932,  '中高級',  '利用網室種植蔬果，可以降低農藥的使用，這種病蟲害防治屬於下列哪類選項？',  '捕殺法',  '遮斷法',  '誘殺法',  '生物防治法',  2),
(1933,  '中高級',  '番薯田與甘蔗田裡常有許多田鼠危害作物，農民常用捕鼠籠捕捉田鼠，這種防治法屬於下列哪類？',  '捕殺法',  '遮斷法',  '誘殺法',  '生物防治法',  3),
(1934,  '中高級',  '下列有關臺灣森林生態系的敘述，何者正確？', '因地處亞熱帶，故低海拔森林皆為落葉闊葉林', '闊葉林中動、植物種類繁多，但物種多樣性很小',  '3,000公尺以上的高海拔森林為針闊葉混生林', '1,100~2,000公尺的中、低海拔森林主要是樟科與殼斗科為主的闊葉林', 4),
(1935,  '中高級',  '冷杉、紅檜和樟樹的海拔分布範圍由高至低的排列為何？',  '冷杉、紅檜、樟樹', '紅檜、冷杉、樟樹', '冷杉、樟樹、紅檜', '樟樹、紅檜、冷杉', 1),
(1936,  '中高級',  '阿里山神木的高度超過十層樓，其頂層葉片獲取水分的最主要途徑為何？', '大氣中的水氣→氣孔→葉片內部', '大氣中的水氣→葉片角質層→葉片內部',  '土壤水→根部表皮細胞→根部皮層細胞→根、莖、葉韌皮部→葉片內部',  '土壤水→根部表皮細胞→根部皮層細胞→根、莖、葉木質部→葉片內部',  4),
(1937,  '中高級',  '阿健為了交生物課作業，因此他到住家附近原始未受破壞的低海拔森林做生物的觀察，以下哪個選項較有可能為他的觀察結果？', '優勢樹種以針葉樹為主', '鳥類只有可能在樹冠層發現', '森林內的溫度通常較森林外低',  '樹林中菌物非常罕見',  3),
(1938,  '中高級',  '造林時，在林木的生長早期會刻意砍除其中一部分的主要目的為何？', '避免林下陽光不足，影響伴生植物生長',  '砍除生病林木，避免疾病蔓延，影響生長', '避免植株競爭土壤養分，影響生長',  '避免林木過多，管理照顧不易',  3),
(1939,  '高級', '臺灣神木多為紅檜，該樹種屬於何種生態系？', '常綠闊葉林生態系', '落葉闊葉林生態系', '針葉林生態系', '岩原生態系',  3),
(1940,  '高級', '有關棲地破碎化對生物的影響何者正確？', '增加物種的族群數目，提高生物多樣性',  '使族群變小，降低遺傳多樣性',  '容易隨機交配，有利於演化', '造成地理屏障，有利於新物種產生，對動物界長程而言是有利的', 2),
(1941,  '中高級',  '下列何種生物已在臺灣絕跡？',  '梅花鹿',  '長鬃山羊', '穿山甲',  '臺灣黑熊', 1),
(1942,  '中高級',  '龜山島是臺灣近海的離島，如果發生火山爆發使島上生物全部消失，但陸地仍存在，則下列哪一物種最可能首先棲息在龜山島？', '麻雀', '蜜蜂', '蕨類植物', '鬼針草(咸豐草)', 3),
(1943,  '中高級',  '入侵性紅火蟻入侵臺灣後於短時間內難以消滅的主要原因為何？', '與本土生物形成互利共生',  '臺灣的生態環境與其原產地完全相同', '缺少天敵', '基因突變使其能夠快速適應本土環境', 3),
(1944,  '中高級',  '下列何者「不是」外來種入侵所造成的危害？', '改變當地的生態平衡',  '提高生物多樣性',  '造成人們經濟的損失',  '影響人們健康', 2),
(1945,  '中高級',  '下列何者「不是」外來種生物成為優勢種的可能原因？', '是所有本土生物的天敵', '沒有天敵', '適應性佳', '繁殖力強', 1),
(1946,  '中高級',  '是否應該引進外來生物？其原因為何？',  '應該。因為一地區生物種類愈多，生態將會更穩定', '應該。因為有需要才引進，非漫無目的',  '不應該。因為可能會破壞原來的生態平衡', '不應該。因為生物不太可能生存於其它地區',  3),
(1947,  '中高級',  '下列何者是我們面對外來種造成生態危害應有的態度？', '應該禁止任何外來種生物(含生物防治的生物)的引進', '得過且過，睜一隻眼閉一隻眼',  '為了糧食作物的增產和多樣化，育種、藥用等目的，仍可適度開放引進外來種', '外來種皆會造成生態環境的巨變，應徹底剷除', 3),
(1948,  '中高級',  '對於外來種，我們應有的態度是什麼？',  '斬草除根，以免危害大自然', '進行管制，減少擴散的速度', '多面照料，使其增加臺灣物種多樣性', '不予理會，自生自滅',  2),
(1949,  '中高級',  '以下何者「不是」臺灣的外來物種？', '火蟻', '綠蠵龜',  '福壽螺',  '吳郭魚',  2),
(1950,  '中高級',  '下列何者為外來種？',  '櫻花鉤吻鮭',  '臺灣黑熊', '藍腹鷴',  '小花蔓澤蘭',  4),
(1951,  '中高級',  '「寵物店飼養的入侵種中國畫眉，因逃逸或放生，與臺灣畫眉發生雜交，若不即時控制，臺灣畫眉恐將滅種。」以上敘述是指入侵種造成的何種影響？', '基因多樣性減少',  '物種多樣性增加',  '生態系多樣性減少', '遺傳多樣性增加',  1),
(1952,  '中高級',  '外來物種紅火蟻入侵臺灣後形成危害的主要原因為何？', '缺少天敵，且不能施用?力化學藥劑，以避免造成二次公害', '與本土物種形成互利共生',  '臺灣之生態環境與其原產地完全相同', '適合居住之環境類型稀少',  1),
(1953,  '中高級',  '外來種引進後若能在野外大量繁殖，以致影響當地原生物種的生存，就稱為入侵種。下列有關入侵種的敘述，何者「錯誤」？',  '可能影響本地生物群集的生態平衡',  '可能與本地種互相雜交而改變本地種的基因組成',  '可能與本地種互相競爭，並排擠本地種的生存', '該物種因生育環境改變，受天擇作用而迅速演化成新的物種', 4),
(1954,  '高級', '針對福壽螺的敘述以下何者「錯誤」？',  '是一種外來種', '應該引進福壽螺的天敵來抑制福壽螺的量', '在臺灣適應良好且大量繁衍', '會傷害農作物幼苗', 2),
(1955,  '中高級',  '關於入侵外來種對本地之影響，以下何者「錯誤」？',  '可能與本地物種雜交，造成物種變異', '危害本地之生態環境',  '傳播疾病', '生物多樣性增加',  4),
(1956,  '中高級',  '下列哪一種生物屬於外來種且因其具有高經濟價值而被引進臺灣？',  '臺東蘇鐵', '黑面琵鷺', '臺灣鯛(吳郭魚)', '紅火蟻',  3),
(1957,  '中高級',  '有關外來種的說明何者正確？',  '外來種一定會變成入侵外來種',  '外來種來到臺灣都能適應得很好，且大量增生', '外來種一定都會造成生態浩劫',  '外來種可能為人類合法所引進',  4),
(1958,  '中高級',  '農業委員會基於何種原因，公告暫停進口美國華盛頓州生產藏有「蘋果蠹蛾」幼蟲的蘋果？', '有蟲洞的蘋果不易保存', '蠹蛾可能會傳染人類疾病',  '蠹蛾會侵襲臺灣種植的蘋果及梨', '有蟲洞的蘋果，消費者的購買意願低', 3),
(1959,  '中高級',  '關於外來種的敘述何者正確？',  '外來種生物都是人為引進的', '引進外來種生物，對臺灣農業有利有弊',  '引進天敵是對付入侵外來種生物的萬靈丹', '為防治吹棉介殼蟲，臺灣最好引進歐洲的鋸針蠅',  2),
(1960,  '中高級',  '鯨魚體表缺乏提供保溫的體毛，但其皮下何種物質特多，可藉以保溫？',  '醣類', '脂質', '蛋白質',  '粒線體',  2),
(1961,  '中高級',  '下列何者「沒有」主根與支根的分別？',  '杜鵑', '蘇鐵', '榕樹', '大王椰子', 4),
(1962,  '中高級',  '木本植物的樹皮「不包含」下列何種構造？',  '韌皮部',  '木質部',  '皮層', '木栓層',  2),
(1963,  '中高級',  '有人說：「邊材就是所謂的春材。」你認為這句話正確嗎？理由為何？',  '對的，因為兩者的細胞顏色皆是較淺色',  '對的，因為兩者皆有運輸水分與無機鹽的功能', '錯的，邊材指的是較外側新生的木質部細胞',  '錯的，邊材比春材細胞更大', 3),
(1964,  '中高級',  '有關木本雙子葉植物莖部樹皮的敘述何者正確？',  '自木栓形成層起以外的部分', '自表皮以外的部分', '自皮層以外的部分', '自韌皮部起以外的部分', 4),
(1965,  '中高級',  '有關臺灣闊葉林生態系的敘述何者「錯誤」？', '分為熱帶雨林、落葉闊葉林和常綠闊葉林', '落葉闊葉林的分層結構多',  '樟科和殼斗科的植物分布於常綠闊葉林區', '春天時，落葉闊葉林底層草本植物生長特別旺盛',  1),
(1966,  '中高級',  '板根、纏勒、幹生花等現象常見於臺灣何種自然生態系中？', '針葉林',  '常綠闊葉林',  '落葉闊葉林',  '熱帶季風林',  4),
(1967,  '中高級',  '關於木質部與韌皮部物質運輸的敘述，下列何者正確？', '木質部運輸水分及無機鹽，只能由下而上', '木質部運輸水分及無機鹽需消耗能量', '韌皮部運送有機養分，只能由上而下', '韌皮部運送有機養分無需消耗能量',  1),
(1968,  '中高級',  '下列哪個「不是」臺灣的國家公園所擁有的生態系？',  '凍原生態系',  '森林生態系',  '河口生態系',  '海洋生態系',  1),
(1969,  '中高級',  '以下關於我國國家公園的敘述何者正確？', '墾丁國家公園是地球第一座國家公園', '金門國家公園是唯一一座設置在臺灣島以外的國家公園', '陽明山國家公園不具海洋生態系', '雪霸國家公園是觀察沙丘生態系的絕佳場地',  3),
(1970,  '中高級',  '我國哪一個行政區內沒有國家公園？', '花蓮縣',  '屏東縣',  '臺南市',  '雲林縣',  4),
(1971,  '中高級',  'DDT造成生物放大的原因為何？',  '因食物塔階層愈高，總生物量愈大，DDT累積量也愈高',  '因高級消費者體內分解DDT的能力較生產者低',  '因DDT在生物體內無法分解，無法排出', '因DDT使受污染生物的總生物量增大',  3),
(1972,  '高級', '下列哪位學者認為「適應性的表徵，直接因生物對於環境的反應而起，且能全部遺傳於子代」？', '拉馬克',  '達爾文',  '魏斯曼',  '華萊士',  1),
(1973,  '高級', '下列哪個敘述符合達爾文的天擇學說？',  '甜玉米被大量種植是因為玉米粒味美好吃', '鯨的附肢像鰭的形狀，此乃因為長期在水中游泳而逐漸成形', '因樺斑蝶色彩鮮豔且具毒性，鳥類多敬而遠之故得以繁衍',  '現今的單蹄馬，為長久在草原奔跑的結果', 3),
(1974,  '高級', '下列哪個論述「不是」達爾文在物種原始一書中闡述的概念？',  '生物有共同祖先',  '生物具有個體差異', '生物演化是天擇的結果', '影響生物演化最主要的因素是大災難', 4),
(1975,  '高級', '下列哪個論述是達爾文天擇說的中心內容？',  '過度繁殖', '生存競爭', '遺傳變異', '環境選擇最適合的表徵', 4),
(1976,  '高級', '下列哪個論述是達爾文和拉馬克在演化觀點上的共同點？',  '生物的演化是連續性的漸變過程', '生物的演化必經由突變和天擇',  '所有的生物均來自相同的原始祖先',  '演化來自遺傳變異，與環境因素無關', 1),
(1977,  '中高級',  '下列哪個選項「不是」一個「族群」？',  '一個蟻窩的螞蟻',  '珊瑚礁上的石蓴',  '池塘裡的浮游藻類', '庭院裡的黃花酢醬草',  3),
(1978,  '中高級',  '下列何者「不是」達爾文天擇說的內容？', '生物的演化為長時間連續的變化', '同一類的生物都是來自於共同的祖先', 'DNA是可以代代相傳的遺傳物質',  '天擇是最重要的演化動力',  3),
(1979,  '中高級',  '下列哪個選項「無法反映」出真正的親緣關係？',  '化石', '形態分類', '同源器官', '生物地理學',  2),
(1980,  '中高級',  '下列哪一個條件是生物形成新種的必要條件？', '地理隔離', '生殖隔離', '突變發生', '遷出至不同環境而適應以後', 2),
(1981,  '高級', '生物的分類階層，依序為界、門、綱、目、科、屬、種。就下列兩兩一組的生物之間所屬相同階層的敘述，下列哪個選項是正確的？', '人與梅花：只在界、門分類階層相同', '綠藻與蕨類：只在界、門、綱、目分類階層相同',  '大腸菌與酵母菌：只在界、門、綱分類階層相同',  '水稻與玉米：只在界、門、綱、目、科分類階層相同',  4),
(1982,  '中高級',  '生物演化最直接的證據是下列哪個選項？', '化石紀錄', '生物的地理分布關係',  '構造、形態的相似度',  '胚胎發生過程的相似程度',  1),
(1983,  '中高級',  '生物學家對生物的演化觀點眾說紛紜，直到哪位科學家提出演化論之後始較為完備與被接受？',  '林奈', '虎克', '達爾文',  '孟德爾',  3),
(1984,  '中高級',  '下列與生態系消長(演替)相關的敘述，何者正確？',  '顛峰群集比消長過程中的過渡群集有更高的生物多樣性', '初級與次級消長從起始到顛峰群集所需的時間相同', '森林生態系是所有生態系消長的最終階段', '先驅物種都是個體較矮小的植物', 1),
(1985,  '中高級',  '地衣是臺灣森林中常見著生於樹幹的生物，其組成物種所屬的生物分界可能為下列何者？',  '動物界與植物界',  '動物界與真菌界',  '植物界與原生生物界',  '原生生物界與真菌界',  4),
(1986,  '中高級',  '在一個生態系中，如何處理才可以提高其生物多樣性？', '棲地破碎化',  '加入外來種',  '增加優良品種的栽植面積',  '提高數量最少的物種之個體數',  4),
(1987,  '中高級',  '同種個體間的差異屬於何種內涵層次的多樣性？',  '棲息地多樣性', '基因多樣性',  '物種多樣性',  '生態系多樣性', 2),
(1988,  '中高級',  '有關天擇的敘述，下列哪個選項「錯誤」？',  '天擇是一種動態的作用過程', '在生物演化過程中，天擇可決定演化的方向',  '天擇通常在人為環境中進行，是生物演化的主要動力',  '天擇作用的過程依時間、環境有所不同',  3),
(1989,  '中高級',  '有關生物多樣性的敘述何者正確？',  '外來種的引進，有助於生物多樣性增加',  '族群愈大的區域，其生物多樣性愈大', '生物多樣性較大的區域，其受病蟲害機會愈大', '生物多樣性愈高的生態系，其穩定性愈高', 4),
(1990,  '高級', '下列有關生物歧異度(多樣性)的敘述何者正確？', '生物多樣性愈高其遭受病蟲害的機會愈大', '物種歧異度不受區域面積、地形、及氣候的影響',  '物種歧異度愈大，其生態系就愈趨穩定',  '物種的族群密度變大時，其歧異度隨之變大',  3),
(1991,  '中高級',  '有關生物演化的敘述，下列哪個選項正確？',  '生物演化就是指族群中親代與子代的等位基因比例發生變化', '天擇是一種靜態的作用過程，依時間、環境而有所不同', '在寒武紀時，地球上最繁盛的生物為藻類和兩生類', '奇異鳥退化的翼骨的痕跡，是生物演化在生物地理學上的證據之一',  1),
(1992,  '中高級',  '有關生物演化的論述，下列哪個選項「錯誤」？',  '拉馬克用進廢退說闡明演化原理', '天擇說的基礎是競爭中僅優勝者得以生存並生育子代',  '不同品種的家禽和家畜是人為選擇育成',  '突變是生物演化唯一的因素', 4),
(1993,  '中高級',  '有關生物種概念的敘述何者正確？',  '依照生物的形態構造進行分類是生物種的概念', '若個體間產下具有生殖能力的子代，則屬於同一物種',  '馬和驢可以產下騾，所以馬、驢和騾皆屬同種生物', '所有生物都可以生物種的概念進行分類',  2),
(1994,  '中高級',  '下列有關地球上能量流轉的敘述，何者正確？', '能量在食物網中流轉，到高級消費者為止', '生產者與消費者皆可將葡萄糖分解產生能量',  '在地表生存的生物皆直接由太陽輻射能獲得能量',  '任一食物階層傳遞到次一食物階層的能量約為90%',  2),
(1995,  '中高級',  '有關早期生物演化論述，下列哪個選項正確？', '布豐認為生物起源於地球某一地區',  '居維業推測有多次大災難使物種滅絕', '萊爾認為大災難對地球的影響最大',  '拉馬克認為化石種類的改變不是生物演化的結果',  2),
(1996,  '中高級',  '有關育種的敘述何者正確？', '近代生物科技的產物',  '一種自然的演化歷程',  '可以改變或增加生物的表徵', '讓子代產生基因突變',  3),
(1997,  '中高級',  '下列有關族群的敘述，何者正確？',  '不同族群的年齡結構大致相同',  '估算一族群的出生率及死亡率，即可決定族群大小和密度',  '在一閉鎖環境中的族群，其大小和密度，最終會維持在一穩定狀態',  '在自然開放環境中，族群密度會受生物因素及非生物因素影響而波動', 4),
(1998,  '中高級',  '下列關於氮循環的敘述，何者正確？', '氮無法直接為一般動、植物體所利用', '大豆根瘤中的根瘤菌是一種與植物共生的真菌', '氮在土壤中必須轉換成硝酸鹽，始能為生物體吸收', '微生物中只有土壤中的硝化細菌，能直接利用大氣中的氮',  1),
(1999,  '中高級',  '下列有關群集消長的?述，何者正確？',  '初級消長的速率比次級消長快',  '群集的消長是一種斷斷續續並且快速的變化過程',  '被土石流淹沒的林地經一段時間，首先長出來的植物是小灌木',  '經過長時間，群集消長會形成穩定的顛峰群集', 4),
(2000,  '中高級',  '有關演化機制的敘述，下列哪個選項「錯誤」？',  '天擇可以決定生物演化的方向',  '生物體若無變異，演化就不會產生',  '為了適應環境，生物體會調整變異的方向', '能適應環境的個體才可以生存下來，這就是天擇',  3),
(2001,  '中高級',  '有關顛峰群集的敘述何者正確？', '物種組成不易再改變',  '生物多樣性因物種組成不變而降低',  '一定都是森林群集', '又稱為先鋒群集',  1),
(2002,  '中高級',  '動物保護色的形成原因為何？',  '人擇後經突變的結果',  '突變後經人擇的結果',  '突變後經天擇的結果',  '天擇後經突變的結果',  3),
(2003,  '中高級',  '恐龍滅絕的原因為何？', '氣候劇烈變化，恐龍無法適應新環境', '鳥類的大繁衍與恐龍競爭食物',  '原始人的出現大量獵捕恐龍', '因為哺乳類的大繁衍，造成恐龍缺乏食物及空間而滅絕', 1),
(2004,  '中高級',  '岩層中必須有下列哪些生物的出現，才能判斷該岩層當時必為海洋中的環境？', '魚類和兩生類', '爬蟲類和哺乳類',  '兩生類和蕨類', '珊瑚和海星',  4),
(2005,  '中高級',  '物種遺傳多樣性的產生與下列何者「無關」？', '天擇', '棲地', '有性生殖', '無性生殖', 4),
(2006,  '中高級',  '要能維持物種歧異度才能確保生物資源的永續性。下列哪一項措施，會違反維持物種歧異度的原則？', '野狼會捕食草食動物，為保護草食動物，應將野狼消滅', '草原生態系常發生因閃電引起的火災，這是草原生態系的自然現象，不宜撲滅', '將「外來種寵物」放生，可能導致牠們與原生物種競爭生存資源，因此應當避免放生',  '雖然福壽螺在臺灣已造成嚴重的災害，也仍不宜將福壽螺的天敵鳥類引進臺灣', 1),
(2007,  '中高級',  '長頸鹿脖子一代一代愈來愈長，依達爾文的演化學說認為此為下列哪個選項的結果？',  '用進廢退', '人為育種', '遺傳變異與天擇',  '基因重組', 3),
(2008,  '中高級',  '南仁湖地區擁有臺灣低海拔原始闊葉林，其高等維管束植物種類占了全臺灣的三分之一。南仁湖地區是屬於何種多樣性？',  '棲息地的多樣性',  '水資源的多樣性',  '物種的多樣性', '生態系的多樣性',  3),
(2009,  '中高級',  '某一海域的潮間帶有兩種海星互競空間，存活較多的一方應具有下列何種特性？',  '以另一方為食的掠食者', '可以產生某種新酵素',  '生殖率極低',  '較適應該區域', 4),
(2010,  '中高級',  '某生物學者利用一種新藥嘗試消滅瘧蚊，此藥第一年效果極好，但是過了十年之後，藥效只剩下兩成，此事件與下列何種學說有關？', '拉馬克「用進廢退說」', '達爾文「天擇說」', '孟德爾「遺傳定律」',  '林奈「生物分類」', 2),
(2011,  '中高級',  '研究不同地質時代的化石可以得到生物演化的訊息。對於馬的各部位化石分析中，哪個部位的演化趨勢最能支持馬愈來愈適應草食性生活？',  '犬齒愈來愈發達',  '臼齒愈來愈發達',  '四肢愈來愈高大',  '頭顱愈來愈壯碩',  2),
(2012,  '中高級',  '研究單位培育出一新品種小麥，其抗病能力及單位面積產量均大幅提升。若世界各地均改種此一新品種小麥，則下列哪一種結果最可能發生？', '小麥將永遠不再產生蟲害',  '小麥的遺傳多樣性增加', '小麥田生態系的穩定性增加', '某些小麥的基因資源消失，可能導致小麥滅絕', 4),
(2013,  '高級', '若花蓮外海因海底火山爆發形成一座新的火山島嶼，那麼最早形成的群集應該為何？',  '蘚苔群集', '地衣群集', '草本植物群集', '森林群集', 2),
(2014,  '中高級',  '根據器官的演化來源判斷，下列何者「不」屬「同源器官」？',  '海狗及鯨的游泳肢', '貓的爪及攀木蜥蜴的爪', '蜻蜓的翅及食果蝙蝠的飛膜', '蝴蝶吸蜜及蚊子吸血的口器', 3),
(2015,  '中高級',  '海洋生態系依水深的程度可分為潮間帶、近海區與遠洋區。遠洋區內的主要生產者為何？',  '大型水生植物', '浮游植物', '上層生物的屍體',  '大型藻類', 2),
(2016,  '中高級',  '現今有袋類生物（如：袋鼠和無尾熊等）僅存於澳洲及南美洲的原因為何？',  '適應該地的特殊氣候，而由胎盤動物演化出來的獨特物種',  '因與外來的近似亞種雜交的結果', '與其他各大陸分離，未被淘汰而得以存活並演化至今',  '與其他各大陸分離，有袋類的演化在澳洲與南美洲呈現完全停滯的狀態',  3),
(2017,  '中高級',  '就生態平衡的觀點而言，下列何者正確？', '無論保護何種野生動物，對環境生態都是有利的',  '從長遠的眼光來看，競爭對族群的綿延不利',  '外來種一旦適應侵入地，對當地而言由於新增新物種，故有利於提升生物多樣性',  '掠食雖對獵物個體生存不利，但對整個獵物族群在環境的適應上是有利的', 4),
(2018,  '中高級',  '在花蓮、臺東地區，白頭翁並不常見，卻可發現另一種不論在身體大小、外型或是顏色上都和白頭翁非常類似的鳥，烏頭翁。按照生物的分類，白頭翁與烏頭翁可根據下列哪個物種觀念，而被視為同一物種？',  '生物種',  '黏合種',  '演化種',  '親緣種',  1),
(2019,  '中高級',  '遠洋區的主要生產者和下列哪類生態系的主要生產者最為相近？', '沼澤生態系',  '湖泊生態系',  '潮間帶生態系', '溪流生態系',  2),
(2020,  '中高級',  '一個生態系中，消費者階層很少超過三級的主要原因為何？', '有害物質經由食物鏈累積，使第四級消費者達到致死的量',  '食物鏈組成種類過於複雜，不易維持生態的穩定',  '物質元素需求太多，環境無法供應',  '能量在轉移過程中逐漸損耗，無法供應最高級消費者',  4),
(2021,  '中高級',  '下列哪個生態系最穩定？',  '岩原', '沙丘', '針葉林',  '闊葉林',  4),
(2022,  '中高級',  '入侵種褐樹蛇於二次大戰時入侵關島，在20年間使關島12種特有鳥類消失了9種，剩餘3種中的2種也瀕臨滅絕，這是入侵種造成的何種影響？',  '基因多樣性減少',  '物種多樣性減少',  '生態系多樣性減少', '遺傳多樣性增加',  2),
(2023,  '中高級',  '下列何種變化會造成某一族群的密度變小？',  '出生率提高',  '死亡率提高',  '食物增加', '環境負荷量升高',  2),
(2024,  '中高級',  '下列何者較「不會」隨著生物群集的消長而改變？', '氣候', '能量流轉', '物種組成', '生物間的交互作用', 1),
(2025,  '中高級',  '下列哪個選項是湖泊中的食物鏈？',  '海茄苳→微生物→招潮蟹→大白鷺',  '水王孫→螺→魚→綠頭鴨',  '綠藻→石蠶蛾→鯛魚→翠鳥', '草→蚱蜢→田鼠→赤腹鷹',  2),
(2026,  '中高級',  '以下何者「不利」於新物種的形成？', '大峽谷隔離兩岸的羚鼠', '丹頂鶴的求偶舞蹈產生變異', '加拉巴哥雀鳥對食物的偏好', '候鳥隨季節向外地作週期性的遷移',  4),
(2027,  '中高級',  '下列何種遺傳表徵「不是」天擇的結果？', '北極熊生活於冰天雪地中，體色為灰白色', '沙漠中仙人掌的針狀葉', '犬的體形及毛的長短變化繁多',  '海洋中鯨魚的四肢呈鰭狀',  3),
(2028,  '中高級',  '下列何者可能是沙漠動物的適應方式？',  '偏好集體活動', '含氮廢物以結晶方式排出',  '大都視覺不發達',  '具有黑色的皮毛',  2),
(2029,  '中高級',  '在自然狀態之下，下列何種植物可藉由其根部的根瘤菌利用空氣中之氮氣？',  '玉米', '水稻', '甘蔗', '落花生',  4),
(2030,  '中高級',  '如果在臺北、臺中、高雄、花蓮、臺東分別做物種遺傳多樣性調查，下列哪一種臺灣原生物種的地區間遺傳差異會最高(假定族群大小及突變率相同，且無天擇之作用)？',  '蝸牛', '麻雀', '山豬', '紫斑蝶',  1),
(2031,  '中高級',  '在海洋生態系中，隨著水深的不同，環境條件與生物種類分布也常有很大的差異，有關海洋生態系的描述，下列哪一選項「不正確」？',  '海洋生態系常以水深200公尺為界，區分為「淺海區」與「大洋區」(或稱「近海區」與「遠海區」)', '「淺海區」底部又稱為「大陸棚」，此水域受陽光照耀富含礦物質，所以棲息其中的生物種類繁多',  '「大洋區」的生存空間遼闊，所以容納的生物種類遠較分布在「淺海區」的生物種類多', '「潮間帶」指的是海岸高潮線和低潮線之間的區域，生物須發展出特殊的適應方式，以抵抗海浪的衝擊',  3),
(2032,  '中高級',  '海島常孕育多種特有生物，其最可能的原因為何？', '不易橫越海洋散布', '食物豐富', '氣候溫和', '缺少天敵', 1),
(2033,  '中高級',  '單一樹種的育林「不會」導致下列何種結果？', '生物多樣性降低',  '森林面積縮減', '生態系穩定性降低', '破壞野生動物棲息地',  2),
(2034,  '中高級',  '有關單一樹種的育林常大量植樹的敘述何者正確？', '適合大力推廣，可增加生物多樣性',  '適合大力推廣，多種樹一定是好的',  '不適合大力推廣，會降低生物多樣性', '不適合大力推廣，一定會導致土石流的發生',  3),
(2035,  '中高級',  '新物種如何形成是研究物種演化過程的重要議題之一。物種形成的可能原因有很多種，但「不包括」下列哪個選項？',  '環境壓力', '族群間產生不能互相交配的現象', '族群間產生不易橫越的地理障礙', '族群間遺傳交流增加',  4),
(2036,  '中高級',  '溪流生態中，食物與能量之主要來源為何？',  '大型固著性藻類',  '河岸植物的枯枝落葉',  '由岩層沖刷溶出',  '浮游藻類', 2),
(2037,  '中高級',  '下列有關海洋生態以及河口生態之敘述何者正確？', '於河口地帶生存之魚類多屬狹鹽性',  '水深二百至四百公尺之淺海區為大陸棚',  '與岩岸地形相比，沙岸生態生產者較少，因此生物相貧乏',  '珊瑚礁是軟體動物之一種，是對環境適應力極大之重要生產者',  3),
(2038,  '中高級',  '臺灣陸地生態系中，下列哪種生態系的物種多樣性最豐富？', '常綠闊葉林',  '針葉林',  '岩原', '草原', 1),
(2039,  '中高級',  '保護色之所以形成，是因為下列哪個選項扮演了天擇的角色？',  '天敵', '氣候', '人類', '綠色植物', 1),
(2040,  '中高級',  '關於生物多樣性的敘述何者正確？',  '在生物多樣性愈小的生態系中，一物種消失，對食物網的穩定性影響愈小', '生物多樣性愈高，生態系愈容易維持平衡穩定', '單一樹種的育林方式有利於生態系的穩定，並能避免病蟲害的侵犯',  '生物棲息環境變化少的生態系，生物多樣性愈高',  2),
(2041,  '中高級',  '關於物質循環與能量流轉的敘述，下列哪個選項是正確的？', '營養階層愈高，所含能量愈高',  '呼吸作用是碳元素返回環境的唯一方式',  '氨化作用可由分解者(如細菌)進行，其目的是使有機氮變成氮返回環境', '依營養階層低到高，能量塔必為下寬上窄的金字塔型',  4),
(2042,  '中高級',  '關於臺灣各種生態系的敘述何者正確？',  '由於垂直高度落差大，臺灣的生態系相當豐富', '由於西部海岸線相當長，使西部素有全球生物多樣性之冠的封號', '沙丘生態系多以耐鹽、耐缺氧的植物為主', '臺灣年雨量高且氣候潮溼，所以高山與平地有許多大型湖泊', 1),
(2043,  '中高級',  '下列何種方式有助於生物多樣性的維護？', '大量食用基因改造食品', '引進外來物種', '維護地球多樣基因庫，平衡全球生態系統', '增加人口成長的速度',  3),
(2044,  '中高級',  '「常被當成雜草遭清除殆盡的野生種水稻，具有如抗蟲害、不易倒伏等獨特的基因，基於生物多樣性及人類利益，應該善加保存這些野生種水稻。」以上是針對哪一層次生物多樣性的敘述與探討？', '遺傳多樣性',  '物種多樣性',  '生態系多樣性', '無關於生物多樣性議題', 1),
(2045,  '中高級',  '下列何者「不是」造成物種多樣性下降的人為因素？',  '單一化種植作物',  '污染', '颱風', '過度捕魚', 3),
(2046,  '中高級',  '下列哪個選項的敘述完全正確？', '人工育種的水稻品種缺乏遺傳變異',  '野生品種的水稻有較高的物種歧異度', '野生品種的水稻對病毒具較強之適應力',  '野生種滅絕後會使稻米的遺傳歧異度提高', 1),
(2047,  '中高級',  '近年來世界各地發生大規模蜜蜂失蹤的現象，這種現象帶給人類最嚴重的損失為何？',  '蜂蜜減產，造成價格大幅度調漲', '蝴蝶大量衍生，造成生態浩劫',  '五穀類農作物大豐收',  '蔬果類農作物減產', 4),
(2048,  '高級', '以下何者是臺灣為何會擁有這麼多物種最可能的原因？', '臺灣自然環境提供不同類型的生物棲所',  '臺灣農業發達，利用育種產生新物種', '臺灣不斷引入外來種，促使物種增加', '臺灣鄰近大陸，生物經常自大陸各地渡海來臺', 1),
(2049,  '中高級',  '關於「突變的基因絕大多數是對個體不利的，卻是演化的重要機制」，下列哪個論述是正確的？', '對的，因為地球上的環境時常改變',  '對的，因為經過突變的個體，不易被淘汰', '不對的，因為基因突變可導致個體死亡',  '不對的，因為帶有突變基因的個體不易繁殖',  1),
(2050,  '中高級',  '有關河口生態系的敘述，何者「不正確」？',  '生產量很高',  '是蚊吶叢生的瘴癘之地', '為海域生物的哺育場所', '紅樹林位於河口的沼澤地',  2),
(2051,  '中高級',  '以生態平衡的角度而言，沼澤、濕地應如何利用較為合理？', '維持原貌', '填平後供都市發展使用', '就近開發為海水魚養殖魚塭', '開發為蓄水池', 1),
(2052,  '中高級',  '最早提出「生態工法」這個名詞的人是誰？',  '許旺', '高基', '懷塔克',  '歐當', 4),
(2053,  '中高級',  '有關流動水域的敘述，下列哪個選項正確？',  '水流速度快，故溶氧量少',  '污染很少，浮游生物容易生存',  '與陸域生態系有明顯區隔',  '上游的物種數量小於中游',  4),
(2054,  '中高級',  '下列何種作為「最不符合」生態工法的原則？', '河川整治或興建水庫時，應設置魚梯', '多孔隙的河川生態，可降低洪水發生率',  '設置腳踏車停放處，應鋪設柏油路面，以保護人體脊椎', '盡可能以再生資源如太陽能、風力發電取代石油或煤炭', 3),
(2055,  '中高級',  '有關防治山崩的方法，下列何者是「錯誤」的？',  '避免在順向坡墾地', '在山坡開設排水溝，宣洩雨水及地下水',  '在坡頂灌漿增加土體摩擦力', '做好山坡地的水土保持', 3),
(2056,  '中高級',  '臺中屬於盆地地形，試問造就該地型的成因可能是哪個選項？',  '盆地四周山區的沉積作用較盆地中心強',  '超抽地下水導致地層下陷',  '盆地四周西流的侵蝕作用強烈',  '因斷層作用造成陸地逐漸陷落',  4),
(2057,  '中高級',  '下列何處比較容易發現化石？',  '陽明山小油坑火山口附近',  '墾丁國家公園的沉積岩地層中',  '澎湖的玄武岩地層中',  '金門的花岡岩地層中',  2),
(2058,  '中高級',  '臺灣北端富貴角常見的風磨石有固定方向的稜角與稜面，這是下列哪項因素所造成？',  '石頭紋理方向固定', '東北季風方向固定', '富貴角潮汐週期固定',  '富貴角溫差大，水滲入將石頭撐破崩解',  2),
(2059,  '中高級',  '墾丁國家公園內的許多溶蝕洞中有特殊的鐘乳石景觀，這是因為其形成過程中，哪一種岩石層經過抬升後，再受地下水和雨水的溶解與沉澱作用所形成？',  '石灰岩',  '頁岩', '安山岩',  '花崗岩',  1),
(2060,  '中高級',  '有關臺灣岩層的分布情形，下列哪個選項是「錯誤」的敘述？',  '北部大屯山主要是安山岩',  '中央山脈區域大都是變質岩', '墾丁國家公園擁有豐富的大理岩', '花東縱谷大都屬於變質岩',  3),
(2061,  '中高級',  '酸雨的危害包括腐蝕大理石的建築物及雕像，也會酸化河水、湖泊，影響水中的生態。位於下列哪一種地質環境的湖泊，其湖水的pH值受酸雨的影響「最小」？',  '花崗岩',  '安山岩',  '石灰岩',  '玄武岩',  3),
(2062,  '中高級',  '農委會每年都會選出十大優質米，幫民眾把關糧食品質，也讓國人對於農業品質有更多的認識，更願意採購國內農產。如此方式屬於哪一種農業策略？', '推動地方特色農業', '發展精緻農業', '推動農村再生', '發展生態農業', 2),
(2063,  '中高級',  '汽機車燃料稅「隨油徵收」除了符合租稅公平性之外，也可以強調下列哪個概念？', '生產效率', '內部成本問題', '比較利益', '使用者付費',  4),
(2064,  '中高級',  '下列何者是利用區域複合體分析觀點所得的結論？', '臺灣有內湖、新竹、臺中、臺南4個科技工業園區', '中國期以西北開發計畫，逐漸縮短沿海與內陸的區域發展落差',  '荷蘭利用盛行西風發展風力發電', '海岸突堤的興建造成堤後海岸侵蝕嚴重',  2),
(2065,  '中高級',  '下列哪個選項中的研究主題需要長期投入田野工作，採取參與觀察和深度訪談的田野調查方法？', '氣候異常調查', '臺中市人口分布空間分析',  '臺灣人口老化趨勢', '泰雅族年度行事曆調查', 4),
(2066,  '中高級',  '圖表是地理學研究不可缺少的工具。下列何種現象可利用「圓餅圖」來表示？', '嘉南平原的稻田分布區', '高雄地區石灰岩的分布', '臺南市的人口成長', '高雄市各行業就業人口比例', 4),
(2067,  '中高級',  '颱風季節來臨，救災單位想提早針對可能淹水的地區進行防治措施，無法利用以下哪些資料來進行疊圖分析而正確掌握？',  '地質圖',  '降水分布預測圖',  '經建版地形圖', '水系圖',  1),
(2068,  '中高級',  '有關人類對環境的改變造成無可彌補的災害，下列何者的敘述是「錯誤」的？', '河川上游水庫的興建，間接使西部海岸後退',  '興建的堤防，形成突堤效應，改變海流方向而使沿岸沙灘迅速消失',  '大甲溪上游的谷關電廠慘遭掩埋，乃因上游山坡地大量栽培蔬菜的後果',  '外傘頂洲的面積正急速縮減乃因河中泥沙被攔截，沿岸漂沙量減少有關',  4),
(2069,  '中高級',  '下列何者會造成生態影響？(A)北部濱海公路沿海曲折多岩岸地形；(B)到貢寮一帶看到「核廢料萬年不滅」、「臺電核四帶來不斷電的臺灣」、「我們要非核家園」等醒目標語；(C)五峰旗瀑布位在礁溪鄉；(D)大量遊客湧入冬山河親水公園，造成交通壅塞；(E)龜山島開放觀光，每天有船隻往返，造成部分生態干擾。',  'AB', 'BC', 'CD', 'DE', 4),
(2070,  '中高級',  '國光石化的評估作業流程中，主要使用下列何種地理學的分析方法？', '空間分析', '生態分析', '區域複合體分析',  '地科研究法',  3),
(2071,  '中高級',  '下列何者為現代區域計畫的基礎？',  '空間分析', '生態分析', '區域交流分析', '區域複合體分析',  4),
(2072,  '中高級',  '1951年花蓮大地震和1999年集集大地震兩次地震災害死亡人數懸殊，最主要是兩地哪一項條件的差異所造成？', '地層年代', '震央海拔', '震源深度', '人口密度', 4),
(2073,  '中高級',  '在1950年代為解決落後地區的糧食問題，除農耕方法改進外，對於小麥、玉米及稻米等作物進行品種改良，造成所謂的「綠色革命」。下列何者「不是」綠色革命所造成的結果？', '農作物產量增加',  '促進作物單一化',  '放緩人口增長速度', '拉大各地貧富差距', 3),
(2074,  '中高級',  '「永續農業」除採用自然農法建立農產品的生態標章外，並在作物收成後將殘株混入土中並加以翻土，讓農田在這樣的休耕方式對農田的生態環境帶來什麼影響？',  '', '提高土壤肥力且避免連年種植同一作物，以減少病蟲害', '使土壤密實，減緩土壤侵蝕', '翻動表土，加速土壤母質風化速度',  0),
(2075,  '中高級',  '在臺灣，成功的生態社區應多發展下列何種產業？', '資訊', '鋼鐵', '水稻種植', '當地的傳統產業',  4),
(2076,  '中高級',  '設置碳交易市場是透過經濟學上的哪個手段，以提升社會整體效益？', '強化企業節能減碳的道德認知',  '增加政府污染防治的公共投資',  '將生產的外部成本納入考量', '降低企業稅率，提高企業獲利',  3),
(2077,  '中高級',  '珊瑚礁島國吐瓦魯，位於大洋洲，該國領導人在一份聲明中說，他們對抗環境變遷的努力已告失敗，將放棄自己的家園，舉國移民紐西蘭。該聲明中所謂之「環境變遷」最可能是下列何者？',  '海平面上升',  '火山爆發', '酸雨侵蝕', '臭氧層破洞',  1),
(2078,  '中高級',  '冰河消融線是指冰雪累積與融化的分界位置，且該分界會隨氣溫變化而位移。不考慮高度差異下，下列關於消融線的敘述，哪個選項較為合理？',  '夏天時，冰河消融線會往冰河下游位移',  '低緯區的冰河消融線位置，通常會較高緯區高', '乾燥區的冰河消融線位置，通常會較溼潤區低', '工業革命以來，冰河消融線位置大致呈現前進現象', 2),
(2079,  '中高級',  '在全球森林快速消失之下，許多政府和民間單位開始倡導植樹活動。下列哪個選項是植樹後最可能產生的影響？',  '抑制聖嬰現象發生', '增加河中淤沙量',  '減緩全球暖化趨勢', '縮短洪水延滯時間', 3),
(2080,  '中高級',  '隨著西北航道海冰的融化，阿拉斯加的生態系統可能出現下列哪種變化？', '國王企鵝的數量減少',  '北極熊的生物群落增加', '小麥種植的面積增加',  '落葉灌木林的面積增加', 4),
(2081,  '中高級',  '英國歷史記載：「1952年12月5至9日，一連幾天，空氣幾乎靜止不動。當時正值隆冬季節，從家庭和工廠的煙囪排出的煙塵不但散不出去，而且愈積愈多。在這次事件中，整個倫敦地區有4百多人死亡。在毒霧過後的兩個月，仍陸續有8千多人死亡。」以上是二十世紀中著名的空氣污染事件，引發此一事件的關鍵因素為何？',  '鋒面過境', '逆溫現象', '聖嬰現象', '溫室效應', 2),
(2082,  '中高級',  '溫室效應與下列哪個選項最相關？',  '二氧化碳，宇宙射線',  '二氧化碳，紅外線', '二氧化碳，紫外線', '二氧化氮，紅外線', 2),
(2083,  '中高級',  '若碳交易市場上，每公噸二氧化碳排放權的價格居高不下，那麼下列描述何者正確？',  '企業已大量減少二氧化碳排放',  '政府發放過多的污染排放權證',  '民眾對於污染的忍受程度提高',  '廠商執行減碳的技術能力低落',  4),
(2084,  '中高級',  '現代的農業發展帶來環境問題，如全球暖化，小小的食物選擇也成為暖化的關鍵，下列哪個選項「無法」對地球盡一分心力？',  '吃在地、當季的食物',  '多吃素、少吃肉',  '選擇食物里程(Food',  'miles)短的食物　',  0),
(2085,  '中高級',  '大氣平流層的底部有一層臭氧層可以阻隔95%以上來自太陽輻射的紫外線，但在1980年代以後，科學家們觀測到南極上空在春天到初夏時會有臭氧耗損，臭氧層變薄的情形，俗稱臭氧洞。造成南極臭氧層破洞較北極嚴重的主要原因是下列何者？', '南極冬季氣溫遠較北極低',  '南半球排放較多的氟氯碳化物',  '南極的降水量較北極少', '南半球環保政策較不落實',  1),
(2086,  '中高級',  '下列哪個選項不是造成全球海平面上升的原因？',  '海水因增溫而體積膨脹', '南北極冰帽及高山冰川消融', '北極海附近海面浮冰消融',  '陸地水域、植被和土壤水減少',  3),
(2087,  '高級', '調查顯示：「1971-1999年，美國東部櫻花開花日期提前7天；1959-1999年，歐洲秋季樹葉變色的日期延遲4.8天；1954-1981年，中國雲南西南部山區的霧日減少75天。」下列何者最適合用來解釋引文所述的現象？', '氣候變遷', '生態平衡', '山岳效應', '推拉理論', 1),
(2088,  '中高級',  '加拿大東南部聖羅倫斯河沿岸低地，交通便利，工業發達，是加拿大人文薈萃的心臟地帶，緊鄰美國五大湖工業區東側不遠處。試問該地最可能面臨下列何種環境生態問題？', '熱島效應，森林林相快速改變',  '溫室效應，冰山溶解海水倒灌',  '地層下陷，夏季常遭洪水侵襲',  '酸雨侵襲，土壤肥力明顯下降',  4),
(2089,  '中高級',  '現今地中海型農業區土地使用較傳統更為集約的原因為何？', '灌溉技術進步', '全球氣候變暖', '品種基因改良', '機械化耕作',  1),
(2090,  '中高級',  '農業系統包括了投入與產出，當系統的投入改變時，系統的運作也將改變。依此概念推論，造成高緯度地區的農業越來越發達的因素「不包括」下列哪個選項？', '生物科技的發展',  '生產技術的改進',  '全球氣溫的暖化',  '大地主制的推行',  4),
(2091,  '中高級',  '國際油價居高不下，近來一些石化業者想到中國大陸設置輕油裂解廠，主要是考量中國大陸擁有什麼條件？',  '原料產量豐富', '環保限制較少且消費市場廣大',  '外籍勞工充足', '以上皆是', 2),
(2092,  '中高級',  '造成近代農業發展變遷的原因包括下列哪些？(A)運輸設備的改進；(B)消費能力的提高；(C)關稅障礙的提高；(D)地質災害頻仍。',  'AB', 'BC', 'CD', 'AC', 1),
(2093,  '中高級',  '1960年代，印度與菲律賓因改種IR8型的奇蹟稻，而使產量倍增，成為綠色革命時期的成功典範。該計畫得以成功的主因「不包括」下列哪個選項？', '進行品種改良', '噴灑化肥與農藥',  '配合機械化',  '施行土地公有制',  4),
(2094,  '中高級',  '下列哪個選項「不是」印度進行綠色革命得以成功的主要因素？', '政策規劃', '資金投入', '技術改良', '勞力需求大增', 4),
(2095,  '中高級',  '邱先生南遷高雄內門務農，若邱先生想有一番作為，並考量臺灣加入WTO所面臨的競爭壓力及臺灣環境與需求，下列哪個農作類型「不值得」邱先生考慮發展？',  '有機農業', '園藝農業', '養豬事業', '酪農業',  3),
(2096,  '中高級',  '臺灣東部的酪農業因應時代環境變遷，目前經營方式上也結合下列何種方式為主，以力求生存發展？', '兼種稻米', '觀光休閒', '食品加工', '生態保育', 2),
(2097,  '中高級',  '什麼是農產品產銷履歷？',  '食品安全和農業環境永續生產行銷證明書', '使用天然素材，不使用化合物的生產歷程', '降低生產過程及產品之風險的歷程紀錄',  '在生產、加工、流通、銷售各階段所經的歷程', 4),
(2098,  '中高級',  '2008年年底，聯合國「糧食暨農業組織」警告，許多較富裕國家如南韓、杜拜等的政府與企業，為確保長期的糧食供給安全，正大舉租用甚至收購開發中國家的農地。這樣的決策是因為收購者的國內發生何種情形？', '農民人口增加', '農民人口的老化',  '飲食習慣的改變',  '可耕地的開發已近飽和', 4),
(2099,  '中高級',  '下列哪些重大的全球變遷現象，與近年世界各國積極推動資訊化、網路化的關聯最密切？',  '人口成長趨緩且跨國企業加速發展',  '自然災害增加且第二級產業集中於都會區', '跨國企業加速發展且時空收斂，空間重組', '第二級產業集中於都會區且時空收斂，空間重組',  3),
(2100,  '中高級',  '造成農業經營出現區域專業化的主因是下列哪個選項？', '生產技術進步', '交通革新', '市場需求下降', '氣候環境變遷', 2),
(2101,  '中高級',  '有關臺灣農村經營特性的敘述，下列哪個選項最可能是加入世界貿易組織(WTO)後對農業發展產生重大衝擊的主因？',  '勞力外流與廢耕',  '農業投資不足', '耕地面積狹小而零碎',  '稻米生產過剩', 3),
(2102,  '中高級',  '「前雷後雨，落不濕土」、「一粒雨擲死一個人」，以上臺灣諺語所形容的降水類型，主要成因是下列哪個選項？', '地形抬升', '鋒面滯留', '熱力對流', '強烈低氣壓',  3),
(2103,  '中高級',  '「清明時節雨紛紛」是先人的生活經驗，請問清明時的降水，主要原因是下列哪個選項？',  '鋒面雨',  '地形雨',  '對流雨',  '颱風雨',  1),
(2104,  '中高級',  '下列哪個選項的敘述是對「降雨變率」最好的詮釋？',  '象神颱風在花東地區降水超過10,000毫米，約占全年平均降水量的一半，形成嚴重水災',  '一時陰風怒吼，一時朝陽送暖，令人捉摸不定', '臺灣諺語：「一月寒死豬，二月寒死牛，三月寒死耕田夫',  '伊基圭位居智利北部，曾有連續14年不降水的紀錄，但之後的一年，一陣雨就下了65毫米，還鬧水災', 4),
(2105,  '中級', '冬至時，下列哪一個都市的「白晝時間」最長？',  '高雄', '嘉義', '臺中', '臺北', 1),
(2106,  '高級', '俗諺「春天後母面」，描述的是下列哪種氣候特徵？',  '春天天氣善變', '春天打雷會放晴',  '春天陰雨連綿', '春天濃霧必大旱',  1),
(2107,  '中高級',  '根據中央氣象局對於臺灣地區降水強度的分類標準，24小時內累積了350毫米以上降水量的氣象事件即可稱為高強度的「超大豪雨」，則哪種情況造成的降水事件「較不易」形成「超大豪雨」？',  '南部熱對流雨', '東北部地形雨', '澎湖午後雷陣雨',  '阿里山區颱風雨',  3),
(2108,  '中高級',  '測量氣溫變化會發現降水區段和不降水區段的氣溫變化不同。降水區段的氣溫變化較小，主要因素是下列哪個選項？',  '水的比熱較大', '降水使地溫降低',  '降水時阻隔陽光照射',  '降水區段會釋放出熱',  4),
(2109,  '中高級',  '請問下列哪一種降雨類型，與地形抬升氣流最相關？',  '清明的綿綿細雨',  '5、6月的梅雨',  '暑假的午後雷陣雨', '基隆的冬雨',  4),
(2110,  '中高級',  '諸羅縣志中記載：「夏秋紅日當空，片雲乍起，傾盆立至。」文中所描述的降水型態，與下列哪個選項最為相近？', '西北雨',  '梅雨', '竹風「蘭雨」', '日本「秋霖」', 1),
(2111,  '中高級',  '「丹恩颱風來襲，恆春鎮在10月8日的24小時內降下262毫米的雨。」此段報導是在強調下列哪項降水特徵的指標？', '降水強度', '降水多寡', '降水變率', '雨區大小', 1),
(2112,  '中高級',  '冬季山地逆溫，所以怕霜的農作物多種在何處？',  '山頂', '谷口', '谷底', '山坡', 4),
(2113,  '中高級',  '下列哪個地形區容易產生逆溫現象？', '山頂', '鞍部', '山谷', '高原', 3),
(2114,  '中高級',  '當臺灣發生「空梅」時，下列哪個地區的乾旱期可能是最長的？', '蘭陽平原', '桃園臺地', '嘉南平原', '竹東丘陵', 3),
(2115,  '中高級',  '七二水災中，部分地區在短時間降下大量雨水，造成嚴重淹水。此一敘述是指何種降水特徵？',  '降水強度', '降水多寡', '降水季節分布', '降水變率', 1),
(2116,  '中高級',  '民國93年9月17日聯合報刊載「…臺北市政府基於地下管道排水容量限制，研擬訂定豪雨假，未來只要氣象預報的日降水量達400毫米，將全面停止上班上課。」臺北市訂定豪雨假標準的主要考量是什麼？',  '降水季節分布太過不均', '相對濕度太大', '降水強度太大', '降水變率太大', 3),
(2117,  '中高級',  '一般而言，海拔高度愈高，氣溫愈低。上述現象和下列哪一項因素最有關？',  '植物種類', '空氣密度', '風化程度', '距地表高度',  2),
(2118,  '中高級',  '下列哪一種氣候特徵的形成，與「暖流」的關係最密切？',  '熱帶莽原氣候的乾濕分明',  '熱帶氣旋的風速',  '熱帶海岸沙漠的形成',  '歐洲冬季氣溫較同緯度其他地區高',  4),
(2119,  '中高級',  '古時黃昏有船隻自澎湖運送魚貨到臺南，隔夜清晨運送其他物資回澎湖。古人巧妙運用的風向為下列哪個選項？',  '季風', '海陸風',  '焚風', '信風', 2),
(2120,  '中高級',  '地方風系中，海陸風的形成與下列哪個選項最相關？',  '海拔高度不同', '海陸比熱不同', '水氣含量不同', '水中鹽分不同', 2),
(2121,  '高級', '下列哪種能量是造成地表空氣流動(風)最主要的來源？',  '地熱', '燃燒', '太陽輻射', '地心引力', 3),
(2122,  '中高級',  '有句俗諺：「夜晚是赤道地區的冬天」，下列哪一組關鍵字可以正確地解釋此句俗諺？', '年降水量、地形',  '年均溫、地形', '晝夜長短、緯度',  '日溫差、緯度', 4),
(2123,  '中高級',  '有關緯度與氣候的關係，下列哪個選項是「錯誤」的敘述？', '同一緯度雖地形不同，但氣候通常相似',  '同一緯度，沿海比內陸多雨', '在西風帶內，大陸西岸比東岸宜於人居',  '同緯度，內陸氣溫變化大於沿海', 1),
(2124,  '中高級',  '每年春季與秋季，大陸性冷氣團與海洋性暖氣團相遇時會產生所謂的「介面」，而此介面通常具有下列何種特徵？', '氣壓較低', '大氣呈穩定狀態',  '大氣鮮少發生對流現象', '若出現降水，其水氣的來源由冷氣團供應', 1),
(2125,  '高級', '亞洲地區「缺乏」下列哪種氣候類型？',  '熱帶高地氣候', '副極地氣候',  '溫帶地中海型氣候', '溫帶海洋性氣候',  4),
(2126,  '中高級',  '亞洲熱帶季風和副熱帶季風最明顯差異是下列哪個選項？',  '氣候的因素',  '夏季的氣溫',  '年降水量的多寡',  '乾季的有無',  4),
(2127,  '中高級',  '受到科氏力的影響，北半球盛行西風帶中的「西風」有下列哪項特徵？',  '由低緯往高緯，風向由西北風轉偏西風',  '由高緯往低緯，風向由北風轉偏西北風',  '由高緯往低緯，風向由西南風轉偏西風',  '由低緯往高緯，風向由西南風轉偏西風',  4),
(2128,  '中高級',  '南、北赤道洋流流至大陸東岸後以拋物方式轉向中緯度地區，主要是受下列哪一因素影響？', '信風吹送', '西風吹送', '海水鹽度的差異',  '地球自轉的偏向',  4),
(2129,  '中高級',  '南極比北極更加酷寒，主要原因和下列哪個選項「無關」？', '海陸性質', '地形差異', '緯度高低', '暖流有無', 3),
(2130,  '中高級',  '若某內陸都市於48小時內，有一冷鋒鋒面通過，當鋒面通過時，此都市的天氣有何變化？', '氣壓升高、氣溫升高、相對濕度升高、風向不變',  '氣壓降低、氣溫降低、相對濕度降低、風向不變',  '氣壓升高、氣溫降低、相對濕度升高、風向不變',  '氣壓升高、氣溫降低、相對濕度降低、風向改變',  4),
(2131,  '中高級',  '海陸差異是影響一地氣候的重要因素，當兩地緯度相當時，下列哪個現象表現出的「海洋性」較明顯？',  '溫差較小', '降水量較少',  '夏溫較高', '氣壓較高', 1),
(2132,  '中高級',  '高緯度地區的大洋東岸水溫比西岸高的原因是？',  '受信風影響',  '受西風影響',  '有暖流經過',  '有涼流經過',  3),
(2133,  '中高級',  '假設地球的自轉軸(地軸)和公轉的黃道面垂直，下列哪一個情況會發生？',  '日夜顛倒', '無四季變化',  '無行星風帶',  '無地方風系',  2),
(2134,  '中高級',  '將季風氣候分成熱帶季風氣候、副熱帶季風氣候和溫帶季風氣候，主要的依據是下列哪個選項？', '地形起伏', '降水量多寡',  '海陸分布', '緯度高低', 4),
(2135,  '中高級',  '通常地表氣溫和海拔高度呈現反比的關係，但有時地表會有逆溫現象。下列哪一個現象的氣壓狀況和逆溫的情形相似？', '全球暖化', '鋒面籠罩', '颶風來襲', '都市熱島', 4),
(2136,  '中高級',  '著名的荷蘭風車提供荷蘭未來綠能的需求。荷蘭可利用風力的優勢為下列哪個選項？',  '地勢低窪', '農業發達', '極地高壓', '盛行西風', 4),
(2137,  '中高級',  '距海遠近是影響氣候的要素之一，最好再同時考量下列哪項因素，才會比較有意義？',  '盛行風向', '海拔高度', '緯度高低', '植被情形', 1),
(2138,  '中高級',  '極地高壓帶的形成，與下列哪個選項關係最大？',  '降水極少', '氣溫極低', '海拔極高', '風力極強', 2),
(2139,  '中高級',  '對於不同區域氣溫變化的比較，下列哪個選項是正確的？',  '緯度愈高，年溫差愈大', '海拔高度愈低，年溫差愈大', '距海愈遠，年溫差愈小', '緯度愈高，夏溫愈高',  1),
(2140,  '高級', '臺灣冬季季風比夏季季風強的主因是下列哪個選項？',  '冬季西北季風與盛行風合而為一', '冬季東北季風與東北信風合而為一',  '夏季西南季風來自海上', '夏季季風受中央山脈阻擋',  2),
(2141,  '中高級',  '臺灣因位在歐亞大陸和太平洋交界處，屬季風氣候區，且臺灣的冬季季風較夏季季風強勁。這主要是下列哪一個原因造成的？',  '地形起伏', '海陸分布', '行星風系', '洋流影響', 3),
(2142,  '中高級',  '臺灣有「竹風蘭雨」、恆春「落山風」、澎湖兩怪「風大、雨少」，造成這些現象的因素是下列哪個選項？',  '洋流、地形',  '季風、地形',  '緯度、鋒面',  '地形、距海遠近',  2),
(2143,  '中高級',  '臺灣南部的緯度和夏威夷相當，夏威夷一年四季皆可進行水上活動，但是臺灣冬季卻常有農漁業遭受寒害的紀錄，造成這種差異的主因是臺灣深受下列何種環境因素影響所致？',  '太平洋高壓',  '中國沿岸流',  '蒙古、西伯利亞高壓',  '新褶曲高山分布廣', 3),
(2144,  '中高級',  '風的形成最主要是因為下列哪一種因素在兩地間的差異所致？',  '氣溫', '氣壓', '濕度', '海拔高度', 2),
(2145,  '中高級',  '造成溫帶海洋性氣候秋、冬季雨水較多的原因是下列哪個選項？', '強烈對流作用', '溫帶氣旋南移', '氣溫低使水氣凝結', '地形阻擋', 2),
(2146,  '中高級',  '新竹地區九降風的來源為下列哪個選項？', '東北季風', '西南季風', '西風', '南風', 1),
(2147,  '中高級',  '「三月死魚鰍，六月風燬稻。」是昔日農家常會擔心的兩種災情，後者所謂「風燬稻」的「風」，指的是下列哪個選項？',  '颱風', '焚風', '海風', '滯留鋒',  1),
(2148,  '中高級',  '「在中緯度地區，由於某種關鍵因素的影響，天然植被的經向地帶性格外規律，呈現由西(沿海)向東(內陸)依序為森林、草原與沙漠的變化。」上述最為關鍵的影響因素應為下列哪個選項？',  '洋流', '西風', '海拔高度', '熱帶氣旋', 2),
(2149,  '中高級',  '「凍融作用」最容易發生於哪個氣候區？', '極地氣候', '副極地氣候',  '溫帶海洋性氣候',  '熱帶乾燥氣候', 2),
(2150,  '中高級',  '如果有一個強烈颱風的中心位於臺南外海時，下列哪個地方最有可能產生焚風？',  '臺北', '宜蘭', '臺東', '臺中', 3),
(2151,  '中高級',  '有關凍融作用的敘述，下列哪個選項是「錯誤」的？',  '屬於物理風化作用', '地表岩石在原地崩解',  '經常發生在終年冰雪封凍的兩極區',  '可形成大片的岩海地形', 3),
(2152,  '中高級',  '通常地表氣溫和海拔高度呈現反比的關係，但有時在地表會有逆溫現象，亦即氣溫隨高度增加而升高。此現象最易發生在冬季晴朗無風的夜晚。為何「晴朗無風」有助於逆溫的形成？', '增加吸熱', '使氣壓降低',  '有助分子熱量輻射', '有助地表大氣熱量累積', 4),
(2153,  '中高級',  '臺東地區常見的焚風，在哪個季節時「最不可能」發生？',  '春季', '夏季', '秋季', '冬季', 4),
(2154,  '中高級',  '「4月臺灣宣告水荒，北部地區水庫蓄水量嚴重不足，已開始有局部管線末端地區產生無水可用的窘境，24日晚間氣象播報說明今、明兩天鋒面過境後，臺灣降水的機會將要等到5月中「入梅」後，才可望解決旱象。」按上述文中「入梅」的降水成因應與下列哪個選項相同？', '沙漠地區的暴雨',  '颱風過後的西南氣流',  '貴州、四川地區的秋雨', '西北雨',  3),
(2155,  '中高級',  '11月下旬時，秋颱「海神」在臺灣以北的那霸海域盤旋，臺灣當時對此颱風既期待能帶來雨水解決旱象，又怕強大風勢帶來嚴重風災。造成秋颱通常風力特別強的主因為何？',  '行進路徑由北而南', '與東北季風結合',  '黑潮勢力減弱', '親潮南下影響', 2),
(2156,  '高級', '大氣中的懸浮微粒會影響到都市逆溫現象，以臺北市而言，最可能出現逆溫的月份為何？',  '1月', '4月', '10月',  '7月', 1),
(2157,  '中高級',  '以下是1994年有關印度半島降雨情形的兩則新聞報導：(A)「新德里連續三週每日高達45°C的熱浪，終於告一段落，昨日的傾盆大雨使首都的氣溫明顯降低…。」；(B)「季風帶來好幾波的暴雨，橫掃印度和巴基斯坦，已經奪走近600人的生命…。」(A)、(B)兩則新聞報導依序最可能發生在哪兩個月份？', '二至四月', '五至七月', '九至十一月',  '十二至二月',  2),
(2158,  '中高級',  '臺北盆地開口向西北方，且因盆地地形常遭水災之苦，以下各條件中哪個選項的洪患機會「較小」？', '向西北方移動的颱風',  '5、6月梅雨季',  '10、11月颱風', '每月農曆15日',  2),
(2159,  '中高級',  '新竹柿餅、恆春洋蔥等地方特產，都和臺灣的哪項氣候特性有關？',  '夏季高溫', '降水豐富', '東北季風', '多颱', 3),
(2160,  '高級', '臺灣中橫公路沿線的果園多分布於山坡上，而非地勢較為低平的山谷裡，主因是下列哪個選項？', '山谷交通不便，果農搬運受限較多',  '夜晚時山坡的氣溫較山谷高，可避免水果的凍傷',  '夏季山坡風力強勁，水果熟成較快',  '山谷降雨強度大，水果易生腐爛', 2),
(2161,  '中高級',  '衛星影像和航空照片的比較中，在相同圖幅下「衛星影像」具有哪項特色？',  '比例尺較大',  '所涵蓋範圍較大',  '細部內容呈現較詳細',  '地表建物較清晰',  2),
(2162,  '中高級',  '2008年9月辛樂克颱風過境造成嚴重的災情，小安使用「紅外線衛星影像」做災後分析，發現大甲溪上游河道兩岸出現大片的白色區塊。大甲溪河道兩岸出現何種變化？', '出現大量蕨類植物', '土中含水量由低變高',  '人工建築物占地因倒塌而縮減',  '出現大量土石流或崩塌地',  4),
(2163,  '中高級',  '八八水災過後，臺灣有許多地方因為土石流而受創嚴重，如阿里山支線的鐵路修復許久，道路雖搶通，但當地的觀光業受打擊甚大。政府單位應該採用下列何種圖資作為未來整建的參考？', '地形模型', '兩萬五千分之一經建版地圖', '衛星影像圖',  '五萬分之一等高線圖',  3),
(2164,  '中高級',  '地理資訊系統(GIS)中，地理資料可分空間資料及屬性資料，下列哪個選項是「空間資料」？',  '居民職業類別', '臺灣行政界線圖',  '男女教育程度比例圖',  '臺灣降水量變率圖', 2),
(2165,  '中高級',  '在臺灣宜蘭縣境內，為防止土壤被風侵蝕，其作物的種植最好的是什麼走向？', '東西方向', '南北方向', '東北-西南方向',  '西北-東南方向',  4),
(2166,  '中高級',  '在颱風過後的「紅外線衛星影像圖」中，某河道呈現灰藍色，其所代表的意義是下列哪個選項？', '河川發生優養化現象',  '上游綠色植物被沖入河道中', '海水倒灌使河川鹽度升高',  '河道被含砂量高的濁水所充斥',  4),
(2167,  '中高級',  '利用GIS處理資料的最主要優點是下列何者？',  '可以透過電腦簡化資料', '結合大量屬性與空間資料做分析', '建立最為正確的預測模式',  '透過電腦資料的蒐集更為快速',  2),
(2168,  '中高級',  '利用紅外線衛星影像圖進行山坡地的監測管理時，若發現圖中新增一些灰綠色的斑點，則表示該地有何種現象發生？',  '有新聚落出現', '有新竹林生成', '有坡地崩塌發生',  '出現新的堰塞湖',  1),
(2169,  '中高級',  '若想知道海地在地震前後，受災的範圍和情況，用哪種圖做比較和分析最為恰當？', '地形圖',  '中美洲國界圖', '地震分布圖',  '衛星影像', 4),
(2170,  '中高級',  '若想將某校校區平面圖數值化，下列哪些資料以向量模式輸入「較不恰當」？', '排水溝管線管', '校園生態景觀路線', '教學大樓的分布',  '新建大樓工地粉塵污染範圍', 4),
(2171,  '中高級',  '計算工程的挖方與填方，甚至分析低窪區潛在的水患分布，應以何種分析方法為主？',  '路網分析', '視域分析', '疊圖分析', '地形分析', 4),
(2172,  '中高級',  '在地理資訊系統的兩種空間資料儲存方式中，向量模式適用於描述不連續現象的空間特質，網格模式則適用於具有連續特質的現象。下列哪個地理現象，較適合以網格模式來儲存資料？',  '油井的分布',  '空氣污染', '地形高度的標示',  '行政區的分布', 2),
(2173,  '高級', '目前政府各部會對電磁波管理的權責分工，下列何者「錯誤」？', '原子能游離輻射管理單位為原子能委員會', '非游離輻射對人體健康由環保署管理', '非游離輻射對勞工影響對策由勞委會管理', '非游離輻射對環境影響及監測由環保署管理',  2),
(2174,  '中高級',  '有關臺灣河流的敘述，下列哪個選項是正確的？',  '富營養鹽的廢水流入河流，造成河流優養化，不利魚、蝦生存',  '河流下游遭受污染，連細菌都難以生存',  '河流中游因河流中的魚蝦減少，因此藻類大量生長', '河流上游水流湍急，水中溶氧量高，河流優養化，魚蝦成群', 1),
(2175,  '中高級',  '水池內某種藻類所分泌的毒素，會減緩在同水池中蝌蚪的生長。若該毒素為蛋白質生合成抑制劑，則下列哪一種細胞構造最可能是它直接作用的目標？', '細胞膜',  '核糖體',  '液胞(液泡)', '溶體', 2),
(2176,  '中高級',  '雲林縣境內的北港溪中下游水質監測數據比對分析後發現懸浮固體、生化需氣量、大腸桿菌群濃度偏高。北港溪下游的大部分污染源最可能來自下列哪兩種？',  '農牧廢水、家庭污水',  '家庭污水、金屬工業廢水',  '家庭污水、核能發電廠廢水', '農牧廢水、金屬工業廢水',  1),
(2177,  '中高級',  '人類應用海水製造淡水的最大限制為何？', '溫度', '鹽度', '洋流', '潮汐', 2),
(2178,  '中高級',  '水是一種非常重要的寶貴資源，有關水的敘述，下列哪個選項是正確的？', '是一種不可更新的資源，數量有限',  '被輻射污染過的水不能再重複使用',  '海洋鹹水含鹽分高，故不屬水資源',  '分布在陸地上的水是以固態存在的冰最多，鹹水次之',  2),
(2179,  '中高級',  '有關水資源的敘述，下列哪個選項正確？', '全球並未達到水循環的平衡', '大氣儲存了全球大量的水資源',  '赤道地區氣溫高，蒸發量大，又缺乏午後雷陣雨，是為缺水區',  '地表上的淡水資源大多儲存在冰雪中', 4),
(2180,  '中高級',  '臺灣年降水量904億立方公尺，年蒸發量294億立方公尺，河川逕流量有443億立方公尺入海，而167億立方公尺用於灌溉、工業、家庭等方面。若以上述數據，臺灣全島用水的狀況，應符合下列哪個選項？',  '達到水平衡',  '為剩水區', '為缺水區', '扣掉用水量則達到水平衡',  2),
(2181,  '中高級',  '臺灣水力資源主要是受到哪項自然環境的限制而沒有全面開發？', '河床落差太大', '河幅太寬', '流量洪枯懸殊', '河流短促', 3),
(2182,  '中高級',  '臺灣雖然降水量豐富，但可利用的水資源仍然有限，其最主要原因是下列哪個選項？',  '地處低緯，蒸發量大',  '降水的時間與空間分配很不均勻', '人口稠密，工業發達',  '農業灌溉用水量大', 2),
(2183,  '中高級',  '補充河流流量以及地下水量的補注，下列哪個選項是最主要的來源？', '湖泊補注', '降水補注', '冰原融化補注', '人工水庫補注', 2),
(2184,  '中高級',  '「水是哈尼族的農業命脈，森林涵養著水源，讓水順著盤山而下的溝渠流入村寨、從上而下漫灌層層堆疊的梯田中，最後匯入河谷底的江河湖泊，又蒸發升高，化為雲、霧、陰雨，儲存於高山森林，如此反覆，生生不已。…」這段文字主要顯示何種概念？', '水資源',  '水平衡',  '水循環',  '生態平衡', 3),
(2185,  '中高級',  '下列哪一個地區的地下水蘊藏量並「不豐富」？',  '臺中盆地', '彰化平原', '桃園臺地', '屏東平原', 3),
(2186,  '中高級',  '若一地的水庫密度較高或數量較多，則當地可能擁有何種氣候特徵？', '雨季降水強度極大', '地表河川多短小',  '年降水量極少', '乾濕季節分明', 4),
(2187,  '中高級',  '湖泊具有蓄洪功能，蓄洪能力指的是湖泊異於河流的下列哪項特性？', '水流較慢', '表面積大', '坡度較緩', '承載量較大',  2),
(2188,  '中高級',  '興建水庫對於水文歷線的影響為何？', '延長洪峰延滯期',  '增加洪峰流量', '縮短河川漲水時間', '漲水翼更形陡峭',  1),
(2189,  '初級', '下列哪一個選項是人為使用不當造成水庫無法發揮它的功能？',  '水庫淤沙', '水庫水蒸發',  '湖緣侵蝕', '水中生物增加', 1),
(2190,  '中高級',  '同一集水區的水文歷線，在相同的降水情形下，上游的土地遭人為破壞時，會有什麼變化？', '洪峰高度降低', '延滯時間變長', '洪水頻率增加', '漲水翼變緩',  3),
(2191,  '中高級',  '有關建水庫可能帶來的影響，「不包括」下列哪個選項？',  '下游河川流量減少', '導致地層下陷', '河口三角洲縮減',  '河中生物增加', 2),
(2192,  '中高級',  '河川中上游興建水庫，往往造成河口海岸地區哪種地形作用增強？',  '風化', '崩壞', '侵蝕', '堆積', 3),
(2193,  '中高級',  '興建水庫雖為增加儲水的重要方式，卻也容易帶來環境危機，以下敘述哪個選項是「不正確」的？',  '部分動植物棲息地的消失',  '輸沙量減少',  '水污染更嚴重', '上游地區侵蝕力增加',  4),
(2194,  '中高級',  '水資源日益緊缺，水的爭奪愈演愈烈，尤以流經兩國以上的國際河流，其水資源的管理和分配不當引起衝突。中國面對日益增加的水資源需求，也不斷在各河川進行開發、蓄水。中國在哪條河川的開發可能引起最多位於中下游鄰國的關切？',  '珠江', '瀾滄江',  '淮河', '黑龍江',  2),
(2195,  '高級', '熱門的泛舟地點「秀姑巒溪」切穿下列哪座山脈？', '海岸山脈', '中央山脈', '雪山山脈', '阿里山山脈',  1),
(2196,  '中高級',  '東北角海岸因有斷層通過而形成的海灣。除了斷層線通過形成岩層缺口，而出現海浪營力侵蝕的著力點之外，尚包含下列哪一種作用的發生？', '襲奪作用', '離水作用', '差異侵蝕', '岩溶作用', 3),
(2197,  '中高級',  '「河道上巨石累累，水流奔竄其間，流速湍急。」最可能描述下列哪一種河流地形景觀？',  '洪水期間的河流入海口', '枯水期氾濫平原上的曲流',  '雨季時河川的上游河道', '乾季時分水嶺附近的小溪溝', 3),
(2198,  '高級', '下列哪種河流地形較「不可能」出現水稻？',  '河階面',  '沖積扇面', '三角洲',  '曲流凸坡', 2),
(2199,  '中高級',  '相鄰的兩條河流，要發生搶水的先決條件是這兩條河流要具備下列哪一條件？', '侵蝕基準不同', '有回春作用',  '有峽谷、河階', '河流流量要增加',  1),
(2200,  '中高級',  '峽灣是因為哪一種冰河地形受海水入侵而形成的？', '冰斗', '河谷', '冰磧平原', '懸谷', 2),
(2201,  '中高級',  '海岸的形成會受到陸地相對升降，以及堆積侵蝕作用的影響。關於峽灣海岸的形成，其先後順序應為何？', '先侵蝕後沉降', '先沉降後侵蝕', '先侵蝕後上升', '先上升後侵蝕', 1),
(2202,  '中高級',  '通常河流自上游到下游可以看見下列幾種河流地形？(A)沖積扇；(B)氾濫平原；(C)三角洲；(D)峽谷。請由上游至下游順序排列。',  'DBCA', 'DACB', 'DABC', 'DCAB', 3),
(2203,  '中高級',  '當河川襲奪作用發生之後，改向河的流速通常會較原先更快，其主因是？', '河水中攜帶之物質粒徑較小', '河流坡度變陡', '河流長度增加', '河流流量流量增加', 2),
(2204,  '中高級',  '臺灣西部海岸屬於「洲潟海岸」，下列何者說明正確？', '受內營力作用', '侵蝕作用旺盛', '河川沖淤陸化', '晒鹽產業興盛', 3),
(2205,  '中高級',  '關於河流特性與侵蝕、堆積作用之間的相關性，下列哪個選項是正確的？', '河流動能大→堆積作用為主', '河流流幅窄→侵蝕作用為主', '河流流量大→堆積作用為主', '河流負荷量大→侵蝕作用為主',  2),
(2206,  '中高級',  '「位於凹岸的村落因河岸持續地侵蝕後退而被迫遷村。」文中所述的侵蝕現象，主要是哪一種河流作用所形成？',  '磨蝕', '沖蝕', '吹蝕', '溶蝕', 2),
(2207,  '中高級',  '「根據經濟部水利署的統計資料顯示2005年員山子分洪道正式啟用後，意外造成臺灣北海岸與東北角沿岸的地形發生顯著的變化。」文中提及的海岸地形變化，應以下列哪個季節最常發生？',  '春季', '夏季', '秋季', '冬季', 2),
(2208,  '中高級',  '日本、臺灣和菲律賓，都有許多地理學者針對海階地形進行研究。這些研究有助於釐清下列哪一項環境變遷議題？', '西太平洋地震帶的地震發生週期', '東亞地區活斷層的等級區分與空間分布',  '近一萬年來西太平洋海水面下降的程度',  '西太平洋洋流系統流速變化週期的分析',  3),
(2209,  '中高級',  '地表外營力作用包括風化、崩壞、侵蝕、搬運、堆積。下列地形中，哪組的外營力作用情形相同？',  '槽湖、潟湖',  '羊背石、鼓丘', '沙丘、錐丘',  '外傘頂洲、山麓沖積扇', 4),
(2210,  '中高級',  '宜蘭降水量充沛，河流經常氾濫，下列何種河流地形最「不可能」出現？', '氾濫平原', '河階', '沖積扇',  '三角洲',  2),
(2211,  '中高級',  '河流與人類的生活息息相關，也常遭到人為工程的影響而產生災害。下列哪些河流地形較「不需要」興建堤防，以維護人類正常的生活空間？', '高層河階', '氾濫平原', '曲流', '網流', 1),
(2212,  '中高級',  '就聚落形成的條件而言，在河流的曲流地形中，下列哪一個地點較容易在早期就出現聚落與商業活動，而明顯優於鄰近地區的發展？', '凹岸', '凸岸', '河中沙洲', '牛軛湖與舊河道',  1),
(2213,  '中高級',  '臺灣本島哪段海岸線的堆積作用最明顯？', '東部海岸', '西部海岸', '南部海岸', '北部海岸', 2),
(2214,  '中高級',  '臺灣西部海岸的海岸線目前有80%左右正處於侵蝕狀態，但各地海岸線後退原因各不相同。下列何處海岸線的後退主要是因地層下陷所造成？',  '臺北八里', '新竹南寮', '雲林口湖', '臺南七股', 3),
(2215,  '中高級',  '臺灣恆春地區的海岸珊瑚礁發達，但是雲嘉沿海卻少有珊瑚礁。雲嘉沿海少有珊瑚礁的主要因素為何？',  '海水深度淺',  '海水含沙量大', '海流速度快',  '日照強度強',  2),
(2216,  '中高級',  '臺灣重要的員山子分洪道工程雖對基隆河中、下游地區的洪患問題產生莫大的助益，卻也造成了些許「難題」。上述所謂的難題，應是下列哪個選項？', '夏季淡水河河口處海水鹽度大幅上升', '北海岸與東北角沿岸的灘沙地形變化失調', '基隆河上游地區洪水無法及時宣洩而發生水患', '冬天乾季時淡水河口魚群數量銳減',  2),
(2217,  '中高級',  '據臺大某教授的研究指出：「臺灣西部海岸屬於堆積性海岸，包括泥質潮汐灘地、濕地與潟湖等，都是具有高生產力的海岸地形。」其提及的「高生產力」意指下列哪個選項？',  '水稻農業', '養殖漁業', '濱海工業區',  '樟腦產業', 2),
(2218,  '中高級',  '「若依沿海陸地或海面的升降來區分，臺灣東部海岸為離水海岸。」此一論點的主要證據是下列哪個選項？',  '山地逼近於海', '海岸平原狹窄', '海岸山脈東側多海階',  '海灘多屬礫灘性質', 3),
(2219,  '中高級',  '三百年前舊安平港與臺南之間原隔著一個寬闊的潟湖，稱為臺江內海。如今內海消失殆盡，安平古堡也遠離海岸，造成此種環境變遷的主要因素為何？', '疏浚潟湖口',  '海平面下降',  '興建防波堤',  '河口淤積', 4),
(2220,  '中高級',  '「高雄地區於民國90年代之前的水泥工業蓬勃發展，其工業區位為原料，主要的原料直接取自於鄰近的壽山、半屏山區，但也因為過度的原料開採，導致半屏山地區曾發生過數次的崩塌事件。」由文中可推知，壽山地區曾發生過的地形作用「不包括」下列哪個選項？', '河流侵蝕', '風化作用', '崩壞作用', '地殼抬升', 1),
(2221,  '中高級',  '「屏東沿海地區由於養殖業者超抽地下水，造成地層下陷。」、「臺北都會區因人為建物過於密集，產生都市熱島效應。」上述的觀點，皆是以地理學的哪一種論點切入？',  '空間分布', '人地關係', '區域特色', '自然環境', 2),
(2222,  '中高級',  '一股長年經過臺灣的洋流稱為「臺灣洋流」。「臺灣洋流」是指哪一股洋流？', '親潮', '黑潮', '中國沿岸流',  '西南季風吹送流',  2),
(2223,  '中高級',  '下列哪一災害事件的發生與內營力最直接相關？',  '海平面上升',  '土石流',  '海嘯', '沙塵暴',  3),
(2224,  '中高級',  '寒流威力強大時，臺灣海峽會有烏魚大豐收；烏魚汛發生原因應與下列哪一個洋流有關？',  '黑潮', '西南吹送流',  '中國沿岸流',  '親潮', 3),
(2225,  '中級', '臺灣東岸的太平洋海域，漁業資源豐富。最主要原因為何？', '大陸棚廣大',  '眾多溪流注入', '中國沿岸流經過',  '黑潮暖流經過', 4),
(2226,  '中高級',  '下列何種方式雖能維持地力，增加產量，卻也可能引發土壤污染？',  '澆灌發酵的廚餘、便溺', '施撒氮、磷、鉀肥料',  '冬季時種植豆科植物',  '冬季時休耕或栽種牧草', 2),
(2227,  '中高級',  '地球上的各種水體，其水循環更新的速度並不相同，試問「地下水」約需幾年的更新速度？', '約8年',  '約48年', '約84年', '約840年',  4),
(2228,  '中高級',  '乾燥氣候區中增加農業生產最常見的方式為加強灌溉設施，但目前在這些地區卻發現過度灌溉，在當地造成什麼樣的環境危機？', '河川水質污染', '地面河川乾枯', '土地鹽鹼化',  '地下水遭受污染',  3),
(2229,  '中高級',  '獨立國協的哪一個地理區因引河水灌溉過度，以致河川流量銳減、湖泊縮小而產生嚴重的土壤鹽化等生態環境問題？',  '歐俄平原', '中亞低地', '西伯利亞', '高加索山地',  2),
(2230,  '中高級',  '地下水使用不當，常會造成地層下陷。下列哪個選項是造成地層下陷的最重要的因素？', '地下水污染鑿深井', '抽取地下水超過安全出水量', '乾季抽取地下水',  '開鑿深井', 2),
(2231,  '中高級',  '有關土壤污染防治，下列哪個選項的做法較為適當？',  '在受污染地區地表鋪設柏油加以覆蓋', '全面挖除被污染土壤以水泥貯槽暫存', '抽取大量海水沖刷以稀釋污染物濃度', '長時期封閉廠區讓天然雨水稀釋污染', 2),
(2232,  '中高級',  '若人類抽取的地下水量超過其安全出水量，則可能導致地表下方的岩層孔隙遭到壓縮，因而形成地層下陷的災害。下列何種地質構造的地區，其安全出水量「最小」？',  '冰磧平原地區', '河階階面地區', '古山麓沖積扇的隆起臺地區', '古湖泊盆地、地質鬆軟未固結的地區', 4),
(2233,  '中高級',  '中國土地沙漠化的問題有日趨嚴重的趨勢。原因與下列哪些事實有最直接的相關性？',  '南水北調工程已逐漸完成',  '過度抽取地下水，導致地下水位下降', '大規模推廣溫室農業生產果蔬、種籽', '經濟起飛成為世界重要新興資本市場', 2),
(2234,  '中高級',  '臺灣南部某化工廠位在溪流的出海口附近，二十幾年前關廠時，曾將大量化工產品封存在廠區內，但未做好管理和環境監測。廠區的土壤近年檢測出含有戴奧辛，附近居民體內也發現該種毒物。該地土壤中的戴奧辛進入人體的過程與下列何種現象關係最密切？', '水循環',  '潮汐變化', '侵蝕輪迴', '大氣環流', 1),
(2235,  '中高級',  '隨著自然環境的改變與人為土地利用的不當，中國沙漠化問題日益嚴重，其所引起的沙塵暴，甚至威脅到中國首都北京，故如何對抗沙漠化已成為中國近年西部大開發政策中，不可忽略的議題。中國成為全球沙漠化最嚴重的地區與哪種土地利用「不當」有關？', '石油開採造成環境污染', '牧業用地改為工廠或建築用地',  '游牧改為定牧或農耕',  '傳統游牧活動飼養多樣的牲畜',  3),
(2236,  '中高級',  '下列哪個選項「不是」環境荷爾蒙的作用機制？',  '加速神經纖維之傳導作用',  '影響生物體內荷爾蒙的運送', '中斷生物體內荷爾蒙的合成', '破壞生物體內荷爾蒙與受器的結合',  1),
(2237,  '中級', '有關環境荷爾蒙的敘述，下列哪個選項正確？', '環境荷爾蒙是造成恐龍滅絕的原因',  '人為合成的化學物質都是環境荷爾蒙', '環境荷爾蒙只要少量的分子便可發揮作用', '環境荷爾蒙對受害個體的下一代完全沒有影響', 3),
(2238,  '中高級',  '下列有關人類對環境影響的敘述，何者正確？', '優養化的結果造成溶氧量的上升', '戴奧辛目前可用遺傳工程的方法清除', '引起溫室效應最重要的氣體是臭氧',  '生物放大效應和食物網的結構有關',  4),
(2239,  '中高級',  '化學肥料的投入造成負面影響會導致何種主要問題？',  '當地地層下陷', '河川優養化',  '食品衛生堪慮', '溫室氣體減少', 2),
(2240,  '中高級',  '1990年代後期，許多專家曾經警告，美國的畜牧方式「符合一切狂牛症爆發的條件」。2003年12月23日，美國出現第一起狂牛症病例。為此，臺灣也在2009年，對開放美國帶骨牛肉進口的貿易行為爭論不休。美國「符合一切狂牛症爆發的條件」和該國哪項特色關係最密切？', '國際貿易額高', '科技化農業盛', '人口移動頻繁', '都市化程度高', 2),
(2241,  '中高級',  '下列有關人類行為與環境交互作用之敘述，何者較合理？',  '使用氟氯碳化物會破壞臭氧層',  '設置國家公園、自然保護區，是為了減少生物多樣性',  '經由生物放大(生物累積)作用，DDT造成鳥類蛋殼變硬以致無法孵化', '通常核能發電廠排出的廢水不含輻射性，所以不會影響珊瑚的生存',  1),
(2242,  '中高級',  '構造、營力、時間為地形三要素，今日大部分所見的地貌皆經歷長時期孕育而成，但下列哪種地形「例外」？', '黃土高原', '火山頸',  '火山錐',  '鐘乳石',  3),
(2243,  '中高級',  '地震災害的預測，必須先建立火災高危險區、地質軟弱區、高架道路分布路段、建築物易倒塌區等地圖，然後再做下列哪種處理？',  '視域分析', '疊圖分析', '環域分析', '迴歸分析', 2),
(2244,  '中高級',  '根據各國水資源量的統計，一地的可再生水資源代表一地由降水所產生的水資源補注情形；西亞沙烏地阿拉伯的人均用水量達1,056立方公尺，但其人均可再生水資源僅有110.6立方公尺，可能的原因是什麼？', '人口過多', '岩層堅硬，降水無法有效補注至地下水',  '石灰岩層水資源容易滲漏而流失', '降水量過低',  4),
(2245,  '中高級',  '隨著肉食消費需求的增加，牲畜畜養的數量日益增加，卻也因此造成許多負面影響，下列哪個選項是正確的？', '熱帶雨林面積減少，乳牛數量增加',  '促發草原地區的沙漠化危機', '消耗大量經濟作物，造成糧食價格上漲',  '牲畜排放許多二氧化碳，加劇全球暖化現象',  2),
(2246,  '中高級',  '今日許多自然災害的確受到若干人為因素的影響，可視為自然和人為力量互動的結果。下列哪種地形的災害較「不符合」人禍誘發天災的定義？',  '南投陳有蘭溪流域的土石流', '屏東林邊地區的地層下陷',  '彰化員林地區因土壤液化而造成的地層凹陷',  '新北市臺北商港南側的沙洲縮小', 3),
(2247,  '中高級',  '「熱帶國家人們的工作節奏比溫帶地區來得緩慢，休息次數也較多；有人推論，熱帶與溫帶工作者精力與效率上的差異，是因為氣候條件不同所致。」上述看法比較接近哪一種地理觀點？', '環境決定論',  '環境可能論',  '環境協調論',  '環境生態論',  1),
(2248,  '中高級',  '20世紀時，美國科羅拉多河流域的土地侵蝕速率，比16至18世紀的平均值增加大約6倍。當地土壤侵蝕率的增加，與下列哪項經濟活動關係最密切？', '露天開採煤礦', '放牧飼養牛隻', '採伐天然森林', '機械耕種小麥', 2),
(2249,  '高級', '臺灣生物物種相當豐富，請問目前約有多少物種呢？',  '3,000種', '30,000種',  '56,000種',  '83,000種',  3),
(2250,  '中高級',  '近年全球環境變遷，中國大陸西北土地沙漠化情況嚴重，致使臺灣地區每逢冬春之交，常見沙塵暴災害。臺灣近年在颱風來臨前或東北季風盛行期間，也常出現地區性的沙塵事件。上述臺灣的地區性沙塵事件，最可能發生在何種環境？',  '平原耕作地',  '山區崩塌地',  '河口灘地', '沼澤灘地', 3),
(2251,  '中高級',  '現代農業漸有自「高度專業化」修正為「雜異化」的趨勢，下列可能的影響原因，哪個選項「錯誤」？',  '量產價跌風險\n', '天災慘賠風險', '基因改造使得原區位優勢不再',  '該地地力枯竭的風險',  3),
(2252,  '中高級',  '臺灣目前生態農業日益興盛的原因，下列哪個選項「無」直接關係？', '開始注重生態永續發展', '追求健康飲食方式', '農業用地面積的減少',  '農業產銷策略的變更',  3),
(2253,  '中高級',  '酸雨的污染源(二氧化硫和氮氧化物)排放最多的地方在華北地區，但酸雨最嚴重的地方卻在四川盆地、雲貴高原。造成此種差異最主要原因為何？',  '緯度高低', '盛行風向', '地勢高低', '晝夜溫差', 2),
(2254,  '中高級',  '「有機農業是不允許使用化學合成物質，強調水土資源保育與生態平衡之管理系統，並達到生產自然安全農產品目標之農業。」根據此一定義，下列哪個選項的農業經營方式較「不符合」有機農業的精神？', '採用翻土，地面覆蓋塑膠布方式，防止雜草叢生',  '大規模機械化耕作，種植單一作物',  '培育多樣化的土壤微生物，昆蟲和鳥類，使用捕蟲裝置，架設網室保護農作物，以減少病蟲害',  '施用以禽畜排泄物和廢棄的農作物做成的堆肥', 2),
(2255,  '中高級',  '「屏東萬丹有三多：苦瓜、紅豆與乳牛。」這句話是採取下列哪一個地理觀點？',  '空間分布', '人地關係', '區域特色', '自然環境', 3),
(2256,  '中高級',  '影響熱帶雨林地區植物呈現垂直分層現象的原因為何？', '降水需求的多寡',  '養分獲取的多寡',  '陽光需求量的多寡', '土壤的肥沃程度',  3),
(2257,  '中高級',  '「世界綠色和平組織」對日本使用東南亞熱帶雨林資源的一則報導：日本國禁止伐木，卻大量使用免洗筷，並有過度精緻包裝的文化；木材進口量年年增加，……，而這些木材主要來自東南亞地區。上述報導主要批判是下列何者？',  '鼓勵國內大量消費木材製品及紙類包裝',  '保育本國資源卻大肆使用他國森林資源',  '視木材為該國與東南亞國家的貿易商品',  '對森林資源的保育態度積極', 2),
(2258,  '中高級',  '為保護每年至七股濕地過冬的黑面琵鷺，保育人士積極建議中央設立生態保護區，其中劃設周邊「緩衝區」之範圍，應以何種分析方法最適當？',  '環域分析', '疊圖分析', '視域分析', '路網分析', 1),
(2259,  '中高級',  '下列何者「不是」臺灣物種遭受外來物種入侵的影響？', '松樹受到松材線蟲威脅', '櫻花鉤吻鮭棲息地遭到破壞', '福壽螺侵害臺灣稻田',  '梨樹嫁接受到梨木蝨病侵襲', 2),
(2260,  '中高級',  '福壽螺對臺灣何種作物危害最深？',  '甘藷', '水稻', '甘蔗', '玉米', 2),
(2261,  '中高級',  '「熱帶雨林和季風雨林最大的差異是：前者林木高大繁密，藤蔓密布；後者則林冠稍稀，灌木叢生。」導致這種差異的主要因素是什麼？', '降水量的多寡', '日照的強弱',  '乾季的有無',  '降水強度的大小',  3),
(2262,  '中高級',  '下列哪種人類活動能有助於降低崩壞現象的發生？(A)改種淺根植物；(B)建設產業道路；(C)鋪設坡地排水系統；(D)森林復育。', 'AD', 'AC', 'CD', 'BC', 3),
(2263,  '中高級',  '在哪一個國家公園可以同時觀察到石灰岩地形和雨林？', '陽明山',  '雪霸', '太魯閣',  '墾丁', 4),
(2264,  '中高級',  '到哪座國家公園最適合考察臺灣的石灰岩地形？',  '玉山國家公園', '陽明山國家公園',  '金門國家公園', '墾丁國家公園', 4),
(2265,  '中高級',  '下列哪個選項對維持生物多樣性是有害的？',  '適當復育梅花鹿',  '設置自然保護區',  '野生動物保育工作', '消滅產量或品質不佳之農作物品種',  4),
(2266,  '中高級',  '當全球海平面皆顯著上升時，對臺灣造成最直接的環境衝擊為何？',  '黑面琵鷺現有棲息地面積縮減',  '附近海域珊瑚礁種類增加',  '南部沿海地區地層下陷量減少',  '各河川泥沙搬運量增加', 1),
(2267,  '中高級',  '石灰岩地形的演育可分為：(A)殘丘；(B)滲穴；(C)窪盆；(D)錐丘。依照時間先後順序，正確的排列是下列哪個選項？', 'ABCD', 'BCDA', 'CBDA', 'CBAD', 2),
(2268,  '高級', '沙漠、礫漠和岩漠同為植物稀少的荒涼地區，但地表自然景觀上有明顯差別，其主因為何？', '緯度高低不同', '地質構造不同', '降水量多寡的差異', '堆積或侵蝕的不同', 4),
(2269,  '中高級',  '極區、熱帶雨林和沙漠邊緣等，這些區域內的糧食生產與穢物容納量具有一定限度。」此一限度稱為什麼？',  '自然恢復力',  '環境生產力',  '自然穩定力',  '環境負載力',  4),
(2270,  '中高級',  '影響作物生長的因素有自然方面及人文方面兩種，形成中、低緯度地區作物種類不同的區位差異，主要的影響因素是下列哪個選項？', '人文環境', '政府政策', '耕作技術', '自然環境', 4),
(2271,  '中高級',  '擦痕是冰河滑動時磨擦岩壁所產生的痕跡。下列冰河地形中哪個選項「找不到」擦痕？', '冰斗', '冰河谷',  '羊背石',  '鼓丘', 4),
(2272,  '中高級',  '下列哪個選項是形塑「溶蝕地形」的主要環境條件？',  '氣候乾燥', '地形崎嶇', '地下水位低',  '花崗岩遍布',  3),
(2273,  '中高級',  '在作物收成後，將殘株混入土中並加以翻土，讓農田在隔年休耕，關於這樣的休耕方式對農田的生態環境帶來什麼影響？',  '提高土壤肥力', '避免連年種植同一作物，但無法減少病蟲害',  '使土壤密實，減緩土壤侵蝕', '翻動表土，加速土壤母質風化速率',  1),
(2274,  '中高級',  '昔日歐洲探險家從澳洲西岸登陸，在遊記中記載，澳洲地區岩層裸露，礫石遍布，探險者看到的景觀最有可能是下列哪個選項？', '冰積地形', '冰蝕地形', '風積地形', '風蝕地形', 4),
(2275,  '中高級',  '森林的採伐會造成水土流失現象，許多開發中國家因為經濟上的壓力而過度墾殖，造成水土流失嚴重。位於溫帶地中海型氣候區的開發中國家，其墾殖後之河川與墾殖前相比，最「不可能」出現下列哪種變化？', '一年中河川最高與最低水位之差值變大',  '冬季時河水平均流速變快',  '夏季時河水平均流量變多',  '豪雨時洪峰到達時間縮短',  3),
(2276,  '中高級',  '人類常會利用各種地形從事適合的活動，下列何種開發「不是」源自於地殼曾經有過的隆升作用？',  '半屏山的水泥工廠', '蘇澳港的漁業大樓', '花東海階上的聚落', '長濱海蝕洞內的廟宇',  2),
(2277,  '中高級',  '「日月潭原為天然斷層湖泊，後因興建成水庫，水位增高而成人工湖泊，此一改變除造成生態的破壞外，也讓當地原居民幾乎搬遷殆盡。」上述的議題分析應用了地理學的哪個觀點？', '空間分析', '生態分析', '區域複合體分析',  '綜合分析', 2),
(2278,  '中高級',  '下列哪一項措施對減緩黃河中上游地區的水土流失最為有效？',  '將耕地退至防風林的背風側', '減少耕作土地的時間',  '將耕地範圍縮小至都市周圍', '停止耕作陡峻的坡地',  4),
(2279,  '中高級',  '在學習冰河地形的過程中，瞭解蛇丘、鼓丘、外洗扇等小地形的分布，有助於釐清下列哪個選項的問題？', '冰河移動的速度',  '冰河冰的厚度', '冰河的壽命',  '冰河消融的方向',  4),
(2280,  '中高級',  '研究指出濁水溪上游的支流陳有蘭溪，因有少數農民的私人農業墾殖行為，常導致河川自然災害頻生。農民的圍墾活動對於河流的主要影響是下列何者？',  '提高河流的坡降',  '增加河川流量', '擴大滯洪區面積',  '縮小行水區範圍',  4),
(2281,  '中高級',  '海岸的變遷深受波浪作用和沿岸漂沙的影響。下列哪一種人類活動有助於減緩海岸侵蝕？',  '河川抽沙', '抽取地下水',  '河川興建防砂壩',  '海岸種植紅樹林',  4),
(2282,  '中高級',  '臺灣山區路況不佳，經常有道路坍方，阻斷往來交通，下列何者「不是」造成坍方的主要原因？', '臺灣屬新褶曲山地，山高谷深',  '臺灣高溫多雨，風化盛行',  '臺灣多暴雨',  '山坡地做好水土保持',  4),
(2283,  '中高級',  '臺灣地區時有山崩發生，下列何者「不是」臺灣山崩的主因？',  '臺灣地處地殼不穩定處', '臺灣山地面積廣，地勢陡峭', '地處高溫多雨之地，化學風化物質多', '春季雪水多，增加潤滑力',  4),
(2284,  '中高級',  '臺灣的山坡地因過度墾殖而水土流失嚴重，為解決此一問題，政府正積極推動山坡地造林工作。如果山坡地全部退耕還林，河川最可能出現下列哪一種變化？',  '豪雨時洪水水位變高',  '夏季時河水流速加快',  '冬季時河水流量增多',  '暴雨時洪峰到達時間縮短',  3),
(2285,  '中高級',  '下列何者的人類活動最容易造成崩壞現象的發生？', '加強水土保持', '將原始林改種茶樹', '鋪設坡地排水系統', '緩坡地闢建梯田',  2),
(2286,  '中高級',  '下列兩者之間的作用，哪一組呈正比關係？',  '物理風化程度、溫差',  '河流流速、流幅',  '崩壞速度、河川流速',  '侵蝕程度、重力作用',  1),
(2287,  '中高級',  '下列哪種地形是同時受到內、外營力作用所形成的？',  '地壘', '火山', '蜂窩岩',  '方山', 4),
(2288,  '中高級',  '山崩、土石流的發生地區大多具備下列哪些環境特徵？(A)有斷層；(B)坡度陡峭；(C)土石緊密；(D)降水強度大。', 'AB', 'BC', 'AD', 'BD', 4),
(2289,  '中高級',  '「臺灣在地質上看來算是相當年輕的島嶼，地層的不穩定使得島上的地形較為破碎，形成多變的地貌。」下列哪個選項中與臺灣年輕的地質年代有直接相關？',  '生物種類繁多', '山脈多呈現南北縱走',  '河流東西分流', '相對高度落差大',  4),
(2290,  '中高級',  '內營力為形成地表原始面貌的主要力量，下列地形中，何者是地球內營力所造成的？',  '澎湖群島', '東北海岸的蕈岩',  '雲貴高原的石灰岩地形', '黃土高原的黃土',  1),
(2291,  '中高級',  '火山活動為人類帶來災害，也帶來資源。下列何者「不是」火山活動所提供的資源？',  '豐富礦藏', '水力發電', '地熱溫泉', '肥沃土壤', 2),
(2292,  '中高級',  '1999年9月21日的大地震使堀?山發生「走山」現象，大量落石阻塞清水溪上游，造成「新草嶺潭」，這個過程及景觀是由下列哪種營力直接形成？', '河蝕', '風化', '崩解', '崩壞', 4),
(2293,  '中高級',  '在高山或高緯的冰緣區會產生土石緩滑的現象，土石會依粒徑大小重新做有規則之移動堆積，主要是受何種作用所造成的？', '凍裂作用', '崩落作用', '膠結作用', '重力淘選作用', 4),
(2294,  '中高級',  '和地球的年齡相比，湖泊在地表只是短暫的現象。下列哪個選項的湖泊壽命「最短」？', '斷層湖',  '火山的火口湖', '冰河的槽湖',  '山崩的堰塞湖', 4),
(2295,  '中級', '綠島的朝日溫泉，泉水自海岸邊的礁石湧出，海底溫泉的成因最可能是下列哪個選項？', '大陸棚廣大',  '珊瑚礁廣布',  '具有如黑潮的暖流經過', '位於板塊接觸帶上', 4),
(2296,  '中高級',  '關於外營力的作用，下列何者的組合是正確的？',  '外傘頂洲的縮減-堆積', '臺江內海的陸化-侵蝕', '南橫公路落石坍塌-崩壞',  '濱海公路路基流失-風化',  3),
(2297,  '中高級',  '下列何種崩壞作用最「不可能」出現在臺灣？', '潛移', '山崩', '土石流',  '土石緩滑', 4),
(2298,  '中高級',  '土石流(不含火山噴發引起者)是下列哪兩種營力交互作用形成的？', '風化和崩壞',  '風蝕和堆積',  '溶蝕和塌陷',  '風力和河流',  1),
(2299,  '中高級',  '今年夏天颱風特別多，西南氣流引進豪雨，在山區引起多起土石流災害，下列何者因素與引致土石流「無直接」關連？', '岩層水平排列', '山區植被減少', '多地震且岩層鬆軟', '坡度大之狹窄溝谷', 1),
(2300,  '中高級',  '新中橫公路開闢後，這裡的果園和房舍災害頻傳。在沖積扇堆積區最常見的是哪種自然災害？',  '土石流',  '土壤潛移', '落石', '地震', 1),
(2301,  '中高級',  '臺灣山區的自然災害，以何種地形作用為多？', '風化作用', '崩壞作用', '溶蝕作用', '褶曲作用', 2),
(2302,  '中高級',  '下列何者是最可能「減少」土石流災害的作為？',  '山地開發農場', '河谷興建防砂壩',  '山區闢建道路', '平原農田轉種檳榔', 2),
(2303,  '中高級',  '以林邊溪口一帶為例，', '11至4月間地層下陷率快；5至10月間地層下陷慢甚至停止，專家指出造成林邊溪口季節不等量的下陷同時有內、外營力交互作用著，關於此現象的敘述下列何者是正確的？', '板塊運動呈現季節性的不等量運動',  '沿海屬於離水侵蝕進夷的海岸',  '雨季時地層下陷減緩是因地下水受到補注', 0),
(2304,  '中高級',  '近年來每當颱風或豪雨來襲，臺灣總有土石流或山崩等崩壞現象發生，下列何者最「不可能」是造成臺灣崩壞地形之主要原因？', '降雨集中率高', '山地高坡度陡', '平原土地開發及利用失當',  '地震造成土石鬆動', 3),
(2305,  '中高級',  '近年來臺灣常發生嚴重的土石流災害，其原因與一直以來山區的人為活動有關，下列何處較「不可能」見到土石流的災害？', '河谷的谷口',  '山麓沖積扇的扇頂', '伏流的吞口',  '河川上游野溪匯入處',  3),
(2306,  '中高級',  '臺灣的環境災害案例中，下列何者與板塊運動最直接相關？', '1999年石岡壩毀損', '西南沿海地層下陷', '南投山區土石流',  '東部海岸線後退',  1),
(2307,  '中高級',  '調查臺灣河流，很容易發現：河流上游人煙稀少處大多水質清澈，中游岸邊開始有人類社區出現，水中藻類增加，水色偏綠且透光度下降，魚蝦數量減少；到了下游，兩岸建築林立，河水污濁發臭，魚蝦幾乎絕跡。下列敘述何者正確？',  '富營養鹽的廢水流入河流，造成河流優養化，不利魚蝦生存', '河流上游水流湍急，水中溶氧量高，河流優養化，魚蝦成群', '河流中游因河流中的魚蝦減少，因此藻類大量生長', '河流下游遭受污染，連細菌都難以生存',  1),
(2308,  '中高級',  '近年來由於臺灣人為開發邊際土地的強度遽增，因而導致了日益頻繁的地形災害，下列何者「不是」造成土石流的人為因素？',  '道路興築', '伐木產業', '山邊溝興修',  '採礦產業', 3),
(2309,  '中高級',  '下列哪個選項是全球高地氣候分布區的共同特徵？', '都是人口密集區',  '都是高緯度區', '都是古老穩定的地層',  '都是相對較年輕的地層', 4),
(2310,  '中高級',  '臺灣北部產硫磺與該地哪一地形(地質)作用有關？',  '海水侵蝕', '火山作用', '沉水為海灣',  '石灰岩地形',  2),
(2311,  '中高級',  '下列哪個選項中的資源利用和珊瑚礁海岸「無關」？',  '半屏山水泥工業',  '澎湖咾咕石防風牆', '東北角海岸九孔養殖',  '墾丁國家公園洞穴鐘乳石景觀',  3),
(2312,  '中高級',  '沙漠的生成與地理環境密切相關，全球的沙漠以位於下列哪一區位所占的面積最大？',  '深處內陸者',  '背盛行風者',  '位於副熱帶高壓帶下方者',  '涼流經過者',  3),
(2313,  '中高級',  '沙漠景觀又可區分成岩漠、礫漠、沙漠。該分類是根據哪一項特徵？', '緯度高低', '顆粒大小', '溫差大小', '面積大小', 2),
(2314,  '中高級',  '岩石經過漫長的時間會風化成為土壤，則下列哪一作用可能會造成岩石成分改變？', '物理風化', '化學風化', '重複乾濕', '岩漿入侵', 2),
(2315,  '中高級',  '臺灣中北部的礫石臺地，如八卦山、新竹湖口、臺北林口等，普遍分布著偏酸性的紅色土壤，主要是經由何種成土作用形成的？', '澱積作用', '鈣化作用', '淋溶作用', '灰化作用', 3),
(2316,  '中高級',  '關於維護土壤肥力，防止土壤侵蝕有許多方法。開闢梯田或沿等高線種植，其主要的目的是下列哪個選項？',  '加速水分下滲', '防止風化進行', '減小營力進行', '保持土壤肥力', 3),
(2317,  '中高級',  '關於維護土壤肥力，防止土壤侵蝕的觀念，下列哪個選項是正確的？', '耕作應與風力方向平行', '對已種植的土地應持續同一作物', '坡地要平行等高線種植', '坡地排水宜自山頂直接將水排至山腳', 3),
(2318,  '中高級',  '下列哪個選項「不是」生物對於土壤化育的影響？', '石灰岩的溶蝕作用而形成石筍',  '人類的農業活動而形成水稻土',  '螞蟻、蚯蚓等動物鑽出洞穴以增加土壤化育的速度', '微生物分解動物遺骸而形成有機質',  1),
(2319,  '高級', '一度水相當於多少公升的水？',  '1公升',  '10公升', '100公升',  '1,000公升',  4),
(2320,  '高級', '下列哪句成語有節約用水的意涵？',  '水深火熱', '近水惜水', '巴山蜀水', '愛才若渴', 2),
(2321,  '中級', '下列哪種想法符合永續發展的概念？', '順應自然萬物生長的時序，即可取之不盡，用之不竭',  '取之不留餘地，只顧眼前利益，不看長遠利益', '不必為未來的事準備，當問題到了才想辦法',  '順應自然萬物生長的時序，按人類的需求，將資源隨意取用', 1),
(2322,  '高級', '下列哪個選項「不符合」永續發展的價值觀？', '使用一次性免洗餐具',  '努力達成二氧化碳減量目標', '限制各國進行瀕臨絕種的野生動物交易',  '使用再生能源', 1),
(2323,  '高級', '隨著人類社會經濟發展，各項天然資源被大量使用，哪種天然資源「不再」被免費使用並成為21世紀最重要「戰略物資」？',  '水',  '風',  '天然氣',  '石油', 1),
(2324,  '高級', '依照永續能源政策網領，臺灣於2025年的二氧化碳排放應回到哪一年的水準？', '2000年',  '1995年',  '2005年',  '2010年',  1),
(2325,  '高級', '關於永續家園發展的敘述，下列何者正確？',  '經濟發展重要', '環境保護重要', '社會發展重要', '以上皆是', 4),
(2326,  '高級', '下列哪個選項「不是」永續發展的內涵？', '人類發展不超出環境負載力', '發展綠色科技及替代技術減輕環境負荷',  '促成地球村概念的落實，加強國際合作',  '以環境保護為導向，降低人類的生活品質', 4),
(2327,  '高級', '永續發展的理念「不應」考慮下列何者？', '環境承載力',  '國際政治妥協', '環境保護', '社會公平正義', 2),
(2328,  '高級', '一座能讓植物自由生長並能讓蚯蚓或小昆蟲在地下生存，還能讓雨水順利滲透到地底下儲存的停車場，符合下列哪一項建築指標？',  '生物多樣性指標',  '基地保水指標', '綠化量指標',  '二氧化碳減量指標', 2),
(2329,  '高級', '商品製造消耗的用水量，我們如何稱呼？', '水耗量',  '水足跡',  '水商品',  '水能量',  2),
(2330,  '高級', '何謂水足跡，下列哪個選項是正確的？',  '消費者所購買的商品，在生產過程中消耗的用水量', '水利用的途徑', '水循環的途徑', '每人每日用水量紀錄',  1),
(2331,  '高級', '下列哪個選項有助於「降低」環境中的二氧化碳濃度？', '使用傳統建築工程的材料',  '建築物建材使用再生環保建材',  '建築應設計誇張外貌增加工程難度',  '使用大型建築結構體增加美觀',  2),
(2332,  '高級', '家電產品貼上「節能標章」圖樣，代表其能源效率比國家認證標準高出多少百分比(%)？', '0-10%',  '10-15%', '15-20%', '20%以上',  2),
(2333,  '高級', '購買海鮮食品時，下列何者是「錯誤」的？',  '不買非法捕殺的海洋生物',  '越珍貴的海鮮越好吃',  '不食用被污染的海洋生物',  '不購買保育類的海洋生物',  2),
(2334,  '高級', '自備手帕及購物袋等，是屬於綠色消費的哪一種行為，下列哪個選項正確？',  '減量使用', '環保選購', '回收再生', '以上皆是', 1),
(2335,  '高級', '節約用水與用電是屬於綠色消費中的哪種行為？',  '環保選購', '減量', '重複使用', '回收再生', 2),
(2336,  '高級', '建築物設計施工時，要如何才能符合環保要求？',  '使用再生環保建材', '使用傳統水泥建築', '使用高耗能建材建築',  '使用鋼骨結構建築', 1),
(2337,  '高級', '下列何項「不屬於」內政部營建署的建築標章？',  '住宅性能標章', '環保標章', '綠建材標章',  '智慧建築標章', 2),
(2338,  '高級', '不購買「不必要、過度包裝、不能重複使用」的商品，可歸類為下列何種消費行為？',  '節約消費', '經濟消費', '綠色消費', '減量消費', 3),
(2339,  '高級', '下列何者是「機關優先採購環境保護產品辦法」所規範第二類環境保護產品所需資格?', '取得環保署認可之環保標章使用許可', '產品非屬之環保標章產品，經認定符合環保節能等條件，並獲得證明者',  '取得我國承認之外國環保標章使用許可者', '經認定符合「增加社會利益或減少社會成本」之產品者', 2),
(2340,  '高級', '對於日常節能行為的敘述，下列何者是「錯誤」的？',  '多吹自然風，關閉空調冷氣', '使用通過節能標章產品', '無人使用的空間應該關閉燈光',  '避免使用太陽能板產生電力，以免浪費資源',  4),
(2341,  '高級', '建築物開窗設計「內倒窗」能夠快速排出室內混濁空氣，是利用下列哪個原理？',  '對流', '輻射', '傳導', '反射', 1),
(2342,  '高級', '如果溫室效應太嚴重造成格陵蘭島冰原全部融化，可能「不會」有下列哪個現象發生？', '全球平均海水鹽度增加', '全球陸地面積減少', '海平面上升',  '溫鹽環流停止', 1),
(2343,  '中級', '下列哪種作法有助於「減緩」酸雨的形成？',  '提升國內自產油料比例', '鼓勵民眾改乘大眾運輸工具', '提高工廠排放廢水標準', '鼓勵汽機車使用高級汽油',  2),
(2344,  '高級', '《不願面對的真相》一書中講述有關全球暖化之議題，該書作者是誰？',  '歐巴馬',  '柯林頓',  '陳文茜',  '高爾', 4),
(2345,  '中高級',  '下列哪一種氣體「不會」累積在大氣層中？',  '氧化亞氮', '臭氧', '水蒸氣',  '甲烷', 3),
(2346,  '中級', '下列哪個選項可「減緩」大氣層中二氧化碳濃度的增加？',  '火山爆發', '生態保育', '都市化開發',  '多用化石燃料', 2),
(2347,  '中高級',  '關於「溫室效應」的敘述，下列哪個選項最正確？', '從太陽輻射的紫外線被二氧化碳吸收', '從太陽輻射的紅外線被一氧化碳吸收', '從地面輻射的紅外線被二氧化碳吸收', '從地面輻射的紫外線被二氧化碳吸收', 3),
(2348,  '高級', '下列哪個選項是已開發國家所面臨最主要的環保問題？', '隨意亂丟垃圾', '減少二氧化碳排放', '地層逐日下陷', '隨地胡亂吐痰', 2),
(2349,  '中級', '下列哪個選項會造成氣候暖化的現象？',  '火山噴發，火山灰遮蔽陽光', '風化作用增強', '太陽黑子活動減弱', '人類活動增加', 4),
(2350,  '高級', '下列哪個選項「不是」引起全球暖化的主要氣體？', '一氧化二氮',  '二氧化碳', '氮氣', '氟氯碳化物',  3),
(2351,  '初級', '下列哪種方式是正確的節約能源方式？',  '將室內空調冷氣開到強冷',  '住家屋頂種植植物以降低室溫',  '將空調冷氣開啟並將門窗打開',  '將室內風扇全天候打開', 2),
(2352,  '高級', '南極洲的冰和雪是地球上最大的淡水庫，全球90%的冰雪儲存在這裡，佔整個地球表面淡水儲量的72%。過去50年來，南極洲半島的暖化速度冠於全球，並帶來環境災害。關於全球暖化現象的敘述，何者為「錯誤」？', '導致冰帽不穩滑入海灣，而海水吸收陽光熱能，會造成越多冰塊融解成水', '', '冰塊融解成水使得附近的海水溫度不但不會降低，反而會升高，形成惡性循環', '平均海平面上升，將導致地表較低點的陸地被淹沒', 0),
(2353,  '中高級',  '下列哪個選項「不是」酸雨可能造成的危害？', '樹木生長緩慢', '鐵軌腐蝕', '土質變化', '地層下陷', 4),
(2354,  '高級', '關於臭氧層的破壞對生物造成的主要影響，下列哪個選項是正確的？', '促進生物的生長',  '增加DNA突變的機會', '抑制癌症的發生',  '降低生物受紫外線的傷害',  2),
(2355,  '高級', '對於臭氧層的敘述，下列哪個選項是「錯誤」的？', '臭氧集中在平流層，可阻隔輻射', '人類所製造的氟氯碳化物會破壞臭氧', '臭氧洞主要發生在初夏，尤其以北極最為嚴重', '1987年於加拿大簽署的「蒙特婁議定書」達成了保護大氣層的協議',  3),
(2356,  '中高級',  '下列哪個選項是造成全球暖化的原因及其所造成的現象？',  '氧氣與氮氣增加；造成海平面上升',  '氧氣與氮氣增加；造成海平面下降',  '二氧化碳與甲烷增加；造成海平面上升',  '二氧化碳與甲烷增加；造成海平面下降',  3),
(2357,  '高級', '有關太陽輻射，下列何者是正確的描述？', '主要被臭氧和二氧化碳吸收', '部分穿透大氣到達地表', '主要被水氣和二氧化碳吸收', '主要被臭氧和氧反射',  2),
(2358,  '高級', '全球暖化「不會」造成下列哪個選項的問題？', '海平面上升',  '異常氣候', '環流系統改變', '北極冰原增加', 4),
(2359,  '中級', '全球急遽暖化可能造成的影響有哪些，下列哪個選項正確？', '海平面上升，陸地縮小', '極端氣候發生頻率增高', '生物生態環境改變，有些物種絕滅',  '以上皆是', 4),
(2360,  '高級', '臭氧層耗盡對人體健康及環境之影響，下列哪個選項是「錯誤」的敘述？', '人類皮膚癌罹患率的增加',  '人體白內障罹患率減少', '免疫系統受抑制',  '農作物減產',  2),
(2361,  '高級', '所謂全球暖化現象是指下列哪個選項？',  '全球性的平均氣溫上升', '可能會造成海平面下降險象', '影響時間為2至3年',  '與聖嬰現象週期相當',  1),
(2362,  '高級', '下列哪個選項「不是」目前全球所面臨的環境課題？',  '溫室氣體逐年增加', '豪雨引發土石流事件',  '臭氧洞持續擴大',  '燃燒化石燃料釋放二氧化碳造成酸雨', 2),
(2363,  '高級', '目前臺灣以哪一種發電方式供應最多的發電量？',  '風力發電', '水力發電', '火力發電', '太陽能發電',  3),
(2364,  '高級', '臺灣海邊有時會看到白色像風車一樣的機器是下列哪種設施？',  '風力發電機',  '水車', '核能發電機',  '火力發電機',  1),
(2365,  '高級', '下列哪個選項是屬於永續利用的天然資源？',  '風力', '煤',  '天然氣',  '石油', 1),
(2366,  '高級', '關於可再生資源的敘述，下列哪個選項是正確的？', '可以循環利用', '會愈用愈少',  '要經過千萬年才能自然形成', '石油是其中一種',  1),
(2367,  '高級', '下列何者「不屬於」再生能源？', '海洋能',  '燃煤', '生質能',  '地熱能',  2),
(2368,  '高級', '關於太陽能的敘述，下列哪個選項是「錯誤」的？', '是利用太陽的熱源提供做為能源', '太陽能的供應源源不斷，是一種非常潔淨的能源',  '不受天氣的影響',  '較不會污染環境',  3),
(2369,  '高級', '臺灣的能源問題「不包括」下列哪個選項？',  '沒有開發其他新能源',  '能源使用效率低',  '能源過度集中於化石燃料',  '電價太高', 4),
(2370,  '高級', '六輕工業區位於臺灣的哪個縣市？',  '彰化', '雲林', '嘉義', '臺南', 2),
(2371,  '高級', '有關臺灣海洋能源發展，下列哪個選項是「錯誤」的？', '臺灣東部適合發展海洋溫差發電', '臺灣西部的港口潮差大，適合發展潮差發電',  '臺灣東北部海岸適合發展波浪能', '臺灣東部海岸的黑潮洋流強勁，適合發展海流能',  2),
(2372,  '高級', '有關能源的敘述，下列哪個選項是正確的？',  '氫氧燃料電池的發電原理與傳統的水力發電相同，兩者在其發電過程中均不污染環境',  '太陽能電池是利用光能產生電流，理論上會消耗物質',  '核能是指核分裂或核融合時所產生的能量，並遵守質量不滅定律', '潮汐發電、波浪發電、洋流發電、海洋溫差發電等均屬於海洋能源',  4),
(2373,  '高級', '高雄捷運是臺灣第二座啟用的大眾捷運系統，於民國幾年開始營運與通車？',  '民國99年',  '民國98年',  '民國97年',  '民國96年',  3),
(2374,  '高級', '臺灣高速鐵路於民國哪一年正式通車？',  '民國94年',  '民國95年',  '民國96年',  '民國97年',  3),
(2375,  '高級', '核四廠位於下列哪一個縣市？',  '新北市',  '臺北市',  '臺東縣',  '屏東縣',  1),
(2376,  '高級', '近代農業專家應用科學技術進行「綠色革命」，改變了農業活動的分布，其帶來最大的影響為下列何者？', '縮小了貧富差距',  '減少了環境污染',  '延長了作物的成長期',  '擴展了作物的種植範圍', 4),
(2377,  '中高級',  '下列何者是政府為配合「京都議定書」所提倡的活動？', '多吃肉少吃蔬菜',  '研究再生能源', '垃圾不落地',  '清淨家園', 2),
(2378,  '高級', '臺灣降雨集中在哪些月份？', '1~3月', '3~5月', '5~10月',  '10~12月', 3),
(2379,  '高級', '臺灣的梅雨季節為何月？',  '3、4月', '5、6月', '7、8月', '9、10月',  2),
(2380,  '高級', '臺灣在哪個季節降雨量最少？',  '春',  '夏',  '秋',  '冬',  4),
(2381,  '高級', '我國全年降雨並不缺乏，在全世界屬於降雨剩水區，但下列那一地區降雨特別少？', '澎湖', '高雄', '臺中', '基隆', 1),
(2382,  '高級', '臺灣平均年雨量約為世界各國平均值的幾倍？', '26倍',  '13倍',  '2.6倍', '1.3倍', 3),
(2383,  '高級', '全球最大體積的淡水以何種型態存在？',  '冰',  '地下水',  '水蒸氣',  '河川', 1),
(2384,  '高級', '形成潮汐現象的主要原因為何？', '風的力量', '月球的吸引力', '海水的溫度',  '海岸的高低',  2),
(2385,  '高級', '空氣中水氣之主要來源為何？',  '海洋', '冰地', '河流', '植物', 1),
(2386,  '高級', '秋颱常會形成共伴效應，為臺灣帶來大量雨水，共伴效應的形成，通常是颱風和下列哪個現象共同形成的？',  '東北季風', '西南季風', '落山風',  '焚風', 1),
(2387,  '高級', '臺灣平均年雨量約多少毫米？',  '2,500毫米',  '4,000毫米',  '1,830毫米',  '3,322毫米',  1),
(2388,  '高級', '關於臺灣氣象中冷暖氣團勢力消長的敘述，下列哪個選項是正確的？', '梅雨時，暖氣團勢力大於冷氣團', '寒流時，暖氣團勢力大於冷氣團', '梅雨時，暖氣團勢力小於冷氣團', '寒流時，暖氣團勢力小於冷氣團', 4),
(2389,  '高級', '預測24小時內颱風暴風範圍可能侵襲臺灣或金門、馬祖，氣象局會發布什麼警報？',  '海上颱風警報', '陸上颱風警報', '解除颱風警報', '豪雨警報', 1),
(2390,  '中級', '對於空氣污染的防治，下列哪個選項是正確的？',  '土石車不須加蓋防塵布', '建築工地不需加裝防塵網',  '建築施工車輛使用專用清潔措施', '建築廢棄土任意丟棄',  3),
(2391,  '高級', '有關臭氧的敘述，下列哪個選項是正確的？',  '臭氧是無色無臭的氣體', '大部分臭氧集中在增溫層',  '臭氧吸收紫外線造成溫室效應',  '人類大量使用氟氯碳化物是破壞臭氧層的主因', 4),
(2392,  '高級', '為了保護臭氧層，下列哪個做法是正確的？',  '購買使用氟氯碳化合物之產品',  '持續使用氟氯碳化合物製成之發泡劑', '電子業採用CFCs清潔技術',  '減少氟氯碳化物直接排放至大氣層',  4),
(2393,  '高級', '空氣污染指標', 'PSI值多少時，對健康的影響為「不良」的等級？',  '51', '101',  '200',  300),
(2394,  '高級', 'PSI值(空氣污染指標)為多少時，屬於「良好」等級，對一般民眾身體健康無影響？',  '0~50', '51~100', '101~199',  '200~299',  1),
(2395,  '初級', '酸雨是哪一種污染所造成的？',  '水污染',  '空氣污染', '噪音污染', '垃圾污染', 2),
(2396,  '高級', '超過下列哪一個紫外線指數，曝曬等級屬於「過量級」？',  '3~5',  '6~7',  '8~10', '11以上', 3),
(2397,  '高級', '下列哪個選項符合綠建築基地保水指標？', '利用藤蔓植物攀爬建築物立面',  '因地制宜種植原生植物及誘蝶植物',  '建築施工時保護老樹不受傷害',  '在屋頂或陽臺大量設計良質土壤人工花園', 4),
(2398,  '高級', '下列哪種行為無法避免水受到污染？', '適量使用無磷清潔劑',  '改善污水下水道設施',  '工廠設立污水處理廠',  '於河流上游畜養家禽',  4),
(2399,  '高級', '下列哪個選項能解決地下水污染的問題？', '倒入大量化學物品清淨污水', '大自然有淨化水質的能力，不需要特別去整治', '建立完善的污水下水道系統', '禁止家庭排放廢水', 3),
(2400,  '高級', '全球約有多少比例的人「沒有」乾淨的飲水可用？', '二分之一', '四分之一', '六分之一', '八分之一', 3),
(2401,  '高級', '下列哪個選項「不是」自來水廠的淨水過程？', '沈澱', '過濾', '消毒', '煮沸', 4),
(2402,  '高級', '對於工廠與家庭污水應該要如何處理？',  '直接排放海洋或河川',  '由工廠或家庭直接排放', '須經過污水處理廠處理', '下雨時與雨水同時排放入河川',  3),
(2403,  '高級', '臺灣受污染的河川大致集中在哪個區域，下列哪個選項最正確？', '上中游河水集水區域',  '中下游人口密集地區',  '河流的出海口', '以上皆是', 2),
(2404,  '初級', '下列哪個是臺灣河川污染的主要來源之一？',  '土石流',  '家庭污水', '酸沉降',  '溯溪活動', 2),
(2405,  '高級', '水很美麗又多用途，卻最容易被污染，水污染的主要來源為何？', '家庭廢水', '工業廢水', '農業畜牧業',  '以上皆是', 4),
(2406,  '高級', '為了「減少」水污染，應該建造下列哪一種設施？', '焚化爐',  '污水處理廠',  '動物園',  '垃圾場',  2),
(2407,  '中高級',  '「烏腳病」是因為下列哪一種物質所造成？',  '鎘',  '汞',  '砷',  '鉛',  3),
(2408,  '中高級',  '地球上面積第二大的海洋為何？', '大西洋',  '南冰洋',  '印度洋',  '北極海',  1),
(2409,  '高級', '有關海洋的敘述何者「錯誤」？', '海洋占地球面積約71%',  '海洋會影響陸地氣候',  '海洋有豐富的資源', '河水流入海，所以海水越來越多', 4),
(2410,  '高級', '關於地球水資源特徵的描述何者「錯誤」？',  '世界各地水量的總收入和總支出是保持平衡的', '赤道地區降水量大於蒸發量為剩水區', '海洋水量大，是目前人類最重要且可利用的水資源', '海洋地區水量的收入包括降水、流入的河水及地下水',  3),
(2411,  '高級', '對於海洋污染的觀點，下列哪個選項是正確的？',  '對人類健康沒有影響',  '不到海邊就沒影響', '對地球、人類與生物生存造成影響',  '對海洋有影響，對陸地則無', 3),
(2412,  '高級', '人類所排放的廢水與海洋的關係，下列哪個選項是正確的？', '距離海洋遠，不會影響海洋', '海洋很大，可以容納更多廢水',  '大部分的海洋污染來自陸地', '廢水有營養，促進魚類生長', 3),
(2413,  '高級', '對海洋環境保護的觀念，下列哪個選項是正確的？', '海洋空間大，可存放垃圾',  '海洋少人住，應大量開發',  '海洋離我們遠，影響不大',  '保護海洋就是保護人類', 4),
(2414,  '高級', '有關海洋污染的敘述，下列哪個選項是「錯誤」的？',  '海水的污染只會在沿海地區', '大量污染物排放至海水', '污水會威脅害海洋生物及人類健康',  '海水可容納的污染是有限度的',  1),
(2415,  '高級', '地球形成後，最先出現生命的地方位於何處？', '山上', '平地', '火山', '海洋', 4),
(2416,  '高級', '下列哪個選項「不是」我們常見的海洋污染？', '船隻因意外而漏油', '傾倒工業廢料', '家庭污水', '夾帶大量泥沙的河川流入海洋',  4),
(2417,  '高級', '阿瑪斯號貨輪於民國90年1月沈?於臺灣的哪個地點？',  '北部外海', '墾丁外海', '花蓮外海', '高雄外海', 2),
(2418,  '高級', '以下何者有助於海洋環境保育的工作？',  '利用海蝕平臺養殖九孔', '砍伐防風林',  '淨灘行動', '將廢土傾倒於河、海岸', 3),
(2419,  '高級', '下列哪個選項「不是」「水再生利用產業」的下游端用水需求？', '民生用水', '民生次級用水', '保育用水及消防用水',  '工業區用水',  1),
(2420,  '高級', '下列哪個選項「不是」「水再生利用產業」的上游水源供給？',  '都市污水處理廠',  '工業區廢水處理廠', '自來水處理廠', '劣級河川水處理廠', 3),
(2421,  '高級', '臺灣最長的濁水溪「沒有」經過下列哪個縣市？',  '臺中', '彰化', '南投', '嘉義', 1),
(2422,  '高級', '「圳」的出現使我們的農業變為哪種耕作方式？',  '休耕', '移耕', '棄耕', '定耕', 4),
(2423,  '高級', '臺灣目前有幾條「中央管河川」？',  '6條', '16條',  '26條',  '36條',  3),
(2424,  '高級', '水只會被短暫地儲存於泥土中。而水在蒸發或蒸騰後及凝結或降水前，會存於大氣層中大約幾天？',  '3天', '6天', '9天', '12天',  3),
(2425,  '高級', '水資源可分陸水、海水和大氣中的水，是依何項指標區分？', '水的深度', '含鹽分多寡',  '水存在的區位', '水的利用方式', 3),
(2426,  '高級', '自然界物質運動和能量轉化的重要方式之一是什麼？',  '水資源',  '水循環',  '水地圖',  '水凝結',  2),
(2427,  '高級', '下列哪個選項是人類可以利用的淡水資源？',  '海水、地下水、食鹽水', '污水、湖水、地下水',  '食鹽水、海水、湖水',  '地下水、河水與湖水',  4),
(2428,  '高級', '水的再生利用可分成六類。下列哪個選項「不是」水的再生利用？',  '畜牧用水再生利用', '養殖用水再生利用', '家庭污水再利用',  '自來水再利用', 4),
(2429,  '高級', '臺灣一直有水資源不足的問題，下列哪個選項「不是」此問題的重要成因？',  '降雨之時間及地點極不均勻', '人口密度太高', '年雨量低於世界平均值', '降雨多以表面逕流方式流至海中，而臺灣無法有效攔蓄', 3),
(2430,  '高級', '臺灣地區年降雨量是世界平均值的2至3倍，卻為排名第18的缺水國家，下列哪個選項「不是」其原因？',  '人口稠密', '地形陡峭，山高水急',  '大量興建水庫', '降雨季節集中', 3),
(2431,  '高級', '有關水資源的敘述，下列哪個選項是「錯誤」的？', '在利用水資源時，已經造成部分地區地層下陷', '都市的柏油路與建築不利於水的循環', '水是取之不盡的，目前沒有資源不足的問題',  '修築水壩有助於保留淡水，但也對環境造成很大的衝擊', 3),
(2432,  '高級', '地球上最大的儲水處在哪裡？',  '冰河', '地下水層', '海洋', '湖泊', 3),
(2433,  '高級', '有關水資源利用的敘述，下列哪個選項是正確的？', '大小便都應調大水量才可清洗乾淨',  '使用符合省水標章的裝置',  '家庭洗米的水質直接倒入水溝無需再利用', '感應式水龍頭是較為浪費水資源的配件',  2),
(2434,  '高級', '全球大約幾天可以完成一個水循環？', '1天', '3天', '6天', '9天', 4),
(2435,  '中高級',  '地球中最大的貯水處為海洋，它的貯水量是地球的總含水量的97%。而第二大的貯水處為下列哪個選項？',  '冰帽及冰河',  '整個生物圈',  '湖泊', '熱帶雨林', 1),
(2436,  '高級', '臺灣被聯合國組織認定為水資源相當貧乏的區域，其主要原因為何？', '陸地面積太小', '地形多山', '水庫太少', '降雨型態分布不均', 4),
(2437,  '高級', '埤塘即具有「吸納水量」的特性，這種特性稱為下列哪個選項？', '滯洪', '淨化水質', '補充地下水',  '保存物種', 1),
(2438,  '高級', '石門水庫位於下列哪條河川上？', '頭前溪',  '大安溪',  '大甲溪',  '大漢溪',  4),
(2439,  '高級', '不同的地方水庫使用年限會不一，導致水庫蓄水量變少的最主要原因為何？',  '人類的垃圾',  '水庫周圍枯枝落葉的增加',  '雨水沖刷下來的土壤',  '水庫內的生物影響水庫的壽命',  3),
(2440,  '高級', '目前臺灣水庫普遍遭遇的危機是下列哪個選項？',  '水庫淤積', '水質優良未受污染', '水庫水量太多', '水庫產生裂縫，有崩塌的危險',  1),
(2441,  '高級', '如果要查詢自家住屋是否為輻射屋,可以撥打哪支電話請問行政院原子能委員會?', '0800-066666',  '0800-076678',  '0800-000-321', '0800-059777',  2),
(2442,  '高級', '下列哪個選項是臺灣興建水庫的原因？',  '降雨量太少，不蓋水庫無法留住水',  '天然的湖泊很多，所以利用地形來蓋水庫', '地形多山，河流太短，無法留住水',  '可提供為養殖淡水魚類的場所',  3),
(2443,  '高級', '臺灣的水資源主要來源為何？',  '水庫、河川',  '地下水',  '海水淡化', '再生水',  1),
(2444,  '高級', '如果水庫集水區內的森林被砍光了，對水庫集水區內的其他生物會有什麼影響？',  '可以享受更多空間，這樣對水庫生態系比較好', '會有影響，但過了幾年之後，水庫就會恢復原狀',  '可能會因此沒有居住的環境及食物，而導致死亡',  '完全沒有影響', 3),
(2445,  '高級', '石門水庫供水區及其集水區之範圍「不涵蓋」下列哪個地區？',  '臺北', '桃園', '新竹', '宜蘭', 1),
(2446,  '高級', '石門水庫最初興建的原因為何？', '為解決臺北盆地淹水之苦',  '為解決大漢溪下游水旱之苦', '為解決桃園地區用電不足',  '為促進桃園觀光發展',  2),
(2447,  '高級', '對於地下水而言，「埤塘」具有什麼功能？',  '減少地下水',  '補充地下水',  '造成地層下陷', '造成地層上升', 2),
(2448,  '高級', '有關地下水的敘述，下列哪個選項是「錯誤」的？', '地下水與地面水並無聯通',  '地下水主要由雨水滲入岩層或土壤而成',  '森林具有涵養地下水的功能', '減少抽取地下水，有助於地下水供需平衡', 1),
(2449,  '高級', '水庫的建置最主要是為了解決什麼問題？', '降雨季節不穩定',  '美化景觀', '增加保育動物棲息地',  '發展工業', 1),
(2450,  '高級', '全球水資源分配，哪種用水所占比例最大？',  '民生用水', '農業用水', '工業用水', '飲用水',  2),
(2451,  '高級', '桃園地區自從有了以下何種工程之後，使得降水可以獲得妥善的保存與利用？', '地下水',  '大圳', '埤(ㄆㄧˊ)塘',  '溪流', 3),
(2452,  '高級', '下列哪個選項是水庫必定具備的功能？',  '發電', '防洪', '給水', '遊憩', 3),
(2453,  '高級', '在什麼狀況下，水會滲入到地底、蒸發入空氣、儲存於湖泊或水庫？', '植物截流', '昇華', '逕流', '移流', 3),
(2454,  '高級', '下列哪個選項「不是」埤塘的三生農業概念？', '生產', '生活', '生態', '生存', 4),
(2455,  '高級', '「渠首工」指的是下列哪一個選項？', '管理水圳的工人',  '清潔水圳的工人',  '引水設施', '防洪設施', 3),
(2456,  '高級', '埤塘喪失了原始的灌溉功能，逐漸消失或荒廢是因為下列哪個選項所造成的？', '雨量太少', '開發為水田',  '居住面積太少', '水庫供給水源', 4),
(2457,  '中高級',  '下列何者的河川流域面積最大?', '新店溪流域',  '濁水溪流域',  '大甲溪流域',  '高屏溪流域',  4),
(2458,  '中級', '水庫內的水質優養化對水庫中的魚類最後會造成什麼影響？', '水中有更多對魚類生存有幫助的養分', '水質變好，但對魚類沒有幫助',  '水質變差，影響魚類的生存', '對魚類完全沒有任何影響',  3),
(2459,  '高級', '下列哪一種生物「不應該」出現在臺灣的水庫中？', '鱷魚', '白鷺鷥',  '五色鳥',  '蜻蜓', 1),
(2460,  '高級', '石門水庫的枯水期大約是每年哪幾月？',  '2至4月', '5至10月',  '11至1月',  '1至5月', 3),
(2461,  '高級', '石門水庫以前遇到颱風就無法供水，現今用何種方法解決供水問題？', '分層取水', '設攔木索', '多設渠道集水', '減少農業用水供應', 1),
(2462,  '高級', '我們常以何種方式預防大壩及取水口被漂流木堵塞？',  '派船打撈', '設置攔污索',  '開啟大壩使漂流木流下', '開放民眾撈取漂流木',  2),
(2463,  '高級', '下列哪個選項「不是」臺灣多數河川共同的問題？', '上游濫墾', '中游經過家庭與工業污染',  '下游遇豪大雨，容易淹水',  '下水道淤積長年不通',  4),
(2464,  '高級', '河川可分為上游、中游與下游，而下游地區常面臨的問題為何？', '泥沙淤積', '水量不足', '不同程度的污染',  '土石流',  3),
(2465,  '高級', '關於河川整治的目的，下列何者為「錯誤」？', '進行疏伐，維持河川生態健康',  '消除髒亂，維護河川自然生態環境',  '提供高灘地親水休閒活動空間',  '整理河道，保持河川水流正常機能',  1),
(2466,  '高級', '臺灣每年的水資源總量約641億立方公尺，而利用僅占總水資源的1/3。此現象和臺灣河流的哪一項特性關係最密切？', '流量變化大',  '河床坡度小',  '流域面積小',  '泥沙含量多',  1),
(2467,  '高級', '古諺云「十年河東，十年河西」指的是下列哪個選項？', '水量的多寡',  '河道經常改變', '水位的穩定',  '河流的發源地', 2),
(2468,  '高級', '以下何者「不是」造成臺灣天然海岸消失的原因？', '沿岸養殖業大量抽取地下水', '河口出砂量減少',  '海岸工業區及港灣開發', '山坡地開發',  4),
(2469,  '高級', '下列哪個選項是臺灣東部著名的海岸景觀？',  '清水斷崖', '永安港',  '白沙灣',  '小琉球',  1),
(2470,  '高級', '臺灣的河川其集水區大致集中在中央山脈的兩側，其地質具有何種特質？', '多屬砂、頁、板岩，易崩塌，河水含砂量大',  '多屬玄武岩，穩定，不易崩塌',  '多屬鵝卵石，不甚穩定', '多屬火山變質岩，質地堅硬，不易侵蝕',  1),
(2471,  '高級', '澎湖群島最著名的是下列哪種海岸景觀？', '玄武岩海岸',  '珊瑚礁海岸',  '潟湖', '沙洲', 1),
(2472,  '高級', '臺灣河川大致呈現何種狀況？',  '長度短、坡緩、流速慢', '長度長、坡陡、流速急', '長度短、坡陡、流速急', '長度長、坡緩、流速慢', 3),
(2473,  '高級', '臺灣中部大甲附近的海岸是屬於哪種地形？',  '岩岸', '沙岸', '峽灣', '珊瑚礁',  2),
(2474,  '高級', '以下何者為「潮間帶」的定義？', '海浪打不到的地方', '高低潮線之間的位置',  '海浪洶湧的地方',  '淡水與海水交會的地方', 2),
(2475,  '中級', '臺灣東海岸大部分多為何種海岸地形？',  '沙岸', '岩岸', '珊瑚礁海岸',  '濕地', 2),
(2476,  '高級', '颱風過後石門水庫呈現滿水狀態，為何還常出現限水情形？', '工作人員人手不足', '取水口被堵塞', '原水濁度太高', '災民清洗家具大量用水', 3),
(2477,  '高級', '地球上泥沙量最多的河是下列哪個選項？', '尼羅河',  '湄公河',  '黃河', '恆河', 3),
(2478,  '高級', '世界上哪個國家填海造地最有名？',  '臺灣', '日本', '荷蘭', '美國', 3),
(2479,  '初級', '陽金公路的馬槽溫泉，與小油坑同為塌陷凹谷，位於陽明山地熱區。該溫泉是屬於下列哪一個火山群？',  '澎湖火山群',  '大屯火山群',  '基隆火山群',  '綠島火山群',  2),
(2480,  '高級', '造成臺灣南部濱海地區地層下陷最主要的原因為何？',  '當地房子蓋得太重', '居住人口太多', '養殖業超抽地下水', '時常發生地震', 3),
(2481,  '高級', '海岸地帶超抽地下水有可能導致環境變遷，在臺灣哪一個地區最明顯？',  '北部的沿岸',  '西南部的沙岸', '南部的珊瑚礁海岸', '東部的斷層海岸',  2),
(2482,  '高級', '我國哪座國家公園的特色為海域有黑潮流經，且水質清澈，溫度適宜，適合多種生物生長？', '東沙環礁國家公園', '臺江國家公園', '金門國家公園', '墾丁國家公園', 4),
(2483,  '高級', '有關黑潮的描述，下列哪個選項是「錯誤」的？',  '源於赤道的海潮',  '經過臺灣東岸', '將海底的營養鹽帶到海面，吸引魚群，使得漁獲豐富',  '又稱親潮', 4),
(2484,  '高級', '海洋中寒、暖流交會的地方，可以帶來什麼好處？', '魚群聚集，增加漁獲量', '波浪增強，有助滑水',  '水溫上升，適宜游泳',  '流速增加，沖走垃圾',  1),
(2485,  '高級', '「石滬」是早期居民利用海水的哪種特性來捕魚？', '洋流', '沿岸?',  '潮汐', '湧浪', 3),
(2486,  '高級', '臺灣的放射性廢棄物貯存場位在下列哪一個縣市？', '屏東縣(萬巒鄉)', '臺東縣(蘭嶼鄉)', '高雄市(旗津區)', '花蓮縣(吉野鄉)', 2),
(2487,  '高級', '有關行政院環境保護署推動的資源永續循環再利用(3R)的正確流程，下列敘述何者正確？',  '源頭減量→回收→再使用',  '回收→源頭減量→再使用',  '再使用→源頭減量→回收',  '源頭減量→再使用→回收',  1),
(2488,  '高級', '垃圾資源回收後可做何種用途，下列說明何者正確？',  '廢紙製成再生紙張', '廚餘堆肥後可供花草施肥',  '保特瓶加工可做塑膠原料',  '以上皆是', 4),
(2489,  '高級', '利用有機物經各式自然或人為化學反應後，直接燃燒應用，或和微生物反應產生沼氣再應用的能源是下列何者？',  '太陽能',  '核能', '生質能',  '地熱', 3),
(2490,  '高級', '下面何者是利用生物資源做出來的？', '鋼杯', '原子筆',  '紙盒', '玻璃杯',  3),
(2491,  '高級', '近年來巴西政府鼓勵農民由咖啡改種甘蔗的主要原因為何？', '甘蔗生產技術改善後，產量提高，獲利增加',  '全球市場甘蔗需求量大增',  '提煉酒精，增加生質能的使用',  '因咖啡生產勞力過剩而轉作', 3),
(2492,  '高級', '下列有關地下水的敘述哪個選項是「錯誤」的？',  '地下水是指在地下水面以下，土壤或岩石孔隙中的水',  '地下水含有較豐富的礦物質', '地下水面如與地面相交，地下水就可流出地表，形成泉水',  '地下水由於儲存在地下，所以較容易受污染',  4),
(2493,  '高級', '超抽地下水會造成下列何種環境災害？',  '地下水的石灰質變高',  '重金屬不會污染地下水', '地層下陷', '地下水面升高', 3),
(2494,  '高級', '因人類錯誤的使用，亞洲哪座湖泊曾經逐漸死亡？', '青海', '鹹海', '渤海', '死海', 2),
(2495,  '高級', '臺灣沿海地區漁業養殖的用水主要來自何處？', '湖水', '地下水',  '河水', '泉水', 2),
(2496,  '高級', '下列何者「不是」超抽地下水造成的結果？',  '地下水位下降', '海水入侵', '土壤鹽化現象', '海埔新生地生成',  4),
(2497,  '高級', '土壤中的戴奧辛進入人體的過程與下列何種現象最為密切？', '潮汐變化', '大氣環流', '水循環',  '侵蝕輪迴', 3),
(2498,  '高級', '臺南市中石化安順廠污染事件中，造成土壤污染的是下列哪一項物質？',  '鎘',  '汞',  '砷',  '鉛',  2),
(2499,  '高級', '下列哪個選項是對土地資源利用的最佳使用方式？', '以最大效益方式利用',  '以永續經營方式利用',  '以最低成本方式利用',  '這一代少用，留給下一代用', 2),
(2500,  '高級', '桃園RCA事件中，造成土壤及地下水污染的主要是下列哪一項物質？',  '鎘',  '三氯乙烯', '戴奧辛',  '汞',  2),
(2501,  '高級', '沿海地區盛行養殖漁業，在長年缺乏合理管理下，環境問題與下列何者「無」直接關連？',  '金屬污染', '地下水鹽化',  '地層下陷', '海水倒灌', 1),
(2502,  '高級', '造成地球臭氧層破洞的主要元凶是下列哪個選項？', '二氧化碳', '氟氯碳化物',  '氣旋粒子', '二氧化硫', 2),
(2503,  '中高級',  '工業國家在1996年開始全面禁用含氟氯碳化物的冷媒，主要是為了保護大氣層中哪一種氣體？',  '氧',  '氮',  '臭氧', '二氧化碳', 3),
(2504,  '中高級',  '下列哪個選項「不是」造成臭氧層含量減少的物品之一？',  '冰箱之冷媒',  '沙發的泡綿',  '髮膠噴霧劑',  '寶特瓶',  4),
(2505,  '中級', '水俁病是因為下列何種物質所造成的公害疾病？',  '有機汞',  '有機鉛',  '重鉻酸鉀', '砷化氫',  1),
(2506,  '高級', '《寂靜的春天》是全球第一本有系統、而且深入淺出探討化學污染危害環境與生態的書，這本書的作者是誰？', '珍古德',  '瑞秋卡森', '李奧波',  '梭羅', 2),
(2507,  '高級', '「痛痛症」首先是在哪一個國家發生？',  '美國', '日本', '南韓', '菲律賓',  2),
(2508,  '高級', '臺灣在2011年5月底爆發的一系列食品安全事件中，不法商人於「起雲劑」中加入下列哪一種化學物質？', '氧化劑',  '染色劑',  '塑化劑',  '芳香劑',  3),
(2509,  '高級', '農夫在水庫上游使用大量的農藥後，大雨將殘餘農藥沖入水庫中，對於生活於水中的魚類最有可能發生下列哪一種情形？',  '魚體可能蓄積農藥導致中毒，使數量減少', '魚類不會受到任何影響', '魚類的數量會越來越多', '魚類會越來越強壯', 1),
(2510,  '高級', '人類應該要有下列哪種環境倫理的認知？', '噴灑農藥可減少鳥害',  '噴灑農藥可增加農作物收成，造福人類',  '噴灑農藥可能造成生態不可挽回的破壞',  '噴灑農藥可能造成生態破壞，但透過調查可恢復原狀',  3),
(2511,  '高級', '關於廢棄物減量的敘述，下列何者「錯誤」？', '建築廢棄物回收利用',  '工程減少二次污染施工', '建築自動化減少工程污染',  '土石運輸車不需覆蓋防塵布', 4),
(2512,  '高級', '下列哪一項疾病最有可能是因為室內空調管線或冷氣機冷卻水塔未清潔消毒所造成？',  '肺結核',  'B型肝炎', '退伍軍人症',  '愛滋病',  3),
(2513,  '高級', '非洲國家每年皆為飢荒所苦的主因與下列哪個選項較無直接關係？',  '自然災害仍頻', '傳染病問題嚴重',  '國際糧食價格的波動',  '綠色革命的負面影響',  2),
(2514,  '高級', '清理地毯應用什麼方式清洗最省水？', '溼式', '蒸氣式',  '乾燥粉末式',  '沖洗式',  3),
(2515,  '高級', '污水不當排入水庫後，造成水庫出現藻類過度滋生，此現象主要是因為水庫水質產生何種改變？', '酸性增加', '含氧量增加',  '重金屬增加',  '氮、磷化物增加',  4),
(2516,  '高級', '臺灣目前面臨許多環境污染的問題，「不包含」下列哪個選項？', '火山爆發造成空氣懸浮微粒的增加',  '河川被重金屬污染', '交通工具排放廢氣造成空氣污染', '廢棄物掩埋造成地下水污染', 1),
(2517,  '高級', '下列哪個選項「不是」海洋污染的成因？', '船隻廢油排入海中', '人們將廢棄物丟在海邊', '珊瑚白化', '河川中的工業廢水', 3),
(2518,  '高級', '利用資源卻容易造成環境污染的是下列哪個選項？', '養魚', '種植蔬菜', '建立塑膠工廠', '設立觀光果園', 3),
(2519,  '高級', '下列哪個選項「不是」我們家園會面臨的環境問題？',  '廢棄物污染',  '森林面積縮小', '山坡地濫墾、濫建', '原生生物的數量增加',  4),
(2520,  '高級', '關於臺灣適合向海洋發展的敘述，下列何者為「錯誤」？',  '臺灣四面環海', '臺灣位於季風氣候範圍內',  '臺灣位居航路要衝', '臺灣海洋資源豐富', 2),
(2521,  '高級', '峽谷乃指由峭壁所圍住的山谷，一般由河流長時間侵蝕而形成。下列哪個選項是地球陸地上最大的峽谷？', '雅魯藏布江大峽谷', '科羅拉多大峽谷',  '喀利根得格大峽谷', '科爾卡大峽谷', 1),
(2522,  '高級', '下列哪個選項「不是」浮在水面的水生植物的特色？',  '沒有根部', '葉柄很長', '葉子和葉柄的浮力較大', '有氣生根', 4),
(2523,  '高級', '地球陸地上最長的山脈是下列哪個選項？', '安地斯山脈',  '喀喇崑崙山脈', '喜馬拉雅山脈', '夸特蘭巴山脈', 1),
(2524,  '高級', '下列哪個選項「不是」熱帶雨林的特徵？', '動物晝伏夜出，以避開日間的高溫',  '終年溫暖、多雨，季節變化不明顯',  '枯枝、落葉很多，土壤相當肥沃', '物種多樣性很大，整體數量也多', 1),
(2525,  '高級', '臺灣最大的平原是嘉南平原，面積第二大平原是下列何者？', '新竹沖積平原', '花東縱谷平原', '屏東平原', '蘭陽平原', 3),
(2526,  '高級', '地球上最長的河流是下列哪個選項？', '剛果河',  '亞馬遜河', '尼羅河',  '長江', 3),
(2527,  '高級', '關於生物的生活環境之敘述，下列哪個選項是正確的？', '水鳥可以在乾燥的沙漠中生活',  '海豚也能在陸地上生活', '只要是蛇都能在水中生存',  '青蛙需要生存在有水的地方', 4),
(2528,  '高級', '沉水水生植物葉片多半呈什麼形狀？', '寬圓形',  '細長形',  '橢圓形',  '寬長形',  2),
(2529,  '高級', '在臺灣的哪一個地方可以發現珊瑚礁，其生存的原因是下列哪個選項？',  '墾丁，因為海水溫暖',  '花蓮，因為海水有深海溝',  '基隆，因為河川污染',  '臺中港，因為是沙質海岸',  1),
(2530,  '高級', '我國哪座國家公園具有獨特的火山地質景觀？', '陽明山國家公園',  '東沙環礁國家公園', '金門國家公園', '墾丁國家公園', 1),
(2531,  '高級', '我國哪座國家公園具有獨特的珊瑚礁生態、多樣的海洋生物及文史資源？', '陽明山國家公園',  '東沙環礁國家公園', '金門國家公園', '墾丁國家公園', 2),
(2532,  '高級', '全世界最大的湖泊是下列哪個選項？', '蘇必略湖', '密西根湖', '青海湖',  '裏海', 1),
(2533,  '高級', '以下何者為臺灣瀕臨絕種的動物？',  '白鷺鷥',  '攀木蜥蜴', '蘭嶼角鴞', '虎頭蜂',  3),
(2534,  '高級', '下列何者「不是」水中生物？',  '臺灣粟螺', '布袋蓮',  '陸龜', '青蛙', 3),
(2535,  '高級', '下列何者對防範洪水災害「沒有」幫助？', '修築河岸堤防', '設立洪道和抽水站', '做好防汛準備和救災演習',  '山坡地廣植檳榔樹', 4),
(2536,  '高級', '臺灣發生洪水最主要的原因是下列何者？', '地震頻繁', '高山融雪', '暴雨驟降', '水庫潰堤', 3),
(2537,  '高級', '風化發生的方式相當多種，容易出現在寒冷地區和乾燥地區的風化作用，分別為何？',  '重複乾溼；凍融作用',  '凍融作用；氧化反應',  '熱漲冷縮；重複乾溼',  '凍融作用；冷縮熱脹',  4),
(2538,  '高級', '下列哪個選項是定義防止海風侵襲的樹林？',  '針葉林',  '防風林',  '闊葉林',  '矮樹林',  2),
(2539,  '中級', '目前一般學校規劃的地震避難場所在什麼地方？',  '地下室',  '操場', '教室', '走廊', 2),
(2540,  '高級', '熱帶雨林的破壞會造成何種環境問題，下列哪個選項正確？', '溫室效應', '氣候變遷', '生物瀕絕', '以上皆是', 4),
(2541,  '高級', '下列哪個選項「不是」洪水發生的可能原因？', '都市化發展過於快速，綠地減少', '降雨強大，使水位越過堤防', '森林面積過大，阻礙流水',  '表土沖蝕量大，墊高河床高度',  3),
(2542,  '高級', '全球人類有可能利用的淡水共約多少立方公里？',  '4,250立方公里',  '2,515立方公里',  '8,000立方公里',  '12,000立方公里', 3),
(2543,  '高級', '下列哪個選項「不屬於」全球性問題？',  '資源分配極不平均', '全球人口數持續增加',  '隨著科技進步，全球生活品質也不斷提升', '人類能運用的生物資源正快速減少',  3),
(2544,  '高級', '全世界曾經最長時間未降雨量的地方位於哪個國家？',  '衣索比亞', '智利', '冰島', '土耳其',  2),
(2545,  '高級', '下列何者「不是」造成臺灣水災的原因？', '高山融雪量大', '流域面積小',  '山坡地濫墾濫伐',  '河流坡度陡',  1),
(2546,  '高級', '臺灣地形雖小，河流眾多，降雨也豐沛，但為什麼臺灣河川「不易」蓄水？',  '河川太長', '河川阻礙太少', '河川坡陡流速太快', '河道常變換位置',  3),
(2547,  '高級', '以下哪個地區，發生酸雨的機率較高？',  '屏東', '花蓮', '臺北', '臺中', 3),
(2548,  '中高級',  '早期臺灣西南部沿海居民利用海水資源及充足的日照製成下列哪種調味品？',  '糖',  '醋',  '鹽',  '酒',  3),
(2549,  '中高級',  '發生地震「不會」直接引發下列哪種災害？',  '海嘯', '土壤液化', '土石流',  '山崩', 3),
(2550,  '高級', '地表最低點位於下列哪個選項？', '裏海', '黑海', '死海', '地中海',  3),
(2551,  '高級', '下列何種傳播方式最有可能將人造污染物傳播到南極大陸？', '地下水的滲透與流動',  '每日的潮汐作用',  '全球的海流循環',  '空氣傳播', 3),
(2552,  '高級', '下列哪個災害的起因與颱風「無直接關係」？', '強風', '豪雨', '地層下陷', '焚風', 3),
(2553,  '高級', '颱風來臨時容易造成土石流災害，其主要原因是下列何者？', '颱風氣流引發海水倒灌，使土石遭侵蝕鬆動',  '颱風引發地震，使土石鬆動', '颱風帶來大量降水', '颱風造成颳強風，使土石鬆動',  3),
(2554,  '高級', '目前大氣中的氧氣來源，主要來自於下列哪種作用？',  '岩石風化分解出氧氣',  '火山活動釋放出氧氣',  '紫外線分解了大氣中的水氣', '大量的植物進行光合作用的產物', 4),
(2555,  '高級', '臺灣農民在冬季農田休耕期間常種植羽扁豆、波斯菊等植物，其主要的用意為何？', '固定氮肥，增加土壤肥力',  '增加生物種類，以維持生態平衡', '充分利用土地，作為蔬菜食用',  '固定太陽能，以促進能量流動',  1),
(2556,  '中級', '下列何者「不是」地震主要引起的災害？', '山崩', '海嘯', '斷電', '洪水', 4),
(2557,  '高級', '地球上面積最大的淡水湖是下列哪個選項？',  '維多利亞湖',  '蘇必略湖', '裏海', '密西根湖', 2),
(2558,  '高級', '下列哪一個颱風造成八八水災，使南部地區嚴重受創？', '龍王颱風', '莫拉克颱風',  '納莉颱風', '賀伯颱風', 2),
(2559,  '高級', '淤積會減損水庫的蓄水功能，石門水庫的淤沙嚴重，下列何者「不是」直接造成泥沙淤積的主因？',  '降雨量過大，沖刷集水區地表土石',  '地震後造成土石鬆動',  '庫區內岩層崩塌地的泥沙進入水庫',  '生態旅遊', 4),
(2560,  '高級', '地球上最大的珊瑚礁位於何處？', '印尼-班達島', '昆士蘭州-大堡礁', '泰國-斯米蘭島',  '臺灣-墾丁',  2),
(2561,  '中高級',  '每生產1公斤食物過程中，需水量最多的是下列哪種食物？', '蔬菜類',  '牛肉', '海鮮類',  '稻米', 2),
(2562,  '高級', '過去歐洲共同市場補貼農戶大量生產，如今歐盟卻補貼農戶適度休耕，下列哪一種因素是歐盟農業政策轉向最重要的考量？', '進口糧價較廉', '農業氣候惡劣', '耕作意願下降', '土壤貧瘠或受污染', 4),
(2563,  '高級', '有關颱風可能帶來的災害，下列何者正確？',  '焚風', '暴潮', '山崩', '以上皆是', 4),
(2564,  '高級', '臺灣東岸的商港或漁港，都比西岸少許多。造成此現象的最主要原因為何？',  '地震、颱風等災害頻繁', '斷層海岸平直缺乏灣澳', '中橫公路替代了漁港的重要性',  '黑潮流勢強勁行船不易', 1),
(2565,  '高級', '以下何者為臺灣的原生生物？',  '福壽螺',  '琵琶鼠魚', '紅火蟻',  '泥鰍', 4),
(2566,  '高級', '我國哪一個行政區設有「綠蠵龜產卵棲息地保護區」？', '澎湖縣',  '南投縣',  '臺北市',  '臺中市',  1),
(2567,  '高級', '破壞水庫集水區內的生物棲息地將可能帶來什麼影響？', '生物數量會變更多', '生物種類會變更多', '生物數量與種類都會變少',  '不會有任何影響',  3),
(2568,  '高級', '雪霸國家公園七家灣溪因具有哪種國寶級動物而被定為生態保護區？', '梅花鹿',  '臺灣黑熊', '櫻花鉤吻鮭',  '山羌', 3),
(2569,  '高級', '造成生物棲息地消失的原因何者正確？',  '地球的氣候改變',  '人類破壞環境', '天然災害', '以上皆是', 4),
(2570,  '高級', '棲息地大量消失後，對生活於其中的生物產生何種影響？',  '生物種類變得更多', '生物數量變得更多', '生物種類和數量減少',  '沒什麼影響',  3),
(2571,  '高級', '臺灣國寶魚櫻花鉤吻鮭的棲息地七家灣溪位於哪一條溪的上游？', '大甲溪',  '大安溪',  '曾文溪',  '高屏溪',  1),
(2572,  '中高級',  '外來物種對環境影響層面最廣者為何？',  '影響臺灣原有生物的生存',  '讓生物多一些種類', '讓環境髒亂',  '沒有任何影響', 1),
(2573,  '高級', '外來種的生物一旦進入河川後，長期下來會對河川生態造成什麼影響？',  '增加河川生物的多要性', '有助於平衡河川生態',  '對原生生物產生競爭或威脅', '增加河川生物的種類與數量', 3),
(2574,  '高級', '紅火蟻如何入侵臺灣本島？', '人們不小心帶進來', '臺灣本來就有的',  '外國人送給我們的', '自己爬到臺灣的',  1),
(2575,  '高級', '造成近年來臺灣近海漁業漁獲量大減的主要原因為何？', '河川遭受污染，使海洋環境改變', '溫室效應改變魚群的移動方向',  '水庫攔砂壩興建，使海中營養物質減少',  '過度捕撈導致漁業資源衰退', 4),
(2576,  '高級', '有關海洋生態的敘述何者正確？', '海洋中沒有生產者', '海洋中的大魚不會被捕食',  '海洋中沒有哺乳動物',  '鯊魚是海洋生態系中的消費者',  4),
(2577,  '高級', '地球上體型最大的生物為何？',  '鯊魚', '大象', '河馬', '鯨魚', 4),
(2578,  '高級', '根據調查，中華白海豚最常出現在下列哪個海域？', '東部海域', '西部海域', '南部海域', '北部海域', 2),
(2579,  '高級', '以下何者「不是」熱帶雨林的功能？', '提供生物棲息環境', '提供伐木的好地方', '維繫生物多樣性',  '調節水文循環', 2),
(2580,  '高級', '我國哪一座國家公園目前屬於管制區域，僅開放學術研究單位進行人文史蹟與自然生態調查？',  '玉山國家公園', '東沙環礁國家公園', '雪霸國家公園', '臺江國家公園', 2),
(2581,  '高級', '下列哪個國家公園「不包含」海域？', '太魯閣國家公園',  '墾丁國家公園', '東沙環礁國家公園', '金門國家公園', 1),
(2582,  '高級', '櫻花鉤吻鮭分布於哪一座國家公園內？',  '金門國家公園', '臺江國家公園', '太魯閣國家公園',  '雪霸國家公園', 4),
(2583,  '高級', '我國哪座國家公園地形特色由老年期波狀丘陵、紅土臺地及海岸低地所組成，且整體外觀為低矮的臺地包圍略為突出於臺地之上的花崗岩丘陵？',  '金門國家公園', '臺江國家公園', '太魯閣國家公園',  '雪霸國家公園', 1),
(2584,  '高級', '我國於民國哪一年成立第一座國家自然公園「壽山國家自然公園」？', '民國85年',  '民國90年',  '民國95年',  '民國100年', 4),
(2585,  '高級', '臺灣第一座國家自然公園位於哪個區域？', '北部', '東部', '西部', '南部', 4),
(2586,  '高級', '臺灣第一座國家自然公園最受矚目的保育類動物為何？', '臺灣獼猴', '臺灣野兔', '臺灣黑熊', '梅花鹿',  1),
(2587,  '高級', '以下何者為臺灣第一座國家自然公園？',  '阿里山',  '玉山', '壽山', '陽明山',  3),
(2588,  '高級', '我國哪一座國家公園具有歷史文化及戰役史蹟等人文資源？', '陽明山國家公園',  '東沙環礁國家公園', '金門國家公園', '墾丁國家公園', 3),
(2589,  '高級', '我國第一座成立的國家公園為何？',  '陽明山國家公園',  '玉山國家公園', '金門國家公園', '墾丁國家公園', 4),
(2590,  '高級', '我國哪一座國家公園具有豐富的濕地生態資源景觀？',  '陽明山國家公園',  '東沙環礁國家公園', '臺江國家公園', '玉山國家公園', 3),
(2591,  '高級', '在建築基地之一隅，保留枯木、樹根、亂石堆、岩洞等「多孔隙環境」之設計，符合下列哪一項綠建築指標？', '綠化量指標',  '生物多樣性指標',  '基地保水指標', '二氧化碳減量指標', 2),
(2592,  '高級', '物種消失的原因以下何者「錯誤」？', '人工繁殖', '環境污染', '人類捕殺', '天然災害', 1),
(2593,  '高級', '有關物種的敘述何者正確？', '同種雌雄個體可以進行交配而產下具生殖能力的子代',  '物種是由一群具有完全相同基因組成的個體所組成', '外部特徵完全相同的個體稱為同種',  '生存在同一棲息地的個體之集合', 1),
(2594,  '高級', '下列哪個選項是決定演化的方向主要因素？',  '基因突變', '基因組合', '天擇', '染色體組合',  3),
(2595,  '高級', '關於消長的敘述何者「錯誤」？', '依顛峰群集的極相特徵，分為初級消長與次級消長', '消長過程中最早出現的群集稱為先鋒群集', '消長過程通常伴隨物種多樣性及植物群高度增加',  '消長為物種替代過程，最終會成為穩定群集',  1),
(2596,  '高級', '以下何者在描寫生物多樣性？',  '太陽系中有不同的星球', '各種瀕臨絕種的動植物', '地球上各式各樣的生命', '著名生物學家的傳記',  3),
(2597,  '高級', '以下何者為生物演化的首要條件？',  '用進廢退', '生存競爭', '環境選擇', '遺傳變異', 4),
(2598,  '高級', '以下何者有助維護「生物多樣性」？', '開發新能源',  '鼓勵低污染、省能源、可回收的綠色消費', '大量食用基因改造食品', '維護地球多樣的基因庫，平衡全球生態系統',  4),
(2599,  '高級', '以下何者「不是」臺灣的濕地？', '臺北關渡', '臺中高美', '臺南四草', '花蓮七星潭',  4),
(2600,  '中高級',  '下列何者「不是」臺江國家公園吸引黑面琵鷺南來過冬的環境條件？', '四周的海堤或魚塭提供避風', '棲息地為潟湖，具阻絕天敵之效', '周邊繁榮的農漁業等人為活動',  '棲息地和周邊覓食區食物充裕',  3),
(2601,  '高級', '以下何者「不是」濕地的重要功能？', '海陸緩衝', '水質淨化', '生物棲息地',  '工業區設立',  4),
(2602,  '高級', '在潮間帶「看不到」下列哪種海洋生物？', '蓋斑鬥魚', '招潮蟹',  '彈塗魚',  '和尚蟹',  1),
(2603,  '高級', '以下何者為生長在河口與海口交會濕地的胎生植物？',  '木麻黃',  '榕樹', '水筆仔',  '黃槿', 3),
(2604,  '高級', '紐約市長彭博(Michael', 'Bloomberg)曾說過哪種地形是抗氧化的救星？',  '綠洲', '濕地', '水庫', 0),
(2605,  '高級', '人們應怎樣處理近海的濕地？',  '傾倒廢棄物，填平成陸地',  '自然發展，提供生物生長',  '開發工業區，促進經濟發展', '養殖漁業，發展休閒活動',  2),
(2606,  '高級', '下列哪一座國家公園因溪流不斷切割大理石岩層，且地殼不斷隆起上升，而形成特殊的峽谷景觀？',  '太魯閣國家公園',  '雪霸國家公園', '陽明山國家公園',  '玉山國家公園', 1),
(2607,  '高級', '「水循環」的能量主要來自於哪裡？', '星星', '隕石', '太陽', '月亮', 3),
(2608,  '高級', '就長程目標而言，臺灣為確保水資源的不虞匱乏，目前最應推行的措施是下列哪個選項？',  '多建水庫', '推廣需水量較少的農作物',  '河流上游集水區保育森林',  '多開發地下水源',  3),
(2609,  '高級', '下列哪個選項「不是」造成臺灣地區屬於缺水國家的原因？', '地狹人稠', '山坡陡峭', '雨勢分散', '河川短促', 3),
(2610,  '高級', '若要使水庫上游集水區有更多的生物物種生存，下列哪一種方式較適合？', '開發為休閒農場',  '發展成觀光果園',  '種植果樹或茶葉',  '保持森林原狀，不要做人為的開發',  4),
(2611,  '高級', '地球平均年雨量最多的地方在哪裡？', '英國倫敦', '印度孟買', '夏威夷群島',  '臺灣基隆市',  4),
(2612,  '高級', '下列哪些選項會造成洪水災情更加嚴重？(A)加高堤防；(B)山坡地開發；(C)增加地面透水面積；(D)破壞水土保持。',  'AB', 'BC', 'BD', 'CD', 3),
(2613,  '高級', '下列何者的作法「無法降低」洪水災害的發生頻率及受災程度？', '興建堤防', '做好水土保持', '增加地表透水面積', '加強洪泛地區的開發',  4),
(2614,  '高級', '下列何者「不是」生態工法的原則？', '河川整治工程要同時考慮上中下游、流域等生態',  '為減少人工干擾，自然建材以當地為主',  '利用自然的設計與恢復能力在防災與生態間取得平衡',  '整治工程應以迅速為優先考慮以確保效率', 4),
(2615,  '高級', '有關臺灣山區常發生山崩的原因，下列何者是「錯誤」的敘述？', '伐林和濫墾的結果', '雨水滲入地下會增加土體的重量，提高土體下滑力，且可能減低土體底部與岩盤間的摩擦阻力',  '建築、開礦等之廢物和礦渣堆積在坡頂，會使坡頂載重例增加',  '山坡的斜面方向若與岩層的傾斜方向相反時，岩層易沿山坡滑落', 4),
(2616,  '高級', '路邊擋土牆上常可看到許多水管穿透擋土牆而出，此裝置的主要目的是下列何者？', '提供地下水的檢測', '提供民眾取地下水飲用', '幫助邊坡排水，減少擋土牆負荷', '排除土石，避免山崩',  3),
(2617,  '高級', '臺灣島是受什麼原因造成環境變遷，讓本島的動、植物擁有極高比例的特有種？',  '劇烈地震', '火山爆發', '島體隆升', '強烈颱風', 3),
(2618,  '高級', '臺灣地震發生次數最多的是下列哪一個地區？', '澎湖', '西部', '東部', '中部', 3),
(2619,  '高級', '土石流之發生有所謂「三多」要件，下列何者「不是」「三多」要件之一？',  '雨水多',  '土石多',  '坡度多',  '支流多',  4),
(2620,  '高級', '關於臺灣島的描述，下列哪個選項是「錯誤」的敘述？', '多火山、溫泉', '由菲律賓海板塊與歐亞板塊碰撞擠壓', '屬於環太平洋火山地震帶',  '板塊擠壓的方向略成南北向', 4),
(2621,  '中高級',  '臺灣地震的發生，大部分是由於下列哪種原因所造成的？',  '板塊碰撞引起地層擠壓', '火山爆發', '山崩', '海嘯', 1),
(2622,  '高級', '臺灣哪一地區發生地震所帶來的災害最為嚴重？',  '離島', '東部', '西部', '北部', 3),
(2623,  '高級', '臺灣所蘊藏的石油與天然氣最多分布在哪裡？', '新竹苗栗外海', '澎湖海域', '臺東花蓮外海', '高雄港外', 1),
(2624,  '高級', '塑膠製品經過千年也不易腐敗分解，它是利用哪一種資源所製成的？', '鋁礦', '鐵礦', '銅礦', '石油', 4),
(2625,  '高級', '墾丁大部分是屬於何種海岸地形，下列哪個選項是正確的？', '沙岸', '岩岸', '珊瑚礁海岸',  '懸崖', 3),
(2626,  '中高級',  '有關海洋污染的來源，下列哪個選項正確？',  '來自陸地', '空氣污染', '船舶運輸', '以上皆是', 4),
(2627,  '中級', '關於保護海洋資源的觀念，下列哪個選項是正確的？',  '資源豐富，不虞匱乏',  '資源有限，要合理運用', '資源有限，但申請後就可以隨意運用', '海洋魚類豐富，可多捕撈',  2),
(2628,  '中高級',  '有關保護海洋的行動，下列哪個選項「錯誤」？',  '正確利用海洋土地', '取締非法捕魚', '減少接觸海洋的機會',  '訂定保護海洋的法案',  3),
(2629,  '中高級',  '下列何者「不是」臺灣水圳的用途？', '保存歷史遺產價值', '展現常民文化', '推廣生態廊道', '發展休閒遊憩', 3),
(2630,  '中高級',  '我國包裝飲用水的相關管理法規，下列何者敘述正確？', '製造過程之水質查驗依《飲用水管理條例》規定',  '包裝過程之衛生依《飲用水管理條例》規定',  '水源之水質管理依《飲用水管理條例》規定',  '包裝之標示依《飲用水管理條例》規定',  3),
(2631,  '中高級',  '下列哪個選項「不是」構成水圈的水源之一？', '冰山', '地下水',  '地表水',  '海水', 1),
(2632,  '中高級',  '下列哪個選項「不是」改變水循環路徑的人為因素？',  '森林採伐和造林',  '興建水壩', '都市化',  '進行生態考察', 4),
(2633,  '中高級',  '為了節約家中用水並避免浪費，應定期檢查下列哪個項目？', '水塔', '水龍頭',  '馬桶', '以上皆是', 4),
(2634,  '中高級',  '下列何者清洗衣物的方式是「錯誤」的？', '一些嚴重污垢的衣物，最好能事先手洗再放入洗衣機',  '依據不同衣物量，適選高中低水位',  '太大、太厚重的毯子、大衣，最好能分批清洗', '不管哪種衣物，量多量少，直接投入洗衣機就好',  4),
(2635,  '中高級',  '下列何者可用來澆灌花木？', '洗澡水',  '洗米的水', '洗菜水',  '以上皆是', 4),
(2636,  '中高級',  '雨水在儲存後，可以作為下列哪一種水質要求不高的供應用水？', '沖水馬桶', '農業灌溉', '澆花', '以上皆是', 4),
(2637,  '初級', '關於臺灣水庫可提供的功能，下列何者為「錯誤」？',  '灌溉', '發電', '遊憩', '伐木', 4),
(2638,  '中高級',  '埤塘與聚落生活密切相關，並衍生出獨特的意義與象徵，下列哪個選項「不包含」在內？',  '釣魚池',  '灌溉或養殖池', '游泳池',  '聚落中心池',  3),
(2639,  '中高級',  '下列哪個選項「不是」人類雨水收集保存的方式？', '屋頂集水', '游泳池',  '雨撲滿',  '地表面或礫石地面', 2),
(2640,  '初級', '下列何者是善用水資源的方法？', '建水庫以儲存水資源',  '保護水資源以防止受污染',  '做好水土保持', '以上皆是', 4),
(2641,  '中高級',  '海岸地區超抽地下水「不會」出現下列哪個現象？', '地下水位下降', '土壤鹽化', '地層下陷', '海埔新生地的形成', 4),
(2642,  '中高級',  '何種公害可向環保單位檢舉？',  '水污染',  '噪音污染', '廢棄物污染',  '以上皆是', 4),
(2643,  '中高級',  '發現烏賊車時，可以向下列哪個單位檢舉？',  '環境保護局',  '警察局',  '消防局',  '社會局',  1),
(2644,  '中高級',  '下列選項何者具備「污染者付費」原則？', '生態稅',  '污染稅',  '能源稅',  '以上皆是', 4),
(2645,  '中高級',  '自1974年經濟合作發展組織提出「污染者付費」的原則之後，針對各國採行之經濟誘因制度，以下何者正確？', '收費制度', '補貼', '排放權交易',  '以上皆是', 4),
(2646,  '中高級',  '造成「綠牡蠣」的原因是下列哪個選項？', '牡蠣吃了太多綠色海藻', '含銅離子的化學物質流到河流',  '海水中太多綠色浮游生物',  '漁船使用的綠色油漆流到河流',  2),
(2647,  '初級', '早期來到臺灣的漢人，大多從臺灣的哪一個海岸登陸？', '西部海岸', '東部海岸', '北部海岸', '南部海岸', 1),
(2648,  '中高級',  '關於生物命名法的敘述何者正確？',  '學名是由屬名和種名所構成', '屬名常為形容詞，種名為名詞',  '種名在前，屬名在後',  '三名法是二名法之後附加發現者的名字',  1),
(2649,  '中高級',  '下列何種生物是海洋生態系中的生產者？', '吻(ㄨㄣˇ)仔魚', '海藻', '珊瑚', '小蝦', 2),
(2650,  '中高級',  '最近幾年來，地球的生物種類有什麼改變？',  '漸漸增加', '沒有增加也沒有減少',  '逐漸減少', '突然減少很多然後再增加很多',  3),
(2651,  '中高級',  '造成地球大量生物瀕臨絕種或消失的原因，以下何者為「錯誤」？',  '人類的濫捕濫殺',  '生物棲息地消失',  '外來物種的侵略',  '生物彼此掠食與競爭',  4),
(2652,  '中高級',  '魚的身體具有哪些特徵，能讓牠在水中生存和運動？',  '能夠調節自己的體溫',  '能呼吸水中的二氧化碳', '胸鰭及腹鰭可幫助魚轉換方向或減慢速度', '藉由背鰭及臀鰭來前進', 3),
(2653,  '中高級',  '有關自然資源的敘述，下列哪個選項正確？',  '生物圈中的自然資源是取之不盡、用之不竭的，是為了人類之居住',  '臺灣地狹人稠，為了國家的永續發展，只好多開發山坡地，以利人類之居住',  '臺灣因豪雨所造成的土石流，多因濫墾山坡地，造成水土保持不良所導致', '海洋資源豐富，宜多加開發，以補陸地食物之不足', 3),
(2654,  '中高級',  '水庫上游集水區若遭受破壞，會帶來什麼影響？下列哪個選項正確？', '影響我們飲用水的品質', '易使下游遭到土石流等災害', '生物多樣性的損害', '以上皆是', 4),
(2655,  '中高級',  '在同一個地區相同地震規模下，下面哪種地震可能造成的災害最大？', '淺層地震', '中層地震', '深層地震', '以上皆是', 1),
(2656,  '中高級',  '濫採砂石對環境有哪些影響？(A)橋墩容易裸露；(B)沿海地區地層嚴重下陷；(C)河砂供應不足造成海岸線後退；(D)河川侵蝕力變弱，下游容易淤積土石',  'AC', 'AD', 'BC', 'BD', 1),
(2657,  '高級', '下列何者的輻射劑量最高？', '臺北搭飛機往返美國西岸一趟劑量',  '胸部電腦斷層掃描劑量', '胸部X光攝影劑量', '每年接受天然背景輻射劑量', 2),
(2658,  '高級', '下列何者「不是」公平貿易中的「3S」原則？',  '適當(Suitable)', '緩慢(Slow)', '微小(Small)',  '持續(Sustainable)',  1),
(2659,  '高級', '臺南市後壁區「後?社區」運用環境體驗教學，納入社區特色及產業文化，推廣傳統農村樸實文化。試問下列哪項敘述「不是」該社區的特色？',  '捏陶技藝', '手工黑糖', '茄芷編織', '無米樂',  1),
(2660,  '高級', '北非和西亞地區一向有謹慎使用水資源的傳統，但除少數國家外，過去幾十年來本區水資源短缺問題日益嚴重。下列何者是造成此問題最主要原因？',  '降雨量變化率增大', '人口快速成長', '製造業用水量大增', '戰亂衝突加劇', 2),
(2661,  '高級', '臺灣目前流行種植與食用有機農產品，下列哪個選項是「錯誤」的敘述？', '消費者追求健康飲食的趨勢', '農業生產與行銷策略的變更', '社會追求自然資源永續利用', '城鄉差異和貧富差距',  4),
(2662,  '高級', '臺北國際花卉博覽會之流行館-「遠東環生方舟FE',  'EcoARK」，是利用下列哪項廢料而聞名遐邇？',  '木質邊料', '再生祇',  '回收寶特瓶',  0),
(2663,  '高級', '庭園土壤改良，添加濕潤介質或保水聚合物(如蛭石、蛇木屑、稻穀、木屑、泥炭土)，可以提高水圈中哪部分的含水量？', '水蒸氣',  '湖泊', '水庫', '地下水',  4),
(2664,  '高級', '於牆面、電線桿張貼宣傳廣告傳單，可能受到什麼處分，下列哪項描述正確？', '處新臺幣1,200-6,000元罰鍰', '處新臺幣5,000元以上罰鍰者，須接受環境講習1小時', '依宣傳廣告傳單上留下電話號碼或是聯絡方式，協同電信單位課以停話處分',  '以上皆是', 4),
(2665,  '高級', '有關「機場回饋金」、「噪音防制費」，下列何項敘述「有誤」？',  '機場回饋金可作為機場周圍地區社會福利、文化及公益活動等用途',  '民航局徵收噪音防制費，該防制費應優先用於維護相關居民健康設施及活動等', '提撥場站降落費之3%作為機場回饋金',  '2級航空噪音管制區內學校、圖書館、醫療機構等合法建物給予航空噪音防制設施經費補助', 2),
(2666,  '高級', '對於娛樂場所、營業場所「低頻噪音管制標準」相關規定之論述，下列哪個選項正確？', '娛樂或營業場所違反管制標準，經當地主管機關限期改善仍未符合噪音管制標準者，處新臺幣1,000-10,000元罰鍰', '無限期改善之相關規定', '娛樂或營業場所違反管制標準，經當地主管機關限期改善仍未符合噪音管制標準者，應處新臺幣3,000-30,000元罰鍰',  '娛樂或營業場所限期改善期限不得超過90日', 3),
(2667,  '高級', '有關「低頻噪音管制標準」，下列何者敘述「有誤」？', '行政院環境保護署依噪音管制法第9條第2項，於94年修正噪音管制標準第3條、第7條', '於94年1月31日正式修正公告娛樂場所、營業場所低頻噪音管制標準', '於94年7月1日開始實施娛樂場所、營業場所低頻噪音管制標準',  '適用對象包括娛樂場所、營業場所、一般住宅、公寓大廈',  4),
(2668,  '高級', '下列有關娛樂場所、營業場所低頻噪音管制標準之論述，何者正確？', '現行娛樂、營業場所噪音管制標準係採50-10,000Hz頻率範圍A加權均能音量量測管制',  '可管制住商混合區中PUB、卡拉OK、冷卻水塔及發電機等機具所造成之低頻噪音',  '測得的噪音量如違反現行管制值，無法要求噪音源所有人進行改善',  '現行娛樂、營業場所噪音管制標準係採20-20,000Hz頻率範圍B加權均能音量量測管制',  2),
(2669,  '高級', '發現飼主未妥善處理寵物糞便影響環境衛生時，下列哪項陳情管道較為妥適？', '向轄區清潔隊申訴反映', '逕撥110洽警察機關陳情', '\'逕撥119洽消防局陳情',  '當作沒看見，不關我的事',  1),
(2670,  '高級', '飼主放任愛犬隨地便溺而未予清除者，依「廢棄物清理法」可處罰鍰金額上下限為？',  '處新臺幣600-1,200元罰鍰', '處新臺幣1,200-3,600元罰鍰', '處新臺幣1,200-6,000元罰鍰', '處新臺幣3,600-6,000元罰鍰', 3),
(2671,  '高級', '布袋蓮膨大的部分是它的哪個部位？', '莖部', '葉柄', '根部', '葉脈', 2),
(2672,  '高級', '地球上的有幾大生態系類型，下列哪個選項最正確？',  '2種', '3種', '4種', '4種以上', 4),
(2673,  '高級', '校園有許多大王椰子樹，下列哪個選項的描述是「錯誤」的？',  '又被稱為文筆樹',  '枯葉不會從樹幹上剝落下來', '樹幹上留下一圈圈的橫紋，就是「葉痕」', '椰子類植物中最高大的一種', 2),
(2674,  '高級', '以下何者可做為人類的食物？',  '動物', '植物', '真菌', '以上皆是', 4),
(2675,  '高級', '以下何者「不是」保護水庫集水區生物多樣的價值？',  '提供人類休閒欣賞的價值',  '讓生活在集水區的人類生活更便利',  '讓自然生態系能正常的運作', '提供人類教育的意義',  2),
(2676,  '高級', '下列哪個選項「不是」沙洲、潟湖和海灘的功能？', '防洪', '造林', '保護海岸', '淨化水質', 2),
(2677,  '中高級',  '下列哪個選項與空氣污染「無關」？', '淡水湖泊及土壤的酸化現象', '墾丁核三廠附近海域珊瑚的白化現象', '南極臭氧洞範圍逐漸擴大',  '1997~1998年東南亞的霾害', 2),
(2678,  '高級', '人類砍伐林木，破壞熱帶雨林，將會導致哪些後果？(A)破壞大氣中的臭氧層；(B)使全球氧、碳等元素的循環速率減緩；(C)許多生物絕種，生物種類減少；(D)湖泊酸化，水生生態系破壞。',  'BCD',  'ABD',  'ABC',  'ACD',  3),
(2679,  '高級', '下列哪個化石的描述是「錯誤」的？', '古生代代表化石為三葉蟲',  '中生代的代表化石為恐龍',  '臺灣杉為中生代活化石', '銀杏為中生代活化石',  3),
(2680,  '中高級',  '人類與環境息息相關，所以下列哪些觀念是正確的？(A)人類應尊重其他生物的生存空間；(B)瞭解自然界發生的各種現象；(C)以科技文明來改造所有自然環境；(D)竭盡使用地球上的所有資源。',  'AB', 'BC', 'CD', 'AD', 1),
(2681,  '中高級',  '下列哪種行為會破壞我們的地球？',  '垃圾分類', '廚餘堆肥', '自備購物袋',  '使用耗電量大的電器',  4),
(2682,  '中高級',  '下列何者具備民主環境決策中所謂「知的權利」之意涵？',  '環境公投', '行政訴訟', '審議式民主',  '以上皆是', 4),
(2683,  '中級', '「海砂屋」是因為建築房屋時使用的海砂中含有什麼離子造成混凝土病變？',  '氯',  '鈉',  '鈣',  '鎂',  1),
(2684,  '中高級',  '關於「負責任的環境行為」的描述，下列何者正確？',  '資源回收、省水省電',  '抵制不重視環保的產品', '檢舉環境違法事件、環境訴訟',  '以上皆是', 4),
(2685,  '中高級',  '關於人類與動植物的敘述，下列哪個選項是正確的？',  '購買動物來放生是很好的行為，應該鼓勵大家儘量這樣做',  '如果人類沒有好好的保護動植物資源，可能會使動植物資源滅絕', '生物多樣性被破壞的主要原因是因為肉食動物吃掉太多其他動物', '保護動植物最好的方式，就是將動植物移到動物園或植物園內',  2),
(2686,  '中高級',  '蘇花公路改善計畫是臺灣什麼區域的公路改善計畫？',  '東部', '南部', '西部', '北部', 1),
(2687,  '中高級',  '關於臺灣目前所面臨的人口問題，下列哪個選項正確？', '人口老化', '人口分布不均', '年輕人的負擔比以前重', '以上皆是', 4),
(2688,  '中高級',  '環境因過度開發而改變時，可能對各種生物造成什麼影響？', '生存空間不變', '生物數量增加', '繁衍後代困難', '食物來源增加', 3),
(2689,  '中高級',  '在海中捕魚時，應採取下列何種方式才符合生態保育的原則？',  '毒魚', '海底拖網捕魚', '網目不要太細密',  '炸魚', 3),
(2690,  '中高級',  '已開發國家人口數比開發中國家少，卻用掉相當大比例的資源，已開發國家的人須要調整其消費行為，下列何者是「錯誤」的？', '不過度消費',  '多使用再生紙', '飲食適可而止', '每週一天斷食', 4),
(2691,  '中高級',  '國家對於綠色產業的發展應推動哪些政策？以下敘述何者「錯誤」？', '增加對綠色產業的投資，提高企業的科研與開發能力',  '擴大綠色生產，應該實行獨資產業、多領域並進的政策', '完善綠色獎勵政策，使綠色企業享有減免稅、優惠貸款等優惠政策',  '鼓勵投資綠色企業，引進先進的環保技術和清潔生產設備',  2),
(2692,  '中高級',  '就經濟發展的描述，下列哪個選項具備「永續發展」的觀念？',  '追求短期的利益',  '破壞或污染環境',  '以追求人民福祉為前提', '以追求高經濟成長為前提',  3),
(2693,  '中高級',  '有關人類與環境的敘述，下列哪個選項是正確的？', '雖然人口不斷增加，但是人類可以生產更多的糧食，所以不會有糧食問題', '科學已經證明人類可以掌握大自然，再也不必擔心任何物種滅絕', '人類需要的食物只有少數幾種，只要好好保存這幾種就好了', '我們應該保護地球上所有的生物與生物的棲息地',  4),
(2694,  '中高級',  '以下哪個選項「不符合」永續發展的理念？',  '設置河濱公園', '搭乘大眾運輸', '設置公車專用道',  '人行道鋪設不透水鋪面', 4),
(2695,  '中高級',  '環保署為鼓勵民眾住宿旅館，力行綠色生活，下列何者「錯誤」?',  '自備牙刷牙膏', '續住不更換床單毛巾',  '自備盥洗毛巾', '自備一次即丟之盥洗用品',  4),
(2696,  '中高級',  '下列何者「無法」兼顧綠色消費與公平貿易的關係?',  '購買有機農產品',  '購買在地農產品',  '壓低農民利潤', '從農民的利益出發', 3),
(2697,  '中高級',  '針對符合環保經濟行為的選購觀念，下列哪項描述正確?',  '選購非耗能產品',  '選購生命週期長的產品', '選購具節能標章之產品', '以上皆是', 4),
(2698,  '中高級',  '關於「減少」電器使用時數的原因，下列哪個選項正確？',  '延長電器使用壽命', '減少二氧化碳的排放',  '省錢', '以上皆是', 4),
(2699,  '中高級',  '位於大洋洲的珊瑚礁島國-吐瓦魯，是因為哪種現象造成移民紐西蘭的計畫？', '火山爆發', '酸雨侵蝕', '海平面上升',  '臭氧層破洞',  3),
(2700,  '中級', '如何「減少」二氧化碳的排放量？',  '儘量使用汽車或機車作為交通工具',  '大量使用電器', '儘量搭乘大眾運輸工具', '儘量使用瓦斯及天然氣', 3),
(2701,  '中高級',  '下列哪一種行為或產品使用，需要考慮太陽的方位或仰角？', '裝設太陽能板', '裝設太陽能路燈',  '種植植物', '以上皆是', 4),
(2702,  '中高級',  '冷氣溫度設定範圍以攝氏(℃)幾度間為宜？', '20-22℃', '22-24℃', '24-26℃', '26-28℃', 4),
(2703,  '中高級',  '如何節約電冰箱的用電量？', '電冰箱門四周密合墊應緊密', '電冰箱門開啟時間不會影響耗電', '放置電冰箱應緊鄰牆面，節省空間',  '電冰箱儲藏量以全滿為宜',  1),
(2704,  '中高級',  '下列何者是正確的飲食習慣？',  '吃多少、點多少',  '餐餐都要吃到飽',  '先煮起來放冰箱',  '很多人排隊的東西一定好吃', 1),
(2705,  '中高級',  '下列何項行為可降低碳排放量?', '中秋節烤肉',  '使用石化燃料製品', '放煙火',  '搭乘公共運輸工具', 4),
(2706,  '中高級',  '中國大陸北方燃燒煤炭，隨著東北季風飄到臺灣，主要造成下列哪種污染？',  '溫室效應', '熱島效應', '海水升溫', '酸雨', 4),
(2707,  '中高級',  '下列哪個選項「不是」全球所面臨的環境問題？',  '臭氧層破壞',  '酸雨', '土地沙漠化',  '地層下陷', 4),
(2708,  '中高級',  '下列哪個選項「不是」全球暖化所造成的影響？',  '促使湖泊的酸性化，魚類等水中的生物大量死亡',  '冰山融解海平面上升',  '豪雨或颱風增加，引起洪水等災害',  '土地沙漠化，作物生產量減少',  1),
(2709,  '中高級',  '公平貿易標準分為公平貿易、生態環境二大政策面向，其中「生態環境政策」包含下列哪個選項？',  '堅持使用鹽素漂白', '木製品來自廢材或成長較快的樹木',  '使用農藥、化學肥料的無機農法', '飾品的金屬部分使用鎳', 2),
(2710,  '中高級',  '世界環境日是幾月幾日？',  '3月22日',  '4月22日',  '5月22日',  '6月5日', 4),
(2711,  '中高級',  '落雪、落冰雹、霧、雪丸和雪雨是下列哪種現象之一？', '蒸發', '降水', '昇華', '凝結', 2),
(2712,  '中高級',  '如果地球自轉的方向相反，太陽從西邊出來，會發生下列哪種現象？', '南北半球的四季會顛倒', '北半球的東北信風會變成東南信風',  '南半球的東南信風會變成西南信風',  '南半球的東南信風會改吹西北信風',  3),
(2713,  '中高級',  '以現在的科學技術，能夠準確的預測地震發生的時間嗎？',  '能夠，地震發生規律有跡可循',  '不能夠，地震觀測不夠完善', '只能夠預測強烈地震',  '能夠預測輕微的地震',  2),
(2714,  '中高級',  '近鄰深夜喧嘩，妨礙公眾安寧，下列哪項申訴管道較為妥適？',  '自行敲門勸告', '逕撥110洽警察機關反映', '以喧嘩聲反制', '向里長申訴反映',  2),
(2715,  '中高級',  '有關民眾飼養動物之吠叫噪音，下列哪項申訴管道較為妥適？',  '逕洽動物疾病防治所反應',  '逕撥110洽警察機關反映', '自行敲門勸告', '逕撥全國公害陳情專線(0800)066666或環保局報案電話', 1),
(2716,  '中高級',  '植物光合作用中的光反應，其主要功能為何？', '固定二氧化碳', '產生ATP和NADPH',  '利用ATP產生葡萄糖', '由二氧化碳和水產生葡萄糖', 2),
(2717,  '中高級',  '下列哪個選項「不是」水資源失去平衡所帶來的影響？', '旱災', '洪水', '地勢低漥地區被淹沒',  '走山', 4),
(2718,  '中高級',  '下列何者「不是」正確預防洪水的方法？', '落實水土保持的工作',  '興建確保其暢通的排水系統', '劃定水災危險地區並實施禁建',  '開發山坡地為高爾夫球場',  4),
(2719,  '中高級',  '臺灣哪一個地方因地下水超抽而導致有地層下陷的情況？',  '花蓮', '雲林', '臺東', '臺中', 2),
(2720,  '中高級',  '下列與污水利用相關的公共設施，何者最為重要？', '自來水管', '水龍頭',  '水塔', '下水道',  4),
(2721,  '中高級',  '下列何者屬於海洋中的自然或礦產資源？', '石油', '天然氣',  '鹽',  '以上皆是', 4),
(2722,  '中高級',  '原油污染對海洋生態造成的影響，下列哪個選項正確？', '海鳥無法飛翔', '海域生態遭受破壞', '生物被油膜包裹窒息死亡',  '以上皆是', 4),
(2723,  '高級', '下列何者屬於「綠能產業旭升方案行動計畫」中所含括之再生或節淨能源產業，哪個選項正確？', '能源資通訊',  '氫能與燃料電池',  '電動機車', '以上皆是', 4),
(2724,  '高級', '臺灣每年有兩期稻作，其產季與下列哪項農漁產品相同？',  '落花生',  '柿',  '黑鮪', '鳳梨（臺農17號）',  1),
(2725,  '高級', '下列有關選購電冰箱的論述，何者最為妥適？', '有效內容積(公升)以家庭成員每人40公升估算', '電冰箱的效率以能源因數值EER表示',  '選購具「節能標章」之電冰箱產品',  '選購具自動斷電的電冰箱，節省電費', 3),
(2726,  '中高級',  '以偏遠地理位置得到「世界的盡頭」稱號的國家吉里巴斯，正因為什麼原因而面臨消失的危機？', '水資源問題',  '全球暖化', '臭氧層破洞',  '糧食問題', 2),
(2727,  '高級', '專家學者預估吐瓦魯九個小島將全部沒入海中，在世界地圖上將永遠消失。對該國的描述，下列哪個選項是「錯誤」的？',  '主要產業為捕魚及農耕', '島上無工業發展',  '國土受海水酸化、土壤侵蝕', '受強烈熱帶氣旋和海嘯襲擊', 1),
(2728,  '高級', '全名為臺灣護聖宮宗教文化藝術館的「臺灣護聖宮」，因其大量使用下列哪項建材而聞名遐邇？', '木質邊料', '隔熱安全玻璃', '回收寶特瓶',  '廢棄混凝土材料',  2),
(2729,  '高級', '政府為加速再生能源開發、打造綠色能源經濟，刻正規劃將風能開發「由陸域逐步延伸至離岸」，下列何者「不是」其發展誘因？',  '景觀、噪音及光影問題小，可自由提高轉速以增加效?', '因造價成本低廉，故?岸風?機組裝置容?皆往千瓩（MW）級發展', '靜風期少，每?滿載小時較?上長久，有?擴大發電?', '氣?較?上穩定，風機疲?載荷較小', 2),
(2730,  '高級', '《京都議定書》管制之溫室氣體包含下列哪個選項？',  '氧化亞氮(N2O)',  '亞硝酸(HNO2)',  '六氟化鈾(UF6)',  '二丁基硫醚(C8H18S)',  1),
(2731,  '高級', '若臭氧層持續稀薄，導致地球生物圈暴露於更多的輻射線下，將造成什麼影響？',  '人類皮膚癌、白內障等疾病罹患率下降',  '植物生長迅速、農作物量產', '減少水面浮游植物產量，破壞水中食物網結構', '臭氧的時空分布變化較小',  3),
(2732,  '高級', '「低頻噪音」對人體可能會產生何種影響，下列哪個選項正確？', '妨礙睡眠、休養',  '聽力損失', '焦慮感',  '以上皆是', 4),
(2733,  '高級', '下列哪個選項所造成之噪音多屬「低頻噪音」？',  '重低頻喇叭',  '冷卻水塔', '抽水馬達', '以上皆是', 4),
(2734,  '中高級',  '通常音量在多少分貝以上，就會讓人產生焦慮不安，引發各種症狀？', '70分貝', '80分貝', '90分貝', '100分貝',  1),
(2735,  '高級', '一般情況下，下列何者的噪音(分貝)最大？', 'KTV的音樂聲',  '狗狗連續的吠叫聲', '道路施工時打碎機的聲音',  '汽車的喇叭聲', 3),
(2736,  '高級', '經估算，我國海洋保護區約佔領海面積46.15%，試問我國海洋保護區面積約多少平方公里？',  '2萬平方公里', '3萬平方公里', '4萬平方公里', '5萬平方公里', 2),
(2737,  '高級', '淨水處理過程中，加入下列何種金屬混凝劑後，恐導致老人癡呆症？', '銅',  '鋁',  '鎳',  '鎂',  2),
(2738,  '高級', '下列哪個選項「不是」海洋的功能？', '提供人類食物', '再生能源', '防洪治水', '調節氣溫', 3),
(2739,  '中級', '地球上的水資源中，淡水占2.5%，這些淡水大部分儲存在哪裡，下列哪個選項「不正確」？', '極地冰山', '高山冰河', '地下水層', '海洋', 4),
(2740,  '高級', '日本人稱「自來水」為下列哪個選項？',  '中水', '上水', '天水', '飲用水',  2),
(2741,  '高級', '一般家庭生活污水經處理後，作為非接觸用水的水源，我們如何稱呼？',  '上水', '中水', '下水', '礦泉水',  2),
(2742,  '高級', '「千塘之鄉」指的是臺灣的哪一行政區？', '臺北', '桃園', '嘉義', '花蓮', 2),
(2743,  '高級', '下列哪些自然條件之特性，「不是」構成桃園臺地埤塘景觀形成之重要因素？', '地形向西北緩傾斜', '地形坡度陡峭', '土壤透水性差', '河川短而陡，遇雨則洪、遇旱則枯之特性', 2),
(2744,  '高級', '不小心弄破燈管時，應該如何處理最妥適？',  '使用塑膠袋包裹回收',  '使用報紙包裹後回收',  '使用玻璃罐或密閉桶等緊閉容器，密封包裝好後回收',  '破掉的燈管不能回收',  3),
(2745,  '高級', '有關廚餘回收要瀝乾水分，是為了避免造成何種環境影響？', '避免污水滴落地面，造成二次環境污染',  '會增加後續廚餘堆肥再利用的處理時間',  '易造成清運過程中污水濺落', '以上皆是', 4),
(2746,  '高級', '再生紙漿相較原生紙漿的製作過程，除了減少樹木砍伐，還有什麼好處？下列何者正確？',  '消耗較少的能源',  '減少空氣污染、水污染', '減少大量的固體廢棄物', '以上皆是', 4),
(2747,  '初級', '有關道路的整潔與噪音的防治，下列何種方法是「錯誤」的？',  '汽機車定期排氣檢驗',  '取締大量排放廢氣的汽機車', '汽機車隨意鳴按喇叭',  '架設道路隔音牆',  3),
(2748,  '初級', '下列針對臺灣主要河川的描述，哪個選項是正確的？',  '蘭陽溪是熱門的泛舟地點',  '秀姑巒溪是宜蘭平原的主要水源', '淡水河早期貿易繁盛，內陸航運發達', '濁水溪是臺灣流域面積最廣的河川',  3),
(2749,  '中高級',  '清代前期漢人為解決灌溉用水於是積極興建大規模的水圳，如：?公圳、曹公圳、八堡圳。試問上述三水圳由北至南依序排列為何？', '?公圳、曹公圳、八堡圳',  '?公圳、八堡圳、曹公圳',  '八堡圳、?公圳、曹公圳',  '八堡圳、曹公圳、?公圳',  2),
(2750,  '初級', '為了供應用水，臺灣興建了許多大型水庫，如：翡翠、石門、德基和曾文水庫。上述四水庫由北至南依序排列為何？',  '翡翠、石門、德基、曾文',  '石門、翡翠、德基、曾文',  '石門、翡翠、曾文、德基',  '翡翠、石門、曾文、德基',  1),
(2751,  '初級', '下列對於臺灣各「自然保留區」的敘述，何者有誤？',  '臺東紅葉村臺東蘇鐵自然保留區-臺灣蘇鐵是古老的「活化石」之一', '烏石鼻海岸自然保留區-長期經強風、海水侵蝕，形成極特殊的海蝕地形', '苗栗三義火炎山自然保留區-岩質經風化、侵蝕後呈現紅棕色的火焰顏色', '烏山頂泥火山自然保留區-泥火山雖無泥漿噴發，但不時仍會噴出可燃性氣體', 4),
(2752,  '初級', '下列對於臺灣各「國家風景區」的敘述，何者正確？',  '(連江縣)馬祖國家風景區-沙岸地形，有潟湖和溼地景觀', '(屏東縣)大鵬灣國家風景區-海岸有崩?、險礁、海蝕洞、海石門等地形',  '(嘉義縣、臺南市)西拉雅國家風景區-關仔嶺溫泉區擁有泥質溫泉', '(南投縣)日月潭國家風景區-日月潭屬於天然的高山淡水湖泊', 3),
(2753,  '初級', '下列對於臺灣各「國家公園」的敘述，何者正確？', '金門國家公園-石灰岩洞地形及珊瑚礁海岸地形遍佈全島',  '陽明山國家公園-區內的大油坑、小油坑、馬槽、大磺嘴等地，都可見到強烈的噴氣孔活動', '海洋(東沙環礁)國家公園-孕育出琉球嶼舉世獨有的雅美族飛魚文化',  '雪霸國家公園-於大安溪上游武陵地區擁有陸封型櫻花鉤吻鮭',  2),
(2754,  '初級', '下列對於臺灣各「國家森林遊樂區」的敘述，何者正確？',  '八仙山國家森林遊樂區-地質為泥岩地，岩質十分脆弱', '東眼山國家森林遊樂區-以蝴蝶谷和東眼瀑布景觀聞名', '雙流國家森林遊樂區-雙流瀑布高廿餘公尺，溪水直洩而下', '富源國家森林遊樂區-山林道沿線有許多的地層裸露',  3),
(2755,  '初級', '下列對於基隆市和平島的敘述，哪個選項是「錯誤」的？',  '西班牙人從此地登陸臺灣',  '「蕃字洞」為西班牙人留下的遺跡',  '「千疊敷」和「萬人堆」為海蝕、風化景觀',  '海蝕平臺是冬季海菜的產地', 2),
(2756,  '初級', '下列針對臺灣水運觀光遊憩功能的敘述，哪個選項是「錯誤」的？',  '藍色公路主要由基隆河、淡水河二條軸線組成', '可以在渡輪上垂釣', '高雄著名的愛之船行駛路線為愛河',  '淡水河藍色公路可以看見水筆仔', 2),
(2757,  '初級', '下列哪個選項「無法」促進漁業發展？',  '在各地設置漁業資源保護區', '加強海岸的水質監測',  '推廣流刺網捕魚作業',  '鼓勵發展箱網養殖', 3),
(2758,  '初級', '當氣溫突然下降及持續低溫時，會對農作物和養殖漁業造成什麼損失？',  '水稻秧苗形成空穎、結實率降低或充實不良',  '葉菜類蔬菜出現黑色斑點，甚至凍傷腐爛', '沿海養殖魚體長停滯甚至暴斃',  '以上皆是', 4),
(2759,  '初級', '水稻秋收後，農民栽種油菜花的主要目的是什麼？請選出下列最正確的答案。', '開放觀光增加收入', '作為下一季稻作的綠肥', '榨取油菜籽的油販賣',  '採收油菜花販賣',  2),
(2760,  '中級', '下列針對「大氣層」的描述，哪個選項完全正確？', '雷電、彩虹、雪都出現在平流層', '極光發生在中氣層', '臭氧層是指平流層中臭氧濃度相對較高的部分', '大氣中最低溫，出現在對流層',  3),
(2761,  '中級', '下列有關「地震」的敘述，何者完全正確？',  '震源與震央的距離即為震央深度', '同一個地震因地震測站所在位置不同，芮氏規模也有差異',  '離震央越遠，搖動破壞的程度越小，震度也越小',  '中央氣象局將震度分為0~9級，數值越大表示震度越強',  3),
(2762,  '中級', '目前臺灣「能源」供給以下列何者為最主要的？',  '煤',  '石油', '核能', '液化天然氣',  2),
(2763,  '中級', '下列何者屬於生活污水的污染物，哪個選項正確？', '有機物',  '油脂', '致病微生物',  '以上皆是', 4),
(2764,  '中級', '下列哪項燃料「不屬於」火力發電所需要的燃料？', '煤',  '石油', '鈾-235',  '天然氣',  3),
(2765,  '中級', '噴灑農藥對於環境所造成的影響，下列說明何者正確？', '人吃下農藥殘留的作物，對身體造成傷害', '農藥有效防治病蟲害，使農作物長得好看', '農藥滲入河川、土壤、地下水造成污染',  '以上皆是', 4),
(2766,  '中高級',  '下列有關「空氣污染」的敘述，哪個選項是「錯誤」的？',  'PSI值超過100對人體健康會造成影響',  '懸浮微粒含量高而降低能見度，這種現象稱為「靄」',  '政府對於懸浮微粒主要來源區，會加強稽查和清掃', '環保機關會依不同的營建工程徵收空氣污染防制費', 2),
(2767,  '中級', '下列何種組合屬於「海洋能」發電？', '潮汐發電、溫差發電',  '溫差發電、汽電共生發電',  '洋流發電、燃煤發電',  '潮汐發電、燃氣發電',  1),
(2768,  '中級', '某間紡織工廠將回收的寶特瓶，經由環保重製的過程製成原液染色布料，再製成各種商品，符合什麼觀念，哪個選項正確？', '綠色設計', '清潔生產', '回收再利用',  '以上皆是', 4),
(2769,  '中級', '大氣中平流層之範圍，約自高度10餘公里至50~55公里。請問自高度30餘公里以上隨著高度的增加，平流層的溫度會有怎樣的變化？', '不會隨高度改變而改變', '隨高度上升而下降', '隨高度上升而上升', '其溫度是不規則上下變動',  3),
(2770,  '高級', '依據我國對極低頻磁場(60Hz)的曝露規定，對一般民眾之管制準則為？', '0.83μT(微特士拉)', '8.3μT(微特士拉)',  '83.3μT(微特士拉)', '833μT(微特士拉)',  3),
(2771,  '中高級',  '依我國對極低頻電磁場的曝露規定，一般民眾與職業人員之管制準則值，下列何者正確？',  '一般民眾之管制值大於職業人員之管制值', '一般民眾之管制值小於職業人員之管制值', '二者管制值相同',  '一般民眾有管制限值，職業人員沒有管制限值', 2),
(2772,  '高級', '家中養的狗太吵，可能會被罰多少錢？',  '300-600',  '600-1,200',  '1,800-2,400',  '3,000-15,000', 4),
(2773,  '中級', '環境荷爾蒙對人體哪一個系統影響最大？', '呼吸系統', '內分泌系統',  '消化系統', '循環系統', 2),
(2774,  '中級', '輻射污染可以引發人體癌症是因為輻射破壞了細胞的哪個部分？', '染色體',  '粒腺體',  '細胞膜',  '葉綠體',  1),
(2775,  '中高級',  '下列哪一種物質「不會」產生生物放大作用？', '鉛',  '碳',  '砷',  '汞',  2),
(2776,  '高級', '下列何者是對環境荷爾蒙正確的描述？',  '影響差異與性別無關',  '影響程度與年齡成反比', '不會影響免疫力',  '不會影響神經系統', 2),
(2777,  '高級', '下列哪一項因素使人不易察覺環境荷爾蒙對人體造成的影響？',  '人們忽視它的影響力',  '好發於青少年期',  '科技落後', '非立即有顯著影響', 4),
(2778,  '高級', '下列何者「不是」我國政府99年至104年預防環境荷爾蒙的執行策略？',  '進行產品、環境等抽測及監控',  '各主管機關向民眾加強宣導', '各主管機關增修訂法規', '成立跨國際預防組織',  4),
(2779,  '中級', '蓄意污染土壤或地下水，使之成為污染控制場址，污染人有何處罰？', '罰站', '坐牢', '罰錢', '罰勞動服務',  2),
(2780,  '高級', '美國超級基金污染場址可能造成的人體健康危害，下列何者「不是」應優先考量的健康狀況前三者？', '出生缺陷及生殖障礙',  '癌症', '免疫功能失調', '生物累積性',  4),
(2781,  '高級', '臺灣何種基金的徵收及運用與美國「超級基金」相近？', '資源回收管理基金', '空氣污染防制基金', '土壤及地下水污染整治基金', '垃圾及一般廢棄物清除處理基金', 3),
(2782,  '中高級',  '土壤是由固相、液相及氣相物質所構成的多項組合。固相成分「不包括」下列何者？',  '無機成分', '有機物質', '腐植質',  '水分溶液', 4),
(2783,  '初級', '未受污染的地下水，在環境中所扮演的角色為何？', '消費者',  '生產者',  '資源', '污染源',  3),
(2784,  '初級', '土壤提供給人類和陸上生物何種需求？',  '活動空間', '食物', '氧氣', '以上皆是', 4),
(2785,  '高級', '「鎘米」事件曾是臺灣重要的生態事件，這是哪一種污染所造成的？', '固體廢棄物污染',  '工業廢水排放', '空氣污染', '人為放置鎘粉', 2),
(2786,  '初級', '保護地下水不受污染，人人有責。下列對於保護地下水之敘述何者「錯誤」？', '研訂並落實地下水污染防治相關法規', '全面興建都市衛生下水道系統與污水處理場',  '控制使用毒害性農藥及加強畜牧養殖業廢水處理',  '將自家垃圾傾倒於荒地中，達到廢棄物再利用的目的',  4),
(2787,  '初級', '下列何者可能為土壤及地下水之污染來源？',  '鹹水養殖池',  '地下儲油槽',  '垃圾掩埋場',  '以上皆是', 4),
(2788,  '初級', '下列對地下水之敘述，何者正確？',  '地下水取之不盡用之不竭，應該儘量使用', '地下水在地層深部，因此不會受到污染',  '抽取地下水不用付錢，因此用愈多愈好',  '地下水抽取過多會導致地層下陷', 4),
(2789,  '高級', '盜油引起之土壤及地下水污染，在何種土壤狀況下會引起大面積嚴重污染？',  '砂土地區', '紅壤地區及下層為礫石層',  '全部土層均為紅土區',  '全部土層均為黃土區',  2),
(2790,  '初級', '臺灣中南部沿海地區養殖漁業發達，屏東林邊地區可發現許多房屋低矮，且半截埋陷於地下，何種原因最可能造成此現象？', '地震', '超抽地下水',  '土石流',  '地層抬升', 2),
(2791,  '初級', '下列何者「不是」常見的土壤顏色？', '紅色', '褐色', '黑色', '綠色', 4),
(2792,  '高級', '下列哪個選項最有可能會造成區域性大面積地下水污染？',  '中小企業工廠排放廢水入河川',  '市區一般加油站漏油',  '油灌車於高速公路翻覆', '油庫之大油槽漏油', 4),
(2793,  '初級', '發現土壤及地下水受污染了該怎麼辦？',  '通知教育局',  '通知消防局',  '通知環保相關單位', '完全不通知',  3),
(2794,  '中級', '酸性的土壤不適於耕作時，可灑些什麼以改變土壤的性質？', '肥料', '醋酸水',  '乾草', '石灰', 4),
(2795,  '初級', '在河道逕流量中有84.04%直接入海，主要是因為臺灣的哪個氣候特性所致？', '四季分明', '四季都是雨季', '降雨集中', '以上皆非', 3),
(2796,  '中高級',  '加油站不慎造成場區內土壤污染，可作何種應變措施？', '立即停止營業', '立即將污染土壤運至他處',  '立即調查污染原因及污染範圍',  '立即通報當地消防局',  3),
(2797,  '高級', '關於土壤氣體抽除法處理污染土壤，下列何者為「錯誤」？', '不需要挖掘地面',  '不需添加化學藥劑', '安全', '以非真空方式抽出', 4),
(2798,  '中高級',  '關於超抽地下水造成的災害，下列何者為「錯誤」？',  '地層下陷及國土流失',  '海水入侵', '土壤鹽化', '地下水位上升', 4),
(2799,  '中級', '只要地下水未受到污染，比起水庫水和地表水，可稱為一種成本低廉的資源，其主要原因為何？', '不須繳電費',  '不需做複雜的淨水處理', '不需繳管理費', '不需繳水權費', 2),
(2800,  '高級', '臺灣東部蛇紋岩地區風化生成之土壤中，何種重金屬含量偏高？', '鎘與鉛',  '銅與鋅',  '砷與汞',  '鉻與鎳',  4),
(2801,  '中級', '下列何者「不是」防治地下水遭受污染的監測機制？',  '查證監測井',  '地下水監測系統',  '環境輻射監測系統', '污染源監測井', 3),
(2802,  '中高級',  '土壤及地下水污染物「管制標準」濃度訂定之主要考量為何？',  '明顯影響灌溉水水質',  '影響人體的健康風險',  '影響養殖業抽取地下水養魚', '影響自來水公司抽地下水飲用',  2),
(2803,  '中級', '地層下陷可能造成的不良後果，下列何者為「錯誤」？', '堤防安全程度減小', '含水層的機能遭受破壞', '排水發生困難', '增加土壤肥沃度',  4),
(2804,  '中級', '工業廢水中造成土壤重金屬污染的物質有哪些？',  '砷',  '鉻',  '汞',  '以上皆是', 4),
(2805,  '高級', '土壤遭受重金屬污染之現行復育防治技術，下列何者為「錯誤」？',  '翻土法',  '客土法',  '施用土壤改良劑',  '水淋溶法', 4),
(2806,  '中高級',  '下列何者是臺灣農田土壤「最常出現」的污染？',  '柴油污染', '鹽類污染', '重金屬污染',  '汽油污染', 3),
(2807,  '中級', '下列選項何者為地殼中含量最多的金屬元素之一？', '鋅',  '鈣',  '鎂',  '鋁',  4),
(2808,  '中高級',  '下列何者重金屬污染對人體健康影響最深？',  '銅與鋅',  '鉻與鎳',  '鎘與汞',  '鉛與鋅',  3),
(2809,  '中級', '下列何者「不是」土壤自淨作用？',  '污染物進入土壤後經化學降解變為無毒害物質', '利用土壤中的微生物，將污染經由分解或礦化作用使污染物轉換', '土壤經過大雨沖刷能將污染物洗掉',  '土壤中的污染物通過複雜多樣的物理過程，使其濃度降低、毒性減輕', 3),
(2810,  '中級', '土壤及地下水的農業污染來源不包含哪一項？', '殺草劑',  '殺菌劑',  '肥料', '塑化劑',  4),
(2811,  '中高級',  '農田土壤被污染後會導致許多不良影響，下列哪一項敘述「錯誤」？', '農作物產量降低',  '不會影響地下水飲用安全性', '土壤生物種類與分布會受影響',  '影響農產品食用安全性', 2),
(2812,  '初級', '土壤的組成包括哪些？', '固相物質', '液相物質', '氣相物質', '以上皆是', 4),
(2813,  '中級', '土壤的酸鹼值為何？',  '酸性', '中性', '鹼性', '以上皆是', 4),
(2814,  '中級', '土石流災害之發生，乃因泥、砂、礫及巨石等地質材料與水之混合物受重力作用後產生流動所造成之災害，其發生包括一些要件，下列何者為「錯誤」？',  '充足的水量',  '足夠的上游堆積物', '有效的河床坡度',  '水土保持良好', 4),
(2815,  '中高級',  '土壤中紅色、黃色及灰色斑點的來源，是由於不同形態及濃度的何種物質組成？',  '氮磷物質', '鐵鋁物質', '碳氮', '納鉀物質', 2),
(2816,  '中級', '地下水受到污染後造成的影響，下列何者為「錯誤」？', '花費龐大的金錢進行整治',  '花費大量的時間進行整治',  '自然生態受到破壞', '不影響國家的經濟', 4),
(2817,  '高級', '下列哪個方法可以處理重金屬污染的土壤？',  '生物堆法', '生物通氣法',  '萃取法',  '以上皆是', 3),
(2818,  '中高級',  '下列何者是土壤污染物轉變的途徑？', '淋洗移動', '生物分解', '化學分解', '以上皆是', 4),
(2819,  '初級', '中南部近海農民常超抽地下水灌溉農田，會造成下列何種問題？', '地下水總量會越抽越多', '近海農田土壤土地鹽化', '沿海魚類資源降低', '土地生產力會增加', 2),
(2820,  '初級', '在河道逕流量中有84.04%直接入海，主要是因為臺灣的哪個地形特性所致？', '坡陡流急', '彎彎曲曲', '河道平緩', '河道寬闊', 1),
(2821,  '中高級',  '為有效應用有限的水資源，近年來政府有「水田轉作」之議。若目前的水田用水被轉移他用，可能會對環境生態帶來的影響為下列何者？', '地下水補注量減少', '加速福壽螺的蔓延', '地下水使用量增加', '土壤可變得更肥沃', 1),
(2822,  '初級', '下列何者是土壤受到污染時會產生的直接影響？',  '影響農產品安全',  '影響房屋的價格',  '影響肺部呼吸', '影響旅遊的安全',  1),
(2823,  '高級', '海水污染程度指標「Cl-/(CO32-+HCO3-)」屬於中度海水污染的標準為何？',  '比值1?2',  '比值2?5',  '比值5?10', '比值10?200', 2),
(2824,  '中高級',  '下列何者「不是」影響土壤顏色的因子？', '土壤水分', '土壤母質', '有機殘體', '土壤密度', 4),
(2825,  '中高級',  '土壤液化易發生於下列何種天然災害？',  '地震', '颱風', '火山爆發', '海嘯', 1),
(2826,  '初級', '下列何者是臺灣主要污染土壤的來源？',  '畜牧業排放廢水',  '工業區廢水排入農田',  '焚化爐排放廢氣及微粒', '廢熱污染', 2),
(2827,  '中高級',  '依據地下水水質監測井設置規範，針對封層與回填，下列何者是其?料材質？', '石英細砂', '水泥', '黏土', '岩土', 1),
(2828,  '中級', '下列何者「不是」國內加油站發生油品洩漏之可能原因？',  '地下油槽及管線腐蝕洩漏',  '洩油過程中發生洩漏及溢滿之情形',  '被微生物分解', '操作管理不當', 3),
(2829,  '中級', '沿海地區若大量抽取地下水作為養殖魚塭之用，可能造成何種土壤污染問題？', '土壤液化', '土壤硬化', '土壤鹽化', '土壤礦化', 3),
(2830,  '中高級',  '下列何者「不是」土壤之重要物理性質？', '土壤質地', '土壤通氣', '土壤排水', '土壤鹽分', 4),
(2831,  '中高級',  '地下水的水質特性，下列何者為「錯誤」？',  '溫差較小', '流速較慢', '具冬暖夏涼特性',  '含鹽量較地面水低', 4),
(2832,  '中高級',  '加油站污染地下水時，何者為常見的污染物質？',  '四氯化碳', '苯',  '銅',  '以上皆是', 2),
(2833,  '高級', '為防止土壤污染惡化，環保署訂定下列哪個標準來管制土壤污染物濃度？', '土壤污染物排放標準',  '土壤污染管制標準', '土壤污染控制標準', '土壤污染濃度標準', 2),
(2834,  '中級', '污染整治場址在選擇整治及復育技術時，所需考慮之因素，下列何者為「錯誤」？', '污染物整治的目標', '地下水位高低', '民眾接受度',  '地方風水', 4),
(2835,  '中高級',  '土壤粒徑小於多少毫米才可稱為土壤？',  '4毫米',  '2毫米',  '7毫米',  '8毫米',  2),
(2836,  '高級', '下列何者為預防地下儲油槽污染地下水的防範措施？',  '設置污水處理設施', '加裝蒸氣萃取井',  '連接之管線使用非腐蝕材料', '種植樹木', 3),
(2837,  '高級', '土壤pH變化對植物養分之可利用性影響很大，但增高pH對何種元素利用不受影響？', 'K',  'Ca', 'Mg', '以上皆是', 1),
(2838,  '高級', '下列哪些元素「不是」植物營養所需之多量元素？', '鉀',  '鈣',  '鎂',  '銅',  4),
(2839,  '高級', '下列何者「不是」控制場址公告為整治場址的要件之一？',  '位於飲用水水源水質保護區內',  '單一污染物最高濃度達土壤或地下水污染管制標準一倍', '位於風景特定區',  '位於學校', 2),
(2840,  '高級', '下列哪些方式是國內外地下水監測井常用的鑿井方式？', '氣錘式鑽堡',  '中空?旋鑽',  '水沖式旋鑽或頓鑽', '以上皆是', 4),
(2841,  '高級', '設置「場置性監測井」時，「不需」考慮下列何項因素？',  '監測井設置間距',  '監測井設置深度',  '監測井位置',  '監測井外觀',  4),
(2842,  '高級', '民國59年設立的臺灣美國無線電公司(RCA)，發生地下水嚴重污染事件，下列何者為該場址主要污染物之一？',  '苯',  '戴奧辛',  '四氯乙烯', '多氯聯苯', 3),
(2843,  '初級', '地下水受到污染後會有什麼影響？',  '整治需投入龐大時間及金錢', '人體健康受到威脅', '自然生態受到破壞', '以上皆是', 4),
(2844,  '中高級',  '我國地下水污染案件應用於何項法?做事後污染改善？', '水污染防治法', '空氣污染防治法',  '廢棄物清?法', '土壤及地下水污染整治法',  4),
(2845,  '中級', '土壤及地下水污染不易被整治的原因為何？',  '污染物在地底不易接觸', '污染源不易找尋',  '污染源不易處理',  '以上皆是', 4),
(2846,  '高級', '河川水質由水質參數之濃度值來計算所得之指標積分值，下列何者為「錯誤」？',  '氨氮', '生化需氧量',  '溶氧', '硬度', 4),
(2847,  '中高級',  '當公害糾紛發生時，糾紛當事人可以透過以下何種管道處理糾紛事宜？',  '向直轄巿、縣(巿)政府環保局陳情', '向鄉鎮市調解委員會申請調解',  '向直轄巿、縣(巿)調處委員會申請調處', '以上皆是', 4),
(2848,  '高級', '我國為了處理重大緊急公害糾紛，設有緊急公害糾紛處理小組，召集人依法由以下何者兼任？',  '環保署署長',  '行政院副院長', '司法院院長',  '警政署署長',  2),
(2849,  '高級', '直轄市、縣(市)政府因應公害事件啟動公害糾紛緊急紓處小組，視個案特性及需要，依法可以再擴增下列哪些小組？(A)污染事件查證組；(B)民意整合協調組；(C)健康影響評估組；(D)損害程度評估組',  'ABC',  'ACD',  'BCD',  '以上皆是', 2),
(2850,  '中高級',  '當水污染公害發生時，受害當事人第一時間應採取什麼舉動？',  '清理現場', '維持現場', '自行採樣', '尋找可疑污染源的排放', 2),
(2851,  '中高級',  '歷年來公害糾紛調處不成立的主要原因為何？', '調處委員為糾紛當事人', '當事人一方連續二次不到場', '調處委員會委員成分遭受質疑',  '以上皆是', 2),
(2852,  '初級', '如果發現河川顏色異常或魚類大量死亡時，應該打電話給以下哪個單位？', '當地環保機關', '環保署督察總隊',  '環保署三區督察大隊',  '以上皆可', 4),
(2853,  '初級', '如果發現附近餐廳正在排放濃濃的油煙，應打電話給以下哪個單位處理？', '衛生局',  '環保局',  '建設局',  '警察局',  2),
(2854,  '中級', '當工廠已經污染環境時，應該要透過何種合法的方式，要求工廠賠償及改善？', '直接到縣(市)政府靜坐抗議',  '包圍工廠不讓車輛進出', '申請公害糾紛調處及裁決',  '透過網路進行言論攻擊', 3),
(2855,  '中高級',  '環保署環境守護隊成員經常性工作為何？', '組成專業服務團，輔導特定對象', '執行環境影響評估', '發現環境污染事件立即蒐證通報', '負責蒐集民眾的環保素養資料',  3),
(2856,  '初級', '以下何種狀況環保署「不能」撥放檢舉環境污染事件獎金給舉發人？', '匿名或以虛偽姓名、地址舉發',  '中央及地方公職人員',  '各級環境保護機關現職人員', '以上皆是', 4),
(2857,  '高級', '公害糾紛事件如果經第一審法院辯論終結，是否可以再申請調處或裁決？', '只能申請調處', '只能申請裁決', '皆可申請', '皆不可申請',  4),
(2858,  '中級', '以下何者是造成公害糾紛的主要因素？',  '瞬發性污染物的排放',  '長期性污染之求償', '土地使用規劃不當', '以上皆是', 4),
(2859,  '中級', '下列何者較「不可能」是異味性公害的污染源？',  '下水道處理廠', '加油站',  '圖書館',  '市場屠宰場',  3),
(2860,  '中級', '如公害造成損害時，「原因鑑定」主要為了建立以下何種因果關係？', '評估危害程度', '造成損害之污染來源',  '何種污染物造成損害',  '以上皆是', 3),
(2861,  '中級', '公害造成損害時，「程度鑑定」主要為了確認下列何者？',  '何種污染物造成損害',  '造成損害之污染來源',  '評估危害程度', '以上皆是', 3),
(2862,  '初級', '在哪個網站可以查詢公害糾紛案件處理內容？', '公害糾紛處理資訊系統', '環境影響評估書件查詢系統', '列管污染源資料查詢系統',  '環保專案查詢系統', 1),
(2863,  '中級', '公害發生後，當事人申請調處委員會，依法規定應有多少委員出席才能調處？', '委員中有第三公正團體即可', '1/4以上委員出席',  '兩方當事人同意，一名委員即可', '以上皆可', 3),
(2864,  '中級', '調處委員會為調查、判定公害造成之原因及責任所委外進行之鑑定，其費用應由何者擔負？', '應負公害責任之當事人', '環保署',  '直轄巿、縣(巿)政府', '調處委員會',  1),
(2865,  '中高級',  '公害糾紛發生後，如經調處委員會調處不成立時，當事人該如何針對損害賠償部分申請裁決？',  '向調處委員會提出申請書',  '向裁決委員會提出申請書',  '向縣市環保局提出申請書',  '向環保署提出申請書',  1),
(2866,  '中級', '針對一再陳情之公害案件，各級環保機關處理時限為何？',  '5日', '7日', '14日',  '1個月',  1),
(2867,  '中高級',  '發生重大環境事件時，可透過三會署機制採取應變措施，以下何者「不是」三會署法定單位？',  '警政署',  '環保署',  '衛生署',  '農委會',  1),
(2868,  '高級', '當公害發生時，鄰近列管污染源許可證是重要的比對資料，許可證主要可以檢視列管污染源哪些廠內資訊？(A)使用原(物)料(B)使用燃料(C)資源回收廠商(D)產品種類', 'ABC',  'ABD',  'BCD',  'ABCD', 2),
(2869,  '中級', '在環保署公害處理資訊系統中，可以查詢到以下哪些資訊？(A)公害糾紛處理程序(B)公害陳情單位(C)公害處理單位(D)公害鑑定方法', 'ABC',  'ABD',  'BCD',  'ABCD', 4),
(2870,  '初級', '下列何者是人為的環境公害？',  '暴雨', '鄰居的狗常常吠叫', '颱風', '火山爆發', 2),
(2871,  '中高級',  '環保署針對公害事件有發展新的遙測科技，以強化污染調查的成效，以下何者屬遙測技術？', '使用無人飛行載具', '使用福衛二號衛星', '地面光達(LiDAR)系統',  '以上皆是', 4),
(2872,  '中級', '在生物鏈越上端的物種其體內累積持久性有機污染物(POPs)濃度將越高，危害性也將越大，這是說明POPs具有下列何種特性？', '持久性',  '半揮發性', '高毒性',  '生物累積性',  4),
(2873,  '高級', '由AIHA美國工業衛生協會所制定的ERPG，其第一級毒性物質之允許暴露程度，以下描述何者正確？',  '有毒氣體環境中，不會有不?影響的最大容許濃度', '有毒氣體環境中，不致使身體造成不可恢?傷害的最大容許濃度', '有毒氣體環境中，不致對生命造成威脅的最大容許濃度', '以上皆是', 1),
(2874,  '中高級',  '我國依《毒性化學物質管理法》將毒化物分成幾類？',  '3類', '4類', '5類', '6類', 2),
(2875,  '中高級',  '現代彙整地方人文歷史文化資料的方式，第一個步驟應為下列何者？', '耆老轉述', '網路搜尋', '圖書館閱覽',  '地方政府采風紀錄', 1),
(2876,  '中級', '臺灣何處在清朝時即有大滬1口、小滬4口，展現其海島居民的生活智慧及對環境的因應？', '澎湖縣',  '金門縣',  '馬祖', '蘭嶼', 1),
(2877,  '初級', '國家公園屬於哪一級空氣污染防制區？',  '一級防制區',  '二級防制區',  '三級防制區',  '四級防制區',  1),
(2878,  '初級', '臺江國家公園區每年何時都會有數以萬計的候鳥經此南下過境？', '春夏', '夏秋', '秋冬', '冬春', 3),
(2879,  '初級', '下列何者為第一座以平埔族命名的國家風景區？',  '參山國家風景區',  '茂林國家風景區',  '大鵬灣國家風景區', '西拉雅國家風景區', 4),
(2880,  '中級', '有全臺唯一的水陸空3D遊程，也是臺灣地區最負盛名水力發電重地，風景區以「高山湖泊」、「原住民文化」、「自然生態」等觀光遊憩為特色，上述為下列何國家風景特定區？',  '日月潭',  '阿里山',  '雲嘉南濱海',  '大鵬灣',  1),
(2881,  '中級', '關於花蓮縣富里鄉豐南村梯田景觀的敘述，下列何者符合生態永續的概念？',  '順應海岸山脈地形，沿山壁開鑿引水灌溉，梯田分布於丘陵坡地，順勢排列而下',  '年代悠久，為要保存完整而不斷地開發新的農地',  '兩側梯田種植檳榔，加入西方灌溉之設計元素，具有鮮明的永續意象', '環境區塊分明，依循宗族社會之秩序發展，佈局工整，極具地方特色', 1),
(2882,  '高級', '聯合國教科文組織的英文簡稱為何？', 'UNESCO', 'UNDP', 'UNIDO',  'UNWTO',  1),
(2883,  '初級', '小明利用「廣用試紙」測試所收集的酸雨，其試紙會呈現何種顏色？', '綠色', '紅色', '藍色', '黑色', 2),
(2884,  '初級', '小華在河邊散步時，聞到臭味，當他往河面望去，可能會看到下列哪些景象？', '魚群在水中悠游',  '水面上有野鳥覓食', '水色污濁且河底有氣泡上浮', '河水清澈見底', 3),
(2885,  '初級', '小明利用簡易溫度計量測居家附近夏天中午的河水溫度，其顯示值最有可能為下列何者？',  '5-10℃',  '11-20℃', '21-30℃', '35-45℃', 3),
(2886,  '中高級',  '水處理技術中「活性污泥法」屬於一般所稱的哪一級處理？', '初級處理', '二級處理', '三級處理', '四級處理', 2),
(2887,  '初級', '臺灣地區目前廢水排放總量，最多的是哪一類污水？',  '工廠污水', '礦場污水', '生活污水', '農業污水', 3),
(2888,  '初級', '湖泊或水庫等水體中藻類大量繁殖導致水質惡化的現象稱為？',  '優氧化',  '優養化',  '缺養化',  '缺氧化',  2),
(2889,  '初級', '下列哪一種微生物長久以來一直被當作水污染的指標生物？', '霍亂弧菌', '沙門氏桿菌',  '大腸桿菌', '志賀氏桿菌',  3),
(2890,  '初級', '小明和家人到墾丁浮潛，發現海底珊瑚變成白色，較可能的原因是？', '海中魚類增多', '水質遭受污染', '藻類增多', '地震', 2),
(2891,  '中級', '小明在河口發現牡蠣呈現綠色，可能是遭受何種物質的污染？',  '銅',  '鋅',  '鉛',  '汞',  1),
(2892,  '初級', '小華夏天清晨在河邊晨跑，發現魚群暴斃，下列何者為最可能的原因？',  '水溫過低', '水中溶氧不足', '鳥類覓食', '工廠排放濃煙', 2),
(2893,  '初級', '若您有意願保護河川生態，可以積極參與下列何種作為？(A)定期水質監測(B)河川認養維護(C)定期巡守(D)外來魚種放生',  'ABC',  'BC', 'ABCD', 'ABD',  1),
(2894,  '初級', '小英參加學校舉辦的認識溼地戶外教學，她在這次活動可能獲得下列哪些知識？',  '溼地可淨化水質',  '溼地具生態保育功能',  '溼地具環境教育功能',  '以上皆是', 4),
(2895,  '初級', '下列何者「不是」水質污染會對河川生態造成的影響？', '植物死亡', '威脅人體健康', '危害水中生物', '提高河川親水性',  4),
(2896,  '中級', '水中溶氧來源可能來自於(A)大氣溶解(B)自然或人為曝氣(C)光合作用(D)有機物分解',  'ABC',  'BCD',  'ABD',  'ACD',  1),
(2897,  '中級', '水若有糞便污染之指標以何者為主？', '藻類大量繁殖及死亡',  '魚類', '大腸桿菌群',  '真菌', 3),
(2898,  '中級', '下列何種水源較不易引起藻類大量繁殖？', '河川上游水',  '大量肥料排入的水體',  '湖泊、水庫',  '養豬廢水排入的水體',  1),
(2899,  '中級', '水體pH值會對下列何者造成影響？', '生物的生長',  '物質的沉澱',  '廢水的處理',  '以上皆是', 4),
(2900,  '中級', '當過量的磷進入水體，會形成水體缺氧和優養化現象，其主要原因為何？', '藻類大量繁殖及死亡',  '魚類大量繁殖及死亡',  '珊瑚大量繁殖及死亡',  '動植物大量繁殖及死亡', 1),
(2901,  '中級', '臺灣西部地區水體曾經遭受何種物質污染，造成飲用者罹患烏腳病？', '砷',  '汞',  '銅',  '鉛',  1),
(2902,  '中級', '下列何種作為可有效處理家庭生活污水？', '加速公共下水道建設',  '社區專用下水道建築物設置合併式污水處理設施',  '化糞池定期清理',  '以上皆是', 4),
(2903,  '中級', '人工溼地屬於現地處理工法，下列敘述何者「不是」人工溼地之主要功能？',  '水質淨化', '生態保育', '滯水防洪', '農業生產', 4),
(2904,  '初級', '小華在學校做完化學實驗所產生的有毒廢液，下列的處置方式何者較正確？',  '直接倒入水槽', '拿去澆灌花木', '倒入廢液桶',  '倒入塑膠瓶中，丟到垃圾桶', 3),
(2905,  '中高級',  '當河水出現高濃度的氨氮存在時表示水體的情形是？',  '水質良好', '剛受污染', '已被污染一段時間', '適合魚類生存', 2),
(2906,  '中高級',  '下列對「鉻(ㄍㄜˋ)」的敘述何者正確？',  '三價鉻毒性較六價鉻毒性高', '三價鉻具有致癌性並會在體內累積',  '含鉻廢水處理需先將六價鉻還原成三價鉻', '六價鉻為人體維持醣代謝之必要元素', 3),
(2907,  '中級', '點源污染是由一個可以明確界定的位置排入河川，以下何者屬於點源污染？',  '市鎮污水', '工廠廢水', '畜牧廢水', '以上皆是', 4),
(2908,  '中高級',  '下列何種反應會產生甲烷物質？', '光合作用', '氧化作用', '硝化作用', '厭氧作用', 4),
(2909,  '中高級',  '環保署所規劃之河川污染整治願景包括下列何者？(A)不缺氧(B)不發臭(C)魚產豐富(D)水岸活化', 'ABC',  'BCD',  'ABCD', 'ABD',  4),
(2910,  '中高級',  '下列何者為工業廢水污染整治較可行的方式？(A)強制拆除違章工廠(B)工廠合理的放流水標準(C)提高經濟發展(D)徵收水污染防治費', 'ABC',  'BCD',  'ABCD', 'ABD',  4),
(2911,  '中高級',  '水中生物需氧量通常在下列何種條件下檢測分析？', '25℃，1小時',  '20℃，5天', '25℃，3天', '30℃，5天', 2),
(2912,  '中高級',  '當河水中濁度過高時，會對下列哪些情形產生不良影響？',  '曝氣作用', '光合作用', '消毒作用', '以上皆是', 4),
(2913,  '中高級',  '將污染物質以沉澱方式加以處理，係屬於下列何種作用？',  '化學作用', '生物作用', '物理作用', '混凝作用', 3),
(2914,  '中高級',  '在春秋交替期間，因表面溫度高於湖底溫度，使得湖底有機物向上翻轉，此一現象對水質將產生何種影響？',  '增加溶氧量',  '減少水中污染量',  '提高pH值',  '減少溶氧量',  4),
(2915,  '中高級',  '水中溶氧可能來自於下列何者？(A)大氣溶解(B)自然或人為曝氣(C)光合作用(D)有機物分解。',  'ABC',  'BCD',  'ABCD', 'ABD',  1),
(2916,  '高級', '河川污染指標(RPI)用以衡量的水質項目有幾個？', '4個', '3個', '5個', '2個', 1),
(2917,  '中高級',  '下列何者屬於水污染的「非點源污染」？', '居家污水', '工業廢水', '逕流廢水', '畜牧廢水', 3),
(2918,  '高級', '環保署所規劃之河川污染整治願景包括不缺氧指標，所謂不缺氧是指河水溶氧值高於下列哪一個值？', '2mg/L',  '4mg/L',  '6mg/L',  '8mg/L',  1),
(2919,  '高級', '水中溶氧會受水體溫度及鹽度所影響，下列何種情況下水中溶氧最高？',  '溫度高且鹽度低',  '溫度和鹽度均低',  '溫度低且鹽度高',  '溫度和鹽度均高',  2),
(2920,  '高級', '總凱氏氮(TotalKjeldahlnitrogen,TKN)係由下列何種物質所組成？',  '有機氮+硝酸氮',  '有機氮+氨氮', '有機氮+亞硝酸氮', '氨氮+硝酸氮', 2),
(2921,  '高級', '在水污染管制區內，使用毒品、藥品或電流捕捉水生物將被裁罰，係依據何種法令之規定？', '下水道法', '飲用水管理辦法',  '水污染防治法', '水利法',  3),
(2922,  '高級', '高屏溪等五大流域為保護飲用水源，曾進行養豬戶(場)依法拆除補償工作，此項作為對何種污染物改善成效最佳？',  '化學需氧量',  '氨氮', '重金屬',  '懸浮固體物',  2),
(2923,  '中級', '民眾參與河川整治可以有哪些比較積極之作為？(A)志工定期水質監測(B)河川認養維護(C)定期巡守(D)外來魚種放生',  'ABC',  'BCD',  'ABCD', 'ABD',  1),
(2924,  '初級', '因為水污染造成之水俁(minata)病是何種污染物所引起的？', '汞',  '銅',  '鎘',  '砷',  1),
(2925,  '初級', '環保署主要在哪個季節執行較密集的海灘水質監測？',  '春',  '夏',  '秋',  '冬',  2),
(2926,  '初級', '當下列何種魚類出現，可能代表河川水質惡化？',  '吳郭魚',  '?魚', '櫻花鉤吻鮭',  '苦花', 1),
(2927,  '初級', '若比較地下水水源與地面水水源的差異，下列哪一項敘述較「不正確」？', '地下水含鹽量較高', '地下水的密度較高', '地下水的溫差較小', '地下水較不會被污染',  4),
(2928,  '中高級',  '當河川原水遭受污染時，何項水質監測數質會明顯下降？',  '溶氧', '總有機碳', '氨氮', '懸浮固體', 1),
(2929,  '中高級',  '根據水庫水質的含營養程度，下列哪一種污染程度代表水庫優養化的現象最為顯著？',  '無養狀態', '貧養狀態', '普養狀態', '優養狀態', 4),
(2930,  '中高級',  '當河川溶氧為下列哪一個數值時，表示河川污染較嚴重？',  '1mg/L',  '3mg/L',  '5mg/L',  '7mg/L',  1),
(2931,  '初級', '下列何者「不是」飲用水水質監測項目之一？', '甜度', '大腸桿菌', '砷',  '汞',  1),
(2932,  '初級', '水中汞污染物危害性主要是因為它具有下列何種特性？', '累積毒性', '急毒性',  '干擾生物之生殖性統',  '影響人體之呼吸系統',  1),
(2933,  '高級', '河川水質污染監測的分類系統在國內稱為河川污染指標(RPI)，下列何者「不是」指標項目？',  '懸浮固體(SS)', '酸鹼值(pH)',  '溶氧(DO)', '生化需氧量(BOD)', 2),
(2934,  '初級', '水中懸浮粒子大量增加，對魚類會造成何種影響？', '有效躲避其他生物的攻擊',  '只對水生植物有影響',  '增加魚群的食物量', '阻礙魚類生長繁殖', 4),
(2935,  '中高級',  '最常造成人體感染的腸球菌，為下列哪一種細菌？', '糞便腸球菌',  '大腸桿菌', '乳酸菌',  '好氧菌',  1),
(2936,  '初級', '下列何者「不是」海灘水質監測在發布資料時所分的等級？', '優良', '普通', '不得從事海上作業', '不宜親水活動', 3),
(2937,  '高級', '下列何者「不是」河川整體調查項目？',  '水質品質評估', '底質品質評估', '生物指標', '表面植物密度', 4),
(2938,  '中級', '水庫優養化的防制措施，常以控制下列何種元素之濃度為主？',  '鈣',  '磷',  '碳',  '鉀',  2),
(2939,  '中級', '水中易被微生物分解的有機物質，在某特定時間及溫度下，被微生物的分解氧化作用所消耗的氧量稱為什麼？', '化學需氧量',  '有機物含量',  '生化需氧量',  '溶氧量',  3),
(2940,  '高級', '自然水體中的鹼度可由下列何項化學物質提供？',  '氯離子',  '鈉離子',  '碳酸氫根', '硫酸根',  3),
(2941,  '中高級',  '水中導電度值偏高時，代表水中哪一類化學物質偏高？', '鹽類離子濃度偏高', '有機物濃度偏高',  '化學需氧量偏高',  '懸浮固體偏高', 1),
(2942,  '高級', '計算河川污染指數(RPI)時，不需要下列哪一項？', '總磷', '溶氧量',  '氨氮濃度', '懸浮固體物濃度',  1),
(2943,  '中級', '下列何者為評估水體品質常用之生物指標？',  '青黴菌',  '大腸桿菌群',  '藍綠菌',  '肉毒桿菌', 2),
(2944,  '中級', '下列何者為水質檢測項目中，BOD之中文名稱？', '生物需氧量',  '生態需氧量',  '生化需氧量',  '化學需氧量',  3),
(2945,  '中級', '下列何種物質是導致湖泊優養化的主要原因？', '營養鹽',  '重金屬',  '戴奧辛',  '石油外洩', 1),
(2946,  '高級', '自來水中若添加過多的含氯消毒劑，可能會導致三鹵甲烷的生成，三鹵甲烷的英文縮寫為何？',  'THMs', 'TOCs', 'TCWs', 'PSI',  1),
(2947,  '中級', '汞是累積性毒物，對人體健康傷害性極大，其主要影響在於下列哪一部分的危害？', '呼吸系統', '皮膚', '消化系統', '中樞神經系統', 4),
(2948,  '高級', '下列何者是降低水中氨氮濃度的方法？',  '加入硫化鋁',  '加入硝化菌',  '加入酸',  '加入還原劑',  2),
(2949,  '中級', '蓄水池、水塔至少每隔多久需要清洗一次？',  '1~3個月',  '半年~一年',  '1~3年', '不用清洗', 2),
(2950,  '中級', '水樣品檢測結果顯示葉綠素a偏高時，可能代表該水樣有何污染現象？',  '水質優養化現象',  '水質遭受重金屬污染',  '水中COD偏高',  '水中溶氧偏高', 1),
(2951,  '中級', '進行水中TDS(總溶解固體物)檢測時，相關樣品的過濾液須在下列哪個溫度烘乾後，再秤取重量？',  '攝氏25~35度', '攝氏103~105度', '攝氏250~300度', '攝氏600~650度', 2),
(2952,  '中高級',  '總有機碳(TOC)為水污染指標之一，下列敘述何者「錯誤」？',  '分析迅速，是良好指標', 'TOC與BOD及COD等均有其各自含意',  '相對於BOD，TOC分析受鹽類干擾大', 'TOC之單位為mg/L',  3),
(2953,  '高級', '下列何者「不是」卡爾森優養化指標(CTSI)所需測定之項目？', '總磷', '透明度',  '水中葉綠素a', 'pH值',  4),
(2954,  '中高級',  '臺灣地區河川水質優劣以下列哪一項指標來代表？', 'RPI',  'WQI',  'CTSI', 'CPI',  1),
(2955,  '中高級',  '下列哪一項「不屬於」判定水庫水質優養化的主要參考參數？',  '生化需氧量',  '葉綠素a', '透明度',  '總磷', 1),
(2956,  '中高級',  '何種優養化指數常用於評比水庫的優養化程度？',  '卡爾森指數',  '河川污染指數', '高斯指數', '氫離子濃度指數',  1),
(2957,  '中高級',  '下列何者與水之濁度較有相關？', '懸浮固體物',  '重金屬',  '磷',  '氨氮', 1),
(2958,  '中級', '環保署執行環境水體水質之例行性監測，「未包括」下列哪個範圍？', '河川', '地下水',  '水庫', '蓄水池',  4),
(2959,  '高級', '下列何者「不是」在計算卡爾森指數(Carlsontrophicstateindex，CTSI)必須有的水質項目？', '葉綠素-a',  '濁度', '透明度',  '總磷', 2),
(2960,  '中高級',  '下列哪一項化學物質可在厭氧環境中反應生成硫化氫？', '氨氮', '汞',  '硫酸鹽',  '碳酸鹽',  3),
(2961,  '高級', '下列何者是水質檢測的物理項目？',  '硬度', '透視度',  '溶氧量',  '鹼度', 2),
(2962,  '高級', '下列何者是常用的優養化指標？', '上層水溶氧指標',  '多樣性指標法', '卡爾森指數',  '動物生長潛勢', 3),
(2963,  '高級', '水樣化學需氧量的分析約需時多久？', '3~5小時',  '3天', '5天', '7天', 1),
(2964,  '中高級',  '氫離子濃度指數的單位為何？',  'mg/L', 'ppm',  'pH', '無單位',  4),
(2965,  '高級', '下列哪一項「不是」水中濁度過高時可能產生的影響？', '干擾水生植物之光合作用',  '增加浮游生物', '干擾魚類呼吸', '影響淨水處理時的成效', 2),
(2966,  '高級', '我們以哪兩種生物指標評估海灘水質的優劣？', '好氧菌和厭氧菌',  '致病菌和腸球菌',  '大腸桿菌和致病菌', '大腸桿菌群和腸球菌',  4),
(2967,  '中高級',  '進行水樣品生化需氧量檢測時，須將相關樣品培養在何種溫度的環境中？', '攝氏4度', '攝氏10度',  '攝氏20度',  '攝氏零下25度',  3),
(2968,  '高級', '下列何者「不是」污染總量管制的原則？', '各污染源採用同一排放標準', '公平分配排放總量', '總量管制與濃度管制相結合', '尋求區域水污染控制成本最小化', 1),
(2969,  '高級', '下列哪一項河川水質參數，「不屬於」判定河川水質優劣的主要參數？',  '氨氮', '生化需氧量',  '溶氧', '透明度',  4),
(2970,  '中高級',  '下列何者「不是」河川水質監測之重金屬項目？',  '鈷',  '硒',  '砷',  '鎘',  1),
(2971,  '高級', '水質監測項目中之總硬度最適合以下列何種方式檢驗？', '電極法',  '離子層析法',  '濁度法',  'EDTA滴定法',  4),
(2972,  '高級', '根據卡爾森優養指數，超過多少值則稱為優養？',  '20', '40', '30', '50', 4),
(2973,  '高級', '下列何者「不是」我國用於檢測生物急毒性之生物？',  '水蚤', '孔雀魚',  '鯉魚', '米蝦', 2),
(2974,  '高級', '下列何者是放流水標準主要劃分的差異？', '依排放污染源之行業劃分',  '依早午晚的時間劃分',  '依排放廢水的總量劃分', '依排放季節劃分',  1),
(2975,  '高級', '下列何者「不是」自來水以氯消毒之目的？',  '操作簡便', '成本較低', '不會有二次殘留',  '氧化效果佳',  3),
(2976,  '高級', '家庭污水經污水道至污水處理場進行處理後，須符合下列哪種法規訂定的標準，才能排放至河流？',  '環境教育法',  '水污染防治法', '廢棄物清理法', '環境影響評估法',  2),
(2977,  '高級', '當河川發現下列何種魚類時，表示河川水質較為乾淨？', '鱒魚', '臺灣馬口魚',  '泥鰍', '大眼華?', 1),
(2978,  '初級', '墾丁著名的滿州賞鷹活動中所關注的是下列哪一種保育類野生動物？', '赤腹鷹',  '黑翅鳶',  '灰面鵟鷹', '蘭嶼角鴞', 3),
(2979,  '初級', '下列哪一項「不是」對海洋生物多樣性保育有利的行為？',  '多認?海濱及海洋生物，共同?作宣導海洋生態保育的義工', '多舉辦如黑鮪魚季等活動鼓勵大家消費',  '??倒污水、??丟垃圾，海釣、潛水應遵守規定，?踢珊瑚及下錨等',  '?吃活海鮮，只攝影、?採集、?收集、?購買海洋生物',  2),
(2980,  '中高級',  '國家公園與國家自然公園的差異為何？',  '國家自然公園的主管機關為地方政府', '國家自然公園只保護自然環境',  '國家自然公園是符合國家公園選定基準而其資源豐度或面積規模較小', '以上皆是', 3),
(2981,  '初級', '下列哪一項是由海洋生態系提供人類利用的資源？', '食物', '礦物', '發電', '以上皆是', 4),
(2982,  '初級', '對於在臺灣許多以宗教為名的放生活動，下列?述哪一項是正確的？', '把動物放生到不適合的地方，動物可能無法適應新環境而死亡',  '放生的出發點是尊重生命、愛護環境，也是護生的一部分，因此應該經常舉行', '放生能夠擴大物種分布的範圍，有助於增加物種生存的機會', '放生活動可以增加商業買賣，有助於經濟發展', 1),
(2983,  '初級', '臺灣水鹿為臺灣原產最大的草食性野生動物，下列對於臺灣水鹿的描述何者「錯誤」？', '臺灣水鹿屬保育第二級珍貴稀有野生動物', '主要分布於中高海拔',  '由於分布區偏遠，因此並無盜獵販售的威脅',  '為臺灣特有亞種',  3),
(2984,  '初級', '去野外觀賞螢火蟲時，下列哪一種行為是正確的？', '用包著紅色玻璃紙的手電筒來做為照明',  '利用閃光燈來照相才能在黑暗中拍到清楚的照片',  '使用網子來捕捉螢火蟲才能進行仔細觀察', '將螢火蟲帶回家裡做為寵物來飼養',  1),
(2985,  '初級', '下列何者「不是」造成全球暖化的原因？', '熱帶雨林的砍伐',  '工業及交通運輸消耗石化燃料',  '人口快速增加', '生物多樣性降低',  4),
(2986,  '中級', '臺中市政府農業局於2012年6月公告高美野生動物保護區的分區管制，遊客可以在規劃的時間內進入下列哪一個區域活動？', '核心區',  '緩衝區',  '永續利用區',  '以上皆可', 3),
(2987,  '中級', '下列哪一項「不是」造成海洋資源減少的原因？',  '過??用開發，缺乏資源管?',  '海岸開發及海洋生物棲息環境的破壞', '人類排放的廢水和垃圾的威脅',  '海洋保護區的設置', 4),
(2988,  '中級', '在國家公園的一般管制區或遊憩區內，經國家公園管理處之許可，可以從事下列哪項行為？', '礦物或土石之勘採', '垂釣魚類或放牧牲畜',  '廣告、招牌或其他類似物之設置', '以上皆可', 4),
(2989,  '中級', '在河川中構築水壩將對生態系造成什麼影響？', '使生物族群縮小',  '造成洄游生物的阻隔',  '造成棲地的單調化', '以上皆是', 4),
(2990,  '中級', '外來物種容易入侵本土生態環境而引起危害。下列何者為外來種危害本土種的原因？',  '繁殖力強', '缺乏天敵的壓制',  '競爭力強', '以上皆是', 4),
(2991,  '中級', '過去臺灣在進行河川整治時，經利用水泥護岸將河川溝渠化。這種作法對於河川生態有何影響？', '一些水棲的昆蟲會找不到化蛹的場所', '提高河岸對於水流沖刷的抵抗力', '增加遊客親近水岸的機會',  '以上皆是', 1),
(2992,  '中級', '阿?壹古道，為清代琅嶠卑南道的其中一段。此古道位於哪一個自然保留區內？',  '南澳闊?樹?自然保留區',  '烏石鼻海岸自然保留區', '鴛鴦湖自然保留區', '旭海觀音鼻自然保?區', 4),
(2993,  '中高級',  '下列哪一種保育類動物並「不是」由於人類大量捕捉及棲地破壞而瀕臨滅絕危機？', '?尾?蝶', '觀霧山椒魚',  '?蠵?',  '櫻花鉤吻鮭',  2),
(2994,  '中高級',  '下列哪一個機關的業務與我國野生動物貿易管理有關？', '行政院農業委員會', '動植物防疫檢疫局', '財政部關稅總局與各地區關稅局', '以上皆是', 4),
(2995,  '中高級',  '保育人員常會選擇特定的「保護傘物種」來推動進行保育工作。「保護傘物種」的意義及功用為何？', '「保護傘物種」對棲息環境的品質要求較高，因此可以連帶保護同一棲地的其他物種',  '「保護傘物種」用來作為明星物種，以爭取保育的經費', '「保護傘物種」是維繫棲地生態功能關鍵物種，牠的存在可以維護生態功能',  '「保護傘物種」是棲地中最高階的消費者，用來抑制棲地內其他的物種',  1),
(2996,  '中高級',  '下列何者「不是」外來種造成的影響？',  '因與本土種雜交而造成基因污染', '提高生物多樣性',  '與本地生物競爭棲地',  '引發疾病或寄生蟲傳播', 2),
(2997,  '中高級',  '面對海洋資源逐漸匱乏，我們可以採取的做法為何？',  '消除造成非法、不報告及不受規範漁捕行為以及造成漁捕能量過剩之漁業補貼', '落實執行禁漁期、禁漁區、漁業資源保育區等相關漁業管理措施', '加強培訓漁業資源養護及管理人才，並教育全民對漁業資源永續利用之認識',  '以上皆是', 4),
(2998,  '中高級',  '自然保留區的設置是依下列哪一項法規所推動？',  '文化資產保存法',  '國家公園法',  '野生動物保育法',  '以上皆是', 1),
(2999,  '中高級',  '下列何者是就地保育(現地保育)的做法？',  '設立動物收容中心', '設立國家公園', '建立植物種子庫',  '以上皆是', 2),
(3000,  '高級', '下列哪一外來種可能「不是」由於人為蓄意引入所造成的？', '互花米草', '福壽螺',  '小花蔓澤蘭',  '吳郭魚',  1),
(3001,  '高級', '下列對於人工溼地的?述何者是正確的？', '人工溼地所種植的植物主要為造景用途，對污水處理沒有效用',  '與污水處理廠相比較，以人工溼地系統來處理污染能較節省能源，為比較環保的方式',  '人工溼地因為多用於污水處理，因此不具有保存生物多樣性的功能',  '人工溼地建造完成後即能如同天然溼地運作，不需要人為介入經營重理',  2),
(3002,  '高級', '下列何者是《蒙特婁議定書》的內容？',  '管制國際間野生動植物貿易手段', '管制破壞臭氧層物質',  '推動維護全球生物多樣性',  '推動全球溼地保育', 2),
(3003,  '高級', '為了維護海洋資源，下列哪一項「不是」政府對於漁業管理的做法？', '制定禁漁區及禁漁期',  '給予休漁補助', '限制漁民的年齡',  '限制使用的漁具及漁法', 3),
(3004,  '高級', '對於外來種經營管理的?述下列何者「錯誤」？',  '提供正確知識與資訊並廣泛宣導與教育，增進大眾對外來物種影響的認識與認知',  '針對各種蓄意、非蓄意引入管道設計足夠的偵測機\n制，並能夠快速反應',  '立法管制外來種，限制外來種引進的管理及規範',  '限制對於外來種的研究以減少意外引入的機會', 4),
(3005,  '高級', '對於海洋生物多樣性的描述，下列何者為正確？',  '海洋生物在高分類位階(門或綱)的生物多樣性高於陸域生態系', '臺灣具有高的海洋生物多樣性的原因之一是由於同時有冷、暖洋流於沿海交會', '海洋生物具有高的遺傳多樣性，普遍有隱蔽種和同胞種的存在',  '以上皆是', 4),
(3006,  '中高級',  '臺灣地區造林應優先考量辦理的區域，「不包括」哪些地區？',  '山坡地',  '復耕性低或污染整治完成之農地', '都會公園', '嚴重地層下陷地區', 3),
(3007,  '中高級',  '哪一種作法會減緩因人為擾動而造成生物多樣性流失的速度？',  '規劃管理人為污染、開發、過度利用等擾動',  '排定優先次序，控制或根除優先入侵外來物種', '依照生態原則規劃與執行劣化生態系之復育',  '以上皆是', 4),
(3008,  '中級', '電動車的發展，早期目的是為了能源危機，今日則為了環保而推展。以下哪一項是使用電動車有利於環境保護的原因？', '外型時髦', '免繳空污費',  '不會排放二氧化碳', '有補助購車',  3),
(3009,  '高級', '以下何者「不是」臺灣綠建築的九大指標之一？',  '經濟價值', '基地保水性',  '日常節能', '生物多樣性',  1),
(3010,  '中高級',  '推廣「綠建築」的意義為何？',  '強調必須在屋頂種植綠色植物',  '強調能源效率的提升與節能', '強調房屋的使用過程完全不排放二氧化碳', '強調房子住戶必須為環保人士',  2),
(3011,  '高級', '下列何者「不是」綠建築的主要特徵？',  '高隱私',  '省資源',  '低污染',  '省能源',  1),
(3012,  '高級', '綠建築在臺灣共分為九大指標和四大指標群，以下哪一項是減廢指標群裡的項目？', '污水及垃圾的改善', '日常節能', '二氧化碳減量', '室內環境', 3),
(3013,  '高級', '綠建築的綠地面積愈多愈好。日本建設省要求綠覆蓋最好能在多少百分比以上，才不會造成人的焦慮？',  '5',  '10', '20', '30', 4),
(3014,  '中高級',  '以下各國的都市每人平均公園綠地面積何者最大？', '臺灣', '美國', '英國', '日本', 3),
(3015,  '中高級',  '以下哪一種建築型態能夠合理地降低能源耗損？',  '密不通風的全玻璃大樓', '無遮陽的玻璃大溫室',  '綠屋頂',  '水平大天窗',  3),
(3016,  '中高級',  '下列何項「不是」好的生態綠化方法？',  '綠地盡是人工草坪或草花花圃',  '利用多年生藤蔓植物攀爬建築立面以爭取綠化量',  '大部分綠地種滿喬木或複層綠化，小部分綠地種滿灌木', '在屋頂陽臺設置防水排水良好的花臺以加強綠化',  1),
(3017,  '中級', '下列哪一個吸收二氧化的作法，最有效率和符合經濟效益？', '綠化', '鹼吸收',  '製成乾冰', '合成沼氣', 1),
(3018,  '高級', '日常耗能以空調與照明用電佔最大比例，尤其以空調耗能影響為最。在臺灣，夏日的建築空調耗電佔總尖峰用量的多少？',  '二分之一', '三分之一', '四分之一', '五分之一', 2),
(3019,  '中高級',  '下列哪一種方法能夠在不影響生活的狀況下，輕鬆達到節能50-60%的效果？', '換LED電燈', '提高居家環境的生物多樣性', '增加庭園的綠地覆蓋率', '增設綠屋頂和外殼絕緣', 4),
(3020,  '中高級',  '下列哪一種作法「不符合」房屋的照明節能？', '選購燈具時，以低價為選購的主要考量',  '居室應保有充足的開窗面，以利自然採光', '使用壽命較長的節能燈具',  '室內採用明亮的設計，以提高照明效果',  1),
(3021,  '高級', '在建築二氧化碳減量上，下列何者為「錯誤」的敘述？', '儘量使用荷重較輕的鋼結構，避免使用磚石及鋼筋混凝土結構',  '採寒帶林木為材料的原木結構、木地板等材料，可儲存大量大氣中的CO2',  '鋼筋混凝土產生的二氧化碳小於鋼結構',  '鋼筋混凝土的耗能量大於鋼結構', 3),
(3022,  '中高級',  '建築的耗能很大，若可以延長房子的壽命，則可以大幅減低二氧化碳的排放。下列何種作法能夠延長房屋的壽命和可維修性？',  '安裝太陽能裝置',  '興建可以絕熱保水的綠屋頂', '以綠屋頂取代防水層分離',  '將水電管路等進行明管化設計',  4),
(3023,  '初級', '家裡的冰箱是家裡最耗能的電氣產品，因此如何正確使用冰箱是非常重要的。以下哪一項是有效節能減碳的作法？', '購買節能標章的冰箱',  '每週定期清理冰箱裡的物品', '減少開關冰箱的頻率',  '以上皆是', 4),
(3024,  '中級', '有關家裡冷氣的設置與使用，以下哪一種作法不能提高冷氣的效率？', '加裝窗簾', '加裝吊扇，增加空氣的循環', '冷氣出風口對著往下的樓梯', '冷氣控?於攝氏26-28度',  3),
(3025,  '中級', '下列關於節能減碳的做法何者「錯誤」？', '養成隨手關電的好習慣', '使用具有綠色標章的產品',  '將洗米水拿來澆花或沖馬桶', '電腦不使用時繼續開著電源', 4),
(3026,  '初級', '下列哪種消暑方法不能達到節能減碳的作用？', '冷氣溫度保持在26~28℃，並搭配風扇使用',  '使用傳統燈具，可使室內溫度降低',  '穿著透氣舒適的衣物，減少悶熱感',  '利用窗簾或百葉窗的設計，減少太陽照射，以降低室內溫度', 2),
(3027,  '中高級',  '冷氣應控?於26~28℃，既能使人感到涼爽也有助於減碳。當我們調高冷氣溫度設定值1℃時，可節省多少的冷氣用電？',  '1％', '6%', '25%',  '40%',  2),
(3028,  '高級', '若每年的建築物節能能夠達到20%，每年約可節約多少億元？', '1',  '10', '20', '30', 2),
(3029,  '中高級',  '生質能至今仍然無法完全取代傳統能源。下列何者是生質能源在推廣上的限制？',  '可減少環境公害，如垃圾等', '生質能是一種清潔的低碳燃料',  '衝擊食物鏈，使糧食價格提升，引發物價上漲', '生質能利用在轉換過程二氧化碳零排放',  3),
(3030,  '中級', '下列哪一項物質「不是」由太陽能間接而得的？',  '石油', '煤',  '木炭', '核能', 4),
(3031,  '中高級',  '低碳生活中所要減的「碳」，指的是來自千萬年前物質。下列何者是前述說明所指的「碳」來源？',  '生質酒精', '生質柴油', '石油和煤', '核電', 3),
(3032,  '高級', '森林中每立方公尺的木材量，每年可以固定約多少噸的二氧化碳？',  '1',  '5',  '10', '100',  1),
(3033,  '中高級',  '生質能的發展必需考慮原料的供應是否充足。下列何樣廢棄物能夠生產「生質能」？',  '廢紙', '廢印刷電路板', '廢食用油', '廢玻璃',  3),
(3034,  '初級', '以下哪一項「不是」節約總用水量的好方法？', '雨水的回收',  '減低工業用水', '減少打掃洗地的次數',  '以淋浴替代泡澡',  3),
(3035,  '中高級',  '下列哪種能源的產生方法符合節能減碳？', '燃煤發電', '火力發電', '風力發電', '柴油發電', 3),
(3036,  '中高級',  '在生活中，人們的食衣住行都跟減碳息息相關，下列說法何者「錯誤」？', '回收舊衣給需要的人',  '多選用在地的天然食材', '在住宅加裝白熾燈泡',  '在路邊短暫停車時，可將引擎熄火',  3),
(3037,  '中高級',  '以下各種再生能源，哪一項必須仰賴足夠的陽光才能穩定地供電，否則就得靠電池將電力貯存？', '生質酒精', '水力發電', '太陽能發電',  '風力發電', 3),
(3038,  '高級', '以前化石能源十分充足時，人類都不太注意亂度所形成的能源。以下哪一項動力的發明是有效利用分散殘餘的能量？',  '電梯發電', '油電混合動力', '腳踏車的頭燈', '以上皆是', 4),
(3039,  '初級', '防火巷最主要的功能是什麼？',  '火災時的避難處',  '防止火勢蔓延', '停放機車、腳踏車', '玩捉迷藏', 2),
(3040,  '初級', '在面對各個季節流行疾病的來臨，我們應該如何因應？', '多去醫院打針吃藥', '待在家中不要出門', '保持環境清潔養成良好個人衛生習慣', '對於染病的同學排斥不理',  3),
(3041,  '初級', '下列哪位民眾的行為最容易引發火災？',  '電腦玩到半夜12點',  '跟朋友講電話', '隨手關燈', '在自家頂樓放鞭炮', 4),
(3042,  '初級', '假如家中發生火災，應撥打下列何者電話號碼求救？',  '113',  '165',  '119',  '1950', 3),
(3043,  '初級', '農委會水土保持局於颱風期間發布土石流紅色警戒時，住在警戒區的民眾應配合事項為何？', '待在家裡注意廣播或電視',  '撤離至鄉鎮公所安排之避難所',  '主動集中到土石流溪流谷口平坦處避難',  '暫時搬到房子比較堅固的鄰居家', 2),
(3044,  '初級', '廚房是家中最易引起火災的地方，作飯、燒菜時儘量避免離開現場；一旦讓油鍋起火時，應用何種方式在第一時間將火儘速撲滅？',  '馬上用大量的水撲救',  '蓋上鍋蓋，即時使用滅火器', '打開抽油煙機把火抽走', '只打電話給消防隊來救火',  2),
(3045,  '初級', '下列何種行為將增加山崩、土石流的發生機率？',  '不當開發山坡地',  '多種植樹木',  '做好水土保持', '遠離土石流危險區', 1),
(3046,  '中級', '下列哪一類的山坡地較穩定？',  '坡度較陡處',  '板塊邊緣地震頻繁處',  '農牧業土地高度利用處', '複層植被處',  4),
(3047,  '中級', '以下哪項條件與臺東出現焚風有關？', '冬天的東北季風',  '夏季颱風引進之西南氣流',  '春季之梅雨',  '秋季偶發之氣溫上升',  2),
(3048,  '高級', '針對防災四階段來說，下列何者屬於「?建」(Recovery)的措施？', '災民的收容與撤?', '重建公共建設', '防止二次災害發生', '擬定疏散避難演?', 2),
(3049,  '中高級',  '下列何者「不是」健康綠建材審查要點中的管制目標？', '重金屬',  '總揮發有機化合物', '甲醛', '二氧化碳', 4),
(3050,  '中級', '下列何種自然災害對堰塞湖的形成影響最小？', '颱風帶來的豪雨',  '地震', '火山爆發', '乾旱', 4),
(3051,  '中級', '欲防止地層持續下陷最妥當的方法為何？', '填土', '減少超抽地下水',  '大量引入工業', '增加灌溉', 2),
(3052,  '中高級',  '甲基第三丁基醚(MTBE)是一種對動物具有致癌性的毒性化學物質，常添加至我們日常生活的哪一類物品中？', '油炸食品', '無鉛汽油', '污泥餅',  '環境衛生用藥', 2),
(3053,  '中高級',  '下列對地震的敘述何者「錯誤」？',  '地震本身的大小與釋放的能量有關',  '用以表示地震釋放能量的規模是一個沒有單位的實數，例如地震規模\"6.5\"',  '地震搖晃程度(震度)則以整數值的\"級\"來表示，例如5級',  '地震的震度與距離震央的遠近無關',  4),
(3054,  '初級', '下列何者「不是」國際間對於溫室效應主要管制的氣體？',  '甲烷', '氧化亞氮', '二氧化碳', '氨氣', 4),
(3055,  '中高級',  '下列哪一個地區恰位於板塊邊界線？', '臺北盆地', '林口臺地', '嘉南平原', '花東縱谷', 4),
(3056,  '中級', '為防範持久性有機污染物危害，國際間所簽訂的公約為以下何者？',  '蒙特婁議定書', '巴賽爾公約',  '斯德哥爾摩公約',  '維也納公約',  3),
(3057,  '中高級',  '哪個季節的颱風容易產生共伴效應，加劇颱風災害？',  '春季', '夏季', '秋季', '冬季', 3),
(3058,  '中高級',  '下列何者「不是」屬《蒙特婁議定書》列管之化學物質？',  '過氧硝酸乙醯(ㄒ一)酯(PAN)', '氟氯碳化物(CFCs)',  '海龍(Halons)', '氟氯烴(ㄊㄧㄥ)', 0),
(3059,  '中高級',  '颱風是指一種劇烈的熱帶氣旋，此熱帶氣旋的形成來源為下列何者？', '從北方大陸而來的高氣壓',  '從熱帶海洋而來的低氣壓',  '在臺灣本島上產生的強大氣流',  '是溫室效應產生的極端氣候現象', 2),
(3060,  '中高級',  '臺灣集集地震斷層錯動屬哪一類斷層？',  '正斷層',  '逆斷層',  '左移斷層', '右移斷層', 2),
(3061,  '中高級',  '颱風在水平方向上可分為下列幾個部分？(A)螺旋雲(雨)帶(B)雲牆區(C)暖心帶(D)颱風眼。',  'ABC',  'BCD',  'ACD',  'ABD',  4),
(3062,  '高級', '何謂土壤液化？',  '土壤顆粒因高溫高壓，由固體變為液體',  '地震後土壤顆粒堆疊方式改變，原本空隙中的水分被擠出',  '連日降雨使得土壤長時間泡在水中而軟化', '土壤被酸雨侵蝕溶解',  2),
(3063,  '高級', '以下對於土石、邊坡之敘述何者正確？',  '大顆粒會沉澱到土石流的最底層', '順向坡滑動是一種平面型滑動',  '深層滑動指厚度約3公尺的土壤移動', '落石指受節理切割之岩塊自坡面墜落', 2),
(3064,  '高級', '關於地震規模以下敘述何者正確？',  '與地震釋放能量有關',  '多以整數之分級表示其大小', '數字愈大、地震愈小',  '同一地震，不同地區其規模不一', 1),
(3065,  '高級', '下列何種行為「不會」導致海嘯現象？',  '海底火山的噴發',  '海底山崩', '核爆', '颱風', 4),
(3066,  '高級', '下列何者是造成暴潮的原因？',  '板塊移動', '全球暖化', '颱風', '地層下陷', 3),
(3067,  '初級', '對於降低災害所帶來的影響力，下列何者「不是」以預防勝於治療的觀念的政策？', '辦理防災研討會',  '豎立土石流警告牌', '加強災後重建', '發送防災宣導品',  3),
(3068,  '高級', '熱帶雨林消失將對環境帶來什麼影響？(A)氣候異常(B)全球溫度上升(C)水土流失(D)再生能源增加。', 'AB', 'BCD',  'ABC',  'BD', 3),
(3069,  '中級', '災害管理是分成幾個階段來操作？',  '二階段',  '三階段',  '四階段',  '五階段',  3),
(3070,  '初級', '下列何者「不是」臺灣常見的天然災害？', '地滑', '落石', '颶風', '颱風', 3),
(3071,  '中級', '下列何者「不是」氣候變遷所造成的災害？',  '犯罪率提升',  '加劇熱島效應', '電氣設備容易暴露於危險中', '都市污水處理與衛生設施亦受衝擊',  1),
(3072,  '初級', '看見有人危害到社區環境，我們應該採取下列何種行為？',  '試圖勸說，請他停止不當行為',  '看著他破壞環境',  '跟他一起破壞社區環境', '馬上跑走', 1),
(3073,  '初級', '何種是有益社區的環境行為？',  '喝完的飲料空罐隨手丟棄',  '看到有人破壞社區的綠化植栽會制止他人的行為',  '亂攀折花草',  '拿粉筆在圍牆／鐵門上畫圖', 2),
(3074,  '初級', '維護社區的環境是誰的責任？',  '負責打掃的工友們', '清潔隊',  '社區的每一份子',  '跟大家都無關', 3),
(3075,  '中級', '下列何種行為有害社區環境？',  '幫社區的植物澆水', '覺得社區蚊蟲太多，可以從家裡拿殺蟲劑來噴', '看到地上有垃圾隨手撿起',  '幫忙社區做綠美化', 2),
(3076,  '中級', '面對全球的環境問題，社區應該如何做以減少對環境的破壞？',  '路燈更換成LED燈',  '多種植綠色植栽',  '公共建築屋頂架設太陽能板', '以上皆是', 4),
(3077,  '中級', '下列社區垃圾分類的方式何者「錯誤」？', '舊錄影帶可以直接放在塑膠類回收',  '電池、光碟可以拿到便利超商回收並換等價商品',  '廚餘回收必須把生熟分開',  '回收任何罐裝物品，需把罐內液體倒至乾淨才可回收',  1),
(3078,  '初級', '面對全球的環境問題，社區民眾可以做到甚麼來維護社區環境？', '路燈開整天',  '多使用替代行為代替汽機車', '在綠地上鋪水泥架設新球場', '每逢佳節大放煙火', 2),
(3079,  '初級', '下列何者是社區努力減少全球溫度繼續升高的方法？',  '鼓勵大家吹冷氣',  '鼓勵節能減碳做環保',  '不需做垃圾分類',  '路燈開整天',  2),
(3080,  '初級', '下列哪一種行為對社區環境保護最有利？', '汽機車亂停',  '把家裡不要的盆栽拿到路上放',  '勸阻他人破壞環境的行為',  '亂丟垃圾', 3),
(3081,  '高級', '面對社區的開發，我們應該用何種態度面對？', '為了維護家園的生活品質，我們應該抵抗社區的開發',  '無論開發地點是否在自身住家旁，都去參與開發事宜',  '謹慎考量並查詢相關的資料，回饋給社區負責人',  '以上皆是', 4),
(3082,  '高級', '下列關於社區參與的內容，何者正確？(A)確認社區參與的角色(B)組織權益相關的團體及個人(確認利害關係人)(C)邀社區領袖參與(D)瞭解當地特色(參與資源調查)', 'AB', 'ABC',  'ACD',  'ABCD', 4),
(3083,  '高級', '下列何者為凝聚居民社區參與的重要關鍵？',  '社區經費', '政府官員', '地方感',  '地方勢力', 3),
(3084,  '高級', '依據社區營造的理念與做法，採循序漸進的方式進行三階段的推動，下列何者「錯誤」？',  '社區自主', '居民參與', '政府補助', '永續經營', 3),
(3085,  '高級', '下列何者「不是」社區參與相關產業成功推動的因素應包含哪些項目？',  '政治因素', '增進社區的應變能力',  '財務及人力資源的支持', '社區當地之生態',  1),
(3086,  '高級', '下列何者「不是」社區保育與公共參與應優先從事的項目為？',  '可幫助政府相關單位取得知識',  '可作為資源管理規劃與合作協商的基礎',  '作為資源管理的手段，大量無限制的使用資源', '促進地方感情融洽', 3),
(3087,  '高級', '依室內空氣品質標準，室內二氧化碳8小時濃度標準為多少ppm？', '250ppm', '500ppm', '1000ppm',  '2000ppm',  3),
(3088,  '中高級',  '下列哪一項「不是」對二氧化硫正確的敘述？', '為白色氣體',  '具刺激臭味',  '作為漂白劑',  '作為防腐劑',  1),
(3089,  '初級', '下列何者與雨水酸化有直接的關係？', '車輛快速增加', '工業轉為農業', '經濟停滯發展', '少子化現象',  1),
(3090,  '中級', '目前臺灣公告之室內空氣品質標準「?包含」下列何者？',  '總揮發性有機氣體', '一氧化碳', '嗜肺性退伍軍人桿菌',  '臭氧', 3),
(3091,  '高級', '我國《空氣污染防制法》中，下列何者屬於衍生性污染物？', '鉛',  '臭氧', '氯化氫',  '二氧化硫', 2),
(3092,  '初級', '下列何者能有效控制道路揚塵現象？', '填補路面坑洞', '增設大型風扇', '增加行駛車輛', '沖洗路面', 4),
(3093,  '中級', '下列何者是屬於固定污染源？',  '柴油火車', '工廠煙囪', '船舶', '飛機', 2),
(3094,  '初級', '下列哪一層是人類生活的主要環境？', '對流層',  '平流層',  '增溫層',  '中氣層',  1),
(3095,  '初級', '下列何者是屬於自然懸浮微粒？', '火山灰',  '工業灰塵', '煤煙', '汽車廢氣', 1),
(3096,  '中級', '若今日空氣污染指標為不良，下列何者「錯誤」?', '所監測的五項污染物，均達不良', '所監測的五項污染物，至少4項達不良',  '所監測的五項污染物，至少3項達不良',  '所監測的五項污染物，至少1',  0),
(3097,  '中級', 'pH值是用來判斷液體為酸性或鹼性的單位，pH值之範圍介於下列何者之間？',  '0至7',  '1至10', '0至14', '1至15', 3),
(3098,  '初級', '下?何者?是國內「空氣污染指標值(PSI)」指標物？', 'PM10', 'NO2',  'SO2',  'CO2',  4),
(3099,  '中高級',  '紅外線攝影機所發出的紅外線是屬於下列哪一種輻射？', '非游離輻射',  '游離輻射', 'Ｘ射線',  'γ射線',  1),
(3100,  '高級', '下列何者會影響電磁波特性？',  '傳播速度', '強度', '頻率', '以上皆是', 4),
(3101,  '中級', '下列何者對電磁波傳播速度的描述是正確的？', '比光速快', '比光速慢', '和光速一樣',  '無法比較', 3),
(3102,  '中高級',  '對電磁波振動的介紹，下列何者「錯誤」？',  '振動方向與波的行進方向相互垂直',  '是為橫波(TransverseWave)', '和光速一樣快', '和音速一樣快', 4),
(3103,  '中高級',  '對於非職業場所之公眾，曝?於環境中各頻段與磁通量密度限制間之關係何者正確？',  '頻段低時，磁通量密度限制數值較小', '頻段低時，磁通量密度限制數值較大', '頻段不同時，磁通量密度限制值都相同',  '頻段與磁通量密度限制值間無特定關係',  2),
(3104,  '高級', '在電磁場管制上，我國對行動電話基地臺產生電磁波之參考位準值，目前國家通訊委員會(NCC)已將該參考位準則納入第幾代行動通信業務管理規則中？',  '第一代',  '第二代',  '第三代',  '第四代',  3),
(3105,  '高級', '對於非游離輻射管制項目中，下列何者屬於低頻者？',  '高壓電塔', '廣播電臺', '雷達站',  '基地臺',  1),
(3106,  '中級', '國內已發佈的電磁波法規與相關標準，發佈單位包括下列何者？', '國家通訊傳播委員會',  '環保署',  '經濟部能源局', '以上皆是', 4),
(3107,  '初級', '紫外線可能會對人體哪些方面產生危害？', '皮膚', '免疫系統', '眼睛', '以上皆是', 4),
(3108,  '中高級',  '若今日的紫外線指數(UVI)為6，是屬於哪一等級？',  '低量級',  '中量級',  '高量級',  '過量級',  3),
(3109,  '中高級',  '都會地區基地臺愈密集，則下列何項描述為「錯誤」？', '通話品質良好', '各基地臺間輸出電磁波功率可降低',  '通話品質因過度密集而變差', '行動電話發射功率可降低',  3),
(3110,  '中級', '下列何者為非游離輻射中波長最短的輻射線？', '紫外線',  '紅外線',  '可見光',  '以上皆非', 1),
(3111,  '初級', '新聞時常報導太陽大時出門要做好防曬措施，預防紫外線，下列何者「不是」紫外線對皮膚造成之慢性危害？', '皮膚老化', '免疫系統之影響',  '皮膚癌',  '皮膚發紅、疼痛',  4),
(3112,  '中高級',  '雷射光為經由(原子)激發所產生的強烈光線放射，直射會對人體造成危害。下列何者「不是」雷射造成身體危害之主要機轉？', '光化學傷害',  '熱傳導傷害',  '熱燒傷',  '熱音震效應',  2),
(3113,  '高級', '現在生活中廣泛運用的無線電波，如收音機、電視機。下列何者為其波長？',  '0.1-15cm', '400-700nm',  '15cm-2km', '100-400nm',  3),
(3114,  '中高級',  '下列何者「不屬於」非游離輻射的運用？', '醫生讓病人照X光診斷病情', '實驗室使用紫外光消毒', '開車時收聽廣播節目',  '將冷掉的飯菜用微波爐加熱', 1),
(3115,  '中級', '關於電磁波防治相關法規製作及管制，為政府哪一個行政單位執行？', '行政院衛生署', '行政院環保署', '行政院公共工程委員會', '行政院勞委會', 2),
(3116,  '高級', '下列哪個範圍的波長在我們眼中看起來為紅色？',  '200-400nm',  '400-600nm',  '600-800nm',  '以上皆非', 3),
(3117,  '高級', '下列何者是聯合國政府間氣候變遷委員會簡稱？',  'IPCC', 'FAO',  'UNFCCC', 'UNCSD',  1),
(3118,  '中級', '聯合國氣候變遷委員會的報告認為當人類活動對於地球環境造成的各種影響，超越地球動態平衡的臨界點，便會引起各種難以預測的變遷，其中以大氣的變化最為顯著，特別是全球暖化的現象。臨界點指的溫度是幾℃？', '1℃', '2℃', '3℃', '4℃', 2),
(3119,  '初級', '造成氣候變遷最重要的因素，就全球尺度而言哪一項是最重要的？',  '二十世紀的二次世界戰爭',  '波灣石油戰爭', '全球糧食危機', '人類大量使用化石能源', 4),
(3120,  '中級', '造成氣候變遷最重要的因素，就區域及地方尺度而言，哪一項是最重要的？',  '人口爆炸', '都市化與土地使用變遷', '全球農業發展', '工業發展', 2),
(3121,  '中級', '以下哪一項「不是」聯合國過去幾次重要氣候變遷會議之目的？', '要求經濟強國付款給落後國家保護熱帶雨林',  '期望透過全球各國的合作與努力來促使溫室氣體減量',  '解除造成氣候變遷的肇因',  '減緩氣候變遷的衝擊',  1),
(3122,  '中高級',  '聯合國氣候變化綱要公約(UNFCCC)是在哪一次聯合國重要會議時簽訂的？', '1992年在巴西里約召開的地球高峰會', '2002年在南非召開的地球高峰會', '2012年在巴西里約召開的地球高峰會', '1997年日本京都會議',  1),
(3123,  '高級', '《京都議定書》在1997年日本京都會議時簽訂，明確訂定各國溫室氣體減量責任與時程。但是在各國各有其考量下，到了哪一年二月才生效？', '1998年',  '2000年',  '2002年',  '2005年',  4),
(3124,  '中高級',  '以下哪一項目「不是」2010年墨西哥坎昆協議(Canc\'unAgreement)的主要內容？',  '將協議轉成具法律約束力的協約', '以各國之國家適當減緩行動為主要方法',  '運用綠色氣候基金協助開發中國家',  '運用技術機制協助開發中國家',  1),
(3125,  '中高級',  '我國的溫室氣體減量目標是「全國二氧化碳排放減量，於哪一年要回到2005年排放量」？',  '2013年',  '2015年',  '2020年',  '2025年',  3),
(3126,  '中高級',  '下列關於氣候變遷的調適策略之敘述，哪一項是「錯誤」的？',  '調適是為了因應氣候衝擊，在自然或人類系統所做的調整',  '調適的目的在降低人類與自然處於氣候變遷影響與效應下的脆弱度',  '調適使得人類與自然在極端天氣與暖化下的負面衝擊最小',  '調適策略著重於提高二氧化碳排放與暖化下的衝擊', 4),
(3127,  '中高級',  '以下哪一個政府機關負責臺灣氣候變遷調適水資源領域的工作分組？', '經濟部',  '國防部',  '內政部',  '財政部',  1),
(3128,  '中高級',  '除了全球暖化後的平均海平面上升因素外，下列何者「不是」影響臺灣周遭海域海平面上升的因素？', '東太平洋海平面持續上升',  '西太平洋海平面持續上升',  '聖嬰現象等氣候現象',  '鄰近海域海平面的改變', 1),
(3129,  '初級', '氣溫升高會造成許多農業生產的衝擊，以下哪一項「不會」發生？',  '干擾農園藝作物的生長期',  '促進雜草生長', '加速病蟲害繁殖',  '常導致稻米品質變佳',  4),
(3130,  '中級', '下列何者「不是」海水溫度上升對水產養殖漁業生產的衝擊？',  '改變養殖之水質環境',  '增加水產疾病風險', '衝擊水產養殖物種生產力',  '增加寒帶水產養殖物種生產量',  4),
(3131,  '中高級',  '溫度上升會衝擊森林的生物多樣性，下列何者敘述「不正確」？', '暖化可能導致中海拔溫帶針葉林分布向下推移', '暖溫帶雨林群系的變動幅度最大', '冷溫帶與亞高山針葉林群系僅能零星分布在海拔極高的山區', '高海拔溫帶針葉林分布向上推移、面積因而縮減',  1),
(3132,  '中高級',  '下列何者是氣候變遷發生的主因？',  '溫室效應', '藤原效應', '熱島效應', '衝擊效應', 1),
(3133,  '中高級',  '下列何者「不是」海岸防風林的主要功能？',  '抗風、抗鹽、生產', '提供野生動物棲地', '維護景觀、保護農地',  '提供薪材能源', 4),
(3134,  '中高級',  '在氣候變遷的影響下，海洋生態系受到的衝擊很多，下列何者敘述「不正確」？',  '水溫升高衝擊物種的適應存續',  '海水酸化改變海水物理及化學特性',  '降雨改變影響鹽度、溶氧',  '洋流流向與湧昇流強度不會受到影響', 4),
(3135,  '中高級',  '最容易受到影響的物種通常具有一些共同的特性。下列何者「不是」它的共同特性？',  '分布範圍很廣', '生態需求特殊', '播遷能力薄弱', '分布在現有分布範圍邊緣',  1),
(3136,  '中高級',  '下列何者「不是」造成物種滅絕的原因？', '物種間相互依存的關係出現改變', '遷移性動物因遷移路線上任一處棲地的變化',  '人類過渡的捕捉',  '以上皆是', 4),
(3137,  '初級', '臭氧層被破壞後，太陽光中的哪一種能量會透入大氣中，危害人?的健康？',  '宇宙射線', '紅外線',  '紫外線',  '雷射', 3),
(3138,  '中級', '就臺灣而言，下?何者屬於全球性的環境問題，需透過國際合作解決？',  '地下水污染',  '噪音', '酸雨', '土壤污染', 3),
(3139,  '中高級',  '全球氣溫上升會拉長氣候相關蟲媒傳染性疾病發生的時間。以下哪一類的疾病比較「沒有」關連？',  '登革熱',  '恙蟲病',  '日本腦炎', '痛痛病',  4),
(3140,  '中高級',  '受到極端高溫或低溫的環境影響，下列哪一種疾病死亡的風險較高？', '肝病', '心血管疾病',  '癌症', '呼吸道疾病',  2),
(3141,  '中高級',  '在極端降雨後，下列哪一種疾病傳染機率「不會」提高？',  'A型肝炎', '桿菌性痢疾',  '類鼻疽等傳染性疾病',  '以上皆會提高', 4),
(3142,  '高級', '以下哪一項「不是」優先處理高風險地區的原因？', '複合性災害風險增加程度',  '脆弱度',  '復原難度', '生命財產損失程度', 4),
(3143,  '高級', '推動災害預警科技整合，強化災害模擬與預警有助成為許多決策的依據。下列哪一項「不是」其目的？',  '減災', '防災預警', '發展防災技術', '土地管理', 3),
(3144,  '高級', '檢視、修訂既有或新建維生基礎設施之設計與抗災能力時，應以何者為假設條件？', '最貴技術', '未來一百年可能出現極端氣候',  '當年最符合成本的工法為假設條件',  '歷史上曾發生之最嚴重事件可能再發生的機率', 4),
(3145,  '初級', '重視森林保護，使森林在上游發揮阻水、儲水的功能，並維持良好的水土保育，能夠防治下列何種災害的發生？',  '地層下陷', '颱風', '地震', '洪水', 4),
(3146,  '高級', '針對災區土石災害防治，若現有工程方法暫無法克服，則可採用軟體防災措施因應。「軟體防災措施」指的是什麼？',  '崩塌地處理',  '植生復育', '治理策略、工法',  '疏散避難規劃及演練',  4),
(3147,  '中級', '聯合國推動之「水足跡」的概念中，「不包括」以下哪一項思維？',  '標示產品之耗水量', '推動產業建立節水製程', '推動水資源回收再利用及節約用水獎勵機制',  '推動購買使用國外進口的瓶裝水', 4),
(3148,  '初級', '以下哪一項是生態敏感地？', '稻田', '水雉生態區',  '臺北木柵動物園',  '生態池',  2),
(3149,  '高級', '以下哪一項「不是」建立以調適為目的之土地使用管理相關配套機制？',  '建構國土保育區的土地使用績效管制', '建立受災土地之合宜的救助、補償機制等配套措施', '中央應訂定成長管理指標，做為評估檢討國家發展、資源使用之依據', '建立生態系服務付費制度',  3),
(3150,  '高級', '首都與周邊地區相鄰之河流堤防防洪設計值應該要如何整合？',  '都市應高於外圍',  '都市與其外圍交界處之保護量要得以銜接', '付得起錢的城市設計值可以較高', '依照河川流域兩旁都市人口密度開發程度來設計',  2),
(3151,  '高級', '都市內要落實設置滯洪及設施與空間，以下哪一項「不是」適宜優先考慮之處？',  '公園', '學校', '復耕可能性高之農地',  '公有土地', 3),
(3152,  '中級', '推動地層下陷地區產業轉型再發展時要結合哪些目標？', '治水', '產業', '土地開發', '以上皆是', 4),
(3153,  '高級', '為了提升產業抗逆境能力，需要培育的作物品系中「不包括」哪些類別？', '耐病蟲害', '耐旱', '耐澇及耐鹽',  '耐輻射線', 4),
(3154,  '中級', '氣候變遷造成土地使用的衝擊，可能受到經濟影響最大的是下列何者？',  '東部沿海地區', '西部沿海地區', '金門', '馬祖', 2),
(3155,  '中高級',  '由於熱島效應，高密度的都市地區與周邊地區的溫差可能達到幾度C？',  '1℃', '3℃', '5℃', '10℃',  4),
(3156,  '高級', '全球氣候變遷與溫室效應的影響日益明顯，減緩與調適為各國政府因應氣候變遷威脅的兩大重要策略。「減緩」指的是何種策略？',  '減低民眾對於溫室效應和全球暖化議題的迷思，認真面對問題',  '以人類的科技結合自然的覆育，提高溫室氣體的排放',  '讓環境經由自然方式覆育，並減低溫室效應',  '以人為干預的方式，減少溫室氣體排放量', 4),
(3157,  '高級', '以下哪些減緩碳排放量或調適策略「不會」產生空間上的競合關係，需要透過土地使用規劃的機制來處理？',  '興建綠色基盤設施', '防災資源分派', '發展機會', '以上皆是', 4),
(3158,  '初級', '現今臺灣飲用水主要來源為何？', '山泉水',  '井水', '地下水',  '自來水',  4),
(3159,  '初級', '下列何者「不是」包裝飲用水？', '包裝礦泉水',  '包裝蒸餾水',  '包裝純水', '包裝氣泡水',  4),
(3160,  '初級', '水塔、水池清洗為建築物用水設備之重要維護工作，至少多久應清洗一次？',  '三個月',  '半年', '一年', '兩年', 2),
(3161,  '中高級',  '電鍍時，大量鎘排放入廢水中，食用過量的鎘可能導致哪種病？', '心臟病',  '痛痛病',  '皮膚病',  '精神病',  2),
(3162,  '中級', '國內現行標準飲用水PH值介於何者間？', '5~7.5',  '6~8.5',  '7~9.5',  '8~10.5', 2),
(3163,  '中高級',  '飲用水中鉻濃度標準定為0.1mg/L，鉻酸鹽中毒有可能會引起下列哪個症狀？',  '皮膚病變', '咳嗽不止', '記憶衰退', '痙攣', 1),
(3164,  '高級', '下列何者為持久性有機污染物？', '達馬松',  '戴奧辛',  '巴拉松',  '氯乙烯',  2),
(3165,  '中高級',  '下列何者「不是」飲用水水質之物理性標準項目？', '臭度', '濁度', '深度', '色度', 3),
(3166,  '高級', '水質項目裡的硒如過量會為害身體何處？', '循環系統', '神經系統', '消化系統', '心臟血管系統', 2),
(3167,  '中高級',  '自?水廠處?飲用水，下列何者「不屬於」處?步驟？', '混凝處?', '沉澱處?', '消化處?', '過?處?', 3),
(3168,  '高級', '下列有關水質之敘述，何者「錯誤」？',  '美國飲用水中最常出現的寄生蟲是梨形原蟲(Giardia)', '飲用含高濃度氟化物水源的民眾普遍都沒有蛀牙，但有黃斑牙的情形', '硝酸銅處理之主要目的為除去水中藻類之臭味', '曝氣處理，可以氧化水中鐵、錳', 3),
(3169,  '中級', '除了二氧化碳之外，下列哪一種氣體亦為主要的溫室氣體？', '氧氣', '氫氣', '甲醛', '甲烷', 4),
(3170,  '中級', '為了鼓勵民眾節約用電而推行的「電費折扣獎勵節能措施」，對於節能減碳的正向效果為何？',  '增加了森林的二氧化碳固碳功能', '激勵民眾長期於日常生活中持續力行節約能源', '降低對風力發電依賴並發展更多綠色能源', '解決發電長期供應過剩的狀況',  2),
(3171,  '高級', '臺電每年在夏季用電尖峰實施「夏月電價」。以下何者關於夏月電價的敘述為正確？',  '於每年6-10月實施', '調降供電成本較低的夏月電價',  '夏月電價收費較高', '夏月電價只針對家庭用戶實施',  3),
(3172,  '中高級',  '從經濟的角度來看，下列何種方式減碳的成本最低？',  '種植臺灣杉',  '以石化技術減碳',  '以一般能源技術減碳',  '以核能技術減碳',  1),
(3173,  '初級', '以下哪一項「不是」臺灣都市綠建築避免熱島效應作法？',  '架設綠屋頂',  '多建金屬玻璃帷幕大樓', '增設草溝設計', '在空地設計貯集滲透水池',  2),
(3174,  '中高級',  '關於建築中常用的金屬玻璃帷幕牆，下列何者敘述正確？',  '玻璃帷幕牆適用於臺灣，讓夏天的室內產生溫暖的感覺', '臺灣的氣候溼熱，特別適合在大樓以金屬玻璃帷幕作為建材', '玻璃帷幕牆的使用能節省室內空調使用',  '在溫度高的國家，建築使用金屬玻璃帷幕會造成日照輻射熱，產生室內「溫室效應」',  4),
(3175,  '高級', '如果地球沒有溫室效應，對整體環境會造成何種影響？', '北極熊不會面對滅絕的問題', '環境會變更美好',  '地球氣溫會忽高忽低',  '對環境沒有影響',  3),
(3176,  '初級', '《京都協議書》主要共識是什麼？',  '全面管制塑化劑的使用', '全面管制多氯聯苯', '環境荷爾蒙物質的管制', '管制二氧化碳的排放',  4),
(3177,  '中高級',  '關於《京都協議書》的敘述，何者正確？', '發起國家為美國，簽署地點在日本京都',  '是繼哥本哈根協議後的第一個碳交易管制', '臺灣也是簽署國家之一', '可分為京都機制與自願減碳系統兩大類',  2),
(3178,  '中級', '為預防世界各國排放溫室氣體，影響全球氣候，國際上於1997年共同簽署哪一項議定書？',  '京都議定書',  '倫敦議定書',  '多倫多議定書', '首爾議定書',  1),
(3179,  '初級', '如果社區的塑膠袋、保麗龍沒有人回收，我們看到後應該要怎麼做？', '交給資源回收車',  '丟入垃圾車',  '貯存在家裡',  '露天焚燒', 1),
(3180,  '初級', '下列何者是鐵罐的特徵？',  '一體成型無接縫',  '質輕、運輸成本較低',  '易壓扁回收',  '罐身有接縫',  4),
(3181,  '初級', '刀片、玻璃碎片等尖銳利器，應該如何正確的處理？',  '太危險了，趕快丟進垃圾桶', '用黑色塑膠袋裝起來丟棄',  '拿舊報紙包好，裝垃圾袋後，在上面註明有利器',  '倒進馬桶裡沖掉',  3),
(3182,  '初級', '若清潔隊的服務態度不好或專業知識不足，而未落實資源回收工作，應該如何反應？',  '拿垃圾丟擲',  '擋住垃圾車和他理論',  '打去環保局檢舉',  '打去消防局檢舉',  3),
(3183,  '初級', '我們把鋁罐交給資源回收人員前，應該要先做什麼處理？',  '將容器內殘留物體清除', '用水略為清洗', '壓扁打包', '以上皆是', 4),
(3184,  '中級', '下列何者「不是」廢輪胎的主要成分？',  '橡膠', '塑膠', '鋼絲', '纖維', 2),
(3185,  '初級', '關於舊衣回收的方式，下列何者「錯誤」？',  '投入政府核准設置的舊衣回收箱', '捐給慈善團體', '舉辦跳蚤市場', '丟入垃圾桶',  4),
(3186,  '中級', '5R為垃圾減量的五項原則，下列何者正確？', 'Refuse：拒用無環保觀念產品', 'Repair:重複使用容器或產品', 'Recycle:重視維修保養', '以上皆是', 1),
(3187,  '初級', '廢機油應該如何處理較為適當？', '倒進馬桶', '拿去附近的機車行回收', '在水槽沖洗掉', '倒入排水溝',  2),
(3188,  '初級', '下列何者能當作舊衣回收交給環保局清潔隊資源回收車?',  '枕頭', '圍裙', '窗簾', '學校制服', 4),
(3189,  '中高級',  '關於國際的塑膠分類標誌，下列何者「錯誤」？',  '1代表聚苯乙烯',  '2代表高密度聚乙烯',  '3代表聚氯乙烯',  '5代表聚丙烯', 1),
(3190,  '初級', '下列何者是可以回收的廢棄物？', '牛奶瓶',  '手機電池', '鐵罐', '以上皆是', 4),
(3191,  '中級', '廢日光燈管被歸類為有害垃圾的原因為何？',  '含有水銀', '為玻璃材質',  '含有金屬', '以上皆是', 1),
(3192,  '中高級',  '廢輪胎的處理方式「不包括」下列哪一種？',  '熱裂解',  '原型利用', '作為橡膠瀝青', '回收作為塑膠袋',  4),
(3193,  '初級', '日常生活中，哪些是「不環保」的行為？', '出門購物攜帶購物袋',  '使用環保筷',  '口渴時就購買瓶裝水',  '紙張使用時雙面書寫',  3),
(3194,  '初級', '關於廢電子電器回收，下列敘述何者「錯誤」？',  '交給新機販賣業者', '電話洽詢清潔隊',  '透過資源回收網協助',  '電話洽詢消防隊',  4),
(3195,  '中級', '關於藥品容器內之剩餘藥品應該如何處理？',  '棄置於馬桶或水槽中',  '交由連鎖藥粧店回收點', '併同家戶一般垃圾交由清潔隊處理',  '給相同症狀的親友吃',  3),
(3196,  '初級', '壞掉的手機應該如何適當的處理？',  '送交清潔隊資源回收車', '送交行動通訊門市回收', '回收前刪除個人資料',  '以上皆是', 4),
(3197,  '中高級',  '國內廢輪胎回收主要製作成以下哪一種原料？', '塑膠', '玻璃', '紙漿', '橡膠', 4),
(3198,  '中級', '發現有長期占用道路之車輛，若有下列何種情況，可被認定為廢棄車輛？', '長期違規停車之車輛',  '經所有人或其代理人以書面放棄之車輛',  '被人惡意將車窗被敲破的車輛',  '被人偷走輪胎的車輛',  2),
(3199,  '中級', '下列何者可以作為再生紙利用？', '蠟紙', '複寫紙',  '傳真紙',  '牛皮紙袋', 4),
(3200,  '中高級',  '家中過期沙拉油或回鍋油，可以如何再利用？', '送交飼料生產工廠進行再利用',  '製作手工肥皂', '可製成硬脂酸原料', '以上皆是', 4),
(3201,  '中級', '下列何者是可以回收的廢棄物？', '廢光碟片', '農藥廢容器',  '廢行動電話',  '以上皆是', 4),
(3202,  '中級', '關於寶特瓶回收再利用的用途，下列何者「錯誤」？',  '製成毛毯', '再生購物袋',  '做成假髮', '衛生紙',  4),
(3203,  '中高級',  '不小心將日光燈(40W長型)掉在水泥地上摔成許多碎片，如何妥善處理才不致危害人體污染環境？',  '打開門窗讓室內空氣流通',  '使用吸塵器清理',  '收集密封後丟棄放置於垃圾車',  '以上皆是', 1),
(3204,  '中高級',  '下列何者為大型的廢棄傢俱及家電用品的回收處理方式？',  '跟一般資源回收一起給資源回收車即可',  '將大型傢俱棄置於路邊，讓需要的人自己去搬', '委託清潔隊協助入屋搬出處理',  '先和清潔隊約好收運的時間及地點，自己找人搬運。',  4),
(3205,  '高級', '關於資源回收再利用法公告的行為，下列何者「錯誤」？',  '限制產品過度包裝', '限制塑膠類托盤及包裝盒使用',  '廢棄物應由製造業者負責處理',  '公營事業或機構、軍事機關應優先採購環保產品',  3),
(3206,  '高級', '保麗龍是由何種塑膠材料製成？', '聚苯乙烯', '聚氯乙烯', '聚丙烯',  '聚乙烯',  1),
(3207,  '高級', '下列何者「不是」再生利用的行為？', '回收紙類製造再生紙',  '酒瓶清洗後再使用', '玻璃瓶磨粉後混入行道磚',  '以上皆非', 2),
(3208,  '高級', '一般紙容器的組成成分為何？',  '紙+塑膠', '紙+臘',  '純紙', '以上皆是', 4),
(3209,  '高級', '下列哪一項是「再生資源」項目？',  '玻璃', '瀝青混凝土挖(刨)除料',  '水淬高爐石(碴)', '以上皆是', 4),
(3210,  '初級', '下列口號，何者「不符合」「舉手之勞做環保，創造美麗新家園」的精神？',  '時時存有環保心',  '危險垃圾請注意',  '垃圾分類做確實',  '垃圾亂丟沒煩惱',  4),
(3211,  '高級', '「低污染、可回收、省能源」指的是哪種標章？',  '環保署—環保標章', '環保署—能源之星', '能源局—節能標章', '建研所—?建材標章',  1),
(3212,  '中級', '垃圾焚化廠除了可以處理垃圾以外，還可以提供以下何種用途？', '供水', '發電', '供石油',  '淨化水質', 2),
(3213,  '初級', '哪些電器在長期不使用時，拔掉插頭較省電？', '隨身聽',  '微波爐',  '風扇', '手電筒',  2),
(3214,  '中級', '下列何者標章與宣導節能減碳概念是「無關」的？', '綠建築標章',  '節能標章', '牛奶標章', '環保標章', 3),
(3215,  '中級', '冷氣溫度設定值每調高1℃，可節省冷氣用電百分之幾？',  '2%', '4%', '6%', '8%', 3),
(3216,  '中級', '行政院環保署何年開始訂定環保標章？',  '1990年',  '1992年',  '1994年',  '1996年',  2),
(3217,  '中高級',  '行政院頒布的「綠建築推動方案」中，在建築部分訂定了環境評估七大指標，以下何者為「錯誤」？', '建築造型', '日常節能', '二氧化碳減量', '綠化', 1),
(3218,  '中高級',  '下列哪一種行為能夠減少溫室氣體排放？', '挖掘更多的化石能源',  '提高能源效率', '發展生質能源', '發展火力和核能發電',  2),
(3219,  '中級', '天然氣屬於幾次能源？', '一次能源', '二次能源', '三次能源', '四次能源', 1),
(3220,  '高級', '關於蒸汽鍋爐的敘述，下列何者正確？',  '為貫流式鍋爐', '需裝置排氣含氧量感測元件或檢測孔', '為處理有毒廢氣者', '都市及產業廢棄物混燒', 2),
(3221,  '初級', '離岸式風力發電廠開發需透過哪個單位去做海洋污染防治？', '經濟部(能源局)', '國防部、行政院海巡署', '行政院環保署', '內政部(營建署)', 3),
(3222,  '中高級',  '全球氣候變遷與溫室效應的影響日益明顯，減緩與調適為各國政府因應氣候變遷威脅的兩大重要策略。「調適」指的是何種策略？',  '減低民眾對於溫室效應和全球暖化議題的迷思', '依據衝擊或影響，在自然或人類系統做的調整', '調整人為和自然環境的總排碳量', '以人類的科技結合自然的覆育，提高溫室氣體的排放',  2),
(3223,  '初級', '下列何處適合設置沼氣發電？',  '沿海地區', '公園空地', '垃圾掩埋場',  '觀光地區', 3),
(3224,  '中高級',  '臺灣太陽光電發電系統結構與材?的使用期限應以幾年較為合適？',  '5年', '10年',  '15年',  '20年',  4),
(3225,  '初級', '核能電廠在發電的過程中，因為何種污染而可能影響海中的生物？',  '土壤污染', '空氣污染', '熱污染',  '噪音污染', 3),
(3226,  '高級', '臺灣目前採用RPI評估河川污染，河川污染指標由(A)生化需氧量(B)溶氧量(C)氨氮(D)懸浮固體(E)懸浮液體以上哪些項目之水質參數所組成？',  'ABCD', 'ABDE', 'BCDE', 'ABCDE',  1),
(3227,  '高級', '藻類及浮游生物大量累積造成優養化的定律是？',  '比格斯定律',  '歐姆定律', '克卜勒定律',  '亞佛加厥定律', 1),
(3228,  '中高級',  '下列何者屬於廢污水之高級處理方法？',  '活性污泥法',  '初沉法',  '中和處理', '活性碳吸附',  4),
(3229,  '中級', '廚房油煙所產生的粒狀污染物主要含有下列何種物質？', '硫氧化物', '碳氫化合物',  '氮氧化物', '氟化物',  2),
(3230,  '中高級',  '依據99年1月12日立法院三讀通過之《行政院組織法》，環保署合併資源保育業務，將正式升格成立哪一部？', '環境保護部',  '國土資源部',  '環境資源部',  '環境部',  3),
(3231,  '初級', '國內目前環境保護中央主管單位為何？',  '行政院衛生署', '交通部',  '行政院環保署', '行政院環保處', 3),
(3232,  '高級', '何謂綠色消費？',  '日常生活採行簡樸節約原則', '選購有環保標章的產品', '對環境傷害較少者', '以上皆是', 4),
(3233,  '中級', '該選用貼有哪一種標章的電器用品較省能？',  '減碳標章', '節能標章', '優良農產品標章',  '環保標章', 2),
(3234,  '高級', '下列何者為「回收紙製品環保標章規格標準」之環境訴求？', '衛生紙的回收紙混合率應為100％', '擦手紙的回收紙混合率應為90％(含)以上', '再生紙含50%以上回收紙混合率',  '以上皆是', 4),
(3235,  '高級', '下列何者是正確的綠色行銷策略？',  '提供正確環保觀念與知識',  '不引導過度消費',  '提供綠色商品相關資訊', '以上皆是', 4),
(3236,  '初級', '下列何者「不是」改善水污染的方法？',  '使用環保清潔劑',  '正確與適當的施用農藥及肥料',  '工業用水要先經過處理後再排放', '在水庫區野炊、戲水、養豬', 4),
(3237,  '初級', '下列何者「不是」在家減少空氣污染的做法？', '選擇有環保標章的家電用品', '廚房內安裝抽油煙機',  '使用有毒的殺蟲劑', '避免使用噴霧式的美容用品', 3),
(3238,  '初級', '下列何者「不是」在公共場合減少空氣污染的做法？',  '不可在野外燃燒廢棄物', '應定期檢查汽機車所排放的廢氣', '公共場所內隨意抽煙',  '搭乘公共運輸系統', 3),
(3239,  '初級', '有關節能減碳(食)的敘述何者正確？',  '食用當季、當地所產的食物', '多吃蔬菜少吃肉類', '買生鮮食品而非冷凍品', '以上皆是', 4),
(3240,  '初級', '有關節能減碳(住)的敘述何者正確？',  '避免使用鎢絲燈泡', '隨手關閉不用的電燈',  '常清洗冷氣機的空氣濾清網', '以上皆是', 4),
(3241,  '初級', '有關節能減碳(購物)的敘述何者正確？', '自備購物袋',  '購買用回收紙製造的產品',  '別買過度包裝的產品',  '以上皆是', 4),
(3242,  '中級', '下列哪種行為「不符合」綠色消費的原則？',  '注意生態保護，不要污染環境造成公害',  '自備餐具、環保筷和購物袋', '可分解的環保塑膠袋，用完即可丟棄', '做好資源回收，讓資源再利用',  3),
(3243,  '中級', '自備購物袋屬於綠色消費的哪一種行為？', '環保選購', '減量使用', '回收再生', '節約能源', 2),
(3244,  '中級', '外食自備餐具是落實綠色消費的哪一項表現？', '重複使用', '回收再生', '環保選購', '降低污染', 1),
(3245,  '中高級',  '下列何者「不是」民間企業與團體在生活中落實綠色消費的行為？',  '建立正確的綠色消費觀念',  '僅檢舉對自己權益有影響之違規標章', '宣導環保產品的特性及環境效益', '投資綠色產業之公司',  2),
(3246,  '初級', '目前許多產品在包裝上均會標示哪一種資料，代表產品製造排放的二氧化碳？', '製造國家', '碳足跡',  '材料成分', '運送里程', 2),
(3247,  '初級', '綠色餐飲的基本概念為何？', '在地食材', '素食', '速食', '有機農業', 1),
(3248,  '初級', '以下何種發電方式的污染程度較低？', '煤炭發電', '石油發電', '天然氣發電',  '太陽能發電',  4),
(3249,  '初級', '丟棄家中垃圾時，最好裝於何種容器？',  '紙袋', '可分解塑膠袋', '玻璃瓶',  '無所謂',  2),
(3250,  '初級', '國內許多環保的衣服和毛毯是用什麼材料製作而成？',  '寶特瓶',  '玻璃瓶',  '塑膠盒',  '鋁箔盒',  1),
(3251,  '中級', '依據國際綠色產業聯合會的廣義定義，綠色產業包括以下哪些產業？', '服務業',  '製造業',  '旅遊業',  '以上皆是', 4),
(3252,  '中級', '餐飲業要配合推動綠色產業，使用下列哪一種材料較「不恰當」？',  '當季食材', '進口材料', '在地食材', '蔬果輕食', 2),
(3253,  '中級', '下列哪一個縣市尚未設置風力發電機組？', '新北市',  '桃園縣',  '南投縣',  '彰化縣',  3),
(3254,  '中級', '政府目前積極推動垃圾清運方式為下列何者？', '放在固定地點就好', '帶到學校丟棄', '請人到家裡收集',  '垃圾不落地',  4),
(3255,  '中級', '以下何者由半導體材料構成，為利用半導體中，電子與電洞結合放出光子的原理而製成的發光元件？', 'LED',  'LCD',  'EDD',  'ECD',  1),
(3256,  '中級', '全臺電動機車推廣比例最高的縣市為何？', '宜蘭縣',  '金門縣',  '澎湖縣',  '花蓮縣',  3),
(3257,  '中高級',  '為讓民眾安心食用，哪個政府單位積極推動農產品的身分認證？', '農委會',  '經濟部',  '衛生署',  '環保署',  1),
(3258,  '中高級',  '臺灣哪個縣市為配合產業轉型，將魚塭改為太陽能發電廠？', '宜蘭縣',  '桃園縣',  '屏東縣',  '嘉義縣',  3),
(3259,  '中高級',  '再生能源除太陽能和風力能之外還包括哪些？', '生質能',  '水力能',  '海洋能',  '以上皆是', 4),
(3260,  '中高級',  '全球最早制訂路燈標準，並於2011年制定LED路燈節能標章的是哪一個國家？',  '美國', '日本', '臺灣', '德國', 3),
(3261,  '中高級',  '下列哪一個國家在今年規劃新的經濟振興方案中，將再生能源扣抵金額倍增，藉此改善房屋能源使用效率，並創造更多的就業機會？', '韓國', '美國', '英國', '中國', 2),
(3262,  '中高級',  '政府鼓勵民眾在住宿旅館時該如何做，以達到環保要求？',  '刷卡代替付現', '自備枕頭', '不搭電梯', '自帶盥洗用品', 4),
(3263,  '中高級',  '哪一種燃料電池是目前最符合綠色能源永續發展的產品？',  '氫',  '氦',  '鋰',  '氮',  1),
(3264,  '高級', '全球生質燃料中，以下何者所佔的比例較多？', '氣態燃料', '生質酒精', '固態衍生燃料', '液態煉解油',  2),
(3265,  '高級', '世界上最大的建築整合風力發電系統位於哪個國家？',  '法國', '中國', '美國', '日本', 3),
(3266,  '高級', '如果陽明山地區要進行能源開發，最適合者為何？', '太陽能',  '風力能',  '生質能',  '地熱能',  4),
(3267,  '高級', '在採購冷氣時，將冷氣能力除以對應的消耗電功率，所得到的數值稱為什麼？', 'BBR',  'DDE',  'EER',  'PPR',  3),
(3268,  '高級', '生質柴油主要使用在哪個國家或地區？',  '美國', '巴西', '歐盟', '中國', 3),
(3269,  '初級', '下列何者為「風力發電示範推廣計畫」所輔導設置的臺灣第一套風力發電示範系統？',  '澎湖中屯', '澎湖七美', '屏東東港', '雲林麥寮', 4),
(3270,  '中級', '下列何者是最根本的噪音防制策略？', '開立罰單', '裝置隔音牆',  '改善噪音源',  '取締噪音', 3),
(3271,  '初級', '關於白天和夜間的噪音管制標準值，下列何者正確？',  '不同，夜晚較嚴格', '不同，白天較嚴格', '相同', '二者都沒有規定標準值', 1),
(3272,  '初級', '下列何種公害是屬於物理性公害？',  '垃圾', '噪音', '水污染',  '空氣污染', 2),
(3273,  '高級', '噪音測量時，噪音計應放置於下列何種高度？', '放在地板上',  '距離地板0.8-1公尺高', '距離地板1.2-1.5公尺高', '距離地板1.5-1.8公尺高', 3),
(3274,  '初級', '噪音對民眾生理健康的影響，下列何者「錯誤」？', '心煩', '血壓升高', '聽力受損', '視力受損', 4),
(3275,  '初級', '近鄰噪音量太大，打電話陳情時，環保局人員派人來測量的時間是下列何者？', '依人員排班狀況輪流',  '可依陳情人指定時刻',  '隨時會來，所以要等著', '通常不會來',  2),
(3276,  '中高級',  '下列何種音源「不會」產生低頻率噪音？', '抽排風機', '抽水馬達', '冷氣水塔的聲音',  '樂隊鐃(ㄋㄠˊ)鈸(ㄅㄚˊ)的聲音',  4),
(3277,  '高級', '在距離路邊10公尺量噪音有78分貝，若退到距路邊20公尺處，噪音值大約會多少？',  '80分貝', '75分貝', '50分貝', '55分貝', 2),
(3278,  '中高級',  '臺灣機車的噪音管制標準是以下列何者作為區分？', '排氣量',  '廠牌', '載重量',  '速度高低', 1),
(3279,  '中高級',  '有噪音陳情時，測量噪音源若背景噪音太大，則應採取下列何種方式處理？',  '一律扣除背景音',  '一律不扣除背景音', '若有現場人員配合，則量測後修正',  '以上皆非', 3),
(3280,  '高級', '以下關於音速的?述何者「錯誤」？', '每秒大約走340公尺', '一馬赫即一倍音速', '超音速是指比音速快',  '比光速快', 4),
(3281,  '中高級',  '測量道路噪音的儀器，應在哪個高度進行測量？',  '頭頂高度', '脖子高度', '耳朵高度', '肚臍高度', 3),
(3282,  '高級', '於第三類管制區內，若某KTV測其噪音值各時段皆為65分貝，下列敘述何者正確？', '晚上(以9點為主)仍符合標準', '半夜仍符合標準',  '晚上(9點)就會超過標準', '白天不符合標準',  3),
(3283,  '中級', '下列何者是噪音頻率的單位？',  '微米(μm)', '加侖(gal)',  '帕(Pa)',  '赫(Hz)',  4),
(3284,  '中高級',  '下列可者對低頻的敘述是正確的？',  '波長約100～10m', '', '20~200Hz', '多用作電臺廣播',  0),
(3285,  '高級', '根據環境音量標準，噴射飛機及螺旋槳飛機起降之航空站的全年航空噪音日夜音量值是多少分貝？',  '50分貝', '60分貝', '70分貝', '80分貝', 2),
(3286,  '初級', '下列何者屬於低頻率聲音？', '叫賣聲',  '狗叫聲',  '工地電鑽聲',  '鼓聲', 4),
(3287,  '中高級',  '環境音量標準中，將一天分為幾個時段進行管制？', '二',  '三',  '四',  '五',  2),
(3288,  '高級', '測定道路交通噪音之氣象條件為無雨、路乾，以及風速每秒多少公尺以下？',  '二公尺',  '三公尺',  '四公尺',  '五公尺',  4),
(3289,  '初級', '寺廟的迎神賽會產生的噪音，是屬於哪一類噪音？', '交通噪音', '近鄰噪音', '民俗噪音', '工地噪音', 3),
(3290,  '初級', '舞龍舞獅的爆竹所產生的噪音，是屬於哪一類噪音？',  '近鄰噪音', '民俗噪音', '交通噪音', '營業場所噪音', 2),
(3291,  '中級', '商家冷卻水塔所產生的噪音，是屬於哪一類噪音？', '交通噪音', '營業場所噪音', '民俗噪音', '群聚噪音', 2),
(3292,  '初級', '家中電視所產生的噪音，是屬於哪一類噪音？', '交通噪音', '近鄰噪音', '民俗噪音', '群聚噪音', 2),
(3293,  '中高級',  '下列何者是噪音計需要校正的理由？', '受不同量測環境影響',  '受不同測試人員影響',  '受不同溫度影響',  '受不同光源影響',  1),
(3294,  '中級', '下列哪個單位是噪音的受害單位也是加害單位？',  '辦公室',  '研究室',  '圖書館',  '學校', 4),
(3295,  '初級', '老師上課時的音量至少要超過背景音量多少分貝時，學生才比較容易聽得清楚？',  '5分貝',  '10分貝', '15分貝', '20分貝', 1),
(3296,  '中高級',  '三部各別產生60分貝、70分貝和80分貝的汽車同時出現時，合成的噪音值為多少？',  '70分貝', '80分貝', '83分貝', '150分貝',  2),
(3297,  '中級', '小孩哭鬧時，容易引起母親的不高興，這主要是噪音引起的什麼反應？',  '情緒', '聽力受損', '血壓升高', '談話受干擾',  1),
(3298,  '高級', '噪音引起的耳鳴，是下列哪種生理現象？', '耳聾', '全聾', '暫時性聽力損失',  '永久性聽力損失',  3),
(3299,  '初級', '下列何種聲音「不屬於」政府管制的噪音？',  '欣賞的音樂',  '電影院的電影', '吵鬧的青蛙叫聲',  '吵雜的叫賣聲', 3),
(3300,  '中高級',  '用麥克風演講的音量，大約是多少分貝？', '50分貝', '60分貝', '80分貝', '120分貝',  3),
(3301,  '高級', '環保標章係指該產品在各類產品項目中，環保表現最優良的前百分之幾？', '5~10%',  '10~20%', '20~30%', '30~40%', 3),
(3302,  '中級', '下列何種標章制度的推廣，是鼓勵民眾使用高能源效率產品，以減少能源消耗？',  '綠建材',  '省水標章', '碳標籤',  '節能標章', 4),
(3303,  '中級', '下列何者為對省水標章之描述？', '箭頭向上，代表將中心的水滴接起',  '右邊三條水帶，代表「愛水、親水、節水」',  '藍色代表水質純淨清澈', '以上皆是', 4),
(3304,  '中高級',  '下列何者「不是」構成水足跡的三元素之一？', '綠色水足跡',  '藍色水足跡',  '灰色水足跡',  '白色水足跡',  4),
(3305,  '高級', '下列有關水足跡的敘述，何者「錯誤」？', '代表產品或服務之生命週期過程的消耗水量',  '水足跡越高代表越耗水', '電子產品只用電因此沒有水足跡', '水足跡計算目的是鼓勵節水', 3),
(3306,  '高級', '下列有關綠色水足跡的描述，何者正確？', '產品生產中所產生的蒸散量', '產品生產中消耗的地表水或地下淡水量',  '為稀釋生產中製造污染至標準水質所需要的用水量', '作物和森林成長中所吸收的雨量', 1),
(3307,  '高級', '水足跡之概念，是以產品生命週期概念來評估其用水量，所謂「搖籃到墳墓」是指產品哪一種階段？', '原料與製造階段',  '使用階段', '處理階段', '以上皆是', 4),
(3308,  '中高級',  '一般產品若有RoHS標示代表何種意義？',  '符合低碳的產品',  '符合節水的產品',  '符合限制有害物質之產品',  '符合綠建材產品',  3),
(3309,  '初級', '下列何者為目前國際間對於綠建材的概念？',  '再使用',  '再循環',  '廢棄物減量',  '以上皆是', 4),
(3310,  '中級', '下列何者是綠建材的優點？', '增加化學合成材料', '增加材料生產過程之耗能',  '使用自然材料與高揮發性有機物質建材',  '材料基本性能及特殊性能經過評估及管制', 4),
(3311,  '高級', '下列何者為綠建築評估指標？',  '綠化量指標',  '二氧化碳減量指標', '生物多樣性',  '以上皆是', 4),
(3312,  '中級', '下面有關碳足跡標章與減碳之目標何者「錯誤」？', '於產品上標示碳足跡',  '生產者應建立產品碳足跡並減碳', '消費者可優先購買具低碳足跡的產品', '碳足跡標章與消費者無關聯', 4),
(3313,  '中高級',  '碳足跡標章內之數值代表什麼意義？', '產品本身重量', '產品之生命週期總減碳的數值量', '產品之生命週期總碳排放當量',  '僅代表二氧化碳的排放', 3),
(3314,  '中高級',  '下列哪一階段有碳足跡？',  '材料使用', '產品製造', '產品運輸', '以上皆是', 4),
(3315,  '中級', '碳足跡標章上的數值意義為何？', '數值大代表溫室氣體含量越低',  '數值小代表溫室氣體含量越高',  '代表通通是環保產品',  '可以瞭解並優先選購碳排放量較低的替代品',  4),
(3316,  '初級', '企業推行碳足跡產品有何好處？', '生產過程可減碳',  '提升企業形象', '研發出低碳產品',  '以上皆是', 4),
(3317,  '初級', '下列哪一種「不是」獲得「綠色商店標章」商店的重點工作？',  '辦理環保活動', '資源回收宣導', '鼓勵民眾購買一次用即丟之產品', '綠色消費觀念宣導', 3),
(3318,  '中級', '下列何者「不屬於」綠色商品？', '獲得能源標章產品', '獲得環保標章產品', '獲得綠建築標章產品',  '獲得CNS標章產品',  4),
(3319,  '初級', '下列何者合乎公平正義原則？',  '永續發展', '弱肉強食', '無限制開發',  '非自由市場',  1),
(3320,  '中級', '下列何者宣言提出「環境影響評估」？',  '那德威克宣言', '索非亞協定',  '里約宣言', '赫爾辛基宣言', 3),
(3321,  '中級', '《里約宣言》提出有三項關係依存是不可分割的，下列何者為「錯誤」？', '慈愛', '和平', '發展', '保護環境', 1),
(3322,  '中級', '西元2000年9月「聯合國千禧年高峰會」(UnitedNationsMillenniumSummit)擬訂8項發展目標，下列何者為「錯誤」？', '消除極端貧窮和飢餓',  '抗愛滋病毒、瘧疾和其他疾病',  '確保環境永續發展', '中等教育普及化',  4),
(3323,  '初級', '「綠色生活」的『綠色』概念可以下列何者為之？', '省能源',  '低污染',  '低毒性',  '以上皆是', 4),
(3324,  '中級', '下列選項何者「不是」環境倫理的基本原則？', '環境正義原則', '世代公平原則', '產業發展原則', '尊重自然原則', 3),
(3325,  '初級', '依據「永續發展」原則，環境保護與經濟發展應以何者為主要考量？', '經濟發展', '環境保護', '兩者平衡', '就當時局勢而定',  3),
(3326,  '中級', '有關環境公平正義之敘述下列而者為「錯誤」？',  '剝奪少數族群的權益',  '保障原住民土地與資源', '確保經濟與文化弱勢之社會群體發展', '對於兒童、女性與老年人口之生存空間與生活所需給予特殊的關注',  1),
(3327,  '中高級',  '永續社會的達成需確保世代間正義的落實，下列敘述何者「不正確」？',  '確保資源與能源的永續使用', '鼓勵與補助非再生能源及相關設施與物品的研發與使用', '零廢棄為願景，訂定各種廢棄物的長期性減廢目標', '擴編海陸域的生態保護區並嚴格執行保護規範', 2),
(3328,  '中高級',  '依據永續社會原則，下列敘述何者正確？', '社會及經濟之發展應不超過環境承載力',  '社會之發展可不受限制', '經濟之發展可超過環境及社會承載力', '環境承載力不需加以考量',  1),
(3329,  '中高級',  '下列何者「不符合」永續發展的理念？',  '以環境保護為導向，降低人類生活品質',  '人類發展不超出環境承載力', '發展綠色科技', '促進地球村概念，加強國際合作', 1),
(3330,  '初級', '下列何者「不符合」永續發展的理念？',  '大量開發集水區，種植高山蔬果', '垃圾分類，資源回收',  '選擇購買具有環保標章的商品',  '建置污水下水道',  1),
(3331,  '中高級',  '下列何者「不是」保護弱勢族群與團體的作法？',  '保障原住民土地與資源之傳統使用及參與決策和管理權', '確保經濟與文化弱勢之社會群體受到政府與私人企業符合於環境正義原則之對待',  '提供貸款給中小企業，以提高其競爭力',  '對於兒童、女性與老年人口之生存空間與生活所需給予特殊的關注',  3),
(3332,  '高級', '下列何種作法對於促進環境公平正義「沒有」實際幫助？',  '促進環境資訊之公開',  '落實污染防制與管制',  '照顧經濟與文化弱勢群體',  '鼓勵環境相關設施的研發',  4),
(3333,  '中高級',  '「為環境資源的有限性與再生的限制性，因此對於環境保護的工作應以事先防備為要」此段敘述主要是說明環境權的何種特質？', '國民共有', '與後代子孫共享',  '預防重於治療', '跨國界',  3),
(3334,  '中高級',  '有關空污費徵收原則，下列何者正確？',  '受益者付費原則',  '默許排放者無限排放原則',  '污染者付費原則',  '污染者付費及受益者付費原則',  3),
(3335,  '中級', '關於「綠色設計」的概念，下列敘述何者正確？',  '生產成本低廉的產品',  '表示建康的，安全的商品',  '售價低廉易購買的商品', '包裝紙一定要用綠色系的',  2),
(3336,  '中級', '下列何者符合環境正義的原則？', '當代人與現代人共享相同的資源', '將污染物運至人口較少的地方處理',  '設立國家公園不採納原住民族意見',  '政府獨自執行環境政策', 1),
(3337,  '初級', '《環境基本法》說明「國民應秉持環境保護理念，減輕因日常生活造成之環境負荷」。在消費行為上，應以下列何者為原則？',  '聰明消費', '最小消費', '藍色消費', '綠色消費', 4),
(3338,  '中高級',  '2000年印度哈里普爾社區發動反核非暴力抗爭，其居民主要是爭取什麼權力？', '選舉權',  '知識權',  '財產權',  '環境權',  4),
(3339,  '中級', '永續發展的原則為何？', '公平性(Fairness)',  '永續性(Sustainability)',  '共同性(Commonality)', '以上皆是', 4),
(3340,  '中級', '《蒙特婁議定書》是為保護臭氧層，管制國際間臭氧層破壞物質的使用，下列何者「不是」管制的項目？', '二氧化碳', '四氯化碳', '氟氯碳化合物(CFCs)', '溴甲烷',  1),
(3341,  '中級', '關於美國環保署對於「環境正義」的定義，下列何者「錯誤」？', '確保人人享有公平的待遇',  '正義與否對後代子孫是沒有影響的',  '是不分國籍及種族的',  '不應以經濟收入來區隔', 2),
(3342,  '初級', '在臺灣的環境公害防治運動中，民眾扮演什麼角色？',  '提供專業咨詢', '協助陳情突發性案件',  '參與公害現場勘查', '協助監督並確保公害於限期改善', 2),
(3343,  '中級', '環保署把陳情公害放到網路地圖上供民眾查詢的作法，有什麼用意？', '增加民眾的上網次數',  '讓民眾了解住家附近有哪些公害', '豐富環保相關的網路內容',  '讓民眾可以隨時透過網路下載相關的手機應用程式', 2),
(3344,  '中高級',  '關於永續發展與環境公平正義之關係，下列何者「錯誤」？', '公眾應多參與環境議題事務', '不關乎後代子孫資源問題',  '應持續不間斷的去進行', '國際間應互相合作', 2),
(3345,  '中高級',  '有關資源與能源應永續利用，下列何者「不是」再生能源？', '潮汐能',  '地熱', '煤',  '風能', 3),
(3346,  '中級', '能源發展應滿足未?世代發展的需要。下列何者「不符合」能源公平分配的觀點？', '有效利用', '節約使用', '研發替代能源', '勸說後代子孫棄用', 4),
(3347,  '中級', '下列何者為環境權之主要內容？', '優良環境享有權',  '惡化環境拒絕權',  '環境知情權',  '以上皆是', 4),
(3348,  '中級', '下列何者為永續社會下公平正義所要達到之願景？', '保障環境人權', '關注後代子孫', '保護弱勢族群與團體',  '以上皆是', 4),
(3349,  '中級', '依照1991年有色人種環境高峰會，下列何者對於環境正義描述「錯誤」？', '保障環境不正義的受害者收到完全的賠償', '?人類應互相尊重', '反對生物存活之毒物',  '支持跨國企業的破壞性行為', 4),
(3350,  '中高級',  '工廠生產後排放空氣污染物，需繳納污染防制費，此主張乃根據何種原則？',  '污染者付費原則',  '比例分配原則', '互不侵犯原則', '選用原則', 1),
(3351,  '高級', '依據永續發展的原則，下列敘述何者「錯誤」？',  '就社會層面，主張公平分配，滿足當代與後代之需求',  '就經濟層面，主張建立在保護地球資源系統尚可持續經濟發展',  '就自然生態層面，主張人類與自然和諧相處',  '就資源層面，應多使用非再生性資源', 4),
(3352,  '高級', '卡森(RachelCarson)在1962年發表哪一本書，對日後的環境保護有重大影響？\n',  '環保出擊(ThetotalQualityCorporation)', '我們共同的未來(OurCommonFuture)', '寂靜的春天(SilentSpring)',  '瀕危的地球(EarthintheBalance)\n', 3),
(3353,  '初級', '依民國99年公布之《環境教育法》，高級中等以下學校所有員工、教師、學生每年均應參加幾小時以上的環境教育課程？', '2小時',  '3小時',  '4小時',  '5小時',  3),
(3354,  '初級', '臺灣最長的河流為何？', '烏溪', '中港溪',  '濁水溪',  '高屏溪',  3),
(3355,  '中級', '《華盛頓公約》的目的為何？',  '促進資源永續利用', '保護瀕臨絕種生物', '防止氣候變遷對生態系造成之衝擊',  '防止全球暖化', 2),
(3356,  '中高級',  '就環境影響評估政策而言，為保護環境之安全及永續利用，政府在開發土地前應對環境做出下列何種評估？',  '對地區是否帶來繁榮',  '開發是否對環境造成影響',  '是否增加就業機會', '對附近住宅地價是否有幫助', 2),
(3357,  '初級', '住宅社區開發時，對於古蹟遺址應採取何種措施？', '應進行古蹟遺址之調查與評估',  '裝作不知道',  '以查無資料視為開發地區沒有古蹟',  '不必依文化資產保護法有關規定辦理', 1),
(3358,  '高級', '環境評估可追溯至美國於1969年制訂的什麼法案？', '水土保持法案', '國家生態保護法案', '國家環境政策法案', '節能減碳法案', 3),
(3359,  '中高級',  '重大工程開發案之土方開挖量與填方量不平衡時之因應方式，下列哪個選項「不是」開發單位應有的因應策略及評估？', '儘量作到土方開挖量與填方量平衡',  '可由他處外購土方來達到平衡',  '可將多餘土方量送至合法土資場收納', '可將多餘土方量送至道路邊坡吸納',  4),
(3360,  '高級', '公司開發礦區將礦石運送到其他地區，哪一項「不會」對環境造成下列何種影響？', '交通量增加上下學過馬路更危險', '造成揚塵,馬路空氣品質變差',  '馬路會產生許多生活垃圾',  '有時候會增加鐵路運輸量',  3),
(3361,  '高級', '高爾夫開發案之廢污水排放於地面水體時，其下游會進入農業灌溉水系統，應如何處置？',  '取得排放口下游灌溉水質權責機構同意後,始得排放.', '不必取得下游灌溉水質權則機構同意,可直接排放', '可以綜合水體平均水質標準排放', '可依一般河川水質標準排放', 1),
(3362,  '高級', '高爾夫球場開發後之廢污水排放於灌排系統時，應依據何標準排放？', '灌溉水標準',  '放流水標準',  '承受水體水質標準', '一般河川水標準',  3),
(3363,  '中級', '興建臺灣高鐵案，下列何者「不是」用來判斷是否適宜設廠的考慮要項？', '經濟效益及產業發展評估',  '沿線地主和廠方的遊說', '學者專家的評估',  '對生態環境品質的影響', 2),
(3364,  '高級', '下列何者「不是」政策環評中，對環境涵容能力評估項目中之水體？', '河川與地下水', '水庫與湖泊',  '海洋', '小埤塘',  4),
(3365,  '高級', '判斷某種有害物質是否屬於致癌物，屬於健康風險評估之哪一步驟？', '危害辨識', '劑量反應評估', '暴露評估', '風險特性描述', 1),
(3366,  '中高級',  '有關氡(Rn)致癌之敘述，下?何者「錯誤」？', '在蛻變時發出α?子',  '和鈾礦工之肺癌有關',  '大?石材較木材建材可能有較高之氡', '氡以固體形態存於地表', 4),
(3367,  '中高級',  '化學物質經暴露，將立即危害人體健康或生物生命者為第幾?毒性化學物質？', '第一?',  '第二?',  '第三?',  '第四?',  3),
(3368,  '中級', '下列哪一種重金屬主要是由人體腎臟所代謝，以致身體的鈣嚴重流失？',  '砷',  '鉛',  '鎘',  '汞',  3),
(3369,  '高級', '構成水硬度的兩個主要元素為何？',  '鐵和錳',  '鈣和鎂',  '硝酸鹽和硫酸鹽',  '氧和矽',  2),
(3370,  '中高級',  '嬰兒飲用含有下?何種物質之飲用水會引起?嬰症(Bluebaby)？',  '硝酸鹽',  '磷酸鹽',  '氰化物',  '多氯?苯', 1),
(3371,  '中級', '下列何者「不是」蚊類所傳染的疾病？',  '屈公病',  '黃熱病',  '日本腦炎', '猩紅熱',  4),
(3372,  '初級', '所謂的紫外線指數，常以下列哪一組英文縮寫代表？',  'UVA',  'UVB',  'UVC',  'UVI',  4),
(3373,  '中級', '基於避免事務機臭氧的釋放，建議事務機應放置於距離人們至少多少公尺範圍以外？',  '30公尺', '50公尺', '80公尺', '1公尺',  4),
(3374,  '初級', '「臺灣碳標籤」係由下列哪一種圖案搭配「CO2」化學符號及數字所組成？', '由紅色心形及綠葉組成腳印', '由紅色心形及紅花組成腳印', '由綠色心形及綠葉組成腳印', '由綠色心形及紅葉組成腳印', 3),
(3375,  '中級', '鄰近地面空氣污染物中的臭氧，其對環境生態或人體健康可能的危害，「不包括」下列哪一項？', '臭氧具強氧化力，對呼吸系統具刺激性',  '臭氧能引起咳嗽、氣喘、頭痛、疲倦及肺部之傷害', '臭氧對於植物等農作物地生長有不良影響', '臭氧可吸收全部紫外線', 4),
(3376,  '中級', '當河川污染指標值等於5.0時，代表該河川屬哪一種污染程度？',  '未受污染', '輕度污染', '中度污染', '嚴重污染', 3),
(3377,  '中高級',  '依據我國毒性化學物質分類，若屬於在環境中不易分解，或因生物蓄積、生物濃縮、生物轉化等作用，導致污染環境或危害人體健康的化學物質，被歸類為？',  '第一類毒性化學物質',  '第二類毒性化學物質',  '第三類毒性化學物質',  '第四類毒性化學物質',  1),
(3378,  '中高級',  '「環境荷爾蒙」又稱為下列哪一種化學物質？', '持久性污染物', '致癌性污染物', '蓄積性污染物', '內分泌干擾物', 4),
(3379,  '中級', 'PM2.5危害人體健康的最主要原因是什麼？',  'PM2.5易隨呼吸深入人體',  'PM2.5易被皮膚所吸收', 'PM2.5含有重金屬', 'PM2.5易沉降累積', 1),
(3380,  '中高級',  '空氣污染物中的二氧化氮，其顏色為何？', '藍色', '紅棕色',  '黃色', '綠色', 2),
(3381,  '中高級',  '除了硫酸鹽之外，下列哪一種化學物質是導致酸雨形成的主要化學成份？', '氯離子',  '鈉離子',  '硝酸鹽',  '金屬離子', 3),
(3382,  '中高級',  '國際間為了減少有害廢棄物的產生，並避免跨國運送時造成環境污染，乃訂定哪一種公約或協定？',  '巴塞爾公約',  '京都議定書',  '蒙特婁議定書', '華盛頓公約',  1),
(3383,  '中高級',  '依據我國毒性化學物質分類，若化學物質經暴露後，將立即危害人體健康或生物生命者，被歸類為？', '第一類毒性化學物質',  '第二類毒性化學物質',  '第三類毒性化學物質',  '第四類毒性化學物質',  3),
(3384,  '中級', '飲用水中下列何種化學物質超過「飲用水水質標準」時，長期飲用可能會導致水俁(ㄩˇ)病發生？', '砷',  '鉛',  '汞',  '銀',  3),
(3385,  '中高級',  '自來水用戶與自來水公司之間權利義務劃分係以何處為界？', '細微懸浮微粒會深入肺部組織',  '懸浮微粒會刺激眼睛',  '懸浮微粒會干擾能見度', '懸浮微粒會導致器具髒污',  1),
(3386,  '中高級',  '下列何者對於酸雨的描述「錯誤」？', 'pH值為4.5',  '衍生性污染物', '具有跨區域影響特性',  '涉及層面廣泛', 1),
(3387,  '高級', '下列哪一項化學物質，為加氯消毒飲用水中最常見的三鹵甲烷類化合物？', '氯仿', '溴仿', '四氯化碳', '苯',  1),
(3388,  '高級', '針對底泥品質指標及管理之相關規定，主要根據下列哪一項法規？',  '空氣污染防制法',  '水污染防治法', '環境基本法',  '土壤及地下水污染整治法',  4),
(3389,  '高級', '一般民眾暴露於戴奧辛的機會，主要係來自於下列哪一項暴露途徑？', '呼吸吸入', '皮膚吸收', '直接注射', '日常飲食中的食物攝取', 4),
(3390,  '高級', '產品製造過程所產生的溫室氣體與其碳足跡相比較，何者較大?', '生產過程較大', '碳足跡較大',  '兩者一樣多',  '兩者無法比較', 2),
(3391,  '高級', '化學需氧量(COD)若用於說明水質，下列敘述何者正確？',  '化學需氧量愈高，水中溶氧濃度愈高', '化學需氧量愈低，水中有機物質含量愈多', '化學需氧量愈高，污染愈嚴重',  '化學需氧量不適於用來說明水體污染情形', 3),
(3392,  '中高級',  '放流水標準中的BOD是指放流水中何種污染物的最大限量？',  '懸浮物',  '重金屬污染',  '生物可分解有機物', '放射性物質',  3),
(3393,  '初級', '下列何者「不是」水質之物理性標準？',  '酸度', '色度', '臭度', '濁度', 1),
(3394,  '高級', '長期暴露於下列何種毒化物會造成再生??性貧血，亦可能會造成血癌？', '甲苯', '苯',  '正己烷',  '二硫化碳', 2),
(3395,  '高級', '下列何種物質職業暴露常導致過敏性氣喘？',  '氯化鈉',  '氟化氫',  '二異氰酸甲苯', '氰化氫',  3),
(3396,  '高級', '1984年在印度波帕爾發生的甲基異氰酸(MIC)中毒事件是屬於哪一種中毒？',  '食物中毒', '肝臟中毒', '神經中毒', '呼吸中毒', 4),
(3397,  '中高級',  '石綿是一種公告列管毒性化學物質，它對人體最大的危害為何？', '白血病',  '肝癌', '矽肺症',  '肺癌', 4),
(3398,  '初級', '發現廚房的油鍋著火，最「不宜」做下列何者？',  '濕布覆蓋', '用水滅火', '關瓦斯',  '開窗戶',  2),
(3399,  '中級', '吸菸的習慣會加強下列哪一種物質的致癌性？', '雲母', '石綿', '石膏', '水蒸氣',  2),
(3400,  '中級', '下列何者「不是」燃燒的四要素？',  '燃料', '熱能', '甲烷', '氧氣', 3),
(3401,  '高級', '下列何者為吸菸與石綿暴露的致癌關係？', '相加效應', '相乘效應', '反射效應', '拮抗效應', 2),
(3402,  '高級', '下列哪個選項「不是」歐盟的三大環保指令？', 'EuP',  'DFE',  'RoHS', 'WEEE', 2),
(3403,  '高級', '下列何者「不是」危害性物質限制指令(RoHS)規範電子產品在製造時不得使用的化學物質？',  '聚溴聯苯(PBB)',  '鉛(Pb)',  '汞(Hg)',  '銀(Ag)',  4),
(3404,  '中高級',  'EuP(能源使用產品生態化設計指令)的主要理念為下列何者？',  '生命週期思維', '生態說明書',  '考慮成本效益', '以上皆是', 4),
(3405,  '中級', '下列何者「不包含」環境化設計的傳統訴求？', '自然資源永續發展', '產品使用方便', '人類健康及安全',  '環境保護', 2),
(3406,  '中高級',  '何者「不是」聯合國環境規劃署所定義之清潔生產目的？',  '永續發展', '工業與環境的互利互榮與永續發展',  '增加生態效益', '廠商為取得綠色工廠標章的措施', 4),
(3407,  '中高級',  '何者對於產品回收率的提升是「沒有」幫助的？',  '選擇單一材質作為零組件的原料', '降低生產成本', '產品設計應儘量避免使用將來不容易處理的材質',  '儘量選擇在當地的生產市場可以回收再利用的物質', 2),
(3408,  '中級', '清潔生產指標的氣候變化指標中，污染物排放量會轉換為下列何種物質的當量，以評估其對氣候變化的影響？', '二氧化碳', '一氧化碳', '二氧化硫', '硫化氫',  1),
(3409,  '中高級',  '下列何者為政府在推行清潔生產時的重點？',  '對於企業給予財政補助', '對於推行清潔生產之企業，給予稅收減免等優惠',  '鼓勵研究機構和高校的科技人員流向企業，開展技術創新',  '以上皆是', 4),
(3410,  '初級', '清潔生產之目標為何？', '節能', '減緩資源枯竭', '減廢', '以上皆是', 4),
(3411,  '中高級',  '下列何者為綠色工廠標章的清潔生產中的「一階指標項目」？',  '生產製造', '環境化設計',  '綠色管理與社會責任',  '以上皆是', 4),
(3412,  '中級', '下列何者「不是」達成清潔生產的主要方法？', '辦公室清潔',  '避免(降低)廢棄物產生',  '有效率使用能源(資源)',  '追求低成本高效益', 1),
(3413,  '中高級',  '下列哪一項「不是」清潔生產的主要目標？',  '增加整個產品對環境衝擊',  '降低污染排放', '節省各個製程資源使用', '減少排放物及廢棄物的?與毒性', 1),
(3414,  '中高級',  '下列何者是清潔生產的主要工作？',  '評估產品的能源管理效率',  '評估產品的污染控制',  '評估產品的工程與製造', '以上皆是', 4),
(3415,  '高級', '下列何者為臺灣綠建築評估系統？',  'EEWH', 'BREEAM', 'LEED', 'CASBEE', 1),
(3416,  '初級', '某國家公園屬於熱帶性氣候，夏季漫長，且受季風影響甚深，特別是10月到隔年3月東北季風在當地地形的效應下，形成本區強勁著名的「落山風」，此外發現多處史前遺跡與原住民文化遺址，更是無價的人文資產，此公園為下列何者？',  '臺江國家公園', '金門國家公園', '東沙環礁國家公園', '墾丁國家公園', 4),
(3417,  '初級', '某港口經過百餘年的淤積，只剩3塊大礁石矗立於沼澤中，成為見證港口歷史的重要遺跡，其基地位置具豐富的濕地生態環境，此地為下列何者？', '蘇澳港',  '安平港',  '烏石港',  '布袋港',  3),
(3418,  '初級', '下列何者為臺灣一級古蹟?', '西門紅樓', '臺北孔子廟',  '臺中文昌廟',  '鹿港龍山寺',  4),
(3419,  '中高級',  '下列何者是苗栗縣造橋鄉的文湖鐵道的特色？', '該砌石邊坡為原縱貫鐵道之路基，砌石具當時工匠特色', '為荷治時期海岸線鐵道之路基',  '為林業發展所建',  '舊山線縱貫鐵路的最高點',  1),
(3420,  '高級', '環境影響說明書經審查完成後，若開發行為對環境有重大影響之虞須進一步評估，其審查結論分類為何？', '有條件通過環境影響評估審查',  '應繼續進行第二階段環境影響評估',  '認定不應開發', '其他經中央主管機關認定者', 2),
(3421,  '高級', '《環境影響評估法》施行多年，大約為民國幾年通過？', '83年',  '92年',  '73年',  '88年',  1),
(3422,  '中高級',  '美國佛羅里達的珊瑚礁海域，發現近30年珊瑚產生白化現象，連原本依賴珊瑚而生的魚群也不見。其現象主要是受到下列哪一個因素影響？', '過度捕撈', '沿岸開發', '被大量海藻覆蓋',  '海洋酸化', 3),
(3423,  '中級', '下列哪一項是造成墨西哥灣海洋死區(deadzone)的主因？', '全球暖化造成', '漁民大量捕撈魚群', '藻類過度繁殖造成', '海底火山爆發', 3),
(3424,  '高級', '腸病毒「不會」經由以下何種途徑傳染？\n', '飛沫', '血液', '污染的食物',  '污染的玩具',  2),
(3425,  '高級', '在臺灣，夏季是登革熱好發季節，傳染登革熱的病媒主要為何？', '白線點蚊', '環紋家蚊', '埃及斑蚊', '三斑家蚊', 3),
(3426,  '高級', '若要了解懸浮微粒對環境造成的衝擊，「不需要」知道下列哪一種資訊？', '人口結構的變化',  '懸浮微粒的物理特性',  '懸浮微粒的化學特性',  '大氣變化的情形',  1),
(3427,  '中高級',  '在夏季，環境髒亂容易造成登革熱疫情，下列有關登革熱的敘述何者「錯誤」？',  '感染者會有發燒的症狀', '為預防病媒，應在住屋加裝紗窗、紗門',  '主要是經由埃及斑蚊、白線斑蚊叮吮而感染',  '感染後就一定不會再感染',  4),
(3428,  '初級', '關於沙塵暴的敘述何者「錯誤」？',  '主要影響北臺灣的地區', '沙塵暴發生時應多出外活動', '常發生在冬末春初', '沙塵暴的源頭往往在乾旱之地發生',  2),
(3429,  '初級', '有關病媒常見的危害，下列敘述何者「錯誤」？',  '不會破壞生活中的物品', '污染食物', '影響環境衛生', '直接叮咬人畜，引起各種傳染疾病',  1),
(3430,  '初級', '下列何者並「不是」預防食品中毒之四大原則？',  '清潔', '避免疏忽', '加熱或冷藏',  '生吃', 4),
(3431,  '中高級',  '為甚麼自然的溫室效應，對於地球環境而言是重要的？', '因為避免溫室氣體過度排放', '因為能夠保存大氣的熱量',  '因為能夠讓海平面維持不變', '因為能夠讓全球地表溫度持續上升',  2),
(3432,  '初級', '甲烷是如何產生的？',  '吃牛肉的時候所產生',  '製造冷媒時所產生的',  '溫室效應造成的',  '發酵與腐化的過程', 4),
(3433,  '初級', '下列有關預防流行性感冒的敘述何者「錯誤」？',  '向著無人的地方打噴嚏', '打噴嚏應用手帕摀住嘴巴',  '應戴口罩', '應減少外出',  1),
(3434,  '初級', '預防腸病毒的方法何者正確？',  '玩遊戲後不用洗手', '吃東西前要洗手',  '上廁所後不用洗手', '玩玩具後不用洗手', 2),
(3435,  '中級', '下列有關登革熱的敘述何者「錯誤」？',  '主要是經由蚊子叮吮而感染', '應在住屋加裝紗窗、紗門',  '家中積水容器可不用清理',  '會有發燒的症狀',  3),
(3436,  '初級', '下列對於噪音的敘述何者正確？', '不會造成別人的不舒服', '不會造成觸覺的損傷',  '不會干擾到睡眠品質',  '不會造成精神不集中',  2),
(3437,  '初級', '人為的污染源則來自人們各種活動及開發所產生者。以下何者是市鎮污水中最常見的污染源？',  '木頭', '重金屬',  '氮肥', '家庭用的清潔劑',  4),
(3438,  '初級', '在職業傷害中，冷凍作業員易患何種疾病？',  '聽力損傷', '皮膚炎',  '凍傷', '膀胱癌',  3),
(3439,  '中級', '下列何者「不是」空氣品質監測站址之選定原則？', '測站種類', '經濟條件', '人口分布', '都市計畫', 2),
(3440,  '中級', '何者是溫室效應惡化可能造成的問題？\n',  '二氧化碳滅火器被禁用', '牧場的牛隻排放甲烷',  '氣候持續不穩定',  '溫室氣體濃度提高', 3),
(3441,  '中級', '下列何者是廢污水處理的主要目的？', '防止流行性感冒的傳播', '防止空氣受污染',  '防止臭氧層破洞',  '防止土壤受污染',  4),
(3442,  '中高級',  '達悟族的何種捕魚文化，展現了生態保育的觀念？', '只捕撈飛魚，吃單一魚種',  '按時節捕撈不同的魚',  '大量捕撈並販賣的飛魚', '只捕撈飛魚的幼魚', 2),
(3443,  '中高級',  '關於原住民族土地，以下敘述何者是「不正確」的？',  '係指原住民族之傳統領域',  '係指既有原住民保留地', '係指原住民私人或團體購買擁有的土地',  '以上皆是', 3),
(3444,  '中級', '因地勢獨立而保留完整文化特色的達悟族位於哪一個行政區域？', '臺東縣',  '連江縣',  '金門縣',  '宜蘭縣',  1),
(3445,  '高級', '達悟族老人、男人與女人食用不同種類的飛魚，在生態永續上的觀點為何？',  '體驗生物多樣性',  '抑制單一物種滅絕的危機',  '減少二氧化碳排放量',  '維持飛魚的神聖地位',  2),
(3446,  '高級', '以下何者「不是」《原住民基本法》與環境保護之間有關的規定？',  '應允原住民營利目的之資源利用行為', '保護傳統之生物多樣性知識及智慧創作',  '回復原住民族部落及山川傳統名稱',  '承認原住民族土地及自然資源權利',  1),
(3447,  '中高級',  '關於原住民得在原住民族地區依法從事之採集、狩獵與土石、應用水資源行為中，何者「不正確」？', '僅能為非營利使用', '僅能在原住民族地區',  '以傳統文化、祭儀或自用為限',  '事前申請許可即可不受限制', 4),
(3448,  '中高級',  '聚會所(Kuba)是鄒族進行祭祀儀式的重地。下列關於聚會所的敘述，何者為「錯誤」？',  '為長老會議的開會場所', '為女子教育訓練的中心', '男子出征狩獵的集散之所',  '部落公共事務的公告處', 2),
(3449,  '中級', '以下何者「不是」《原住民族基本法》中關於原住民族地區天然災害防救的規定？', '政府應建立天然災害防護',  '政府應建立原住民族地區天然災害善後制度',  '政府應劃設天然災害防護優先區', '政府無需預先劃設災後重建之區域',  4),
(3450,  '高級', '原住民委員會為開發原住民族地區的溫泉，「不得」以哪些方式來進行？', '結合社區或部落居民輔導興辦溫泉民宿',  '輔導興辦社區或部落公共浴池',  '輔導興辦文化產業、生態產業、特色產業', '引進國際財團投資整體開發溫泉觀光區',  4),
(3451,  '高級', '達悟族傳統的家屋皆有高聳的邊牆，其作用為何？', '作為明顯的邊界，劃分勢力範圍', '保障家居隱私', '因應強風氣候，作為屏障之用',  '防止猛獸攻擊', 3),
(3452,  '高級', '達悟族發展出獨特建築於坡地的「半穴居」，為維持居住安全及品質，於建築初期最重要的規劃為何？',  '維持室內品質，注意室內的通風條件', '重視祖靈的庇護，嚴格控制屋舍座向', '避免猛獸的攻擊，架設良好的趨敵設施',  '規劃良好的排水系統，避免屋舍淹水', 4),
(3453,  '高級', '鄒、泰雅、賽夏與太魯閣等族之部分族人居住於高山地區，其搭建家屋最常見之材料為何？', '族人燒製的磚頭',  '鵝卵石、泥土', '竹子、樹木、茅草等',  '黑色頁岩', 3),
(3454,  '高級', '以散居的方式分布在高山地區的布農族與泰雅族，有別於其他原住民集村的群居形式，其最主要的原因為何？', '按傳統自行選擇居住地點',  '適用耕地分散，不利群居',  '獵物體型較嬌小，不需集體狩獵', '族人個性獨立，不喜群居',  2),
(3455,  '中高級',  '針對一個國家、區域、公司、事業單位等所有活動，所產生的空氣污染物排放總量，稱為下列何者？', '空氣污染排放清冊', '空氣污染排放係數', '空氣污染排放減量', '空氣污染排放管理', 1),
(3456,  '中高級',  '為提昇環境品質及維護國人健康，環保署將針對下列何者納入管制？', 'PM2.5',  'PM10', 'CO', 'O3', 1),
(3457,  '中高級',  '下列哪一種紫外線指數等級，具有較高的傷害性？', 'UVI=2',  'UVI=4',  'UVI=6',  'UVI=8',  4),
(3458,  '中高級',  '下列何者是政府針對移動污染源提出的管制政策？', '針對電力業排放硫氧化物徵收空污費', '針對廢棄物焚化爐訂定管制標準', '訂定「固定污染源空氣污染物排放標準」', '發布「車用汽柴油成分管制標準」',  4),
(3459,  '初級', '下列何者「不是」導致雨水酸化的現象？', '火山爆發噴出硫化氫',  '高空閃電', '海洋中的鹽份', '石化工廠', 3),
(3460,  '中高級',  '設置於工業區之盛?風下風處的監測站，屬於下列哪一類空氣品質監測站？',  '一般測站', '工業測站', '交通測站', '背景測站', 2),
(3461,  '初級', '下列何種措施有效減緩河川揚塵的現象？(A)加強河川內機動灑水(B)增加灰塵監測儀器(C)種植喬、灌木', 'AB', 'AC', 'BC', 'ABC',  2),
(3462,  '中高級',  '環保署空氣品質監測站進行監測儀器校正時，除了採用標準氣體外，還會使用哪種氣體進行校正？',  '氧氣', '零氣體',  '臭氧', '二氧化碳', 2),
(3463,  '初級', '下列哪一種活動「不會」產生大量懸浮微粒？', '建造房屋', '火力發電', '生產鋼鐵', '出外郊遊', 4),
(3464,  '高級', '一般而言，高屏地區空氣品質最理想的季節是下列何者？',  '春季', '夏季', '秋季', '冬季', 2),
(3465,  '高級', '實驗顯示，光波長介於哪一個範圍的紫外線，會破壞生物的染色體？', '350-400奈米',  '300-350奈米',  '270-300奈米',  '250-260奈米',  4),
(3466,  '高級', '根據空污法法規，細懸浮微粒(FineParticulateMatters)係指懸浮在空氣中氣動粒徑小於多少？', 'PM1.0',  'PM2.5',  'PM10', 'TSP',  2),
(3467,  '中級', '臺灣的沙塵暴主要是透過中國大陸在東北季風下夾帶輸送，以下何者對於沙塵暴的敘述是正確的？',  '懸浮微粒濃度由北向南遞減', '懸浮微粒濃度由北向南遞增', '常發生於夏季高溫', '影響範圍只在中部以北地區', 1),
(3468,  '高級', '作為代表大區域範圍空氣品質，並避開局部污染源所設置的監測站，屬於下列哪一類空氣品質監測站？',  '一般測站', '工業測站', '交通測站', '背景測站', 1),
(3469,  '高級', '環保署空品監測站，每隔多久發布新的空氣污染指標值？',  '每半小時', '每1小時', '每3小時', '每6小時', 2),
(3470,  '中高級',  '根據《海洋污染防治法》，其所指稱之中央主管機關為何？', '內政部',  '經濟部',  '農委會',  '環保署',  4),
(3471,  '中高級',  '「過去臺灣西南沿海常傳出某養殖動物大量死亡，經證實是工業廢水惹的禍，主因為工廠排出的化學廢料的銅含量過高。」以上述及的動物，最有可能為下列何者？', '牡犡', '吳郭魚',  '福壽螺',  '鰤魚', 1),
(3472,  '中高級',  '下列哪一種生物族群的生產?可比擬熱帶雨?？',  '藻礁', '石滬', '珊瑚礁',  '島礁', 3),
(3473,  '中高級',  '當海域水體發生優養化時，將促使海洋環境中藻?的大?繁殖，常可發現下列哪一種現象？', '赤潮', '珊瑚白化', '聖嬰現象', '共生現象', 1),
(3474,  '高級', '根據《海域環境監測及監測站設置辦法》，海域環境監測之「選擇監測水質項目」，「不包括」下列哪一個化學組成？', '葉綠素ａ', '二氧化硫', '重金屬',  '營養鹽',  2),
(3475,  '高級', '「水華」指的是水域呈現何種現象？', '當一個水域中藻類大量增生，到達一種極為顯著的現象', '當一個水域中被大量油污污染，變成一片死寂的海洋',  '當一個水域中出現過多的外來種，導致生態失衡受影響的現象',  '當一個水域中魚類大量繁衍，表現出高度生物多樣性的現象', 1),
(3476,  '高級', '民國90?，希?籍貨?「阿瑪斯號」鐵礦砂船在墾丁外海擱淺，並導致附近海域受到污染，其導致海洋污染之主要原因為何？', '船上化學品外洩',  '船用油品洩漏', '船上鐵砂洩漏', '船體腐蝕', 2),
(3477,  '中高級',  '《蒙特婁議定書》之簽署，主要希望能夠保護下列哪一項地球環境？', '北極冰原', '地球臭氧層',  '酸化土壤', '德國黑森林',  2),
(3478,  '中高級',  '下列何者「不是」石化工廠的?散主要排放源？',  '揮發性有機液體儲槽',  '壓力槽',  '設備元件', '廢水處理場',  2),
(3479,  '中高級',  '對於在特殊氣象條件下，長時間持續空氣品質嚴重惡化的現象，稱之為什麼？', '工安事件', '光化學煙霧',  '空氣污染事件', '溫室效應', 3),
(3480,  '中高級',  '對於產生粉塵之裸露地、露天燃燒及農業操作等污染源，常被歸類為下列何者？',  '逸散污染源',  '移動污染源',  '固定污染源',  '揮發性污染源', 1),
(3481,  '中高級',  '酸雨其正確的名稱應為酸性沉降，下列哪一種屬於乾酸沉降？',  '酸雹', '酸雪', '酸霧', '酸落塵',  4),
(3482,  '中高級',  '凡因建築物內空氣污染導致人體異常症狀，常被歸屬於下列哪一種疾病？', '病態建築物症候群', '退伍軍人症',  '嚴重急性呼吸系統綜合症',  '禽流感',  1),
(3483,  '中高級',  '對於一氧化碳的敘述，下列何者正確？',  '全部來自石化燃料的不完全燃燒', '空氣污染指標之一', '無色無味，比空氣重',  '與血紅素的氧氣親和力低',  2),
(3484,  '高級', '下列哪一種粒徑的大氣懸浮微粒，也被稱之為呼吸性微粒？', '粒徑小於10μm的微粒',  '粒徑介於10~15μm之微粒', '粒徑介於15~20μm之微粒', '粒徑大於20μm之微粒',  1),
(3485,  '高級', '過去為提高汽油的辛烷值而增加下列何種物質，會對環境及人類健康造成不利影響？',  '四乙基鉛', '石棉', '氮氧化物', '二甲苯',  1),
(3486,  '高級', '下列哪一項是導致酸雨產生之主要化學物質？', '氯離子',  '鈉離子',  '硫酸根',  '氨根', 3),
(3487,  '高級', '香菸燃燒過程所釋出的化學物質中，至少有幾種已被證實具有致癌性？',  '10種以上',  '20種以上',  '40種以上',  '60種以上',  3),
(3488,  '高級', '加油站漏油污染土壤，如碰到礫石層，其污染情形會如何？', '僅污染土壤下層部分礫石層污染', '會快速污染整個礫石層', '不會往下繼續滲漏，因毛細管不連續', '污染土壤部分會自動分解油污',  2),
(3489,  '高級', '土壤受到污染後，使用各種整治技術之主要考量為何？', '民眾整治意願', '整治技術成熟度與需求', '整治成本及效果',  '整合技術可行性',  3),
(3490,  '高級', '業主要將工廠停業或歇業時，自行發現土壤及地下水污染場址，污染業主如何決定使用何種整治技術？',  '邀請專業顧問公司調查污染狀況後提出可行技術即可',  '邀請顧問公司提出可行技術後，需通知地方政府環保局專案委員會通過',  '邀請顧問公司提出可行技術，需通知地方環保局通過且需與地區居民溝通協調', '邀請顧問公司提出可行技術，通知環保署通過且需與地區居民溝通協調',  1),
(3491,  '高級', '哪種物質「不是」地下水的主要污染物？', '石油化學物質', '砷',  '重金屬',  '塑膠', 4),
(3492,  '中高級',  '水田土壤受到鎘污染後，其污染土壤之主要途徑為何？', '灌溉水受到臨近工廠排放鎘污染物質之影響',  '受到臨近工廠空氣中排放鎘污染物質之影響',  '人為置放鎘固體廢棄物於農田之影響', '人為放置鎘粉', 1),
(3493,  '中高級',  '評估可利用超級累積植物吸收移除污染土壤中重金屬，土壤污染程度為何？',  '輕微污染區',  '中度污染區',  '嚴重污染區',  '任何污染區',  1),
(3494,  '高級', '下列對於生物堆法的敘述何者正確？', '於受污染之土壤上飼養家禽', '以生物降解處理污染物', '一般整治期程至少要五年',  '利用基因改造生物進行生物降解', 2),
(3495,  '高級', '評估可利用超級累積植物吸收移除污染土壤中重金屬，大約要幾年？', '少於30年',  '50-100年',  '200-500年', '大於500年', 1),
(3496,  '高級', '在臺灣為何「不能」使用現地固化法或穩定法以降低污染物從土壤中溶出？',  '考量現地固化法或穩定法之物質會再從土壤中溶出', '整治費用較高且會引起二次污染', '污染物管制標準以全量為管制依據',  '可能會使土壤變成廢棄物無法資源再利用', 3),
(3497,  '高級', '典型之化學處理方法，利用還原劑將污染區之重金屬之型態改變，如六價鉻還原為三價鉻，此技術主要目的為何？', '可分解部分重金屬污染', '為了降低重金屬毒性',  '經現地應用需控制之條件尚可，屬經濟可行',  '為了增加整治的時間',  2),
(3498,  '初級', '下列何者「不是」受污染的土壤對生活環境以及生態的影響？',  '產生惡臭等氣味',  '使人感染肺炎鏈球菌',  '對生態造成影響',  '阻礙農作物的生長', 2),
(3499,  '中高級',  '一般地下水硝酸鹽的含量是以下列何者作為標準？', '氧',  '氫',  '氮',  '氦',  3),
(3500,  '高級', '我國土壤污染事件可溯自72年之何者事件？', '桃園縣高銀化工公司及基力化工公司農地鎘污染',  '雲林縣虎尾鎮稻米鎘污染',  '彰化縣花壇鄉白沙村農地鎘污染', '臺灣美國無線電公司(RCA)桃園廠土壤及地下水污染',  1),
(3501,  '中級', '下列哪一項是常見的環境荷爾蒙？',  '硼酸', '氯化鈉',  '硫酸', 'DDT',  4),
(3502,  '初級', '下列哪一種毒素容易因為食物發霉而產生？',  '黃麴毒素', '汞',  '多氯聯苯', '甲醇', 1),
(3503,  '高級', '某公司擬於山坡地設立大型觀光飯店及大型遊樂區開發案時，面積廣達20公頃，下列哪個選項「不是」用來判斷是否適宜開發的考慮要項？', '地質穩定性及山區道路坡度行車安全性',  '廢污水產生量及回收處理再利用', '水土保持預防與因應',  '交通車輛管制防治措施', 4),
(3504,  '高級', '臺灣中部或南部地區各種大型水庫或大型工業區開發案時，大都會面臨哪些環境品質考量問題？', '水源與水量不足，造成農民與開發業者搶水大戰',  '在枯水期排放水進口河川後，無水可稀釋，造成河川污染疑慮',  '排放水進入附近河川後，排放口下游為農田水利會之灌溉水取水口所造成困擾', '以上皆是', 4),
(3505,  '中級', '下列何者是政府鼓勵民眾購買在地食物的主因？',  '穩定農產品價格',  '避免外來食物入侵', '減少運輸所製造的碳排放',  '鎖國政策', 3),
(3506,  '中級', '同樣劑量或濃度的環境荷爾蒙對下列哪一個年齡層的影響最大？', '嬰幼兒',  '青少年',  '青壯年',  '老年人',  1),
(3507,  '中級', '下列哪一項是環境荷爾蒙的特性？',  '工業環境中才會出現',  '需要一段時間才會顯現它的影響', '對所有人均產生一樣的影響', '唯一靠接觸途徑才會受影響', 2),
(3508,  '高級', '依《文化資產保存法》規定，「古蹟之管理維護」所指事項為何？',  '日常保養及定期維修',  '防盜、防災、保險', '使用或再利用經營管理', '以上皆是', 4),
(3509,  '高級', '(A)主管機關、(B)所有人、(C)使用人、(D)管理人，下列哪些人可申請「歷史建築」之登錄？',  'AB', 'BC', 'CD', 'AD', 1),
(3510,  '中高級',  '臺灣原住民族多具有極高的音樂藝術表現，下列何者為布農族的民族傳統音樂？',  '八部合音', '口鼻笛',  '口簧琴',  '和聲合音', 1),
(3511,  '高級', '臺灣的「自然保護區域」劃設及其法源，下列何者正確？',  '野生動物重要棲息環境－野生動物保育法', '自然保留區－森林法',  '自然保護區－文化資產保存法',  '以上皆非', 1),
(3512,  '中高級',  '魯凱族因應氣候變化及在地取材模式所建造出的會呼吸的房子為何？', '半穴居',  '石板屋',  '毛胚屋',  '咾咕石屋', 2),
(3513,  '中級', '原住民傳統中的許多禁忌，以下敘述何者正確？',  '設立神聖的祖靈地，並禁止狩獵', '遵循部落中不可進入禁忌地的傳統',  '禁獵族內的圖騰動物',  '以上皆是', 4),
(3514,  '中級', '為了捕捉飛魚，花費相當長的時間到山中砍伐巨木、切割成船板，再加以組合，是下列哪一個族的傳統？', '達悟族',  '阿美族',  '卑南族',  '賽夏族',  1),
(3515,  '高級', '以下何者「不是」《原住民基本法》頒布以實行原住民族自治的主因？',  '原住民地區普遍缺乏民主政治實作權力',  '為要保障原住民族之平等地位',  '保障原住民族之自主發展',  '要尊重原住民族的意願', 1),
(3516,  '中高級',  '半豎穴式木屋與平地竹屋為下列哪一族人傳統的住居型態？', '排灣族',  '魯凱族',  '布農族',  '泰雅族',  4),
(3517,  '中級', '泰雅族為了儲存收割的小米所蓋的穀倉使用哪些防護措施？', '高腳屋，阻絕濕氣', '欄杆式建築防止濕氣',  '連接地面的柱子設置防鼠板防止鼠類入侵', '以上皆是', 4),
(3518,  '初級', '達悟族製造大船時需要良好的木材，下列何者為該族永續利用林木時所展現的智慧？',  '父親會在樹木上預做記號，利於家中男孩觀察樹木成長情形', '砍下一棵樹後立刻在附近勳著另一棵樹做記號，繼續培養',  '不整片砍伐樹木，而是在不同角落選則是用樹種',  '以上皆是', 4),
(3519,  '初級', '以下對原住民常使用的刀耕火種法的敘述何者「錯誤」？',  '以火燒除地表上的植物以取得耕地',  '不另外使用肥料的粗放農業', '能使農地保持富饒具生產力', '當土地生產力不良時需遷徙尋找新耕地',  3),
(3520,  '高級', '原住民委員會為開發原住民族地區的溫泉所需經費之主要來源是？',  '未來的經營財團',  '原住民族綜合發展基金之溫泉取用費每年提撥百分之六十',  '原住民委員會之預算',  '地方縣政府都市計畫重劃經費',  2),
(3521,  '高級', '中央目的事業主管機關擬於原住民族地區劃定資源治理區域前，必須將計畫內容公告閱覽，以下何者「不是」被要求的項目？',  '計畫目的、範圍',  '經營管理事項', '與當地共管事項',  '營利回饋與補償項目',  4),
(3522,  '中高級',  '以下何者「不是」魯凱族的狩獵規定?',  '雲豹是魯凱族的神聖動物，不可狩獵', '獵殺小動物是小人的行為',  '狩獵的季節集中在夏季', '熊雖然可以獵殺，但是會引來疾病的報應', 3),
(3523,  '高級', '如果當地原住民族部落會議議決為否決者，中央目的事業主管機關可以如何回應？', '修正計畫書內容，重行辦理公告閱覽、公聽會及部落會議',  '永遠撤回該計畫書', '三年內不得在相同範圍內提案',  '以上皆非', 1),
(3524,  '中級', '地震發生時，新聞常會報導「震央」位置，請問下列何者為「震央」的定義？', '地震錯動的起始點', '地震錯動的終點',  '震源在地表的投影點',  '震波發生的起點',  3),
(3525,  '初級', '泰雅族選擇高山地區居住的可能原因為何？',  '水草豐美', '景色怡人', '蚊蟲較少', '氣候適中', 3),
(3526,  '中級', '下?何者「?是」游??射「劑?」的單位？', '西弗(Sv)', '格?(Gy)', '貝克(Bq)', '侖琴(r)',  3),
(3527,  '中高級',  '長期接觸或??於重?屬下會造成健康上的影響，並引發疾病。下?各項組合中，哪一組之因果相關性最低？\n', '錳－巴金森氏症候群',  '汞－水俁病',  '鉻－致畸胎',  '砷－烏腳病',  3),
(3528,  '中高級',  '石綿經公告為致癌物後，相關作業多改用玻璃纖維替代，此種作法屬何種控制方法？',  '變更生產作業方法以達資源節省', '以低毒性物質代替高毒性物質',  '以低價格之物質代替高價格之物質',  '以高科技研發之產品取代原有的產品', 2),
(3529,  '中高級',  '一般認為職業事故發生的主要原因為何？', '工作場所髒亂', '工作場所噪音干擾', '工作場所的照明不佳',  '工作人員的不安全動作或行為',  4),
(3530,  '高級', '哪一類火災是指電器火災？', '甲(A)類',  '乙(B)類',  '丙(C)類',  '丁(D)類',  3),
(3531,  '中級', '下列有關冷卻滅火法之描述何者正確？',  '將燃燒物由火源中移除，減低燃燒面積之滅火方法', '利用滅火藥劑之冷卻效果，以降低燃燒溫度',  '利用化學藥劑於火焰中產生鹵素(或鹼金屬)離子', '將不燃性氣體朝可燃物傾注，阻絕可燃物與氧氣接觸',  2),
(3532,  '初級', '下列何者是窒息滅火法的原理？', '利用滅火藥劑之冷卻效果，以降低燃燒溫度',  '將燃燒物由火源中移除，減低燃燒面積',  '將氧氣自外部加以遮斷，阻絕可燃物與空氣接觸',  '將可燃性氣體朝不可燃物傾注',  3),
(3533,  '中級', '在醫院工作因為中央空調系統沒有定期消毒保養而引起醫護人員得到退伍軍人症，是屬於哪種類型的危害？',  '物理性危害',  '化學性危害',  '生物性危害',  '心理性危害',  3),
(3534,  '初級', '下列何者是我國職業安全衛生業務的中央主管機關？',  '內政部勞工司', '行政院衛生署', '行政院勞工委員會', '勞動部',  3),
(3535,  '中高級',  '電鍍作業易使勞工暴露於下列何種形態之鉻而造成鼻中膈穿孔？', '煙霧', '粉塵', '霧滴', '燻煙', 3),
(3536,  '高級', '二異氰酸甲苯(TDI)對人體會造成危害，它屬於何種物質？', '窒息性物質',  '致過敏性物質', '麻醉性物質',  '致癌性物質',  2),
(3537,  '中級', '經吸收進入人體內之鉛，大部分會沉積在人體的哪一器官？', '肝',  '腎',  '腦',  '骨',  4),
(3538,  '中級', '在勞動時因體內平均體溫過高，導致調節體溫機能喪失而無法適當的維持熱平衡。此為何種熱危害症狀？', '熱中暑',  '熱痙攣',  '熱衰竭',  '心臟衰竭', 1),
(3539,  '中高級',  '我國目前高溫作業勞工作息時間標準，溫度以何指數為標準？',  '熱舒適指數',  '熱危害指數',  '綜合溫度熱指數',  '熱適應指數',  3),
(3540,  '中級', '下列何者「不是」國內公告法定職業病？', '乳膠引起病症', '過勞死',  '銦引起病症',  '貧血', 4),
(3541,  '中高級',  '下列有關職業病的敘述，何者「錯誤」？', '隧道及地下捷運工人易罹患潛水伕症', '打字員、職業鋼琴師易導致白指症',  '蓄電池工易罹鉛中毒',  '熔接工、玻璃成型工易導致白內障',  2),
(3542,  '中級', '下列何者「不屬於」職業性男性生殖系統疾病之病因？', '鉛暴露',  'X-射線暴露', '錳暴露',  '鹵族殺蟲劑暴露',  3),
(3543,  '中級', '工作之中長期反覆手部之操作，常引起腕隧道症候群，其主要病因為何？', '振動引起的週圍血管傷害',  '手臂屈肌發炎', '正中神經受到壓迫', '肌腱之反覆拉傷',  3),
(3544,  '高級', '有關生物危害預防與控制的敘述，下列何者「錯誤」？', '遵守微生物實驗室操作守則', '生物安全櫃內在為正壓', '生物安全櫃應雙HEPA過濾排氣',  '生物安全櫃應氣密式',  2),
(3545,  '高級', '下?何者為物?性危害因子？',  '紅外線',  '粉塵', '重複性動作',  '退伍軍人菌',  1),
(3546,  '高級', '臺灣職業病的病史中「飛歌事件」，是屬哪一種溶劑中毒？', '正己烷',  '四氯化碳', '三氯乙烯', '二異氰酸甲苯', 3),
(3547,  '中高級',  '下列何者「不是」屬於化學窒息劑？', '氰化氫',  '氨',  '硫化氫',  '一氧化碳', 2),
(3548,  '中高級',  '下列有關鉛的生物偵測的敘述何者「錯誤」？', '有機鉛化合物的吸收，主要是由皮膚吸收', '循環中的鉛，90%會與紅血球結合', '90%的鉛會最後儲存於骨骼',  '有機鉛的??，最好的偵測指標則是血中鉛濃?',  4),
(3549,  '中高級',  '關於半導體工廠內引起化學性灼傷較嚴重的物質為下列何者？',  '二硫化碳', '正己烷',  '氨氣', '氫氟酸',  4),
(3550,  '高級', '短時間暴露限值是規範勞工任何一次連續多少時間的暴露，均「不得」超過之濃度？',  '連續5分鐘',  '連續10分鐘', '連續15分鐘', '連續30分鐘', 3),
(3551,  '中高級',  '熱危害中係由於大腦皮質血液供應不足而造成的虛脫狀態，係為下列何種熱危害症狀？', '熱衰竭',  '失水', '熱痙攣',  '熱中暑',  1),
(3552,  '中級', '依勞工安全衛生法令規定，事業單位工作場所發生勞工死亡職業災害時，雇主應於多少時間內報告勞動檢查機構？', '八小時',  '十二小時', '二十四小時',  '四十八小時',  3),
(3553,  '中級', '少子化會對臺灣社會帶來甚麼衝擊？', '勞動力旺盛',  '創造更多的經濟效益',  '社會人口結構趨向年輕化',  '學校面臨招生困難', 4),
(3554,  '中高級',  '有關2013年中國報告的H7N9感染人類案例，下列敘述何者為「錯誤」？',  '發現感染案例後，一週內立即有疫苗開始生產', '勤洗手重視手的衛生可預防感染', '重視呼吸系統的衛生可預防感染', '重視食物安全衛生可預防感染',  1),
(3555,  '中高級',  '有關愛滋病與人類免疫缺乏病毒(HIV)之敘述，以下何者「錯誤」？', '人類免疫缺乏病毒感染免疫系統的細胞，破壞或減損細胞功能',  '愛滋病(AIDS)，是一種經由性行為、血液或母子垂直傳染的疾病',  '愛滋病就是後天免疫缺乏症候群(AcquiredImmunodeficiencySyndrome，AIDS)的簡稱', '如果媽媽確定為愛滋病毒病患感染者，仍可餵母乳', 4),
(3556,  '中高級',  '有關喝酒之敘述，下列何者正確？',  '酒精濫用是指因喝酒導致個人健康、人際關係或工作能力受到傷害',  '酒精只傷肝，但不影響身體其他器官', '喝啤酒比喝烈酒安全',  '小孩和青少年可以飲酒', 1),
(3557,  '中高級',  '在臺灣，下列哪一類學校吸菸率最高？',  '普通高中', '綜合高中', '職業高中', '夜校', 4),
(3558,  '中高級',  '有關疫苗之敘述，下列何者「錯誤」？',  '不活化疫苗和較少的有害作用有關',  '不活化疫苗產生的免疫力隨時間而減弱，因此需追加劑量',  '活性減毒疫苗引起的免疫反應只限於體液免疫', '理想疫苗提供的保護長達數年，最長甚至可以終生', 3),
(3559,  '中高級',  '有關食品安全之敘述，下列何者正確？',  '真空包裝的食物皆是無菌的可安心食用',  '食用前要削皮的水果,不必先洗.',  '食物用保鮮膜覆蓋直接用微波加熱既方便又安全',  '購買食品注意包裝、貯放條件和保存期限', 4),
(3560,  '中高級',  '因臺灣地區各地環境不同，登革熱案例較常出現在哪一地區？',  '高雄', '臺東', '花蓮', '宜蘭', 1),
(3561,  '高級', '根據臺灣衛生福利部的資料，民國100年國人主要死因為何？', '慢性疾病', '傳染病',  '罕見疾病', '急性疾病', 1),
(3562,  '高級', '為什麼夏季為感染登革熱的高風險期？',  '夏季天氣熱，人們穿著較為單薄，容易被蚊子叮咬', '土耳其斑蚊在夏季大量繁衍', '夏季常常下雨，造成環境潮濕，積水處增加',  '因為夏季的天氣太熱造成免疫力較低', 3),
(3563,  '高級', '烏腳病和皮膚癌與飲用水中的什麼元素有關？', '鉛',  '砷',  '鎘',  '汞',  2),
(3564,  '高級', '下列何者為霍亂的傳染方法？',  '被患者的飛沫傳染', '吃到或喝到受感染的水或食物',  '接觸到患者的手',  '經由蚊子叮咬傳染', 2),
(3565,  '高級', '下列哪一種方式能夠為儘量避免吃到蔬果農藥殘留的機率？', '選擇食用輪番採收的蔬菜',  '吃當季盛產的蔬果', '選擇食用搶收及搶種的蔬菜', '不剝皮直接吃蔬果', 2),
(3566,  '中高級',  '提供安全的飲用水，可預防什麼兒童疾病？',  '腹瀉', '營養過剩', '腦膜炎',  '口腔癌',  1),
(3567,  '高級', '檳榔對健康的危害，「不包括」下列何者？',  '口腔癌',  '牙齦萎縮', '口腔黏膜下纖維化', '口蹄病',  4),
(3568,  '初級', '水銀溫度計打破時，下列處理方式何者「不正確」？',  '請非清理人員離開', '打開電熱器及空調系統', '清理時要戴手套和活性碳口罩',  '保持對戶外的空氣流通', 2),
(3569,  '中級', '在家中正常使用狀況下，開?一小時耗電量最多(均以一臺計)為下列何者？', '電腦', '電冰箱',  '冷氣機',  '電視機',  3),
(3570,  '初級', '下列何者「不是」環保署推動的環保概念？',  '多吃蔬食少吃肉',  '在地生產、在地消息',  '均衡飲食，吃出健康',  '低碳旅遊樂活', 3),
(3571,  '中高級',  '下列何者是黃金十年永續環境之主軸？',  '綠能減碳', '生態家園', '災害防救', '以上皆是', 4),
(3572,  '中級', '所謂時間電價，下列何者正確？', '不區分基本電價和流動電價', '不分假日與非假日', '區分日間或夜間',  '基本電價相同', 3),
(3573,  '中高級',  '我國政府在再生能源之規劃，以下何者「錯誤」？', '?勵沼氣發電', '?勵小型風力發電', '日本福島核災後已停止地熱發電?勵', '規劃打造陽光屋頂百萬座',  3),
(3574,  '初級', '在生活中有關太陽能運用的?述，下列何者正確？', '不能用在採光罩上', '不能用在無線通信上',  '可以用在交通號誌上',  '只能用在太陽能熱水器上',  3),
(3575,  '中高級',  '在臺灣架設太陽能板時，我們應注意什麼事項？',  '臺灣在北回歸線上，板面朝南可以得到最大效益',  '場地周圍應有高樓保護', '周圍應有樹林遮蔽避免太熱', '周圍應有高物遮蔽，以免直接照射',  1),
(3576,  '中高級',  '新北市三峽有一座碳中和樂園，所謂「碳中和」是指什麼？', '用碳去進行酸鹼中和作用',  '用碳吸附空氣中酸性氣體',  '把碳由中和帶到三峽園區放置',  '計算碳排放，消耗量與減低量相互抵消',  4),
(3577,  '初級', '下列何者「不是」環保署建立空氣品質監測的主要目的？',  '防制空氣污染', '提升空氣品質', '防止全球暖化', '掌握監測數據', 3),
(3578,  '中級', '洗澡時瓦斯中毒，其實是指吸入哪種過量的氣體？', '二氧化碳', '氧氣', '一氧化碳', '二氧化硫', 3),
(3579,  '中級', '下列哪一種活動會使大氣的二氧化硫大量增加？',  '火力發電', '飼養豬隻', '燃燒雜草', '種植農作物',  1),
(3580,  '中級', '下列何者「不屬於」臭味逸散源？',  '垃圾場',  '屠宰場',  '石化廠',  '營建工地', 4),
(3581,  '中高級',  '辦公室事務機應放在較為通風之處，是因為它主要會產生下列何種空氣污染物？',  '臭氧', '一氧化碳', '甲醛', '二氧化碳', 1),
(3582,  '初級', '有關室內空氣污染，下列何者「錯誤」？', '油漆及塗料為主要揮發性有機物來源', '事務機易產生臭氧，應放在通風處',  '新裝潢的房間要緊閉門窗保持清潔',  '潮濕處應常清潔打掃以免孳生黴菌',  3),
(3583,  '中高級',  '下列何者「不是」室內甲醛的主要來源？', '油漆與塗料',  '辦公室事務機', '合板與隔板',  '清潔劑與立可白',  2),
(3584,  '中高級',  '下列何者是國家公園空氣品質監測站應測定的項目？',  '風向、風速',  '鉛',  '交通流量', '毒性污染物',  1),
(3585,  '中高級',  '機車出廠滿五年每年應做一次排氣定檢，若未收到定檢通知單怎麼辦？',  '不用定檢', '仍可持行車執照去定檢站檢驗',  '自費定檢', '以上皆非', 2),
(3586,  '中級', '空氣污染防制區可分三級，下列何者是屬於一級防制區劃定之區域？', '國家公園', '科技園區', '焚化爐',  '商業區',  1),
(3587,  '中高級',  '機車車籍登記在某縣市，但機車目前在其他縣市使用，接到定檢通知時該如何辦理？',  '可就近找任一環保局委託之定檢站檢驗',  '必須至車籍所在地定檢站檢驗',  '必須在使用地之定檢站檢驗', '以上皆非', 1),
(3588,  '初級', '發現烏賊車後可以利用何種管道檢舉？',  '網路', '傳真', '電話', '以上皆是', 4),
(3589,  '高級', '下列何者是政府針對固定污染源提出的管制政策？', '針對玻璃業訂定硫氧化物排放濃度標準',  '加急機動車輛排放廢氣標準', '管制油品之含硫量', '發布「車用汽柴油成分管制標準」',  1),
(3590,  '中級', '下列何種方法最有效控制物?裝卸活動中所引起的粉塵?散？',  '啟動強力風扇', '放慢裝卸動作', '啟動灑水系統', '增加清除粉塵人員', 3),
(3591,  '中級', '所謂的健康傢俱，是指下列何種物質含量較低？',  '乙醚', '鐵氟龍',  '塑膠', '甲醛', 4),
(3592,  '中級', '酸雨對農作物影響的主要原因為何？', '直接腐蝕植物葉子，使其無法行光合作用', '酸雨溶解土壤中金屬元素，造成礦物質大量流失',  '直接把植物打倒，因無法站立而死亡', '植物長期被淹在水中，無法進行呼吸作用', 2),
(3593,  '高級', '下列有關我國車用柴油之規定，何者正確？',  '其中添加2%的生質柴油',  '其中均未添加生質柴油', '其中添加10%的酒精', '其中添加50%汽油',  1),
(3594,  '高級', '在產生相同能量下，重型柴油引擎使用生質柴油與化石柴油對環境的效益，下列何者正確？', '二氧化碳僅有化石柴油的15~40%',  '懸浮微粒排放僅下降1%',  '一氧化碳排放量略微增加',  '生質柴油含大量硫，會產生致癌風險物質', 1),
(3595,  '中高級',  '以下對酒精汽油之?述，下列何者「錯誤」？', '具有高辛烷值可提高汽油的抗爆性',  '酒精含氧量高，使燃燒效率提高', '減少燃燒不完全所造成的廢氣污染',  '不會對汽車材料中銅及鋅腐蝕性', 4),
(3596,  '中級', '對於植物與空氣品質之關係，下列敘述何者正確？', '不同污染特性區，可考量選擇適合之樹種', '各樹種對污染之淨化能力相同',  '樹木具有觀賞功能，無淨化空氣功能', '有污染之區域對植物生長不利，不應栽種樹木', 1),
(3597,  '高級', '我國固定污染源空污費，其徵收方式為下列何者？', '依工廠登記規模徵收',  '依污染物種類及實際排放量徵收', '不論污染物種類，以排放總量徵收',  '以原料用量徵收',  2),
(3598,  '中高級',  '加油站中販售95無鉛汽油，其中95是指下列何者？', '其辛烷值(抗震爆性)為95',  '其中加生質柴油95%', '其中加上95%的水',  '只能加到油箱容量的95%', 1),
(3599,  '高級', '我國空氣品質管理法中所管制的微生物是下列哪二種？', '真菌、細菌',  '黴菌、酵母菌', '病毒、細菌',  '黴菌、病毒',  1),
(3600,  '高級', '下列有關環保署空氣品質自動監測站之?述，何者「錯誤」？',  '以一般空氣品質監測站最多', '交通空氣品質監測站主要在量測交通污染', '國家公園空氣品質監測站主要在量測國家公園內的空氣品質', '超級測站主要在追?超級颱風的動態', 4),
(3601,  '中高級',  '下列有關輻射之?述何者正確？', '非游離輻射較游離輻射能量強',  '微波較無線電波強', '電磁場能量較光波能量強',  '電磁場無熱效應也不會使溫度升高',  4),
(3602,  '高級', '西元2013年時，我國規定極低頻電磁場暴露限制值在頻率60Hz時為833.3mG(亳高斯，或83.33微特斯拉)，至於其他國家情形，下列敘述何者「錯誤」？',  '美國聯邦法規限制比我國嚴格',  '日本、南韓與我國規定相同', '中國及香港均尚未制定限值', '丹麥及加拿大均尚未制定限值',  1),
(3603,  '中級', '下列何項電器其電磁場值為最高者(距離3公分)？',  '微波爐',  '吸塵器',  '電視', '冰箱', 2),
(3604,  '高級', '依我國規定，從事海域工程造成海洋污染時，下列敘述何者正確？',  '會被罰30-150萬元罰鍰',  '不用理會，因為海洋涵容力強',  '只要採取措施減輕污染即可', '只需立即通知主管機關', 1),
(3605,  '中高級',  '我國火力電廠燃燒產生的顆粒狀污染物(懸浮微粒)，通常如何處理？',  '可直接排出',  '利用靜電集塵器去除，其排氣符合環保法規',  '因環保法規未有限制，所以自訂標準處理', '用大量水直接沖洗後再排氣', 2),
(3606,  '中級', '國家公園是依據下列哪一項法規劃設的？', '森林法',  '野生動物保育法',  '文化資產保存法',  '國家公園法',  4),
(3607,  '中級', '「鋤頭、犁、碌碡、秧盆」這四種物品的共同性為何？', '用以傳統農業', '用以採礦', '用以秤重', '用以保存食物', 1),
(3608,  '中級', '關於國姓鄉北港溪上方的糯米橋之敘述，下列何者「錯誤」？',  '先民利用糯米、高粱混合黏土建造',  '利用糯米混合紅糖、石灰等物資，作為黏築石塊的材料', '當時由於水泥是一種缺乏而且昂貴的材料，而改用替代品建造',  '公告指定為臺閩地區三級古蹟',  1),
(3609,  '中級', '下列何者「不是」製作擂茶的工具？', '擂缽', '擂捧', '擂棍', '水壺', 4),
(3610,  '初級', '試問下列何者「不是」臺灣民俗藝術？',  '陶笛', '糖蔥', '畫糖人',  '薑餅屋',  4),
(3611,  '中高級',  '傳統美濃的油紙傘，為何又被稱為「黑油傘」？',  '用黑色的傘骨製成，呈黑紅色',  '紙傘價格非常昂貴，以黑金色為主',  '製造過程中將傘置放在鍋內和桐油一起煮', '傘面呈現黑色，是因為染料調配的關係',  4),
(3612,  '初級', '下列何者是管制溫室氣體排放的條約？',  '華盛頓公約',  '京都議定書',  '蒙特婁議定書', '斯德哥爾摩公約',  2),
(3613,  '中高級',  '碳交易主要是交易何種溫室氣體的排放量？',  'HCHO', 'CO2',  'CO', 'CH4',  2),
(3614,  '初級', '下列何者「不是」全球暖化帶來的影響？', '洪水', '熱浪', '旱災', '地震', 4),
(3615,  '中高級',  '下列敘述何者「錯誤」？',  '溫室效應的氣體中，最主要的是二氧化碳', '溫室氣體污染物來源主要是畜牧業',  '正常情況下水蒸氣才是地球上最重要之溫室效應氣體',  '溫室效應會使全球氣溫節節上升', 2),
(3616,  '中級', '下列何者為《京都議定書》之締約國但未簽署該條約？', '中國', '日本', '美國', '法國', 3),
(3617,  '中高級',  '下列敘述何者正確？',  '氟氯碳化物只會破壞臭氧層，與溫室效應無關', '溫室效應是溫室氣體攔截地球表面反射的紫外線',  '溫室氣體的增加，加強了溫室效應，是造成全球暖化的主要原因', '溫室效應是太陽一直放出過多的熱所造成的',  3),
(3618,  '高級', '在亞洲地區，人均碳排放最高的是下列哪個國家？', '中國', '臺灣', '日本', '南韓', 2),
(3619,  '初級', '下列何者「不是」海平面上升後所造成的後果？',  '農田遭水淹沒', '陸地減少', '農作物產量減少',  '人口密度降低', 4),
(3620,  '中高級',  '「某溫室氣體多屬天然排放，自然界的生物厭氧腐解作用時會排放，如水體流動性不高之湖泊、濕地等均有較高貢獻」，以上描述是指下列何種氣體？', '二氧化碳', '甲烷', '氧化亞氮', '氫氟碳化物',  2),
(3621,  '初級', '下列何種方法「無法」減少二氧化碳？',  '自備杯筷，減少免洗用具垃圾量', '多吃蔬菜，少吃肉', '選購當地、當季食材，減少運輸碳足跡',  '想吃多少儘量點，剩下可當廚餘回收', 4),
(3622,  '高級', '下列何者為碳中和的標準？', 'PAS2060',  'PAS1060',  'ISO14050', 'ISO12050', 1),
(3623,  '初級', '關於綠色採購的敘述，下列何者「錯誤」？',  '採購回收材料製造之物品',  '採購的產品對人體傷害性較小',  '選購產品對環境傷害較少、污染程度較低', '以精美包裝為主要首選', 4),
(3624,  '高級', '關於黃金標準基金會的目標，下列何者「錯誤」？', '幫助具有可持續能源專案的投資', '確保可續性開發案貢獻的顯著性與持久性', '確保投資案對環境之影響',  '降低公眾對再生能源與能源效率的支持',  4),
(3625,  '中高級',  '有關二氧化碳的減量，下列何者為CCS的中文名稱？', '課徵碳稅', '發展潔淨的替代能源',  '預燃、氧燃燒技術', '二氧化碳捕集與封存',  4),
(3626,  '高級', '下列何者「不屬於」碳交易的機制？', '繳交空污費',  '清潔發展機制', '聯合履行', '排放交易', 1),
(3627,  '高級', '我國推動產業溫室氣體盤查作業，主要係參考下列何者？',  'ISO/CNS14064-1', 'ISO/CNS13064-1', 'ISO/CNS14000-1', 'ISO/CNS1300-1',  1),
(3628,  '中級', '下列何者「不是」我國永續能源政策綱領之政策原則「二高二低」？', '低排放',  '低依賴',  '高效?',  '高經濟',  4),
(3629,  '中級', '一旦大氣中的CO2含量增加，會引起哪一種後果？',  '臭氧層破洞',  '溫室效應惡化', '冰期來臨', '海平面下降',  2),
(3630,  '中高級',  '限制溫室氣體的排放的主要作用是什麼？', '大氣的逆輻射作用', '大氣對太陽散射作用',  '大氣對地面輻射的吸收作用', '大氣對太陽輻射的反射', 3),
(3631,  '中級', '民國100年爆發塑化劑事件後，政府新增及調整公告列管毒性化學物質包括鄰苯二甲酸酯類塑化劑、甲醯(ㄒ一)胺及安殺番等，以上物質具有下列何種特性？',  '易分解',  '生態毒性', '生物稀釋', '以上皆是', 2),
(3632,  '初級', '下列何者「不會」減少溫室氣體的排放？', '?少使用煤、石油等化石燃料',  '大量植樹造林，禁止亂砍亂伐',  '增高燃煤氣體排放的煙囪?', '開發太陽能、水能等新能源', 3),
(3633,  '中級', '我國已於99年4月6日完成訂定「環境荷爾蒙管理計畫」，確立各部會分工監測、管理市面上相關商品及產品，下列何者是衛生署主要的管理範圍？', '農藥', '食品容器', '玩具', '酒類', 2),
(3634,  '初級', '下列哪一項活動是環保署為鼓勵全國民眾共同維護環境整潔而舉辦的？',  '環保知識擂臺賽',  '檢舉髒亂我在行',  '土淨水清家園永青', '綠色心視界.環境心體驗',  2),
(3635,  '中高級',  '?蟲劑名稱中常以「XX?」稱呼的是下列何種?蟲劑？',  '有機氯系殺蟲劑',  '氨基甲酸劑',  '合成除蟲菊劑', '有機磷系殺蟲劑',  3),
(3636,  '中高級',  '?蟲劑名稱中常以「XX丹」稱呼的是下列何種?蟲劑？',  '有機氯系殺蟲劑',  '氨基甲酸劑',  '合成除蟲菊劑', '有機磷系殺蟲劑',  2),
(3637,  '高級', '環境用藥產品有效期限，最長為幾?？',  '三年', '五年', '七年', '九年', 2),
(3638,  '高級', '臺灣依毒性化學物質管理法將毒化物分成四類，急毒性物質屬於第幾類？', '第一類',  '第二類',  '第三類',  '第四類',  3),
(3639,  '中高級',  '下列哪一種行為是屬於偽造環境用藥的情形？', '超過有效期限', '擅自添加著色劑',  '有效成分含量與容許誤差範圍不符',  '摻雜或抽換國內外產品', 4),
(3640,  '高級', '下列何者是環保署針對環境衛生用藥產品核准的許可證字號？',  '環署衛製字第OOO號', '環署毒製字第OOO號', '環署廢製字第OOO號', '環署醫製字第OOO號', 1),
(3641,  '中級', '使用環境用藥時眼睛不小心受到污染，應利用下列何者物質減輕污染程度？',  '用眼淚沖洗',  '重水', '無菌生理食鹽水',  '消毒藥水', 3),
(3642,  '中級', '於害蟲防治時常用的昆蟲生長調節劑，下列何者是其主要的生理作用機制？',  '阻礙發育', '改變外型', '降低智力', '改變性別', 1),
(3643,  '初級', '臺灣的環境病媒一般可以分為幾種？', '五種', '四種', '三種', '兩種', 1),
(3644,  '初級', '使用蚊香或電蚊香時要注意什麼事情？',  '置於室外', '玩具收起來',  '置於室內時要注意通風', '食具加蓋子',  3),
(3645,  '高級', '南太平洋的島國吐瓦?之所以要舉國移民?西?的主要原因為何？',  '環境污染嚴重', '超抽地下水導致地層下陷',  '氣候過?炎熱', '海平面上升即將淹沒家園',  4),
(3646,  '中級', '使用環境用藥清潔環境時，下列何者是與消毒劑之效力成反比關係？', '溫度', '處理時間', '抗藥性',  '接觸面積', 3),
(3647,  '中級', '如公害事故發生，有廢水持續流出去時，為了防止污染擴大，常用的方法有哪些？', '將有害廢液設法導入池塘中暫存', '將污染廢液排入下水道系統', '採用強力吸收劑',  '以上皆是', 3),
(3648,  '中高級',  '何太太因錯誤使用殺蟲藥，導致全身無力頭暈噁心等症狀，當何太太被送進醫院後，醫生首先要知道下列何種資訊？',  '殺蟲劑的種類', '殺蟲劑的劑量', '殺蟲劑的濃度', '殺蟲劑的品牌', 1),
(3649,  '高級', '大氣中的懸浮微粒對整個環境造成很大的影響，故政府於民國91年建置下列何種監測站？', '超級測站', '光化學測站',  '逆溫測站', '交通空氣品質監測站',  1),
(3650,  '初級', '根據環保署資料顯示，世紀之毒「戴奧辛」主要透過何者方式進入人體？', '透過觸摸', '透過呼吸', '透過飲食', '透過雨水', 3),
(3651,  '中高級',  '環保署針對世紀之毒「戴奧辛」有哪些加強管制措施？', '限制焚化爐設立地點',  '管控焚化爐燃燒垃圾時段',  '管制污染原料來源', '以上皆是', 3),
(3652,  '初級', '下列哪一種消費行為是有效減少垃圾的產生？', '不斷索取試用品',  '購買過量衣物', '準備購物袋',  '準備大量零錢', 3),
(3653,  '中級', '下列何者是夜間收集垃圾的主要優點？',  '收集效率高',  '時薪較高', '產生較少噪音', '較沒有安全上的問題',  1),
(3654,  '中高級',  '實驗室實驗後產生的廢液，應該如何處理？',  '留著以後可能還會用到', '不管他，棄置於原地',  '倒入廢液桶中，集中回收處理',  '直接倒入洗手槽中', 3),
(3655,  '高級', '下列哪種行為是工廠將應負的成本責任，轉嫁給社會大眾？', '工廠將處理好的廢氣排出',  '工廠排出未處理的廢水', '工廠生產可回收產品',  '工廠將廢棄物運往焚化廠處理',  2),
(3656,  '高級', '下列何者為資源回收四合一計畫中，社區民眾、學校所需配合的項目？',  '支付回收清除處理費',  '成立民間回收團體', '定時、定點、定線進行資源回收', '回收資源垃圾', 4),
(3657,  '中高級',  '下列何者「不是」垃圾前處理的目的？',  '減少污染減輕災害', '增進營運效率', '回收可用物質', '回收轉化物或能源', 1),
(3658,  '中高級',  '在追求生態效益的前提下，下列何者「不是」產品設計及製造「搖籃到搖籃」的設計理念？', '降低有害廢棄物的使用', '消除廢棄物的觀念', '創造多樣性',  '使用再生能源與碳管理', 1),
(3659,  '初級', '廚餘回收分為「熟廚餘」及「生廚餘」兩類，以下哪一項屬於生廚餘？',  '不要的果皮',  '烹煮過的葉菜', '吃剩的滷肉飯', '過期的罐頭食品',  1),
(3660,  '初級', '政府會向特定業者收取回收清除處理費，以作為資源回收管理基金，以下有關資源回收管理基金的用途何者正確？', '支付應回收物品的回收清除處理補貼費用', '補助獎勵回收系統及再生利用相關作業費用',  '支付執行機關代清理費用',  '以上皆可', 4),
(3661,  '中高級',  '物品或其包裝、容器在經食用或使用後，會產生以下何種情形時，政府將要求由製造、輸入業者負責回收清除處?？',  '含長期??腐化的成分', '含有害物質之成分', '??清除、處?',  '以上皆是', 4),
(3662,  '中高級',  '以下何者為已公告可做土壤改?用途之事業廢棄物種?？',  '蔗渣', '蔗渣煙?灰',  '製???', '以上皆可', 4),
(3663,  '初級', '下?垃圾處?方法何者有錯？',  '做好分?工作', '自?焚化以減少垃垃?', '減少廢棄物的產生', '做好資源回收工作', 2),
(3664,  '初級', '包裹過狗排泄物之報紙應如何處理？', '自行焚燒', '當紙類資源回收處理',  '視為一般垃圾處理', '與一般垃圾分開，交給清潔隊員', 3),
(3665,  '中級', '下列何者為廢棄物焚化法之優點？',  '所需之土地面積較少',  '操作維持費低', '設備成本低',  '不需去除爆炸性罐裝物', 1),
(3666,  '高級', '下列哪個國際公約的內容，是在協商減少有害廢棄物的產生，並避免跨國運送時造成的環境污染？',  '巴塞爾公約',  '斯德哥爾摩公約',  '聯合國海洋法公約', '華盛頓公約',  1),
(3667,  '初級', '二手菸是一種空氣污染，會危害到下列何者的健康？',  '只對12歲以下孩童有影響', '只對孕婦比較有影響',  '全民皆有影響', '只有65歲以上之民眾須避免吸到二手菸', 3),
(3668,  '高級', '下列何者是全球因食物，而引發疾病不斷增加的原因？', '全球食物鍊',  '快速都市化',  '外食增加', '以上皆是', 4),
(3669,  '中級', '下列哪一個「不是」吸菸對身體的影響？', '肺癌', '肺氣腫',  '心臟病',  '登革熱',  4),
(3670,  '中級', '以下列哪一種方式處理飲用水可達到最好的殺菌效果？', '煮沸', '放置陽光下曝曬',  '靜置沈澱', '曝氣', 1),
(3671,  '初級', '依照道路交通管理處罰條例，下列何者是臺灣小客車附載幼童的正確作法？',  '幼童乘車時應當坐在進口的安全椅上', '為坐在副駕駛座的兒童繫上安全帶',  '安置幼童於安全椅', '幼童由成人抱在膝上時，應當繫好安全帶，並面朝成人，作保護之用途',  3),
(3672,  '中級', '臺灣民國70年後，近30年來食品中毒的主要原因是甚麼？',  '化學物質', '塑化劑',  '細菌', '天然毒',  3),
(3673,  '中高級',  '有關愛滋病，與人類免疫缺乏病毒(HIV)之敘述，以下何者「錯誤」？',  '人類免疫缺乏病毒感染免疫系統的細胞，破壞或減損細胞功能',  '愛滋病是一種經由性行為、血液或母子垂直傳染的疾病', '愛滋病簡稱為AIDS', '癌症是人類免疫缺乏病毒感染者的主要死因',  4),
(3674,  '初級', '兒童常見的受傷原因是？',  '道路交通撞擊', '跌倒', '燙傷', '以上皆是', 4),
(3675,  '初級', '為什麼兒童較成人更容易受傷，以下何者「錯誤」？',  '在馬路上兒童太小，不容易被汽車駕駛看到',  '兒童尚未學到保護自己安全', '兒童頭腦反應靈敏', '兒童身體小容易卡在洞裡或裂縫', 3),
(3676,  '中級', '喝酒的酒精主要透過人體哪一個器官代謝？',  '腦',  '肝',  '骨骼', '皮膚', 2),
(3677,  '高級', '以高雄地區供應範圍而言，在自來水處理過程中何處水質最易受環境影響？',  '取水處',  '導水處',  '淨水處',  '輸(配)水處', 1),
(3678,  '高級', '自來水用戶與自來水公司之間權利義務劃分係以何處為界？', '水塔入水端',  '住戶內出水端', '水錶', '水塔出水端',  3),
(3679,  '高級', '自來水用戶與自來水公司之間權利義務劃分係以何處為界？', '低於5倍', '低於10倍',  '約相等',  '高於2倍以上', 4),
(3680,  '高級', '下列哪一項是使用逆滲透技術的家用淨水器的缺點？',  '耗電量',  '噪音大',  '廢水多',  '淨水功能差',  3),
(3681,  '中高級',  '哪一種致病菌出現可以判定水質遭糞便污染？', '真菌', '絲狀菌',  '霉菌', '大腸桿菌群',  4),
(3682,  '初級', '在飲用水水源水質保護區或飲用水取水口一定距離內之地區，「不能」進行下列何種活動？\n', '監測水質', '興建高爾夫球場',  '進行田野調查', '賞鳥', 2),
(3683,  '高級', '下列何者是生活廢水的來源？',  '農作物生產中使用的氮肥',  '廚房排出的洗滌水', '煉鋼過程的冷卻水', '開採礦坑的廢水',  2),
(3684,  '中高級',  '供水系統維持一定自由有效餘氯的目的為何？', '提高有機物濃度',  '穩定水質的硬度和色度', '增加自來水的口感', '可預防細菌的滋生', 4),
(3685,  '高級', '一般飲用水若儲放超過幾天以上，則較「不適合」直接飲用？',  '2天', '4天', '6天', '8天', 1),
(3686,  '中級', '用自來水養魚，為什麼容易造成魚兒死亡？',  '自來水中沒有氧氣', '自來水中沒有養分', '自來水中含有餘氯', '自來水中含有臭氧', 3),
(3687,  '高級', '鉛是如何進入飲水中？', '去除有機物時的副產物', '消毒時添加',  '由含鉛配水管線及其配件溶出',  '由空氣中溶入水中', 3),
(3688,  '中級', '《飲用水管理條例》所稱飲用水之種類如何？', '自來水',  '社區自設公共給水設備供應之水\n', '經連續供水固定設備處理後供應之水\n', '以上皆是', 4),
(3689,  '高級', '飲用水水質處理所使用之藥劑須遵循之規定如何？', '可向任何廠商訂購', '可用自行生產之藥劑',  '以中央主管機關公告者為限', '以地方衛生局公告為限', 3),
(3690,  '高級', '下列何者是給水工程應達成的目標？', '水量充足', '水質良好', '水壓適當', '以上皆是', 4),
(3691,  '高級', '自來水設施標準規定河川表面水之安全出水量以幾年發生一次枯水量為主？',  '10年',  '20年',  '30年',  '40年',  2),
(3692,  '高級', '水中採用曝氣的目的為何？', '去除水中氣體', '增加水中溶氧量',  '提高反應效率', '以上皆是', 4),
(3693,  '高級', '下列何者是將水中固體物移除的最簡易方法？', '過濾', '離子交換法',  '加熱法',  '蒸發法',  1),
(3694,  '初級', '以下何者為減少清潔劑使用的益處？', '節省家庭開支', '維護環境', '減少污水廠處理費', '以上皆是', 4),
(3695,  '高級', '飲用水的殺菌效果與溫度之關係為何？',  '溫度越高殺菌效果越好', '溫度越低殺菌效果越好', '溫度越高殺菌效果越低', '溫度低於零度，完全沒有殺菌效果',  1),
(3696,  '高級', '當水中氨氮濃度偏高時，水體水質可能處於甚麼狀況？', '高分子量脂肪酸過高',  '沒有影響', '色度偏低', '受到污染', 4),
(3697,  '高級', '飲用水水源標準係由何機關訂定？',  '衛生局',  '自來水公司',  '水利署',  '環保署',  4),
(3698,  '高級', '規劃長期國家用水量之主管機關為何？',  '衛生局',  '自來水公司',  '水利署',  '環保局',  3),
(3699,  '初級', '山泉水及井水為何「不適合」直接飲用？', '水源較無安全保障', '水中可能有超標之大腸桿菌數',  '水源可能遭受人為污染', '以上皆是', 4),
(3700,  '初級', '下列何種活動「不適」於水源區中進行？', '開墾', '傾倒污染物',  '工業開發', '以上皆是', 4),
(3701,  '中級', '飲用水中含過量硝酸鹽氮會對人體造成影響，下列何者正確？',  '補充身體養分，幫助成長',  '與紅血球結合提高血液攜氧效率', '提高新陳代謝能力', '降低血紅素攜氧效率，導致缺氧', 4),
(3702,  '中高級',  '在水龍頭上使用外接橡皮水管時應注意何種情況發生？', '水管無固定，使水管脫落浪費水資源', '水管浸泡於清潔用水中導致水塔水源受污染',  '水管長時間日曬導致脆化',  '以上皆是', 4),
(3703,  '中級', '關於入住新屋時需讓水放流一陣子的原因，下列何者正確？', '沖洗管中變質水源', '確保水流速的穩定', '入厝習俗', '以上皆是', 1),
(3704,  '中高級',  '飲用水水質標準中，下列何者為影響健康之物質？', '重金屬',  '三鹵甲烷', '農藥', '以上皆是', 4),
(3705,  '高級', '關於飲用水水質標準中物理性之標準項目，下列何者「錯誤」？', '臭度', '濁度', '色度', '硬度', 4),
(3706,  '中級', '豪雨颱風過後，下列何者「不是」飲用水的正確觀念？', '濁度偏高', '期間最好使用儲備水',  '淨水廠將添加更多餘氯', '大雨稀釋飲水將更為安全',  4),
(3707,  '高級', '飲用水中大腸桿菌的標準值是每毫升多少CFU？', '6',  '0.6',  '0.06', '60', 3),
(3708,  '高級', '飲用水檢驗測定機構應向哪個機關申請許可，才可以進行檢驗測定？', '地方環保局',  '鄉、鎮、市公所',  '地方政府', '環保署',  4),
(3709,  '中高級',  '市售瓶裝礦泉水中含有下列何種物質？',  '礦物鹽',  '微量元素', 'CO2',  '以上皆是', 4),
(3710,  '初級', '合格的飲用水應呈現什麼狀態？', '無色', '有香氣',  '冒泡', '濃稠', 1),
(3711,  '中高級',  '一般家庭在家中煮飲用水，當水沸騰時會讓水再煮3至5分鐘，這個動作能消除大量的何種物質？',  '重金屬',  '二氧化碳', '三鹵甲烷', '塑化劑',  3),
(3712,  '中級', '下列哪種物質可能於電子發票、提款機提款明細表等感熱紙上被檢出？',  '雙酚A',  '壬基酚',  'DDT',  '五氯酚',  1),
(3713,  '中級', '根據《公害糾紛處理法》，下列何者被認定為「公害」？',  '噪音', '地盤下陷', '空氣污染', '以上皆是', 4),
(3714,  '中高級',  '下列何項開發行為需進行環境影響評估？', '開闢臺中市東勢林場遊樂區', '臺大體育館舉辦大型演唱會', '舉辦馬拉松國際競賽',  '在社區公園舉辦大型園遊會', 1),
(3715,  '中級', '公司將大量固體廢棄物放置於海岸邊時，應對環境做出下列何種「主要」監測計畫？',  '河川水質及地下水水質監測', '空氣品質監測', '是否產生臭味', '是否產生毒氣', 1),
(3716,  '高級', '開發案之排放水會對附近河川水質造成影響時，下列哪個選項「不是」開發單位應有的因應策略及評估？', '將廢水處理至可排放標準',  '在經濟效益許可下,提出完成零排放計畫', '在緊急狀況發生時,將廢水以專車委外做廢水處理', '在緊急狀況發生時,將廢水偷排至其他流域',  4),
(3717,  '高級', '為推動節能減碳，政府補助校園的?位電錶可發揮?麼功能？',  '數據與價位',  '使用與分布',  '使用與價位',  '美觀與數據',  2),
(3718,  '高級', '土壤受到污染的描述，下列何者正確？',  '土壤受污染不會影響土壤微生物活性與分布',  '土壤受到污染後，農作物生產力可能會降低',  '土壤受污染不會影響附近河川的水質', '土壤受污染不會影響附近地下水的水質',  2),
(3719,  '中級', '中國大陸自2013年3月31日起，陸續公布「H7N9」病例，其中「H7N9」是什麼？', '一種流感病毒', '一種流感藥物', '一種流感症狀', '一種流感細菌', 1),
(3720,  '初級', '不要吃發霉的東西，是為了要防止吃進下列哪種黴菌所產生的毒素？', '汞',  '多氯聯苯', '甲醇', '黃麴毒素', 4),
(3721,  '中級', '環境中的重金屬污染，是藉由下列何項作用加深對人體的傷害？', '溫室效應', '熱島效應', '生物放大', '沉積效應', 3),
(3722,  '高級', '工作人員若常曝露於電池室且無做好防護措施，則易接觸下列何種物質而導致罹患鼻咽癌？', '硫酸酸霧', '多環芳香烴(ㄊㄧㄥ)化合物',  '多氯聯苯', '氨氣', 1),
(3723,  '高級', '根據聯合國轄下的國際癌症研究所(IARC)分類，致癌物總共可以分為幾個級別？', '2級', '4級', '6級', '8級', 2),
(3724,  '高級', '下列何者於2010年正式成為第一個立法禁止嬰兒奶瓶中含有雙酚Ａ的國家？',  '加拿大',  '美國', '日本', '臺灣', 1),
(3725,  '高級', '有機污染物二氯乙烯比水還重，若不當排放於臺灣中北部的礫石臺地時，可能會污染至多深？',  '表土30公分', '表土50公分', '所有土壤厚度', '礫石層以下',  4),
(3726,  '初級', '地下水污染與國民的生活有何種關係？',  '提高生育率',  '促進經濟發展', '危害國民健康', '提高國民生活品質', 3),
(3727,  '中高級',  '影響污染物在土壤剖面中移動與分布之主要特性為何？', '土壤pH值',  '土壤質地(砂粒與黏粒組成不同)',  '土壤無機物含量',  '土壤顏色', 2),
(3728,  '初級', '臺灣主要的土壤污染來源有哪些？',  '工業廢水', '農業及化學肥料',  '都市污水與家庭垃圾',  '以上皆是', 4),
(3729,  '高級', '下列何者行業不必繳納土壤及地下水污染整治基金？',  '石油業及加油站',  '鋼鐵業',  '化工廠及電鍍廠',  '五金行業', 4),
(3730,  '中級', '關於地下水的水質特性，下列何者為「錯誤」？',  '含鹽量較高',  '密度較高', '溫差較小', '易受污染', 4),
(3731,  '初級', '如何預防山坡地土壤流失？', '加強水土保持', '多翻土',  '種植檳榔', '建房子',  1),
(3732,  '初級', '有關地下水及土壤污染的敘述，下列何者正確？',  '表層土壤的污染不會造成地下水受到污染', '土壤可以保護地下水不受污染',  '地下水不會遭受到污染', '地下水污染整治需要龐大的金錢與時間',  4),
(3733,  '初級', '有關地下水的敘述，下列何者為「錯誤」？',  '地下水的形成需經過長時間的積蓄才能達到人類可探取使用的水量',  '臺灣地下水很充足，可以無限制抽取使用', '家庭廢污水處理不當，可能滲入地下造成地下水污染',  '工業生產過程中所產生的工業製程廢水會造成地下水污染',  2),
(3734,  '高級', '土壤構造中不同土壤孔隙可協助保持水分及讓水分穿透，以補注地下水水量，其土壤孔隙百分比約多少？', '10%-20%',  '30%-50%',  '<10%', '60%-70%',  2),
(3735,  '初級', '何謂地下水？', '下雨後，留存於地面上的水通稱為地下水', '水溝裡的水通稱為地下水',  '凡是存在於地面下的水通稱為地下水', '湖中的水通稱為地下水', 3),
(3736,  '初級', '下列有關水土保持的敘述，何者正確？',  '肥料可以使作物長的又大又漂亮，因此用愈多愈好', '樹木可以使土壤中的水分不易流失，因此要多種檳榔樹', '湖泊優養化代表湖泊水中養分豐富，是魚、蝦生長的優良環境',  '超抽地下水會使海水倒灌和地層下陷，造成難以挽回的傷害', 4),
(3737,  '中級', '為什麼要回收沒有電力的廢電池？',  '可以製成肥料', '廢電池價格很昂貴', '避免廢電池污染土壤',  '廢電池可以拿來蓋房子', 3),
(3738,  '高級', '下列有關土壤功能的描述，何者「錯誤」？',  '生產農作物',  '無法將污染物分解', '可儲存水及淨化水', '土壤具有生命力',  2),
(3739,  '初級', '當發現下列哪一個情形時，可以打免費報案電話給環保單位？',  '隔壁工地車輛出入頻繁', '有人在兜售不明藥物',  '同學被外校人士欺負',  '工廠排放異味廢水', 4),
(3740,  '初級', '下列何者為生活用水的主要來源？',  '河川水',  '水庫水',  '地下水',  '以上皆非', 2),
(3741,  '高級', '土壤中的戴奧辛污染，主要經過何種途徑影響人體的健康？', '灌溉水污染',  '空氣擴散', '食物鏈系統',  '土壤流失', 3),
(3742,  '中級', '有關地下水的敘述，下列何者正確？', '地下水較容易被污染',  '地下水溫差較小',  '地下水含鹽分較低', '以上皆是', 2),
(3743,  '中高級',  '下列何者為工業用水的主要來源？',  '河川水',  '水庫水',  '地下水',  '以上皆非', 3),
(3744,  '中高級',  '下列何者為農業用水的主要來源？',  '河川水',  '水庫水',  '地下水',  '以上皆非', 1),
(3745,  '中級', '下列何者「不是」地下水所具備的特性？', '簡便', '穩定', '價廉', '營養', 4),
(3746,  '中級', '下列何者狀況屬於地下水超抽？', '地下水抽水量「超越」天然補注量',  '地下水抽水量「低於」天然補注量',  '天然補注量「超越」降雨量', '地下水抽水量「低於」降雨量',  1),
(3747,  '中高級',  '下列何種方式是避免農田土壤污染最重要的策略？', '用化學藥劑處理被污染之土壤',  '嚴格控管工業廢水不要排入農田', '讓農作物吸收移除土壤污染物',  '把污染的土壤挖至別處丟棄', 2),
(3748,  '中級', '土壤中除了孕育著無窮的有機、無機物資源外，在生態系中還有何種重要的功能？', '促進國民健康', '增加土壤肥沃度',  '土壤中的微生物分解動植物遺體', '加速農作物生長',  3),
(3749,  '高級', '有關農田土壤受重金屬污染，下列哪個整治方法最普遍被使用？', '在受污染地區地表鋪設柏油加以覆蓋', '全面挖除被污染土壤搬到外地處理後再運回原地',  '透過水的淋溶、洗出等作用帶走或稀釋',  '以機器將表層污染土壤與下層未受污染土壤充分上下混合稀釋',  4),
(3750,  '中級', '關於土壤劣化的原因，下列何者為「錯誤」？', '高溫多雨氣候', '高密度耕作',  '酸雨', '一年一期農作', 4),
(3751,  '中高級',  '土壤整治方式採用生物堆法，在理想情況下，要多久時間才能完成？', '6個月?2年', '3年?4年',  '4年?5年',  '5年?6年',  1),
(3752,  '中高級',  '下列何者為土壤污染場址整治時應考慮之因素？',  '地下水位高低', '土壤性質', '整治經費', '以上皆是', 4),
(3753,  '中高級',  '下列何者是造成臺灣農田土壤污染的主要原因？',  '輸油管漏油造成污染',  '輸油管使用太久破裂',  '加油站漏油污染擴大',  '工廠廢水不當排放', 4),
(3754,  '中級', '下列何者為地下水高污染潛勢區？',  '百貨公司', '加油站',  '電影院',  '遊樂園',  2),
(3755,  '中級', '日本發生之痛痛病是因為灌溉水中含有什麼重金屬，導致人類食用此處生產稻米後產生病變？',  '鎘(Cd)',  '銫(Cs)',  '銅(Cu)',  '鉻(Cr)',  1),
(3756,  '高級', '土壤受到重金屬污染後大多集中於土壤多深的位置？',  '距表土20至30公分內',  '距表土30至50公分深',  '距表土50至70公分深',  '距表土70至100公分深', 1),
(3757,  '中高級',  '利用生物堆法處理受油品污染的土壤時，需控制某些條件，下列何者「不屬於」其控制條件？',  '含氧量',  'pH', '水分', '厚度', 4),
(3758,  '中高級',  '污染物在哪一種土壤剖面中，移動傳輸較快？', '壤土', '黏壤土',  '黏土', '砂土', 4),
(3759,  '中級', '造成地下水污染的原因，下列何者為「錯誤」？',  '受污染河川補注地下水', '刻意將工業廢水排入井中',  '加油站地下儲槽洩漏',  '地下水監測系統的設立', 4),
(3760,  '中高級',  '一般土壤中總孔隙百分比，大約為多少？', '20-30',  '30-40',  '40-50',  '60-70',  3),
(3761,  '高級', '環保署對於遭鉻、銅、鎳、鋅污染，且污染濃度較低之農地，採用何種處理方式？', '土壤酸洗法',  '熱處理法', '土壤翻土混合稀釋法',  '以上皆非', 3),
(3762,  '初級', '受到嚴重污染的土壤會對蚯蚓數量造成什麼影響？', '大量增加', '稍微減少', '大量減少或死亡',  '不會影響', 3),
(3763,  '初級', '生活化學品中，哪些物質不當使用可能造成土壤污染？', '汽油', '環境衛生用藥', '清潔劑',  '以上皆是', 4),
(3764,  '初級', '地下水抽至地面後，以下列何種用途使用比例最高？',  '農業灌溉', '洗車', '洗澡', '澆花', 1),
(3765,  '中高級',  '下列何種自然因素會導致土壤酸化？', '降雨量多', '海嘯', '森林大火', '火山爆發', 1),
(3766,  '高級', '土壤的質地通常會影響土壤之通氣與排水，一般粗質地土壤的特性為何？', '排水通氣好，但吸水性差',  '排水通氣差，吸水性亦差',  '排水通氣好，吸水性亦好',  '排水通氣差，但吸水性好',  1),
(3767,  '中級', '下列哪一項「不是」臺灣地區地層下陷的主因？',  '地層的變化運動',  '軟弱沖積層的自然壓實', '超抽地下水',  '農地過度開墾', 4),
(3768,  '初級', '如何可以預防土壤受到污染？',  '不要讓工廠廢水排入灌溉水系統', '讓家庭生活污水排入農田',  '把家庭垃圾倒入農田',  '大量使用環境衛生用藥', 1),
(3769,  '高級', '「地下水監測井」的完井紀錄表中需記錄地下水的物理化學項目，下列何者為「錯誤」？',  '濁度', '電導度',  '溫度', '蒸發速度', 4),
(3770,  '中高級',  '一般環境中，下列哪一種類型的土壤最肥沃？', '紅壤', '黑色土',  '黃壤', '紅棕壤',  2),
(3771,  '中高級',  '土壤整治方式中，生物堆法有些限制，下列何者為「錯誤」？',  '污染土壤經挖除後，需先將粒徑大於60mm的物質予以分離或處理', '不確定對含鹵素原子化合物之固相處理程序是否有效',  '添加大量的營養鹽或添加劑會明顯增加土壤的體積', '不需進行處理可行性試驗',  4),
(3772,  '中級', '下列對於土壤肥沃的描述何者正確？', '土壤很紅', '土壤很鬆', '提供作物生產需求養份', '土壤屬中性，不酸也不鹼',  3),
(3773,  '中高級',  '以好氧生物復育法處理有機物污染土壤，其氧氣供應劑通常使用的化合物「不包括」下列何者？', '空氣', '二氧化硫', '臭氧', '純氧', 2),
(3774,  '初級', '下列何者是造成臺灣西部沿海地層嚴重下陷的原因？',  '地殼板塊運動', '火山活動', '超抽地下水',  '地震', 3),
(3775,  '中高級',  '處理重金屬污染土壤的方法，下列何者為「錯誤」？',  '化學處理', '工程技術', '生物處理', '淋溶稀釋', 4),
(3776,  '中高級',  '過度開發地下水，易引起(甲)表土流失，土壤枯竭；(乙)如在海濱，易使地下水鹽化；(丙)加速地表植物枯死；(丁)地下水污染；(戊)地層下陷，以上哪些正確？', '甲乙丙',  '乙丙戊',  '甲丁戊',  '乙丁戊',  4),
(3777,  '中級', '生成土壤的風化過程，下列何者正確？',  '物理風化', '化學風化', '生物風化', '以上皆是', 4),
(3778,  '中高級',  '下列何者為土壤污染監測的目的？',  '提供土壤污染的定量數據，作為環保單位罰鍰之參考',  '提供土壤污染的定量數據，作為政府施政以及土地利用等之參考', '提供土壤污染的定量數據，給建築機構作為建設公司土地利用之參考', '提供土壤污染的定量數據，給農業單位作為耕作之參考', 2),
(3779,  '中高級',  '土壤依顆粒大小不同而分為砂、砏土、與黏土，而砂的顆粒直徑大小為何？',  '>2毫米', '2毫米-50微米', '50微米-2微米', '<2微米', 2),
(3780,  '高級', '我國土壤及地下水污染整治基金的徵收及運用，仿效美國的何種基金？',  '水污染防治基金',  '空氣污染防治基金', '噪音管制基金', '超級基金', 4),
(3781,  '中高級',  '土地被環保機關公告為污染管制區後，管制區內相關活動將會受到限制，除了下列何者例外？',  '開發行為', '建築物拆除',  '新建', '進行污染控制或整治相關作業',  4),
(3782,  '高級', '?用「排土客土法」處?受重?屬污染的土壤，主要優點為何？', '花費最少', '無二次污染',  '污染土不需處理',  '時程迅速', 4),
(3783,  '高級', '土壤中重金屬之全量分析，常用何種試劑來做消化之前處理？',  '王水', '硫酸', '硝酸', '鹽酸', 1),
(3784,  '高級', '依據我國土壤及地下水污染整治相關法規規範，底泥品質指標項目濃度高於下限值但低於上限值，依法應有何措施？',  '增加檢測頻率', '檢測生物體濃度',  '公告並追查污染源', '以上皆是', 1),
(3785,  '高級', '下列哪個介質「不受」土壤及地下水污染整治法之規範？',  '土壤', '底泥', '地下水',  '地表水',  4),
(3786,  '中高級',  '下列何者「不適合」作為農地重金屬污染之改善方法？', '土壤翻土混合稀釋法',  '酸洗法',  '客土法',  '自然衰減整治法',  4),
(3787,  '高級', '受重金屬污染之土壤的復育方法有哪些？', '客土與排土客土',  '土壤洗淨去除法',  '生物去除法',  '以上皆是', 4),
(3788,  '高級', '下列何者「不是」評估水庫水質優養程度「卡爾森指數」的水質參數？',  '葉綠素a', '透明度',  '總磷', '懸浮固體', 4),
(3789,  '中高級',  '我國《公害糾紛處理法》中所謂的「公害」，是指因下列何種因素所造成生存環境的破壞？', '天然因素', '人為因素', '經濟因素', '政治因素', 2),
(3790,  '高級', '依照《公害糾紛處理法》中所稱的公害糾紛，是指何種糾紛？',  '刑事糾紛', '民事糾紛', '國際糾紛', '天災糾紛', 2),
(3791,  '初級', '下列何者是《公害糾紛處理法》中所謂的「公害」？',  '惡臭', '空氣污染', '噪音', '以上皆是', 4),
(3792,  '中級', '當公害糾紛發生時，糾紛當事人可透過以下哪個單位處理糾紛事宜？', '公害糾紛裁決委員會',  '公害糾紛調處委員會',  '環保署督察總隊',  '行政院消費者保護會',  2),
(3793,  '中高級',  '公害糾紛發生後，如糾紛當事人經由直轄市、縣(市)調處委員會調處不成立時，可透過以下哪個單位進一步尋求損害賠償協助？',  '環保署基管會', '公害糾紛裁決委員會',  '行政院消費者保護會',  '公害糾紛督導處理小組', 2),
(3794,  '高級', '直轄巿、縣(巿)政府為了主動處理突發及緊急的公害糾紛事件，依法設有以下哪個單位？', '緊急公害糾紛調查小組', '公害糾紛緊急紓處小組', '公害糾紛督導處理小組', '公害糾紛裁決委員會',  2),
(3795,  '中高級',  '當公害發生後，由公害糾紛緊急紓處小組邀集各方所設置之「健康影響評估小組」，其主要專長包含以下何者？',  '非游離輻射',  '公共衛生', '水產養殖', '以上皆是', 2),
(3796,  '高級', '環保署得設立「公害糾紛督導處理小組」，協調有關機關研擬公害糾紛事件之處理方法及對策，依法召集人由以下何者兼任？',  '環保署副署長', '環保署署長',  '行政院副院長', '以上皆非', 2),
(3797,  '初級', '發現馬路邊沒有牌照的廢棄車輛時，應打電話給以下哪個單位？', '衛生局',  '環保局',  '交通局',  '社會局',  2),
(3798,  '中高級',  '民國97年大寮空污事件，經協調後大寮鄉公所與大發工業區廠商協進會所簽訂敦親睦鄰備忘錄主要內容為何？',  '補助國小學童營養午餐', '補助當地老人每月每年1000元養老津貼',  '賠償每戶5萬元',  '於社區定期舉辦說明會', 1),
(3799,  '中級', '一般環保署環境守護隊成員(非環保機關退休者)之訓練採以下何種方式辦理？',  '自由選課參加', '遠距教學線上測驗', '集中實地訓練', '以上皆可', 3),
(3800,  '初級', '退休之軍公教人員要如何加入環保署環境守護隊服務計畫？', '洽詢社會局',  '洽詢警政機關', '洽詢各級環保機關', '洽詢救國團',  3),
(3801,  '中級', '公害糾紛發生時，當事人可申請公害糾紛調處，過去調處不成立比例超過7成以上，其主要原因為何？',  '無法達成共識', '當事人一方連續二次不到場', '當事人明確表示拒絕調處',  '以上皆是', 4),
(3802,  '高級', '公害糾紛調處不成立之案件，可向公害糾紛裁決委員會申請損害賠償裁決，過去裁決委員會駁回裁決申請的主要原因為為何？',  '相對人財產遭受凍結',  '申請人舉證不實',  '無因果關係',  '申請人更換代表',  3),
(3803,  '中級', '下列何者「可能」是振動噪音公害的污染源？', '公車站牌', '圖書館',  '公園', '營建工地', 4),
(3804,  '初級', '某工業區排放異味造成附近國小、中師生身體不適送醫，其主要公害類型為何？',  '輻射', '惡臭', '空氣', '土壤地下水',  3),
(3805,  '中級', '如公害造成損害時，「責任鑑定」主要為了建立以下何種因果關係？', '何種污染物造成損害',  '評估危害程度', '造成損害之污染來源',  '以上皆是', 3),
(3806,  '中高級',  '公害發生後蒐證需要大量背景資料做為評估依據，以下何者是平時就需要持續建立、維護之背景資料？',  '許可證資料',  '環境監測背景', '物質安全資料表(MSDS)',  '以上皆是', 4),
(3807,  '初級', '依照獎勵民眾舉發污染案件實施要點規範，舉發污染案件獎金由以下哪的單位撥發？',  '環保署',  '環保局',  '環保署督察總隊',  '以上皆可', 1),
(3808,  '中級', '環保署蒐集並篩選出臺灣30個重大環境事件，將重要圖片及資料編輯成書，下列何者「不是」出版該書籍的用意？',  '完整留下事件紀錄', '掌握歷史事件的來龍去脈',  '促進環境污染', '提供民眾環境保護教育資料，了解各部門對解決污染的努力', 3),
(3809,  '中高級',  '1950年發生在日本富山縣的痛痛病，是重要的鎘中毒公害事件，在環保署公害糾紛處理資訊系統中可以查詢到哪些受體鎘中毒之鑑定資訊？(A)人體健康(B)農林作物(C)水產生物', 'AB', 'AC', 'BC', 'ABC',  2),
(3810,  '中級', '1956年發生在日本熊本縣水俁市的水俁病，是重要的汞中毒公害事件，在環保署公害糾紛處理資訊系統中可以查詢到何種受體汞中毒之鑑定資訊？', '水產生物', '農林作物', '人體健康', '以上皆是', 3),
(3811,  '初級', '為什麼在臺灣，民眾最常陳情的公害為噪音最多？', '地小人稠', '民眾習慣製造噪音', '陳情很方便',  '原因不詳', 1),
(3812,  '中級', '環保署「公害糾紛法律扶助計畫」主要協助民眾處理公害糾紛哪些事宜？', '法律文件撰擬', '調處等相關程序代理',  '民事訴訟案件代理', '以上皆是', 4),
(3813,  '初級', '當公害糾紛發生時，民眾可以向哪個單位提出法律扶助申請？',  '所在地縣(市)政府環保局', '所在地縣(市)政府社會局', '勞委會',  '所在地警察局', 1),
(3814,  '中級', '我國環境荷爾蒙主管機關依照「環境荷爾蒙管理計畫」內容，包含以下哪些單位？', '法務部',  '警政署',  '環保署',  '以上皆是', 3),
(3815,  '初級', '在臺灣的眾多座國家公園中，哪一座國家公園的設立是以維護史蹟和文化景觀為主？',  '玉山國家公園', '東沙環礁國家公園', '金門國家公園', '太魯閣國家公園',  3),
(3816,  '中級', '臺灣著名的「四草濕地」位於下?何處？', '東沙環礁國家公園', '臺江國家公園', '玉山國家公園', '雪霸國家公園', 2),
(3817,  '中級', '下列何者是國家級風景特定區？', '玉山', '阿里山',  '紗帽山',  '觀音山',  2),
(3818,  '初級', '某處國家公園珊瑚礁、海洋生態獨具特色、生物多樣性高、為南海及臺灣海洋資源之關鍵棲地，此地為下列何處？', '陽明山國家公園',  '玉山國家公園', '金門國家公園', '東沙環礁國家公園', 4),
(3819,  '中級', '依《文化資產保存法》規範，自然紀念物包括珍貴稀有植物及下列何項？', '保育類動物',  '微生物',  '稀奇器物', '特有礦物', 4),
(3820,  '中級', '添興窯保留了一座創窯至今已有50餘年歷史的蛇窯，其構造與功能均相當完整，此窯位於何處？',  '嘉義縣',  '南投縣',  '雲林縣',  '高雄市',  2),
(3821,  '中高級',  '下列何者為聯合國教科文組織所定義的世界遺產？', '經由聯合國各國統一審查通過，具歷史意義之遺產', '由遺產所有國捐獻予聯合國，且該遺產能夠代表其國家歷史地位之遺跡',  '聯合國教科文組織每年主動挑選認定具歷史意義之遺產', '由世界遺產公約締約國推薦,世界遺產委員會審議通過,登錄於世界遺產名單之遺產',  4),
(3822,  '中高級',  '《文化資產保存法》包含七大項，其中之一的自然地景所指為何？',  '流傳於各族群與地方之傳統技藝與藝能',  '與國民生活有關之傳統並有特殊文化意義之風俗',  '具保育自然價值之自然區域、地形、植物及礦物',  '蘊藏過去人類生活所遺留具歷史文化意義之遺物',  3),
(3823,  '高級', '世界遺產的登錄範圍包含核心地區及緩衝地區。緩衝地區設立的用意為何？',  '讓遺產看起來更大', '保護核心地區', '作為景觀用途', '防洪', 2),
(3824,  '初級', '小明參加世界水質監測日活動，利用簡易水質檢測包量測居家附近水質狀況良好的河水pH值，試管內的水最後會呈現何種顏色？',  '綠色', '紅色', '藍色', '透明', 1),
(3825,  '中高級',  '下列何者「不是」水庫水質優養化程度的指標項目？',  '總氮', '總磷', '葉綠素-a',  '透明度',  1),
(3826,  '初級', '下列哪些行為會造成水污染？',  '清理河面垃圾', '在河岸兩邊飼養家禽家畜',  '工廠妥善處理廢水', '家中減少使用清潔劑',  2),
(3827,  '初級', '河水混濁會造成何種影響？', '增加自來水處理難度',  '提供魚嗣料',  '增加上游沙石量',  '減少光害', 1),
(3828,  '初級', '小明和家人到河邊戲水，發現河中魚群種類眾多，但每類魚群數量平均，下列敘述何者最正確？', '河流水質清澈', '河面有垃圾漂浮',  '河面有異味產生',  '河水有泡沫產生',  1),
(3829,  '中級', '溼地可淨化污水，其功能類似人體哪一個器官？',  '心臟', '脾臟', '腎臟', '胃',  3),
(3830,  '初級', '池塘裡長滿綠色的藻類，可能是遭受何種污染所造成的？',  '空氣污染', '噪音污染', '水污染',  '土壤污染', 3),
(3831,  '中級', '小華發現平常使用的自來水量愈多，所產生的污水量亦愈多。下列關於小華自來水用量的敘述，何者較正確？', '小華每日的自來水用量約為50公升', '小華每日產生的污水量約為200公升',  '為降低河川遭受家庭污水污染，小華自來水的用量應再增加', '小華洗完澡的水不應再用來沖洗廁所，以免沖不乾淨',  2),
(3832,  '初級', '下列何種作為可提供民眾良好的視覺景觀及親水空間？', '河川整治復育', '河面髒亂點清除',  '河岸綠美化',  '以上皆是', 4),
(3833,  '初級', '小英體認家庭污水會污染河川的水質和生態，她應該如何做才能減少家庭污水量？', '洗米水再用來澆花', '盆浴代替淋浴', '淋浴取代盆浴', '以上皆是', 4),
(3834,  '初級', '河流遭受污染時，會呈現何種現象？', '水體顏色異常\n', '水體漂浮異物\n', '水體產生臭味\n', '以上皆是', 4),
(3835,  '初級', '小英參加世界水質監測日活動，在住家附近河川監測水質，她可能進行下列哪些項目的量測(A)溶氧(B)pH(C)水溫(D)透視度',  'ABC',  'BCD',  'ABCD', 'ABD',  3),
(3836,  '中級', '河川魚群暴斃的主要原因大多為水中溶氧不足，在下列何時段最容易發生魚群暴斃事件？',  '清晨', '中午', '傍晚', '半夜', 1),
(3837,  '中級', '桃園地區稻米曾經遭受下列何種重金屬污染，食用者可能引發痛痛病症狀？',  '鋁',  '鎘',  '鉛',  '銅',  2),
(3838,  '初級', '養殖魚池中常見有水車運轉，其最主要的功能為？', '防止魚群聚集', '增加魚飼料之溶解度',  '增加空氣中氧的傳輸量', '提升整體景觀', 3),
(3839,  '中級', '當高溫廢水排入水體後，下列敘述何者正確？', '增加水中溶氧', '減少細菌活動力',  '加速有機物分解',  '水的黏滯性增加',  3),
(3840,  '中級', '水中導電度過高會對灌溉後的農作物產生何種影響？',  '提高生產量',  '降低生產量',  '沒有影響', '不確定',  2),
(3841,  '中高級',  '生物需氧量是用來表示水中何種物質的濃度高低？', '重金屬',  '營養鹽',  '有機物',  '無機物',  3),
(3842,  '中級', '當地面蓄水池或地下水井與化糞池之距離太近時，易引起水質污染，危害使用者之健康，可用何種指標進行檢測？', '真菌', '懸浮固體', '溶氧量',  '大腸桿菌群',  4),
(3843,  '中級', '當河川水溫增加10℃時，以下何種現象較「不會」產生？', '有機物降解速率增加',  '水的密度增大', '微生物活動力增強', '溶氧量增加',  4),
(3844,  '中級', '水中有機物於有氧環境下被分解，是屬於下列何種情形？',  '硝化反應', '氧化反應', '光合作用', '還原作用', 2),
(3845,  '中級', '下列何者為水中有機物質被微生物好氧分解的最終產物？',  '葡萄糖',  '氨基酸',  '二氧化碳與水', '醋酸', 3),
(3846,  '中級', '下列何種重金屬會累積於人體內而導致疾病？', '汞',  '鉻',  '鉛',  '以上皆是', 4),
(3847,  '中高級',  '溫度會影響下列哪一種水的物理性質？(A)密度(B)黏度(C)蒸氣壓(D)表面張力。',  'ABC',  'BCD',  'ABCD', 'ABD',  3),
(3848,  '中高級',  '下列何者為造成水中溶氧量降低的主要原因？', '曝氣', '有機物質排入', '重金屬排入',  '降雨', 2),
(3849,  '中高級',  '加氯消毒常會產生致癌性之三鹵甲烷，主要係由氯與何種物質反應所產生？',  '無機物',  '重金屬',  '硝酸鹽',  '有機物',  4),
(3850,  '中高級',  '常食用含下列何種金屬的魚類會引發水俁病？', '鉻',  '銅',  '汞',  '鉛',  3),
(3851,  '中高級',  '湖泊中若有大量藻類滋生的情形，水中溶氧值會有何種變化？',  '上升', '下降', '不變', '先降低再升高', 2),
(3852,  '中級', '在每年的哪一天會舉行「世界水資源日」慶祝活動？',  '3月22日',  '10月20日', '6月5日', '3月29日',  1),
(3853,  '中高級',  '每一頭豬的排泄污染量約相當於多少人所產生之污染量？',  '40~50人', '10~20人', '4~6人', '8~10人',  3),
(3854,  '中高級',  '何種重金屬會取代人體的鈣質，使人體骨骼疼痛，產生「痛痛病」？', '砷',  '汞',  '銅',  '鎘',  4),
(3855,  '中高級',  '工業廢水污染整治計畫中較為可行的作為是？', '強制拆除違章工廠', '事業合理的放流水標準', '徵收水污染防治費', '以上皆是', 4),
(3856,  '高級', '在河川旁泥巴裡發現釣魚用的紅蟲，代表河川遭受何種程度的污染？', '未受污染', '稍受污染', '輕度污染', '嚴重污染', 4),
(3857,  '高級', '下列有關水質指標所引起的症狀，何者敘述「錯誤」？', '痛痛病-鎘',  '水俁病-汞',  '油症-油脂',  '綠牡蠣-銅',  3),
(3858,  '初級', '下列何種行為可能會造成水污染？',  '物質侵入', '生物侵入', '能量侵入', '以上皆是', 4),
(3859,  '高級', '河川污染指標(RPI)常被用來評估河川水質之優劣，當數值越高則表示河川的水質是？', '河川水質越好', '河川水質越差', '河川水質不受影響', '河川水質越穩定',  2),
(3860,  '高級', '湖泊在下列哪兩個季節易引起湖水翻轉而產生惡劣水質？',  '春夏', '秋冬', '春秋', '夏冬', 3),
(3861,  '中級', '下列何種做法「不會?妨礙水體正常用途？',  '廢水排入河川', '洗衣粉倒入河川中', '污水納入污水下水道',  '於河川上游建造水庫',  3),
(3862,  '高級', '底泥沉積高濃度的有機物會對水中溶氧產生何種影響？', '增加再曝氣能力',  '對水中溶氧無影響', '底部易產生厭氧作用',  '增加水中溶氧', 3),
(3863,  '中高級',  '下列所述之人工濕地水質淨化原理，何者「錯誤」？',  '接觸沉澱', '稀釋作用', '生物分解', '植物吸收', 2),
(3864,  '高級', '有機污染物排入河川後，會與水中溶氧轉化成不同形式的氮，下列敘述何者較正確？',  '水中有機氮和氨氮會逐漸被氧化成硝酸態氮',  '水中氨氮濃度高表示水體已被污染一段時間',  '硝酸態氮對魚類的毒性較氨氮高', '水中溶氧會逐漸升高',  1),
(3865,  '初級', '', '國際「世界水日」係指每年的哪一天？',  '', '3月22日',  '4月22日',  8),
(3866,  '初級', '早期痛痛病之發生，主要是食入哪一種金屬污染的食物？',  '錫',  '銀',  '鉻',  '鎘',  4),
(3867,  '初級', '典型的葉綠素a呈現下列何種顏色？', '紅色', '藍綠色',  '黃色', '棕色', 2),
(3868,  '高級', '藍嬰症主要是吃進下列何種污染物所導致？',  '碳酸鹽',  '硝酸鹽',  '磷酸鹽',  '硫酸鹽',  2),
(3869,  '中高級',  '湖泊水庫優養化之原因，主要是何種化學物質使藻類大量生長？', '氯鹽', '磷酸鹽',  '碳酸鹽',  '硫酸鹽',  2),
(3870,  '中高級',  '下列哪一種生物可以作為鑑定河川水質嚴重污染的指標？',  '紅蟲', '蜻蜓幼蟲', '豆娘幼蟲', '溪蝦', 1),
(3871,  '中高級',  '颱風過後，容易因為下列何項水質項目數值增加，導致限制自來水淨水廠的處理能力？', '濁度', '臭度', '總有機碳', '營養鹽',  1),
(3872,  '初級', '下列哪種方法可以節約用水？',  '用盆浴後的水刷洗廁所', '用洗米水、煮麵水、苦茶粉洗碗筷',  '採用二段式省水馬桶',  '以上皆是', 4),
(3873,  '中高級',  '下列何者為廢水處理的「化學作用」？',  '沉澱', '曝氣', '氧化', '過濾', 3),
(3874,  '初級', '下列何種物質為臺灣自來水消毒所使用之藥劑？',  '氟',  '氯',  '溴',  '碘',  2),
(3875,  '初級', '綠牡蠣事件與下列何種水質污染物有關？', '汞',  '銅',  '磷',  '鎘',  2),
(3876,  '高級', '長期誤食何種金屬，將導致皮膚與眼睛產生永久性藍灰色病變？', '鐵',  '汞',  '銀',  '銅',  3),
(3877,  '初級', '中性的水，酸鹼值(pH)約為多少？',  '2',  '4',  '7',  '9',  3),
(3878,  '中高級',  '下列何種方式對去除自來水中殘留的微量三鹵甲烷最為有效？',  '將自來水開蓋煮沸3-5分鐘',  '將自來水經過過濾處理', '將自來水經過逆滲透處理',  '自來水經過離子交換樹脂',  1),
(3879,  '中級', '河川水質採樣作業準則，應遵循下列何項方法？',  '河川、湖泊及水庫水質採樣通則」(NIEAW104.51C)',  '採樣單位自行決定', '專業分析實驗室採樣準則',  '以上皆非', 1),
(3880,  '中級', '我國陸域地面水體共分為幾類？', '4類', '5類', '8類', '10類',  2),
(3881,  '高級', '河川污染程度常以「河川污染程度指數」，Rive',  'rPollution', 'Index(簡稱RPI)」表示，當RPI積分值在3.1至6.0之間，代表河川之污染程度為何？', '未(稍)受污染',  '輕度污染', 0),
(3882,  '中級', '廢污水中的氨氮主要來自於下列何種污染源？', '動物排泄物或植物體分解',  '空氣溶入', '土壤滲透', '砂石場廢水排放',  1),
(3883,  '初級', '在水淨化和污水處理程序中，檢查何種水質分析可以了解水是否遭受糞便污染？',  '大腸桿菌', '葡萄糖',  '蛋白質',  '維生素',  1),
(3884,  '中高級',  '下列何者「不是」自來水處理的流程？',  '混凝', '沉澱', '消毒', '漂白', 4),
(3885,  '中級', '下列何者「不是」河川水質監測項目之一？',  '水溫', '酸鹼值',  '總三鹵甲烷',  '硝酸鹽氮', 3),
(3886,  '高級', '水質監測項目中，「總有機碳」的英文簡寫為以下何者？',  'CTSI', 'TOC',  'COD',  'BOD',  2),
(3887,  '中級', '河川自淨作用「不包括」下列哪一種作用？',  '沉澱', '氧化', '還原', '生物', 3),
(3888,  '中高級',  '水中真色色度的表示單位為何？', '無單位',  'mg/L', 'NTU',  '以上皆非', 1),
(3889,  '中高級',  '在水質檢測項目中，水中生化需氧量之分析，需於20°C環境下，進行為期幾日的微生物培養作業？',  '3日', '4日', '5日', '6日', 3),
(3890,  '中級', '水的生化需氧量(BOD)愈高，其所代表的意義為何？',  '水為硬水', '有機污染物多', '水質偏酸', '分解污染物時不需消耗太多氧',  2),
(3891,  '中級', '下列何者為臭度單位？', '初嗅數',  'mg/L', 'ppm',  'kg/m', 1),
(3892,  '高級', '下列何者「不是」鉻在環境中的價態？',  '+2', '+3', '+4', '+6', 3),
(3893,  '中級', '在檢測生化需氧量時常提到BOD5，其中「5」代表的意義為何？', '培養5天', '要加入5種化學藥品',  '要在攝氏5度下進行實驗',  '要加入5滴硫酸亞錳溶液',  1),
(3894,  '中級', '河川水質監測中，下列何者「不是」現場量測？',  '水溫', 'pH', '溶氧', '葉綠素a', 4),
(3895,  '中級', '當水體中含有哪兩種離子存在時，經加熱處理後容易造成水垢的發生？',  '鈉、氯',  '鈣、鎂',  '鋁、錳',  '錳、鈉',  2),
(3896,  '中高級',  '下列選項中何者「不是」河川污染指標(RPI)之監測項目？', '溶氧量',  '氨氮', '硫酸鹽',  '懸浮固體量',  3),
(3897,  '中高級',  '哪個污染物「不常」作為總量管制的指標？',  '生化需氧量',  '重金屬',  '總氮', '總磷', 2),
(3898,  '中高級',  '生化需氧量的英文縮寫為何？',  'BOR',  'TOC',  'COD',  'BOD',  4),
(3899,  '高級', '下列何者「不是」優養化對水質造成之影響？', 'BOD增加',  'pH值下降',  '引起臭味', '產生生物毒物', 2),
(3900,  '中高級',  '下列何者與生物累積作用有關？', '水溫', '溶氧量',  '氨氮', '重金屬',  4),
(3901,  '高級', '河川水質監測大腸桿菌分析，須使用下列何種方法？',  '多管醱酵法和濾膜法',  '免疫色層分析法',  '核酸檢驗技術', '蛋白質檢驗技術',  1),
(3902,  '高級', '針對水樣進行化學需氧量檢測時，常以下列哪一項化學物質作為氧化劑？', '重鉻酸鉀', '硫酸', '氯化汞',  '硫酸銨',  1),
(3903,  '高級', '我國公告之「放流水標準」中，針對廢水pH管制標準的範圍為何？', '3.5-5.5',  '5.5-7.5',  '6.5-7.5',  '6.0-9.0',  4),
(3904,  '高級', '下列哪一種水質指標存在於飲用水中時，會影響飲用水的「適飲性」？',  '硝酸鹽',  '氟鹽', '大腸菌',  '硬度', 4),
(3905,  '高級', '天然水所具備中和「酸」的能力稱之為何？',  '酸度', '鹼度', '酸鹼度',  '總硬度',  2),
(3906,  '中高級',  '鉻濃度過高具有毒性，下列哪一種氧化數狀態的鉻，具有較高的毒性？',  '零價鉻',  '\"+2鉻\"',  '\"+3鉻\"',  '\"+6鉻\"',  4),
(3907,  '高級', '有關河川的自淨作用，下列敘述何者「錯誤」？',  '有物理、化學、生物等作用', '再曝氣作用之強弱與溫度無關',  '地勢起伏越大，再曝氣效果越好', '耗氧作用與有機污染物有關', 2),
(3908,  '中高級',  '如何了解我國環境水體水質？',  '新聞報導', '全國環境水質監測資訊網',  '報章雜誌', '以上皆可', 4),
(3909,  '高級', '我國「水庫水質」之優劣，以下列哪一項指標來表示？', '河川污染程度指數(RPI)',  '水質指數(WQI)',  '卡爾森指數(CTSI)',  '水質飽和指數(SI)', 3),
(3910,  '高級', '下列哪一項因素「不是」將大腸桿菌濃度作為水質指標的主要原因？', '可作為水體受到排泄物污染的指標',  '大腸桿菌在水中的生存時間較致病菌長',  '水中檢測出大量大腸桿菌，表示水體在短時間內曾受人類或動物排泄物污染',  '大腸桿菌群為一群常見寄生於動物腸道的短桿狀細菌',  4),
(3911,  '高級', '《放流水標準》中規定「食品製造業」放流水中「懸浮固體」之最大限值為多少？', '50毫克/公升',  '40毫克/公升',  '30毫克/公升',  '20毫克/公升',  3),
(3912,  '高級', '下列哪一項「不是」屬於目前水體水質檢測之主要目的？',  '提供水體品質相關資訊', '瞭解水體環境現況', '保障民眾用水安全', '徵收水污染防治費', 4),
(3913,  '高級', '下列何者為自來水管制之加氯消毒副產物？',  '氯酚', '次氯酸納', '氯氟碳化合物', '三鹵甲烷', 4),
(3914,  '高級', '典型的葉綠素b呈現下列何種顏色？', '紅色', '黃綠色',  '藍色', '藍綠色',  2),
(3915,  '高級', '在一設有污下水道系統地區，從家庭排放出的生活污水，其處理流程為何？(A)河川(B)排水設施(C)衛生下水道(D)污水處理廠',  'BADC', 'CBDA', 'BCDA', 'CABD', 3),
(3916,  '中高級',  '可以避免飲用水從淨水廠配送至家戶使用前遭受病菌污染的化學物質為何？',  '餘氯', '鈣鹽', '氯鹽', '鈉鹽', 1),
(3917,  '高級', '下列何者並「不是」我國《地面水體分類及水質標準》之指標項目？', '溶氧量',  '生化需氧量',  '懸浮固體', '總有機碳', 4),
(3918,  '中高級',  '在高美溼地保護區內，下列哪一種行為是被禁止的？',  '在永續利用區踏浪', '在海堤上觀賞落日', '參加志工生態解說', '在草澤中捕捉蝦蟹', 4),
(3919,  '初級', '春夏季是許多野生動物繁殖的季節，如果您撿到鳥寶寶應該怎麼做才是正確的？',  '若撿到的是雛鳥，可在拾獲處附近尋找有無鳥巢，試著將雛鳥送回',  '若撿到的是幼鳥，可將鳥移到安全處，放在拾獲處附近高處棲地，並等候親鳥自己來帶回',  '聯絡野生動物急救站',  '以上皆是', 4),
(3920,  '中高級',  '陽明山國家公園在道路下方興建的地下道路涵洞的目的為何？',  '避免動物行走在道路上造成路面損壞', '提供動物可以遮風避雨的棲所',  '加強道路排水', '避免動物穿越道路遭車輛撞擊造成傷亡',  4),
(3921,  '初級', '過去大安森林公園曾經捕捉到鱷魚。推測鱷魚出現的來源為何？', '公園內原有的生物', '遭民眾棄養的寵物', '政府引入用來增加公園內生物多樣性', '學術單位進行的保育研究',  2),
(3922,  '初級', '下列對於自然資源保育的?述哪一項是「錯誤」的？',  '自然資源依其形成的特徵和被人類利用時間的長短，可分為有限資源及無限資源兩類',  '無限的自然資源是指用之不竭的資源，如太陽能、潮汐能、風能、海水等', '有限的自然資源中，一部分是可更新的，如水、土壤、動物、植物等，故不需要特別珍惜',  '有限的自然資源中，一部分是不可更新的，如泥炭、煤、石油、各種礦物等，在地球的存量有限，故應合理的利用', 3),
(3923,  '中級', '臺灣位處熱帶、亞熱帶，面積雖小但生態環境多樣化，全島面積中，佔比例最多是哪一種？', '平原', '丘陵', '臺地', '森林', 4),
(3924,  '初級', '下列何者「不屬於」空氣污染物？',  '火山灰',  '沙塵暴',  '汽車廢氣', '芬多精',  4),
(3925,  '初級', '下列有關能源敘述何者正確？',  '化石燃料為可再生能源', '核燃料為不可再生能源', '太陽能為不可再生能源', '地熱為不可再生能源',  2),
(3926,  '中級', '一般來說，下列何者生態系的生物多樣性最高？',  '河川', '水庫', '熱帶雨林', '湖泊', 3),
(3927,  '中級', '外來種互花米草，主要影響哪一類型的生態系？',  '森林生態系',  '高山草原生態系',  '海岸及河口潮間帶灘地', '河川上游的溪流生態系', 3),
(3928,  '中級', '全臺共計5處保育類野生動物收容中心，「不包括」下列哪個單位？', '國?屏東科技大學', '新竹市立動物園',  '國?海洋生物博物?',  '高雄市立萬壽山動物園', 2),
(3929,  '中級', '下列哪一項行為有助於山坡地的水土保持？',  '嚴禁山林持續開發，並適當獎勵並輔導私有地造林', '大量開築山區道?以便利交通運輸',  '開墾坡地來種植蔬菜',  '坡地栽種檳榔或?樹',  1),
(3930,  '中級', '下列關於華盛頓公約的?述何者是「錯誤」的？',  '華盛頓公約於1973年6月21日於美國華府簽署',  '華盛頓公約之全名為「瀕臨絕種野生動植物國際貿易公約」，縮寫為CITES',  '華盛頓公約目的在於以管理野生動植物之國際貿易', '我國並非華盛頓公約的締約國，故不必受到公約的限制', 4),
(3931,  '中級', '對於互花米草的?述下列何者為正確的？', '因為互花米草具有穩固沙地的功能，故適合大面積種殖來提高水土保持',  '互花米草雖生長快速，但臺灣氣候與原產地不同，故不易擴散',  '互花米草地下根莖及根系生長綿密，導致底棲動物等種類和數量下降', '互花米草是臺灣特有種', 3),
(3932,  '中級', '下列何者「不是」造成海洋污染的原因？', '海底火山爆發產生污氣體及岩漿', '由工廠產生的污染隨氣流及降兩進入海洋', '船舶產生的油污流入海中',  '核電廠所排放冷卻水中的熱能',  1),
(3933,  '中級', '漁業署推動「鯊魚鰭不離身」之漁船作業規範的目的為何？', '鯊魚為海洋生態系中頂端掠食者，能維護海洋食物鏈的自然平衡，在海洋中是不可或缺的重要角色，因此需要保護', '國際對鯊魚資源保育議題已高度重視，若無有效之鯊魚保育管理措施，有可能導致全面禁捕鯊魚之危機',  '洗刷國際上對我國濫捕鯊魚之污名',  '以上皆是', 4),
(3934,  '中高級',  '高美溼地近年來受到下列哪一種外來種入侵，對原生的雲林莞(ㄍㄨㄢˇ)草草澤造成嚴重威脅？',  '銀合歡',  '互花米草', '美國螯(ㄠˊ)蝦', '小花蔓澤蘭',  2),
(3935,  '中高級',  '下列哪一個選項「不是」目前造成國寶魚櫻花鉤吻鮭瀕臨滅絕的原因？',  '外來種入侵造成威脅',  '河川攔砂壩阻隔鮭魚的分布', '颱風帶來的豪雨引發的洪水', '農業開發造成棲地的污染與破壞', 1),
(3936,  '中高級',  '臺灣黑熊於1989年依《文化資產保存法》被列為瀕臨絕種的動物。下列關於臺灣黑熊的?述，哪一項是正確的？',  '臺灣黑熊並非在華盛頓公約(CITES)附錄Ⅰ的保育類動物，故可以在國際間進行買賣', '野外的臺灣黑熊不可以獵殺，原住民在進行傳統祭典時不在此限', '臺灣黑熊依法不得騷擾、虐待、獵捕、宰殺或為其他利用但基於學術研究或教育目的，經中央主管機關許可者則不在此限',  '以上皆是', 3),
(3937,  '中高級',  '紅火蟻入侵對臺灣生態潛在的影響為何？', '攻擊地棲性動物，如小型哺乳動物等', '搬運及取食植物的種子影響植物群聚組成', '與原生的螞蟻競爭，造成原生螞蟻的滅絕', '以上皆是', 4),
(3938,  '中高級',  '人工漁礁對於增加海洋資源的功能，下列的?述何者「錯誤」？', '增加沿岸海域漁獲量',  '增加休閒性潛水及潛水艇觀光景點',  '礁體可能釋放出化學物質',  '保護海底魚類棲息環境', 3),
(3939,  '中高級',  '下列何者「不是」移地保育的做法之一？', '設立動物收容中心', '讓動物自行選擇想居住的領域',  '建立植物種子庫',  '將梅花鹿族群遷移至墾丁社頂復育區', 2),
(3940,  '中高級',  '在海床上廢棄的漁網對於珊瑚礁有何影響？',  '提供基質增加珊瑚礁成長的速率', '增加魚類的棲地，提高生物多樣性',  '由於漁網的覆蓋將使珊瑚無法接受足夠的陽光而死亡',  '降低珊瑚受到海洋生物活動的破壞',  3),
(3941,  '中高級',  '環保署近年來推動所謂「生態治河」，其主要做法為何？',  '進行河川生態調查', '建置河川生物指標，利用生物指標來評估河川水質', '推動以自然淨化工程來整治河川污染', '以上皆是', 4),
(3942,  '高級', '近年來入侵臺灣與金門多處海岸及河口灘地的外來種「互花米草」，因外形與下列何種植物相似而常被誤認？', '雲林莞草', '鹽地鼠尾粟',  '水筆仔',  '蘆葦', 4),
(3943,  '高級', '自然保護區的規劃原則，下列何者是正確的？', '總面積相同時，多個小的保護區會比一個大的保護區為佳',  '相鄰的保護區間有廊道相連通較佳',  '保護區的形狀以有較長邊緣的不規則的形狀較佳',  '保護區之間隔離的距離愈遠愈好', 2),
(3944,  '高級', '近年來由於人類活動造成環境的破壞與污染，引起全球氣候變化，對自然保育產生的影響為何？', '海平面上升造成海岸及溼地面積減少，使棲息在這些棲地的物種消失', '海水溫度上升造成珊瑚的白化，會減少活珊瑚覆蓋的面積，導致生物多樣性下降',  '極端氣候發生頻率增加，造成物種的滅絕', '以上皆是', 4),
(3945,  '高級', '棲地破碎化對於物種的影響為何？',  '使物種生存的棲地面積變大', '使族群間隔離的程度減少',  '影響族群間基因的交流，容易造成基因多樣性下降', '以上皆是', 3),
(3946,  '高級', '印尼大面積砍伐及焚燒雨林以種植棕櫚，對生態產生的效應為何？',  '造成許多紅毛猩猩喪失棲所', '降低生物多樣性',  '增加溫室效應', '以上皆是', 4),
(3947,  '高級', '下列空氣污染物質中，何者為二次污染物？',  '二氧化硫', '臭氧', '一氧化碳', '以上皆是', 2),
(3948,  '高級', '?務局於民國89?完成?「中央山脈保育廊道」的建置作業，其目的為何？', '增加觀光遊憩的景點以提高國民旅遊的活動',  '維護臺灣森林的完整性，供後代子孫開發利用', '?接中央山脈地區的高山?地及各類保護(?)區', '以上皆是', 3),
(3949,  '高級', '「愛知目標」(Aichi', 'Targets)，其主要推動內容為何？',  '溫室氣體減量', '生物多樣性',  '毒化物質管制', 0),
(3950,  '中高級',  '推動社區林業等民眾參與計畫的目的是？', '讓企業可獲得發展機會', '在社區內伐林', '促進林業私有化',  '讓民眾與政府共同分擔自然保育之責任',  4),
(3951,  '中級', '由部落保護山林及水土資源，並由原住民協助造林和護林，可達成以下什麼目標？', '全面開發森林資源和發展部落經濟',  '引進國外的造林技術',  '森林資源共管共享', '捨棄傳統智慧，鼓勵發展企業化', 3),
(3952,  '中高級',  '哪一項「不是」目前生物多樣性流失的威脅因子？', '人為擾動過度利用', '自然演替', '外來物種入侵', '生態系劣化、沙漠化',  2),
(3953,  '中高級',  '在臺灣，下列哪一種作法符合餐飲業實施節能減碳？',  '採購高山種植的蔬果',  '採購當地蔬果', '採購最便宜的的蔬果',  '採購自國外進口的蔬果', 2),
(3954,  '初級', '以下哪一種購買方式最符合低碳生活的原則？', '購買舶來品',  '使用國際名牌的商品',  '購買本地生產的商品',  '購買名牌包',  3),
(3955,  '中級', '下列何者是開車省油的好方法？', '冬天得常注意是否因為天冷而胎壓不足',  '天氣很熱，在車上，引擎怠速來吹冷氣',  '為了早點到達好省油，頻頻開快車與?車', '放置大量雜物在車上便於取用，以減少開車',  1),
(3956,  '高級', '我國建築相關產業之二氧化碳排放比例，約佔全國總排放量28.8%，下列哪一項耗能最大？', '建材生產', '營建運輸', '住宅使用', '商業使用', 3),
(3957,  '中高級',  '閩南式建築冬暖夏涼，下列哪一個敘述說明了閩南式建築的節能效果？',  '', '牆壁以木頭為主要建材', '朝向東或西',  '從日本進口特有的花崗石建造',  0),
(3958,  '高級', '符合綠建築概念的房屋，應該如何兼顧基地保水？', '鋪設水泥', '掘取地下水',  '加蓋小涼亭',  '利用土地涵養水分', 4),
(3959,  '高級', '蓋房子是很耗能的，常常重蓋房子不符合節能減碳的精神。在臺灣住宅的平均壽命約為多少年？', '20', '40', '60', '80', 2),
(3960,  '高級', '以40年期作基準，以下哪一種植物的二氧化碳固定量（kg-CO2/m2）最高？', '喬木', '灌木', '多年生蔓藤',  '生態複層', 4),
(3961,  '中高級',  '永續發展是建構在哪三大基礎之上？', '環境保護、經濟發展及社會公義', '環境開發、經濟利益及生技科學', '環境技術、經濟指數及人均收入', '環境保護、社會競爭力、人均收入',  1),
(3962,  '中高級',  '低碳永續的生活常提到周遭環境的綠美化。以下哪一種作法是合理的綠化方式？',  '高爾夫球場青一色的人工草坪',  '三成以上的綠地採多層次的生態複層綠化', '家裡庭院種植整片外來品種的花草',  '公園整齊的草花花圃與圖案', 2),
(3963,  '中級', '下列何種購買冷氣的原則，會造成超量的耗電量？', '買大一號的冷氣機可以達到快速冷房的效果',  '使用變頻的冷暖氣機',  '先作好外牆的絕熱，與氣流分布的設計',  '使用小型的冷氣機，低轉數下，提早運轉也可以舒適一整天', 4),
(3964,  '中高級',  '下列何者「不是」節能的居家設計需求？', '開窗部位儘量設置外遮陽或陽臺', '大開窗面儘量避免設置在東西向', '不要採用LOW-E玻璃',  '每個臥室至少要有四分之一以上的開窗面', 3),
(3965,  '高級', '下列何種植栽方式，其單位面積二氧化碳固定量最小?', '喬木', '灌木', '自然野草地',  '生態複層', 3),
(3966,  '中級', '日常耗能以空調與照明用電佔最大比例。一般而言，哪一種燈具的耗電量最高？',  '鎢絲燈泡', '日光燈',  'LED燈', '省電燈泡', 1),
(3967,  '中高級',  '建築節能設計中，哪一項的節能成效較大？',  '外殼節能', '建築物外的綠化與保水', '空調節能', '照明節能', 1),
(3968,  '中高級',  '建築的耗能很大，若可以延長房子的壽命，則可以大幅減低二氧化碳的排放。下列哪一項「不是」延長壽命耐久性的作法？', '只要單純地加強結構強度便易達成，提升結構強度20%則可延長壽命一倍',  '增加1cmRC保護層厚度，可提升壽命十年', '耐震度設計提升到一級以上，酌量提高柱樑及樓板的RC保護層厚度', '在屋頂興建可以絕熱保水的綠屋頂',  4),
(3969,  '高級', '建築的耗能很大，若可延長房子的壽命，則可以大幅減低二氧化碳的排放。然而結構體剩餘年限未達多少年，則無利用價值？',  '10', '20', '30', '40', 2),
(3970,  '中高級',  '夏天家裡的頂樓通常是最熱的地方，以下哪一項作法「不符合」節能減碳的精神？', '綠屋頂',  '加裝冷氣', '在屋頂噴灑霧化的水',  '舖設隔熱材',  2),
(3971,  '中級', '為何垃圾資源回收可以達到節能減碳的目的？', '可以兌換回收金',  '資源再利用可以減少能源消耗',  '可以將寶特瓶做成風車', '垃圾桶會比較乾淨', 2),
(3972,  '初級', '提倡推廣再生能源的主要目的為何？', '節能減碳', '保衛國家', '跟隨流行', '維護社會治安', 1),
(3973,  '中級', '根據經濟部能源局的研究顯示，哪一種車內設備對於車子的油耗量影響最大？', '空調', '電動窗',  '音響', '小燈', 1),
(3974,  '中高級',  '冷氣機的能源效率比值，一般稱什麼？',  'EF', 'EA', 'EER',  'EIA',  3),
(3975,  '高級', '臺灣哪座水庫是全憑國人自己設計、施工的第一座大型拱壩，在我國水利工程史上，具有劃時代的重大意義？', '石門水庫', '翡翠水庫', '虎頭埤水庫',  '阿公店水庫',  2),
(3976,  '中高級',  '太陽能是我國發展低碳能源之一，其太陽能輻射量平均每平方公尺約有幾瓦？', '100瓦', '300瓦', '500瓦', '1000瓦',  4),
(3977,  '初級', '外來種的入侵會造成原生物種的消滅，是一項嚴重的生態問題，以下哪一項是原生物種？',  '黑板樹',  '福壽螺',  '吳郭魚',  '臺灣樟樹', 4),
(3978,  '中高級',  '在社區改造方面，下列哪種做法「不能」達到節能減碳的效用？', '舉辦跳蚤市場，拿舊物品和別人流通', '提倡種樹活動，減少大氣中的CO2量',  '社區活動提供免洗餐具方便里民使用', '經常聘請專家授課，教導居民環保小祕方', 3),
(3979,  '中級', '為什麼能源是人類於二十一世紀所面臨最嚴重的生存問題之一？', '天災將成為能源短缺的主因', '每桶石油價格降低至3美元', '替代性能源將取代化石能源', '能源消耗量升高，供給不敷需求', 4),
(3980,  '初級', '以下哪一項的作法，可以有效洗碗而不浪費太多的水或洗碗精？', '將髒的碗盤先行沖水，清除表面', '洗碗的水溫約在攝氏45度', '髒碗盤不疊在一起，而使盤底變油',  '以上皆是', 4),
(3981,  '中高級',  '下列何者「不屬於」再生能源？', '海洋能',  '核能', '太陽能',  '生質能',  2),
(3982,  '中高級',  '以下各種再生能源，哪一項較符合低碳的精神，在發電或作為能源時最會產生額外的能源耗損？', '生質酒精', '水力發電', '太陽能發電',  '風力發電', 1),
(3983,  '中高級',  '生質能是指以下哪一項？',  '將生物質直接燃燒技術', '將生物質?用汽化或熱解（液化）產生合成燃料',  '生化轉換技術', '以上皆是', 4),
(3984,  '中高級',  '下列何者是發展「再生能源」的限制？',  '高開發成本',  '供應不穩定',  '高技術門檻',  '以上皆是', 4),
(3985,  '初級', '以下各種再生能源，哪一項必須仰賴足夠的風力才能穩定地供電，否則就得靠電池將電力貯存？', '生質酒精', '水力發電', '太陽能發電',  '風力發電', 4),
(3986,  '初級', '發生大地震時，小武看到身邊有四個地方，他應該到哪裡避難？', '學校操場中央', '天橋下',  '百貨公司一樓門口', '公車亭',  1),
(3987,  '初級', '臺灣夏季盛行西南風，易發生午後雷陣雨，在戶外遭遇打雷閃電時要如何因應？',  '趕快躲到樹底下',  '跑到空曠的地方',  '拿出手機打電話求救',  '盡快回到車內或室內',  4),
(3988,  '初級', '下列何者是一般動物比人類更快察覺地震的原因？', '大多數動物的嗅覺都比人類好',  '動物對低頻率比較敏感', '動物對高頻率比較敏感', '大多數動物的視力都比人類好',  2),
(3989,  '初級', '氣象預報颱風即將來臨，我們應該準備甚麼東西？', '手電筒、通訊工具及收音機等',  '不用準備', '電子產品', '電動玩具', 1),
(3990,  '初級', '發生大地震時，下列哪些是我們該做的？(A)站在窗戶旁躲避(B)把門打開(C)關閉瓦斯、火爐(D)搭電梯逃難',  'BD', 'AD', 'AB', 'BC', 4),
(3991,  '初級', '颱風來襲時，我們應該去哪裡？', '登山', '海邊觀浪', '看水庫洩洪',  '待在家裡', 4),
(3992,  '初級', '當發生各類災害時，不論水災、火災、土石流、地震等等災害時，下列何者為通報單位？',  '地方警察局',  '氣象局',  '消防局',  '行政院',  3),
(3993,  '中級', '根據水利署統計，直至民國100年臺灣地層下陷最為嚴重的地區為以下何者？',  '北北基',  '桃竹苗',  '雲嘉南',  '宜花東',  3),
(3994,  '初級', '颱風期間土石流防災預警主要根據哪項資訊而發布警戒？',  '風速', '雨量', '地震', '地質', 2),
(3995,  '高級', '下列何者「不參與」空氣中產生臭氧的光化學反應？',  '紫外線',  '甲烷', '氫氧自由基',  '反應性碳氫化合物', 2),
(3996,  '中級', '臺灣的颱風是由哪一種氣旋發展而成的？', '熱帶氣旋', '溫帶氣旋', '亞熱帶氣旋',  '極圈氣旋', 1),
(3997,  '高級', '下列有關毒性實驗中，LD50之敘述何者正確？', 'LD是指中毒劑量', '50是指動物產生中毒的百分比', 'LD50愈小，致命性愈大', '有些化學物質對人類的LD50可以直接測試', 3),
(3998,  '中高級',  '空氣中氮分子與氧燃燒產生氮氧化物，溫度愈高時，何種污染物會優先形成？', '一氧化碳', '一氧化氮', '二氧化氮', '二氧化碳', 2),
(3999,  '中級', '以下哪些天然災害經常發生在板塊邊界？(A)火山(B)地震(C)大型山崩與堰塞湖(D)沙塵暴。', 'A',  'AB', 'ABC',  'ABCD', 3),
(4000,  '初級', '下?何者「?是」國際環保主要議題？',  '臭氧層破壞',  '溫室效應', '沙塵暴',  '酸雨', 3),
(4001,  '中級', '以下哪些天然災害可能會與氣候變遷效應發生關聯性？(A)洪水(B)山崩與土石流(C)土地沙漠化(D)地層下陷。', 'A',  'AB', 'ABC',  'ABCD', 4),
(4002,  '高級', '下列何者「不屬於」環境荷爾蒙？',  '有機錫',  'DDT',  '多溴(ㄒㄧㄡˋ)聯苯(PBB)',  '二硫化碳', 4),
(4003,  '中高級',  '降雨常誘發山崩，其主要原因為何？(A)土壤摩擦力下降(B)地下水位上升(C)土壤凝聚力下降(D)土壤內孔隙壓力下降。', 'A',  'AB', 'ABC',  'ABCD', 3),
(4004,  '中級', '人類活動提高了溫室效應造成地球暖化，下列敘述何者正確？',  '氣候劇烈變化', '地表溫度降低海水溫度上升', '海平面下降',  '冰河面積增加', 1),
(4005,  '初級', '下列何者是九九峰自然保留區的主要保護對象？',  '泥火山地景',  '天然海岸林',  '地震崩場斷崖特殊地景', '石灰岩地景',  3),
(4006,  '中高級',  '民國88年9月21日凌晨發生的大地震是哪一條斷層所引起？', '湖口斷層', '車籠埔斷層',  '後甲里斷層',  '池上斷層', 2),
(4007,  '中高級',  '下列關於颱風發展要件何者正確？',  '海水表面溫度須高於攝氏26.5度', '大部分在南北緯5度以內',  '小範圍的對流雲系存在', '大氣垂直風切變化大',  1),
(4008,  '中級', '欲減少山崩土石流災害，最佳對策為何？', '進行大量工程整治', '禁止土地開發利用', '增加預報氣候人員', '做好水土保持', 4),
(4009,  '中高級',  '氣象報告有時會說到「藤原效應」，指的是以下何種現象？', '地震引發山崩', '海底地震引發海嘯', '颱風引進西南氣流', '雙颱互相牽引', 4),
(4010,  '中高級',  '一個結構完整的颱風，下列何處為風雨以及破壞力最大之處？',  '颱風眼',  '雲牆區',  '颱風外圍', '螺旋雲帶', 2),
(4011,  '高級', '海嘯在深海處的傳遞速度與以下哪一交通工具相當？',  '噴射機',  '高鐵', '高速公路上的汽車', '自行車',  1),
(4012,  '高級', '全球暖化可能造成天然災害頻率與規模增加，以下何者為地球暖化減緩之自然調節機制？',  '極地融冰', '火山活動增加', '風化作用加劇', '永凍土溫度上升至冰點以上', 3),
(4013,  '高級', '下列何者為豪雨的定義？',  '日雨量大於或等於50mm而小於130mm', '日雨量大於或等於130mm',  '日雨量大於或等於200mm',  '日雨量大於等於350mm', 2),
(4014,  '高級', '所謂的溫室效應，下列敘述何者正確？',  '人類沒有破壞臭氧層之前，地球並沒有溫室效應',  '如果沒有自然的溫室效應，地球表面的平均溫度會降到0℃以下', '燃燒化石燃料並不會加強自然溫室效應',  '停止引起地球暖化的所有活動，臭氧層很快就會恢復',  2),
(4015,  '高級', '不同國家對於颱風分級標準不一，臺灣的颱風分級分為幾種？',  '2種', '3種', '4種', '5種', 2),
(4016,  '高級', '臺北盆地若發生地震，「較不可能」產生哪些災害現象？',  '土壤液化', '房屋倒塌', '管線斷裂', '土壤酸化', 4),
(4017,  '初級', '下列何種房屋結構最耐震？', '土角厝',  '木造', '磚造', '鋼骨', 4),
(4018,  '高級', '災害的發生是建立在下列何者因素的同時存在？',  '潛在危險、宣導不足',  '政策不當、宣導不足',  '潛在危險、抗災盲點',  '抗災盲點、政策不當',  3),
(4019,  '中高級',  '下列何者「不在」防災防疫演練時，須參與演練的單位中？', '地方衛生單位', '在地醫療院所、急救責任醫院',  '各區緊急與國軍之醫療訓練', '各區私人診所', 4),
(4020,  '初級', '下列何者是緊急避難包的建議項目？', '食物', '滑鼠', '乳液', '雜誌', 1),
(4021,  '初級', '社區節能減碳，我們可以做到甚麼？', '在家庭園種植綠色植物', '幫忙社區做資源回收分類',  '社區路燈開整天，會馬上通知管理人員維修',  '以上皆是', 4),
(4022,  '中級', '有關社區的垃圾分類何者正確？', '保麗龍回收歸類在廢塑膠內', '紙類回收必須把紙上的塑膠膜／袋清掉獨立回收',  '回收任何瓶罐類物品都要將裡面的液體倒乾淨', '以上皆是', 4),
(4023,  '初級', '身為社區的一份子，我們應該如何讓社區辦的活動更成功？', '參加社區舉辦的活動或成為活動的志工',  '社區的活動跟我無關，無需理會', '告訴其他人活動很無聊不要來玩', '把張貼的海報拿回家當計算紙',  1),
(4024,  '中級', '如何提高社區民眾對環境的認識？',  '社區定期請舉辦環境教育知識講座',  '張貼回收分類或是環境相關公告', '請里長定期廣播呼籲社區民眾注意有關環境相關的政策', '以上皆是', 4),
(4025,  '中級', '下列何種行為對社區環境有益？', '大量張貼廣告宣傳海報', '辦理社區環境清潔競賽', '在社區道路畫設整排的停車格',  '在社區環境內按汽機車喇叭', 2),
(4026,  '初級', '看見社區有人遛狗隨地大小便的話，我們應該怎麼做？', '當作沒看見',  '鼓勵他',  '勸說他，並請他把環境清潔乾淨', '下次也可以把狗帶來這邊遛', 3),
(4027,  '初級', '我們應該要如何防治社區病媒蚊孳生？',  '清理社區廢棄容器', '定期清理社區排水道',  '定期清理社區棄置垃圾場所', '以上皆是', 4),
(4028,  '中級', '對社區守望相助隊的敘述，何者「錯誤」？',  '防止外來人士破壞社區環境', '讓社區居民的情感更融洽',  '其實有或沒有都沒關係', '容易管理社區的環境維護',  3),
(4029,  '初級', '下列何者是處理垃圾的正確態度？',  '把垃圾丟到別人家門口', '看到電線杆旁有人棄置垃圾，也一起放在那邊', '反正晚上沒人看到，把垃圾丟到公園去',  '在家分類好，等垃圾車及回收車到後再丟棄',  4),
(4030,  '初級', '下列何者是保護社區環境最好的方式？',  '各做各的', '社區安排時間，大家共同分工',  '交給環保志工就好', '共同一起維護環境', 4),
(4031,  '高級', '用何種方式經營管理社區，更能培養社區自主能力？',  '當地居民共同參與', '請政府單位接管',  '住戶自己管好自己', '社區委員會自行管理',  1),
(4032,  '高級', '下列關於社區參與的推動，「不包含」哪一個面向？',  '對社區事務有一定的了解程度',  '完全依賴政府給予的補助',  '社區人際網絡的熟稔',  '社區居民間彼此相互信任',  2),
(4033,  '高級', '地方感是社區參與的重要因素之一，下列何者會較認同當地社區並與社區緊密相依？',  '外來移民的外國人士',  '從小生活在當地社區的民眾', '開發建商', '地方政府', 2),
(4034,  '高級', '下列何者「不是」社區保育成效？',  '改善當地河川生態', '促進戶外遊憩發展', '維護珍稀物種', '非法盜獵增加', 4),
(4035,  '中高級',  '社區產業的永續經營應以何者為優先考量因素？',  '地方政府直接設定準則規範', '制訂經營準則及指標時必須調查社區居民的意見',  '社區自己定就可以了',  '拿其他相關法規來套用即可', 2),
(4036,  '中級', '除二氧化碳之外，造成溫室效應的主因為何？', '甲烷', '氟氯碳化物',  '氧化亞氮', '水蒸氣',  4),
(4037,  '高級', '下列有關二氧化氮(NO2)的敘述，何者「錯誤」？', '燃料在高?下燃燒所產生',  '主要來源為工業污染排放',  '氮氧化物也是臭氧及酸沉降的前驅物', '吸入NO2及其他氮氧化物，降低人體對呼吸道感染的抵抗力',  2),
(4038,  '中高級',  '下列何者屬於粒狀污染物？', '酸霧', '一氧化碳', '硫氧化物', '?化烴類', 1),
(4039,  '初級', '北歐國家課徵碳稅項目中「不包括」哪項？',  '天然氣',  '水力發電', '煤碳', '油品', 2),
(4040,  '初級', '室內空氣中，甲醛主要可能來源為何？',  '空氣濾清器',  '裝潢用夾板',  '印表機',  '殺蟲劑',  2),
(4041,  '中級', '依照我國《空氣污染防制法》施行細則之規定，粒徑超過10微米，能因重力逐漸落下而引起公眾厭惡之物質稱為？',  '黑煙', '懸浮微粒', '落塵', '總懸浮微粒',  3),
(4042,  '初級', '下列何種情形下比較容易聽到氣象局以能見度來說明空氣品質的問題？',  '沙塵暴',  '暴風雨',  '乾旱', '寒流', 1),
(4043,  '中級', '下列何者是造成河川揚塵的主要原因？',  '降雨量減少',  '大量砍伐樹木', '外來人口增加', '不當使用環境用藥', 1),
(4044,  '初級', '下列何者是屬於人造懸浮微粒？', '沙漠塵灰', '煤煙', '火山灰',  '海鹽懸浮粒',  2),
(4045,  '中級', '下列何處是臺灣於民國70年代發現雨水略顯酸化的地區，因而著手進行酸雨監測計畫？',  '臺灣中部', '臺灣外島', '臺灣北部', '臺灣東部', 3),
(4046,  '中級', '下列何者對於濕沉降的敘述是「錯誤」？', '氣狀污染物隨雨、雪等降下', '氣狀污染物經由風力帶至海洋',  '大氣中污染物質去除的重要機制', '自然降雨是濕沉降最重要的機制', 2),
(4047,  '中級', '下列何者是民國84年至100年期間，空氣污染指標不良(PSI>100)站日數比率的變化？', '維持不變', '逐漸上升', '逐漸下降', '急遽上升', 3),
(4048,  '初級', '民國88年至99年期間，下列何種空氣品質指標污染物有逐年升高的趨勢？', '二氧化氮', '懸浮微粒', '二氧化硫', '臭氧', 4),
(4049,  '初級', '除了PSI值以外，下列何者可作為判斷空氣品質好壞的指標？', '濕度', '溫度', '曝光度',  '能見度',  4),
(4050,  '中高級',  '下列何者「不是」游離輻射？',  'Ｘ射線',  '可見光',  'α射線',  'γ射線',  2),
(4051,  '中高級',  '微波爐所發出的微波是屬於下列哪一種輻射？', '非游離輻射',  '游離輻射', 'α射線',  'γ射線',  1),
(4052,  '中級', '日常生活環境中之物品，下列何者為電磁輻射產生源？', '衣服', '紙本筆記本',  '木製傢俱', '電腦設備', 4),
(4053,  '中高級',  '下列何種波的頻率最高？',  '微波(MW)', '紅外線(IR)',  '可見光',  '紫外線(UV)',  4),
(4054,  '中高級',  '我國變電所對電場與磁場的檢測，依據的是什麼規定？', '我國環保署公告之規定', '國際非游離輻射防護協會之規定', '日本電磁波應用協會之規定', '美國電機電子工程協會之規定',  1),
(4055,  '中高級',  '下列何者為環境中電場和磁場的總稱？',  '電磁場',  '大氣場',  '向量場',  '音場', 1),
(4056,  '中級', '在環保署非屬原子能游離輻射管制網中，可以查詢住家附近的設施有哪些？',  '手機基地臺',  '變電所',  '無線電臺', '以上皆是', 4),
(4057,  '高級', '在量測變電所電磁波時，所有的測量點以離地面、牆面多少公尺為原則？', '1公尺',  '3公尺',  '5公尺',  '10公尺', 1),
(4058,  '初級', '目前雖無法證明電磁波對人體的危害，但若要預防它可能的危害，下列何者為可行的作法？', '儘量遠離電化製品', '相同電器設備，儘量選用大型',  '電器不用時插頭要繼續插著', '要延長使用電器時間',  1),
(4059,  '中高級',  '我們接受電磁波的強度，與離電器的距離關係為何？',  '與距離的平方成正比',  '與距離的平方成反比',  '與距離無關',  '以上皆非', 2),
(4060,  '中高級',  '紫外線分成UVA、UVB、UVC，下列對各種紫外線之敘述，何者「錯誤」？', 'UVA可穿透玻璃和水', 'UVB波長範圍約280奈米~315奈米之間',  'UVB可穿透空氣和石英',  'UVC對所有介質的穿透力皆為最佳', 4),
(4061,  '高級', '有關非游離輻射之定義，下列何者正確？', '能量低於10電子伏特(eV)', '頻率大於2.4×1015赫茲(Hz)', '波長大於324μm',  '以上皆非', 1),
(4062,  '中高級',  '對游離輻射與非游離輻射之敘述，下列何者正確？', '微波為游離輻射',  '頻率大於3×1015赫(Hz)為非游離輻射',  '可見光為非游離輻射',  'Ｘ射線為非游離輻射',  3),
(4063,  '高級', '微波爐已成為現在生活必需品之一，其電磁波波長為下列何者？', '0.1~15公分', '400~700奈米',  '1.5~2公里',  '100~400奈米',  1),
(4064,  '中高級',  '現在實驗室及工業上會使用下列何種非游離輻射照射，以達殺菌效果？',  '紅外線',  '雷射光',  '紫外線',  '微波', 3),
(4065,  '高級', '聯合國政府間氣候變遷委員會於西元幾年起，開始提出氣候變遷評估報告？',  '1988年',  '1990年',  '1995年',  '2001年',  2),
(4066,  '中高級',  '我國2012年訂定「國家氣候變遷調適政策綱領」的原因與社會有關的是以下何者？', '健全與提升社會的富裕度',  '建立整合性的社會福利運作機制', '降低社會脆弱度',  '作為島嶼老年化社會因應策略',  3),
(4067,  '中級', '下列哪一項「不是」我國訂定「國家氣候變遷調適政策綱領」的原因？',  '健全與提升國家調適能力',  '控制國家溫室氣體的排放',  '降低社會脆弱度',  '建立我國整合性的運作機制', 2),
(4068,  '中級', '下列哪一種水文現象與全球氣候變遷現象「無關」？',  '全球海平面上升',  '下雪的機會不變',  '造成全球水文循環改變', '降雨與蒸發散的強度升高',  2),
(4069,  '中級', '自溫室效應被發現且由科學家提出警訊至今，聯合國及各國政府與非政府組織即著手研擬各種不同類型之減緩策略，以下哪些「不是」臺灣地區的減緩策略？',  '節約能源、提高能源效率',  '發展火力發電技術', '開發新興與再生能源',  '發展溫室氣體減量', 2),
(4070,  '初級', '全球暖化和氣候變遷，是否可以靠人類以人為干預方式，來減少溫室氣體的排放量趨勢？',  '完全可以', '稍微可以', '稍微不可以',  '完全無法控制', 4),
(4071,  '中高級',  '2009年哥本哈根氣候會議，對2012年《京都議定書》到期後的減緩目標，並無一致共識，僅通過無法律約束力的哥本哈根協議(CopenhagenAccord)，以下哪一項目「不是」協議的主要內容？', '控制全球升溫在2℃內', '所有國家都必須採取行動對抗氣候變遷',  '提供即時與長期的財務援助', '必須在五年內，盡力將協議轉化為具法律約束力的協約', 4),
(4072,  '高級', '我國的溫室氣體減量目標是在哪一個文獻中宣告的？',  '馬總統第一次當選的文告',  '永續能源政策綱領', '國家永續發展綱領', '國家氣候變遷調適政策綱領', 2),
(4073,  '中高級',  '減緩與調適已是世界各國因應氣候變遷威脅的兩大重要策略，其中調適的目的在於降低人類與自然系統處於氣候變遷影響與效應下的脆弱度，以下何者是脆弱度的影響因子？', '特性、強度',  '頻率、敏感度、',  '調適能力', '以上皆是', 4),
(4074,  '中高級',  '以下哪一個政府機關負責臺灣氣候變遷調適農業生產及生物多樣性領域的工作分組？',  '農委會',  '交通部',  '水利署',  '環保署',  1),
(4075,  '高級', '1993年至2003年間臺灣附近平均海平面上升速率與過去五十年上升速率平均值之比較，下列敘述何者正確？',  '速率慢2倍左右',  '大略相同', '速率快2倍左右',  '速率快4倍左右',  3),
(4076,  '中高級',  '下列何者「不是」氣候變遷對農業生產的衝擊？',  '農耕面積因海平面上升、地層下陷、土壤鹽化及農地變更而逐年下降', '造成降雨量分布不均或總量不足時水資源分配困難', '降雨強度過大可能直接破壞作物外觀，並阻礙作物生長', '農作物在逆境中成長，存活的品種會讓基因更佳',  4),
(4077,  '初級', '森林及林業可能常受到氣候變遷的衝擊。下列何者敘述「不正確」？', '森林植群帶分布改變',  '各林相內物種遭受生存威脅', '人工林健康度下降', '森林的碳吸存功能上升', 4),
(4078,  '中級', '下列何者「不是」海水溫度上升對漁業生產的衝擊？',  '改變海洋漁業資源種類與數量',  '漁場位移或消失',  '魚群迴游路線改變', '捕撈無獲風險降低', 4),
(4079,  '中級', '溫度上升會衝擊畜牧的生產，下列何者敘述「不正確」？',  '可導致畜禽動物個體之熱緊迫現象',  '造成微生物不當滋生，動物感染疾病的機會增加',  '飼料作物產量與品質降低',  '畜禽基因多樣性增加',  4),
(4080,  '中高級',  '極端天氣事件發生的頻率與強度增加，會造成河川很多的影響。下列何者敘述「不正確」？', '影響河川物理、化學結構、生物組成', '河川人工結構物難以抵擋暴雨的沖刷', '沖刷下來的粗粒流入河川中造成更大幅度的擾動與傷害', '以上皆非', 4),
(4081,  '中高級',  '海平面上升、暴雨颱風的頻率與強度增加會直接造成海岸土地的衝擊，下列何者敘述「不正確」？',  '海岸侵蝕及海岸線的退縮',  '鹹水入侵河口或淡水的地下蓄水層',  '可能會造成當地的生物族群衰退、漁業資源枯竭',  '興建穩固的巨型海堤就可永久確保海岸地區人類的居住環境', 4),
(4082,  '中高級',  '海洋生態系受到衝擊後「不會」造成下列哪一項影響？', '海洋生物幼生的著床與播遷', '海洋食物網的組成結構', '洄游性魚類的漁場位置改變', '海洋生物基礎生產力提升',  4),
(4083,  '中高級',  '「在特定地域，同一時間內、同種個體所組成之群體」，在生態學上被稱為何？',  '族群', '物群', '聚群', '類群', 1),
(4084,  '中高級',  '極端天氣與災變發生頻率與強度增加，使得保護區經營管理面臨下列哪些挑戰？',  '病蟲害、外來種入侵或擴大範圍的情況更嚴重', '週邊棲地因開發改變，使得保護區逐漸成為生態孤島',  '需要被保護的物種、植群、或特殊生態系的分布發生改變',  '以上皆是', 4),
(4085,  '中高級',  '關於外來入侵種的敘述，哪一項「不正確」的？',  '許多物種可能受到衝擊而數量下降、分布縮減，甚至瀕絕',  '一些適應性廣、遷移性強、入侵能力強的物種卻可能反而擴大分布範圍、增強本身的競爭力', '入侵能力強的外來入侵種常常比本土種更具侵略性', '大部分的外來種都是自然遷徙到新的環境中',  4),
(4086,  '中高級',  '全球氣溫上升，下列何者對健康危害較「不會」出現？', '拉長氣候相關蟲媒傳染性疾病發生的時間', '移入歐美地區氣候相關傳染性疾病',  '移入東南亞地區氣候相關傳染性疾病', '拉長夏季傳染性疾病發生時間',  2),
(4087,  '中高級',  '在極端降雨後，下列哪一種現象的出現機率「不會」提高？', '乾旱', '水災', '增加接觸污水機會', '潔淨水增加',  4),
(4088,  '高級', '推動國家重要河川流域整體規劃及治理時，以下哪一項業務未列入？', '流域單元的水土林資源', '集水區保育、防汛等事項',  '政府部門組織再造', '海岸防護及土地使用環境營造',  3),
(4089,  '中高級',  '?以下哪一項「不是」優先要提升都會地區對氣候變遷調適防護能力的原因？', '臺灣將近80％的人口聚集在都市地區',  '都市地區土地價值非常高',  '相關都市土地的規劃與管理制度缺乏對氣候變遷的回應', '都市地區的氣候脆弱度高',  2),
(4090,  '中級', '針對防災四階段來說，下列何者屬於「應變」(Response)的措施？', '興建護岸', '土地使用管制', '恢?運輸系統', '成?災害應變中心', 4),
(4091,  '高級', '為了降低災區再次受損的風險，若該地區確定為重複致災區，應採什麼策略，以降低災區再次受損？', '研擬再開發策略，規劃新的發展藍圖', '擬辦減碳工程內容及經費',  '棄自然復育，並擴大該區水泥化工程', '審慎檢討治理策略、工法、材料', 4),
(4092,  '中級', '因應極端氣候檢討橋樑、道路防洪排水設施之選址及設計時應考量許多因素，以下哪一項「不是」考量重點？', '極端天氣', '上下游水文及地質變化', '橋樑照明', '生態保育', 3),
(4093,  '高級', '依據2012年「國家氣候變遷調適政策綱領」所述，以下哪一項「不是」在「維生基礎設施」領域的調適策略中，積極研發之新技術？', '耐洪、耐澇',  '耐旱、耐強風', '耐震', '耐海嘯、耐火災',  4),
(4094,  '高級', '以下哪一項「不是」管理臺灣環境敏感地的作法？', '劃設國土保育區，禁止新開發行為及設施之設置',  '污染地開發成為各種工業區', '維護天然森林、涵養水土資源、保護物種多樣性',  '加強違規使用行為之查報與取締', 2),
(4095,  '高級', '以下哪一項「不是」海岸主題調適綱領所擬定的總目標？',  '優先成立海洋事務部',  '保護海岸自然環境', '降低受災潛勢', '減輕海岸災害損失', 1),
(4096,  '高級', '為了提升農業產業抗逆境能力，下列何者「不是」政府提出應對的措施？', '發展設施栽培產業', '保留傳統的農產業', '推動精準農業', '發展生物科技', 2),
(4097,  '高級', '在政府組織再造後，氣候變遷政策的主要機關，並「不包括」下列何者？', '行政院國家發展委員會', '環境資源部',  '經濟建設委員會',  '外交部',  4),
(4098,  '初級', '下列何種作法對環境保護有正面的幫助？', '拒用保麗龍餐盒',  '利用洗碗精洗碗',  '購買包裝精美的商品',  '喝完鋁箔包飲料，直接丟至垃圾桶',  1),
(4099,  '中高級',  '自來水處理過程之順序為何？(A)淨水(B)導水(C)輸(配)水(D)取水', 'ABCD', 'BACD', 'CBAD', 'DBAC', 4),
(4100,  '初級', '水池水塔清洗業者資訊何處可尋得？', '交通部網站',  '外交部網站',  '臺灣自來水公司網站',  '臺灣電力公司網站', 3),
(4101,  '中高級',  '砷對民眾健康不會立刻顯現影響，但會累積在體內，逐漸引發下列何病？', '心臟病',  '烏腳病',  '痛痛病',  '痛風', 2),
(4102,  '高級', '下列何者「不是」飲用水水質標準規定項目？', '細菌性標準',  '病毒性標準',  '物理性標準',  '化學性標準',  2),
(4103,  '中級', '如何降低飲用水中消毒副產物三鹵甲烷？', '先將水煮沸，打開壺蓋再煮三分鐘以上',  '先將水過濾，加氯消毒', '先將水煮沸，加氯消毒', '先將水過濾，打開壺蓋使其自然蒸發', 1),
(4104,  '中高級',  '水質標準中大腸桿菌群之指標意義為何？', '可能會有其他致病菌同時出現',  '無機污染的指標之一',  '有機污染之指標之一',  '反映出配水系統受損',  1),
(4105,  '高級', '下列哪一項「不是」飲用水消毒副產物？', '三鹵甲烷', '溴酸鹽',  '含鹵乙酸', '三氯乙烯', 4),
(4106,  '高級', '農業地區使用過量化學肥料，造成地下水井遭硝酸鹽污染，對嬰孩危害最鉅，易使他們得到下列何病？',  '心臟病',  '白血症',  '藍嬰症',  '高血壓',  3),
(4107,  '高級', '下列有關加氯消毒的敘述，何者「錯誤」？',  '氯消毒具有效性',  'HOCl和OCl?在水中之?稱為自由有效氯',  'HOCl之消毒效果較OCl?弱',  'pH值愈高，則HOCl含?愈低，OCl?愈高', 3),
(4108,  '高級', '住家常見的自來水二次污染為何？',  '自來水因重複再利用而造成水質不良', '自來水因用戶用水不當或設備問題導致水質惡化',  '自來水因使用者自行淨化而造成水質污染', '自來水因未消毒完全造成細菌污染',  2),
(4109,  '高級', '天然水源中何者硬度最小？', '海水', '河水', '雨水', '地下水',  3),
(4110,  '中高級',  '不同的溫室氣體有不同的「全球暖化潛勢(GWP)」。下列哪一種氣體的「全球暖化潛勢(GWP)」最大？',  '二氧化碳', '甲烷', '六氟化硫', '氧化亞氮', 3),
(4111,  '中級', '下列何者為臺電實施「夏月電價」的時期？',  '1~3月', '4~6月', '6~9月', '10~12月', 3),
(4112,  '中級', '「這種氣體在溫室氣體中，雖然吸收長波輻射能量的能力最低，但是它卻占了溫室氣體總量的大部分，而對溫室效應造成最大的影響。」，上述氣體最可能為下列何者？', '甲烷', '二氧化碳', '全氟化碳', '六氟化硫', 2),
(4113,  '中級', '我們應該如何減緩「都市熱島效應」對都會城市造成的影響？',  '移居鄉下', '安裝冷氣', '植栽綠地', '安裝金屬玻璃帷幕', 3),
(4114,  '中級', '下列何者為減少熱島效應最直接也最有效的行為？', '舖設水泥地',  '增加建築面積內的保水性',  '廢棄物減量',  '建築物二氧化碳減量',  2),
(4115,  '高級', '都市建築面積增加保水性可以避免熱島效應，下列何者「不是」其帶來的好處？',  '減少洪水氾濫頻率', '降低公共排水設施負荷', '避免土石流',  '調節微氣候',  3),
(4116,  '高級', '溫室氣體中二氧化碳主要來自化石能源的使用，而甲烷主要來自哪種產業？',  '紡織業',  '旅遊業',  '農牧業',  '能源業',  3),
(4117,  '初級', '以下何者為造成溫室效應加劇的主要原因？',  '懸浮微粒', '臭氧排放', '二氧化碳排放', '海水上升', 3),
(4118,  '初級', '截至目前全球已超過180個成員國(含歐盟)簽署，下列何者可被稱為「全球最大之環保公約」？', '京都議定書',  '氣候變化綱要公約', '二十一世紀議程',  '里約宣言', 2),
(4119,  '初級', '下列哪些廢紙類「不可以」進行資源回收？',  '紙尿褲',  '包裝紙',  '雜誌', '報紙', 1),
(4120,  '初級', '下列廢紙類何者可以進行資源回收？', '複寫紙',  '轉印紙',  '塑膠光面廢紙', '紙製糖果禮盒', 4),
(4121,  '初級', '下列何者是正確的廚餘回收行為？',  '剩飯可作養豬用',  '筷子可以放入廚餘回收桶',  '柚子皮可以作為養豬用', '魚骨頭可以作為養豬用', 1),
(4122,  '初級', '下列廢塑膠何者可以進行資源回收？', '保鮮膜',  '百葉窗',  '錄音帶',  '寶特瓶',  4),
(4123,  '中級', '鋁容器的處理方式「不包括」下列哪項步驟？', '將容器內殘留物體清除', '用水略為清洗', '壓扁打包', '直接交給清潔隊',  4),
(4124,  '初級', '關於垃圾減量的敘述，下列何者「錯誤」？',  '自備環保購物袋',  '塑膠袋重複使用',  '購物時主動拒絕塑膠袋', '購買包裝精美的東西',  4),
(4125,  '中級', '關於資源回收的效益，下列敘述何者「錯誤」？',  '垃圾減量', '節約資源', '減少垃圾掩埋場壽命',  '減少垃圾處理成本', 3),
(4126,  '初級', '下列何者是正確處理剩下飯菜的方法？',  '倒進垃圾桶',  '廚餘回收', '放在花盆裡',  '丟進臭水溝',  2),
(4127,  '中級', '家裡的殺蟲劑罐用盡後，應該如何正確處理？', '放進鐵鋁罐壓縮機', '直接丟入垃圾桶',  '送交資源垃圾回收車',  '以上皆是', 3),
(4128,  '初級', '民眾碰到路邊有廢棄的汽、機車，最好的處理方式為何？',  '破壞廢棄汽機車',  '打電話到各縣市的環保局、警察局',  '把有價的零件拆下來',  '不管它',  2),
(4129,  '初級', '關於廢電池的回收地點，下列何者「錯誤」？', '學校', '照相館',  '垃圾掩埋場',  '清潔隊',  3),
(4130,  '中高級',  '下列何者「不屬於」有害垃圾？', '水銀電池', '保麗龍',  '鋰電池',  '鎳鎘電池', 2),
(4131,  '初級', '關於回收觀念，下列何者敘述是「錯誤」？',  '購買不使用農藥的農產品',  '將新聞紙、玻璃瓶或碎片視為垃圾丟棄',  '上街購物時，自備購物袋',  '少用免洗餐具', 2),
(4132,  '中高級',  '相片行中的定影液、顯影液含有何種有價物質？',  '鐵',  '金',  '銀',  '銅',  3),
(4133,  '初級', '下列何者屬於可以回收的電池？', '碳鋅電池', '鎳鎘電池', '鋰電池',  '以上皆是', 4),
(4134,  '中級', '下列何項對於回收標誌的描述正確？', '回收標誌為3個逆向箭頭所組成', '箭頭分別代表資源回收三合一制度',  '塑膠容器上三角形的數字標誌，代表7類不同材質塑膠', '有回收標誌也可以不作回收', 3),
(4135,  '初級', '下列關於資源回收的觀念，何者「錯誤」？',  '少用免洗餐具，減少垃圾產生',  '紙張儘量雙面使用', '玻璃瓶可直接與一般垃圾包在一起丟棄',  '上街購物，自備購物袋', 3),
(4136,  '初級', '下列何者「不適合」作為廚餘堆肥？', '油炸廢油', '茶葉渣',  '菜葉', '果皮', 1),
(4137,  '中級', '住家附近有一臺廢棄車放置已久，而且沒有掛車牌，應該如何適當的處置？',  '打電話給拖吊業者', '向消防局檢舉', '向環保局檢舉', '連絡汽機車回收業者',  3),
(4138,  '中高級',  '下列何者「不是」《廢輪胎回收貯存清除處理方法及設施標準》所訂定之廢輪胎分解處理方式？', '破碎處理', '裂解處理', '能源利用', '直接掩埋', 4),
(4139,  '中級', '在資源回收分類中，下列何者物品「不能」作為「廢塑膠類」回收？', '安全帽',  '吸管', '牛奶瓶',  '汽水瓶',  2),
(4140,  '中高級',  '關於「廢照明光源回收」，下列敘述何者「錯誤」？',  '可避免環境污染',  '可當成玻璃回收',  '應儘量縮短家中貯存時間',  '有些可產出螢光粉', 2),
(4141,  '中高級',  '使用過的雷射印表機空碳粉匣，應該如何處理？',  '拿給資源回收車回收',  '送交清潔隊處理',  '洽詢碳粉匣製造商協助回收', '賣給回收業者', 3),
(4142,  '中級', '有關複合式容器材質，例如奶粉罐瓶身為鐵材質，瓶蓋為塑膠材質，下列處理方式何者「錯誤」？',  '拆開後分類回收',  '交給清潔隊資源回收車', '丟進垃圾車',  '交給回收商處理',  3),
(4143,  '中高級',  '關於廢電子電器的處理方式，下列何者作法「錯誤」？', '送至衛生掩埋場進行掩埋',  '購買新品時，交販賣業者回收',  '與清潔隊約定時間後，將電子電器搬至約定地點交付',  '以上皆非', 1),
(4144,  '高級', '依據國內「廢棄物清理法」之規定，廢棄物可概分為哪兩種？',  '有害性廢棄物、非有害性廢棄物', '醫療性廢棄物、非醫療性廢棄物', '資源性廢棄物、非資源性廢棄物', '一般廢棄物、事業廢棄物',  4),
(4145,  '中級', '下列何者「不是」目前已公告應回收廢電子電器物品？', '電視機',  '電話機',  '暖氣機',  '洗衣機',  2),
(4146,  '高級', '下列何者「不屬於」公告回收的電子電器物品？',  '電冰箱',  '微波爐',  '洗衣機',  '電視機',  2),
(4147,  '高級', '資源回收四合一是指哪四種對象？',  '社區民眾、地方政府清潔隊、回收商、回收基金',  '學校、家庭、工廠、醫院',  '物品類、容器類、資訊類、其他類',  '紙類、塑膠類、電子類、其他類', 1),
(4148,  '高級', '資源回收的分類方法，下列何者正確？',  '紙杯、鋁箔包與蠟紙皆為紙類，可混合回收',  '寶特瓶的「塑膠材質回收辨識碼」是3號', '燈管可視為玻璃類回收', '塑膠光面廢紙視為一般垃圾處理', 4),
(4149,  '高級', '下列何者為7號塑膠？', '聚丙烯(PP)',  '聚乙烯對苯二甲酸酯(PET)', '聚羥基丁酸酯(PHB)',  '高密度聚乙烯(HDPE)', 3),
(4150,  '中高級',  '廚餘回收可分為生(堆肥)廚餘與熟(養豬)廚餘，下列哪一類是「不」屬於生(堆肥)廚餘?', '枯枝落葉', '過期水果', '果菜殘渣', '罐頭食物', 4),
(4151,  '高級', '環保署推動的資源回收四合一制度，「不包括」下列哪個單位或組織？',  '地方清潔隊',  '回收商',  '回收基金', '垃圾掩埋場',  4),
(4152,  '中級', '全臺第一座太陽能高鐵車站為何？',  '臺中站',  '左營站',  '苗栗站',  '臺北站',  3),
(4153,  '初級', '打破的碎玻璃應該要怎麼處理？', '直接丟入垃圾袋即可',  '埋入土內免得有人踩到', '報紙包好並註明危險字樣交給清潔隊員',  '放在路邊自然會有人來收走', 3),
(4154,  '中高級',  '下列何者為濕地的功能？',  '提供野生生物和魚類棲息地', '調節雨水', '作為水源地',  '淨化自來水',  1),
(4155,  '中高級',  '影響地球溫度上升的氣體，包含下列哪幾類？', '二氧化碳、甲烷',  '硫化鈉、氫氧化鉀', '氯化銨、硫化亞鐵', '氧化矽、二硫化碳', 1),
(4156,  '中級', '臺灣的產業如何進行溫室氣體減量？', '少搭大眾運輸多開車',  '尋求替代能源(如風力發電)',  '增加清潔劑產量',  '垃圾自行燃燒', 2),
(4157,  '中級', '地球的構造由外而內可大致分為地殼、地函與下列哪一項？', '軟流圈',  '固態岩石', '地核', '岩石圈',  3),
(4158,  '初級', '電冰箱存放食物，以不超過幾分滿最恰當？',  '三分滿',  '五分滿',  '八分滿',  '全滿', 3),
(4159,  '中高級',  '購買日光燈應選擇哪一種安定器較省電？', '傳統式',  '電子式',  '電磁式',  '以上皆是', 2),
(4160,  '中級', '綠色消費是以哪種力量為基礎？', '政府機關', '社會團體', '全體民眾', '企業團體', 3),
(4161,  '中高級',  '環保署依《水污染防治法》第73條規定，「廢(污)水以未經許可登記之管線排放…」於何時生效？',  '95年3月15',  '97年5月1日',  '99年7月1日',  '100年9月1日', 4),
(4162,  '初級', '社區綠美化植物，為何具有「低碳」功能？',  '植物進行呼吸作用', '植物進行蒸散作用', '植物進行分解作用', '植物進行光合作用', 4),
(4163,  '初級', '下列何者「不是」減碳診所提供的診斷服務？', '電力', '省水', '消防', '資源回收', 3),
(4164,  '中級', '風力發電機組依照主軸與水平面的相對位置分類，何者正確？',  '水平軸與垂直軸',  '迎風式與背風式',  '主動式與可動式',  '大型、中型、小型', 1),
(4165,  '中高級',  '我國依據什麼法規建構安全穩定、潔淨環境之能源供需系統，以達成國家節能減碳目標，實現永續能源發展？', '再生能源發展條例', '能源管?法',  '肥料管理法',  '空氣品質管理法',  2),
(4166,  '高級', '在經濟部所公告的「水泥製造業應遵行之節約能源與能源效率指標規定」中，其指定使用之能源設備種類有哪些？', '生熟料系統',  '旋窯系統', '水泥磨系統',  '以上皆是', 4),
(4167,  '中級', '「節能標章」的使用期限為何？', '1年', '2年', '3年', '4年', 2),
(4168,  '中級', '風力發電廠可開發區域，下列何者正確？', '已核定開發區', '海岸及生態保護區', '3級以上淺層地震', '平原無斷曾帶區域', 4),
(4169,  '中級', '廢輪胎粉碎後的橡膠顆粒與瀝青混合鋪路可延長道路壽命幾倍？', '一倍', '三倍', '四倍', '五倍', 2),
(4170,  '中高級',  '對違反廢清法稽查之場所，稽查人員請求身分證明卻遭無故拒絕者，得罰款新臺幣多少元？', '500以上2,000元以下',  '600元以上3,000元以下', '800以上5,000元以下',  '1,000元以上3,000元以下', 2),
(4171,  '初級', '下列哪些產品需要張貼強制性能源效率標示？', '電冰箱',  '除濕機',  '窗(壁)型與箱型冷氣機',  '以上皆是', 4),
(4172,  '初級', '臺灣太陽光電發電系統的設置方位，以何者為優先考慮？',  '東北方',  '西南方',  '西北方',  '東南方',  2),
(4173,  '中高級',  '建設多少仟瓦以上風?發電系統才需考量風速條件？',  '200',  '300',  '400',  '500',  4),
(4174,  '初級', '失去臭氧層保護會對人類造成什麼影響？', '皮膚癌、白內障疾病',  '使海平面下降', '農作物產量變多',  '增加動物免疫系統', 1),
(4175,  '中級', '酸雨會對森林造成嚴重的損害，以下何者「不正確」？', '會帶走土壤中的鈣和鎂造成樹木枯死', '會阻礙葉子的氣孔進行光合作用', '會造成凋零的速率大於再生的速率',  '會降低土壤真菌的成長', 4),
(4176,  '初級', '有關水污染來源中下列何者為點污染源？', '農地', '林地', '畜牧廢水', '營建工程', 3),
(4177,  '高級', '下列何者「不屬於」垃圾完全燃燒須注意的3T原則？', '燃燒溫度', '停留時間', '攪拌作用', '傳輸作用', 4),
(4178,  '高級', '下列關於《環境基本法》之敘述何者正確？',  '在經濟對環境有嚴重不良影響時，應以經濟為優先', '基於國家長期利益，環境比經濟、科技及社會發展都優先',  '我們應犧牲自己的需求，考量後代的需要和發展',  '環境，係指影響人類生存與發展之各種天然資源及經過人為影響之自然因素的總稱', 4),
(4179,  '高級', '下?何者?是目前?政院環保署組織內的部門？',  '水利局',  '管制考核及糾紛處理處', '土污基管會',  '環境督察總隊', 1),
(4180,  '高級', '有關「清潔劑環保標章規格標準」的敘述何者「錯誤」？',  '生物分解度須達80%以上', '不得檢出EDTA', '不得檢出乙氧烷基酚',  '不得檢出含氯漂白劑',  1),
(4181,  '高級', '以下何者為「電器類環保標章規格標準」之環境訴求？', '省電', '塑膠件不得檢出鉛', '塑膠件不得檢出溴化阻燃劑', '以上皆是', 4),
(4182,  '初級', '下列何者「不是」節水小偏方？', '加裝流量蓮篷頭',  '隨手關緊水龍頭',  '定期檢查馬桶、水塔等', '直接用水龍頭沖洗衣物', 4),
(4183,  '初級', '下列何者「不是」在學校減少空氣污染的做法？',  '多種植綠色植物',  '整理環境前，可先灑水', '室內儘量避免使用具有揮發性的有機物修正液', '校園落葉直接燃燒就好', 4),
(4184,  '初級', '下列何者「不是」資源回收前要作的處理？',  '沖洗瓶罐', '壓扁瓶、罐、盒',  '避免打破燈泡和日光燈管',  '大型的廢棄傢俱與家電用品隨意丟棄路邊', 4),
(4185,  '初級', '有關節能減碳(衣)的敘述何者正確？',  '夏天穿透氣淺色衣物',  '回收舊衣服',  '挑選天然材質的衣服',  '以上皆是', 4),
(4186,  '初級', '有關節能減碳(行)的敘述何者正確？',  '騎腳踏車代替機車', '搭乘大眾運輸工具', '開車時緩慢踩油門', '以上皆是', 4),
(4187,  '中級', '以下敘述何者「不符合」綠色消費行動？', '減少垃圾、重覆使用、資源回收', '購買綠色產品', '購買私人交通工具', '簡化生活、淡化慾望',  3),
(4188,  '中級', '下列哪一種購買行為無法兼顧綠色消費與公平貿易的關係？', '儘量購買在地的農產品', '設法壓低農民利潤', '購買商品時從農民的利益出發',  '多購買有機農產品', 2),
(4189,  '中級', '關於我國環保標章的敘述，下列說明何者「錯誤」？',  '以一片綠色樹葉包裹著純淨、不受污染的地球', '綠色樹葉代表「可回收、低污染、再利用」之綠色消費觀念', '以綠葉包裹地球，象徵綠色消費是全球性、無國界的',  '因為此標章，消費者可以知道如何選購綠色產品',  2),
(4190,  '中高級',  '下列哪個「不是」購車時選擇節能車輛的考量？',  '車身流線型',  '能源效率比(EER)越低越好', '低排氣量', '淺色系的車輛', 2),
(4191,  '中高級',  '以下對於綠色採購的概念何者「錯誤」？', '政府主要扮演角色為法規制度',  '社會團體為提倡者、監督者', '企業主要扮演角色為供應者、出資者、消費者', '以學術團體之力量為基礎',  4),
(4192,  '中級', '推動綠色產業發展需要哪些單位配合？',  '政府', '消費者',  '廠商', '以上皆是', 4),
(4193,  '初級', '推動綠色產業發展的最終目的為何？', '環境永續發展', '利潤最高', '成本最低', '價值最高', 1),
(4194,  '初級', '如何最恰當地處理日常生活的廢棄物？',  '任意丟掉', '藏起來',  '資源分類回收', '送給別人', 3),
(4195,  '初級', '哪一種交通工具最符合綠色環保發展？',  '自行車',  '摩托車',  '小汽車',  '公車', 1),
(4196,  '初級', '臺北市哪一棟建築被列為鑽石級的綠建築？',  '市立美術館',  '當代藝術館',  '臺北故事館',  '北投圖書館',  4),
(4197,  '中級', '有關於碳足跡的計算包括哪些部分？', '材料', '製程', '運輸', '以上皆是', 4),
(4198,  '中級', '若直接將垃圾交給清潔隊員，民眾可先將家裡的垃圾分為三類，以下何項「不在」範圍之內？',  '玻璃瓶',  '資源垃圾', '一般垃圾', '廚餘', 1),
(4199,  '中級', '採用太陽能發電須考量哪些因素？',  '技術層面', '地理區位', '日照條件', '以上皆是', 4),
(4200,  '中級', '臺北花博內的「環生方舟」及臺南慈濟安平聯絡處皆是回收下列哪一種材料所建築而成？',  '寶特瓶',  '玻璃瓶',  '瓦片', '竹板', 1),
(4201,  '中級', '使用環保分解垃圾袋的主要原因為何？',  '價格便宜', '隨手可得', '減少污染', '不容易破', 3),
(4202,  '中級', '哪個國家前來臺灣屏東考察養水種電措施，以振興災區經濟？',  '印尼', '日本', '菲律賓',  '越南', 2),
(4203,  '中高級',  '環保署主要針對何種產業推動「綠行動傳唱」？',  '餐飲業',  '演藝業',  '婚紗業',  '旅館業',  4),
(4204,  '中高級',  '政府為推動「綠色能源產業旭升方案」，在何單位下成立「?色能源產業服務辦公室」，提供?色能源業界服務？', '環保署',  '財政部',  '交通部',  '經濟部',  4),
(4205,  '中高級',  '太陽光電發電系統(設備)的安裝費用需考量哪些因素？',  '系統容量大小', '材料選用', '施工方法', '以上皆是', 4),
(4206,  '中高級',  '為推動發展低碳觀光，在全島建置20處公共建築太陽光電示範設置工程的為哪一座離島？', '澎湖', '金門', '馬祖', '綠島', 1),
(4207,  '中高級',  '電動車最適合在何種狀況下行駛？',  '爬山', '長途', '市區短程', '賽車場',  3),
(4208,  '中級', '有關臺北捷運文湖線的說明何者「錯誤」？',  '中運量',  '車廂間獨立',  '主要為高架',  '松山機場段為平面', 4),
(4209,  '中高級',  '歐洲哪一個國家在2013年將興建結合高科技的智慧型公路？', '法國', '荷蘭', '德國', '比利時',  2),
(4210,  '高級', '每年接近十月時，於新北市雙溪地區食用哪種食材最符合綠色環保？', '馬鈴薯',  '花生', '山藥', '何首烏',  3),
(4211,  '高級', '為響應綠建築的發展，國內何種建材又開始大量被應用？',  '竹子', '石塊', '磚頭', '石板', 1),
(4212,  '高級', '據國際能源總署發布的最新報告，何種能源將在10年內超越石油，成為世界最主要的能源？',  '木材', '煤炭', '農作物',  '塑膠', 2),
(4213,  '初級', '臺北市舉行花博期間，其環生方舟的建築材料主要為下列何者？', '木板', '寶特瓶',  '不繡鋼',  '鐵氟龍',  2),
(4214,  '高級', '待機電力約占家庭用電的多少百分比？',  '7.4',  '17.4', '27.4', '37.4', 1),
(4215,  '高級', '下列何者「不是」LED照明產業的分類？',  '元件', '模組', '照明應用', '資訊科技', 4),
(4216,  '初級', '下列何者「不是」水力發電的優點？', '不會造成空氣污染', '運維成本低',  '不會有生態衍生問題',  '可以重複使用', 3),
(4217,  '中高級',  '我國有害事業廢棄物認定中有一項是「溶出毒性事業廢棄物」，下?何者「?適用」毒性特性溶出程序(TCLP)加以認定？', '重?屬',  '石綿', '農藥', '氯仿', 2),
(4218,  '中級', '臺灣的噪音管制標準中，下列何時段的管制最寬鬆？',  '日間', '晚上', '夜間', '以上皆是', 1),
(4219,  '初級', '隔壁水果店冷?水塔太吵，最適當的解決方法是？', '過去與老板吵架',  '打公害陳情專線',  '沒辦法，只能自嘆倒楣', '半夜去砸壞冷氣',  2),
(4220,  '中級', '下列何種公害會自然消失？', '垃圾', '噪音', '水污染',  '空氣污染', 2),
(4221,  '高級', '因婚喪、廟會等民俗活動的擴音設備或燃放鞭炮吵到居民，可能被罰多少錢？', '300-600',  '600-1,200',  '1,800-2,400',  '3,000-30,000', 4),
(4222,  '初級', '婚喪、廟會活動太吵被開罰單後，下列敘述何者「錯誤」？', '就可以安心繼續吵，不會再被罰', '若沒改善，可能會再被開單', '降低擴音設備的音量',  '停止燃放鞭炮', 1),
(4223,  '中級', '吸音材質的功能是將聲音能量轉換成哪一種能量?', '化學能',  '光能', '機械能',  '熱能', 4),
(4224,  '高級', '測量工廠噪音時，測量位置若在建築物或牆面附近，應距離建物或牆多遠？',  '緊靠牆邊', '距離0.5公尺以上',  '距離1公尺以上',  '距離3公尺以上',  3),
(4225,  '中高級',  '集會活動時擴音設施太吵，應在何處測量噪音是否超標？',  '緊靠擴音設施前方', '在擴音設施後方',  '距擴音設施水平投影距離1公尺處',  '距擴音設施水平投影距離3公尺以上', 4),
(4226,  '初級', '下列何者是噪音對民眾最顯著的影響？',  '煩躁不安', '影響觸覺', '血液不通', '影響視力', 1),
(4227,  '高級', '測量環境噪音時，為避免交通影響，應在離馬路邊多遠處進行測量？', '若路寬小於5米，則在離路邊至少15米處',  '若路寬為8米，則在離路邊至少30米處', '若路寬為12米，則在離路邊至少15米處',  '若路寬為45米，則在離路邊至少50公尺處', 1),
(4228,  '中高級',  '下列何種音源的音量最容易衰減？',  '點音源',  '線音源',  '面音源',  '以上皆是', 1),
(4229,  '中高級',  '尖峰時段的都市道路車輛所產生的噪音，屬於哪一種音源？', '點音源',  '線音源',  '面音源',  '牆音源',  2),
(4230,  '中高級',  '臺灣在營建及工廠噪音管制上，下列何者「錯誤」？',  '分時段有不同管制標準值',  '分管制區有不同管制標準值', '分高低頻有不同管制標準值', '無論時段、管制區或頻率都相同標準', 4),
(4231,  '高級', '寬度在八公尺以上道路之環境噪音監測點，應距離道路邊緣多少公尺以上進行測量？',  '一公尺',  '十公尺',  '十五公尺', '三十公尺', 4),
(4232,  '中級', '若要降低噪音，可用下列何種方式？', '裝吸音材料',  '裝隔音設施',  '把音源換成噪音較小者', '以上皆是', 4),
(4233,  '高級', '道路邊有建築物時，其交通噪音監測點應距離建物牆面多少公尺以上？',  '一公尺',  '十公尺',  '十五公尺', '三十公尺', 1),
(4234,  '中高級',  '噪音計的哪一項加權計算模式，是為了模擬人耳的聽覺？',  'A加權',  'B加權',  'C加權',  'F加權',  1),
(4235,  '初級', '下列何種職業會長期暴露在振動環境中而影響身體的健康？', '清掃工人', '餐廳服務人員', '鑽牆工人', '灑水工人', 3),
(4236,  '高級', '測量機場周圍地區固定式航空噪音的儀器，應該在離地面或樓板至少多少公尺進行測量？',  '1公尺',  '2公尺',  '3公尺',  '4公尺',  3),
(4237,  '中級', '下列何者是長期暴露於振動環境中，對健康造成不良影響？', '痛風', '高血壓',  '心臟病',  '白指病',  4),
(4238,  '中級', '正常耳朵對於哪個頻率的聲音聽的最清楚？',  '500赫', '1,000赫', '2,000赫', '4,000赫', 4),
(4239,  '高級', '測定航空噪音之氣象條件為風速每秒多少公尺以下？',  '五公尺',  '十公尺',  '十五公尺', '二十公尺', 2),
(4240,  '初級', '結婚喜慶所產生的噪音，是屬於哪一類噪音？', '交通噪音', '近鄰噪音', '民俗噪音', '工地噪音', 3),
(4241,  '初級', '家庭式卡拉OK所產生的噪音，是屬於哪一類噪音？',  '交通噪音', '近鄰噪音', '民俗噪音', '群聚噪音', 2),
(4242,  '中級', '以下哪種型態的噪音，較容易造成聽力的受損？',  '低頻率低音量', '低頻率高音量', '高頻率低音量', '高頻率高音量', 4),
(4243,  '中級', '下列何種頻率的聲音，民眾感覺最「不」靈敏？',  '低頻率',  '中頻率',  '中高頻率', '高頻率',  1),
(4244,  '高級', '依據機場周圍地區航空噪音防制法第四條規定，航空噪音防制區可分為幾級?', '2',  '3',  '4',  '5',  2),
(4245,  '中高級',  '聽力檢查室背景音量在2,000Hz時，可容許最大噪音量為多少分貝？',  '37分貝', '47分貝', '57分貝', '67分貝', 2),
(4246,  '初級', '下列何者「不屬於」噪音管制的範圍？',  '機車聲音', '公車聲音', '電視聲音', '昆蟲叫聲', 4),
(4247,  '高級', '一場地原本音量為80分貝，若此時增加另一80分貝之音源，則現場音量變為幾分貝？',  '100分貝',  '160分貝',  '83分貝', '120分貝',  3),
(4248,  '中級', '噪音對於年輕人造成的聽力損失，是由哪個頻率開始影響？', '2,000赫', '4,000赫', '6,000赫', '8,000赫', 2),
(4249,  '中高級',  '下列何種噪音源是最「不容易」取締的？', '建築工地噪音', '擴音器噪音',  '工廠噪音', '道路交通噪音', 4),
(4250,  '高級', '家電產品貼上節能標章圖樣，代表該產品能源效率比國家認證標準高多少？',  '5~10%',  '5~15%',  '10~20%', '10~50%', 4),
(4251,  '中級', '核發節能標章的單位為下列何者？',  '經濟部工業局', '經濟部能源局', '行政院環保署', '各縣市環保局', 2),
(4252,  '中高級',  '請問我國能源效率分級標示分成幾級？',  '3',  '5',  '8',  '10', 2),
(4253,  '初級', '購買具有節能標章的產品(如：變頻冷氣)，長期而言有何好處？',  '節電', '省錢', '減碳', '以上皆是', 4),
(4254,  '中級', '省水標章的右邊三條水帶，代表甚麼意義？',  '愛水、親水、節水', '工業用水、農業用水及商業用水', '河川、湖泊、海洋', '自來水、礦泉水及地下水',  1),
(4255,  '高級', '下列有關藍色水足跡的描述，何者正確？', '產品生產中所產生的蒸散量', '產品生產中消耗的地表水或地下淡水量',  '為稀釋生產中製造污染至標準水質所需要的用水量', '作物和森林成長中所吸收的雨量', 2),
(4256,  '高級', '下列有關灰色水足跡的描述，何者正確？', '產品生產中所產生的蒸散量', '產品生產中消耗的地表水或地下淡水量',  '為稀釋生產中製造污染至標準水質所需要的用水量', '作物和森林成長中所吸收的雨量', 3),
(4257,  '高級', '一般產品若有RoHS標示，代表限制使用下列何種有毒物質？', '鉛',  '銅',  '三價鉻',  '雙酚A',  1),
(4258,  '中高級',  '消費者購買之產品含有RoHS標示，代表產品可免於何種危害？',  '免於溫室效應危害', '可以節約能源', '可以免於鉛、汞等物質之危害',  '免於酸雨之威脅',  3),
(4259,  '初級', '關於綠建材的說明，下列何者「錯誤」？', '對環境無害的建材', '應符合相關規格標準',  '來自原始森林建材', '對人體無害',  3),
(4260,  '中高級',  '1992年國際學術界認為，在以下何種過程中考量對環境負荷最小、對人類身體健康無害之建材，方可稱為「綠建材」？', '原料開採階段', '產品製造階段', '應用過程和使用以後的再生利用循環', '以上皆是', 4),
(4261,  '中級', '下列何者「不是」綠建築的三大設計理念？',  '增加舒適性',  '自然調和健康', '重視環保', '經濟實惠', 4),
(4262,  '中級', '下面有關碳足跡的敘述，何者「錯誤」？', '包含產品整個生命週期', '僅只是二氧化碳排放',  '使用汽油會產生碳足跡', '生活用電會產生碳足跡', 2),
(4263,  '中高級',  '碳足跡是指產品或服務之生命週期過程中，何種污染物之排放總和？', '溫室氣體', '廢棄物',  '廢水污染量',  '以上皆是', 1),
(4264,  '初級', '我國推行碳足跡標章的目的？',  '協助消費者尋找低碳產品',  '協助企業進行減碳', '提升企業競爭力',  '以上皆是', 4),
(4265,  '中級', '消費者應購買何種數值的碳足跡產品以響應減碳？', '低碳足跡排放產品', '高碳足跡排放產品', '不考慮',  '具有碳足跡標章產品',  1),
(4266,  '初級', '下列何者是獲得綠色商店標章的特色之一？',  '商店種很多樹木',  '販售綠色商品', '用綠色商品布置商店',  '販售天然食品', 2),
(4267,  '初級', '國際標準組織(ISO)將綠色商品分為幾大類？', '3',  '4',  '5',  '6',  2),
(4268,  '高級', '下列哪個選項「不屬於」公平正義實質原則？', '同等原則', '需要原則', '貢獻原則', '讓渡原則', 4),
(4269,  '中級', '下列何者為公平貿易標章認證的意義？',  '公平價格', '嚴守聯合國人權憲章',  '保護環境', '以上皆是', 4),
(4270,  '初級', '永續發展由下列何者要素所構成？',  '環境與生態要素',  '社會要素', '經濟要素', '以上皆是', 4),
(4271,  '中級', '「斯德哥爾摩人類環境會議」為世界各國政府共同探討當代環境問題與策略的第一次國際會議，其開幕日演變成現今的「世界環境日」，世界環境日的日期為下列何者？', '6月16日',  '6月5日', '5月5日', '5月16日',  2),
(4272,  '中高級',  '「國家環境保護計畫」於民國87年經行政院核定，計畫列舉之基本理念下列何者為「錯誤」？', '永續發展', '互利共生', '降低城鄉差距', '以上皆非', 3),
(4273,  '初級', '下列何者合乎「環境正義」之理念？', '追求權利平等', '減少弱勢族群受害', '追求環境資源永續經營的思考與行徑', '以上皆是', 4),
(4274,  '中級', '下列選項對於「環境正義」的敘述何者「不正確」？',  '提供公平享用所有資源的管道',  '可以軍事方式占領土地、人民或文化', '政府的環境不正義行為是違反聯合國人權宣言及聯合國種族屠殺會議的行徑',  '保障受害者收到完全的賠償，傷害的修繕以及好的醫療服務', 2),
(4275,  '中級', '永續社會中對於公平正義的追求包含以下哪些重點？',  '保護弱勢群體與團體',  '關注後代子孫福祉', '保障環境人權', '以上皆是', 4),
(4276,  '中高級',  '有關「環境人權」的敘述下列何者正確？', '需落實污染防制與管制', '建構與維護一個健康、安全以及符合生態原則的環境',  '促進環境資訊之公開與易得性',  '以上皆是', 4),
(4277,  '中高級',  '從永續社會的觀點來看，為什麼我們要關注後代子孫福祉？', '確保資源都集中被當代人使用',  '後代子孫應對污染負責', '發展經濟為最優先才能留好的財產給後代', '確保世代間正義的落實', 4),
(4278,  '中級', '1987年聯合國提出《我們的未來》報告書，其中指出「永續發展」的理念是？', '完全禁用氟氯碳化物',  '滿足當代需求，且不損及後代滿足其需要之發展',  '2008~2012年達到二氧化碳減量5~8%', '各國減少硫化物排出量及削減氮氧化物30%', 2),
(4279,  '中級', '永續發展之意義為追求三向度之平衡，下列何者「不是」三向度之一？',  '環境保護', '資訊融合', '經濟發展', '社會公平', 2),
(4280,  '中級', '下列何者「不符合」永續發展的理念？',  '建置河濱公園', '設置公車專用道',  '將核廢料丟棄到海中',  '搭乘大眾運輸工具', 3),
(4281,  '中級', '下列何者「不是」環境權的特質？',  '國民共有', '後代子孫共享', '治療重於預防', '跨國界',  3),
(4282,  '中高級',  '企業為維護環境的公平正義，下列何者敘述「錯誤」？', '優先考量成本', '建立綠色生產', '使用綠色設計', '進行生命週期評估', 1),
(4283,  '中高級',  '政府徵收水權費是符合下列哪個選項？',  '受益者付費',  '污染者付費',  '是一種排放稅', '是一種污染稅', 1),
(4284,  '初級', '下列何者「不是」綠色產品？',  '無磷清洗劑',  '高級汽油', '再生紙',  '不含氟氯碳化物之氣膠', 2),
(4285,  '中高級',  '依據環境基本法，下列何者為「永續發展」之定義？',  '滿足當代需求，同時不損及後代滿足其需要之發展', '滿足當代需求，後代之發展不需納入評估', '節制現代的發展，以滿足後代需求',  '滿足後代需求，當代無需發展',  1),
(4286,  '初級', '《環境基本法》說明「基於國家長期利益，經濟、科技及社會發展均應兼顧環境保護」，但以下列何者為優先考量？',  '科技', '經濟', '環境', '社會', 3),
(4287,  '中級', '為維護環境公平與正義，下列何者行為較「不正確」？', '進行綠色消費', '大量使用非再生能源',  '選擇公平貿易商品', '確保生物多樣性',  2),
(4288,  '中級', '1972年6月聯合國舉行「人類環境會議」，會中通過「聯合國人類環境會議宣言」，其「聯合國人類環境會議宣言」又稱為下列何者？',  '世界自然憲章', '森林原則', '斯德哥爾摩宣言',  '里約宣言', 3),
(4289,  '中級', '依照「聯合國人類環境宣言」原則，下列敘述何者「錯誤」？',  '各國有按自己的環境政策開發自己資源的主權', '地球上的自然資源必須適當管理', '應該支持各國人民反對污染的正義鬥爭',  '經濟及社會發展的考量是不必要的',  4),
(4290,  '中級', '關於「環境公平」的理念，下列何者「不正確」？', '受到影響的居民有適當機會參與決定對環境或健康有影響的計劃', '決策程序尊重所有參與者的意見', '公眾意見無法影響監管部門的決定',  '決策者應主動徵求可能受影響者的意見',  3),
(4291,  '初級', '我們該如何減少環境公害？', '協助監督和陳情，促使政府改善環境', '考取公職，成為環保署的一員',  '降低罰款', '協助隱瞞實情，讓公害陳情量減少，減低公害陳情案件', 4),
(4292,  '中高級',  '西元1992年聯合國於巴西里約召開「地球高峰會」，提出的「二十一世紀議程」呼籲各國制訂下列何者政策？', '資源保護', '濕地保育', '貿易協定', '永續發展', 4),
(4293,  '中高級',  '下列何者行為是環境影響評估的法定程序？',  '公開說明會',  '公民投票', '公開招標', '公民審核', 1),
(4294,  '中級', '下列何者「不是」環境公平正義所探討的範圍？',  '醫療', '文化', '安全', '生產', 4),
(4295,  '中級', '下列何者「不是」建立環境公平正義的理由？', '提供安全無懼的環境',  '建立無虞之生活',  '提高個人利益所得', '保障健康無憂', 3),
(4296,  '中級', '為落實公平正義，政府對於排放污染的業者所實行的措施，下列何者為正確？', '污染費徵收',  '污染防治法令之建立',  '公害賠償法之建立', '以上皆是', 4),
(4297,  '高級', '依照1991年有色人種環境高峰會，下列何者「不屬於」環境不正義之類屬？',  '程序性不正義', '地理性不正義', '心理性不正義', '社會性不正義', 3),
(4298,  '中高級',  '「環境知情權」指的是什麼？',  '公民有知曉環境資源生態狀況的權利', '公民有參與環境保護的權利', '公民有要求享受優良環境的權利', '公民有知曉環境發展技術和資源的權利',  1),
(4299,  '高級', '《斯德哥爾摩公約》的主要目的為何？',  '溫室氣體', '保護瀕臨絕種生物', '禁用或限制生產持久性有機污染物',  '永續發展', 3),
(4300,  '初級', '下列何者為開採砂石時未做好水土保持可能造成的影響？',  '地層下陷', '加劇溫室效應', '空氣污染', '土石流危機',  4),
(4301,  '中高級',  '擬開發地區經調查後發現土壤已受嚴重污染，需要作何處理始能提出開發案？', '等開發案通過後再提出污染整治計畫', '將來一邊開發一邊整治', '先將污染區整治後再提出開發案', '可以不必理會土壤污染', 3),
(4302,  '中高級',  '下列何項行為需進行環境影響評估？', '新北市三重區設立5公頃新公園', '臺北淡水河邊舉行國慶煙火秀活動',  '中部海域設立50座風力發電機組',  '在社區公園舉辦大型運動會', 3),
(4303,  '高級', '下列何項「不需」進行環境影響評估？',  '義大世界遊樂區',  '臺北小巨蛋改建工程',  '高速鐵路工程', '新竹科學園區廢水排入宵裡溪計畫',  2),
(4304,  '高級', '下列地區哪一項「不屬於」環境影響評估中之敏感點？', '國民小學', '30棟建築之大社區',  '運動公園', '私人大農場',  4),
(4305,  '高級', '高爾夫球場開發後之廢污水排放於地面水體時，應依據何標準排放？', '灌溉水標準',  '放流水標準',  '承受水體水質標準', '一般河川水質標準', 2),
(4306,  '高級', '下列何者「不是」環境涵容能力之評估項目？', '空氣與水體',  '土壤與廢棄物', '噪音', '交通流量', 4),
(4307,  '高級', '下?何者?在「環境影響?明書」的報告範圍？',  '環境現況', '開發?為之目的',  '可能引起之環境影響',  '當地居民意?之處?',  4),
(4308,  '中高級',  '懸浮微粒進入人體呼吸道的沉積位置與下列何項因素有關？', '氣動粒徑大小', '風速', '微粒濃度', '年齡層',  1),
(4309,  '中高級',  '空氣動力直徑在',  '1μm',  '以下的微粒主要沉積在人體的哪一個部位？',  '眼睛', '口鼻', 0),
(4310,  '中高級',  '空氣污染指標中的懸浮微粒(PM10)，其數字10代表的意思為何？', '10種化學物質',  '每10小時測量一次',  '氣動粒徑小於\n10μm 之粒狀物',  '其單位以毫米計算', 3),
(4311,  '中高級',  '持久性有機污染物經由蒸發或風力影響不斷釋放至大氣中，並沉積在遠離其排放地點的地區。這是屬於哪一種效應？',  '比馬龍效應',  '蝴蝶效應', '蚱蜢效應', '寒蟬效應', 3),
(4312,  '中級', '下?傳染病與相對應的昆蟲病媒，何者「錯誤」？', '鼠疫-跳蚤',  '瘧疾-瘧蚊',  '登革熱-蚊子', '萊姆病-蒼蠅', 4),
(4313,  '中高級',  '空氣污染物中的一氧化碳對人體健康造成危害之主要原因在於？', '一氧化碳比空氣輕', '一氧化碳對血紅素的親和力比氧氣大得多', '一氧化碳為不完全燃燒產物', '一氧化碳可再燃燒', 2),
(4314,  '中級', '根據氣象學的定義，當能見度低於多少距離者，定義為「沙塵暴」？', '100公尺',  '500公尺',  '1,000公尺',  '3,000公尺',  3),
(4315,  '高級', '下列哪一項為臺灣地區採用的河川污染程度指標？', '水質指數', '河川污染程度指數', '水質飽和指數', '卡爾森指數',  2),
(4316,  '初級', '洗衣機使用橡皮管接水時，橡皮管如浸在水中，易產生二次污染。何種作用讓洗衣機水槽內的污水．被吸入自來水管線中，因而污染了自來水？',  '擴散作用', '滲透作用', '虹吸作用', '水錘作用', 3),
(4317,  '初級', '大氣層中的臭氧層，為何具有保護地球表面生物的作用？',  '因臭氧氧化力強',  '因臭氧可分解有機污染物',  '因臭氧具吸收紫外線的作用', '因臭氧可殺菌', 3),
(4318,  '高級', '當有機物含有下列哪一項元素時，其燃燒後生成戴奧辛的機會較高？', '鈉',  '氯',  '鉛',  '鎘',  2),
(4319,  '初級', '臺灣地區溫室氣體的總排放量，以哪一種溫室氣體排放量最大？', '二氧化碳', '氧化亞氮', '六氟化硫', '甲烷', 1),
(4320,  '初級', '目前世界衛生組織中所定義的「細懸浮微粒」，係指空氣中的哪一項污染物？', 'PM1.0',  'PM2.5',  'PM10', 'TSP',  2),
(4321,  '中級', '根據統計，臺灣地區民國100年垃圾回收率為多少？', '32.2%',  '42.2%',  '52.2%',  '62.2%',  3),
(4322,  '中高級',  '根據統計，民國100年臺灣地區平均每萬人所擁有的自行車道長度為多少公里?', '0.48公里', '0.98公里', '1.48公里', '1.98公里', 2),
(4323,  '中級', '臺灣地區之大氣空氣品質指標為何？', 'WQI',  'PSI',  'CSCI', 'RPI',  2),
(4324,  '中級', '根據統計資料，臺灣地區最容易遭受大陸沙塵暴影響的季節是？', '春季', '夏季', '秋季', '冬季', 1),
(4325,  '中級', '環保署針對地下水監測井的水質檢測，其例行監測每隔多久一次？',  '每週一次', '每月一次', '每季一次', '每年一次', 3),
(4326,  '初級', '一般狀態下，下列何者是中性水的酸鹼值？',  'pH為3', 'pH為5', 'pH為7', 'pH為9', 3),
(4327,  '中級', '下列何者對於紫外線的描述「錯誤」？',  '雲層越厚紫外線愈難穿透',  '紫外線波長最短',  '紫外線的強弱與太陽照射有關',  '俞靠近赤道紫外指數越高',  2),
(4328,  '中級', '臭氧具有強氧化能力，暴露高臭氧環境中對人體健康具危害性，其危害主要在人體哪一個部分？', '呼吸器官', '消化器官', '神經系統', '生殖系統', 1),
(4329,  '中級', '產品碳足跡之評估結果，一般以下列哪一種化學物質的釋放量為計算基準？',  '甲烷', '二氧化碳', '元素碳',  '有機碳',  2),
(4330,  '中高級',  '當大氣空氣品質之PSI指標高於多少時，即代表空氣品質對健康的影響為「有害」？', '高於200',  '高於250',  '高於300',  '高於350',  3),
(4331,  '中高級',  '經光化學反應所產生的微粒狀物質，其能夠懸浮於空氣中，並造成視程障礙者，稱之為什麼？',  '光化學霧', '二氧化碳', '鹽酸', '總懸浮微粒',  1),
(4332,  '中高級',  '下列哪一項指標為臺灣地區水庫水質優養化程度指標？', 'RPI',  'CPI',  'CTSI', 'WQI',  3),
(4333,  '高級', '環保署針對臺灣地區海域水質的監測，其例行檢測每隔多久1次？',  '每月1次', '每季1次', '每半年1次',  '每年1次', 2),
(4334,  '中高級',  '依據我國毒性化學物質分類，若化學物質具有導致腫瘤、生育能力受損等作用者，被歸類為第幾類毒性化學物質？', '第一類毒性化學物質',  '第二類毒性化學物質',  '第三類毒性化學物質',  '第四類毒性化學物質',  2),
(4335,  '中高級',  '會干擾負責維持生物體內恆定、生殖、發育或行為的內生荷爾蒙之外來物質，影響荷爾蒙的合成、分泌、傳輸、結合、作用及排除的化學物，稱之為什麼？', '持久性污染物', '環境荷爾蒙',  '抗生素',  '蓄積性污染物', 2),
(4336,  '中高級',  '地表上哪一種紫外光，具有較高的能量，其對人體健康影響較大？',  'UVA',  'UVB',  'UVC',  'UVI',  2),
(4337,  '中高級',  'PM2.5除了來自於污染源直接排放外，亦可能經由下列哪一項化學反應產生？', '光化反應', '酸鹼反應', '沉澱反應', '光合作用', 1),
(4338,  '中高級',  '所謂「生命週期評估」是對產品系統自原物料的取得到最終處置，其中投入和產出及潛在環境衝擊之彙整與評估，其英文縮寫為？',  'LCA',  'BCA',  'PPCP', 'LOP',  1),
(4339,  '中高級',  '以電力消費評估能源燃燒排放CO2貢獻度來看，下列哪一個部門貢獻比例最大？', '運輸部門', '工業部門', '服務業部門',  '農業部門', 2),
(4340,  '中高級',  '空氣污染物中的二氧化硫，其對生態環境造成什麼主要的危害？', '干擾能見度',  '造成空氣中異味',  '導致酸雨的形成',  '造成土地偏鹼性',  3),
(4341,  '中高級',  '基於污染者付費原則，根據空氣污染物排放量多寡向污染源徵收的費用，稱之為下列何者？', '空氣污染保護費',  '空氣品質污染費',  '空氣資源費',  '空氣污染防制費',  4),
(4342,  '高級', '我國早期染料業使用聯苯胺作為附著基質，導致員工罹癌比例增加，依據毒性化學物質之分類，聯苯胺屬於下列哪一類毒化物？', '第一類毒性化學物質',  '第二類毒性化學物質',  '第三類毒性化學物質',  '第四類毒性化學物質',  2),
(4343,  '高級', '對於一般民眾而言，哪一個光波波長看起來最清晰、舒服？', '254奈米',  '400奈米',  '556奈米',  '700奈米',  3),
(4344,  '高級', '除了揮發性有機物外，下列哪一項化學物質，為都會區大氣中臭氧生成的主要前驅物？', '甲醛', '二氧化碳', '二氧化硫', '氮氧化物', 4),
(4345,  '高級', '一般情況下，下列哪一種魚類的戴奧辛含量較低？', '鮪魚', '鱈魚', '吳郭魚',  '大青花魚', 3),
(4346,  '高級', '《巴賽爾公約》主要管制哪一類污染物？', '一般廢棄物',  '工業廢水', '酸雨', '有害事業廢棄物',  4),
(4347,  '高級', '下列對於家庭污水中之生化需氧量(BOD)、化學需氧量(COD)及總有機碳(TOC)三者關係之敘述，何者為正確？',  '經生物處理後BOD＞COD＞TOC',  '未經處理原水BOD＞COD＞TOC',  '未經處理原水TOC＞COD＞BOD',  '以上皆非', 3),
(4348,  '中高級',  '下列廢水分析之結果，何者最具毒性？',  'BOD/COD=1.0',  'BOD/COD=0.8',  'BOD/COD=0.4',  'BOD/COD=0',  4),
(4349,  '高級', '因職業性引起的帕金森氏症(Parkinsonism)，與下列何種物質的長期暴露最有關？',  '鉛',  '二硫化碳', '錳',  '汞',  3),
(4350,  '高級', '石綿暴露所引起的石綿肺症、肺癌及間皮瘤，通常需要多久以上的暴露史？',  '5年以上', '10年以上',  '15年以上',  '20年以上',  4),
(4351,  '高級', '下?哪一項「?屬於」非游??射？', '紫外光',  'X光', '雷射', '微波', 2),
(4352,  '初級', '在戶外聞到異味，應該如何自保？',  '躲在不通風的地方', '留在現場調查', '保持體力不要移動', '往逆風方向儘速疏散人群',  4),
(4353,  '中級', '電氣用品著火，最「不宜」使用下列何者滅火？',  '乾粉滅火器',  '泡沫滅火器',  '二氧化碳滅火器',  '棉被', 2),
(4354,  '中高級',  '下列何者是2000年版金氏世界紀錄中收錄的最臭物質，由於有強烈氣味，常被加到液化石油氣中，當氣體洩漏時讓人可警覺到，以避免火災和爆炸的發生？', '乙硫醇',  '芥子油',  '臭氧', '硫化氫',  1),
(4355,  '中高級',  '下列哪一個「不是」水在滅火時所產生的滅火作用？',  '冷卻作用', '窒息作用', '抑制作用', '稀釋作用', 4),
(4356,  '高級', '在永續發展的趨勢中，下列何者為企業生產的思考方向，以降低環境衝擊？',  '去物質化', '去毒化',  '去碳化',  '以上皆是', 4),
(4357,  '高級', '對於廢電子電機設備指令(WEEE)的敘述何者正確？',  '產品銷售商應負起電子廢棄產品回收責任', '電子產品製造/供應商負起電子廢棄產品回收及再利用責任', '管制電子產品中有害物質',  '產品上市後三年內提供回收和處理資訊',  2),
(4358,  '中高級',  '下列何者「不是」', '清潔生產的主要方式？', '儘量使用低污染、無污染的原料', '將環境因素納入產品設計中', '在商品使用階段結束後，能夠回收再利用', 0),
(4359,  '中高級',  '下列對於整合性產品政策(IntegratedProductPolicy，IPP)的論述何者「錯誤」？', '降低生產成本', '刺激消費者對綠色產品的需求',  '使用價格機制發展綠色產品', '促成企業供應綠色產品', 1),
(4360,  '中級', '產品生態化設計的生產技術中，下列哪一項的觀念「錯誤」？',  '產生的消耗物減少', '較少的生產步驟',  '大量投入人力', '?少的生產?費',  3),
(4361,  '中高級',  '何者是產品環境化設計應考量的觀點？',  '避免產生有害的廢棄物', '減少因使用產品而排放對環境有害的化學物質', '儘量選擇使用無害的可回收物質', '以上皆是', 4),
(4362,  '中級', '有關清潔生產實現的目的，以下何者較「不正確」？',  '節能', '降低耗損', '增加效率', '機具乾淨', 4),
(4363,  '中高級',  '下列何者對清潔生產的理解是正確？', '清潔生產無非是對過去環保辦法的老調重彈',  '沒有資金，不更換設備，一切都是空談',  '清潔生產應該在企業內部長期、持續的推行下去',  '清潔生產只是強調污染處理', 3),
(4364,  '中高級',  '下列何者為ISO14062環境化設計的核心理念？', '綠色管理', '創新思維', '考慮產品對環境的衝擊', '社會責任', 3),
(4365,  '初級', '下列何者「不屬於」清潔生產內容？', '改進工藝設備、提高產品收率',  '加強管理措施、降低原料損耗',  '使用清潔能源、減少污染排放',  '降低廢水處理效率', 4),
(4366,  '中高級',  '清潔生產主要涵蓋的範圍為何？', '製程', '產品', '服務', '以上皆是', 4),
(4367,  '中高級',  '下列哪一項「不是」清潔生產的主要方法？',  '製程改善', '廢棄資源再利用',  '提升污染防治設備', '產品再設計',  3),
(4368,  '中高級',  '何者「不是」綠色工廠標章的清潔生產範疇？', '辦公室',  '機臺設備', '公用設備', '生產原物料之設備', 1),
(4369,  '初級', '某國家公園承襲了悠遠的閩南文化，近代則有僑鄉文化的注入，人文方面保存了許多寶貴而且耐人尋味的資產，其中鳥類密度更是全臺之冠，此公園為下列何者？',  '臺江國家公園', '金門國家公園', '太魯閣國家公園',  '墾丁國家公園', 2),
(4370,  '初級', '某地為配合保育政策將場區轉型為注重環境保護的生態場域，並引入文化創意產業，將文化、生態與創意三合一，提供民眾認識臺灣林業歷史及生態保存之遊憩教育場所，此地位於下列何處？', '羅東林場', '北門驛與阿里山森林鐵道',  '談文湖鐵道砌石邊坡',  '烏石港舊址',  1),
(4371,  '初級', '番仔井為芝蘭八景之一，譽稱為「番井沸泉」，表現人與自然互動之歷史文化意義，存在長久已超過三百年，見證原民生活遺跡，現為公園泉池景觀，保持良好，此地位於何處？', '臺北市',  '新北市',  '臺南市',  '臺中市',  1),
(4372,  '中級', '關於苗栗縣公館鄉的出磺坑之敘述，下列何者「錯誤」？',  '是全臺灣最古老的油礦', '以硫磺命名',  '由邱苟於1861發現挖掘', '為提煉食用油而開發',  4),
(4373,  '高級', '欲查詢環境影響評估案件的電子檔全文，可利用哪個系統(或網站)查詢？',  '環評開發案論壇',  '環保論壇', '低碳永續家園入口網',  '環境影響評估書件查詢系統', 4),
(4374,  '中高級',  '近年來，在重大發展計畫的環評作業中，開發對於中華白海豚之影響屢次被提及，白海豚調查熱點為何？', '基隆外海', '彰化外海', '高雄外海', '花蓮外海', 2),
(4375,  '高級', '開發單位首次申請許可開發行為時，應向目的事業主管機關提出何種文件？',  '環境影響差異分析報告', '環境影響說明書',  '環境設施變更報告', '環境生態調查書',  2),
(4376,  '中高級',  '生活污水及工業廢水流到海裡，海中浮游生物急遽增加，海水從綠色先轉黃色再變成琥珀色，此現象稱為什麼？',  '赤潮', '黃潮', '黑潮', '綠潮', 1),
(4377,  '中級', '聯合國為呼籲全球關心海洋，決議自2009年起，每年幾月幾日訂為「世界海洋日」？',  '6月8日', '3月8日', '4月22日',  '9月22日',  1),
(4378,  '中高級',  '何種消毒法最廣泛使用，且價格最便宜？', '臭氧消毒', '金屬離子消毒', '氯氣消毒', '紫外線消毒',  3),
(4379,  '中級', '分布於臺灣東部離島，因地勢獨立而保留較完整文化特色的原住民族為何？',  '達悟族',  '阿美族',  '卑南族',  '賽夏族',  1),
(4380,  '高級', '一般高血壓之症狀「不包括」下列何者？', '頭痛、眼花、頭重', '耳鳴、心悸、眼花', '後腰及後頸兩肩痠痛',  '頭重或無症狀', 3),
(4381,  '中高級',  '在職業傷害中，木匠、礦工工人易患何種疾病？',  '塵肺病',  '皮膚炎',  '膀胱癌',  '潛水伕病', 1),
(4382,  '初級', '下列何者是垃圾分類的優點？',  '增加垃圾處理量',  '提高資源回收率',  '增加垃圾處理成本', '縮短焚化爐壽命',  2),
(4383,  '中高級',  '何者「不是」後天免疫缺乏症候群(AIDS)的傳播途徑？\n',  '性行為傳染',  '血液傳染', '共用針頭', '近距離擁抱',  4),
(4384,  '中高級',  '下列何者是造成酸雨的原因？',  '氧氣', '二氧化硫、氮氧化物',  '氫氣', '氯氣', 2),
(4385,  '中高級',  '何者「不是」水污染的污染源？', '畜牧廢水', '垃圾滲出水',  '電解水',  '市鎮廢水', 3),
(4386,  '初級', '下列對於噪音的敘述何者「錯誤」？', '會干擾到睡眠品質', '不會造成聽力的損傷',  '會造成精神不集中', '對妊娠與胎兒發育有影響',  2),
(4387,  '中級', '在職業傷害中，飛機維修者易患何種疾病？',  '聽力損傷', '皮膚炎',  '膀胱癌',  '心臟病',  1),
(4388,  '初級', '下列有關預防食物中毒的敘述，何者「錯誤」？',  '不飲用未煮沸過的水',  '不食用受污染的生魚片', '吃東西前要先洗手', '不會有生命危險',  4),
(4389,  '中高級',  '下列何者「不是」廢污水處理的主要目的？',  '防止土壤受污染',  '防止空氣受污染',  '防止水源被污染',  '防止水生動植物受污染', 2),
(4390,  '初級', '在噪音頻繁的場所中工作易患何種疾病？', '肚子痛',  '皮膚炎',  '聽力損傷', '流鼻水',  3),
(4391,  '中級', '下列有關登革熱的臨床特徵何者正確？',  '?感覺很涼快', '疼痛及倦怠',  '發病第4~5天，白血球會增加', '身體長滿水泡', 2),
(4392,  '初級', '下列關於預防食品中毒的敘述何者正確？', '不要浪費食物，所以過期三天的食物仍然可以吃',  '直接食用未煮熟的食物', '吃東西前先洗手',  '食物有一點點發霉還是繼續吃',  3),
(4393,  '初級', '何者「不是」造成水污染的原因？',  '不亂排放廢水', '工廠亂排放廢水',  '養豬場亂排廢水',  '養雞場亂排廢水',  1),
(4394,  '高級', '政府於民國92年架設第一個光化學測站，目的是要瞭解以下哪一種污染物？', 'PM2.5',  '臭氧', '氮氧化物', '紫外線',  2),
(4395,  '初級', '能見度低於50公尺的強烈沙塵暴，俗稱什麼？',  '黑風', '黃風', '旋風', '暴風', 1),
(4396,  '初級', '何者「不會」造成海洋污染？',  '亂丟垃圾到海洋中', '郵輪翻覆，導致漏油污染',  '不隨意亂丟垃圾到大海中',  '工廠將廢水排放入海',  3),
(4397,  '中級', '下列何者是能見度正確的敘述？', '不能作為空氣品質的指標之一',  '能見度的遠近因個人視力而有所不同', '儀器觀測目標所能看見的最短距離',  '肉眼觀測目標所能看見的最遠距離',  4),
(4398,  '中級', '下列何者並「不是」預防食品中毒的原則？',  '確認食物的有效日期',  '確認食物的新鮮度', '吃未加熱的食物',  '吃東西前先洗手',  3),
(4399,  '高級', '以下何者「不是」政府訂定原住民族基本法的原因？',  '保障原住民族基本權利', '促進原住民族生存發展', '促進原住民可儘快離開原住民保留地發展經濟', '建立共存共榮之族群關係',  3),
(4400,  '中高級',  '以下哪一個民族尚未成為臺灣地區法定的原住民？', '噶瑪蘭族', '雅美族(達悟族)', '西拉雅族', '太魯閣族', 3),
(4401,  '中高級',  '關於原住民族部落的敘述，以下何者是「不正確」的？', '係指原住民於原住民族地區之一定區域內', '依其傳統規範共同生活結合而成之團體',  '具有原住民族服裝特色的團體',  '經中央原住民族主管機關核定者', 3),
(4402,  '高級', '蘭嶼的達悟族發展出建築於坡地的「半穴居」，主要是因為何種原因？',  '因應飛魚文化需求', '為了避免陽光照射', '防颱風',  '建於坡地便於種植水芋', 3),
(4403,  '中級', '針對原住民族教育之權利，以下敘述何者是「不正確」的？', '鼓勵原住民族接受現代化的教育', '本多元、平等之精神',  '尊重保障原住民族教育之權利',  '依原住民族意願決定課程內容',  4),
(4404,  '中高級',  '下列何者「不是」原住民在原住民族地區，可以從事的非營利行為？', '獵捕祭儀用的野生動物', '販賣野生動植物',  '採取礦物、土石做傳統服飾', '利用水資源供自家用',  2),
(4405,  '初級', '以下何種行為違反了《原住民族基本法》的精神？', '發展部落觀光', '為原住民文化拍攝紀錄片',  '破壞原住民族的史前遺址',  '針對原住民族的史前遺址進行考古',  3),
(4406,  '高級', '達悟族依山坡高低向下挖掘的家屋形式為何？', '半穴居',  '窯洞', '三合院',  '地窖', 1),
(4407,  '中級', '達悟族發展出以半穴式主屋為中心的家族生活空間的環境生態意義為何？', '免於洪水氾濫的危害',  '防止春夏間的颱風', '避免野獸的侵襲',  '能夠收集雨水', 2),
(4408,  '高級', '以下哪些原住民保留地內的竹木，「不會」因為維護生態資源，而被限制砍伐？',  '低海拔平地造林區', '位於水庫集水區、溪流水源地帶', '地勢陡峻或土層淺薄復舊造林困難者', '可作為母樹或採種樹者', 1),
(4409,  '中高級',  '以下何者「不是」《原住民族基本法》中關於資源治理的機關？', '文化古蹟', '國家公園', '國家風景特定區',  '林業區',  1),
(4410,  '高級', '位於熱帶地區的達悟族如何降低酷暑時住家之高溫？',  '將部落建築在坡地上，享受季節性的涼風', '儲存冬季山區之積雪，於夏日時取出降溫', '於居家四週灑水，降低環境溫度', '於屋頂開立天窗，增加空氣對流', 1),
(4411,  '高級', '排灣、魯凱、布農族均以「石板屋」為居所，其因素為何？', '因為石板很重，不怕地震的侵襲', '容易取材', '在叢林中成為良好的保護色', '以上皆是', 4),
(4412,  '高級', '布農族八部合音的起源為何？',  '模擬自然界中動物的叫聲，用來吸引獵物', '因住居環境較疏落，用於工作時呼叫同伴溝通之用', '於族群中向異性表達愛意的方式', '於重大慶典時對祖靈表示敬意',  2),
(4413,  '高級', '民國', '96', '年',  '12', '月',  18),
(4414,  '中高級',  '就一般辦公室室內環境而言，其室內二氧化碳的濃度何時較高？', '上午九點', '上午十一點',  '下午三點', '下午下班前',  4),
(4415,  '中高級',  '地表上的太陽光光譜在下列哪一光譜範圍，具有最大的總能量？', '紫外光波段',  '可見光波段',  '紅外光波段',  '微波波段', 2),
(4416,  '中高級',  '下列何者「不是」空氣品質監測站設置的目的？',  '監測空氣污染物的長期趨勢', '判知法規的符合性', '評估對國家經濟的威脅', '評量管制策略的有效性', 3),
(4417,  '中高級',  '將標準濃?之氣體輸入監測設施，?測其檢測?據值與標準濃?值之百分誤差，為下列哪一種測試？', '精密度測試',  '準確度測試',  '偏移度測試',  '穩定性測試',  2),
(4418,  '初級', '《機動車輛停車怠速熄火管理辦法》主要是為了要解決下列何種環境問題的政策？', '行人安全', '石油危機', '交通壅塞', '空氣污染', 4),
(4419,  '中高級',  '高屏地區在秋末冬初期間空氣品質不良，其主要原因為何？', '大環境之氣象因素不利污染物擴散',  '各污染源污染物排放量較大', '汽機車較多',  '時值農作物收穫期', 1),
(4420,  '初級', '懸浮微粒對環境造成什麼影響？', '增加降雨率',  '提高能見度',  '氣候的改變',  '造成河川揚塵', 3),
(4421,  '中級', '下列何者「不是」室內空氣污染源？', '建材', '辦公室事務機', '茶葉渣',  '油漆及塗料',  3),
(4422,  '高級', '空氣品質監測站採樣口位置，應該離地面多少高度為原則？', '1-2公尺',  '2-3公尺',  '3-15公尺', '15-20公尺',  3),
(4423,  '高級', '下列何者是懸浮微粒與落塵的差異？', '採樣地區', '粒徑大小', '分布濃度', '物體顏色', 2),
(4424,  '中級', '下列哪一種作法「不能」有效減少營建工地產生的懸浮微粒？',  '清洗工程車輛輪胎', '用帆布包覆工程材料表面',  '於乾燥天候對道路適度灑水', '使用空氣清淨機',  4),
(4425,  '高級', '下列哪一種紫外光波長最長？',  'UV-A', 'UV-B', 'UV-C', 'UV-D', 1),
(4426,  '中高級',  '根據海域環境分類及海洋環境品質標準，下列哪一類海域環境適合游泳？', '甲類', '乙類', '丙類', '丁類', 1),
(4427,  '中高級',  '根據《海域環境監測及監測站設置辦法》，海域環境應監測之水質項目「不包括」下列哪項？',  '鹽度', '溶氧量',  '懸浮固體', '總磷', 4),
(4428,  '中高級',  '對於海洋污染特性的描述，何者最「不適當」？',  '海洋污染常具持久性',  '海洋污染常具高生物?積性', '海洋污染可能因為生物?積作用，而影響人體健康', '海洋污染常可在短時間內獲得解決',  4),
(4429,  '中高級',  '可能導致「珊瑚白化」的原因，主要與下列哪一種污染行為有關？',  '空氣污染', '溫排水排入導致海水溫度偏高',  '毒魚行為', '任意丟棄廢棄物於海中', 2),
(4430,  '高級', '我國《海洋污染防治法》所謂的「有害物質」，是根據下列哪個單位所認定？', '國科會',  '聯合國國際海事組織(IMO)', '經濟部',  '環保署',  2),
(4431,  '高級', '根據「重大海洋油污染緊急應變計畫」，經研判屬於重大海洋污染應變層次，須成立緊急應變中心時，應由下列哪個政府機關首長擔任召集人？',  '國防部',  '交通部',  '環保署',  '海巡署',  3),
(4432,  '高級', '當發生海域洩油事件時，下列哪一類化學物質，對海洋生物的毒性危害較大？', '較低分子?的碳氫化合物',  '直鏈烷?化合物',  '揮發性有機物', '芳香烴化合物', 4),
(4433,  '中高級',  '「對於不符合空氣污染物標準之區域，進行總容許排放數量的管制」是屬於下列哪一種空氣品質管理措施？',  '排放許可制',  '總量管制', '污染者付費',  '排放標準制',  2),
(4434,  '中高級',  '北部酸雨除本土污染源排放污染物造成之外，還受到下列何者的影響？',  '人口增加', '都市更新', '全球暖化', '境外傳輸', 4),
(4435,  '中高級',  '下列哪一組電話為檢舉烏賊車之免付費環保報案專線？', '(0800)018-111',  '(0800)611-999',  '(0800)066-666',  '(0800)095-110',  3),
(4436,  '高級', '臺灣北部在秋冬季時的酸雨監測較南臺灣高，主要是受到下列何種因素影響？', '盆地效應', '溫度及濕度',  '家庭用電量',  '東北季風', 4),
(4437,  '中高級',  '溫室氣體會造成地球暖化效應，其關鍵原因為何？', '溫室氣體具有毒性', '溫室氣體溫度較高', '溫室氣體會吸收水蒸氣', '溫室氣體可吸收地球長波輻射',  4),
(4438,  '中高級',  '政府為了推廣使用電動機車，實施了何種政策措施？',  '降低車用液化石油氣售價補助',  '立法限制汽機車營運廠商生產量', '臺灣清淨空氣計畫-近程執行方案',  '電動機車電池交換費用補助', 4),
(4439,  '高級', '可以進入人體肺部的懸浮微粒，粒徑大小如何？',  '大於1000微米以上', '大於100微米以上',  '大於10毫米以上', '小於10微米以下', 4),
(4440,  '中高級',  '下列何者「無法」減少室內臭氧的危害？', '更換事務機濾網',  '使用不透光玻璃',  '影印機置於通風處', '距人們至少１公尺處',  2),
(4441,  '中高級',  '對於非因本身動力而改變位置之污染源，被歸類為下列何者？',  '逸散污染源',  '移動污染源',  '固定污染源',  '揮發性污染源', 3),
(4442,  '高級', '下列何者是政府為降低空氣污染所制定的政策？',  '民國87年開始徵收空氣污染防制費', '限制汽車業每年車輛生產量', '限制航空公司飛行總里程數', '針對玻璃業的NOx排放濃度訂定較嚴的管制標準', 4),
(4443,  '中級', '在環保署建置的空氣品質監測網站中，無法查詢下列何種資訊？', '風速', '紫外線',  '細懸浮微粒',  'PSI',  1),
(4444,  '高級', '將區域空氣污染物總容許排放數量，限制其上限值，為下列哪一種空氣品質管制策略？', '排放許可制',  '總量管制', '污染者付費',  '排放標準制',  2),
(4445,  '中高級',  '所謂的大氣逆溫現象係指下列哪一種現象？',  '大氣溫度的垂直分布，隨高度增加而增加', '大氣溫度的垂直分布，隨高度增加而降低', '大氣的雲層高度，隨緯度增加而降低', '大氣的雲層高度，隨緯度增加而降低', 1),
(4446,  '高級', '加油站漏油會造成土壤及地下水污染，可能造成加油站漏油之原因為何？', '油槽至加油島間接頭漏油造成',  '加油島加油不慎漏油',  '油槽至加油島間管線破裂造成漏油',  '以上皆是', 4),
(4447,  '高級', '農田土壤受重金屬污染後會導致許多不良影響，下列何者是臺灣受到最大面積的重金屬污染？',  '鎘',  '鉛',  '砷與汞',  '銅與鋅',  4),
(4448,  '高級', '經地方政府公告之土壤及地下水污染場址，污染業主如何決定使用何種整治技術？', '邀請專業顧問公司調查污染狀況後提出可行技術即可',  '顧問公司提出可行技術後，需經地方環保局專案委員會通過', '顧問公司提出可行技術，需經地方環保局通過且需與地區居民溝通',  '顧問公司提出可行技術後，需經中央環保署委員會通過', 3),
(4449,  '中高級',  '下列何者「不是」以植物處理受污染土壤的優點？', '植物根部可以吸收土壤中的重金屬',  '植物根部有固土作用，能避免污染物擴散', '雖不適用大面積土地，但於面積小的土地上成果極佳',  '植物能累積高含量重金屬之特性', 3),
(4450,  '高級', '一般市區加油站之土壤及地下水污染後，在繼續營業情況下，最常使用之整治技術為何？',  '僅使用土壤氣體抽除法', '僅注入氧氣將油氣氧化掉',  '抽除地下水污染氣油',  '同時使用土壤氣體抽除法與注入氧氣將油氣氧化掉', 4),
(4451,  '高級', '水田土壤受到鎘污染後，如何瞭解污染土壤生長之稻米是否也受到污染？', '可利用科學研究建議之相關模式即可推估', '在污染區採樣並分析生長之混合稻米鎘含量',  '利用水稻品種特性與土壤鎘污染濃度即可推估', '該污染區收獲之所有稻米回收後之鎘含量', 2),
(4452,  '中高級',  '酸性紅壤中，土壤水溶液的何種重金屬濃度可能偏高？', '鐵',  '鉛',  '銅',  '鋅',  1),
(4453,  '中級', '下列何者對於「超級累積植物」的描述是正確的？', '可大範圍分解土壤中的重金屬物', '可吸附重金屬的一種植物',  '只可分解土壤中含鐵物質',  '可吸附土壤中大量的重金屬', 4),
(4454,  '初級', '施灑化學肥料過量而使土壤酸化，將造成什麼影響？',  '農產品帶有濃烈酸味',  '植物生長旺盛', '植物生長受到限制', '加速植物吸收養份', 3),
(4455,  '高級', '下列何者是常見的土壤污染情形？',  '土壤液化', '土壤礦質化',  '土壤有機物含量低', '土壤累積各種毒性物質', 4),
(4456,  '高級', '在1982年至1992年間，地下水污染的整治技術中最常見的是下列何種方式？',  '植物吸附法',  '抽取處理法',  '土壤蒸氣萃取法',  '現地空氣貫入法',  2),
(4457,  '中高級',  '生物通氣整治技術為提供何種物質給土壤中的微生物，以分解有機污染物？',  '氮氣', '氧氣', '土壤碳物質',  '二氧化碳', 2),
(4458,  '中高級',  '下列何者「不是」造成土壤酸化的原因？', '土壤長期被荒廢',  '酸雨導致土壤酸化', '酸性母質的影響',  '酸性化學肥料的使用',  1),
(4459,  '高級', '民國83年，臺灣美國無線電公司(RCA)桃園廠污染廠區土壤及地下水，主要污染物是以下哪種元素之有機化合物？',  '砷',  '鎘',  '氯',  '汞',  3),
(4460,  '高級', '下列何項開發行為「不需要」進行環境影響評估？', '蘇花公路沿線拓寬工程', '中山高速公路五股至楊梅段拓寬公程', '中部海域設立50座風力發電機組',  '在臺北市總統府前辦國慶大型活動',  4),
(4461,  '中級', '哪一種疾病「不是」由輻射污染所引起？', '白血病',  '癌症', '愛滋病',  '白內障',  3),
(4462,  '中級', '「食物從生產地到消費者的餐桌所經過的運輸距離。」所稱為何？',  '消費里程', '食物里程', '生產里程', '交通里程', 2),
(4463,  '高級', '某公司於山區提出開採礦石大型計畫，面積廣達50公頃，下列哪個選項「不是」用來判斷環境是否適宜開發的考慮要項？', '水土保持工程及設施是否規劃完整',  '可協助當地居民增加多少就業機會及社會經濟產值', '開採之挖方與填方如何平衡與利用',  '開礦過程中生態復育計畫及礦石外運之影響評估',  2),
(4464,  '中級', '長期遭受輻射污染容易引發下列何種疾病？',  '高血壓',  '心臟病',  '糖尿病',  '癌症', 4),
(4465,  '初級', '下列哪一種污染物人體接觸後最容易導致癌症？',  '一氧化碳', '甲烷', '甲醇', '黃麴毒素', 4),
(4466,  '中高級',  '在工程或開發行為進行中，發現具古蹟價值之建造物時，應該怎麼做？',  '即刻停止工程', '將現場恢復原狀',  '繞過本區，繼續施工',  '報備後，繼續施工', 1),
(4467,  '高級', '下列何者為進入古蹟指定審查程序？', '指定古蹟', '準定古蹟', '暫定古蹟', '標定古蹟', 3),
(4468,  '高級', '下列哪個被指定的文化資產「聚落」不在外島？',  '花宅聚落', '津沙聚落', '瓊林聚落', '五溝水聚落',  4),
(4469,  '高級', '農林漁牧為人類社會重要生產基礎，下列何者「不是」已被登錄的農林漁牧文化景觀？', '臺北市「八芝蘭番仔井?',  '澎湖七美「雙心石滬?', '嘉義「北門驛(一ˋ)?',  '與阿里山森林鐵道', 0),
(4470,  '中級', '下列何者是魯凱族狩獵的規定？', '主要以獵殺小動物為主', '獅子為神聖的動物，不可狩獵',  '熊雖然可以獵殺，但是會引來疾病的報應', '狩獵的季節集中在夏季', 3),
(4471,  '中高級',  '臺灣地區的原住民族可以自治嗎？',  '不可以，這是搞國家分裂',  '不可以，最大族漢人都不能獨立自治', '不可以，大陸反對', '可以，但要依各原住民族意願決定',  4),
(4472,  '高級', '關於原住民族自治發展的法令中，以下何者是「不正確」的？',  '財務也要自治', '國家提供充分資源，每年寬列預算協助',  '自治權限及財政，準用地方制度法、財政收支劃分法',  '政府與原住民族自治間權限發生爭議時，由總統府召開協商會議決定之',  1),
(4473,  '中高級',  '由於飛魚會隨著黑潮洄游到蘭嶼的海域，達悟族人約於每年的幾月舉行招魚祭？',  '3',  '6',  '9',  '12', 1),
(4474,  '中級', '源自於原住民智慧，便於攜帶的食物為何？',  '米糕', '便當', '竹筒飯',  '麵包', 3),
(4475,  '初級', '排灣族的傳統建築包含了精緻的石板屋及木製雕刻，其規格及圖紋具有哪些意涵？', '社會階層的區分',  '藝術的表現',  '特殊身分的象徵',  '以上皆是', 4),
(4476,  '中級', '臺灣原住民中唯一擁有自己文字的種族為何？', '達悟族',  '阿美族',  '布農族',  '泰雅族',  3),
(4477,  '初級', '泰雅族人放棄原有部落而遷徙的原因為何？',  '避開洪水侵襲', '便於狩獵', '解決耕地問題', '以上皆是', 4),
(4478,  '高級', '以下哪些原住民保留地內的竹木，「不會」因為維護生態資源及國土保安而限制砍伐？', '伐木後，土壤易被沖蝕', '經認定非需加強保育者', '位於河岸沖蝕地帶、海岸衝風地帶',  '位於景觀名勝古蹟區域內',  2),
(4479,  '高級', '以下關於公聽會、部落會議之召開，何者是不正確的？', '當地原住民族之部落未於第一項規定期間內召開部落會議議決者，當地鄉(鎮、市)公所應於三十日內召集之', '當地鄉(鎮、市)公所應於三十日內召集部落會議議決者，縣原住民委員會應於六十日內召集',  '部落會議之召集方式、議事程序及議決方法，由中央原住民族主管機關定之',  '中央目的事業主管機關得委託當地縣(市)政府舉行前項之公聽會',  2),
(4480,  '高級', '以下何者「不是」當地原住民族可以向中央目的事業主管機關申請變更或撤銷公告之部落會議議決結果的條件？',  '部落會議之議決結果與事實不符', '部落會議召集方式不符合規定',  '部落會議議事程序或議決方式不符合規定', '部落會議參與人員人數不足或不具代表性', 4),
(4481,  '中級', '以下何者已被國際癌症研究機構(IARC)訂為確認的人?致癌物？',  '甲苯', '石綿', '三氯乙烯', '鉛粉塵',  2),
(4482,  '中高級',  '下列環境暴露因子中，何者較「不易」引起氣喘症？',  '動物化皮毛',  '花粉', '鉛',  '二異氰酸甲苯(TDI)',  3),
(4483,  '高級', '勞工工作環境依「缺氧症預防規則」規定，缺氧係指空氣中氧氣含?未滿多少%？', '2%', '8%', '18%',  '28%',  3),
(4484,  '初級', '下列何者是我國現行的主要職業安全衛生法令？',  '勞動基準法',  '職業安全衛生法',  '勞工保護法',  '勞工安全衛生法',  2),
(4485,  '中高級',  '預防職業病之計畫中，下列何者應列為優先？', '提供勞工安全護具', '提供員工最好的保險',  '定期進行工作環境測定，並改善污染源',  '加強緊急事故處理能力', 3),
(4486,  '中級', '勞工一天工作8小時，「噪音音壓級」「不宜」超過幾分貝？',  '70分貝', '80分貝', '90分貝', '100分貝',  3),
(4487,  '高級', '可燃性金屬，如鉀、鈉等引起的火災，是屬於哪一類火災？', 'A類', 'B類', 'C類', 'D類', 4),
(4488,  '中級', '長時間使用電腦玩線上遊戲而引起的腕隧道症候群，是屬於哪種類型的危害？', '化學性危害',  '物理性危害',  '心理性危害',  '人體工學性危害',  4),
(4489,  '中級', '在工作現場中詳列使用化學物質之安全衛生相關資料(如密度、成份、可能之危害性等)為下列何者？',  '危險物及有害物通識規則',  '容器標示', '化學物質清單', '物質安全資料表',  4),
(4490,  '高級', '關於環境危害配對，下列何者正確？', '過敏—物理性危害', '振動—生物性危害', '噪音—生物性危害', '游離輻射—物理性危害', 4),
(4491,  '中級', '在勞動時大量出汗，鹽份亦會同時損耗，若只補充水份容易引起肌肉抽搐疼痛。此為何種熱危害症狀？',  '熱中暑',  '熱痙攣',  '熱衰竭',  '心臟衰竭', 2),
(4492,  '中高級',  '下列何種作業「不是」屬於「特別危害健康」之作業？', '游離輻射作業', '異常氣壓', '精密作業', '高溫作業', 3),
(4493,  '中級', '勞工常見的白指病，是屬於哪種類型的危害？', '物理性危害',  '化學性危害',  '人因性危害',  '心理性危害',  1),
(4494,  '高級', '美國ACGIH工作場所中鉛的暴露生物暴露指標，ACGIH建議量測生物檢體內何種物質的鉛濃度？', '毛髮', '指甲', '血液', '尿液', 3),
(4495,  '中高級',  '長時間暴露於下列何種物質，可能造成多發性神經炎？', '鉛',  '正己烷',  '有機磷',  '錳',  2),
(4496,  '高級', '下列哪一種游離輻射線的穿透力最弱？',  'α粒子',  'β粒子',  'γ射線',  'X射線',  1),
(4497,  '中級', '職業性暴露於下列哪一種元素，可能引起巴?森氏症候群？', '鉛',  '汞',  '錳',  '砷',  3),
(4498,  '中級', '下背痛、頸肩酸痛、腕隧道症候群與下列工作場所中的哪一種有害因子關係密切？', '物理性危害',  '人因性危害',  '心理性危害',  '生物性危害',  2),
(4499,  '中高級',  '在下列哪一種環境中工作，最容易造成「潛水伕病」？', '在船上的時間過長', '當環境的水流速度過快', '當環境的氧氣含量過高', '當環境的壓力改變過快', 4),
(4500,  '中級', '檢查瓦斯漏氣的方法，下列何者正確？',  '開燈查看', '用耳朵聽', '用點火槍測試', '塗抹肥皂水',  4),
(4501,  '高級', '作業場所測得之噪音音壓級為95dBA，該場所依「勞工安全衛生設施規則」之規定，勞工工作日容許暴露時間為多少小時？', '1小時',  '2小時',  '4小時',  '8小時',  3),
(4502,  '高級', '下列何者「不是」鉛的健康危害？',  '貧血', '腎臟危害', '腕垂症',  '心臟疾病', 4),
(4503,  '高級', '暴露於下列何種物質會引起肝管肉瘤？',  '二硫化碳', '二氧化碳', '氯乙烯單體',  '聚氯乙烯', 3),
(4504,  '中高級',  '下列何者「不是」屬於單純窒息劑？', '氮',  '甲烷', '二氧化碳', '一氧化碳', 4),
(4505,  '中高級',  '下列何種物質使用於嫘縈（rayon）製造，若人體接觸後，易造成中樞神經系統病變？', '二硫化碳', '正己烷',  '丙烯醯胺', '錳',  1),
(4506,  '中級', '依《勞工安全衛生法》，下列何者應負責宣導有關安全衛生之規定？', '各級主管單位', '雇主', '負責人',  '法人代表', 2),
(4507,  '初級', '目前臺灣小學生人數增長的趨勢為何？',  '逐年上升', '逐年下降', '持平', '升降持續波動', 2),
(4508,  '中高級',  '有關臺灣的人口老化問題，以下何者「錯誤」？',  '冷戰後出生的嬰兒潮世代占老化人口的最大比例',  '老年人口迅速增長', '應重視高齡化世界的發展',  '應增進老年期的健康與幸福安寧', 1),
(4509,  '中高級',  '有關空氣污染之敘述，下列何者「錯誤」？',  '空氣污染會增加人們呼吸系統感染疾病的風險', '空氣污染會增加兒童氣喘死亡率的風險',  '只有長期暴露在空氣污染物中才對健康有影響', '空氣污染會增加人們心臟疾病的風險', 3),
(4510,  '中高級',  '有關菸煙之敘述，下列何者「錯誤」？',  '菸煙的暴露沒有安全值', '菸煙裡沒有致癌物', '菸煙裡有超過4000種化學物質',  '二手菸可能令嬰兒猝死', 2),
(4511,  '中高級',  '有關吸二手菸之敘述，下列何者「錯誤」？',  '懷孕婦女吸入二手菸將導致新生兒出生時體重過低', '根據世界衛生組織統計，兒童死亡的原因中，肇因於二手菸約為5%', '二手菸導致成人嚴重的心血管系統疾病',  '二手菸造成成人嚴重的呼吸系統疾病', 2),
(4512,  '中高級',  '有關食品安全之敘述，下列何者「錯誤」？',  '保持乾淨', '生熟食一同處理',  '食物充分煮熟', '將食物保持在安全的溫度',  2),
(4513,  '中高級',  '早期臺灣烏腳病案例常出現在哪一地區？', '臺灣北部城市', '臺灣南部山區', '臺灣東部部落', '臺灣西南沿岸', 4),
(4514,  '中高級',  '關於接種B型肝炎疫苗的敘述，下列何者「錯誤」？',  '接種B型肝炎疫苗用來預防肝炎', '接種B型肝炎疫苗用來預防肝癌', 'B型肝炎經由食物傳染', 'B型肝炎病毒慢性帶原者常無症狀或只出現容易疲累和倦怠等情形',  3),
(4515,  '高級', '關於我國人口健康相關的趨勢，下列哪個選項「錯誤」？',  '標準化死亡率呈下降的趨勢', '平均餘命呈上升趨勢',  '出生率呈上升趨勢', '人口老化趨勢', 3),
(4516,  '高級', '臺灣早期烏腳病的盛行率與居民飲水習慣有關，根據統計，以下何者最容易罹患烏腳病？',  '只用深井水者', '併用深井水和淺井水者', '只用淺井水者', '用河水者', 1),
(4517,  '高級', '2013年人類感染A型流行性感冒(H7N9)的敘述，下列何者「錯誤」？',  '中國通報案例前未有人類感染個案',  '感染A型流行性感冒(H7N9)的主要症狀是腸胃炎', '活禽是人類感染H7N9的源頭之一', 'H1N1,H5N1,和H7N9三者皆是A型流行性感冒病毒', 2),
(4518,  '高級', '為什麼嚼檳榔容易罹患癌症？',  '口腔黏膜和檳榔塊中的生物鹼及亞硝基安化合物接觸',  '石灰會使口腔環境變成酸性並釋放出一些游離基，造成細胞病變', '牙髓膜和黃樟素接觸，產生化學性刺激的致癌物質', '細胞分解膠原蛋白質的能力下降', 1),
(4519,  '中級', '下列有關石綿的?述，何者「錯誤」？',  '是公告的致癌物',  '我國已大部分禁用', '纖維狀石綿釋出，會影響人體健康',  '可以防火，應大量使用', 4),
(4520,  '初級', '能源效率分成5個等級，其中最省電的為哪一級？', '第1級',  '第2級',  '第3級',  '第4級',  1),
(4521,  '中級', '在同樣的冷房能力下，有不同EER值的冷氣，其耗電量最少的是下列何者？', 'EER=1.2',  'EER=2.2',  'EER=3.4',  'EER=4.3',  4),
(4522,  '中級', '我國現有家庭用電費率狀況，下列何者「錯誤」？', '採累進費率制', '與營業電價相同',  '分夏月及非夏月',  '有省電?勵措施',  2),
(4523,  '初級', '關於我國家庭用電事項，下列何者正確？', '每個月收電費一次', '平均約30天抄表一次', '夏月用電累進費率較高', '非夏月用電累進費率較高',  3),
(4524,  '中高級',  '下列何者列入我國再生能源?勵的項目？', '太陽能',  '潮汐發電', '地熱發電', '以上皆是', 4),
(4525,  '中級', '以下何者為低碳、低污染之發電方式？',  '地熱發電', '火力發電', '燃煤發電', '燃油發電', 1),
(4526,  '中高級',  '在加油站加油時若採用B2柴油，其中「B」代表生質柴油，而「2」代表意義為何？', '柴油中生質柴油佔0.2%', '柴油中生質柴油佔2%', '柴油中生質柴油佔20%',  '柴油中生質柴油佔98%',  2),
(4527,  '中級', '政府推動的「陽光屋頂百萬座」計畫是要作什麼？', '家戶在屋頂設置日光浴場所', '家戶屋頂都裝透明玻璃讓陽光曬入',  '家戶普及設置屋頂型太陽光電系統',  '家戶都裝太陽色的日光燈管', 3),
(4528,  '中級', '空氣中若一氧化碳濃度過高，對人類造成的影響為何？', '吸多會過於興奮',  '皮膚會有過敏反應', '因缺氧導致昏迷',  '會因情緒煩躁而有暴力傾向', 3),
(4529,  '初級', '民眾如果想要查詢當日空氣品質，可於下列何處取得資訊？', '教育局',  '環保署',  '農委會',  '地政局',  2),
(4530,  '中級', '下列哪一種活動會導致一氧化碳的產生？', '開車上班', '使用電器', '亂倒垃圾', '農地耕作', 1),
(4531,  '中高級',  '環保署為了提早掌握從中國西北及華北的沙塵暴，於民國88年起在下列何處增置空氣品質監測站？', '金門', '馬祖', '臺北', '澎湖', 2),
(4532,  '中級', '吸菸會釋放下列何種物質？', '焦油', '二氧化碳', '懸浮微粒', '以上皆是', 4),
(4533,  '中高級',  '減少二氧化硫的產生方式為何？', '使用煤炭作為燃料', '使用更高的煙囪',  '將廢氣通過除塵網', '使用石灰過濾廢氣', 4),
(4534,  '初級', '出廠五年機車應每年進行定檢，若檢驗「不合格」應如何處理？', '直接丟棄', '不理它照樣騎', '以不當手法將檢驗結果改成合格', '應於一個月內修復並複驗合格',  4),
(4535,  '中高級',  '下列哪一個是對於氮氧化物正確的敘述？', '包括一氧化氮(NO)及二氧化氮(NO2)', '二氧化氮為無色無味氣體',  '一氧化氮為具刺激味道之赤褐色氣體', '來自石化等燃料之不完全燃燒產生',  1),
(4536,  '中級', '機車出廠滿五年每年應做一次排氣定檢，民眾可至以下何處辦理定檢？',  '經環保局認可委託之定檢站', '所有機車行均可',  '環保署辦公室', '縣市環保局',  1),
(4537,  '中級', '過去汽油中加入含量之四乙基鉛，是因為要提高汽油的什麼數值當做抗震劑？', '辛烷值',  '乙烯值',  '甲醇值',  '丙酮值',  1),
(4538,  '高級', '對於臭氧的敘述，下列何者是正確的？',  '可以用來呼吸的氣體',  '由硫氧化物與揮發性有機物反應而成', '於空氣中直接排放', '空氣品質監測污染指標之一', 4),
(4539,  '中級', '對於二氧化氮的敘述，下列何者正確？',  '具刺激味道之無色氣體', '是造成雨水酸化原因之一',  '不溶於水', '對血紅素的親和力比氧氣大得多', 2),
(4540,  '中級', '阿里山發生酸雨機率遠小於都會地區，其主要原因為何？',  '都會地區地面透水性較差',  '都會地區房子較多', '都會地區人口較集中',  '都會地區汽機車及工廠較多', 4),
(4541,  '中高級',  '為維持汽油中的辛烷值，人們會用以下何種物質來代替四乙基鉛？',  '環丙烷',  '硫化甲基', '含氧物質', '三氯乙烷', 3),
(4542,  '中級', '酸雨對湖泊或水的生態系造成影響，以下原因何者「錯誤」？',  '會妨礙魚吸取水中氧氣的能力',  '會破壞維持生命的鹽分和營養物平衡狀態', '魚兒因受到酸雨刺激，不停游來游去', '酸鹼值改變，使魚群生活的鹽層如鈣離子無法維持', 3),
(4543,  '高級', '下列何者是使用生質柴油的優點？',  '加油站設置專用設備即可提供加油',  '修改引擎即可使用生質柴油', '對溫室氣體減量有幫助', '閃火點較柴油低',  3),
(4544,  '高級', '在加油站販賣E3酒精汽油，其中E3是表示？',  '在一般無鉛汽油中添加0.3%生質酒精', '在一般無鉛汽油中添加3%生質酒精', '在一般無鉛汽油中添加13%生質酒精',  '在一般無鉛汽油中添加30%生質酒精',  2),
(4545,  '中高級',  '我國移動污染源空污費，其徵收方式是下列哪一種？',  '隨車徵收', '隨人徵收', '隨油徵收', '隨保險徵收',  3),
(4546,  '中高級',  '若要減少車輛爆震現象，下列何種做法有效？', '可改用辛烷值較低汽油', '可改用辛烷值較高汽油', '不用改，辛烷值維持原樣',  '在引擎內加水', 2),
(4547,  '中級', '下列哪一個「不是」對於二氧化硫正確的敘述？',  '與水反應為硫酸鹽', '具刺激臭味',  '空氣污染指標之一', '酸雨的主要物質',  1),
(4548,  '中高級',  '粒徑小於2.5微米之粒狀空氣污染物容易藉由呼吸進入人體哪一個部位？',  '口腔', '肺部', '鼻腔', '胃部', 2),
(4549,  '中高級',  '我們使用電動刮鬍刀時，附近電磁場狀況如何？',  '不會產生電磁場',  '其電磁場平均比電視為高，依廠牌不同而異',  '會產生非常低的電磁場，是所有家用電器最低者',  '以上皆非', 2),
(4550,  '初級', '使用家用電器時，其附近電磁場狀況下列敘述何者正確？',  '距離電器愈遠電磁波愈低',  '距離電器愈近電磁波愈低',  '無論任何距離都無電磁波',  '電磁波之高低與距離無關',  1),
(4551,  '中級', '下列有關電磁場的敘述何者正確？',  '電場大小與電壓、距離無關', '電場很不容易被隔絕',  '磁場大小與電流、距離有關', '磁場很容易就被隔絕',  3),
(4552,  '高級', '欲從事海洋棄置者，下列敘述何者正確？', '應向中央主管機關申請許可', '應向目的事業主管機關申請許可', '應向地方政府申請許可', '應向五都直轄政府申請許可', 1),
(4553,  '中級', '早期農村文化裡，農家喜歡蓋土角厝。這種屋子的特色為何？',  '耐震性好', '就地取材', '全部以石頭建造',  '牆壁厚度超過100公分',  2),
(4554,  '初級', '下列何者是清代巡撫劉銘傳在臺實施新政的重要基地？', '淡毛紅毛城',  '臺北機器局',  '關西分駐所',  '虎尾糖廠鐵橋', 2),
(4555,  '中級', '下列何者是屬於「大屯火山群」？',  '七星山',  '玉山', '秀姑巒山', '向陽山',  1),
(4556,  '中級', '水牛在臺灣的開拓史上，扮演著甚麼角色？',  '風水', '畜養', '開墾', '宗教', 3),
(4557,  '中高級',  '臺北盆地原是下列哪一族之活動區域？',  '阿美族',  '平埔族',  '布農族',  '鄒族', 2),
(4558,  '中級', '美濃最具代表性的民俗手工藝為何？', '紙傘', '繡縫', '藍染', '陶藝', 1),
(4559,  '初級', '?想的?蟲劑除?要考量使用方便性外，還要注意哪些事情？',  '?蟲效果', '包裝精美', '品牌保證', '名人推薦', 1),
(4560,  '高級', '下列哪個國家有簽署《京都議定書》？',  '阿富汗',  '美國', '伊拉克',  '德國', 4),
(4561,  '中高級',  '下列何者「不是」《京都議定書》所管制之氣體？', '二氧化碳', '甲烷', '臭氧', '氧化亞氮', 3),
(4562,  '初級', '下列何者是溫室氣體過度排放造成的結果？',  '氣溫升高', '海平面上升',  '冰山融化', '以上皆是', 4),
(4563,  '初級', '下列何種方法有助於減少二氧化碳的排放？',  '每天使用汽機車上班上課',  '燃燒化石燃料', '積極發展工業', '使用節能標章認證的電器',  4),
(4564,  '中高級',  '下列哪個國家因海平面上升將成為第一個被海水淹沒的國家？',  '吐瓦魯',  '馬爾地夫', '吉里巴斯', '巴布亞紐幾內亞',  1),
(4565,  '初級', '下列何者對減碳有幫助？',  '大量種植樹木', '增加該地區之人口數',  '火山噴發', '積極開發土地', 1),
(4566,  '中級', '在大氣中何種溫室氣體含量最多？',  '水氣', '二氧化碳', '臭氧', '甲烷', 1),
(4567,  '中高級',  '下列何者「不是」氟氯碳化物的來源？',  '清潔劑',  '發泡劑',  '冷氣', '汽機車排氣',  4),
(4568,  '高級', '下列何者為《京都議定書》之列管國家？', '巴西', '荷蘭', '南韓', '墨西哥',  2),
(4569,  '初級', '下列哪一種交通工具的搭乘方式，可以減少二氧化碳的排放？',  '騎機車',  '開車', '搭公車',  '坐計程車', 3),
(4570,  '中高級',  '下列何者「不屬於」計算水足跡的三個部分組成？', '綠色的水足跡', '藍色的水足跡', '灰色的水足跡', '白色的水足跡', 4),
(4571,  '中級', '臺灣二氧化碳排放主要來自下列哪個行業？',  '服務業',  '工業', '農業', '運輸部門', 2),
(4572,  '中高級',  '下列何者「不是」氫氟碳化物(HFCs)排放的主要來源？',  '海龍替代品',  '光電半導體業', '化石燃料', '冷煤', 3),
(4573,  '初級', '使用何種再生能源有助於減少溫室氣體的排放？',  '風能', '水力', '太陽能',  '以上皆是', 4),
(4574,  '高級', '下列何者為聯合國氣候變遷公約所提出，為因應氣候變遷主要策略之一？', '調適', '污染防治', '資源回收', '生物多樣性',  1),
(4575,  '高級', '目前世界上的碳交易所「不包括」下列哪一個國家？',  '英國', '加拿大',  '美國', '澳洲', 2),
(4576,  '中級', '水氣和二氧化碳均為大氣中之成分，關於兩者的敘述，何者正確？',  '前者為地球上水出現的主要型式', '後者對溫室效應沒有影響',  '兩者含量均不會隨時間、地點而改變', '兩者均與溫室效應有密切關係',  4),
(4577,  '中級', '在我國「環境荷爾蒙管理計畫」中，下列何者是環保署主要的管理範圍？', '食品', '環境用藥', '玩具', '綠建材',  2),
(4578,  '高級', '以紐西蘭為例，對畜牧業者所收的「放屁稅」主要是因為含有溫室氣體中的哪種氣體？', '氮氣', '臭氧', '甲烷', '氟氯碳化物',  3),
(4579,  '中高級',  '聯合國主導推行化學品分類與標示的全球調和系統簡稱為何？',  'MSDS', 'GIS',  'GHS',  'EEIS', 3),
(4580,  '初級', '施用環境用藥過程中暫停休息時「不宜」進行下列何種行為？',  '抽煙', '洗手', '刷牙', '運動', 1),
(4581,  '中高級',  '?蟲劑名稱中常以「XX松」稱呼的是下列何種?蟲劑？',  '有機氯系殺蟲劑',  '氨基甲酸劑',  '合成除蟲菊劑', '有機磷系殺蟲劑',  4),
(4582,  '中高級',  '下列哪一種行為「不是」劣質環境用藥的情形？',  '有效成分含?與容許誤差範圍?符',  '另外使用容器分裝', '擅自添加其他化學物品', '塗改有效日期', 2),
(4583,  '中級', '根據統計，常見的環境衛生用藥中毒事件，其主要對象為以下何者？', '使用藥劑的專業人員',  '資源回收人員', '藥劑販賣者',  '一般民眾', 1),
(4584,  '初級', '下列何者「不能」減輕溫室效應的？', '大量燒煤，以解?能源問題??????????????', '提倡使用節能技術和節能產品',  '植樹造林，嚴禁亂砍濫伐森林',  '提倡公共交通或步行方式出行',  1),
(4585,  '高級', '下列何項指標用於描述有毒物質的毒性？', 'LD50', 'EC50', 'TD50', 'ED50', 1),
(4586,  '中高級',  '下列哪一本書是針對化學合成物、工業廢棄物和毒性物質危害的科學調查？',  '蘇西的世界',  '寂靜的春天',  '失竊的未來',  '學習的革命',  3),
(4587,  '中級', '下面哪一項關於《京都議定書》的敘述是正確的？', '是國際間為了減少溫室氣體排放所做的共同約定',  '是介紹京都這個地方的旅遊書',  '目的是為了保護臭氧層', '臺灣也有簽\n署參與京都議書', 1),
(4588,  '中級', '下列何者是大掃除時使用環境用藥的原則？',  '用藥為主、清潔整頓為輔',  '清潔整頓為主、用藥為輔',  '用藥為主、美化為輔',  '美化為主、用藥為輔',  2),
(4589,  '初級', '下列哪一種「不是」臺灣家庭常見的蟑螂品種？',  '澳洲蟑螂', '大陸蟑螂', '棕帶蟑螂', '美洲蟑螂', 2),
(4590,  '初級', '下列何者是使用環境用藥的正確認知？',  '包裝越大藥性越毒', '環藥只會對動物有害',  '價格越貴效果越好', '所有的環藥本身均具有毒性', 4),
(4591,  '中級', '高溫焚化是去除世紀之毒「戴奧辛」最可行的方法，大型垃圾焚化爐處理溫度達到多少℃以上，即可破壞戴奧辛？', '850℃', '750℃', '650℃', '550℃', 1),
(4592,  '中級', '當非揮發性液體或固體外洩導致公害產生時，除?阻止其持續外洩外，對於洩漏物可嘗試回收或減輕其危害性，其常用清理設備有以下哪些？(A)鏟子(B)吸油棉(C)阻塞毯(D)資源回收袋',  'BC', 'ABC',  'ABD',  'ACD',  2),
(4593,  '中級', '在公害事故發生現場，已知有高濃度蒸氣、氣體或懸浮微粒等有害物質時，應穿著何種防護衣進行事故處理？', 'A級防護衣',  'B級防護衣',  'C級防護衣',  'S級防護衣',  1),
(4594,  '高級', '形成酸雨的氮氧化物，其主要的污染排放源為下列何者？',  '垃圾燃燒', '火山噴發氣體', '工廠高溫燃燒', '牛隻排放氣體', 3),
(4595,  '中高級',  '依據環保署對有害事業廢棄物處理的規定，其焚化處理設施的燃燒室出口中心溫度應保持多少℃以上？',  '1000℃',  '900℃', '850℃', '800℃', 1),
(4596,  '初級', '俗稱黑風的強烈沙塵暴，其能見度可能低於下列何者？', '50公尺', '100公尺',  '500公尺',  '1000公尺', 1),
(4597,  '中高級',  '下列哪一國家以「發展中國家不承擔義務」為由，宣布退出《京都議定書》？', '英國', '美國', '加拿大',  '日本', 2),
(4598,  '中級', '下列有關廚餘的敘述，何者「錯誤」？',  '屬於不適燃垃圾',  '含有大量水分', '含有大量有機物',  '有利於焚化處理',  4),
(4599,  '高級', '下列何者「不是」一般垃圾的前處理技術？',  '破碎', '壓縮', '分選', '堆肥', 4),
(4600,  '中高級',  '以下何者「不是」有害事業廢棄物之特性認定種類？',  '產生廢鑄砂的事業廢棄物',  '腐蝕性事業廢棄物', '石綿及其製品廢棄物',  '多氯聯苯有害事業廢棄物',  1),
(4601,  '中級', '下列何者「不是」廚餘堆肥處理的優點？', '唯一可回收天然有機物使回歸自然的方法', '市場穩定，不受季節性農作情況而改變',  '堆肥場不必像掩埋場一樣需大面積',  '堆肥場設於室內的部分，不受天候的影響', 2),
(4602,  '初級', '利用微生物將廚餘中的有機成份分解後，以供土壤吸收及提供植物營養屬於下列哪一種做法？',  '減量', '再生利用', '回收', '再使用',  2),
(4603,  '高級', '廢棄物的處理方法有很多種，其中利用高溫燃燒，將事業廢棄物轉變為安定的氣體或物質的處理方式為何？',  '熱處理法', '穩定法',  '氧化分解法',  '固化法',  1),
(4604,  '中高級',  '將一般事業廢棄物掩埋在不透水材質或低滲水性土壤所構築，並設有滲出水；廢氣收集處理設施之處理方法，是下列哪一種最終處置方法？',  '安定掩埋法',  '海洋棄置法',  '封閉掩埋法',  '衛生掩埋法',  4),
(4605,  '高級', '我國雖然不是以下哪個公約的締約國，但仍針對公約中管制持久性有機污染物(POPs)的決議事項，在政策上表現出積極作為？', '鹿特丹公約',  '斯德哥爾摩公約',  '京都議定書',  '維也納公約',  2),
(4606,  '中高級',  '事業廢棄物除了高溫燃燒的焚化處理外，也可使用熱解法進行處理，以下有關熱解法之敘述何者正確？',  '需在無氧或少氧的環境下進行',  '需在充氧的環境下進行', '廢棄物處理後只會有殘渣產生',  '是氧化分解法的一種',  1),
(4607,  '初級', '下?何者是垃圾可能造成的問題？',  '污染環境', '滋生病媒', '可能含有毒化物危害生命',  '以上皆對', 4),
(4608,  '中級', '家中有大型廢棄物需要丟棄時，應該如何處理？',  '可電洽當地清潔隊預約時間、地點',  '可電洽消防局協助回收', '可直接丟進垃圾車', '可放在垃圾車會經過的路邊', 1),
(4609,  '中高級',  '欲丟棄日光燈管、水銀溫度計，應該如何處理？',  '妥善包裝處理，直接交給清潔隊員',  '視為一般垃圾丟棄', '直接丟入回收車',  '隨意棄置路邊', 1),
(4610,  '中高級',  '2013年中國H7N9感染人類案例的報告，下列何者「錯誤」？', '即便是充分煮熟的禽肉或豬肉都不可食用', '不應該吃病了的動物或病死的動物',  '避免吃生肉',  '避免吃帶血未煮熟之料理',  1),
(4611,  '中級', '2013年出現人類感染H7N9的病例，有關「H7N9」敘述下列何者正確？', 'H7N9是A型流行性感冒', 'H7N9是B型流行性感冒', 'H7N9是C型流行性感冒', '以前曾經出現人類感染的案例',  1),
(4612,  '初級', '空氣污染造成人體健康受損，下列何者較無關連性？',  '肺癌', '肺氣腫',  '心臟病',  '胃潰瘍',  4),
(4613,  '中級', '下列哪一個是藉由受污染的水或食物傳布的糞口傳染病？',  'B型肝炎', '霍亂', '登革熱',  '流行性感冒',  2),
(4614,  '中級', '下列哪一種情況不容易讓貯存的水受微生物污染？', '貯存水的容器開口太大', '貯放的時間太長',  '貯放的空氣中灰塵多',  '貯存的水置於冰凍或冷藏',  4),
(4615,  '初級', '早餐買熱豆漿，下列何種行為符合環保和健康觀念？',  '自己帶鋼杯去裝盛,環保又健康', '用老闆提供的薄軟塑膠袋，很方便',  '用老闆提供的保麗龍杯盛裝', '用老闆提供的紙杯裝盛，並以塑膠蓋或塑膠膜封口', 1),
(4616,  '中級', '有關空氣污染的敘述，下列何者「錯誤」？',  '一氧化碳可能造成人體中毒現象', '二氧化氮是造成雨水酸化的原因之一', '臭氧只對植物有害，對人類沒影響',  '二氧化硫是造成雨水酸化的原因之一', 3),
(4617,  '初級', '兒童感染了流行性感冒怎麼辦？', '因為好學全勤繼續去上學',  '請假在家休息', '約同學一起聊天玩耍',  '去網咖',  2),
(4618,  '初級', '兒童騎腳踏車時，下列哪一個敘述較「不正確」？', '兒童騎腳踏車不必戴安全帽', '兒童應到公園空地騎車較安全',  '兒童騎車應有大人在旁邊看護較安全', '兒童騎車最好戴護膝、護腕墊',  1),
(4619,  '初級', '造成發展中國家百分之六十的兒童(5歲以下兒童)死亡的原因是甚麼？', '抽菸', '喝酒', '嚼檳榔',  '營養失調和與飢餓相關的疾病',  4),
(4620,  '高級', '霍亂的主要傳染途徑為何？', '飛沫', '受污染的食物', '空氣', '蚊子叮咬', 2),
(4621,  '中級', '關於下列二手菸的敘述，何者較「不正確」？', '杜絕菸害必須要100%無菸的環境', '自己不吸菸，只吸到二手菸危害不大', '少年較常在家裡吸到二手菸', '吸到二手菸有害人體健康',  2),
(4622,  '高級', '下列何者為使用臭氧消毒的缺點？',  '殺菌速度快',  '氧化速度快',  '除臭、脫色、清濁效果好',  '不適用於清水端至用戶端之消毒劑',  4),
(4623,  '高級', '預防飲用水源受到污染的方法為何？', '減少家庭廢水量',  '參加巡守隊',  '增加水源保護區之範圍', '以上皆是', 4),
(4624,  '高級', '下列哪一個選項較可能是家中出現紅色自來水的原因？', '自來水公司加藥後產生', '水塔清洗不乾淨',  '遭地下水滲漏', '管線腐蝕', 4),
(4625,  '高級', '市售包裝飲用水包裝與製造過程之衛生，是依何種法規管理？',  '飲用水管理條例',  '水污染防治法', '食品衛生管理法',  '廢棄物清理法', 3),
(4626,  '高級', '六價鉻和三價鉻的差別為何？',  '六價鉻毒性較高',  '六價鉻毒性較低',  '六價鉻的管制標準較低', '六價鉻出現在自然中的機率較高', 1),
(4627,  '中級', '有效餘氯在自來水的安全衛生上扮演極重要的角色。如何維持自來水的有效餘氯？', '讓氯氣溶於水中',  '讓六氯苯溶於水中', '讓三氯乙烷溶於水中',  '讓氯乙烯溶於水中', 1),
(4628,  '高級', '下列何者為家庭用自來水管的優先選用材質？', '鍍鋅鐵管', '鉛管', '塑膠管',  '不鏽鋼管', 4),
(4629,  '中級', '水資源相當珍貴，您知道生產一公斤的穀物大約需要多少公升的水嗎？',  '100公升',  '1000公升', '1500公升', '5000公升', 3),
(4630,  '高級', '自來水煮沸後，有時表面有一層白色漂浮物或有白色鍋垢。這些鍋垢可能是什麼物質？', '矽酸鈣固體',  '碳酸鈣固體',  '檸檬酸鈣固體', '乳酸鈣固體',  2),
(4631,  '初級', '自來水為什麼有時會聞起來有消毒水的味道？', '水的天然氣味', '讓水更好喝',  '添加物的氣味', '煮過後所產生的氣味',  3),
(4632,  '高級', '下列何者可以去除水的暫時硬度？',  '加酸', '加熱', '振動', '攪拌', 2),
(4633,  '高級', '自來水取水設施水源選擇，以下何者為第1優先選用？', '水源充足、水質要處理、可以重力直接流下',  '水源充足、水質良好、可以重力直接流下', '水源充足、水質良好、須以動力抽水', '水源充足、水質要處理、須以動力抽水',  2),
(4634,  '高級', '抽水機在一定轉速條件下，揚程與出水量之關係為何？', '揚程越高出水量越多',  '揚程越高出水量越少',  '揚程越高出水量不變',  '揚程越低出水量越少',  2),
(4635,  '高級', '下列何者是移除水中離子的方法？',  '離子交換法',  '化學混凝法',  '化學沉降法',  '以上皆是', 4),
(4636,  '高級', '飲用水設備的過濾器，其操作原理為何？', '蒸發處理', '加熱處理', '阻截處理', '化學處理', 3),
(4637,  '高級', '在飲用水管理當中，濁度與消毒效果之關係為何？', '濁度越高殺菌效果越好', '濁度越低殺菌效果越低', '濁度越高殺菌效果越低', '濁度不會影響殺菌效果', 3),
(4638,  '中高級',  '當家中用水發現水質異常時應通知何單位採樣檢驗？',  '衛生局',  '自來水公司',  '經發局',  '當地清潔隊',  2),
(4639,  '高級', '當發現民眾有竊水行為時應通知何單位？', '衛生局',  '自來水公司',  '水利署',  '環保局',  2),
(4640,  '初級', '一般家庭由自來水公司配送之水資源，應再經何種淨水程序方可飲用？',  '可直接飲用',  '取水於容器中靜置一段時間', '經煮沸後可飲用',  '不可使用於飲食上', 3),
(4641,  '中級', '為何來自自來水廠之水源可直接使用於洗滌清潔上，卻「不建議」生飲？', '自來水廠無明顯作用',  '家庭對水源水質之不安全感', '配送過程可能有水源污染之虞慮', '水中有添加清潔劑', 3),
(4642,  '初級', '家中淨水器之使用何者正確？',  '只要安裝便無需煩惱飲水問題',  '購買最昂貴之設備以永保飲水安全',  '選購適用之淨水器，並定期更換濾心', '為節約資源，淨水器之更換應視使用頻率來決定',  3),
(4643,  '初級', '地下水源「不安全」之原因為？', '心理作用', '因為廢水管線將廢水排入地下水層',  '容易受到人為活動污染', '沒有礦物質',  3),
(4644,  '高級', '飲用水取水規劃與使用，下列敘述何者正確？', '可混用地下水源，節省水費', '儲水建物需審慎規劃，避免污水輸送洩漏導致二次污染', '節省空間，可將污水及飲用水相關建物規劃於同處以方便修整',  '簡易自來水可於停水期間取代自來水', 2),
(4645,  '中高級',  '下列何者為停水期間需注意的事項？', '儲水時不須加蓋，可保留超過3天',  '回收洗滌用水煮沸後可再飲用',  '停止抽水馬達，確保管線安全',  '不須停止抽水馬達，水源恢復時可直接取用',  3),
(4646,  '中級', '關於自來水配水發生二次污染的原因，下列何者正確？', '水塔太久未清洗',  '配送管線老舊破裂', '房舍改建導致管路接錯', '以上皆是', 4),
(4647,  '中高級',  '關於蓄水塔之使用觀念，下列敘述何者正確？', '容量越大越好', '可與消防用水混用', '長時間未使用，水質亦不影響',  '檢查有無溢流，若發生溢流時檢查浮球閥', 4),
(4648,  '中級', '關於包裝飲用水之購買方式，下列何者正確？', '包裝精緻為水質保障象徵',  '只要是密封容器盛裝水品質皆有保障', '可觀看有無GMP標誌進行選購', '以上皆是', 3),
(4649,  '高級', '飲用水中如有過量溴酸鹽會對人體造成危害，請問溴酸鹽會因淨水程序中添加下列何項物質而產生？', '次氯酸鈉', '聚合氯化鋁(', 'PAC)', '?酸鋁',  0),
(4650,  '高級', '飲用水中總菌落數的標準值是每毫升多少CFU？', '100',  '200',  '150',  '80', 1),
(4651,  '中高級',  '環保署《飲用水管理條例》中，飲用水是指供人飲用之水，其種類包含什麼？', '自來水',  '社區自設公共給水設備供應之水', '經環保署指定之水', '以上皆是', 4),
(4652,  '中高級',  '根據環保署規定，經飲用水設備處理後的飲用水，其大腸桿菌群應多久檢測一次？', '1個月',  '6個月',  '2個月',  '3個月',  4),
(4653,  '高級', '抽檢飲用水設備時，應抽檢多少飲用水設備數量的比例？',  '0.25', '0.6',  '0.125',  '0.8',  3),
(4654,  '中高級',  '西元2011年我國沸騰一時的塑化劑風暴中，塑化劑是指以下哪一類化合物？',  '烷基酚類', '鄰苯二甲酸酯類',  '對羥基苯甲酸酯類', '多環芳香烴類', 2),
(4655,  '高級', '請問「環境荷爾蒙」一詞是源自於以下哪個國家？', '美國', '英國', '德國', '日本', 4),
(4656,  '中級', '下列何者為多數環境荷爾蒙物質所具有的特性？',  '無機污染物',  '易分解',  '存在環境中時間短', '具生物濃縮性', 4),
(4657,  '高級', '在多種民生用品中(如電視)，都有使用到多溴聯苯醚以做為產品內的阻燃劑，下列關於多溴聯苯醚的敘述何者「錯誤」？', '廣泛用於火焰抑制劑',  '於水中溶解度很高', '具生物累積性', '毒性與多氯聯苯相仿',  2),
(4658,  '中級', '以下哪一項「不是」環境敏感地？',  '山坡地災害地區',  '土石流潛勢溪流',  '都市平原', '嚴重崩塌、地層下陷地區',  3),
(4659,  '高級', '任何開發案均多少會對自然環境造成衝擊，開發單位在與居民溝通中，下列何者作法「不合適」？',  '部分當地居民強力抗爭，開發單位應持續協商至居民同意後才提出開發案', '與當地居民溝通其工作與生活之需求', '如僅少部分當地居民不同意，可強制徵收土地並要求當地居民遷移',  '繼續加開說明會，直至所有當地居民同意', 3),
(4660,  '高級', '下列哪一項開發案「不屬於」政府單位提出「政策環評說明書」之細項？', '能源政策', '鋼鐵工業發展', '桃園機場及周邊整體開發',  '大臺中都市計畫擴大方案計畫',  4);


