<?php
/**
 * Ben Score module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ben Score
 * @since      2.5
 * @author     Benjamin
 * @version    $Id $
 **/


/*-----------引入檔案區--------------*/
$isAdmin=true;
$xoopsOption['template_main'] = 'ben_score_adm_comment.html';
include_once "header.php";
include_once "../function.php";

/*-----------功能函數區--------------*/


//ben_score_comment編輯表單
function ben_score_comment_form($bs_comment_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    include_once(XOOPS_ROOT_PATH."/class/xoopsformloader.php");
    include_once(XOOPS_ROOT_PATH."/class/xoopseditor/xoopseditor.php");

    //抓取預設值
    if(!empty($bs_comment_sn))
    {
        $DBV = get_ben_score_comment($bs_comment_sn);
    }else{
        $DBV = array();
    }

    //預設值設定
        
    //設定 bs_comment_sn 欄位的預設值
    $bs_comment_sn = !isset($DBV['bs_comment_sn']) ? $bs_comment_sn : $DBV['bs_comment_sn'];
    $xoopsTpl->assign('bs_comment_sn', $bs_comment_sn);    
    //設定 bs_comment_id 欄位的預設值
    $bs_comment_id = !isset($DBV['bs_comment_id']) ? "" : $DBV['bs_comment_id'];
    $xoopsTpl->assign('bs_comment_id', $bs_comment_id);    
    //設定 bs_comment_desc 欄位的預設值
    $bs_comment_desc = !isset($DBV['bs_comment_desc']) ? "" : $DBV['bs_comment_desc'];
    $xoopsTpl->assign('bs_comment_desc', $bs_comment_desc);

    $op = empty($bs_comment_sn) ? "insert_ben_score_comment" : "update_ben_score_comment";
    //$op="replace_ben_score_comment";
    
    $span = $_SESSION['bootstrap'] == '3' ? 'form-control col-md-' : 'span';
    $form = new XoopsThemeForm('', 'form', $_SERVER['PHP_SELF'], 'post', true);
    $form->setExtra('enctype = "multipart/form-data"');

    //評語編號
    $form->addElement(new XoopsFormHidden("bs_comment_sn", $bs_comment_sn));

    //評語代碼
    $bs_comment_idText = new XoopsFormText(_MA_BENSCORE_BS_COMMENT_ID, "bs_comment_id", 25, 255, $bs_comment_id);
    $bs_comment_idText->setExtra("class = '{$span}5'");
    $form->addElement($bs_comment_idText, false);

    //評語說明
    $bs_comment_descText = new XoopsFormText(_MA_BENSCORE_BS_COMMENT_DESC, "bs_comment_desc", 25, 255, $bs_comment_desc);
    $bs_comment_descText->setExtra("class = '{$span}5'");
    $form->addElement($bs_comment_descText, false);
    $form->addElement(new XoopsFormHidden("op", $op));
    $form->addElement(new XoopsFormHiddenToken());

    $SubmitTray=new XoopsFormElementTray('', '', '', true);
    $SubmitTray->addElement(new XoopsFormButton('', '', _TAD_SUBMIT, 'submit'));
    $form->addElement($SubmitTray);
    $xoopsform = $form->render();
    $xoopsTpl->assign('xoopsform', $xoopsform);

    $xoopsTpl->assign('now_op', 'ben_score_comment_form');
    $xoopsTpl->assign('next_op', $op);
}



//以流水號取得某筆ben_score_comment資料
function get_ben_score_comment($bs_comment_sn = '')
{
    global $xoopsDB;

    if(empty($bs_comment_sn))
    {
        return;
    }

    $sql = "select * from `".$xoopsDB->prefix("ben_score_comment")."`
    where `bs_comment_sn` = '{$bs_comment_sn}'";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data = $xoopsDB->fetchArray($result);
    return $data;
}

//新增資料到ben_score_comment中
function insert_ben_score_comment()
{
    global $xoopsDB, $xoopsUser, $isAdmin;
    if(!$isAdmin) {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error=implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_comment_sn = intval($_POST['bs_comment_sn']);
    $bs_comment_id = $myts->addSlashes($_POST['bs_comment_id']);
    $bs_comment_desc = $myts->addSlashes($_POST['bs_comment_desc']);

    $sql = "insert into `".$xoopsDB->prefix("ben_score_comment")."` (
        `bs_comment_id`, 
        `bs_comment_desc`
    ) values(
        '{$bs_comment_id}', 
        '{$bs_comment_desc}'
    )";
    $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());

    //取得最後新增資料的流水編號
    $bs_comment_sn = $xoopsDB->getInsertId();
    
    return $bs_comment_sn;
}

//更新ben_score_comment某一筆資料
function update_ben_score_comment($bs_comment_sn = '')
{
    global $xoopsDB, $isAdmin, $xoopsUser;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }
    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_comment_sn = intval($_POST['bs_comment_sn']);
    $bs_comment_id = $myts->addSlashes($_POST['bs_comment_id']);
    $bs_comment_desc = $myts->addSlashes($_POST['bs_comment_desc']);

    $sql = "update `".$xoopsDB->prefix("ben_score_comment")."` set 
       `bs_comment_id` = '{$bs_comment_id}', 
       `bs_comment_desc` = '{$bs_comment_desc}'
    where `bs_comment_sn` = '$bs_comment_sn'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    return $bs_comment_sn;
}

//刪除ben_score_comment某筆資料資料
function delete_ben_score_comment($bs_comment_sn = '')
{
    global $xoopsDB, $isAdmin;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    if(empty($bs_comment_sn))
    {
        return;
    }

    $sql = "delete from `".$xoopsDB->prefix("ben_score_comment")."`
    where `bs_comment_sn` = '{$bs_comment_sn}'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
}

//以流水號秀出某筆ben_score_comment資料內容
function show_one_ben_score_comment($bs_comment_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(empty($bs_comment_sn))
    {
        return;
    } else {
        $bs_comment_sn = intval($bs_comment_sn);
    }

    $myts = MyTextSanitizer::getInstance();

    $sql = "select * from `".$xoopsDB->prefix("ben_score_comment")."`
    where `bs_comment_sn` = '{$bs_comment_sn}' ";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $all = $xoopsDB->fetchArray($result);

    //以下會產生這些變數： $bs_comment_sn, $bs_comment_id, $bs_comment_desc
    foreach($all as $k => $v)
    {
        $$k = $v;
    }

    

    //過濾讀出的變數值
    $bs_comment_id = $myts->htmlSpecialChars($bs_comment_id);
    $bs_comment_desc = $myts->htmlSpecialChars($bs_comment_desc);

    $xoopsTpl->assign('bs_comment_sn', $bs_comment_sn);
    $xoopsTpl->assign('bs_comment_id', $bs_comment_id);
    $xoopsTpl->assign('bs_comment_desc', $bs_comment_desc);

    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }

    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_comment_func = $sweet_alert_obj->render('delete_ben_score_comment_func', "{$_SERVER['PHP_SELF']}?op=delete_ben_score_comment&bs_comment_sn=", "bs_comment_sn");
    $xoopsTpl->assign('delete_ben_score_comment_func', $delete_ben_score_comment_func);

    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('now_op', 'show_one_ben_score_comment');
}



//列出所有ben_score_comment資料
function list_ben_score_comment()
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    $myts = MyTextSanitizer::getInstance();
    
    $sql = "select * from `".$xoopsDB->prefix("ben_score_comment")."` ";

    //getPageBar($原sql語法, 每頁顯示幾筆資料, 最多顯示幾個頁數選項);
    $PageBar = getPageBar($sql, 20, 10, null, null, $bootstrap);
    $bar     = $PageBar['bar'];
    $sql     = $PageBar['sql'];
    $total   = $PageBar['total'];

    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    $all_content = '';
    $i = 0;
    while($all = $xoopsDB->fetchArray($result))
    {
        //以下會產生這些變數： $bs_comment_sn, $bs_comment_id, $bs_comment_desc
        foreach($all as $k=>$v){
            $$k=$v;
        }
        
        //過濾讀出的變數值
        $bs_comment_id = $myts->htmlSpecialChars($bs_comment_id);
        $bs_comment_desc = $myts->htmlSpecialChars($bs_comment_desc);

        $all_content[$i]['bs_comment_sn'] = $bs_comment_sn;
        $all_content[$i]['bs_comment_id'] = $bs_comment_id;
        $all_content[$i]['bs_comment_desc'] = $bs_comment_desc;
        $i++;
    }

    //刪除確認的JS
    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }
    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_comment_func = $sweet_alert_obj->render('delete_ben_score_comment_func',
    "{$_SERVER['PHP_SELF']}?op=delete_ben_score_comment&bs_comment_sn=", "bs_comment_sn");
    $xoopsTpl->assign('delete_ben_score_comment_func', $delete_ben_score_comment_func);
    
    $xoopsTpl->assign('bar', $bar);
    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('isAdmin', $isAdmin);
    $xoopsTpl->assign('all_content', $all_content);
    $xoopsTpl->assign('now_op', 'list_ben_score_comment');
}




/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path( '/modules/system/include/functions.php' );
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$bs_student_sn = system_CleanVars($_REQUEST, 'bs_student_sn', '', 'int');
$bs_teacher_sn = system_CleanVars($_REQUEST, 'bs_teacher_sn', '', 'int');
$bs_course_sn = system_CleanVars($_REQUEST, 'bs_course_sn', '', 'int');
$bs_select_course_sn = system_CleanVars($_REQUEST, 'bs_select_course_sn', '', 'int');
$bs_comment_sn = system_CleanVars($_REQUEST, 'bs_comment_sn', '', 'int');
$CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM; = system_CleanVars($_REQUEST, 'CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM;', '', 'int');


switch($op){
  /*---判斷動作請貼在下方---*/

  
    //替換資料
    //case "replace_ben_score_comment":
    //    replace_ben_score_comment();
    //    header("location: {$_SERVER['PHP_SELF']}?bs_comment_sn=$bs_comment_sn");
    //    exit;
    //break;

    //新增資料
    case "insert_ben_score_comment":
        $bs_comment_sn = insert_ben_score_comment();
        header("location: {$_SERVER['PHP_SELF']}?bs_comment_sn=$bs_comment_sn");
        exit;
    break;

    //更新資料
    case "update_ben_score_comment":
        update_ben_score_comment($bs_comment_sn);
        header("location: {$_SERVER['PHP_SELF']}?bs_comment_sn=$bs_comment_sn");
        exit;
    break;

    
    case "ben_score_comment_form":
        ben_score_comment_form($bs_comment_sn);
    break;

    
    case "delete_ben_score_comment":
        delete_ben_score_comment($bs_comment_sn);
        header("location: {$_SERVER['PHP_SELF']}");
        exit;
    break;
    
    

    
    default:
        if(empty($bs_comment_sn)) {
            list_ben_score_comment();
            //$main .= ben_score_comment_form($bs_comment_sn);
        }else{
            show_one_ben_score_comment($bs_comment_sn);
        }
    break;


  /*---判斷動作請貼在上方---*/
}

/*-----------秀出結果區--------------*/
$xoopsTpl->assign("isAdmin" , true);
$xoTheme->addStylesheet(XOOPS_URL.'/modules/tadtools/css/xoops_adm.css');
include_once 'footer.php';