<?php
/**
 * Ben Score module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ben Score
 * @since      2.5
 * @author     Benjamin
 * @version    $Id $
 **/


/*-----------引入檔案區--------------*/
$isAdmin=true;
$xoopsOption['template_main'] = 'ben_score_adm_course.html';
include_once "header.php";
include_once "../function.php";

/*-----------功能函數區--------------*/


//ben_score_course編輯表單
function ben_score_course_form($bs_course_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    include_once(XOOPS_ROOT_PATH."/class/xoopsformloader.php");
    include_once(XOOPS_ROOT_PATH."/class/xoopseditor/xoopseditor.php");

    //抓取預設值
    if(!empty($bs_course_sn))
    {
        $DBV = get_ben_score_course($bs_course_sn);
    }else{
        $DBV = array();
    }

    //預設值設定
        
    //設定 bs_course_sn 欄位的預設值
    $bs_course_sn = !isset($DBV['bs_course_sn']) ? $bs_course_sn : $DBV['bs_course_sn'];
    $xoopsTpl->assign('bs_course_sn', $bs_course_sn);    
    //設定 bs_course_cate 欄位的預設值
    $bs_course_cate = !isset($DBV['bs_course_cate']) ? "" : $DBV['bs_course_cate'];
    $xoopsTpl->assign('bs_course_cate', $bs_course_cate);    
    //設定 bs_course_title 欄位的預設值
    $bs_course_title = !isset($DBV['bs_course_title']) ? "" : $DBV['bs_course_title'];
    $xoopsTpl->assign('bs_course_title', $bs_course_title);    
    //設定 bs_course_credit 欄位的預設值
    $bs_course_credit = !isset($DBV['bs_course_credit']) ? "" : $DBV['bs_course_credit'];
    $xoopsTpl->assign('bs_course_credit', $bs_course_credit);    
    //設定 bs_course_class 欄位的預設值
    $bs_course_class = !isset($DBV['bs_course_class']) ? "" : $DBV['bs_course_class'];
    $xoopsTpl->assign('bs_course_class', $bs_course_class);    
    //設定 bs_course_school_year_semester 欄位的預設值
    $bs_course_school_year_semester = !isset($DBV['bs_course_school_year_semester']) ? "" : $DBV['bs_course_school_year_semester'];
    $xoopsTpl->assign('bs_course_school_year_semester', $bs_course_school_year_semester);    
    //設定 bs_teacher_sn 欄位的預設值
    $bs_teacher_sn = !isset($DBV['bs_teacher_sn']) ? "" : $DBV['bs_teacher_sn'];
    $xoopsTpl->assign('bs_teacher_sn', $bs_teacher_sn);    
    //設定 bs_course_memo 欄位的預設值
    $bs_course_memo = !isset($DBV['bs_course_memo']) ? "" : $DBV['bs_course_memo'];
    $xoopsTpl->assign('bs_course_memo', $bs_course_memo);    
    //設定 bs_course_enable 欄位的預設值
    $bs_course_enable = !isset($DBV['bs_course_enable']) ? "" : $DBV['bs_course_enable'];
    $xoopsTpl->assign('bs_course_enable', $bs_course_enable);    
    //設定 bs_course_sort 欄位的預設值
    $bs_course_sort = !isset($DBV['bs_course_sort']) ? ben_score_course_max_sort() : $DBV['bs_course_sort'];
    $xoopsTpl->assign('bs_course_sort', $bs_course_sort);

    $op = empty($bs_course_sn) ? "insert_ben_score_course" : "update_ben_score_course";
    //$op="replace_ben_score_course";
    
    $span = $_SESSION['bootstrap'] == '3' ? 'form-control col-md-' : 'span';
    $form = new XoopsThemeForm('', 'form', $_SERVER['PHP_SELF'], 'post', true);
    $form->setExtra('enctype = "multipart/form-data"');

    //課程編號
    $form->addElement(new XoopsFormHidden("bs_course_sn", $bs_course_sn));

    //課程分類
    $bs_course_cateRadio = new XoopsFormRadio(_MA_BENSCORE_BS_COURSE_CATE, 'bs_course_cate', '');
    $options_array['學科'] = '學科';
    $options_array['術科'] = '術科';
    $bs_course_cateRadio->addOptionArray($options_array);
    $form->addElement($bs_course_cateRadio, false);

    //課程名稱
    $bs_course_titleText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_TITLE, "bs_course_title", 25, 255, $bs_course_title);
    $bs_course_titleText->setExtra("class = '{$span}5'");
    $form->addElement($bs_course_titleText, false);

    //學分數
    $bs_course_creditText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_CREDIT, "bs_course_credit", 25, 255, $bs_course_credit);
    $bs_course_creditText->setExtra("class = '{$span}5'");
    $form->addElement($bs_course_creditText, false);

    //開課班級
    $bs_course_classText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_CLASS, "bs_course_class", 25, 255, $bs_course_class);
    $bs_course_classText->setExtra("class = '{$span}5'");
    $form->addElement($bs_course_classText, false);

    //開課學年期
    $bs_course_school_year_semesterText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_SCHOOL_YEAR_SEMESTER, "bs_course_school_year_semester", 25, 255, $bs_course_school_year_semester);
    $bs_course_school_year_semesterText->setExtra("class = '{$span}5'");
    $form->addElement($bs_course_school_year_semesterText, false);

    //教師編號
    $bs_teacher_snSelect = new XoopsFormSelect(_MA_BENSCORE_BS_TEACHER_SN, 'bs_teacher_sn', '', 1, false);
    $sql="select `bs_teacher_sn`, `` from `".$xoopsDB->prefix("ben_score_teacher")."` ";
    $result = $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    while(list($bs_teacher_sn,$) = $xoopsDB->fetchRow($result))
    {
        $options_array[$bs_teacher_sn] = $;
    }
    $bs_teacher_snSelect->addOptionArray($options_array);
    $bs_teacher_snSelect->setExtra("class = '{$span}5'");
    $form->addElement($bs_teacher_snSelect, false);

    //課程備註
    $bs_course_memoText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_MEMO, "bs_course_memo", 25, 255, $bs_course_memo);
    $bs_course_memoText->setExtra("class = '{$span}5'");
    $form->addElement($bs_course_memoText, false);

    //開課否
    $bs_course_enableRadio = new XoopsFormRadio(_MA_BENSCORE_BS_COURSE_ENABLE, 'bs_course_enable', '');
    $options_array['開課'] = '開課';
    $options_array['不開課'] = '不開課';
    $bs_course_enableRadio->addOptionArray($options_array);
    $form->addElement($bs_course_enableRadio, false);

    //課程排序
    $bs_course_sortText = new XoopsFormText(_MA_BENSCORE_BS_COURSE_SORT, "bs_course_sort", 25, 255, $bs_course_sort);
    $bs_course_sortText->setExtra("class = '{$span}3'");
    $form->addElement($bs_course_sortText, false);
    $form->addElement(new XoopsFormHidden("op", $op));
    $form->addElement(new XoopsFormHiddenToken());

    $SubmitTray=new XoopsFormElementTray('', '', '', true);
    $SubmitTray->addElement(new XoopsFormButton('', '', _TAD_SUBMIT, 'submit'));
    $form->addElement($SubmitTray);
    $xoopsform = $form->render();
    $xoopsTpl->assign('xoopsform', $xoopsform);

    $xoopsTpl->assign('now_op', 'ben_score_course_form');
    $xoopsTpl->assign('next_op', $op);
}


//自動取得ben_score_course的最新排序
function ben_score_course_max_sort()
{
    global $xoopsDB;
    $sql = "select max(`bs_course_sort`) from `".$xoopsDB->prefix("ben_score_course")."`";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    list($sort) = $xoopsDB->fetchRow($result);
    return ++$sort;
}


//以流水號取得某筆ben_score_course資料
function get_ben_score_course($bs_course_sn = '')
{
    global $xoopsDB;

    if(empty($bs_course_sn))
    {
        return;
    }

    $sql = "select * from `".$xoopsDB->prefix("ben_score_course")."`
    where `bs_course_sn` = '{$bs_course_sn}'";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data = $xoopsDB->fetchArray($result);
    return $data;
}

//新增資料到ben_score_course中
function insert_ben_score_course()
{
    global $xoopsDB, $xoopsUser, $isAdmin;
    if(!$isAdmin) {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error=implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_course_sn = intval($_POST['bs_course_sn']);
    $bs_course_cate = $_POST['bs_course_cate'];
    $bs_course_title = $myts->addSlashes($_POST['bs_course_title']);
    $bs_course_credit = $myts->addSlashes($_POST['bs_course_credit']);
    $bs_course_class = $myts->addSlashes($_POST['bs_course_class']);
    $bs_course_school_year_semester = $myts->addSlashes($_POST['bs_course_school_year_semester']);
    $bs_teacher_sn = $_POST['bs_teacher_sn'];
    $bs_course_memo = $myts->addSlashes($_POST['bs_course_memo']);
    $bs_course_enable = $_POST['bs_course_enable'];
    $bs_course_sort = intval($_POST['bs_course_sort']);

    $sql = "insert into `".$xoopsDB->prefix("ben_score_course")."` (
        `bs_course_cate`, 
        `bs_course_title`, 
        `bs_course_credit`, 
        `bs_course_class`, 
        `bs_course_school_year_semester`, 
        `bs_teacher_sn`, 
        `bs_course_memo`, 
        `bs_course_enable`, 
        `bs_course_sort`
    ) values(
        '{$bs_course_cate}', 
        '{$bs_course_title}', 
        '{$bs_course_credit}', 
        '{$bs_course_class}', 
        '{$bs_course_school_year_semester}', 
        '{$bs_teacher_sn}', 
        '{$bs_course_memo}', 
        '{$bs_course_enable}', 
        '{$bs_course_sort}'
    )";
    $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());

    //取得最後新增資料的流水編號
    $bs_course_sn = $xoopsDB->getInsertId();
    
    return $bs_course_sn;
}

//更新ben_score_course某一筆資料
function update_ben_score_course($bs_course_sn = '')
{
    global $xoopsDB, $isAdmin, $xoopsUser;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }
    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_course_sn = intval($_POST['bs_course_sn']);
    $bs_course_cate = $_POST['bs_course_cate'];
    $bs_course_title = $myts->addSlashes($_POST['bs_course_title']);
    $bs_course_credit = $myts->addSlashes($_POST['bs_course_credit']);
    $bs_course_class = $myts->addSlashes($_POST['bs_course_class']);
    $bs_course_school_year_semester = $myts->addSlashes($_POST['bs_course_school_year_semester']);
    $bs_teacher_sn = $_POST['bs_teacher_sn'];
    $bs_course_memo = $myts->addSlashes($_POST['bs_course_memo']);
    $bs_course_enable = $_POST['bs_course_enable'];
    $bs_course_sort = intval($_POST['bs_course_sort']);

    $sql = "update `".$xoopsDB->prefix("ben_score_course")."` set 
       `bs_course_cate` = '{$bs_course_cate}', 
       `bs_course_title` = '{$bs_course_title}', 
       `bs_course_credit` = '{$bs_course_credit}', 
       `bs_course_class` = '{$bs_course_class}', 
       `bs_course_school_year_semester` = '{$bs_course_school_year_semester}', 
       `bs_teacher_sn` = '{$bs_teacher_sn}', 
       `bs_course_memo` = '{$bs_course_memo}', 
       `bs_course_enable` = '{$bs_course_enable}', 
       `bs_course_sort` = '{$bs_course_sort}'
    where `bs_course_sn` = '$bs_course_sn'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    return $bs_course_sn;
}

//刪除ben_score_course某筆資料資料
function delete_ben_score_course($bs_course_sn = '')
{
    global $xoopsDB, $isAdmin;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    if(empty($bs_course_sn))
    {
        return;
    }

    $sql = "delete from `".$xoopsDB->prefix("ben_score_course")."`
    where `bs_course_sn` = '{$bs_course_sn}'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
}

//以流水號秀出某筆ben_score_course資料內容
function show_one_ben_score_course($bs_course_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(empty($bs_course_sn))
    {
        return;
    } else {
        $bs_course_sn = intval($bs_course_sn);
    }

    $myts = MyTextSanitizer::getInstance();

    $sql = "select * from `".$xoopsDB->prefix("ben_score_course")."`
    where `bs_course_sn` = '{$bs_course_sn}' ";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $all = $xoopsDB->fetchArray($result);

    //以下會產生這些變數： $bs_course_sn, $bs_course_cate, $bs_course_title, $bs_course_credit, $bs_course_class, $bs_course_school_year_semester, $bs_teacher_sn, $bs_course_memo, $bs_course_enable, $bs_course_sort
    foreach($all as $k => $v)
    {
        $$k = $v;
    }

    
    //取得分類資料(ben_score_teacher)
    $ben_score_teacher_arr = get_ben_score_teacher($bs_teacher_sn);


    //過濾讀出的變數值
    $bs_course_title = $myts->htmlSpecialChars($bs_course_title);
    $bs_course_credit = $myts->htmlSpecialChars($bs_course_credit);
    $bs_course_class = $myts->htmlSpecialChars($bs_course_class);
    $bs_course_school_year_semester = $myts->htmlSpecialChars($bs_course_school_year_semester);
    $bs_course_memo = $myts->htmlSpecialChars($bs_course_memo);

    $xoopsTpl->assign('bs_course_sn', $bs_course_sn);
    $xoopsTpl->assign('bs_course_cate', $bs_course_cate);
    $xoopsTpl->assign('bs_course_title', $bs_course_title);
    $xoopsTpl->assign('bs_course_credit', $bs_course_credit);
    $xoopsTpl->assign('bs_course_class', $bs_course_class);
    $xoopsTpl->assign('bs_course_school_year_semester', $bs_course_school_year_semester);
    $xoopsTpl->assign('bs_teacher_sn', $bs_teacher_sn);
  $xoopsTpl->assign('bs_teacher_sn_title', $ben_score_teacher_arr['']);
    $xoopsTpl->assign('bs_course_memo', $bs_course_memo);
    $xoopsTpl->assign('bs_course_enable', $bs_course_enable);
    $xoopsTpl->assign('bs_course_sort', $bs_course_sort);

    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }

    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_course_func = $sweet_alert_obj->render('delete_ben_score_course_func', "{$_SERVER['PHP_SELF']}?op=delete_ben_score_course&bs_course_sn=", "bs_course_sn");
    $xoopsTpl->assign('delete_ben_score_course_func', $delete_ben_score_course_func);

    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('now_op', 'show_one_ben_score_course');
}


//以流水號取得某筆ben_score_teacher資料
function get_ben_score_teacher($bs_teacher_sn = '')
{
    global $xoopsDB;

    if(empty($bs_teacher_sn))
    {
        return;
    }

    $sql = "select * from `".$xoopsDB->prefix("ben_score_teacher")."`
    where `bs_teacher_sn` = '{$bs_teacher_sn}'";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data = $xoopsDB->fetchArray($result);
    return $data;
}


//列出所有ben_score_course資料
function list_ben_score_course()
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    $myts = MyTextSanitizer::getInstance();
    
    $sql = "select * from `".$xoopsDB->prefix("ben_score_course")."` order by `bs_course_sort`";

    //getPageBar($原sql語法, 每頁顯示幾筆資料, 最多顯示幾個頁數選項);
    $PageBar = getPageBar($sql, 20, 10, null, null, $bootstrap);
    $bar     = $PageBar['bar'];
    $sql     = $PageBar['sql'];
    $total   = $PageBar['total'];

    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
  //取得分類所有資料陣列
  $ben_score_teacher_arr = get_ben_score_teacher_all();
    $all_content = '';
    $i = 0;
    while($all = $xoopsDB->fetchArray($result))
    {
        //以下會產生這些變數： $bs_course_sn, $bs_course_cate, $bs_course_title, $bs_course_credit, $bs_course_class, $bs_course_school_year_semester, $bs_teacher_sn, $bs_course_memo, $bs_course_enable, $bs_course_sort
        foreach($all as $k=>$v){
            $$k=$v;
        }
        
        //過濾讀出的變數值
        $bs_course_title = $myts->htmlSpecialChars($bs_course_title);
        $bs_course_credit = $myts->htmlSpecialChars($bs_course_credit);
        $bs_course_class = $myts->htmlSpecialChars($bs_course_class);
        $bs_course_school_year_semester = $myts->htmlSpecialChars($bs_course_school_year_semester);
        $bs_course_memo = $myts->htmlSpecialChars($bs_course_memo);

        $all_content[$i]['bs_course_sn'] = $bs_course_sn;
        $all_content[$i]['bs_course_cate'] = $bs_course_cate;
        $all_content[$i]['bs_course_title'] = $bs_course_title;
        $all_content[$i]['bs_course_credit'] = $bs_course_credit;
        $all_content[$i]['bs_course_class'] = $bs_course_class;
        $all_content[$i]['bs_course_school_year_semester'] = $bs_course_school_year_semester;
        $all_content[$i]['bs_teacher_sn'] = $ben_score_teacher_arr[$bs_teacher_sn][''];
        $all_content[$i]['bs_course_memo'] = $bs_course_memo;
        $all_content[$i]['bs_course_enable'] = $bs_course_enable;
        $all_content[$i]['bs_course_sort'] = $bs_course_sort;
        $i++;
    }

    //刪除確認的JS
    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }
    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_course_func = $sweet_alert_obj->render('delete_ben_score_course_func',
    "{$_SERVER['PHP_SELF']}?op=delete_ben_score_course&bs_course_sn=", "bs_course_sn");
    $xoopsTpl->assign('delete_ben_score_course_func', $delete_ben_score_course_func);
    
  $xoopsTpl->assign('ben_score_course_jquery_ui', get_jquery(true));
    $xoopsTpl->assign('bar', $bar);
    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('isAdmin', $isAdmin);
    $xoopsTpl->assign('all_content', $all_content);
    $xoopsTpl->assign('now_op', 'list_ben_score_course');
}

//取得ben_score_teacher所有資料陣列
function get_ben_score_teacher_all()
{
    global $xoopsDB;
    $sql = "select * from `".$xoopsDB->prefix("ben_score_teacher")."`";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data_arr = '';
    while($data = $xoopsDB->fetchArray($result))
    {
        $bs_teacher_sn = $data['bs_teacher_sn'];
        $data_arr[$bs_teacher_sn] = $data;
    }
    return $data_arr;
}


//更新排序
function update_ben_score_course_sort(){
  global $xoopsDB;
  $sort = 1;
  foreach ($_POST['tr'] as $bs_course_sn) {
      $sql="update ".$xoopsDB->prefix("ben_score_course")." set `bs_course_sort`='{$sort}' where `bs_course_sn`='{$bs_course_sn}'";
      $xoopsDB->queryF($sql) or die(_TAD_SORT_FAIL." (".date("Y-m-d H:i:s").")");
      $sort++;
  }
  return _TAD_SORTED." (".date("Y-m-d H:i:s").")";
}


/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path( '/modules/system/include/functions.php' );
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$bs_student_sn = system_CleanVars($_REQUEST, 'bs_student_sn', '', 'int');
$bs_teacher_sn = system_CleanVars($_REQUEST, 'bs_teacher_sn', '', 'int');
$bs_course_sn = system_CleanVars($_REQUEST, 'bs_course_sn', '', 'int');
$bs_select_course_sn = system_CleanVars($_REQUEST, 'bs_select_course_sn', '', 'int');
$bs_comment_sn = system_CleanVars($_REQUEST, 'bs_comment_sn', '', 'int');
$CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM; = system_CleanVars($_REQUEST, 'CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM;', '', 'int');


switch($op){
  /*---判斷動作請貼在下方---*/

  
    //替換資料
    //case "replace_ben_score_course":
    //    replace_ben_score_course();
    //    header("location: {$_SERVER['PHP_SELF']}?bs_course_sn=$bs_course_sn");
    //    exit;
    //break;

    //新增資料
    case "insert_ben_score_course":
        $bs_course_sn = insert_ben_score_course();
        header("location: {$_SERVER['PHP_SELF']}?bs_course_sn=$bs_course_sn");
        exit;
    break;

    //更新資料
    case "update_ben_score_course":
        update_ben_score_course($bs_course_sn);
        header("location: {$_SERVER['PHP_SELF']}?bs_course_sn=$bs_course_sn");
        exit;
    break;

    
    case "ben_score_course_form":
        ben_score_course_form($bs_course_sn);
    break;

    
    case "delete_ben_score_course":
        delete_ben_score_course($bs_course_sn);
        header("location: {$_SERVER['PHP_SELF']}");
        exit;
    break;
    
    
  //更新排序
  case "update_ben_score_course_sort":
  $msg = update_ben_score_course_sort();
  die($msg);
  break;

    
    default:
        if(empty($bs_course_sn)) {
            list_ben_score_course();
            //$main .= ben_score_course_form($bs_course_sn);
        }else{
            show_one_ben_score_course($bs_course_sn);
        }
    break;


  /*---判斷動作請貼在上方---*/
}

/*-----------秀出結果區--------------*/
$xoopsTpl->assign("isAdmin" , true);
$xoTheme->addStylesheet(XOOPS_URL.'/modules/tadtools/css/xoops_adm.css');
include_once 'footer.php';