<?php
/**
 * Ben Score module
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright  The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license    http://www.fsf.org/copyleft/gpl.html GNU public license
 * @package    Ben Score
 * @since      2.5
 * @author     Benjamin
 * @version    $Id $
 **/


/*-----------引入檔案區--------------*/
$isAdmin=true;
$xoopsOption['template_main'] = 'ben_score_adm_student.html';
include_once "header.php";
include_once "../function.php";

/*-----------功能函數區--------------*/


//ben_score_student編輯表單
function ben_score_student_form($bs_student_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    include_once(XOOPS_ROOT_PATH."/class/xoopsformloader.php");
    include_once(XOOPS_ROOT_PATH."/class/xoopseditor/xoopseditor.php");

    //抓取預設值
    if(!empty($bs_student_sn))
    {
        $DBV = get_ben_score_student($bs_student_sn);
    }else{
        $DBV = array();
    }

    //預設值設定
        
    //設定 bs_student_sn 欄位的預設值
    $bs_student_sn = !isset($DBV['bs_student_sn']) ? $bs_student_sn : $DBV['bs_student_sn'];
    $xoopsTpl->assign('bs_student_sn', $bs_student_sn);    
    //設定 bs_student_cate 欄位的預設值
    $bs_student_cate = !isset($DBV['bs_student_cate']) ? "" : $DBV['bs_student_cate'];
    $xoopsTpl->assign('bs_student_cate', $bs_student_cate);    
    //設定 bs_student_sid 欄位的預設值
    $bs_student_sid = !isset($DBV['bs_student_sid']) ? "" : $DBV['bs_student_sid'];
    $xoopsTpl->assign('bs_student_sid', $bs_student_sid);    
    //設定 bs_student_id 欄位的預設值
    $bs_student_id = !isset($DBV['bs_student_id']) ? "" : $DBV['bs_student_id'];
    $xoopsTpl->assign('bs_student_id', $bs_student_id);    
    //設定 bs_student_name 欄位的預設值
    $bs_student_name = !isset($DBV['bs_student_name']) ? "" : $DBV['bs_student_name'];
    $xoopsTpl->assign('bs_student_name', $bs_student_name);    
    //設定 bs_student_gender 欄位的預設值
    $bs_student_gender = !isset($DBV['bs_student_gender']) ? "" : $DBV['bs_student_gender'];
    $xoopsTpl->assign('bs_student_gender', $bs_student_gender);    
    //設定 bs_student_birthday 欄位的預設值
    $bs_student_birthday = !isset($DBV['bs_student_birthday']) ? date("Y-m-d") : $DBV['bs_student_birthday'];
    $xoopsTpl->assign('bs_student_birthday', $bs_student_birthday);    
    //設定 bs_student_phone1 欄位的預設值
    $bs_student_phone1 = !isset($DBV['bs_student_phone1']) ? "" : $DBV['bs_student_phone1'];
    $xoopsTpl->assign('bs_student_phone1', $bs_student_phone1);    
    //設定 bs_student_guardian 欄位的預設值
    $bs_student_guardian = !isset($DBV['bs_student_guardian']) ? "" : $DBV['bs_student_guardian'];
    $xoopsTpl->assign('bs_student_guardian', $bs_student_guardian);    
    //設定 bs_student_phone2 欄位的預設值
    $bs_student_phone2 = !isset($DBV['bs_student_phone2']) ? "" : $DBV['bs_student_phone2'];
    $xoopsTpl->assign('bs_student_phone2', $bs_student_phone2);    
    //設定 bs_student_country 欄位的預設值
    $bs_student_country = !isset($DBV['bs_student_country']) ? "中華民國" : $DBV['bs_student_country'];
    $xoopsTpl->assign('bs_student_country', $bs_student_country);    
    //設定 bs_student_code 欄位的預設值
    $bs_student_code = !isset($DBV['bs_student_code']) ? "" : $DBV['bs_student_code'];
    $xoopsTpl->assign('bs_student_code', $bs_student_code);    
    //設定 bs_student_city 欄位的預設值
    $bs_student_city = !isset($DBV['bs_student_city']) ? "" : $DBV['bs_student_city'];
    $xoopsTpl->assign('bs_student_city', $bs_student_city);    
    //設定 bs_student_address 欄位的預設值
    $bs_student_address = !isset($DBV['bs_student_address']) ? "" : $DBV['bs_student_address'];
    $xoopsTpl->assign('bs_student_address', $bs_student_address);    
    //設定 bs_student_graduated_school 欄位的預設值
    $bs_student_graduated_school = !isset($DBV['bs_student_graduated_school']) ? "" : $DBV['bs_student_graduated_school'];
    $xoopsTpl->assign('bs_student_graduated_school', $bs_student_graduated_school);    
    //設定 bs_student_picture 欄位的預設值
    $bs_student_picture = !isset($DBV['bs_student_picture']) ? "" : $DBV['bs_student_picture'];
    $xoopsTpl->assign('bs_student_picture', $bs_student_picture);    
    //設定 bs_student_memo 欄位的預設值
    $bs_student_memo = !isset($DBV['bs_student_memo']) ? "" : $DBV['bs_student_memo'];
    $xoopsTpl->assign('bs_student_memo', $bs_student_memo);    
    //設定 bs_student_enable 欄位的預設值
    $bs_student_enable = !isset($DBV['bs_student_enable']) ? "" : $DBV['bs_student_enable'];
    $xoopsTpl->assign('bs_student_enable', $bs_student_enable);    
    //設定 bs_student_sort 欄位的預設值
    $bs_student_sort = !isset($DBV['bs_student_sort']) ? ben_score_student_max_sort() : $DBV['bs_student_sort'];
    $xoopsTpl->assign('bs_student_sort', $bs_student_sort);    
    //設定 bs_student_keyindate 欄位的預設值
    $bs_student_keyindate = !isset($DBV['bs_student_keyindate']) ? date("Y-m-d H:i:s") : $DBV['bs_student_keyindate'];
    $xoopsTpl->assign('bs_student_keyindate', $bs_student_keyindate);

    $op = empty($bs_student_sn) ? "insert_ben_score_student" : "update_ben_score_student";
    //$op="replace_ben_score_student";
    
    $span = $_SESSION['bootstrap'] == '3' ? 'form-control col-md-' : 'span';
    $form = new XoopsThemeForm('', 'form', $_SERVER['PHP_SELF'], 'post', true);
    $form->setExtra('enctype = "multipart/form-data"');

    //學生編號
    $form->addElement(new XoopsFormHidden("bs_student_sn", $bs_student_sn));

    //學生分類
    $bs_student_cateSelect = new XoopsFormSelect(_MA_BENSCORE_BS_STUDENT_CATE, 'bs_student_cate', '', 1, false);
    $options_array = "";
    $options_array['舞蹈班'] = '舞蹈班';
    $options_array['美術班'] = '美術班';
    $options_array['音樂班'] = '音樂班';
    $options_array['普通班'] = '普通班';
    $bs_student_cateSelect->addOptionArray($options_array);
    $bs_student_cateSelect->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_cateSelect, false);

    //學生證號
    $bs_student_sidText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_SID, "bs_student_sid", 25, 255, $bs_student_sid);
    $bs_student_sidText->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_sidText, false);

    //身份證號
    $bs_student_idText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_ID, "bs_student_id", 25, 255, $bs_student_id);
    $bs_student_idText->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_idText, true);

    //學生姓名
    $bs_student_nameText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_NAME, "bs_student_name", 50, 255, $bs_student_name);
    $bs_student_nameText->setExtra("class = '{$span}10'");
    $form->addElement($bs_student_nameText, false);

    //性別
    $bs_student_genderSelect = new XoopsFormSelect(_MA_BENSCORE_BS_STUDENT_GENDER, 'bs_student_gender', '', 1, false);
    $options_array = "";
    $options_array['男'] = '男';
    $options_array['女'] = '女';
    $bs_student_genderSelect->addOptionArray($options_array);
    $bs_student_genderSelect->setExtra("class = '{$span}1'");
    $form->addElement($bs_student_genderSelect, false);

    /*送出後，取得時間值的方法：
    $all_time = strtotime($_POST['bs_student_birthday']['date']) + $_POST['bs_student_birthday']['time'];
    $day = date("Y-m-d", $all_time); */
    $bs_student_birthday_timestamp = !empty($bs_student_birthday) ? strtotime($bs_student_birthday) : time();
    $bs_student_birthdayDateTime = new XoopsFormDateTime(_MA_BENSCORE_BS_STUDENT_BIRTHDAY, "bs_student_birthday", 25, $bs_student_birthday_timestamp);
    $bs_student_birthdayDateTime->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_birthdayDateTime, false);

    //聯絡電話1
    $bs_student_phone1Text = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_PHONE1, "bs_student_phone1", 50, 255, $bs_student_phone1);
    $bs_student_phone1Text->setExtra("class = '{$span}10'");
    $form->addElement($bs_student_phone1Text, false);

    //監護人
    $bs_student_guardianText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_GUARDIAN, "bs_student_guardian", 50, 255, $bs_student_guardian);
    $bs_student_guardianText->setExtra("class = '{$span}10'");
    $form->addElement($bs_student_guardianText, false);

    //聯絡電話2
    $bs_student_phone2Text = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_PHONE2, "bs_student_phone2", 50, 255, $bs_student_phone2);
    $bs_student_phone2Text->setExtra("class = '{$span}10'");
    $form->addElement($bs_student_phone2Text, false);

    //國籍別
    $bs_student_countryText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_COUNTRY, "bs_student_country", 25, 255, $bs_student_country);
    $bs_student_countryText->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_countryText, false);

    //地址
    $bs_student_address_Code = new XoopsFormLabel(_MA_BENSCORE_BS_STUDENT_ADDRESS, "<div class='col-md-5' id='twzipcode'></div><div class='col-md-7'><input type='text' name='bs_student_address' id='bs_student_address' class='form-control' value='$bs_student_address' placeholder='_MA_BENSCORE_BS_STUDENT_ADDRESS'></div></div>");
    $form->addElement($bs_student_address_Code, false);

    //畢業學校
    $bs_student_graduated_schoolText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_GRADUATED_SCHOOL, "bs_student_graduated_school", 25, 255, $bs_student_graduated_school);
    $bs_student_graduated_schoolText->setExtra("class = '{$span}5'");
    $form->addElement($bs_student_graduated_schoolText, false);

    //學生照片
    $form->addElement(new XoopsFormHidden("bs_student_picture", $bs_student_picture));

    //學生備註
    $bs_student_memoText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_MEMO, "bs_student_memo", 50, 255, $bs_student_memo);
    $bs_student_memoText->setExtra("class = '{$span}10'");
    $form->addElement($bs_student_memoText, false);

    //畢業否
    $bs_student_enableRadio = new XoopsFormRadio(_MA_BENSCORE_BS_STUDENT_ENABLE, 'bs_student_enable', '');
    $options_array['在學中'] = '在學中';
    $options_array['已畢業'] = '已畢業';
    $bs_student_enableRadio->addOptionArray($options_array);
    $form->addElement($bs_student_enableRadio, false);

    //學生排序
    $bs_student_sortText = new XoopsFormText(_MA_BENSCORE_BS_STUDENT_SORT, "bs_student_sort", 25, 255, $bs_student_sort);
    $bs_student_sortText->setExtra("class = '{$span}3'");
    $form->addElement($bs_student_sortText, false);

    //上傳照片
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_student_sn",$bs_student_sn);
    $up_bs_student_sn_form = $TadUpFiles->upform(false, "up_bs_student_sn", "1");
    $bs_student_sn_up = new XoopsFormLabel(_MA_BENSCORE_UP_BS_STUDENT_SN, $up_bs_student_sn_form);
    $form->addElement($bs_student_sn_up, false);
    $form->addElement(new XoopsFormHidden("op", $op));
    $form->addElement(new XoopsFormHiddenToken());

    $SubmitTray=new XoopsFormElementTray('', '', '', true);
    $SubmitTray->addElement(new XoopsFormButton('', '', _TAD_SUBMIT, 'submit'));
    $form->addElement($SubmitTray);
    $xoopsform = $form->render();
    $xoopsTpl->assign('xoopsform', $xoopsform);

    $xoopsTpl->assign('now_op', 'ben_score_student_form');
    $xoopsTpl->assign('next_op', $op);
}


//自動取得ben_score_student的最新排序
function ben_score_student_max_sort()
{
    global $xoopsDB;
    $sql = "select max(`bs_student_sort`) from `".$xoopsDB->prefix("ben_score_student")."`";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    list($sort) = $xoopsDB->fetchRow($result);
    return ++$sort;
}


//以流水號取得某筆ben_score_student資料
function get_ben_score_student($bs_student_sn = '')
{
    global $xoopsDB;

    if(empty($bs_student_sn))
    {
        return;
    }

    $sql = "select * from `".$xoopsDB->prefix("ben_score_student")."`
    where `bs_student_sn` = '{$bs_student_sn}'";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $data = $xoopsDB->fetchArray($result);
    return $data;
}

//新增資料到ben_score_student中
function insert_ben_score_student()
{
    global $xoopsDB, $xoopsUser, $isAdmin;
    if(!$isAdmin) {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error=implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_student_sn = intval($_POST['bs_student_sn']);
    $bs_student_cate = $_POST['bs_student_cate'];
    $bs_student_sid = $myts->addSlashes($_POST['bs_student_sid']);
    $bs_student_id = $myts->addSlashes($_POST['bs_student_id']);
    $bs_student_name = $myts->addSlashes($_POST['bs_student_name']);
    $bs_student_gender = $_POST['bs_student_gender'];
    $bs_student_birthday = $myts->addSlashes($_POST['bs_student_birthday']);
    $bs_student_phone1 = $myts->addSlashes($_POST['bs_student_phone1']);
    $bs_student_guardian = $myts->addSlashes($_POST['bs_student_guardian']);
    $bs_student_phone2 = $myts->addSlashes($_POST['bs_student_phone2']);
    $bs_student_country = $myts->addSlashes($_POST['bs_student_country']);
    $bs_student_code = $_POST['bs_student_code'];
    $bs_student_city = $_POST['bs_student_city'];
    $bs_student_address = $_POST['bs_student_address'];
    $bs_student_graduated_school = $myts->addSlashes($_POST['bs_student_graduated_school']);
    $bs_student_picture = $_POST['bs_student_picture'];
    $bs_student_memo = $myts->addSlashes($_POST['bs_student_memo']);
    $bs_student_enable = $_POST['bs_student_enable'];
    $bs_student_sort = intval($_POST['bs_student_sort']);
    $bs_student_keyindate = date("Y-m-d H:i:s",xoops_getUserTimestamp(time()));

    $sql = "insert into `".$xoopsDB->prefix("ben_score_student")."` (
        `bs_student_cate`, 
        `bs_student_sid`, 
        `bs_student_id`, 
        `bs_student_name`, 
        `bs_student_gender`, 
        `bs_student_birthday`, 
        `bs_student_phone1`, 
        `bs_student_guardian`, 
        `bs_student_phone2`, 
        `bs_student_country`, 
        `bs_student_code`, 
        `bs_student_city`, 
        `bs_student_address`, 
        `bs_student_graduated_school`, 
        `bs_student_picture`, 
        `bs_student_memo`, 
        `bs_student_enable`, 
        `bs_student_sort`, 
        `bs_student_keyindate`
    ) values(
        '{$bs_student_cate}', 
        '{$bs_student_sid}', 
        '{$bs_student_id}', 
        '{$bs_student_name}', 
        '{$bs_student_gender}', 
        '{$bs_student_birthday}', 
        '{$bs_student_phone1}', 
        '{$bs_student_guardian}', 
        '{$bs_student_phone2}', 
        '{$bs_student_country}', 
        '{$bs_student_code}', 
        '{$bs_student_city}', 
        '{$bs_student_address}', 
        '{$bs_student_graduated_school}', 
        '{$bs_student_picture}', 
        '{$bs_student_memo}', 
        '{$bs_student_enable}', 
        '{$bs_student_sort}', 
        '{$bs_student_keyindate}'
    )";
    $xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());

    //取得最後新增資料的流水編號
    $bs_student_sn = $xoopsDB->getInsertId();
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_student_sn", $bs_student_sn);
    $TadUpFiles->upload_file('up_bs_student_sn', '', '', '', '', false, false);
    return $bs_student_sn;
}

//更新ben_score_student某一筆資料
function update_ben_score_student($bs_student_sn = '')
{
    global $xoopsDB, $isAdmin, $xoopsUser;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }
    
    //XOOPS表單安全檢查
    if(!$GLOBALS['xoopsSecurity']->check())
    {
        $error = implode("<br />", $GLOBALS['xoopsSecurity']->getErrors());
        redirect_header($_SERVER['PHP_SELF'], 3, $error);
    }

    $myts = MyTextSanitizer::getInstance();
    
    $bs_student_sn = intval($_POST['bs_student_sn']);
    $bs_student_cate = $_POST['bs_student_cate'];
    $bs_student_sid = $myts->addSlashes($_POST['bs_student_sid']);
    $bs_student_id = $myts->addSlashes($_POST['bs_student_id']);
    $bs_student_name = $myts->addSlashes($_POST['bs_student_name']);
    $bs_student_gender = $_POST['bs_student_gender'];
    $bs_student_birthday = $myts->addSlashes($_POST['bs_student_birthday']);
    $bs_student_phone1 = $myts->addSlashes($_POST['bs_student_phone1']);
    $bs_student_guardian = $myts->addSlashes($_POST['bs_student_guardian']);
    $bs_student_phone2 = $myts->addSlashes($_POST['bs_student_phone2']);
    $bs_student_country = $myts->addSlashes($_POST['bs_student_country']);
    $bs_student_code = $_POST['bs_student_code'];
    $bs_student_city = $_POST['bs_student_city'];
    $bs_student_address = $_POST['bs_student_address'];
    $bs_student_graduated_school = $myts->addSlashes($_POST['bs_student_graduated_school']);
    $bs_student_picture = $_POST['bs_student_picture'];
    $bs_student_memo = $myts->addSlashes($_POST['bs_student_memo']);
    $bs_student_enable = $_POST['bs_student_enable'];
    $bs_student_sort = intval($_POST['bs_student_sort']);
    $bs_student_keyindate = date("Y-m-d H:i:s",xoops_getUserTimestamp(time()));

    $sql = "update `".$xoopsDB->prefix("ben_score_student")."` set 
       `bs_student_cate` = '{$bs_student_cate}', 
       `bs_student_sid` = '{$bs_student_sid}', 
       `bs_student_id` = '{$bs_student_id}', 
       `bs_student_name` = '{$bs_student_name}', 
       `bs_student_gender` = '{$bs_student_gender}', 
       `bs_student_birthday` = '{$bs_student_birthday}', 
       `bs_student_phone1` = '{$bs_student_phone1}', 
       `bs_student_guardian` = '{$bs_student_guardian}', 
       `bs_student_phone2` = '{$bs_student_phone2}', 
       `bs_student_country` = '{$bs_student_country}', 
       `bs_student_code` = '{$bs_student_code}', 
       `bs_student_city` = '{$bs_student_city}', 
       `bs_student_address` = '{$bs_student_address}', 
       `bs_student_graduated_school` = '{$bs_student_graduated_school}', 
       `bs_student_picture` = '{$bs_student_picture}', 
       `bs_student_memo` = '{$bs_student_memo}', 
       `bs_student_enable` = '{$bs_student_enable}', 
       `bs_student_sort` = '{$bs_student_sort}', 
       `bs_student_keyindate` = '{$bs_student_keyindate}'
    where `bs_student_sn` = '$bs_student_sn'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_student_sn", $bs_student_sn);
    $TadUpFiles->upload_file('up_bs_student_sn', '', '', '', '', false, false);
    return $bs_student_sn;
}

//刪除ben_score_student某筆資料資料
function delete_ben_score_student($bs_student_sn = '')
{
    global $xoopsDB, $isAdmin;
    if(!$isAdmin)
    {
        redirect_header($_SERVER['PHP_SELF'], 3, _TAD_PERMISSION_DENIED);
    }

    if(empty($bs_student_sn))
    {
        return;
    }

    $sql = "delete from `".$xoopsDB->prefix("ben_score_student")."`
    where `bs_student_sn` = '{$bs_student_sn}'";
    $xoopsDB->queryF($sql) or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_student_sn", $bs_student_sn);
    $TadUpFiles->del_files();
}

//以流水號秀出某筆ben_score_student資料內容
function show_one_ben_score_student($bs_student_sn = '')
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    if(empty($bs_student_sn))
    {
        return;
    } else {
        $bs_student_sn = intval($bs_student_sn);
    }

    $myts = MyTextSanitizer::getInstance();

    $sql = "select * from `".$xoopsDB->prefix("ben_score_student")."`
    where `bs_student_sn` = '{$bs_student_sn}' ";
    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    $all = $xoopsDB->fetchArray($result);

    //以下會產生這些變數： $bs_student_sn, $bs_student_cate, $bs_student_sid, $bs_student_id, $bs_student_name, $bs_student_gender, $bs_student_birthday, $bs_student_phone1, $bs_student_guardian, $bs_student_phone2, $bs_student_country, $bs_student_code, $bs_student_city, $bs_student_address, $bs_student_graduated_school, $bs_student_picture, $bs_student_memo, $bs_student_enable, $bs_student_sort, $bs_student_keyindate
    foreach($all as $k => $v)
    {
        $$k = $v;
    }

    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles=new TadUpFiles("ben_score");
    $TadUpFiles->set_col("bs_student_sn",$bs_student_sn);
    $show_bs_student_sn_files=$TadUpFiles->show_files('up_bs_student_sn', true, 'thumb',true,false,NULL,NULL,false);
    $xoopsTpl->assign('show_bs_student_sn_files',$show_bs_student_sn_files);

    //過濾讀出的變數值
    $bs_student_sid = $myts->htmlSpecialChars($bs_student_sid);
    $bs_student_id = $myts->htmlSpecialChars($bs_student_id);
    $bs_student_name = $myts->htmlSpecialChars($bs_student_name);
    $bs_student_birthday = $myts->htmlSpecialChars($bs_student_birthday);
    $bs_student_phone1 = $myts->htmlSpecialChars($bs_student_phone1);
    $bs_student_guardian = $myts->htmlSpecialChars($bs_student_guardian);
    $bs_student_phone2 = $myts->htmlSpecialChars($bs_student_phone2);
    $bs_student_country = $myts->htmlSpecialChars($bs_student_country);
    $bs_student_graduated_school = $myts->htmlSpecialChars($bs_student_graduated_school);
    $bs_student_memo = $myts->htmlSpecialChars($bs_student_memo);

    $xoopsTpl->assign('bs_student_sn', $bs_student_sn);
    $xoopsTpl->assign('bs_student_cate', $bs_student_cate);
    $xoopsTpl->assign('bs_student_sid', $bs_student_sid);
    $xoopsTpl->assign('bs_student_id', $bs_student_id);
    $xoopsTpl->assign('bs_student_name', $bs_student_name);
    $xoopsTpl->assign('bs_student_gender', $bs_student_gender);
    $xoopsTpl->assign('bs_student_birthday', $bs_student_birthday);
    $xoopsTpl->assign('bs_student_phone1', $bs_student_phone1);
    $xoopsTpl->assign('bs_student_guardian', $bs_student_guardian);
    $xoopsTpl->assign('bs_student_phone2', $bs_student_phone2);
    $xoopsTpl->assign('bs_student_country', $bs_student_country);
    $xoopsTpl->assign('bs_student_code', $bs_student_code);
    $xoopsTpl->assign('bs_student_city', $bs_student_city);
    $xoopsTpl->assign('bs_student_address', $bs_student_address);
    $xoopsTpl->assign('bs_student_graduated_school', $bs_student_graduated_school);
    $xoopsTpl->assign('bs_student_picture', $bs_student_picture);
    $xoopsTpl->assign('bs_student_memo', $bs_student_memo);
    $xoopsTpl->assign('bs_student_enable', $bs_student_enable);
    $xoopsTpl->assign('bs_student_sort', $bs_student_sort);
    $xoopsTpl->assign('bs_student_keyindate', $bs_student_keyindate);

    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }

    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_student_func = $sweet_alert_obj->render('delete_ben_score_student_func', "{$_SERVER['PHP_SELF']}?op=delete_ben_score_student&bs_student_sn=", "bs_student_sn");
    $xoopsTpl->assign('delete_ben_score_student_func', $delete_ben_score_student_func);

    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('now_op', 'show_one_ben_score_student');
}



//列出所有ben_score_student資料
function list_ben_score_student()
{
    global $xoopsDB, $xoopsTpl, $isAdmin;

    $myts = MyTextSanitizer::getInstance();
    
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php" ;
    $TadUpFiles = new TadUpFiles("ben_score");
    $sql = "select * from `".$xoopsDB->prefix("ben_score_student")."` order by `bs_student_sort`";

    //getPageBar($原sql語法, 每頁顯示幾筆資料, 最多顯示幾個頁數選項);
    $PageBar = getPageBar($sql, 20, 10, null, null, $bootstrap);
    $bar     = $PageBar['bar'];
    $sql     = $PageBar['sql'];
    $total   = $PageBar['total'];

    $result = $xoopsDB->query($sql)
    or redirect_header($_SERVER['PHP_SELF'], 3, mysql_error());
    
    $all_content = '';
    $i = 0;
    while($all = $xoopsDB->fetchArray($result))
    {
        //以下會產生這些變數： $bs_student_sn, $bs_student_cate, $bs_student_sid, $bs_student_id, $bs_student_name, $bs_student_gender, $bs_student_birthday, $bs_student_phone1, $bs_student_guardian, $bs_student_phone2, $bs_student_country, $bs_student_code, $bs_student_city, $bs_student_address, $bs_student_graduated_school, $bs_student_picture, $bs_student_memo, $bs_student_enable, $bs_student_sort, $bs_student_keyindate
        foreach($all as $k=>$v){
            $$k=$v;
        }
        
        //過濾讀出的變數值
        $bs_student_sid = $myts->htmlSpecialChars($bs_student_sid);
        $bs_student_id = $myts->htmlSpecialChars($bs_student_id);
        $bs_student_name = $myts->htmlSpecialChars($bs_student_name);
        $bs_student_birthday = $myts->htmlSpecialChars($bs_student_birthday);
        $bs_student_phone1 = $myts->htmlSpecialChars($bs_student_phone1);
        $bs_student_guardian = $myts->htmlSpecialChars($bs_student_guardian);
        $bs_student_phone2 = $myts->htmlSpecialChars($bs_student_phone2);
        $bs_student_country = $myts->htmlSpecialChars($bs_student_country);
        $bs_student_graduated_school = $myts->htmlSpecialChars($bs_student_graduated_school);
        $bs_student_memo = $myts->htmlSpecialChars($bs_student_memo);

        $all_content[$i]['bs_student_sn'] = $bs_student_sn;
        $all_content[$i]['bs_student_cate'] = $bs_student_cate;
        $all_content[$i]['bs_student_sid'] = $bs_student_sid;
        $all_content[$i]['bs_student_id'] = $bs_student_id;
        $all_content[$i]['bs_student_name'] = $bs_student_name;
        $all_content[$i]['bs_student_gender'] = $bs_student_gender;
        $all_content[$i]['bs_student_birthday'] = $bs_student_birthday;
        $all_content[$i]['bs_student_phone1'] = $bs_student_phone1;
        $all_content[$i]['bs_student_guardian'] = $bs_student_guardian;
        $all_content[$i]['bs_student_phone2'] = $bs_student_phone2;
        $all_content[$i]['bs_student_country'] = $bs_student_country;
        $all_content[$i]['bs_student_code'] = $bs_student_code;
        $all_content[$i]['bs_student_city'] = $bs_student_city;
        $all_content[$i]['bs_student_address'] = $bs_student_address;
        $all_content[$i]['bs_student_graduated_school'] = $bs_student_graduated_school;
        $all_content[$i]['bs_student_picture'] = $bs_student_picture;
        $all_content[$i]['bs_student_memo'] = $bs_student_memo;
        $all_content[$i]['bs_student_enable'] = $bs_student_enable;
        $all_content[$i]['bs_student_sort'] = $bs_student_sort;
        $all_content[$i]['bs_student_keyindate'] = $bs_student_keyindate;
        $TadUpFiles->set_col("bs_student_sn", $bs_student_sn);
        $show_files=$TadUpFiles->show_files('up_bs_student_sn', true, 'small', false, false, NULL, NULL, false);
        $all_content[$i]['list_file'] = $show_files;
        $i++;
    }

    //刪除確認的JS
    if(!file_exists(XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php"))
    {
        redirect_header("index.php", 3, _MA_NEED_TADTOOLS);
    }
    include_once XOOPS_ROOT_PATH."/modules/tadtools/sweet_alert.php";
    $sweet_alert_obj   = new sweet_alert();
    $delete_ben_score_student_func = $sweet_alert_obj->render('delete_ben_score_student_func',
    "{$_SERVER['PHP_SELF']}?op=delete_ben_score_student&bs_student_sn=", "bs_student_sn");
    $xoopsTpl->assign('delete_ben_score_student_func', $delete_ben_score_student_func);
    
  $xoopsTpl->assign('ben_score_student_jquery_ui', get_jquery(true));
    $xoopsTpl->assign('bar', $bar);
    $xoopsTpl->assign('action', $_SERVER['PHP_SELF']);
    $xoopsTpl->assign('isAdmin', $isAdmin);
    $xoopsTpl->assign('all_content', $all_content);
    $xoopsTpl->assign('now_op', 'list_ben_score_student');
}


//更新排序
function update_ben_score_student_sort(){
  global $xoopsDB;
  $sort = 1;
  foreach ($_POST['tr'] as $bs_student_sn) {
      $sql="update ".$xoopsDB->prefix("ben_score_student")." set `bs_student_sort`='{$sort}' where `bs_student_sn`='{$bs_student_sn}'";
      $xoopsDB->queryF($sql) or die(_TAD_SORT_FAIL." (".date("Y-m-d H:i:s").")");
      $sort++;
  }
  return _TAD_SORTED." (".date("Y-m-d H:i:s").")";
}


/*-----------執行動作判斷區----------*/
include_once $GLOBALS['xoops']->path( '/modules/system/include/functions.php' );
$op = system_CleanVars($_REQUEST, 'op', '', 'string');
$bs_student_sn = system_CleanVars($_REQUEST, 'bs_student_sn', '', 'int');
$bs_teacher_sn = system_CleanVars($_REQUEST, 'bs_teacher_sn', '', 'int');
$bs_course_sn = system_CleanVars($_REQUEST, 'bs_course_sn', '', 'int');
$bs_select_course_sn = system_CleanVars($_REQUEST, 'bs_select_course_sn', '', 'int');
$bs_comment_sn = system_CleanVars($_REQUEST, 'bs_comment_sn', '', 'int');
$CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM; = system_CleanVars($_REQUEST, 'CREATETABLEben_score_files_centerfiles_snsmallint5unsignedNOTNULLAUTO_INCREMENTCOMMENT'檔案流水號'col_namevarchar255NOTNULLdefault''COMMENT'欄位名稱'col_snsmallint5unsignedNOTNULLdefault0COMMENT'欄位編號'sortsmallint5unsignedNOTNULLdefault0COMMENT'排序'kindenum'img''file'NOTNULLdefault'img'COMMENT'檔案種類'file_namevarchar255NOTNULLdefault''COMMENT'檔案名稱'file_typevarchar255NOTNULLdefault''COMMENT'檔案類型'file_sizeint10unsignedNOTNULLdefault0COMMENT'檔案大小'descriptiontextNOTNULLCOMMENT'檔案說明'countermediumint8unsignedNOTNULLdefault0COMMENT'下載人次'original_filenamevarchar255NOTNULLdefault''COMMENT'檔案名稱'hash_filenamevarchar255NOTNULLdefault''COMMENT'加密檔案名稱'sub_dirvarchar255NOTNULLdefault''COMMENT'檔案子路徑'files_snENGINE=MyISAM;', '', 'int');


switch($op){
  /*---判斷動作請貼在下方---*/

  
    //替換資料
    //case "replace_ben_score_student":
    //    replace_ben_score_student();
    //    header("location: {$_SERVER['PHP_SELF']}?bs_student_sn=$bs_student_sn");
    //    exit;
    //break;

    //新增資料
    case "insert_ben_score_student":
        $bs_student_sn = insert_ben_score_student();
        header("location: {$_SERVER['PHP_SELF']}?bs_student_sn=$bs_student_sn");
        exit;
    break;

    //更新資料
    case "update_ben_score_student":
        update_ben_score_student($bs_student_sn);
        header("location: {$_SERVER['PHP_SELF']}?bs_student_sn=$bs_student_sn");
        exit;
    break;

    
    case "ben_score_student_form":
        ben_score_student_form($bs_student_sn);
    break;

    
    case "delete_ben_score_student":
        delete_ben_score_student($bs_student_sn);
        header("location: {$_SERVER['PHP_SELF']}");
        exit;
    break;
    
    //下載檔案
    case "tufdl":
    include_once XOOPS_ROOT_PATH."/modules/tadtools/TadUpFiles.php";
    $TadUpFiles=new TadUpFiles("ben_score");
    $TadUpFiles->add_file_counter($files_sn, false);
    exit;
    break;
    
  //更新排序
  case "update_ben_score_student_sort":
  $msg = update_ben_score_student_sort();
  die($msg);
  break;

    
    default:
        if(empty($bs_student_sn)) {
            list_ben_score_student();
            //$main .= ben_score_student_form($bs_student_sn);
        }else{
            show_one_ben_score_student($bs_student_sn);
        }
    break;


  /*---判斷動作請貼在上方---*/
}

/*-----------秀出結果區--------------*/
$xoopsTpl->assign("isAdmin" , true);
$xoTheme->addStylesheet(XOOPS_URL.'/modules/tadtools/css/xoops_adm.css');
include_once 'footer.php';