CREATE TABLE `ben_score_student` (
  `bs_student_sn` smallint(5) unsigned NOT NULL auto_increment COMMENT '學生編號',
  `bs_student_sid` varchar(15) NOT NULL default '' COMMENT '學生證號',
  `bs_student_id` varchar(15) NOT NULL default '' COMMENT '身份證號',
  `bs_student_cate` enum('舞蹈班','美術班','音樂班','普通班' ) NOT NULL COMMENT '學生分類',
  `bs_student_name` varchar(25) NOT NULL default '' COMMENT '學生姓名',
  `bs_student_gender` enum('男','女') NOT NULL COMMENT '性別',
  `bs_student_birthday` date NOT NULL default '0000-00-00' COMMENT '生日',
  `bs_student_phone1` varchar(50) NOT NULL default '' COMMENT '聯絡電話1',
  `bs_student_guardian` varchar(25) NOT NULL default '' COMMENT '監護人',
  `bs_student_phone2` varchar(50) NOT NULL default '' COMMENT '聯絡電話2',
  `bs_student_country` varchar(100) NOT NULL default '' COMMENT '國籍別',
  `bs_student_code` varchar(10) NOT NULL default '' COMMENT '郵遞區號',
  `bs_student_city` varchar(50) NOT NULL default '' COMMENT '居住縣市',
  `bs_student_address` varchar(255) NOT NULL default '' COMMENT '居住地址',
  `bs_student_graduated_school` varchar(255) NOT NULL default '' COMMENT '畢業學校',
  `bs_student_picture` varchar(255) NOT NULL default '' COMMENT '學生照片',
  `bs_student_enable` enum('1','0') NOT NULL COMMENT '畢業否',
  `bs_student_sort` smallint(5) unsigned NOT NULL default '0' COMMENT '學生排序',
  `bs_student_memo` varchar(255) NOT NULL default '' COMMENT '學生備註',
  `bs_student_keyindate` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '建檔日期',
PRIMARY KEY  (`bs_student_sn`)
) ENGINE=MyISAM;

CREATE TABLE `ben_score_teacher` (
  `bs_teacher_sn` smallint(5) unsigned NOT NULL auto_increment COMMENT '教師編號',
  `bs_teacher_id` varchar(15) NOT NULL default '' COMMENT '身份證號',
  `bs_teacher_name` varchar(25) NOT NULL default '' COMMENT '教師姓名',
  `bs_teacher_cate` enum('專任','代理','兼任','基金會聘任') NOT NULL COMMENT '教師分類',
  `bs_teacher_genser` enum('男','女') NOT NULL COMMENT '教師性別',
  `bs_teacher_phone` varchar(50) NOT NULL default '' COMMENT '聯絡電話',
  `bs_teacher_country` varchar(100) NOT NULL default '' COMMENT '國籍別',
  `bs_teacher_code` varchar(10) NOT NULL default '' COMMENT '郵遞區號',
  `bs_teacher_city` varchar(50) NOT NULL default '' COMMENT '居住縣市',
  `bs_teacher_address` varchar(255) NOT NULL default '' COMMENT '居住地址',
  `bs_teacher_dept` enum('教務處','學務處','總務處','輔導室','舞蹈科','美術科','音樂科','普通班') NOT NULL COMMENT '所屬處室',
  `bs_teacher_hiredate` date NOT NULL default '0000-00-00' COMMENT '起聘日期',
  `bs_teacher_picture` varchar(255) NOT NULL default '' COMMENT '教師照片',
  `bs_teacher_enable` enum('1','0') NOT NULL default '1' COMMENT '聘任否',
  `bs_teacher_memo` varchar(255) NOT NULL default '' COMMENT '教師備註',
  `bs_teacher_keyindate` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '建檔日期',
PRIMARY KEY  (`bs_teacher_sn`)
) ENGINE=MyISAM;

CREATE TABLE `ben_score_course` (
  `bs_course_sn` smallint(5) unsigned NOT NULL auto_increment COMMENT '課程編號',
  `bs_course_cate` enum('學科','術科') NOT NULL COMMENT '課程分類',
  `bs_course_title` varchar(50) NOT NULL default '' COMMENT '課程名稱',
  `bs_course_credit` smallint(6) unsigned NOT NULL default '0' COMMENT '學分數',
  `bs_course_school_year_semester` varchar(5) NOT NULL default '' COMMENT '開課學年期',
  `bs_course_class` varchar(5) NOT NULL default '' COMMENT '開課班級',
  `bs_teacher_sn` smallint(5) unsigned NOT NULL default '0' COMMENT '教師編號',
  `bs_course_memo` varchar(255) NOT NULL default '' COMMENT '課程備註',
  `bs_course_enable` enum('1','0') NOT NULL default '1' COMMENT '開課否',
  `bs_course_sort` smallint(5) unsigned NOT NULL default '0' COMMENT '課程排序',
PRIMARY KEY  (`bs_course_sn`)
) ENGINE=MyISAM;

CREATE TABLE `ben_score_select_course` (
  `bs_select_course_sn` smallint(5) unsigned NOT NULL auto_increment COMMENT '選課編號',
  `bs_student_sn` smallint(5) unsigned NOT NULL default '0' COMMENT '學生編號',
  `bs_course_sn` smallint(5) unsigned NOT NULL default '0' COMMENT '課程編號',
  `bs_usual_score1` smallint(5) unsigned NOT NULL default '0' COMMENT '平常成績1',
  `bs_usual_score2` smallint(5) unsigned NOT NULL default '0' COMMENT '平常成績2',
  `bs_usual_score3` smallint(5) unsigned NOT NULL default '0' COMMENT '平常成績3',
  `bs_regular_score1` smallint(5) unsigned NOT NULL default '0' COMMENT '定期評量1',
  `bs_regular_score2` smallint(5) unsigned NOT NULL default '0' COMMENT '定期評量2',
  `bs_regular_score3` smallint(5) unsigned NOT NULL default '0' COMMENT '定期評量3',
  `bs_semester_score` smallint(5) unsigned NOT NULL default '0' COMMENT '學期成績',
  `bs_comment` varchar(255) NOT NULL default '' COMMENT '教師評語',
  `bs_select_course_memo` varchar(255) NOT NULL default '' COMMENT '選課備註',
  `bs_select_course_enable` enum('1','0') NOT NULL default '1' COMMENT '選課否',
  `bs_select_course_keyindate` datetime NOT NULL default '0000-00-00 00:00:00' COMMENT '建檔日期',
PRIMARY KEY  (`bs_select_course_sn`)
) ENGINE=MyISAM;

CREATE TABLE `ben_score_comment` (
  `bs_comment_sn` smallint(5) unsigned NOT NULL auto_increment COMMENT '評語編號',
  `bs_comment_id` varchar(10) NOT NULL default '' COMMENT '評語代碼',
  `bs_comment_desc` varchar(255) NOT NULL default '' COMMENT '評語說明',
PRIMARY KEY  (`bs_comment_sn`)
) ENGINE=MyISAM;

CREATE TABLE `ben_score_files_center` (  `files_sn` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '檔案流水號',  `col_name` varchar(255) NOT NULL default '' COMMENT '欄位名稱',  `col_sn` smallint(5) unsigned NOT NULL default 0 COMMENT '欄位編號',  `sort` smallint(5) unsigned NOT NULL default 0 COMMENT '排序',  `kind` enum('img','file') NOT NULL default 'img' COMMENT '檔案種類',  `file_name` varchar(255) NOT NULL default '' COMMENT '檔案名稱',  `file_type` varchar(255) NOT NULL default '' COMMENT '檔案類型',  `file_size` int(10) unsigned NOT NULL default 0 COMMENT '檔案大小',  `description` text NOT NULL COMMENT '檔案說明',  `counter` mediumint(8) unsigned NOT NULL default 0 COMMENT '下載人次',  `original_filename` varchar(255) NOT NULL default '' COMMENT '檔案名稱',  `hash_filename` varchar(255) NOT NULL default '' COMMENT '加密檔案名稱',  `sub_dir` varchar(255) NOT NULL default '' COMMENT '檔案子路徑',  PRIMARY KEY (`files_sn`)) ENGINE=MyISAM;

